/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import ctreeaceexplorer.AppProperties;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.sql.SqlConnection;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class OptionsDialog
extends JDialog {
    private AppProperties appProps;
    private boolean mode;
    static String fileName;
    static String directoryName;
    private JCheckBox allowMultiple;
    private JCheckBox askForPlanCB;
    private JRadioButton autoCommitRB;
    private JCheckBox autoConnect;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton cancelButton;
    private JPanel connectionPanel;
    private JTextField fileNameTB;
    private JPanel isamCallbackPanel;
    private JComboBox isoLevelCB;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTabbedPane jTabbedPane1;
    private JPanel localePanel;
    private JRadioButton manualCommitRB;
    private JLabel manualLabel;
    private JSpinner maxCharsSP;
    private JButton okButton;
    private JCheckBox rememberPwd;
    private JPanel sqlExePlanPanel;
    private JPanel sqlTransactionPanel;
    private JRadioButton useEnglishLocaleRB;
    private JRadioButton useMachineLocaleRB;

    public OptionsDialog(Frame frame, boolean bl) {
        super(frame, true);
        this.mode = bl;
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.connectionPanel = new JPanel();
        this.allowMultiple = new JCheckBox();
        this.autoConnect = new JCheckBox();
        this.rememberPwd = new JCheckBox();
        this.isamCallbackPanel = new JPanel();
        this.fileNameTB = new JTextField();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.sqlTransactionPanel = new JPanel();
        this.autoCommitRB = new JRadioButton();
        this.manualCommitRB = new JRadioButton();
        this.manualLabel = new JLabel();
        this.isoLevelCB = new JComboBox();
        this.sqlExePlanPanel = new JPanel();
        this.askForPlanCB = new JCheckBox();
        this.localePanel = new JPanel();
        this.useEnglishLocaleRB = new JRadioButton();
        this.useMachineLocaleRB = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.maxCharsSP = new JSpinner();
        this.setDefaultCloseOperation(2);
        this.setTitle("Options");
        this.setResizable(false);
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setRequestFocusEnabled(false);
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(125, Short.MAX_VALUE).addComponent(this.okButton, -2, 75, -2).addGap(60, 60, 60).addComponent(this.cancelButton).addGap(147, 147, 147)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addGap(14, 14, 14)));
        this.jTabbedPane1.setName("jTabbedPane1");
        this.connectionPanel.setName("connectionPanel");
        this.allowMultiple.setText("Allow Multiple Connections");
        this.allowMultiple.setHorizontalAlignment(11);
        this.allowMultiple.setName("allowMultiple");
        this.autoConnect.setText("AutoConnect");
        this.autoConnect.setName("autoConnect");
        this.rememberPwd.setText("Remember Password");
        this.rememberPwd.setName("rememberPwd");
        GroupLayout groupLayout2 = new GroupLayout(this.connectionPanel);
        this.connectionPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(21, 21, 21).addComponent(this.allowMultiple).addGap(18, 18, 18).addComponent(this.autoConnect).addGap(18, 18, 18).addComponent(this.rememberPwd).addContainerGap(45, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(25, 25, 25).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.allowMultiple).addComponent(this.autoConnect).addComponent(this.rememberPwd)).addContainerGap(28, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Connection", this.connectionPanel);
        this.isamCallbackPanel.setName("isamCallbackPanel");
        this.fileNameTB.setName("fileNameTB");
        this.jLabel1.setText("Library Name :");
        this.jLabel1.setName("jLabel1");
        this.jButton1.setText("...");
        this.jButton1.setName("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog.this.jButton1ActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout3 = new GroupLayout(this.isamCallbackPanel);
        this.isamCallbackPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileNameTB, -2, 341, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton1, -2, 25, -2).addGap(30, 30, 30)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGap(27, 27, 27).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileNameTB, -2, -1, -2).addComponent(this.jButton1).addComponent(this.jLabel1)).addContainerGap(26, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Callback Library", this.isamCallbackPanel);
        this.sqlTransactionPanel.setName("sqlTransactionPanel");
        this.buttonGroup1.add(this.autoCommitRB);
        this.autoCommitRB.setSelected(true);
        this.autoCommitRB.setText("Auto");
        this.autoCommitRB.setName("autoCommitRB");
        this.autoCommitRB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                OptionsDialog.this.autoCommitRBStateChanged(changeEvent);
            }
        });
        this.buttonGroup1.add(this.manualCommitRB);
        this.manualCommitRB.setText("Manual");
        this.manualCommitRB.setName("manualCommitRB");
        this.manualLabel.setText(" - Isolation Level :");
        this.manualLabel.setName("manualLabel");
        this.isoLevelCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Read Uncommitted", "Read Committed", "Repeatable Read", "Serializable"}));
        this.isoLevelCB.setName("isoLevelCB");
        GroupLayout groupLayout4 = new GroupLayout(this.sqlTransactionPanel);
        this.sqlTransactionPanel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGap(19, 19, 19).addComponent(this.autoCommitRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 34, Short.MAX_VALUE).addComponent(this.manualCommitRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.manualLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.isoLevelCB, -2, 136, -2).addGap(68, 68, 68)));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGap(23, 23, 23).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoCommitRB).addComponent(this.manualCommitRB).addComponent(this.manualLabel).addComponent(this.isoLevelCB, -2, -1, -2)).addContainerGap(30, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Transaction Control", this.sqlTransactionPanel);
        this.sqlExePlanPanel.setName("sqlExePlanPanel");
        this.askForPlanCB.setText("Ask for Table and Statement ID before Explaining");
        this.askForPlanCB.setName("askForPlanCB");
        GroupLayout groupLayout5 = new GroupLayout(this.sqlExePlanPanel);
        this.sqlExePlanPanel.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addGap(111, 111, 111).addComponent(this.askForPlanCB).addContainerGap(93, Short.MAX_VALUE)));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addGap(25, 25, 25).addComponent(this.askForPlanCB).addContainerGap(28, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Execution Plan", this.sqlExePlanPanel);
        this.localePanel.setName("localePanel");
        this.buttonGroup2.add(this.useEnglishLocaleRB);
        this.useEnglishLocaleRB.setText("Use \"English\" Locale");
        this.useEnglishLocaleRB.setName("useEnglishLocaleRB");
        this.useEnglishLocaleRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog.this.useEnglishLocaleRBActionPerformed(actionEvent);
            }
        });
        this.buttonGroup2.add(this.useMachineLocaleRB);
        this.useMachineLocaleRB.setSelected(true);
        this.useMachineLocaleRB.setText("Use Machine Locale");
        this.useMachineLocaleRB.setName("useMachineLocaleRB");
        this.jLabel2.setText("When viewing table records :");
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setForeground(Color.red);
        this.jLabel3.setText("For this option to have effect the tool must be restarted.");
        this.jLabel3.setName("jLabel3");
        GroupLayout groupLayout6 = new GroupLayout(this.localePanel);
        this.localePanel.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addGap(140, 140, 140).addComponent(this.jLabel2)).addGroup(groupLayout6.createSequentialGroup().addGap(52, 52, 52).addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabel3)).addGroup(groupLayout6.createSequentialGroup().addComponent(this.useEnglishLocaleRB).addGap(82, 82, 82).addComponent(this.useMachineLocaleRB))))).addContainerGap(93, Short.MAX_VALUE)));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useMachineLocaleRB).addComponent(this.useEnglishLocaleRB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Records View", this.localePanel);
        this.jPanel2.setName("jPanel2");
        this.jLabel4.setText("Max. Chars in Columns :");
        this.jLabel4.setName("jLabel4");
        this.maxCharsSP.setModel(new SpinnerNumberModel(256, 1, 30000, 1000));
        this.maxCharsSP.setName("maxCharsSP");
        GroupLayout groupLayout7 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout7);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.maxCharsSP, -2, 71, -2).addContainerGap(249, Short.MAX_VALUE)));
        groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addGap(30, 30, 30).addGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.maxCharsSP, -2, -1, -2)).addContainerGap(26, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Others", this.jPanel2);
        GroupLayout groupLayout8 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout8);
        groupLayout8.setHorizontalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane1, -1, 472, Short.MAX_VALUE));
        groupLayout8.setVerticalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout8.createSequentialGroup().addComponent(this.jTabbedPane1, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 48, -2)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        if (this.mode) {
            Globals.sqlMultipleConnections = this.appProps.sqlAllowMultiple = this.allowMultiple.isSelected();
            this.appProps.sqlAutoConnect = this.autoConnect.isSelected();
            this.appProps.sqlRememberPassword = this.rememberPwd.isSelected();
            this.appProps.sqlAskForPlan = this.askForPlanCB.isSelected();
            if (this.appProps.sqlAutoCommit != this.autoCommitRB.isSelected()) {
                this.appProps.sqlAutoCommit = this.autoCommitRB.isSelected();
                if (this.autoCommitRB.isSelected()) {
                    for (SqlConnection sqlConnection : Globals.sqlConnections) {
                        sqlConnection.commit();
                        sqlConnection.setAutoCommit(true);
                    }
                } else {
                    for (SqlConnection sqlConnection : Globals.sqlConnections) {
                        sqlConnection.commit();
                        sqlConnection.setAutoCommit(false);
                        sqlConnection.setTransactionIsolation(this.appProps.sqlIsolationLevel);
                    }
                }
            }
            switch (this.isoLevelCB.getSelectedIndex()) {
                case 0: {
                    this.appProps.sqlIsolationLevel = 1;
                    break;
                }
                case 1: {
                    this.appProps.sqlIsolationLevel = 2;
                    break;
                }
                case 2: {
                    this.appProps.sqlIsolationLevel = 4;
                    break;
                }
                case 3: {
                    this.appProps.sqlIsolationLevel = 8;
                }
            }
        } else {
            this.appProps.isamAllowMultiple = true;
            Globals.isamMultipleConnections = true;
            this.appProps.isamAutoConnect = this.autoConnect.isSelected();
            this.appProps.isamRememberPassword = this.rememberPwd.isSelected();
        }
        Globals.appProps.callBackLib = this.fileNameTB.getText();
        Globals.appProps.useMachineLocale = this.useMachineLocaleRB.isSelected();
        Globals.appProps.maxCharsInColumns = (Integer)this.maxCharsSP.getValue();
        this.appProps.saveProperties();
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Library files", "dll", "so", "dylib", "shlib");
        jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
        if (fileName == null) {
            fileName = Globals.execDir;
        }
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setCurrentDirectory(new File(fileName));
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            fileName = file.getAbsolutePath();
            this.fileNameTB.setText(fileName);
            Globals.appProps.callBackLib = fileName;
        }
    }

    private void autoCommitRBStateChanged(ChangeEvent changeEvent) {
        this.isoLevelCB.setEnabled(!this.autoCommitRB.isSelected());
        this.manualLabel.setEnabled(!this.autoCommitRB.isSelected());
    }

    private void useEnglishLocaleRBActionPerformed(ActionEvent actionEvent) {
        Globals.appProps.useMachineLocale = !this.useEnglishLocaleRB.isSelected();
    }

    public void showDialog(AppProperties appProperties) {
        this.appProps = appProperties;
        this.getRootPane().setDefaultButton(this.okButton);
        this.rememberPwd.setVisible(false);
        if (this.mode) {
            this.jTabbedPane1.remove(this.isamCallbackPanel);
            this.allowMultiple.setEnabled(true);
            this.allowMultiple.setSelected(appProperties.sqlAllowMultiple);
            this.autoConnect.setSelected(appProperties.sqlAutoConnect);
            this.rememberPwd.setSelected(appProperties.sqlRememberPassword);
            this.askForPlanCB.setSelected(appProperties.sqlAskForPlan);
            if (appProperties.sqlAutoCommit) {
                this.autoCommitRB.setSelected(this.mode);
                this.isoLevelCB.setEnabled(false);
                this.manualLabel.setEnabled(false);
            } else {
                this.manualCommitRB.setSelected(true);
                switch (appProperties.sqlIsolationLevel) {
                    case 1: {
                        this.isoLevelCB.setSelectedIndex(0);
                        break;
                    }
                    case 2: {
                        this.isoLevelCB.setSelectedIndex(1);
                        break;
                    }
                    case 4: {
                        this.isoLevelCB.setSelectedIndex(2);
                        break;
                    }
                    case 8: {
                        this.isoLevelCB.setSelectedIndex(3);
                    }
                }
            }
        } else {
            this.jTabbedPane1.remove(this.sqlTransactionPanel);
            this.jTabbedPane1.remove(this.sqlExePlanPanel);
            if (!Globals.appProps.callBackLib.isEmpty()) {
                this.fileNameTB.setText(Globals.appProps.callBackLib);
                fileName = Globals.appProps.callBackLib;
            }
            this.allowMultiple.setEnabled(false);
            this.allowMultiple.setSelected(false);
            this.autoConnect.setSelected(appProperties.isamAutoConnect);
            this.rememberPwd.setSelected(appProperties.isamRememberPassword);
        }
        this.useMachineLocaleRB.setSelected(Globals.appProps.useMachineLocale);
        this.useEnglishLocaleRB.setSelected(!Globals.appProps.useMachineLocale);
        this.maxCharsSP.setValue(Globals.appProps.maxCharsInColumns);
        this.connectionPanel.requestFocusInWindow();
        this.setVisible(true);
    }
}

