/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTRecord;
import FairCom.CtreeDb.CTSession;
import FairCom.CtreeDb.CTTable;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.ISAM_MODE;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;

public class RebuildDialog
extends JDialog {
    String tableName;
    ISAM_MODE mode;
    private ButtonGroup buttonGroup1;
    private JRadioButton compactRB;
    private JButton exitBT;
    private JCheckBox ifilCB;
    private static JLabel jLabel1;
    private static JProgressBar jPBar;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton normalRB;
    private JCheckBox purgeCB;
    private JButton startBT;

    public RebuildDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    public void showDialog(ISAM_MODE iSAM_MODE, String string) {
        Globals.currentIsamConnection.getSession().SetCallbackOnRebuild((Object)this, "callback", 1);
        Globals.currentIsamConnection.getSession().SetCallbackOnRebuild((Object)this, null, 1);
        this.mode = iSAM_MODE;
        this.tableName = string;
        this.getRootPane().setDefaultButton(this.startBT);
        this.setVisible(true);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.normalRB = new JRadioButton();
        this.compactRB = new JRadioButton();
        this.purgeCB = new JCheckBox();
        this.ifilCB = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.startBT = new JButton();
        this.exitBT = new JButton();
        jLabel1 = new JLabel();
        jPBar = new JProgressBar();
        this.setDefaultCloseOperation(0);
        this.setTitle("Rebuild / Compact Table");
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Rebuild Mode"));
        this.jPanel1.setName("jPanel1");
        this.buttonGroup1.add(this.normalRB);
        this.normalRB.setSelected(true);
        this.normalRB.setText("Normal");
        this.normalRB.setName("normalRB");
        this.buttonGroup1.add(this.compactRB);
        this.compactRB.setText("Compact");
        this.compactRB.setName("compactRB");
        this.purgeCB.setText("Purge Duplicated Records");
        this.purgeCB.setName("purgeCB");
        this.ifilCB.setText("Update IFIL Structure");
        this.ifilCB.setName("ifilCB");
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(16, 16, 16).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.compactRB).addComponent(this.normalRB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 69, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.purgeCB).addComponent(this.ifilCB)).addGap(34, 34, 34)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this.purgeCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ifilCB)).addGroup(groupLayout.createSequentialGroup().addComponent(this.normalRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.compactRB))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setName("jPanel2");
        this.startBT.setText("Start");
        this.startBT.setName("startBT");
        this.startBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RebuildDialog.this.startBTActionPerformed(actionEvent);
            }
        });
        this.exitBT.setText("Exit");
        this.exitBT.setName("exitBT");
        this.exitBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RebuildDialog.this.exitBTActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(84, 84, 84).addComponent(this.startBT, -2, 76, -2).addGap(35, 35, 35).addComponent(this.exitBT, -2, 78, -2).addContainerGap(84, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap(23, Short.MAX_VALUE).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startBT).addComponent(this.exitBT))));
        jLabel1.setText("Action :");
        jLabel1.setName("jLabel1");
        jPBar.setName("jPBar");
        GroupLayout groupLayout3 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGap(37, 37, 37).addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 293, Short.MAX_VALUE)).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addGap(24, 24, 24).addComponent(jPBar, -1, 320, Short.MAX_VALUE).addGap(23, 23, 23)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(jPBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void startBTActionPerformed(ActionEvent actionEvent) {
        CTTable cTTable = null;
        int n = 5;
        int n2 = 0;
        if (this.compactRB.isSelected()) {
            n2 = 8;
        }
        if (this.purgeCB.isSelected()) {
            n2 |= 1;
        }
        if (this.ifilCB.isSelected()) {
            n2 |= 2;
        }
        CTSession cTSession = null;
        try {
            Short s;
            Long l;
            this.startBT.setEnabled(false);
            this.exitBT.setEnabled(false);
            this.validate();
            this.repaint();
            cTTable = new CTTable(Globals.currentIsamConnection.getDb());
            cTTable.Open(this.tableName, n);
            CTRecord cTRecord = new CTRecord(cTTable);
            try {
                l = cTRecord.GetRecordCount();
            }
            catch (CTException cTException) {
                l = 0L;
            }
            if (l <= 100L) {
                s = 1;
            } else if (l <= 64000L) {
                s = (short)(l / 100L);
            } else {
                Long l2 = l;
                while (l2 > 32767L) {
                    l2 = l2 / 20L;
                }
                s = l2.shortValue();
            }
            while (l > Integer.MAX_VALUE) {
                l = l / 1000L;
            }
            cTSession = Globals.currentIsamConnection.getSession();
            int n3 = cTSession.SetCallbackOnRebuild((Object)this, "callback", (int)s.shortValue());
            if (n3 == -1) {
                Globals.showMessage("A rebuild callback is already in place\n\nCallback messages may not appear", "Rebuild Table");
            }
            jPBar.setMinimum(0);
            jPBar.setMaximum(l.intValue());
            this.setControl(false);
            Thread thread = new Thread(new RunSomeTask(cTSession, cTTable, n2));
            thread.start();
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "Rebuild Error");
            this.setControl(true);
        }
    }

    private void setControl(Boolean bl) {
        this.normalRB.setEnabled(bl);
        this.compactRB.setEnabled(bl);
        this.purgeCB.setEnabled(bl);
        this.ifilCB.setEnabled(bl);
        this.exitBT.setEnabled(bl);
        this.startBT.setEnabled(bl);
    }

    public static void callback(int n, char c, String string) {
        if (c == 'm') {
            jLabel1.setText("Action : " + string);
            jLabel1.repaint();
            jLabel1.invalidate();
            jPBar.setValue(0);
            jPBar.repaint();
            jPBar.invalidate();
        } else if (c == 'd' || c == 'i') {
            jPBar.setValue(n);
            jPBar.repaint();
            jPBar.invalidate();
        }
    }

    private void exitBTActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public class RunSomeTask
    implements Runnable {
        CTSession s;
        CTTable tb;
        int mode;

        public RunSomeTask(CTSession cTSession, CTTable cTTable, int n) {
            this.s = cTSession;
            this.tb = cTTable;
            this.mode = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.tb.Rebuild(this.mode);
            }
            catch (CTException cTException) {
                Globals.showException(cTException, "Rebuild Error");
            }
            finally {
                jLabel1.setText("Rebuild finished");
                if (this.tb != null && this.tb.IsActive()) {
                    try {
                        this.tb.Close();
                        if (this.s != null) {
                            this.s.SetCallbackOnRebuild((Object)this, null, 0);
                        }
                        RebuildDialog.this.setControl(true);
                    }
                    catch (CTException cTException) {
                        Logger.getLogger(RebuildDialog.class.getName()).log(Level.SEVERE, null, cTException);
                    }
                }
            }
        }
    }
}

