/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import ctreeaceexplorer.IsamTree;
import ctreeaceexplorer.LookUpServer;
import ctreeaceexplorer.sql.SqlTree;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerDiscovery {
    private ArrayList<LookUpServer> workerThreads = new ArrayList();
    SqlTree sqlTree;
    IsamTree isamTree;

    public ServerDiscovery(SqlTree sqlTree, IsamTree isamTree) {
        this.sqlTree = sqlTree;
        this.isamTree = isamTree;
    }

    public void discover() {
        InetAddress[] inetAddressArray = null;
        try {
            InetAddress[] inetAddressArray2 = System.getenv("COMPUTERNAME");
            if (inetAddressArray2 == null) {
                inetAddressArray2 = System.getenv("HOSTNAME");
            }
            if (inetAddressArray2 == null) {
                inetAddressArray2 = InetAddress.getLocalHost().getHostName();
            }
            inetAddressArray = InetAddress.getAllByName((String)inetAddressArray2);
        }
        catch (UnknownHostException unknownHostException) {
            Logger.getLogger(ServerDiscovery.class.getName()).log(Level.SEVERE, null, unknownHostException);
        }
        if (inetAddressArray != null) {
            for (InetAddress inetAddress : inetAddressArray) {
                if (inetAddress.isLinkLocalAddress()) continue;
                System.out.println("Ip = " + inetAddress.toString());
                this.initDiscovery(inetAddress, this.sqlTree, this.isamTree);
            }
        }
    }

    private void initDiscovery(InetAddress inetAddress, SqlTree sqlTree, IsamTree isamTree) {
        LookUpServer lookUpServer = new LookUpServer(sqlTree, isamTree, inetAddress);
        Thread thread = new Thread(lookUpServer);
        this.workerThreads.add(lookUpServer);
        thread.start();
    }

    void stopDiscover() {
        for (LookUpServer lookUpServer : this.workerThreads) {
            lookUpServer.stopped = true;
        }
    }
}

