/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import FairCom.CtreeDb.CTDatabase;
import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTField;
import FairCom.CtreeDb.CTIndex;
import FairCom.CtreeDb.CTRecord;
import FairCom.CtreeDb.CTSegment;
import FairCom.CtreeDb.CTTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.Helper.Editors.FcComboBoxCellEditor;
import FairCom.Helper.Renderers.FcComboBoxCellRenderer;
import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.Field;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.ISAM_MODE;
import ctreeaceexplorer.Index;
import ctreeaceexplorer.IndexConditionDialog;
import ctreeaceexplorer.IsamDynamicTable;
import ctreeaceexplorer.IsamTableModel;
import ctreeaceexplorer.Segment;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableSchemaEditor
extends JDialog {
    String tableName;
    TableSchema schema = new TableSchema();
    ISAM_MODE mode;
    ArrayList<Object[]> tableProperties;
    Index currentIndex;
    int currentIndexNumber;
    CTTable tb;
    int oldPadChar;
    int oldFieldDelimiter;
    public FieldsTable fieldsTable = new FieldsTable();
    public IndexesTable indexesTable = new IndexesTable();
    public SegmentsTable segmentsTable = new SegmentsTable();
    private JButton addFieldBT;
    private JButton addIndexBT;
    private JButton addSegmentBT;
    private JButton applyButton;
    private JButton browseBT;
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    private JCheckBox checkLockCB;
    private JCheckBox checkReadCB;
    private JButton conditionBT;
    private JTextField datExtensionTB;
    private JSpinner datExtentSP;
    private JButton deleteFieldBT;
    private JButton deleteIndexBT;
    private JButton deleteSegmentBT;
    private JButton fieldMoveDownBT;
    private JButton fieldMoveUpBT;
    private JScrollPane fieldsScrollPane;
    private JSpinner fldDelSP;
    private JCheckBox hugeFileCB;
    private JTextField idxExtensionTB;
    private JSpinner idxExtentSP;
    private JScrollPane indexexScrollPane;
    private JButton insertFieldBT;
    private JButton insertSegmentBT;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JTable jTable2;
    private JTable jTable3;
    private JTextField nameTB;
    private JCheckBox noDelFldCB;
    private JCheckBox noNulFldCB;
    private JCheckBox noRecBytCB;
    private JCheckBox noRowIdCB;
    private JRadioButton noneRB;
    private JButton okButton;
    private JSpinner padCharSP;
    private JTextField pathTB;
    private JRadioButton preimgBT;
    private JButton segMoveDownBT;
    private JButton segMoveUpBT;
    private JScrollPane segmentsScrollPane;
    private JRadioButton trnlogBT;
    private JCheckBox vrLenCB;
    private JCheckBox writeThruCB;

    public TableSchemaEditor(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        Globals.isamShowDebugColumns = false;
        this.fieldsScrollPane.setViewportView((Component)((Object)this.fieldsTable));
        this.fieldsScrollPane.getViewport().setBackground(Color.white);
        this.indexexScrollPane.setViewportView((Component)((Object)this.indexesTable));
        this.indexexScrollPane.getViewport().setBackground(Color.white);
        this.segmentsScrollPane.setViewportView((Component)((Object)this.segmentsTable));
        this.segmentsScrollPane.getViewport().setBackground(Color.white);
        this.fieldsTable.schema = this.schema;
    }

    public void showDialog(ISAM_MODE iSAM_MODE, String string) {
        this.mode = iSAM_MODE;
        this.tableName = string;
        if (iSAM_MODE == ISAM_MODE.TABLE_CREATE) {
            String string2;
            this.schema.fields = new ArrayList();
            this.applyButton.setEnabled(false);
            CTDatabase cTDatabase = Globals.currentIsamConnection.getDb();
            if (cTDatabase.IsSQL() && (string2 = cTDatabase.GetPath()).endsWith("SQL_SYS")) {
                string2 = string2.substring(0, string2.length() - 7);
                this.pathTB.setText(string2);
            }
        } else {
            this.setTitle("Modify Table : " + string);
            this.nameTB.setEnabled(false);
            this.pathTB.setEnabled(false);
            this.datExtensionTB.setEnabled(false);
            this.datExtentSP.setEnabled(false);
            this.idxExtensionTB.setEnabled(false);
            this.idxExtentSP.setEnabled(false);
            this.vrLenCB.setEnabled(false);
            this.browseBT.setEnabled(false);
            FieldsTableModel fieldsTableModel = this.fieldsTable.getModel();
            fieldsTableModel.readOnlyColumns.set(FIELD_COLS.IDENTITY.ordinal(), true);
            fieldsTableModel.readOnlyColumns.set(FIELD_COLS.SEED.ordinal(), true);
            fieldsTableModel.readOnlyColumns.set(FIELD_COLS.INCREMENT.ordinal(), true);
            if (!this.setProperties(string)) {
                return;
            }
            this.getSchema();
            fieldsTableModel.populateTableFields(this.schema.fields);
            IndexesTableModel indexesTableModel = (IndexesTableModel)this.indexesTable.getModel();
            indexesTableModel.populateTableIndexes(this.schema.indexes);
            String[] stringArray = new String[this.schema.fields.size()];
            int n = 0;
            for (Field field : this.schema.fields) {
                stringArray[n++] = field.name;
            }
            Object object = (SegmentsTableModel)this.segmentsTable.getModel();
            ((SegmentsTableModel)((Object)object)).fieldsCombo.setCellRenderer((TableCellRenderer)new FcComboBoxCellRenderer(stringArray));
            ((SegmentsTableModel)((Object)object)).fieldsCombo.setCellEditor((TableCellEditor)new FcComboBoxCellEditor(stringArray));
            try {
                this.tb = new CTTable(Globals.currentIsamConnection.getDb());
                this.tb.Open(string, Globals.isamOpenMode | 1);
            }
            catch (CTException cTException) {
                Globals.showException(cTException, "Open Error");
                return;
            }
        }
        this.getRootPane().setDefaultButton(this.okButton);
        this.setVisible(true);
    }

    private boolean setProperties(String string) {
        this.nameTB.setText(string);
        this.tableProperties = Globals.currentIsamConnection.readTableProperties(string);
        if (this.tableProperties == null || this.tableProperties.isEmpty()) {
            return false;
        }
        String string2 = this.GetValue("Path");
        this.pathTB.setText(string2);
        string2 = this.GetValue("Datafile Extension");
        this.datExtensionTB.setText(string2);
        string2 = this.GetValue("Datafile Extent Size");
        this.datExtentSP.setValue(Integer.parseInt(string2));
        string2 = this.GetValue("Indexfile Extension");
        this.idxExtensionTB.setText(string2);
        string2 = this.GetValue("Indexfile Extent Size");
        this.idxExtentSP.setValue(Integer.parseInt(string2));
        string2 = this.GetValue("PREIMG");
        this.preimgBT.setSelected(string2.equals("Yes"));
        string2 = this.GetValue("TRNLOG");
        this.trnlogBT.setSelected(string2.equals("Yes"));
        string2 = this.GetValue("NOROWID");
        this.noRowIdCB.setSelected(string2.equals("Yes"));
        string2 = this.GetValue("NODELFLD");
        this.noDelFldCB.setSelected(string2.equals("Yes"));
        string2 = this.GetValue("NONULFLD");
        this.noNulFldCB.setSelected(string2.equals("Yes"));
        string2 = this.GetValue("NORECBYT");
        this.noRecBytCB.setSelected(string2.equals("Yes"));
        string2 = this.GetValue("HUGEFILE");
        this.hugeFileCB.setSelected(string2.equals("Yes"));
        string2 = this.GetValue("VLENGTH");
        this.vrLenCB.setSelected(string2.equals("Yes"));
        string2 = this.GetValue("CHECKLOCK");
        this.checkLockCB.setSelected(string2.equals("Yes"));
        string2 = this.GetValue("CHECKREAD");
        this.checkReadCB.setSelected(string2.equals("Yes"));
        string2 = this.GetValue("WRITETHRU");
        this.writeThruCB.setSelected(string2.equals("Yes"));
        string2 = this.GetValue("Pad Char");
        this.oldPadChar = Integer.parseInt(string2);
        this.padCharSP.setValue(this.oldPadChar);
        string2 = this.GetValue("Field Delimiter");
        this.oldFieldDelimiter = Integer.parseInt(string2);
        this.fldDelSP.setValue(this.oldFieldDelimiter);
        return true;
    }

    private String GetValue(String string) {
        for (Object[] objectArray : this.tableProperties) {
            if (!objectArray[0].equals(string)) continue;
            return (String)objectArray[1];
        }
        Globals.showException(new Exception(string), "Value Not Found");
        return "Value Not Found";
    }

    private void getSchema() {
        ArrayList<Field> arrayList = Globals.currentIsamConnection.getTableFields();
        this.schema.fields = arrayList;
        ArrayList<Index> arrayList2 = Globals.currentIsamConnection.getTableIndexes();
        for (Index index : arrayList2) {
            if (index.isInternal) continue;
            this.schema.indexes.add(index);
            index.segments = Globals.currentIsamConnection.getIndexSegments(this.tableName, index.name);
        }
    }

    private boolean applySchema() {
        String string = this.nameTB.getText();
        if (string.isEmpty()) {
            Globals.showMessage("The table Name property cannot be blank", "Create Table");
            return false;
        }
        if (this.schema.fields.isEmpty()) {
            Globals.showMessage("Table " + string + " has no fields", "Create Table");
            return false;
        }
        for (Index index : this.schema.indexes) {
            if (index.isInternal || index.segmentCount != 0) continue;
            Globals.showMessage("Index " + index.name + " has no segments", "Create Table");
            return false;
        }
        if (!this.datExtensionTB.getText().startsWith(".")) {
            this.datExtensionTB.setText("." + this.datExtensionTB.getText());
        }
        if (!this.idxExtensionTB.getText().startsWith(".")) {
            this.idxExtensionTB.setText("." + this.idxExtensionTB.getText());
        }
        int n = 0;
        if (this.vrLenCB.isSelected()) {
            n |= 0x10;
        }
        if (this.preimgBT.isSelected()) {
            n |= 1;
        }
        if (this.trnlogBT.isSelected()) {
            n |= 2;
        }
        if (this.noRowIdCB.isSelected()) {
            n |= 0x40;
        }
        if (this.noDelFldCB.isSelected()) {
            n |= 0x200;
        }
        if (this.noneRB.isSelected()) {
            n |= 0x400;
        }
        if (this.noRecBytCB.isSelected()) {
            n |= 0x20;
        }
        if (this.writeThruCB.isSelected()) {
            n |= 4;
        }
        if (this.checkLockCB.isSelected()) {
            n |= 8;
        }
        if (this.checkReadCB.isSelected()) {
            n |= 0x80;
        }
        if (this.hugeFileCB.isSelected()) {
            n |= 0x100;
        }
        if (this.mode == ISAM_MODE.TABLE_CREATE) {
            return this.CreateTable(string, n);
        }
        return this.AlterTable(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean CreateTable(String string, int n) {
        try {
            CTField cTField;
            this.tb = new CTTable(Globals.currentIsamConnection.getDb());
            this.tb.SetPath(this.pathTB.getText());
            this.tb.SetDataExtension(this.datExtensionTB.getText());
            this.tb.SetIndexExtension(this.idxExtensionTB.getText());
            this.tb.SetDataDefaultExtentSize(((Integer)this.datExtentSP.getValue()).intValue());
            this.tb.SetIndexDefaultExtentSize(((Integer)this.idxExtentSP.getValue()).intValue());
            int n2 = (Integer)this.padCharSP.getValue();
            char c = (char)n2;
            n2 = (Integer)this.fldDelSP.getValue();
            char c2 = (char)n2;
            this.tb.SetPadChar(c, c2);
            for (Field object : this.schema.fields) {
                cTField = this.tb.AddField(object.name, object.type, object.length);
                cTField.SetNullFlag(!object.nullAllowed);
                if (object.type == IsamTableModel.fieldTypes.GetKey("NUMBER")) {
                    cTField.SetPrecision(object.precision);
                    cTField.SetScale(object.scale);
                }
                if (!object.isIdentity) continue;
                this.tb.SetIdentityField(object.name, object.seed, object.increment);
            }
            for (Index index : this.schema.indexes) {
                cTField = this.tb.AddIndex(index.name, index.type, !index.dupDisallowed, !index.nullDisallowed);
                if (!index.fileName.isEmpty() && !index.fileName.equals("( Default )")) {
                    cTField.SetFilename(this.pathTB.getText(), index.fileName);
                }
                n2 = index.emptyChar;
                c = (char)n2;
                cTField.SetEmptyChar(c);
                for (Segment segment : index.segments) {
                    int n3 = segment.mode;
                    switch (segment.mode) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            Globals.showMessage("Segment " + segment.fieldName + " has an invalid Segment Mode\n\nIf you really need this segment mode\nyou must use other tools", "Create Table");
                        }
                    }
                    if (segment.descending) {
                        n3 |= 0x10;
                    }
                    this.tb.AddSegment((CTIndex)cTField, segment.fieldName, n3);
                }
            }
            this.tb.Create(string, n);
            this.UpdateCndxIndexes(this.mode);
        }
        catch (CTException cTException) {
            Globals.showException(cTException, "Create Table");
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.tb.IsActive()) {
                try {
                    this.tb.Close();
                }
                catch (CTException cTException) {
                    Logger.getLogger(TableSchemaEditor.class.getName()).log(Level.SEVERE, null, cTException);
                }
            }
        }
        return true;
    }

    private boolean AlterTable(int n) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this.tb.IsActive()) {
                int n2 = this.tb.GetStatus();
                this.tb.Begin();
                int n3 = (Integer)this.padCharSP.getValue();
                char c = (char)n3;
                int n4 = (Integer)this.fldDelSP.getValue();
                char c2 = (char)n4;
                if (n3 != this.oldPadChar || n4 != this.oldFieldDelimiter) {
                    this.tb.UpdatePadChar(c, c2, true);
                }
                if ((n2 & 8) == 8 || (n2 & 4) == 4) {
                    this.tb.Alter(3);
                } else if (n2 != 0) {
                    this.tb.Alter(0);
                }
                this.tb.UpdateCreateMode(n);
                this.tb.Commit();
                this.UpdateCndxIndexes(this.mode);
                this.tb.Close();
                this.tb.Open(this.tableName, Globals.isamOpenMode | 1);
            }
        }
        catch (CTException cTException) {
            try {
                this.tb.Abort();
            }
            catch (CTException cTException2) {
                Logger.getLogger(TableSchemaEditor.class.getName()).log(Level.SEVERE, null, cTException2);
            }
            this.setCursor(Cursor.getDefaultCursor());
            Globals.showException(cTException, "Alter Table");
            return false;
        }
        this.setCursor(Cursor.getDefaultCursor());
        return true;
    }

    private void UpdateCndxIndexes(ISAM_MODE iSAM_MODE) {
        for (Index index : this.schema.indexes) {
            if (index.condition == null || index.condition.equals("N") || iSAM_MODE == ISAM_MODE.TABLE_CREATE && index.condition.length() == 0) continue;
            try {
                CTRecord cTRecord = new CTRecord(this.tb);
                if (cTRecord == null) continue;
                try {
                    if (index.condition.length() > 0) {
                        cTRecord.CndxCompile(index.condition);
                    }
                    String string = this.tb.GetCndxIndex(index.name);
                    if (index.condition.length() <= 0 && string.length() <= 0) continue;
                    this.tb.UpdateCndxIndex(index.name, index.condition);
                }
                catch (CTException cTException) {
                    if (cTException.GetErrorCode() == 408L) continue;
                    Globals.showMessage("Error # : " + cTException.GetErrorCode() + "\nError Description : " + cTException.GetErrorMsg() + "\n\nOn Index : " + index.name, "Conditional Compile Error");
                }
            }
            catch (CTException cTException) {
                Globals.showMessage(cTException.GetErrorMsg() + "\n\nOn Index : " + index.name, "Conditional Compile Error");
            }
        }
    }

    private void stopEditing() {
        if (this.fieldsTable.getCellEditor() != null) {
            this.fieldsTable.getCellEditor().stopCellEditing();
        }
        if (this.indexesTable.getCellEditor() != null) {
            this.indexesTable.getCellEditor().stopCellEditing();
        }
        if (this.segmentsTable.getCellEditor() != null) {
            this.segmentsTable.getCellEditor().stopCellEditing();
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jPanel5 = new JPanel();
        this.nameTB = new JTextField();
        this.pathTB = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.browseBT = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.datExtensionTB = new JTextField();
        this.datExtentSP = new JSpinner();
        this.idxExtensionTB = new JTextField();
        this.jLabel5 = new JLabel();
        this.idxExtentSP = new JSpinner();
        this.jLabel6 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jPanel8 = new JPanel();
        this.noneRB = new JRadioButton();
        this.trnlogBT = new JRadioButton();
        this.preimgBT = new JRadioButton();
        this.jPanel9 = new JPanel();
        this.noRowIdCB = new JCheckBox();
        this.noDelFldCB = new JCheckBox();
        this.noNulFldCB = new JCheckBox();
        this.noRecBytCB = new JCheckBox();
        this.hugeFileCB = new JCheckBox();
        this.vrLenCB = new JCheckBox();
        this.checkLockCB = new JCheckBox();
        this.checkReadCB = new JCheckBox();
        this.writeThruCB = new JCheckBox();
        this.jPanel7 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.padCharSP = new JSpinner();
        this.fldDelSP = new JSpinner();
        this.jPanel3 = new JPanel();
        this.fieldsScrollPane = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel10 = new JPanel();
        this.addFieldBT = new JButton();
        this.insertFieldBT = new JButton();
        this.deleteFieldBT = new JButton();
        this.fieldMoveUpBT = new JButton();
        this.fieldMoveDownBT = new JButton();
        this.jPanel4 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel11 = new JPanel();
        this.jPanel14 = new JPanel();
        this.addIndexBT = new JButton();
        this.deleteIndexBT = new JButton();
        this.conditionBT = new JButton();
        this.indexexScrollPane = new JScrollPane();
        this.jTable3 = new JTable();
        this.jPanel12 = new JPanel();
        this.jPanel13 = new JPanel();
        this.addSegmentBT = new JButton();
        this.insertSegmentBT = new JButton();
        this.deleteSegmentBT = new JButton();
        this.segMoveUpBT = new JButton();
        this.segMoveDownBT = new JButton();
        this.segmentsScrollPane = new JScrollPane();
        this.jTable2 = new JTable();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.applyButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Create Table");
        this.setResizable(false);
        this.jTabbedPane1.setBorder(BorderFactory.createEtchedBorder());
        this.jTabbedPane1.setName("jTabbedPane1");
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TableSchemaEditor.this.jTabbedPane1StateChanged(changeEvent);
            }
        });
        this.jPanel2.setName("jPanel2");
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, "General", 0, 0, new Font("Tahoma", 0, 11), Color.blue));
        this.jPanel5.setName("jPanel5");
        this.nameTB.setName("nameTB");
        this.pathTB.setName("pathTB");
        this.jLabel1.setText("Name :");
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText("Path :");
        this.jLabel2.setName("jLabel2");
        this.browseBT.setText("...");
        this.browseBT.setName("browseBT");
        this.jLabel3.setText("File Extension :");
        this.jLabel3.setName("jLabel3");
        this.jLabel4.setText("Data Extent Size :");
        this.jLabel4.setName("jLabel4");
        this.datExtensionTB.setText(".dat");
        this.datExtensionTB.setName("datExtensionTB");
        this.datExtentSP.setName("datExtentSP");
        this.idxExtensionTB.setText(".idx");
        this.idxExtensionTB.setName("idxExtensionTB");
        this.jLabel5.setText("Index Extension :");
        this.jLabel5.setName("jLabel5");
        this.idxExtentSP.setName("idxExtentSP");
        this.jLabel6.setText("Data Extent Size :");
        this.jLabel6.setName("jLabel6");
        GroupLayout groupLayout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameTB, -2, 151, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.pathTB, -2, 223, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseBT, -2, 24, -2))).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.datExtensionTB, -2, 42, -2).addComponent(this.datExtentSP, -2, 66, -2)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idxExtensionTB, -2, 42, -2).addComponent(this.idxExtentSP, -2, 66, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.idxExtensionTB, -2, -1, -2)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.idxExtentSP, -2, -1, -2))).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameTB, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jLabel3).addComponent(this.datExtensionTB, -2, -1, -2)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pathTB, -2, -1, -2).addComponent(this.browseBT).addComponent(this.jLabel4).addComponent(this.datExtentSP, -2, -1, -2).addComponent(this.jLabel2)))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(null, "Table Creation Modes", 0, 0, new Font("Tahoma", 0, 11), Color.blue));
        this.jPanel6.setName("jPanel6");
        this.jPanel8.setBorder(BorderFactory.createTitledBorder("Transaction Mode"));
        this.jPanel8.setName("jPanel8");
        this.buttonGroup1.add(this.noneRB);
        this.noneRB.setSelected(true);
        this.noneRB.setText("NONE");
        this.noneRB.setName("noneRB");
        this.buttonGroup1.add(this.trnlogBT);
        this.trnlogBT.setText("TRNLOG");
        this.trnlogBT.setName("trnlogBT");
        this.buttonGroup1.add(this.preimgBT);
        this.preimgBT.setText("PREIMG");
        this.preimgBT.setName("preimgBT");
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noneRB).addComponent(this.trnlogBT).addComponent(this.preimgBT)).addContainerGap(27, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.noneRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.trnlogBT).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.preimgBT).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel9.setBorder(BorderFactory.createTitledBorder("Special Fields"));
        this.jPanel9.setName("jPanel9");
        this.noRowIdCB.setText("NOROWID");
        this.noRowIdCB.setName("noRowIdCB");
        this.noDelFldCB.setText("NODELFLD");
        this.noDelFldCB.setName("noDelFldCB");
        this.noNulFldCB.setText("NONULFLD");
        this.noNulFldCB.setName("noNulFldCB");
        GroupLayout groupLayout3 = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noRowIdCB).addComponent(this.noDelFldCB).addComponent(this.noNulFldCB)).addContainerGap(13, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.noRowIdCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.noDelFldCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.noNulFldCB).addContainerGap(-1, Short.MAX_VALUE)));
        this.noRecBytCB.setText("NORECBYT");
        this.noRecBytCB.setName("noRecBytCB");
        this.hugeFileCB.setText("HUGEFILE");
        this.hugeFileCB.setName("hugeFileCB");
        this.vrLenCB.setText("VRLEN");
        this.vrLenCB.setName("vrLenCB");
        this.checkLockCB.setText("CHECKLOCK");
        this.checkLockCB.setName("checkLockCB");
        this.checkReadCB.setText("CHECKREAD");
        this.checkReadCB.setName("checkReadCB");
        this.writeThruCB.setText("WRITETHRU");
        this.writeThruCB.setName("writeThruCB");
        GroupLayout groupLayout4 = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.jPanel8, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel9, -2, -1, -2).addGap(34, 34, 34).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hugeFileCB).addComponent(this.noRecBytCB).addComponent(this.vrLenCB)).addGap(38, 38, 38).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.writeThruCB).addComponent(this.checkLockCB).addComponent(this.checkReadCB)).addContainerGap(197, Short.MAX_VALUE)));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addComponent(this.jPanel9, -2, -1, -2).addContainerGap()).addGroup(groupLayout4.createSequentialGroup().addComponent(this.jPanel8, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.noRecBytCB).addComponent(this.checkLockCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkReadCB).addComponent(this.hugeFileCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.vrLenCB).addComponent(this.writeThruCB)).addGap(34, 34, 34)))));
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(null, "Padding & Delimiter", 0, 0, new Font("Tahoma", 0, 11), Color.blue));
        this.jPanel7.setName("jPanel7");
        this.jLabel7.setText("Padding Char ASCII Decimal Value :");
        this.jLabel7.setName("jLabel7");
        this.jLabel8.setText("Field Delimiter ASCII Decimal Value :");
        this.jLabel8.setName("jLabel8");
        this.jLabel9.setText("(i.e. space = 32 )");
        this.jLabel9.setName("jLabel9");
        this.jLabel10.setText("(i.e. space = 32 )");
        this.jLabel10.setName("jLabel10");
        this.padCharSP.setName("padCharSP");
        this.padCharSP.setValue(32);
        this.fldDelSP.setName("fldDelSP");
        GroupLayout groupLayout5 = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addGap(18, 18, 18).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7, -2, 191, -2).addGroup(groupLayout5.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel9))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.padCharSP, -2, 60, -2).addGap(55, 55, 55).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addComponent(this.jLabel8, -2, 191, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldDelSP, -2, 60, -2)).addGroup(groupLayout5.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel10))).addContainerGap(84, Short.MAX_VALUE)));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addGap(11, 11, 11).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jLabel8).addComponent(this.padCharSP, -2, -1, -2).addComponent(this.fldDelSP, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jLabel10)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout6 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel7, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel6, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap(12, Short.MAX_VALUE)));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -2, 151, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel7, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Properties", this.jPanel2);
        this.jPanel3.setName("jPanel3");
        this.fieldsScrollPane.setBorder(BorderFactory.createTitledBorder(null, "Fields Definition", 0, 0, new Font("Tahoma", 0, 11), Color.blue));
        this.fieldsScrollPane.setName("fieldsScrollPane");
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}));
        this.jTable1.setName("jTable1");
        this.jTable1.setPreferredSize(new Dimension(30, 64));
        this.jTable1.setSelectionMode(0);
        this.fieldsScrollPane.setViewportView(this.jTable1);
        this.jPanel10.setName("jPanel10");
        this.jPanel10.setPreferredSize(new Dimension(93, 375));
        this.addFieldBT.setText("Add");
        this.addFieldBT.setName("addFieldBT");
        this.addFieldBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSchemaEditor.this.addFieldBTActionPerformed(actionEvent);
            }
        });
        this.insertFieldBT.setText("Insert");
        this.insertFieldBT.setName("insertFieldBT");
        this.insertFieldBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSchemaEditor.this.insertFieldBTActionPerformed(actionEvent);
            }
        });
        this.deleteFieldBT.setText("Delete");
        this.deleteFieldBT.setName("deleteFieldBT");
        this.deleteFieldBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSchemaEditor.this.deleteFieldBTActionPerformed(actionEvent);
            }
        });
        this.fieldMoveUpBT.setText("Move Up");
        this.fieldMoveUpBT.setName("fieldMoveUpBT");
        this.fieldMoveUpBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSchemaEditor.this.fieldMoveUpBTActionPerformed(actionEvent);
            }
        });
        this.fieldMoveDownBT.setText("Move Down");
        this.fieldMoveDownBT.setName("fieldMoveDownBT");
        this.fieldMoveDownBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSchemaEditor.this.fieldMoveDownBTActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout7 = new GroupLayout(this.jPanel10);
        this.jPanel10.setLayout(groupLayout7);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.insertFieldBT, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.deleteFieldBT, GroupLayout.Alignment.TRAILING, -1, 89, Short.MAX_VALUE).addComponent(this.addFieldBT, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.fieldMoveDownBT, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.fieldMoveUpBT, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addGap(18, 18, 18).addComponent(this.addFieldBT).addGap(18, 18, 18).addComponent(this.insertFieldBT).addGap(18, 18, 18).addComponent(this.deleteFieldBT).addGap(18, 18, 18).addComponent(this.fieldMoveUpBT).addGap(18, 18, 18).addComponent(this.fieldMoveDownBT).addContainerGap(181, Short.MAX_VALUE)));
        GroupLayout groupLayout8 = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(groupLayout8);
        groupLayout8.setHorizontalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout8.createSequentialGroup().addComponent(this.fieldsScrollPane, -1, 587, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel10, -2, 108, -2)));
        groupLayout8.setVerticalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel10, -1, 386, Short.MAX_VALUE).addComponent(this.fieldsScrollPane, -1, 386, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("Fields", this.jPanel3);
        this.jPanel4.setName("jPanel4");
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(180);
        this.jSplitPane1.setDividerSize(0);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setName("jSplitPane1");
        this.jPanel11.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel11.setName("jPanel11");
        this.jPanel14.setName("jPanel14");
        this.addIndexBT.setText("Add");
        this.addIndexBT.setName("addIndexBT");
        this.addIndexBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSchemaEditor.this.addIndexBTActionPerformed(actionEvent);
            }
        });
        this.deleteIndexBT.setText("Delete");
        this.deleteIndexBT.setName("deleteIndexBT");
        this.deleteIndexBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSchemaEditor.this.deleteIndexBTActionPerformed(actionEvent);
            }
        });
        this.conditionBT.setText("Condition");
        this.conditionBT.setName("conditionBT");
        this.conditionBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSchemaEditor.this.conditionBTActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout9 = new GroupLayout(this.jPanel14);
        this.jPanel14.setLayout(groupLayout9);
        groupLayout9.setHorizontalGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout9.createSequentialGroup().addContainerGap().addGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.conditionBT, GroupLayout.Alignment.TRAILING, -1, 85, Short.MAX_VALUE).addComponent(this.deleteIndexBT, GroupLayout.Alignment.TRAILING, -1, 85, Short.MAX_VALUE).addComponent(this.addIndexBT, GroupLayout.Alignment.TRAILING, -1, 85, Short.MAX_VALUE)).addContainerGap()));
        groupLayout9.setVerticalGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout9.createSequentialGroup().addContainerGap().addComponent(this.addIndexBT).addGap(18, 18, 18).addComponent(this.deleteIndexBT).addGap(18, 18, 18).addComponent(this.conditionBT).addContainerGap(51, Short.MAX_VALUE)));
        this.indexexScrollPane.setBorder(BorderFactory.createTitledBorder(null, "Indexes Definition", 0, 0, new Font("Tahoma", 0, 11), Color.blue));
        this.indexexScrollPane.setName("indexexScrollPane");
        this.jTable3.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable3.setName("jTable3");
        this.indexexScrollPane.setViewportView(this.jTable3);
        GroupLayout groupLayout10 = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(groupLayout10);
        groupLayout10.setHorizontalGroup(groupLayout10.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout10.createSequentialGroup().addComponent(this.indexexScrollPane, -1, 572, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel14, -2, -1, -2).addGap(15, 15, 15)));
        groupLayout10.setVerticalGroup(groupLayout10.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.indexexScrollPane, -1, 178, Short.MAX_VALUE).addGroup(groupLayout10.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jPanel14, -1, -1, Short.MAX_VALUE)));
        this.jSplitPane1.setTopComponent(this.jPanel11);
        this.jPanel12.setName("jPanel12");
        this.jPanel13.setName("jPanel13");
        this.addSegmentBT.setText("Add");
        this.addSegmentBT.setName("addSegmentBT");
        this.addSegmentBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSchemaEditor.this.addSegmentBTActionPerformed(actionEvent);
            }
        });
        this.insertSegmentBT.setText("Insert");
        this.insertSegmentBT.setName("insertSegmentBT");
        this.insertSegmentBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSchemaEditor.this.insertSegmentBTActionPerformed(actionEvent);
            }
        });
        this.deleteSegmentBT.setText("Delete");
        this.deleteSegmentBT.setName("deleteSegmentBT");
        this.deleteSegmentBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSchemaEditor.this.deleteSegmentBTActionPerformed(actionEvent);
            }
        });
        this.segMoveUpBT.setText("Move Up");
        this.segMoveUpBT.setName("segMoveUpBT");
        this.segMoveUpBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSchemaEditor.this.segMoveUpBTActionPerformed(actionEvent);
            }
        });
        this.segMoveDownBT.setText("Move Down");
        this.segMoveDownBT.setName("segMoveDownBT");
        this.segMoveDownBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSchemaEditor.this.segMoveDownBTActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout11 = new GroupLayout(this.jPanel13);
        this.jPanel13.setLayout(groupLayout11);
        groupLayout11.setHorizontalGroup(groupLayout11.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout11.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout11.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addSegmentBT, GroupLayout.Alignment.TRAILING, -1, 92, Short.MAX_VALUE).addComponent(this.segMoveDownBT, GroupLayout.Alignment.TRAILING, -1, 92, Short.MAX_VALUE).addComponent(this.segMoveUpBT, GroupLayout.Alignment.TRAILING, -1, 92, Short.MAX_VALUE).addComponent(this.deleteSegmentBT, GroupLayout.Alignment.TRAILING, -1, 92, Short.MAX_VALUE).addComponent(this.insertSegmentBT, -1, 92, Short.MAX_VALUE)).addContainerGap()));
        groupLayout11.linkSize(0, this.addSegmentBT, this.deleteSegmentBT, this.insertSegmentBT, this.segMoveDownBT, this.segMoveUpBT);
        groupLayout11.setVerticalGroup(groupLayout11.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout11.createSequentialGroup().addGap(24, 24, 24).addComponent(this.addSegmentBT).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.insertSegmentBT).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.deleteSegmentBT).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.segMoveUpBT).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.segMoveDownBT).addContainerGap(12, Short.MAX_VALUE)));
        this.segmentsScrollPane.setBorder(BorderFactory.createTitledBorder(null, "Segments Definition", 0, 0, new Font("Tahoma", 0, 11), Color.blue));
        this.segmentsScrollPane.setName("segmentsScrollPane");
        this.jTable2.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jTable2.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable2.setName("jTable2");
        this.segmentsScrollPane.setViewportView(this.jTable2);
        GroupLayout groupLayout12 = new GroupLayout(this.jPanel12);
        this.jPanel12.setLayout(groupLayout12);
        groupLayout12.setHorizontalGroup(groupLayout12.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout12.createSequentialGroup().addComponent(this.segmentsScrollPane, -1, 574, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel13, -2, -1, -2).addContainerGap()));
        groupLayout12.setVerticalGroup(groupLayout12.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout12.createSequentialGroup().addComponent(this.jPanel13, -1, -1, Short.MAX_VALUE).addContainerGap()).addComponent(this.segmentsScrollPane, -1, 206, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this.jPanel12);
        GroupLayout groupLayout13 = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(groupLayout13);
        groupLayout13.setHorizontalGroup(groupLayout13.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout13.createSequentialGroup().addComponent(this.jSplitPane1, -2, 704, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout13.setVerticalGroup(groupLayout13.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING, -2, 386, -2));
        this.jTabbedPane1.addTab("Indexes", this.jPanel4);
        this.jPanel1.setName("jPanel1");
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSchemaEditor.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSchemaEditor.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.applyButton.setMnemonic('A');
        this.applyButton.setText("Apply");
        this.applyButton.setName("applyButton");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSchemaEditor.this.applyButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout14 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout14);
        groupLayout14.setHorizontalGroup(groupLayout14.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout14.createSequentialGroup().addContainerGap(190, Short.MAX_VALUE).addComponent(this.okButton, -2, 75, -2).addGap(47, 47, 47).addComponent(this.cancelButton, -2, 80, -2).addGap(49, 49, 49).addComponent(this.applyButton, -2, 71, -2).addGap(98, 98, 98)));
        groupLayout14.setVerticalGroup(groupLayout14.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout14.createSequentialGroup().addGroup(groupLayout14.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton).addComponent(this.applyButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout15 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout15);
        groupLayout15.setHorizontalGroup(groupLayout15.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -2, 710, -2).addGroup(groupLayout15.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jPanel1, -2, -1, -2)));
        groupLayout15.setVerticalGroup(groupLayout15.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout15.createSequentialGroup().addComponent(this.jTabbedPane1, -1, 418, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void addFieldBTActionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        FieldsTableModel fieldsTableModel = this.fieldsTable.getModel();
        fieldsTableModel.addRecord(false);
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        if (this.applySchema()) {
            try {
                if (this.tb.IsActive()) {
                    this.tb.Close();
                }
                this.setVisible(false);
            }
            catch (CTException cTException) {
                Logger.getLogger(TableSchemaEditor.class.getName()).log(Level.SEVERE, null, cTException);
            }
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.tb != null && this.tb.IsActive()) {
                this.tb.Close();
            }
            this.setVisible(false);
        }
        catch (CTException cTException) {
            Logger.getLogger(TableSchemaEditor.class.getName()).log(Level.SEVERE, null, cTException);
        }
        this.setVisible(false);
    }

    private void applyButtonActionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        this.applySchema();
    }

    private void addIndexBTActionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        IndexesTableModel indexesTableModel = (IndexesTableModel)this.indexesTable.getModel();
        indexesTableModel.addRecord();
    }

    private void deleteIndexBTActionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        IndexesTableModel indexesTableModel = (IndexesTableModel)this.indexesTable.getModel();
        if (indexesTableModel.checkIsRowSelected()) {
            indexesTableModel.deleteRecord();
        }
    }

    private void conditionBTActionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        if (this.currentIndex != null) {
            JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
            IndexConditionDialog indexConditionDialog = new IndexConditionDialog((Frame)jFrame, true);
            indexConditionDialog.setLocationRelativeTo(jFrame);
            indexConditionDialog.cndxExpr = this.currentIndex.condition;
            if (indexConditionDialog.showDialog(this.mode, this.tableName, this.tb)) {
                this.currentIndex.condition = indexConditionDialog.cndxExpr;
            }
        }
    }

    private void addSegmentBTActionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        SegmentsTableModel segmentsTableModel = (SegmentsTableModel)this.segmentsTable.getModel();
        segmentsTableModel.addRecord(false);
    }

    private void insertSegmentBTActionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        SegmentsTableModel segmentsTableModel = (SegmentsTableModel)this.segmentsTable.getModel();
        if (segmentsTableModel.checkIsRowSelected()) {
            segmentsTableModel.addRecord(true);
        }
    }

    private void deleteSegmentBTActionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        SegmentsTableModel segmentsTableModel = (SegmentsTableModel)this.segmentsTable.getModel();
        if (segmentsTableModel.checkIsRowSelected()) {
            segmentsTableModel.deleteRecord();
        }
    }

    private void segMoveUpBTActionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        SegmentsTableModel segmentsTableModel = (SegmentsTableModel)this.segmentsTable.getModel();
        if (segmentsTableModel.checkIsRowSelected()) {
            segmentsTableModel.moveRecord(false);
        }
    }

    private void segMoveDownBTActionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        SegmentsTableModel segmentsTableModel = (SegmentsTableModel)this.segmentsTable.getModel();
        if (segmentsTableModel.checkIsRowSelected()) {
            segmentsTableModel.moveRecord(true);
        }
    }

    private void jTabbedPane1StateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        int n = jTabbedPane.getSelectedIndex();
        if (n == 2) {
            String[] stringArray = new String[this.schema.fields.size()];
            int n2 = 0;
            for (Field field : this.schema.fields) {
                stringArray[n2++] = field.name;
            }
            Object object = (SegmentsTableModel)this.segmentsTable.getModel();
            ((SegmentsTableModel)((Object)object)).fieldsCombo.setCellRenderer((TableCellRenderer)new FcComboBoxCellRenderer(stringArray));
            ((SegmentsTableModel)((Object)object)).fieldsCombo.setCellEditor((TableCellEditor)new FcComboBoxCellEditor(stringArray));
        }
    }

    private void insertFieldBTActionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        FieldsTableModel fieldsTableModel = this.fieldsTable.getModel();
        if (fieldsTableModel.checkIsRowSelected()) {
            fieldsTableModel.addRecord(true);
        }
    }

    private void deleteFieldBTActionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        FieldsTableModel fieldsTableModel = this.fieldsTable.getModel();
        if (fieldsTableModel.checkIsRowSelected()) {
            fieldsTableModel.deleteRecord();
        }
    }

    private void fieldMoveUpBTActionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        FieldsTableModel fieldsTableModel = this.fieldsTable.getModel();
        if (fieldsTableModel.checkIsRowSelected()) {
            fieldsTableModel.moveRecord(false);
        }
    }

    private void fieldMoveDownBTActionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        FieldsTableModel fieldsTableModel = this.fieldsTable.getModel();
        if (fieldsTableModel.checkIsRowSelected()) {
            fieldsTableModel.moveRecord(true);
        }
    }

    class TableSchema {
        ArrayList<Field> fields = new ArrayList();
        ArrayList<Index> indexes = new ArrayList();

        TableSchema() {
        }
    }

    public class SegmentsTableModel
    extends IsamTableModel {
        IsamDynamicTable table;
        TableColumn fieldsCombo;

        public SegmentsTableModel(IsamDynamicTable isamDynamicTable) {
            super(isamDynamicTable, false);
            this.table = isamDynamicTable;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 >= 0 && n >= 0 && !this.isEmpty()) {
                if (n2 == 0) {
                    return n + 1;
                }
                FcBaseTableModel.RowData rowData = this.getRow(n);
                FcBaseTableModel.CellData cellData = rowData.getData(this.getDataColumnNumber(n2));
                return cellData.getData();
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            FcBaseTableModel.RowData rowData = this.getRow(n);
            FcBaseTableModel.CellData cellData = new FcBaseTableModel.CellData((FcBaseTableModel)this, object);
            rowData.setData(this.getDataColumnNumber(n2), cellData);
            this.fireTableCellUpdated(n, n2);
            try {
                if (((Boolean)this.dirtyColumns.get(n2)).booleanValue()) {
                    int n3 = n;
                    CTSegment cTSegment = null;
                    CTIndex cTIndex = null;
                    if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                        cTIndex = TableSchemaEditor.this.tb.GetIndex(TableSchemaEditor.this.currentIndexNumber);
                        boolean bl = false;
                        do {
                            if (((cTSegment = TableSchemaEditor.this.tb.GetSegment(cTIndex, n3)).GetStatus() & 2) == 2) {
                                bl = true;
                                ++n3;
                                continue;
                            }
                            bl = false;
                        } while (bl);
                    }
                    if (TableSchemaEditor.this.schema.indexes.size() > 0) {
                        Segment segment = TableSchemaEditor.this.currentIndex.segments.get(n);
                        SEGMENT_COLS sEGMENT_COLS = SEGMENT_COLS.fromInt(n2);
                        switch (sEGMENT_COLS) {
                            case FIELD_NAME: {
                                segment.fieldName = object.toString();
                                if (TableSchemaEditor.this.mode != ISAM_MODE.TABLE_MODIFY) break;
                                CTField cTField = TableSchemaEditor.this.tb.GetField(segment.fieldName);
                                cTSegment.SetField(cTField);
                                break;
                            }
                            case MODE: {
                                segment.mode = segModes.GetKey(object.toString());
                                if (TableSchemaEditor.this.mode != ISAM_MODE.TABLE_MODIFY) break;
                                cTSegment.SetMode(segment.mode);
                                break;
                            }
                            case DESC: {
                                segment.descending = (Boolean)object;
                                if (TableSchemaEditor.this.mode != ISAM_MODE.TABLE_MODIFY) break;
                                int n4 = segment.mode;
                                if (segment.descending) {
                                    n4 |= 0x10;
                                }
                                cTSegment.SetMode(n4);
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                Globals.showException(exception, "setValueAt");
            }
        }

        @Override
        public boolean rowChanged(int n) {
            if (!this.hasDirtyColumns) {
                return true;
            }
            return true;
        }

        public void setupColumns() {
            String[] stringArray;
            Object object;
            FontMetrics fontMetrics = Globals.appFrame.getFrame().getFontMetrics(Globals.appFrame.getFrame().getFont());
            ArrayList arrayList = new ArrayList();
            String[] stringArray2 = new String[]{"#", "Field Name", "Mode", "Descending"};
            Integer[] integerArray = new Integer[]{51, 144, 144, 8};
            this.addColumns(stringArray2, integerArray);
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                object = tableColumnModel.getColumn(i);
                stringArray = (String[])this.columnsName.get(this.getDataColumnNumber(i));
                int n = fontMetrics.stringWidth((String)stringArray) + 15;
                ((TableColumn)object).setPreferredWidth(n);
            }
            TableColumn tableColumn = this.table.getColumnModel().getColumn(SEGMENT_COLS.MODE.ordinal());
            object = segModes.values();
            stringArray = new String[object.size()];
            tableColumn.setCellRenderer((TableCellRenderer)new FcComboBoxCellRenderer(object.toArray(stringArray)));
            tableColumn.setCellEditor((TableCellEditor)new FcComboBoxCellEditor(object.toArray(stringArray)));
            this.fieldsCombo = this.table.getColumnModel().getColumn(SEGMENT_COLS.FIELD_NAME.ordinal());
            this.fieldsCombo.setCellRenderer((TableCellRenderer)new FcComboBoxCellRenderer());
            this.fieldsCombo.setCellEditor((TableCellEditor)new FcComboBoxCellEditor());
        }

        @Override
        public void addRecord(boolean bl) {
            if (TableSchemaEditor.this.currentIndex != null && TableSchemaEditor.this.schema.fields.size() > 0) {
                FcBaseTableModel.RowData rowData;
                int n;
                Segment segment = new Segment();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this.getRowCount() + 1);
                for (n = 1; n < this.columnsType.size(); ++n) {
                    this.dirtyColumns.set(n, true);
                    if (n == SEGMENT_COLS.MODE.ordinal()) {
                        arrayList.add("SCHSEG");
                        segment.mode = 12;
                        continue;
                    }
                    if (n == SEGMENT_COLS.FIELD_NAME.ordinal()) {
                        rowData = (FcComboBoxCellRenderer)this.fieldsCombo.getCellRenderer();
                        Object object = rowData.getItemAt(0);
                        arrayList.add(object);
                        segment.fieldName = object.toString();
                        continue;
                    }
                    arrayList.add(this.getDefaultColumnValue((Integer)this.columnsType.get(n)));
                }
                if (bl) {
                    n = this.table.getCurrentRow();
                    if (n < 0) {
                        return;
                    }
                    rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
                    this.insertRow(n, rowData);
                    if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                        try {
                            TableSchemaEditor.this.tb.InsertSegment(TableSchemaEditor.this.currentIndex.name, n, segment.fieldName, segment.mode);
                        }
                        catch (CTException cTException) {
                            Logger.getLogger(TableSchemaEditor.class.getName()).log(Level.SEVERE, null, cTException);
                        }
                    }
                    TableSchemaEditor.this.currentIndex.segments.add(n, segment);
                    this.hasDirtyColumns = true;
                    this.fireTableDataChanged();
                    this.selectRow(n);
                } else {
                    this.addRow(arrayList);
                    if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                        try {
                            TableSchemaEditor.this.tb.AddSegment(TableSchemaEditor.this.currentIndex.name, segment.fieldName, segment.mode);
                        }
                        catch (CTException cTException) {
                            Logger.getLogger(TableSchemaEditor.class.getName()).log(Level.SEVERE, null, cTException);
                        }
                    }
                    TableSchemaEditor.this.currentIndex.segments.add(segment);
                    ++TableSchemaEditor.this.currentIndex.segmentCount;
                    this.hasDirtyColumns = true;
                    this.fireTableDataChanged();
                    this.selectRow(this.getRowCount() - 1);
                }
            }
        }

        @Override
        public void deleteRecord() {
            int n = this.table.getCurrentRow();
            if (n < 0) {
                return;
            }
            TableSchemaEditor.this.currentIndex.segments.remove(n);
            if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                try {
                    CTIndex cTIndex = TableSchemaEditor.this.tb.GetIndex(TableSchemaEditor.this.currentIndexNumber);
                    cTIndex.DelSegment(n);
                }
                catch (CTException cTException) {
                    Logger.getLogger(TableSchemaEditor.class.getName()).log(Level.SEVERE, null, cTException);
                }
            }
            this.deleteRow(n);
            this.fireTableDataChanged();
            if (n < this.getRowCount()) {
                this.selectRow(n);
            }
        }

        public void moveRecord(boolean bl) {
            int n = this.table.getCurrentRow();
            if (bl && (n < 0 || n == this.getRowCount() - 1)) {
                return;
            }
            if (!bl && n <= 0) {
                return;
            }
            Segment segment = TableSchemaEditor.this.currentIndex.segments.get(n);
            FcBaseTableModel.RowData rowData = this.getRow(n);
            TableSchemaEditor.this.currentIndex.segments.remove(n);
            this.deleteRow(n);
            if (bl) {
                TableSchemaEditor.this.currentIndex.segments.add(n + 1, segment);
                this.insertRow(n + 1, rowData);
                if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                    try {
                        TableSchemaEditor.this.tb.MoveSegment(TableSchemaEditor.this.currentIndex.name, n, n + 1);
                    }
                    catch (CTException cTException) {
                        Logger.getLogger(TableSchemaEditor.class.getName()).log(Level.SEVERE, null, cTException);
                    }
                }
                this.fireTableDataChanged();
                this.selectRow(n + 1);
            } else {
                TableSchemaEditor.this.currentIndex.segments.add(n - 1, segment);
                this.insertRow(n - 1, rowData);
                if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                    try {
                        TableSchemaEditor.this.tb.MoveSegment(TableSchemaEditor.this.currentIndex.name, n, n - 1);
                    }
                    catch (CTException cTException) {
                        Logger.getLogger(TableSchemaEditor.class.getName()).log(Level.SEVERE, null, cTException);
                    }
                }
                this.fireTableDataChanged();
                this.selectRow(n - 1);
            }
        }

        @Override
        public void populateIndexSegments(ArrayList<Segment> arrayList) {
            this.clearTable();
            if (arrayList != null) {
                this.clearTable();
                this.numberOfColumns = this.columnsType.size();
                int n = 1;
                for (Segment segment : arrayList) {
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    arrayList2.add(n);
                    arrayList2.add(segment.fieldName);
                    String string = (String)segModes.get(segment.mode);
                    arrayList2.add(string);
                    arrayList2.add(segment.descending);
                    this.addRow(arrayList2);
                    ++n;
                }
                this.fireTableDataChanged();
            }
        }

        private boolean checkIsRowSelected() {
            if (this.table.getCurrentRow() == -1) {
                Globals.showMessage("Please select one row (segment)", "Error");
                return false;
            }
            return true;
        }
    }

    public class SegmentsTable
    extends IsamDynamicTable {
        SegmentsTableModel model;

        public SegmentsTable() {
            super(false);
            this.model = new SegmentsTableModel(this);
            this.setModel(this.model);
            this.model.setupColumns();
            this.model.readOnlyColumns.set(SEGMENT_COLS.NUMBER.ordinal(), true);
        }

        @Override
        public IsamTableModel getModel() {
            return this.model;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            int n = listSelectionModel.getMinSelectionIndex();
            if (!this.inError && this.previousRow >= 0 && !this.model.rowChanged(this.previousRow)) {
                this.inError = true;
                this.editCellAt(this.previousRow, 0);
                this.setRowSelectionInterval(this.previousRow, this.previousRow);
            } else {
                this.inError = false;
                int n2 = -1;
                if (n >= 0) {
                    n2 = this.convertRowIndexToModel(n);
                }
                this.previousRow = n2;
            }
            super.valueChanged(listSelectionEvent);
        }
    }

    public class IndexesTableModel
    extends IsamTableModel {
        IsamDynamicTable table;

        public IndexesTableModel(IsamDynamicTable isamDynamicTable) {
            super(isamDynamicTable, false);
            this.table = isamDynamicTable;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 >= 0 && n >= 0 && !this.isEmpty()) {
                if (n2 == 0) {
                    return n + 1;
                }
                FcBaseTableModel.RowData rowData = this.getRow(n);
                FcBaseTableModel.CellData cellData = rowData.getData(this.getDataColumnNumber(n2));
                return cellData.getData();
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            FcBaseTableModel.RowData rowData = this.getRow(n);
            FcBaseTableModel.CellData cellData = new FcBaseTableModel.CellData((FcBaseTableModel)this, object);
            rowData.setData(this.getDataColumnNumber(n2), cellData);
            this.fireTableCellUpdated(n, n2);
            try {
                if (((Boolean)this.dirtyColumns.get(n2)).booleanValue()) {
                    CTIndex cTIndex = null;
                    if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                        cTIndex = TableSchemaEditor.this.tb.GetIndex(n);
                    }
                    if (TableSchemaEditor.this.schema.indexes.size() > 0) {
                        Index index = TableSchemaEditor.this.schema.indexes.get(n);
                        INDEX_COLS iNDEX_COLS = INDEX_COLS.fromInt(n2);
                        switch (iNDEX_COLS) {
                            case NAME: {
                                index.name = object.toString();
                                if (TableSchemaEditor.this.mode != ISAM_MODE.TABLE_MODIFY) break;
                                cTIndex.SetName(index.name);
                                break;
                            }
                            case FILENAME: {
                                String string = object.toString();
                                if (!string.equals("( Default )")) {
                                    index.fileName = object.toString();
                                }
                                if (TableSchemaEditor.this.mode != ISAM_MODE.TABLE_MODIFY || index.fileName == null) break;
                                cTIndex.SetFilename(TableSchemaEditor.this.pathTB.getText(), index.fileName);
                                break;
                            }
                            case TYPE: {
                                index.type = keyTypes.GetKey(object.toString());
                                if (TableSchemaEditor.this.mode != ISAM_MODE.TABLE_MODIFY) break;
                                cTIndex.SetKeyType(index.type);
                                break;
                            }
                            case DUP_ALLOWED: {
                                boolean bl = index.dupDisallowed = (Boolean)object == false;
                                if (TableSchemaEditor.this.mode != ISAM_MODE.TABLE_MODIFY) break;
                                cTIndex.SetDuplicateFlag(((Boolean)object).booleanValue());
                                break;
                            }
                            case NULL_ALLOWED: {
                                boolean bl = index.nullDisallowed = (Boolean)object == false;
                                if (TableSchemaEditor.this.mode != ISAM_MODE.TABLE_MODIFY) break;
                                cTIndex.SetNullFlag(((Boolean)object).booleanValue());
                                break;
                            }
                            case EMPTY_CHAR: {
                                index.emptyChar = (Integer)object;
                                if (TableSchemaEditor.this.mode != ISAM_MODE.TABLE_MODIFY) break;
                                cTIndex.SetEmptyChar((char)index.emptyChar);
                            }
                        }
                    }
                }
            }
            catch (CTException cTException) {
                Globals.showException(cTException, "setValueAt");
            }
        }

        @Override
        public boolean rowChanged(int n) {
            SegmentsTableModel segmentsTableModel = (SegmentsTableModel)TableSchemaEditor.this.segmentsTable.getModel();
            if (TableSchemaEditor.this.segmentsTable.getCellEditor() != null) {
                TableSchemaEditor.this.segmentsTable.getCellEditor().stopCellEditing();
            }
            if (TableSchemaEditor.this.schema.indexes != null && n < TableSchemaEditor.this.schema.indexes.size()) {
                TableSchemaEditor.this.currentIndex = TableSchemaEditor.this.schema.indexes.get(n);
                TableSchemaEditor.this.currentIndexNumber = n;
                segmentsTableModel.populateIndexSegments(TableSchemaEditor.this.currentIndex.segments);
            } else {
                segmentsTableModel.populateIndexSegments(null);
            }
            if (!this.hasDirtyColumns) {
                return true;
            }
            return true;
        }

        public void setupColumns() {
            String[] stringArray;
            Object object;
            FontMetrics fontMetrics = Globals.appFrame.getFrame().getFontMetrics(Globals.appFrame.getFrame().getFont());
            ArrayList arrayList = new ArrayList();
            String[] stringArray2 = new String[]{"#", "Index Name", "Index Filename", "Type", "Dup Allowed", "Null Allowed", "Empty Char", "Cndx"};
            Integer[] integerArray = new Integer[]{51, 144, 144, 144, 8, 8, 33, 144};
            this.addColumns(stringArray2, integerArray);
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                object = tableColumnModel.getColumn(i);
                stringArray = (String[])this.columnsName.get(this.getDataColumnNumber(i));
                int n = fontMetrics.stringWidth((String)stringArray) + 15;
                ((TableColumn)object).setPreferredWidth(n);
            }
            TableColumn tableColumn = this.table.getColumnModel().getColumn(INDEX_COLS.TYPE.ordinal());
            object = keyTypes.values();
            stringArray = new String[object.size()];
            tableColumn.setCellRenderer((TableCellRenderer)new FcComboBoxCellRenderer(object.toArray(stringArray)));
            tableColumn.setCellEditor((TableCellEditor)new FcComboBoxCellEditor(object.toArray(stringArray)));
        }

        public void addRecord() {
            Index index = new Index();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(this.getRowCount() + 1);
            for (int i = 1; i < this.columnsType.size(); ++i) {
                String string;
                this.dirtyColumns.set(i, true);
                if (i == INDEX_COLS.TYPE.ordinal()) {
                    arrayList.add("FIXED");
                    index.type = 0;
                    continue;
                }
                if (i == INDEX_COLS.NAME.ordinal()) {
                    string = this.createNewIndexName();
                    arrayList.add(string);
                    index.name = string;
                    continue;
                }
                if (i == INDEX_COLS.FILENAME.ordinal()) {
                    string = "( Default )";
                    arrayList.add(string);
                    index.fileName = string;
                    continue;
                }
                if (i == INDEX_COLS.CNDX.ordinal()) {
                    string = "N";
                    arrayList.add(string);
                    index.condition = string;
                    continue;
                }
                arrayList.add(this.getDefaultColumnValue((Integer)this.columnsType.get(i)));
            }
            this.addRow(arrayList);
            TableSchemaEditor.this.schema.indexes.add(index);
            if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                try {
                    TableSchemaEditor.this.tb.AddIndex(index.name, index.type, index.dupDisallowed, index.nullDisallowed);
                }
                catch (CTException cTException) {
                    Logger.getLogger(TableSchemaEditor.class.getName()).log(Level.SEVERE, null, cTException);
                }
            }
            TableSchemaEditor.this.currentIndex = index;
            this.hasDirtyColumns = true;
            this.fireTableDataChanged();
            this.selectRow(this.getRowCount() - 1);
        }

        @Override
        public void deleteRecord() {
            int n = this.table.getCurrentRow();
            if (n < 0) {
                return;
            }
            TableSchemaEditor.this.currentIndex = null;
            TableSchemaEditor.this.schema.indexes.remove(n);
            if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                try {
                    TableSchemaEditor.this.tb.DelIndex(n);
                }
                catch (CTException cTException) {
                    Logger.getLogger(TableSchemaEditor.class.getName()).log(Level.SEVERE, null, cTException);
                }
            }
            this.deleteRow(n);
            this.fireTableDataChanged();
            if (n < this.getRowCount()) {
                this.selectRow(n);
            }
        }

        @Override
        public void populateTableIndexes(ArrayList<Index> arrayList) {
            TableSchemaEditor.this.schema.indexes = arrayList;
            this.clearTable();
            this.numberOfColumns = this.columnsType.size();
            int n = 1;
            for (Index index : arrayList) {
                if (index.isInternal) continue;
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                arrayList2.add(n);
                arrayList2.add(index.name);
                if (index.fileName == null) {
                    arrayList2.add("( Default )");
                } else {
                    arrayList2.add(index.fileName);
                }
                String string = (String)keyTypes.get(index.type);
                arrayList2.add(string);
                arrayList2.add(!index.dupDisallowed);
                arrayList2.add(!index.nullDisallowed);
                arrayList2.add(index.emptyChar);
                arrayList2.add(index.condition == null ? "N" : "Y");
                this.addRow(arrayList2);
                if (TableSchemaEditor.this.currentIndex == null && !index.isInternal) {
                    TableSchemaEditor.this.currentIndex = index;
                    SegmentsTableModel segmentsTableModel = (SegmentsTableModel)TableSchemaEditor.this.segmentsTable.getModel();
                    segmentsTableModel.populateIndexSegments(index.segments);
                }
                ++n;
            }
            this.fireTableDataChanged();
        }

        private String createNewIndexName() {
            Integer n = 1;
            String string = TableSchemaEditor.this.nameTB.getText() + "_idx";
            String string2 = string + n.toString();
            if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                boolean bl;
                int n2 = TableSchemaEditor.this.tb.GetIndexCount();
                block2: do {
                    bl = false;
                    string2 = string + n.toString();
                    String string3 = "";
                    for (int i = 0; i < n2; ++i) {
                        CTIndex cTIndex = null;
                        try {
                            cTIndex = TableSchemaEditor.this.tb.GetIndex(i);
                        }
                        catch (CTException cTException) {
                            Logger.getLogger(TableSchemaEditor.class.getName()).log(Level.SEVERE, null, cTException);
                        }
                        string3 = cTIndex.GetName();
                        if (!string3.toLowerCase().equals(string2.toLowerCase())) continue;
                        bl = true;
                        Integer n3 = n;
                        Integer n4 = n = Integer.valueOf(n + 1);
                        continue block2;
                    }
                } while (bl);
            } else {
                boolean bl;
                block4: do {
                    bl = false;
                    for (Index index : TableSchemaEditor.this.schema.indexes) {
                        string2 = string + n.toString();
                        if (!index.name.toLowerCase().equals(string2.toLowerCase())) continue;
                        bl = true;
                        Integer n5 = n;
                        Integer n6 = n = Integer.valueOf(n + 1);
                        continue block4;
                    }
                } while (bl);
            }
            return string2;
        }

        private boolean checkIsRowSelected() {
            if (this.table.getCurrentRow() == -1) {
                Globals.showMessage("Please select one row (index)", "Error");
                return false;
            }
            return true;
        }
    }

    public class IndexesTable
    extends IsamDynamicTable {
        IndexesTableModel model;

        public IndexesTable() {
            super(false);
            this.model = new IndexesTableModel(this);
            this.setModel(this.model);
            this.model.setupColumns();
            this.model.readOnlyColumns.set(INDEX_COLS.NUMBER.ordinal(), true);
            this.model.readOnlyColumns.set(INDEX_COLS.CNDX.ordinal(), true);
        }

        @Override
        public IsamTableModel getModel() {
            return this.model;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            int n = listSelectionModel.getMinSelectionIndex();
            if (!this.inError && this.previousRow >= 0 && !this.model.rowChanged(this.previousRow)) {
                this.inError = true;
                this.editCellAt(this.previousRow, 0);
                this.setRowSelectionInterval(this.previousRow, this.previousRow);
            } else {
                this.inError = false;
                int n2 = -1;
                if (n >= 0) {
                    n2 = this.convertRowIndexToModel(n);
                }
                this.previousRow = n2;
            }
            super.valueChanged(listSelectionEvent);
        }
    }

    public class FieldsTableModel
    extends IsamTableModel {
        FieldsTable table;

        public FieldsTableModel(FieldsTable fieldsTable) {
            super(fieldsTable, true);
            this.table = fieldsTable;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 >= 0 && n >= 0 && !this.isEmpty()) {
                if (n2 == 0) {
                    return n + 1;
                }
                FcBaseTableModel.RowData rowData = this.getRow(n);
                FcBaseTableModel.CellData cellData = rowData.getData(this.getDataColumnNumber(n2));
                return cellData.getData();
            }
            return null;
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Override
        public void setValueAt(Object var1_1, int var2_2, int var3_3) {
            block30: {
                var4_4 = this.getRow(var2_2);
                var5_5 = new FcBaseTableModel.CellData((FcBaseTableModel)this, var1_1);
                var4_4.setData(this.getDataColumnNumber(var3_3), var5_5);
                this.fireTableCellUpdated(var2_2, var3_3);
                try {
                    if (!((Boolean)this.dirtyColumns.get(var3_3)).booleanValue()) break block30;
                    var6_6 = null;
                    if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                        var6_6 = TableSchemaEditor.this.tb.GetField(var2_2);
                    }
                    if (TableSchemaEditor.this.schema.fields.size() <= 0) break block30;
                    var7_8 = TableSchemaEditor.this.schema.fields.get(var2_2);
                    var8_9 = var7_8.name;
                    var9_10 = FIELD_COLS.fromInt(var3_3);
                    switch (18.$SwitchMap$ctreeaceexplorer$TableSchemaEditor$FIELD_COLS[var9_10.ordinal()]) {
                        case 1: {
                            var10_11 = var1_1.toString();
                            for (Object var12_15 : TableSchemaEditor.this.schema.fields) {
                                if (var12_15 == var7_8 || !var12_15.name.equals(var10_11)) continue;
                                Globals.showMessage("A field with the same name already exist", "Fieldname Error");
                            }
                            var7_8.name = var10_11;
                            if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                                var6_6.SetName(var10_11);
                            }
                            for (Object var12_15 : TableSchemaEditor.this.schema.indexes) {
                                for (Segment var14_19 : var12_15.segments) {
                                    if (var14_19.fieldName != var8_9) continue;
                                    var14_19.fieldName = var10_11;
                                }
                            }
                            break;
                        }
                        case 2: {
                            var11_13 = var1_1.toString();
                            var7_8.type = FieldsTableModel.fieldTypes.GetKey(var11_13);
                            this.setValueAt("-", var2_2, FIELD_COLS.PRECISION.ordinal());
                            this.setValueAt("-", var2_2, FIELD_COLS.SCALE.ordinal());
                            switch (var7_8.type) {
                                case 8: 
                                case 16: 
                                case 24: {
                                    this.setValueAt(1, var2_2, FIELD_COLS.LENGTH.ordinal());
                                    break;
                                }
                                case 33: 
                                case 41: {
                                    this.setValueAt(2, var2_2, FIELD_COLS.LENGTH.ordinal());
                                    break;
                                }
                                case 51: 
                                case 59: 
                                case 67: 
                                case 75: 
                                case 83: 
                                case 91: {
                                    this.setValueAt(4, var2_2, FIELD_COLS.LENGTH.ordinal());
                                    break;
                                }
                                case 103: 
                                case 119: 
                                case 124: 
                                case 143: 
                                case 231: 
                                case 239: {
                                    this.setValueAt(8, var2_2, FIELD_COLS.LENGTH.ordinal());
                                    break;
                                }
                                case 105: {
                                    this.setValueAt(0, var2_2, FIELD_COLS.PRECISION.ordinal());
                                    this.setValueAt(0, var2_2, FIELD_COLS.SCALE.ordinal());
                                    this.setValueAt(20, var2_2, FIELD_COLS.LENGTH.ordinal());
                                }
                            }
                            switch (var7_8.type) {
                                case 8: 
                                case 67: 
                                case 75: 
                                case 83: 
                                case 91: 
                                case 103: 
                                case 105: 
                                case 119: 
                                case 124: 
                                case 143: 
                                case 239: {
                                    this.setValueAt(0L, var2_2, FIELD_COLS.SEED.ordinal());
                                    this.setValueAt(0L, var2_2, FIELD_COLS.INCREMENT.ordinal());
                                    this.setValueAt(false, var2_2, FIELD_COLS.IDENTITY.ordinal());
                                    var7_8.isIdentity = false;
                                }
                            }
                            if (TableSchemaEditor.this.mode != ISAM_MODE.TABLE_MODIFY) break;
                            var6_6.SetType(var7_8.type, var7_8.length);
                            break;
                        }
                        case 3: {
                            var7_8.length = (Integer)var1_1;
                            if (TableSchemaEditor.this.mode != ISAM_MODE.TABLE_MODIFY) break;
                            var6_6.SetLength(var7_8.length);
                            break;
                        }
                        case 4: {
                            var7_8.nullAllowed = (Boolean)var1_1;
                            if (TableSchemaEditor.this.mode != ISAM_MODE.TABLE_MODIFY) break;
                            var6_6.SetNullFlag(var7_8.nullAllowed == false);
                            break;
                        }
                        case 5: {
                            var11_14 = var1_1.toString();
                            var7_8.binFlag = FieldsTableModel.binaryFlags.GetKey(var11_14);
                            if (TableSchemaEditor.this.mode != ISAM_MODE.TABLE_MODIFY) break;
                            var6_6.SetFieldBinaryFlag(var7_8.binFlag);
                            break;
                        }
                        case 6: {
                            if (var1_1.getClass() == String.class) break;
                            var7_8.precision = (Integer)var1_1;
                            if (TableSchemaEditor.this.mode != ISAM_MODE.TABLE_MODIFY) break;
                            var6_6.SetPrecision(var7_8.precision);
                            break;
                        }
                        case 7: {
                            if (var1_1.getClass() == String.class) break;
                            var7_8.scale = (Integer)var1_1;
                            if (TableSchemaEditor.this.mode != ISAM_MODE.TABLE_MODIFY) break;
                            var6_6.SetScale(var7_8.scale);
                            break;
                        }
                        case 8: {
                            if (!((Boolean)var1_1).booleanValue()) ** GOTO lbl99
                            for (Field var13_18 : TableSchemaEditor.this.schema.fields) {
                                if (var13_18 == var7_8 || !var13_18.isIdentity) continue;
                                Globals.showMessage("An identity field already exist", "Fieldname Error");
                                this.setValueAt(false, var2_2, var3_3);
                                this.fireTableCellUpdated(var2_2, var3_3);
                                ** GOTO lbl102
                            }
                            ** GOTO lbl102
lbl99:
                            // 1 sources

                            this.setValueAt(0L, var2_2, var3_3 + 1);
                            this.setValueAt(0L, var2_2, var3_3 + 2);
                            this.fireTableCellUpdated(var2_2, var3_3);
lbl102:
                            // 3 sources

                            var7_8.isIdentity = (Boolean)var1_1;
                            break;
                        }
                        case 9: {
                            var7_8.seed = (Long)var1_1;
                            break;
                        }
                        case 10: {
                            var7_8.increment = (Long)var1_1;
                        }
                    }
                }
                catch (Exception var6_7) {
                    Globals.showException(var6_7, "setValueAt");
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (this.readOnlyColumns != null && ((Boolean)this.readOnlyColumns.get(n2)).booleanValue()) {
                return false;
            }
            if (n2 == FIELD_COLS.SEED.ordinal() || n2 == FIELD_COLS.INCREMENT.ordinal()) {
                Field field = TableSchemaEditor.this.schema.fields.get(n);
                if (!field.isIdentity) {
                    return false;
                }
            } else if (n2 == FIELD_COLS.PRECISION.ordinal() || n2 == FIELD_COLS.SCALE.ordinal()) {
                Field field = TableSchemaEditor.this.schema.fields.get(n);
                if (field.type != 105) {
                    return false;
                }
            } else if (n2 == FIELD_COLS.LENGTH.ordinal()) {
                Field field = TableSchemaEditor.this.schema.fields.get(n);
                switch (field.type) {
                    case 8: 
                    case 16: 
                    case 24: 
                    case 33: 
                    case 41: 
                    case 51: 
                    case 59: 
                    case 67: 
                    case 75: 
                    case 83: 
                    case 91: 
                    case 103: 
                    case 105: 
                    case 119: 
                    case 124: 
                    case 143: 
                    case 231: 
                    case 239: {
                        return false;
                    }
                }
            } else if (n2 == FIELD_COLS.IDENTITY.ordinal()) {
                Field field = TableSchemaEditor.this.schema.fields.get(n);
                switch (field.type) {
                    case 8: 
                    case 67: 
                    case 75: 
                    case 83: 
                    case 91: 
                    case 103: 
                    case 105: 
                    case 119: 
                    case 124: 
                    case 143: 
                    case 239: {
                        return false;
                    }
                }
            } else if (n2 == FIELD_COLS.BINARY_FLAG.ordinal()) {
                Field field = TableSchemaEditor.this.schema.fields.get(n);
                switch (field.type) {
                    case 162: 
                    case 170: {
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean rowChanged(int n) {
            if (!this.hasDirtyColumns) {
                return true;
            }
            return true;
        }

        public void setupFieldsTable() {
            String[] stringArray;
            Object object;
            FontMetrics fontMetrics = Globals.appFrame.getFrame().getFontMetrics(Globals.appFrame.getFrame().getFont());
            ArrayList arrayList = new ArrayList();
            String[] stringArray2 = new String[]{"#", "Field Name", "Type", "Length", "Null Allowed", "Binary Flag", "Precision", "Scale", "Identity", "Seed", "Increment"};
            Integer[] integerArray = new Integer[]{51, 144, 144, 51, 8, 144, 51, 51, 8, 231, 231};
            this.clearTable();
            this.addColumns(stringArray2, integerArray);
            super.fireTableStructureChanged();
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                object = tableColumnModel.getColumn(i);
                stringArray = (String[])this.columnsName.get(this.getDataColumnNumber(i));
                int n = fontMetrics.stringWidth((String)stringArray) + 15;
                ((TableColumn)object).setPreferredWidth(n);
            }
            TableColumn tableColumn = this.table.getColumnModel().getColumn(FIELD_COLS.TYPE.ordinal());
            object = fieldTypes.values();
            stringArray = new String[object.size()];
            tableColumn.setCellRenderer((TableCellRenderer)new FcComboBoxCellRenderer(object.toArray(stringArray)));
            tableColumn.setCellEditor((TableCellEditor)new FcComboBoxCellEditor(object.toArray(stringArray)));
            tableColumn = this.table.getColumnModel().getColumn(FIELD_COLS.BINARY_FLAG.ordinal());
            Collection collection = binaryFlags.values();
            stringArray = new String[collection.size()];
            tableColumn.setCellRenderer((TableCellRenderer)new FcComboBoxCellRenderer(collection.toArray(stringArray)));
            tableColumn.setCellEditor((TableCellEditor)new FcComboBoxCellEditor(collection.toArray(stringArray)));
        }

        @Override
        public void addRecord(boolean bl) {
            Object object;
            int n;
            Field field = new Field();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(this.getRowCount() + 1);
            for (n = 1; n < this.columnsType.size(); ++n) {
                this.dirtyColumns.set(n, true);
                if (n == FIELD_COLS.TYPE.ordinal()) {
                    arrayList.add("CT_CHAR");
                    field.type = fieldTypes.GetKey("CT_CHAR");
                    field.length = 1;
                    continue;
                }
                if (n == FIELD_COLS.LENGTH.ordinal()) {
                    arrayList.add(1);
                    continue;
                }
                if (n == FIELD_COLS.BINARY_FLAG.ordinal()) {
                    arrayList.add(null);
                    continue;
                }
                if (n == FIELD_COLS.NAME.ordinal()) {
                    object = this.createNewFieldName();
                    arrayList.add(object);
                    field.name = object;
                    continue;
                }
                if (n == FIELD_COLS.PRECISION.ordinal() || n == FIELD_COLS.SCALE.ordinal()) {
                    arrayList.add("-");
                    continue;
                }
                arrayList.add(this.getDefaultColumnValue((Integer)this.columnsType.get(n)));
            }
            if (bl) {
                n = this.table.getCurrentRow();
                if (n < 0) {
                    return;
                }
                this.table.schema.fields.add(n, field);
                object = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
                this.insertRow(n, (FcBaseTableModel.RowData)object);
                this.addRow(arrayList);
                this.hasDirtyColumns = true;
                this.fireTableDataChanged();
                this.selectRow(n);
                if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                    try {
                        TableSchemaEditor.this.tb.InsertField(n, field.name, field.type, field.length);
                    }
                    catch (CTException cTException) {
                        Globals.showException(cTException, "Insert Field");
                    }
                }
            } else {
                this.table.schema.fields.add(field);
                this.addRow(arrayList);
                this.hasDirtyColumns = true;
                this.fireTableDataChanged();
                this.selectRow(this.getRowCount() - 1);
                if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                    try {
                        TableSchemaEditor.this.tb.AddField(field.name, field.type, field.length);
                    }
                    catch (CTException cTException) {
                        Globals.showException(cTException, "Add Field");
                    }
                }
            }
        }

        private String createNewFieldName() {
            Integer n = 1;
            String string = "field";
            String string2 = string + n.toString();
            if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                Boolean bl;
                Integer n2 = TableSchemaEditor.this.tb.GetFieldCount();
                block2: do {
                    bl = false;
                    string2 = string + n.toString();
                    String string3 = "";
                    for (int i = 0; i < n2; ++i) {
                        CTField cTField = null;
                        try {
                            cTField = TableSchemaEditor.this.tb.GetField(i);
                        }
                        catch (CTException cTException) {
                            Logger.getLogger(TableSchemaEditor.class.getName()).log(Level.SEVERE, null, cTException);
                        }
                        string3 = cTField.GetName();
                        if (!string3.toLowerCase().equals(string2.toLowerCase())) continue;
                        bl = true;
                        Integer n3 = n;
                        Integer n4 = n = Integer.valueOf(n + 1);
                        continue block2;
                    }
                } while (bl.booleanValue());
            } else {
                Boolean bl;
                block4: do {
                    bl = false;
                    for (Field field : TableSchemaEditor.this.schema.fields) {
                        string2 = string + n.toString();
                        if (!field.name.toLowerCase().equals(string2.toLowerCase())) continue;
                        bl = true;
                        Integer n5 = n;
                        Integer n6 = n = Integer.valueOf(n + 1);
                        continue block4;
                    }
                } while (bl.booleanValue());
            }
            return string2;
        }

        @Override
        public void deleteRecord() {
            int n = this.table.getCurrentRow();
            if (n < 0) {
                return;
            }
            this.table.schema.fields.remove(n);
            this.deleteRow(n);
            if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                try {
                    TableSchemaEditor.this.tb.DeleteField(n);
                }
                catch (CTException cTException) {
                    Globals.showException(cTException, "Move Field");
                }
            }
            this.fireTableDataChanged();
            if (n < this.getRowCount()) {
                this.selectRow(n);
            }
        }

        public void moveRecord(boolean bl) {
            int n = this.table.getCurrentRow();
            if (bl && (n < 0 || n == this.getRowCount() - 1)) {
                return;
            }
            if (!bl && n <= 0) {
                return;
            }
            Field field = this.table.schema.fields.get(n);
            FcBaseTableModel.RowData rowData = this.getRow(n);
            this.table.schema.fields.remove(n);
            this.deleteRow(n);
            if (bl) {
                this.table.schema.fields.add(n + 1, field);
                this.insertRow(n + 1, rowData);
                this.selectRow(n + 1);
                if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                    try {
                        TableSchemaEditor.this.tb.MoveField(n, n + 1);
                    }
                    catch (CTException cTException) {
                        Globals.showException(cTException, "Move Field");
                    }
                }
            } else {
                this.table.schema.fields.add(n - 1, field);
                this.insertRow(n - 1, rowData);
                this.selectRow(n - 1);
                if (TableSchemaEditor.this.mode == ISAM_MODE.TABLE_MODIFY) {
                    try {
                        TableSchemaEditor.this.tb.MoveField(n, n - 1);
                    }
                    catch (CTException cTException) {
                        Globals.showException(cTException, "Move Field");
                    }
                }
            }
        }

        @Override
        public void populateTableFields(ArrayList<Field> arrayList) {
            int n = 1;
            for (Field field : arrayList) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                arrayList2.add(n);
                arrayList2.add(field.name);
                String string = (String)fieldTypes.get(field.type);
                arrayList2.add(string);
                arrayList2.add(field.length);
                arrayList2.add(field.nullAllowed);
                if (field.type == 162 || field.type == 170) {
                    arrayList2.add(binaryFlags.get(field.binFlag));
                } else {
                    arrayList2.add(binaryFlags.get(0));
                }
                if (field.type == 105) {
                    arrayList2.add(field.precision);
                    arrayList2.add(field.scale);
                } else {
                    arrayList2.add("-");
                    arrayList2.add("-");
                }
                if (field.isIdentity) {
                    arrayList2.add(true);
                    arrayList2.add(field.seed);
                    arrayList2.add(field.increment);
                } else {
                    arrayList2.add(false);
                    arrayList2.add(null);
                    arrayList2.add(null);
                }
                this.addRow(arrayList2);
                ++n;
            }
            this.fireTableDataChanged();
        }

        private boolean checkIsRowSelected() {
            if (this.table.getCurrentRow() == -1) {
                Globals.showMessage("Please select one row (field)", "Error");
                return false;
            }
            return true;
        }
    }

    public class FieldsTable
    extends IsamDynamicTable {
        private FieldsTableModel model;
        public TableSchema schema;

        public FieldsTable() {
            super(false);
            this.model = new FieldsTableModel(this);
            this.setModel(this.model);
            this.model.setupFieldsTable();
            this.model.readOnlyColumns.set(FIELD_COLS.NUMBER.ordinal(), true);
        }

        @Override
        public FieldsTableModel getModel() {
            return this.model;
        }
    }

    private static enum SEGMENT_COLS {
        NUMBER,
        FIELD_NAME,
        MODE,
        DESC;


        public static SEGMENT_COLS fromInt(int n) {
            return SEGMENT_COLS.values()[n];
        }
    }

    private static enum INDEX_COLS {
        NUMBER,
        NAME,
        FILENAME,
        TYPE,
        DUP_ALLOWED,
        NULL_ALLOWED,
        EMPTY_CHAR,
        CNDX;


        public static INDEX_COLS fromInt(int n) {
            return INDEX_COLS.values()[n];
        }
    }

    private static enum FIELD_COLS {
        NUMBER,
        NAME,
        TYPE,
        LENGTH,
        NULL,
        BINARY_FLAG,
        PRECISION,
        SCALE,
        IDENTITY,
        SEED,
        INCREMENT;


        public static FIELD_COLS fromInt(int n) {
            return FIELD_COLS.values()[n];
        }
    }
}

