/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer;

import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.EXIT_CODE;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.sql.CreateSqlTable;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class Warnings
extends JDialog {
    private String warningText;
    private String errorMessage;
    private int ErrorPosition;
    JPopupMenu contextMenu;
    PopupActions popupActions;
    static int fontSize = 12;
    EXIT_CODE returnCode = EXIT_CODE.OK;
    Style redStyle;
    Style nullStyle;
    private int lowindex;
    private int highindex;
    private JButton closeBT;
    private JButton executeBT;
    private JTextPane infoTB;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton nextBT;
    private JTextPane textArea;
    private JButton zoomInBT;
    private JButton zoomOutBT;

    public Warnings(Frame frame, boolean bl) {
        super(frame, bl);
        this.getRootPane().setDefaultButton(this.closeBT);
        this.initComponents();
        this.redStyle = this.infoTB.addStyle("Red", null);
        this.nullStyle = this.infoTB.addStyle("Null", null);
        StyleConstants.setForeground(this.redStyle, Color.red);
        this.textArea.addMouseListener(new PopupListener(this.textArea));
        this.popupActions = new PopupActions(this.textArea);
        this.contextMenu = new JPopupMenu("Edit");
        this.contextMenu.add(this.makeMenuItem("Surround with Double Quotes", this.popupActions));
        this.contextMenu.add(this.makeMenuItem("Remove Double Quotes", this.popupActions));
    }

    private JMenuItem makeMenuItem(String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.executeBT = new JButton();
        this.closeBT = new JButton();
        this.nextBT = new JButton();
        this.jPanel2 = new JPanel();
        this.zoomInBT = new JButton();
        this.zoomOutBT = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.infoTB = new JTextPane();
        this.jScrollPane1 = new JScrollPane();
        this.textArea = new JTextPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("Conversion Warnings");
        this.jPanel1.setName("jPanel1");
        this.executeBT.setText("Save To File");
        this.executeBT.setName("executeBT");
        this.executeBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Warnings.this.executeBTActionPerformed(actionEvent);
            }
        });
        this.closeBT.setText("Close");
        this.closeBT.setName("closeBT");
        this.closeBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Warnings.this.closeBTActionPerformed(actionEvent);
            }
        });
        this.nextBT.setText("Next View");
        this.nextBT.setName("nextBT");
        this.nextBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Warnings.this.nextBTActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(196, 196, 196).addComponent(this.executeBT).addGap(36, 36, 36).addComponent(this.closeBT, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 76, Short.MAX_VALUE).addComponent(this.nextBT).addGap(36, 36, 36)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(13, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nextBT).addComponent(this.closeBT).addComponent(this.executeBT)).addContainerGap()));
        this.jPanel2.setName("jPanel2");
        this.zoomInBT.setIcon(new ImageIcon(this.getClass().getResource("/ctreeaceexplorer/images/ZoomIn.png")));
        this.zoomInBT.setName("zoomInBT");
        this.zoomInBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Warnings.this.zoomInBTActionPerformed(actionEvent);
            }
        });
        this.zoomOutBT.setIcon(new ImageIcon(this.getClass().getResource("/ctreeaceexplorer/images/ZoomOut.png")));
        this.zoomOutBT.setName("zoomOutBT");
        this.zoomOutBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Warnings.this.zoomOutBTActionPerformed(actionEvent);
            }
        });
        this.jScrollPane2.setBorder(null);
        this.jScrollPane2.setName("jScrollPane2");
        this.infoTB.setBorder(null);
        this.infoTB.setEditable(false);
        this.infoTB.setFont(new Font("Tahoma", 1, 11));
        this.infoTB.setForeground(Color.blue);
        this.infoTB.setName("infoTB");
        this.infoTB.setOpaque(false);
        this.jScrollPane2.setViewportView(this.infoTB);
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 496, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.zoomOutBT, -2, 29, -2).addGap(10, 10, 10).addComponent(this.zoomInBT, -2, 29, -2).addGap(21, 21, 21)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 81, Short.MAX_VALUE)).addGroup(groupLayout2.createSequentialGroup().addGap(33, 33, 33).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.zoomOutBT).addComponent(this.zoomInBT)).addContainerGap(34, Short.MAX_VALUE)));
        this.jScrollPane1.setName("jScrollPane1");
        this.textArea.setFont(new Font("Tahoma", 0, 12));
        this.textArea.setName("textArea");
        this.jScrollPane1.setViewportView(this.textArea);
        GroupLayout groupLayout3 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 601, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 246, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void zoomInBTActionPerformed(ActionEvent actionEvent) {
        this.textArea.setFont(new Font("Tahoma", 0, ++fontSize));
    }

    private void zoomOutBTActionPerformed(ActionEvent actionEvent) {
        this.textArea.setFont(new Font("Tahoma", 0, --fontSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBTActionPerformed(ActionEvent actionEvent) {
        String string = this.executeBT.getText();
        if (string.equals("Execute")) {
            this.returnCode = EXIT_CODE.OK;
            this.setVisible(false);
        } else {
            JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
            JFileChooser jFileChooser = new JFileChooser();
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("text files (*.txt)", "txt");
            jFileChooser.setFileFilter(fileNameExtensionFilter);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setCurrentDirectory(new File(Globals.execDir));
            int n = jFileChooser.showSaveDialog(jFrame);
            if (n == 0) {
                OutputStreamWriter outputStreamWriter = null;
                try {
                    File file = jFileChooser.getSelectedFile();
                    String string2 = file.getAbsolutePath();
                    if (!string2.isEmpty() && !string2.contains(".t")) {
                        string2 = string2 + ".txt";
                    }
                    outputStreamWriter = new FileWriter(string2);
                    outputStreamWriter.write(this.textArea.getText());
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    Globals.showException(iOException, "Save File");
                }
                finally {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(CreateSqlTable.class.getName()).log(Level.SEVERE, null, iOException);
                    }
                }
            }
        }
    }

    private void closeBTActionPerformed(ActionEvent actionEvent) {
        this.returnCode = EXIT_CODE.ABORT;
        this.setVisible(false);
    }

    private void nextBTActionPerformed(ActionEvent actionEvent) {
        this.returnCode = EXIT_CODE.RETRY;
        this.setVisible(false);
    }

    public EXIT_CODE showDialog(boolean bl, String string) {
        if (bl) {
            this.textArea.setText(this.warningText);
            this.infoTB.setText("Conversion completed with the following warnings / errors:");
            this.nextBT.setVisible(false);
            this.getRootPane().setDefaultButton(this.closeBT);
            this.closeBT.requestFocus();
            this.setVisible(true);
            return this.returnCode;
        }
        this.textArea.setFont(new Font("Tahoma", 0, fontSize));
        this.setTitle("Create " + string);
        String string2 = "Create " + string + " failed with the following error:\r\n";
        this.infoTB.setText(string2);
        String string3 = string2 + this.errorMessage;
        string3 = string3 + "\r\nTry to edit and reexecute the statement.\r\n( Look for missing double quotes around objects names - Right click to add them)";
        this.infoTB.setText(string3);
        StyledDocument styledDocument = (StyledDocument)this.infoTB.getDocument();
        styledDocument.setCharacterAttributes(string2.length() - 1, this.errorMessage.length(), this.redStyle, true);
        this.infoTB.setSelectionColor(Color.red);
        this.textArea.setText(this.warningText);
        styledDocument = (StyledDocument)this.textArea.getDocument();
        styledDocument.setCharacterAttributes(0, this.warningText.length(), this.nullStyle, true);
        styledDocument.setCharacterAttributes(this.ErrorPosition, 1, this.redStyle, true);
        this.getRootPane().setDefaultButton(this.closeBT);
        this.executeBT.setText("Execute");
        this.closeBT.requestFocus();
        this.setVisible(true);
        return this.returnCode;
    }

    public String getWarningText() {
        return this.textArea.getText();
    }

    public void setWarningText(String string) {
        this.warningText = string;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public void setErrorPosition(int n) {
        this.ErrorPosition = n;
    }

    class PopupActions
    implements ActionListener {
        JTextPane pane;

        public PopupActions(JTextPane jTextPane) {
            this.pane = jTextPane;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.pane.getText();
            String string2 = actionEvent.getActionCommand();
            if (string2.equals("Surround with Double Quotes")) {
                string = string.substring(0, Warnings.this.lowindex) + "\"" + string.substring(Warnings.this.lowindex, Warnings.this.highindex - 1) + "\"" + string.substring(Warnings.this.highindex - 1);
                this.pane.setText(string);
            } else if (string2.equals("Remove Double Quotes")) {
                if (Warnings.this.lowindex == 0) {
                    Warnings.this.lowindex = 1;
                }
                if (Warnings.this.lowindex > 0 && string.charAt(Warnings.this.lowindex - 1) == '\"') {
                    string = string.substring(0, Warnings.this.lowindex - 1) + string.substring(Warnings.this.lowindex, Warnings.this.highindex - 1) + string.substring(Warnings.this.highindex);
                    this.pane.setText(string);
                }
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        JTextPane pane;

        public PopupListener(JTextPane jTextPane) {
            this.pane = jTextPane;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getButton();
            if (n == 3) {
                try {
                    Robot robot = new Robot();
                    robot.mousePress(16);
                }
                catch (AWTException aWTException) {
                    Logger.getLogger(Warnings.class.getName()).log(Level.SEVERE, null, aWTException);
                }
            } else {
                Component component = mouseEvent.getComponent();
                if (component.getClass() == JTextPane.class) {
                    String string = this.pane.getText();
                    int n2 = this.pane.getCaretPosition();
                    Warnings.this.lowindex = (Warnings.this.highindex = n2);
                    char c = string.charAt(n2);
                    while (Warnings.this.lowindex > -1 && !Character.isWhitespace(c) && Character.isLetterOrDigit(c) || c == '_') {
                        c = string.charAt(Warnings.this.lowindex--);
                    }
                    if (Warnings.this.lowindex == -1) {
                        Warnings.this.lowindex = 0;
                    } else {
                        Warnings.this.lowindex += 2;
                    }
                    c = string.charAt(Warnings.this.highindex++);
                    while (Character.isLetterOrDigit(c) || c == '_') {
                        c = string.charAt(Warnings.this.highindex++);
                    }
                }
                this.maybeShowPopup(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                Warnings.this.contextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

