/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.Helper.Editors.FcBooleanCellEditor;
import FairCom.Helper.Editors.FcComboBoxCellEditor;
import FairCom.Helper.Renderers.FcBooleanCellRenderer;
import FairCom.Helper.Renderers.FcComboBoxCellRenderer;
import ctree.jdbc.CtreeSQLException;
import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.sql.CreateSqlTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class CreateIndex
extends JDialog {
    String tableName = "";
    String tableOwner = "";
    ColumnsTable cTable = new ColumnsTable();
    private JScrollPane columnsScrollPane;
    private JButton createButton;
    private JButton downRowBT;
    private JButton exitButton;
    private JTextField indexNameTB;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JCheckBox partitionCB;
    private JButton saveButton;
    private JTextArea statementTA;
    private JComboBox<String> tableNameCB;
    private JCheckBox uniqueCB;
    private JButton upRowBT;

    public CreateIndex(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.setIconImage(Globals.getIcon("Table.png").getImage());
        this.columnsScrollPane.setViewportView((Component)((Object)this.cTable));
        this.cTable.showRowHeader(this.columnsScrollPane);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.createButton = new JButton();
        this.exitButton = new JButton();
        this.jPanel3 = new JPanel();
        this.saveButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.statementTA = new JTextArea();
        this.jPanel2 = new JPanel();
        this.columnsScrollPane = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel5 = new JPanel();
        this.upRowBT = new JButton();
        this.downRowBT = new JButton();
        this.uniqueCB = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.indexNameTB = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.tableNameCB = new JComboBox();
        this.partitionCB = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Create Index");
        this.jPanel1.setName("jPanel1");
        this.createButton.setMnemonic('O');
        this.createButton.setText("Create");
        this.createButton.setName("createButton");
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateIndex.this.createButtonActionPerformed(actionEvent);
            }
        });
        this.exitButton.setMnemonic('A');
        this.exitButton.setText("Exit");
        this.exitButton.setName("exitButton");
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateIndex.this.exitButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(160, 160, 160).addComponent(this.createButton, -2, 75, -2).addGap(57, 57, 57).addComponent(this.exitButton, -2, 71, -2).addContainerGap(173, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createButton).addComponent(this.exitButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Resulting Statement", 0, 0, null, Color.blue));
        this.jPanel3.setName("jPanel3");
        this.saveButton.setText("Save Statement");
        this.saveButton.setName("saveButton");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateIndex.this.saveButtonActionPerformed(actionEvent);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.statementTA.setColumns(1);
        this.statementTA.setFont(new Font("Tahoma", 0, 11));
        this.statementTA.setLineWrap(true);
        this.statementTA.setRows(10);
        this.statementTA.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.statementTA.setName("statementTA");
        this.jScrollPane1.setViewportView(this.statementTA);
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 524, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGap(197, 197, 197).addComponent(this.saveButton).addContainerGap(218, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.jScrollPane1, -1, 59, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveButton)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Columns", 0, 0, null, Color.blue));
        this.jPanel2.setName("jPanel2");
        this.columnsScrollPane.setBorder(BorderFactory.createTitledBorder(""));
        this.columnsScrollPane.setName("columnsScrollPane");
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Title 1", "Title 2"}));
        this.jTable1.setName("jTable1");
        this.columnsScrollPane.setViewportView(this.jTable1);
        this.jPanel5.setName("jPanel5");
        this.upRowBT.setIcon(new ImageIcon(this.getClass().getResource("/ctreeaceexplorer/images/Arrowup.png")));
        this.upRowBT.setToolTipText("Move Up");
        this.upRowBT.setName("upRowBT");
        this.upRowBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateIndex.this.upRowBTActionPerformed(actionEvent);
            }
        });
        this.downRowBT.setIcon(new ImageIcon(this.getClass().getResource("/ctreeaceexplorer/images/Arrowdown.png")));
        this.downRowBT.setToolTipText("Move Down");
        this.downRowBT.setName("downRowBT");
        this.downRowBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateIndex.this.downRowBTActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout3 = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.upRowBT, -2, 25, -2).addContainerGap()).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.downRowBT, -2, 25, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.upRowBT).addGap(18, 18, 18).addComponent(this.downRowBT).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout4 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addComponent(this.columnsScrollPane, -1, 475, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, 43, -2)));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jPanel5, -2, -1, -2).addContainerGap(19, Short.MAX_VALUE)).addComponent(this.columnsScrollPane, -1, 120, Short.MAX_VALUE));
        this.uniqueCB.setText("UNIQUE");
        this.uniqueCB.setName("uniqueCB");
        this.uniqueCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateIndex.this.uniqueCBActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setText("CREATE ");
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText("INDEX");
        this.jLabel2.setName("jLabel2");
        this.indexNameTB.setName("indexNameTB");
        this.indexNameTB.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CreateIndex.this.indexNameTBFocusLost(focusEvent);
            }
        });
        this.jLabel3.setText("Index Name :");
        this.jLabel3.setName("jLabel3");
        this.jLabel4.setText("ON");
        this.jLabel4.setName("jLabel4");
        this.jLabel5.setText("Tale Name :");
        this.jLabel5.setName("jLabel5");
        this.tableNameCB.setName("tableNameCB");
        this.tableNameCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateIndex.this.tableNameCBActionPerformed(actionEvent);
            }
        });
        this.partitionCB.setText("STORAGE_ATTRIBUTES 'PARTITION'");
        this.partitionCB.setName("partitionCB");
        this.partitionCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateIndex.this.partitionCBActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout5 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(groupLayout5.createSequentialGroup().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addGap(169, 169, 169).addComponent(this.jLabel3)).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.partitionCB).addGroup(groupLayout5.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.uniqueCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.indexNameTB, -1, 149, Short.MAX_VALUE))))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4).addGap(18, 18, 18).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tableNameCB, -2, 146, -2).addComponent(this.jLabel5)).addGap(29, 29, 29)).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.uniqueCB).addComponent(this.jLabel2).addComponent(this.indexNameTB, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.tableNameCB, -2, -1, -2)).addGap(5, 5, 5).addComponent(this.partitionCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void createButtonActionPerformed(ActionEvent actionEvent) {
        if (this.indexNameTB.getText().isEmpty()) {
            Globals.showMessage("Missing Index Name", "Error");
            return;
        }
        try {
            Globals.currentSqlConnection.executeUpdate(this.statementTA.getText());
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "Create Index Error");
            CtreeSQLException cfr_ignored_0 = (CtreeSQLException)sQLException;
            Globals.appFrame.showErrorPos(sQLException.getErrorCode(), CtreeSQLException.getErrorPosition(), this.statementTA.getText(), this.statementTA);
            return;
        }
        Globals.showOKMessage("Index Successfully Created", "Create Index");
    }

    private void exitButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveButtonActionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        JFileChooser jFileChooser = new JFileChooser();
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("script files (*.sql)", "sql");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setCurrentDirectory(new File(Globals.execDir));
        int n = jFileChooser.showSaveDialog(jFrame);
        if (n == 0) {
            OutputStreamWriter outputStreamWriter = null;
            try {
                File file = jFileChooser.getSelectedFile();
                String string = file.getAbsolutePath();
                if (!string.isEmpty() && !string.contains(".s")) {
                    string = string + ".sql";
                }
                outputStreamWriter = new FileWriter(string);
                outputStreamWriter.write(this.statementTA.getText());
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Save Statement");
            }
            finally {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(CreateSqlTable.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }
        }
    }

    private void tableNameCBActionPerformed(ActionEvent actionEvent) {
        this.cTable.getModel().clearTable();
        this.cTable.getModel().addNewRow();
        this.readColumns();
        this.buildStatement();
    }

    private void upRowBTActionPerformed(ActionEvent actionEvent) {
        int n = this.cTable.getSelectedRow();
        if (n > 0) {
            FcBaseTableModel.RowData rowData = this.cTable.getModel().getRow(n);
            this.cTable.getModel().deleteRow(n);
            this.cTable.getModel().insertRow(n - 1, rowData);
            this.cTable.getModel().fireTableDataChanged();
            this.cTable.changeSelection(n - 1, 0, false, false);
        }
        this.buildStatement();
    }

    private void downRowBTActionPerformed(ActionEvent actionEvent) {
        int n = this.cTable.getSelectedRow();
        if (n < this.cTable.getModel().getRowCount() - 1) {
            FcBaseTableModel.RowData rowData = this.cTable.getModel().getRow(n);
            this.cTable.getModel().deleteRow(n);
            this.cTable.getModel().insertRow(n + 1, rowData);
            this.cTable.getModel().fireTableDataChanged();
            this.cTable.changeSelection(n + 1, 0, false, false);
        }
        this.buildStatement();
    }

    private void indexNameTBFocusLost(FocusEvent focusEvent) {
        this.buildStatement();
    }

    private void uniqueCBActionPerformed(ActionEvent actionEvent) {
        this.buildStatement();
    }

    private void partitionCBActionPerformed(ActionEvent actionEvent) {
        this.buildStatement();
    }

    public void showDialog(String string) {
        this.tableName = string;
        this.tableOwner = Globals.currentSqlConnection.getSelectedUser();
        if (string.isEmpty()) {
            this.readTables();
        } else {
            this.tableNameCB.setEnabled(false);
            this.tableNameCB.addItem(this.tableOwner + "." + string);
        }
        this.getRootPane().setDefaultButton(this.createButton);
        this.setVisible(true);
    }

    private void readTables() {
        this.tableNameCB.addItem("");
        String string = "select tbl from admin.systables where owner = '" + this.tableOwner + "' and tbltype = 'T' order by 1";
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string);
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    this.tableNameCB.addItem(this.tableOwner + "." + resultSet.getString(1));
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "Read Columns");
            }
        }
    }

    private void readColumns() {
        String string = this.tableNameCB.getSelectedItem().toString();
        String[] stringArray = string.split("\\.");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        if (stringArray.length == 2) {
            String string2 = "select col from admin.syscolumns where tbl = '" + stringArray[1] + "' and owner = '" + this.tableOwner + "'";
            ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string2);
            if (resultSet != null) {
                try {
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getString(1));
                    }
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    Globals.showException(sQLException, "Read Columns");
                }
            }
            TableColumn tableColumn = this.cTable.getColumnModel().getColumn(0);
            FcComboBoxCellRenderer fcComboBoxCellRenderer = (FcComboBoxCellRenderer)tableColumn.getCellRenderer();
            String[] stringArray2 = new String[arrayList.size()];
            fcComboBoxCellRenderer.setItems(arrayList.toArray(stringArray2));
            FcComboBoxCellEditor fcComboBoxCellEditor = (FcComboBoxCellEditor)tableColumn.getCellEditor();
            fcComboBoxCellEditor.setItems(stringArray2);
        }
    }

    private void buildStatement() {
        int n = this.cTable.getRowCount();
        if (n > 0) {
            String string = "CREATE ";
            if (this.uniqueCB.isSelected()) {
                string = string + "UNIQUE ";
            }
            string = string + "INDEX ";
            if (!this.indexNameTB.getText().contains(".")) {
                string = string + this.tableOwner + ".";
            }
            String string2 = this.tableNameCB.getSelectedItem().toString();
            String[] stringArray = string2.split("\\.");
            String string3 = "";
            String string4 = "";
            if (stringArray.length == 2) {
                string3 = stringArray[0];
                string4 = stringArray[1];
            }
            string = string + this.indexNameTB.getText() + " ON " + string3 + ".\"" + string4 + "\" ( ";
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                String string5 = this.cTable.getValueAt(i, 0).toString();
                if (string5.isEmpty()) continue;
                if (bl) {
                    bl = false;
                } else {
                    string = string + " , ";
                }
                string = string + "\"" + string5 + "\" ";
                String string6 = this.cTable.getValueAt(i, 1).toString();
                if (!string6.equals("true")) continue;
                string = string + " DESC";
            }
            string = string + " )";
            if (this.partitionCB.isSelected()) {
                string = string + " STORAGE_ATTRIBUTES 'PARTITION'";
            }
            this.statementTA.setText(string);
        } else {
            this.statementTA.setText("");
        }
    }

    public class ColumnsTableModel
    extends FcBaseTableModel {
        ColumnsTable table;

        public ColumnsTableModel(ColumnsTable columnsTable) {
            super((FcBaseDynamicTable)columnsTable, false);
            this.table = columnsTable;
            this.showNullAsEmpty = true;
        }

        public void setValueAt(Object object, int n, int n2) {
            super.setValueAt(object, n, n2);
            if (this.autoAddRows && object != null && n == this.getRowCount() - 1 && object instanceof String && !object.toString().isEmpty()) {
                this.addNewRow();
            }
            CreateIndex.this.buildStatement();
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"Columns", "DESC"};
            Integer[] integerArray = new Integer[]{1, 1};
            this.clearTable();
            this.numberOfColumns = stringArray.length;
            this.addColumns(stringArray, integerArray);
            this.autoSizeColumns.set(0, true);
            this.autoAddRows = true;
            super.fireTableStructureChanged();
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setCellRenderer((TableCellRenderer)new FcComboBoxCellRenderer());
            tableColumn.setCellEditor((TableCellEditor)new FcComboBoxCellEditor());
            tableColumn.setPreferredWidth(300);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setCellRenderer((TableCellRenderer)new FcBooleanCellRenderer(false));
            tableColumn.setCellEditor((TableCellEditor)new FcBooleanCellEditor(false));
            tableColumn.setPreferredWidth(150);
        }

        public boolean isCellEditable(int n, int n2) {
            return !this.isReadOnly();
        }

        public void addNewRow() {
            this.addRow(this.createNewRow());
            this.fireTableDataChanged();
        }

        public ArrayList<Object> createNewRow() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("");
            arrayList.add(false);
            return arrayList;
        }
    }

    public class ColumnsTable
    extends FcBaseDynamicTable {
        ColumnsTableModel model;

        public ColumnsTable() {
            this.model = new ColumnsTableModel(this);
            this.setModel((TableModel)((Object)this.model));
            this.model.setupColumns();
        }

        public ColumnsTableModel getModel() {
            return this.model;
        }
    }
}

