/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.Helper.Editors.FcButtonCellEditor;
import FairCom.Helper.Editors.FcComboBoxCellEditor;
import FairCom.Helper.Renderers.FcButtonCellRenderer;
import FairCom.Helper.Renderers.FcComboBoxCellRenderer;
import ctree.jdbc.CtreeSQLException;
import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.sql.FKButtonAction;
import ctreeaceexplorer.sql.PopupListener;
import ctreeaceexplorer.sql.RecordColumns;
import ctreeaceexplorer.sql.SQL_MODE;
import ctreeaceexplorer.sql.SqlDynamicTable;
import ctreeaceexplorer.sql.SqlTableColumn;
import ctreeaceexplorer.sql.SqlTableModel;
import ctreeaceexplorer.sql.StorageAttribute;
import ctreeaceexplorer.sql.UniqueButtonAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.constant.Constable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;

public class CreateSqlTable
extends JDialog {
    String tableName;
    static SQL_MODE mode;
    ColumnsTable columnsTable = new ColumnsTable();
    UniqueTable uniqueTable = new UniqueTable();
    FKTable fkTable = new FKTable();
    CheckTable checkTable = new CheckTable();
    ArrayList<Integer> PKColumns = new ArrayList();
    boolean loading;
    String storageAttributes = "";
    static ArrayList<SqlTableColumn> tableColumns;
    static ArrayList<SqlTableColumn> pkSelectedColumns;
    static ArrayList<SqlTableColumn> ukSelectedColumns;
    static ArrayList<SqlTableColumn> fkSelectedColumns;
    final int ADD = 1;
    final int INSERT = 2;
    final int DELETE = 3;
    final int MOVE_UP = 4;
    final int MOVE_DOWN = 5;
    private JMenuItem add;
    private JButton addRowBT;
    private JButton advancedBT;
    private JScrollPane checkScrollPane;
    private JScrollPane columnsScrollPane;
    private JButton createButton;
    private JMenuItem delete;
    private JButton deleteRowBT;
    private JButton downRowBT;
    private JButton exitButton;
    private JScrollPane fkScrollPane;
    private JMenuItem insert;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JTable jTable2;
    private JTable jTable3;
    private JTable jTable4;
    private JMenuItem moveDown;
    private JMenuItem moveUp;
    private JButton pkButton;
    private JPopupMenu popupMenu;
    private JButton saveButton;
    private JTextArea statementTA;
    private JTextField tableAs;
    private JTextField tableNameTB;
    private JTextField tableOwnerTB;
    private JTextField tablePrimKeyTB;
    private JScrollPane uniqueScrollPane;
    private JButton upRowBT;

    public CreateSqlTable(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.setIconImage(Globals.getIcon("Table.png").getImage());
        this.columnsScrollPane.setViewportView((Component)((Object)this.columnsTable));
        this.columnsScrollPane.getViewport().setBackground(Color.white);
        this.uniqueScrollPane.setViewportView((Component)((Object)this.uniqueTable));
        this.uniqueScrollPane.getViewport().setBackground(Color.white);
        this.uniqueTable.showRowHeader(this.uniqueScrollPane);
        this.fkScrollPane.setViewportView((Component)((Object)this.fkTable));
        this.fkScrollPane.getViewport().setBackground(Color.white);
        this.fkTable.showRowHeader(this.fkScrollPane);
        this.checkScrollPane.setViewportView((Component)((Object)this.checkTable));
        this.checkScrollPane.getViewport().setBackground(Color.white);
        this.checkTable.showRowHeader(this.checkScrollPane);
    }

    static void allocateArrays() {
        if (!tableColumns.isEmpty()) {
            pkSelectedColumns = new ArrayList<SqlTableColumn>(tableColumns);
            ukSelectedColumns = new ArrayList<SqlTableColumn>(tableColumns);
            fkSelectedColumns = new ArrayList<SqlTableColumn>(tableColumns);
        } else if (pkSelectedColumns != null) {
            pkSelectedColumns.clear();
            ukSelectedColumns.clear();
            fkSelectedColumns.clear();
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.add = new JMenuItem();
        this.insert = new JMenuItem();
        this.delete = new JMenuItem();
        this.moveUp = new JMenuItem();
        this.moveDown = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.createButton = new JButton();
        this.exitButton = new JButton();
        this.jPanel2 = new JPanel();
        this.columnsScrollPane = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel5 = new JPanel();
        this.upRowBT = new JButton();
        this.downRowBT = new JButton();
        this.addRowBT = new JButton();
        this.deleteRowBT = new JButton();
        this.jPanel3 = new JPanel();
        this.saveButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.statementTA = new JTextArea();
        this.jPanel4 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel6 = new JPanel();
        this.jLabel4 = new JLabel();
        this.tablePrimKeyTB = new JTextField();
        this.pkButton = new JButton();
        this.jPanel7 = new JPanel();
        this.uniqueScrollPane = new JScrollPane();
        this.jTable2 = new JTable();
        this.jPanel8 = new JPanel();
        this.fkScrollPane = new JScrollPane();
        this.jTable3 = new JTable();
        this.jPanel9 = new JPanel();
        this.checkScrollPane = new JScrollPane();
        this.jTable4 = new JTable();
        this.jLabel1 = new JLabel();
        this.tableAs = new JTextField();
        this.jLabel2 = new JLabel();
        this.tableNameTB = new JTextField();
        this.jLabel3 = new JLabel();
        this.tableOwnerTB = new JTextField();
        this.advancedBT = new JButton();
        this.popupMenu.setName("popupMenu");
        this.add.setText("Add Row");
        this.add.setName("add");
        this.popupMenu.add(this.add);
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(CreateSqlTable.class, this);
        this.insert.setAction(applicationActionMap.get("popUpMenuAction"));
        this.insert.setName("insert");
        this.popupMenu.add(this.insert);
        this.delete.setText("Delete Row");
        this.delete.setName("delete");
        this.popupMenu.add(this.delete);
        this.moveUp.setText("Move Up");
        this.moveUp.setName("moveUp");
        this.popupMenu.add(this.moveUp);
        this.moveDown.setText("Move Down");
        this.moveDown.setName("moveDown");
        this.popupMenu.add(this.moveDown);
        this.setDefaultCloseOperation(2);
        this.setTitle("Create Table");
        this.jPanel1.setName("jPanel1");
        this.createButton.setMnemonic('O');
        this.createButton.setText("Create");
        this.createButton.setName("createButton");
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateSqlTable.this.createButtonActionPerformed(actionEvent);
            }
        });
        this.exitButton.setMnemonic('A');
        this.exitButton.setText("Exit");
        this.exitButton.setName("exitButton");
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateSqlTable.this.exitButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(255, 255, 255).addComponent(this.createButton, -2, 75, -2).addGap(83, 83, 83).addComponent(this.exitButton, -2, 71, -2).addContainerGap(274, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createButton).addComponent(this.exitButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Columns", 0, 0, new Font("Tahoma", 0, 11), Color.blue));
        this.jPanel2.setName("jPanel2");
        this.columnsScrollPane.setBorder(BorderFactory.createTitledBorder(""));
        this.columnsScrollPane.setName("columnsScrollPane");
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setName("jTable1");
        this.columnsScrollPane.setViewportView(this.jTable1);
        this.jPanel5.setName("jPanel5");
        this.upRowBT.setIcon(new ImageIcon(this.getClass().getResource("/ctreeaceexplorer/images/Arrowup.png")));
        this.upRowBT.setToolTipText("Move Up");
        this.upRowBT.setName("upRowBT");
        this.downRowBT.setIcon(new ImageIcon(this.getClass().getResource("/ctreeaceexplorer/images/Arrowdown.png")));
        this.downRowBT.setToolTipText("Move Down");
        this.downRowBT.setName("downRowBT");
        this.addRowBT.setIcon(new ImageIcon(this.getClass().getResource("/ctreeaceexplorer/images/AddRec.png")));
        this.addRowBT.setToolTipText("Insert Column");
        this.addRowBT.setName("addRowBT");
        this.deleteRowBT.setIcon(new ImageIcon(this.getClass().getResource("/ctreeaceexplorer/images/RemoveRec.png")));
        this.deleteRowBT.setToolTipText("Remove Column");
        this.deleteRowBT.setName("deleteRowBT");
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addRowBT, GroupLayout.Alignment.TRAILING, -2, 23, -2).addComponent(this.downRowBT, GroupLayout.Alignment.TRAILING, -2, 25, -2).addComponent(this.upRowBT, GroupLayout.Alignment.TRAILING, -2, 25, -2).addComponent(this.deleteRowBT, GroupLayout.Alignment.TRAILING, -2, 23, -2)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.addRowBT).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.deleteRowBT).addGap(11, 11, 11).addComponent(this.upRowBT).addGap(11, 11, 11).addComponent(this.downRowBT).addContainerGap(25, Short.MAX_VALUE)));
        GroupLayout groupLayout3 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addComponent(this.columnsScrollPane, -1, 677, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, 43, -2)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addComponent(this.columnsScrollPane, -1, 169, Short.MAX_VALUE));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Resulting Statement", 0, 0, new Font("Tahoma", 0, 11), Color.blue));
        this.jPanel3.setName("jPanel3");
        this.saveButton.setText("Save Statement");
        this.saveButton.setName("saveButton");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateSqlTable.this.saveButtonActionPerformed(actionEvent);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.statementTA.setColumns(1);
        this.statementTA.setFont(new Font("Tahoma", 0, 11));
        this.statementTA.setLineWrap(true);
        this.statementTA.setRows(10);
        this.statementTA.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.statementTA.setName("statementTA");
        this.jScrollPane1.setViewportView(this.statementTA);
        GroupLayout groupLayout4 = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 726, Short.MAX_VALUE).addGroup(groupLayout4.createSequentialGroup().addGap(300, 300, 300).addComponent(this.saveButton).addContainerGap(317, Short.MAX_VALUE)));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addComponent(this.jScrollPane1, -1, 63, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveButton)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Table Constraints", 0, 0, new Font("Tahoma", 0, 11), Color.blue));
        this.jPanel4.setName("jPanel4");
        this.jTabbedPane1.setName("jTabbedPane1");
        this.jPanel6.setName("jPanel6");
        this.jLabel4.setText("Primary Key Columns :");
        this.jLabel4.setName("jLabel4");
        this.tablePrimKeyTB.setName("tablePrimKeyTB");
        this.pkButton.setText("...");
        this.pkButton.setName("pkButton");
        this.pkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateSqlTable.this.pkButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout5 = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addGap(19, 19, 19).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tablePrimKeyTB, -1, 540, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pkButton, -2, 24, -2).addGap(21, 21, 21)));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addGap(34, 34, 34).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pkButton).addComponent(this.jLabel4).addComponent(this.tablePrimKeyTB, -2, -1, -2)).addContainerGap(43, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Primary Key", this.jPanel6);
        this.jPanel7.setName("jPanel7");
        this.uniqueScrollPane.setName("uniqueScrollPane");
        this.jTable2.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable2.setName("jTable2");
        this.uniqueScrollPane.setViewportView(this.jTable2);
        GroupLayout groupLayout6 = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addComponent(this.uniqueScrollPane, -1, 701, Short.MAX_VALUE).addContainerGap()));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addComponent(this.uniqueScrollPane, -1, 78, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Unique", this.jPanel7);
        this.jPanel8.setName("jPanel8");
        this.fkScrollPane.setName("fkScrollPane");
        this.jTable3.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable3.setName("jTable3");
        this.fkScrollPane.setViewportView(this.jTable3);
        GroupLayout groupLayout7 = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(groupLayout7);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addContainerGap().addComponent(this.fkScrollPane, -1, 701, Short.MAX_VALUE).addContainerGap()));
        groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addContainerGap().addComponent(this.fkScrollPane, -1, 78, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Foreign Key", this.jPanel8);
        this.jPanel9.setName("jPanel9");
        this.checkScrollPane.setName("checkScrollPane");
        this.jTable4.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable4.setName("jTable4");
        this.checkScrollPane.setViewportView(this.jTable4);
        GroupLayout groupLayout8 = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(groupLayout8);
        groupLayout8.setHorizontalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout8.createSequentialGroup().addContainerGap().addComponent(this.checkScrollPane, -1, 701, Short.MAX_VALUE).addContainerGap()));
        groupLayout8.setVerticalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout8.createSequentialGroup().addContainerGap().addComponent(this.checkScrollPane, -1, 78, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Check", this.jPanel9);
        GroupLayout groupLayout9 = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(groupLayout9);
        groupLayout9.setHorizontalGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 726, Short.MAX_VALUE));
        groupLayout9.setVerticalGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 128, Short.MAX_VALUE));
        this.jLabel1.setText("AS");
        this.jLabel1.setName("jLabel1");
        this.tableAs.setName("tableAs");
        this.jLabel2.setText("Table Name :");
        this.jLabel2.setName("jLabel2");
        this.tableNameTB.setName("tableNameTB");
        this.tableNameTB.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CreateSqlTable.this.tableNameTBFocusLost(focusEvent);
            }
        });
        this.jLabel3.setText("Table Owner :");
        this.jLabel3.setName("jLabel3");
        this.tableOwnerTB.setName("tableOwnerTB");
        this.tableOwnerTB.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CreateSqlTable.this.tableOwnerTBFocusLost(focusEvent);
            }
        });
        this.advancedBT.setText("Advanced Options");
        this.advancedBT.setName("advancedBT");
        this.advancedBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateSqlTable.this.advancedBTActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout10 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout10);
        groupLayout10.setHorizontalGroup(groupLayout10.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout10.createSequentialGroup().addContainerGap(98, Short.MAX_VALUE).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tableNameTB, -2, 135, -2).addGap(45, 45, 45).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tableOwnerTB, -2, 106, -2).addGap(43, 43, 43).addComponent(this.advancedBT).addGap(65, 65, 65)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(groupLayout10.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout10.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout10.createSequentialGroup().addGap(41, 41, 41).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tableAs, -2, 640, -2).addContainerGap(54, Short.MAX_VALUE)).addGroup(groupLayout10.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout10.setVerticalGroup(groupLayout10.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout10.createSequentialGroup().addContainerGap().addGroup(groupLayout10.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.advancedBT).addComponent(this.jLabel2).addComponent(this.tableNameTB, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.tableOwnerTB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout10.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.tableAs, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addGap(17, 17, 17).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void createButtonActionPerformed(ActionEvent actionEvent) {
        if (this.columnsTable.getCellEditor() != null) {
            this.columnsTable.getCellEditor().stopCellEditing();
        }
        if (this.tableNameTB.getText().isEmpty()) {
            Globals.showMessage("Missing Table Name", "Error");
            return;
        }
        try {
            this.buildStatement();
            Globals.currentSqlConnection.executeUpdate(this.statementTA.getText());
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "Table Not Created", "Create Table");
            CtreeSQLException cfr_ignored_0 = (CtreeSQLException)sQLException;
            Globals.appFrame.showErrorPos(sQLException.getErrorCode(), CtreeSQLException.getErrorPosition(), this.statementTA.getText(), this.statementTA);
            return;
        }
        Globals.showOKMessage("Table Successfully Created", "Create Table");
    }

    private void exitButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void pkButtonActionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        RecordColumns recordColumns = new RecordColumns((Frame)jFrame, true);
        recordColumns.setLocationRelativeTo(jFrame);
        String string = this.tablePrimKeyTB.getText();
        boolean bl = recordColumns.showDialog(RecordColumns.MODE.PK_COLUMNS, string);
        if (bl) {
            String string2 = "";
            boolean bl2 = true;
            for (SqlTableColumn sqlTableColumn : pkSelectedColumns) {
                if (!sqlTableColumn.Selected) continue;
                if (bl2) {
                    bl2 = false;
                } else {
                    string2 = string2 + ",";
                }
                string2 = string2 + sqlTableColumn.Name;
            }
            this.tablePrimKeyTB.setText(string2);
        }
    }

    private void advancedBTActionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        StorageAttribute storageAttribute = new StorageAttribute((Frame)jFrame, true);
        storageAttribute.setLocationRelativeTo(jFrame);
        this.storageAttributes = storageAttribute.showDialog(this.storageAttributes);
        this.buildStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveButtonActionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        JFileChooser jFileChooser = new JFileChooser();
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("script files (*.sql)", "sql");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setCurrentDirectory(new File(Globals.execDir));
        int n = jFileChooser.showSaveDialog(jFrame);
        if (n == 0) {
            OutputStreamWriter outputStreamWriter = null;
            try {
                File file = jFileChooser.getSelectedFile();
                String string = file.getAbsolutePath();
                if (!string.isEmpty() && !string.contains(".s")) {
                    string = string + ".sql";
                }
                outputStreamWriter = new FileWriter(string);
                outputStreamWriter.write(this.statementTA.getText());
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Save Statement");
            }
            finally {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(CreateSqlTable.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }
        }
    }

    private void tableOwnerTBFocusLost(FocusEvent focusEvent) {
        this.buildStatement();
    }

    private void tableNameTBFocusLost(FocusEvent focusEvent) {
        this.buildStatement();
    }

    public void showDialog(SQL_MODE sQL_MODE, String string) {
        mode = sQL_MODE;
        this.tableName = string;
        this.getRootPane().setDefaultButton(this.createButton);
        this.tablePrimKeyTB.setEditable(false);
        this.pkButton.setEnabled(false);
        this.uniqueTable.mode = sQL_MODE;
        String string2 = Globals.currentSqlConnection.getSelectedUser();
        this.tableOwnerTB.setText(string2);
        if (sQL_MODE == SQL_MODE.TABLE_PROPERTIES || sQL_MODE == SQL_MODE.TABLE_CLONE) {
            String string3;
            String string4;
            Object object;
            String string5;
            Object object2;
            String string6;
            if (sQL_MODE == SQL_MODE.TABLE_PROPERTIES) {
                this.setTitle("Show Table Properties");
                this.createButton.setEnabled(false);
                this.columnsTable.getModel().setReadOnly(true);
                this.uniqueTable.getModel().setReadOnly(true);
                this.fkTable.getModel().setReadOnly(true);
                this.checkTable.getModel().setReadOnly(true);
                this.tablePrimKeyTB.setEditable(false);
                this.pkButton.setEnabled(false);
                this.advancedBT.setEnabled(false);
                this.upRowBT.setEnabled(false);
                this.downRowBT.setEnabled(false);
                this.tableNameTB.setEditable(false);
                this.tableOwnerTB.setEditable(false);
                this.addRowBT.setEnabled(false);
                this.deleteRowBT.setEnabled(false);
            }
            ColumnsTableModel columnsTableModel = this.columnsTable.getModel();
            columnsTableModel.clearTable();
            Object[] objectArray = Globals.currentSqlConnection.getConstraintsStatus(string);
            boolean bl = (Boolean)objectArray[0];
            boolean bl2 = (Boolean)objectArray[1];
            boolean bl3 = (Boolean)objectArray[2];
            boolean bl4 = (Boolean)objectArray[3];
            String string7 = "";
            string2 = Globals.currentSqlConnection.getSelectedUser();
            this.tableNameTB.setText(string);
            this.tableOwnerTB.setText(string2);
            string7 = Globals.currentSqlConnection.isIdentitySupported() ? "select col, coltype, width, scale, nullflag, dflt_value, case when colid is null then 'N' else 'Y' end as 'identity', seed, incr, charset, collation  from admin.syscolumns cols left join admin.sysidentity ids on cols.owner = ids.owner and cols.tbl = ids.tbl and cols.id = ids.colid where cols.tbl = '" + string + "' and cols.owner = '" + string2 + "' order by id" : "select col, coltype, width, scale, nullflag, dflt_value,    '-' as 'identity', '-' as 'seed', '-' as 'incr', charset, collation  from admin.syscolumns cols where cols.tbl = '" + string + "' and cols.owner = '" + string2 + "' order by id";
            ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string7);
            if (resultSet != null) {
                try {
                    while (resultSet.next()) {
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        arrayList.add(false);
                        string6 = resultSet.getString(1);
                        arrayList.add(string6);
                        object2 = resultSet.getString(2).toUpperCase();
                        if (object2.equals("CHARACTER")) {
                            object2 = "CHAR";
                        }
                        arrayList.add(object2);
                        arrayList.add(resultSet.getInt(3));
                        arrayList.add(resultSet.getInt(4));
                        string5 = resultSet.getString(5);
                        arrayList.add(string5.equals("N"));
                        object = resultSet.getString(6);
                        if (object != null && ((String)object).startsWith("\"")) {
                            object = ((String)object).substring(1);
                        }
                        if (object != null && ((String)object).endsWith("\"")) {
                            object = ((String)object).substring(0, ((String)object).length() - 1);
                        }
                        arrayList.add(object);
                        string5 = resultSet.getString(7);
                        arrayList.add(string5.equals("Y"));
                        if (Globals.currentSqlConnection.isIdentitySupported()) {
                            arrayList.add(resultSet.getInt(8));
                            arrayList.add(resultSet.getInt(9));
                        } else {
                            arrayList.add("-");
                            arrayList.add("-");
                        }
                        arrayList.add(null);
                        arrayList.add(null);
                        columnsTableModel.addRow(arrayList);
                        tableColumns.add(new SqlTableColumn(string6, (String)object2, string5.equals("Y") ? "Y" : null));
                    }
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    Globals.showException(sQLException, "setupColumns");
                }
            }
            columnsTableModel.fireTableDataChanged();
            CreateSqlTable.allocateArrays();
            if (bl) {
                string7 = "select u.colname from admin.sys_tbl_constrs c join admin.sys_keycol_usage u on c.owner = u.owner and c.tblname = u.tblname and c.cnstrname = u.cnstrname  where c.owner = '" + string2 + "' and c.tblname = '" + string + "' and c.cnstrtype = 'P'";
                resultSet = Globals.currentSqlConnection.execRsQuery(string7);
                boolean bl5 = true;
                if (resultSet != null) {
                    try {
                        string6 = "";
                        while (resultSet.next()) {
                            if (bl5) {
                                bl5 = false;
                            } else {
                                string6 = string6 + ", ";
                            }
                            string6 = string6 + resultSet.getString(1);
                        }
                        this.tablePrimKeyTB.setText(string6);
                        resultSet.close();
                        this.setPKColums(string6);
                        columnsTableModel.fireTableDataChanged();
                    }
                    catch (SQLException sQLException) {
                        Globals.showException(sQLException, "setupPK");
                    }
                }
            }
            UniqueTableModel uniqueTableModel = this.uniqueTable.getModel();
            if (bl4) {
                string7 = "select u.colname, u.cnstrname from admin.sys_tbl_constrs c join admin.sys_keycol_usage u on c.owner = u.owner and c.tblname = u.tblname and c.cnstrname = u.cnstrname  where c.owner = '" + string2 + "' and c.tblname = '" + string + "' and c.cnstrtype = 'U' " + "order by u.cnstrname, u.colposition";
                resultSet = Globals.currentSqlConnection.execRsQuery(string7);
                boolean bl6 = true;
                if (resultSet != null) {
                    try {
                        object2 = "";
                        string5 = "";
                        while (resultSet.next()) {
                            if (!bl6 && !string5.equals(resultSet.getString(2))) {
                                bl6 = true;
                                object = new ArrayList();
                                ((ArrayList)object).add(object2);
                                object2 = "";
                                ((ArrayList)object).add("...");
                                uniqueTableModel.addRow((ArrayList)object);
                            }
                            if (bl6) {
                                bl6 = false;
                                string5 = resultSet.getString(2);
                            } else {
                                object2 = object2 + ", ";
                            }
                            object2 = object2 + resultSet.getString(1);
                        }
                        resultSet.close();
                        object = new ArrayList<String>();
                        ((ArrayList)object).add(object2);
                        ((ArrayList)object).add("...");
                        uniqueTableModel.addRow((ArrayList)object);
                    }
                    catch (SQLException sQLException) {
                        Globals.showException(sQLException, "setupUK");
                    }
                }
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("");
            arrayList.add("...");
            uniqueTableModel.addRow(arrayList);
            uniqueTableModel.fireTableDataChanged();
            object2 = this.fkTable.getModel();
            if (bl2) {
                string7 = "select u.colname, r.refowner, r.refcnstrname, r.reftblname , f.colname from admin.sys_tbl_constrs c join admin.sys_keycol_usage u on c.owner = u.owner and c.tblname = u.tblname and c.cnstrname = u.cnstrname join admin.sys_ref_constrs r on c.owner = r.owner and c.tblname = r.tblname and c.cnstrname = r.cnstrname join admin.sys_keycol_usage f on f.owner = r.refowner and f.tblname = r.reftblname and f.cnstrname = r.refcnstrname where c.owner = '" + string2 + "' and c.tblname = '" + string + "' and c.cnstrtype = 'F' " + "order by u.cnstrname, u.colposition";
                resultSet = Globals.currentSqlConnection.execRsQuery(string7);
                boolean bl7 = true;
                if (resultSet != null) {
                    try {
                        object = "";
                        string4 = "";
                        string3 = "";
                        String string8 = "";
                        while (resultSet.next()) {
                            if (!bl7 && !string8.equals(resultSet.getString(3))) {
                                bl7 = true;
                                arrayList = new ArrayList();
                                arrayList.add(object);
                                object = "";
                                arrayList.add("...");
                                arrayList.add(string4 + string3 + " )");
                                string4 = "";
                                string3 = "";
                                object2.addRow(arrayList);
                            }
                            if (bl7) {
                                bl7 = false;
                                string4 = resultSet.getString(4) + " ( ";
                            } else {
                                object = (String)object + ", ";
                                string3 = string3 + ", ";
                            }
                            object = (String)object + resultSet.getString(1);
                            string3 = string3 + resultSet.getString(5);
                        }
                        resultSet.close();
                        arrayList = new ArrayList();
                        arrayList.add(object);
                        arrayList.add("...");
                        arrayList.add(string4 + string3 + " )");
                        object2.addRow(arrayList);
                    }
                    catch (SQLException sQLException) {
                        Globals.showException(sQLException, "setupFK");
                    }
                }
            }
            arrayList = new ArrayList();
            arrayList.add("");
            arrayList.add("...");
            arrayList.add("");
            object2.addRow(arrayList);
            object2.fireTableDataChanged();
            CheckTableModel checkTableModel = this.checkTable.getModel();
            if (bl3) {
                string7 = "select l.chkclause, c.cnstrname from admin.sys_tbl_constrs c join admin.sys_chk_constrs l on c.owner = l.owner and c.tblname = l.tblname and c.cnstrname = l.cnstrname where c.owner = '" + string2 + "' and c.tblname = '" + string + "' and c.cnstrtype = 'C' " + "order by l.cnstrname";
                resultSet = Globals.currentSqlConnection.execRsQuery(string7);
                boolean bl8 = true;
                if (resultSet != null) {
                    try {
                        string4 = "";
                        string3 = "";
                        while (resultSet.next()) {
                            if (!bl8 && !string3.equals(resultSet.getString(2))) {
                                bl8 = true;
                                arrayList = new ArrayList();
                                arrayList.add(string4);
                                string4 = "";
                                checkTableModel.addRow(arrayList);
                            }
                            if (bl8) {
                                bl8 = false;
                                string3 = resultSet.getString(2);
                            } else {
                                string4 = string4 + ", ";
                            }
                            string4 = string4 + resultSet.getString(1);
                            string4 = string4.substring(1, string4.length() - 3);
                        }
                        resultSet.close();
                        arrayList = new ArrayList();
                        arrayList.add(string4);
                        checkTableModel.addRow(arrayList);
                        checkTableModel.fireTableDataChanged();
                    }
                    catch (SQLException sQLException) {
                        Globals.showException(sQLException, "setupUK");
                    }
                }
            }
            arrayList = new ArrayList();
            arrayList.add("");
            checkTableModel.addRow(arrayList);
            this.buildStatement();
        }
        if (sQL_MODE == SQL_MODE.TABLE_CREATE || sQL_MODE == SQL_MODE.TABLE_CLONE) {
            this.upRowBT.addActionListener(new SqlActions(this.columnsTable, 4));
            this.downRowBT.addActionListener(new SqlActions(this.columnsTable, 5));
            this.addRowBT.addActionListener(new SqlActions(this.columnsTable, 1));
            this.deleteRowBT.addActionListener(new SqlActions(this.columnsTable, 3));
            this.columnsTable.getModel().addNewRow();
            this.columnsTable.setupActions();
            this.columnsTable.addMouseListener(new PopupListener(this.columnsTable));
            this.uniqueTable.getModel().addNewRow();
            this.fkTable.getModel().addNewRow();
            this.checkTable.getModel().addNewRow();
        }
        if (sQL_MODE == SQL_MODE.TABLE_CREATE) {
            tableColumns.clear();
            CreateSqlTable.allocateArrays();
        }
        this.setVisible(true);
    }

    private void buildStatement() {
        String string;
        Object object;
        String string2;
        String string3;
        FcBaseTableModel.CellData cellData;
        tableColumns.clear();
        String string4 = "CREATE TABLE ";
        if (!this.tableOwnerTB.getText().isEmpty()) {
            string4 = string4 + "\"" + this.tableOwnerTB.getText() + "\".";
        }
        string4 = string4 + "\"" + this.tableNameTB.getText() + "\"";
        boolean bl = true;
        String string5 = "";
        boolean bl2 = false;
        ColumnsTableModel columnsTableModel = this.columnsTable.getModel();
        int n = columnsTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string6;
            String string7;
            Object object2;
            Object object3;
            Constable constable;
            FcBaseTableModel.RowData rowData = columnsTableModel.getRow(i);
            cellData = rowData.getData(COLUMNS_COLS.NAME.ordinal());
            string3 = (String)cellData.getData();
            if (string3 == null || string3.isEmpty()) continue;
            bl2 = true;
            string5 = bl ? string5 + " ( " : string5 + ", ";
            string5 = string5 + string3;
            cellData = rowData.getData(COLUMNS_COLS.TYPE.ordinal());
            string2 = (String)cellData.getData();
            string5 = string2.equals("DOUBLE") ? string5 + " DOUBLE PRECISION " : string5 + " " + string2 + " ";
            if (string2.equals("CHAR") || string2.equals("VARCHAR") || string2.equals("NCHAR") || string2.equals("NVARCHAR") || string2.equals("BINARY") || string2.equals("VARBINARY") || string2.equals("FLOAT") || string2.equals("NUMERIC") || string2.equals("DECIMAL")) {
                object = (Integer)rowData.getData(COLUMNS_COLS.SIZE.ordinal()).getData();
                if ((Integer)object > 0) {
                    string5 = string5 + " (" + object;
                    constable = (Integer)rowData.getData(COLUMNS_COLS.SCALE.ordinal()).getData();
                    if (constable != null && (Integer)constable > 0) {
                        string5 = string5 + "," + constable;
                    }
                    string5 = string5 + ") ";
                }
            } else if (string2.equals("MONEY") && (Integer)(object = (Integer)rowData.getData(COLUMNS_COLS.SIZE.ordinal()).getData()) > 0) {
                string5 = string5 + " (" + object + ") ";
            }
            tableColumns.add(new SqlTableColumn(string3, string2, null));
            object = (Boolean)rowData.getData(COLUMNS_COLS.IDENTITY.ordinal()).getData();
            constable = Boolean.valueOf(false);
            if (((Boolean)object).booleanValue()) {
                string5 = string5 + "IDENTITY";
                constable = Boolean.valueOf(true);
                string5 = string5 + "(";
                object3 = (Integer)rowData.getData(COLUMNS_COLS.SEED.ordinal()).getData();
                string5 = object3 != null && (Integer)object3 > 0 ? string5 + object3 : string5 + "1";
                string5 = string5 + ",";
                object2 = (Integer)rowData.getData(COLUMNS_COLS.INCREMENT.ordinal()).getData();
                string5 = object2 != null && (Integer)object2 > 0 ? string5 + object2 : string5 + "1";
                string5 = string5 + ") ";
            }
            if ((object3 = (String)rowData.getData(COLUMNS_COLS.DEFAULT.ordinal()).getData()) != null && !((String)object3).isEmpty()) {
                string5 = string5 + "DEFAULT ";
                object2 = ((String)object3).toUpperCase();
                string5 = ((String)object2).equals("USER") || ((String)object2).equals("NULL") || ((String)object2).equals("UID") || ((String)object2).equals("SYSDATE") || ((String)object2).equals("SYSTIME") || ((String)object2).equals("SYSTIMESTAMP") ? string5 + (String)object2 : string5 + "'" + (String)object3 + "'";
            }
            if (((Boolean)(object2 = (Boolean)rowData.getData(COLUMNS_COLS.NOT_NULL.ordinal()).getData())).booleanValue()) {
                string5 = string5 + " NOT NULL ";
            }
            if ((string7 = (String)rowData.getData(COLUMNS_COLS.REFERENCES.ordinal()).getData()) != null && !string7.isEmpty()) {
                string5 = string5 + " REFERENCES " + string7;
            }
            if ((string6 = (String)rowData.getData(COLUMNS_COLS.CHECK.ordinal()).getData()) != null && !string6.isEmpty()) {
                string5 = string5 + " CHECK( " + string6 + ")";
            }
            bl = false;
        }
        this.tablePrimKeyTB.setText("");
        if (!this.PKColumns.isEmpty()) {
            this.tablePrimKeyTB.setText(this.getPKColumns());
            string5 = string5 + ", PRIMARY KEY(" + this.getPKColumns() + ") ";
        }
        UniqueTableModel uniqueTableModel = this.uniqueTable.getModel();
        n = uniqueTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            cellData = uniqueTableModel.getRow(i);
            string3 = (String)cellData.getData(0).getData();
            if (string3 == null || string3.isEmpty()) continue;
            string5 = string5 + ", UNIQUE(" + string3 + ") ";
        }
        FKTableModel fKTableModel = this.fkTable.getModel();
        n = fKTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            string3 = fKTableModel.getRow(i);
            string2 = (String)string3.getData(0).getData();
            object = (String)string3.getData(2).getData();
            if (string2 == null || string2.isEmpty() || object == null || ((String)object).isEmpty()) continue;
            string5 = string5 + ", FOREIGN KEY(" + string2 + ") REFERENCES " + (String)object;
        }
        CheckTableModel checkTableModel = this.checkTable.getModel();
        n = checkTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            string2 = checkTableModel.getRow(i);
            object = (String)string2.getData(0).getData();
            if (object == null || ((String)object).isEmpty()) continue;
            string5 = string5 + ", CHECK(" + (String)object + ") ";
        }
        if (bl2) {
            string5 = string5 + " )";
        }
        string4 = string4 + string5;
        if (!this.storageAttributes.isEmpty()) {
            string4 = string4 + " STORAGE_ATTRIBUTES '" + this.storageAttributes + "'";
        }
        if (!(string = this.tableAs.getText()).isEmpty()) {
            string4 = string4 + " AS " + string;
        }
        this.statementTA.setText(string4);
    }

    private void setPKColums(String string) {
        this.loading = true;
        ColumnsTableModel columnsTableModel = this.columnsTable.getModel();
        int n = columnsTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            columnsTableModel.setValueAt(false, i, COLUMNS_COLS.PK.ordinal());
        }
        this.PKColumns.clear();
        if (!string.isEmpty()) {
            String[] stringArray;
            block1: for (String string2 : stringArray = string.split(",")) {
                for (int i = 0; i < n; ++i) {
                    if (!columnsTableModel.getValueAt(i, COLUMNS_COLS.NAME.ordinal()).equals(string2.trim())) continue;
                    columnsTableModel.setValueAt(true, i, COLUMNS_COLS.PK.ordinal());
                    columnsTableModel.setValueAt(true, i, COLUMNS_COLS.NOT_NULL.ordinal());
                    continue block1;
                }
            }
            columnsTableModel.fireTableDataChanged();
        }
        this.tablePrimKeyTB.setText(this.getPKColumns());
        this.loading = false;
    }

    String getPKColumns() {
        String string = "";
        boolean bl = true;
        ColumnsTableModel columnsTableModel = this.columnsTable.getModel();
        for (int n : this.PKColumns) {
            if (bl) {
                bl = false;
            } else {
                string = string + ", ";
            }
            string = string + columnsTableModel.getValueAt(n, COLUMNS_COLS.NAME.ordinal());
        }
        return string;
    }

    static {
        tableColumns = new ArrayList();
    }

    class SqlActions
    implements ActionListener {
        FcBaseDynamicTable table;
        int mode;

        public SqlActions(FcBaseDynamicTable fcBaseDynamicTable, int n) {
            this.table = fcBaseDynamicTable;
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsTable columnsTable = (ColumnsTable)this.table;
            int n = columnsTable.getSelectedRow();
            if (columnsTable.isEditing()) {
                columnsTable.getCellEditor().stopCellEditing();
            }
            switch (this.mode) {
                case 1: {
                    columnsTable.getModel().addNewRow();
                    break;
                }
                case 2: {
                    columnsTable.getModel().insertRow(n);
                    break;
                }
                case 3: {
                    if (n < 0) break;
                    columnsTable.getModel().deleteRow(n);
                    columnsTable.getModel().fireTableDataChanged();
                    CreateSqlTable.this.buildStatement();
                    break;
                }
                case 4: {
                    if (n <= 0) break;
                    FcBaseTableModel.RowData rowData = columnsTable.getModel().getRow(n);
                    columnsTable.getModel().deleteRow(n);
                    columnsTable.getModel().insertRow(n - 1, rowData);
                    columnsTable.getModel().fireTableDataChanged();
                    columnsTable.changeSelection(n - 1, 0, false, false);
                    break;
                }
                case 5: {
                    if (n >= columnsTable.getModel().getRowCount() - 1) break;
                    FcBaseTableModel.RowData rowData = columnsTable.getModel().getRow(n);
                    columnsTable.getModel().deleteRow(n);
                    columnsTable.getModel().insertRow(n + 1, rowData);
                    columnsTable.getModel().fireTableDataChanged();
                    columnsTable.changeSelection(n + 1, 0, false, false);
                }
            }
        }
    }

    public class CheckTableModel
    extends SqlTableModel {
        CheckTable table;

        public CheckTableModel(CheckTable checkTable) {
            super(checkTable);
            this.table = checkTable;
            this.showNullAsEmpty = true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            super.setValueAt(object, n, n2);
            if (this.autoAddRows && object != null && n == this.getRowCount() - 1) {
                this.addNewRow();
            }
            CreateSqlTable.this.buildStatement();
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"Search Condition"};
            Integer[] integerArray = new Integer[]{1};
            this.clearTable();
            this.numberOfColumns = stringArray.length;
            this.addColumns(stringArray, integerArray);
            this.autoSizeColumns.set(0, true);
            super.fireTableStructureChanged();
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(600);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return !this.isReadOnly();
        }

        public void addNewRow() {
            this.addRow(this.createNewRow());
            this.fireTableDataChanged();
        }

        public ArrayList<Object> createNewRow() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("");
            return arrayList;
        }
    }

    public class CheckTable
    extends SqlDynamicTable {
        CheckTableModel model;

        public CheckTable() {
            super(false);
            this.model = new CheckTableModel(this);
            this.model.showNullAsEmpty = true;
            this.model.autoAddRows = true;
            this.setModel(this.model);
            this.model.setupColumns();
        }

        @Override
        public CheckTableModel getModel() {
            return this.model;
        }
    }

    public class FKTableModel
    extends FcBaseTableModel {
        FKTable table;

        public FKTableModel(FKTable fKTable) {
            super((FcBaseDynamicTable)fKTable, false);
            this.table = fKTable;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"Foreign Key Columns", "...", "References Table [(Columns)]"};
            Integer[] integerArray = new Integer[]{1, 1, 1};
            this.clearTable();
            this.numberOfColumns = stringArray.length;
            this.addColumns(stringArray, integerArray);
            this.autoSizeColumns.set(2, true);
            super.fireTableStructureChanged();
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(350);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setCellRenderer((TableCellRenderer)new FcButtonCellRenderer("..."));
            tableColumn.setCellEditor((TableCellEditor)new FcButtonCellEditor("...", (AbstractAction)new FKButtonAction(this.table)));
            tableColumn.setPreferredWidth(15);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(300);
        }

        public boolean isCellEditable(int n, int n2) {
            return !this.isReadOnly();
        }

        public void addNewRow() {
            this.addRow(this.createNewRow());
            this.fireTableDataChanged();
        }

        public void setValueAt(Object object, int n, int n2) {
            super.setValueAt(object, n, n2);
            if (this.autoAddRows && object != null && n == this.getRowCount() - 1) {
                this.addNewRow();
            }
        }

        public ArrayList<Object> createNewRow() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("");
            arrayList.add("...");
            arrayList.add("");
            return arrayList;
        }
    }

    public class FKTable
    extends FcBaseDynamicTable {
        FKTableModel model;

        public FKTable() {
            this.model = new FKTableModel(this);
            this.model.showNullAsEmpty = true;
            this.model.autoAddRows = true;
            this.setModel((TableModel)((Object)this.model));
            this.model.setupColumns();
        }

        public FKTableModel getModel() {
            return this.model;
        }
    }

    public class UniqueTableModel
    extends FcBaseTableModel {
        UniqueTable table;

        public UniqueTableModel(UniqueTable uniqueTable) {
            super((FcBaseDynamicTable)uniqueTable, false);
            this.table = uniqueTable;
        }

        public void addNewRow() {
            this.addRow(this.createNewRow());
            this.fireTableDataChanged();
        }

        public ArrayList<Object> createNewRow() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("");
            arrayList.add("...");
            return arrayList;
        }

        public void setValueAt(Object object, int n, int n2) {
            super.setValueAt(object, n, n2);
            if (this.autoAddRows && object != null && n == this.getRowCount() - 1) {
                this.addNewRow();
            }
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"Columns", "..."};
            Integer[] integerArray = new Integer[]{1, 1};
            this.clearTable();
            this.addColumns(stringArray, integerArray);
            this.autoSizeColumns.set(0, true);
            super.fireTableStructureChanged();
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(500);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setCellRenderer((TableCellRenderer)new FcButtonCellRenderer("..."));
            tableColumn.setPreferredWidth(15);
            tableColumn.setCellEditor((TableCellEditor)new FcButtonCellEditor("...", (AbstractAction)new UniqueButtonAction(this.table)));
        }

        public boolean isCellEditable(int n, int n2) {
            return !this.isReadOnly();
        }
    }

    public class UniqueTable
    extends FcBaseDynamicTable {
        UniqueTableModel model;
        SQL_MODE mode;

        public UniqueTable() {
            this.model = new UniqueTableModel(this);
            this.setModel((TableModel)((Object)this.model));
            this.model.autoAddRows = true;
            this.model.showNullAsEmpty = true;
            this.model.setupColumns();
        }

        public UniqueTableModel getModel() {
            return this.model;
        }
    }

    public class ColumnsTableModel
    extends FcBaseTableModel {
        ColumnsTable table;

        public ColumnsTableModel(ColumnsTable columnsTable) {
            super((FcBaseDynamicTable)columnsTable, false);
            this.table = columnsTable;
            this.showNullAsEmpty = true;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"BIT", "TINYINT", "SMALLINT", "INTEGER", "BIGINT", "MONEY", "REAL", "FLOAT", "DOUBLE", "DECIMAL", "NUMERIC", "CHAR", "VARCHAR", "LVARCHAR", "NCHAR", "NVARCHAR", "DATE", "TIME", "TIMESTAMP", "BINARY", "VARBINARY", "LVARBINARY"};
            String[] stringArray2 = new String[]{"Prim.Key", "Column", "Data Type", "Size", "Scale", "Not Null", "Default Value", "Identity", "Seed", "Incr.", "References", "Check"};
            Class[] classArray = new Class[]{Boolean.class, String.class, String.class, Integer.class, Integer.class, Boolean.class, String.class, Boolean.class, Integer.class, Integer.class, String.class, String.class};
            this.clearTable();
            this.addColumns(stringArray2, classArray);
            if (!Globals.currentSqlConnection.isIdentitySupported()) {
                this.readOnlyColumns.set(COLUMNS_COLS.IDENTITY.ordinal(), true);
                this.readOnlyColumns.set(COLUMNS_COLS.SEED.ordinal(), true);
                this.readOnlyColumns.set(COLUMNS_COLS.INCREMENT.ordinal(), true);
            }
            super.fireTableStructureChanged();
            TableColumn tableColumn = this.table.getColumnModel().getColumn(COLUMNS_COLS.TYPE.ordinal());
            tableColumn.setCellRenderer((TableCellRenderer)new FcComboBoxCellRenderer(stringArray));
            tableColumn.setCellEditor((TableCellEditor)new FcComboBoxCellEditor(stringArray));
        }

        public void deleteRow(int n) {
            super.deleteRow(n);
            this.fireTableDataChanged();
        }

        public void insertRow(int n) {
            this.insertRow(n, this.createNewRow());
            this.fireTableDataChanged();
        }

        public void addNewRow() {
            this.addRow(this.createNewRow());
            this.fireTableDataChanged();
            this.table.changeSelection(this.table.getRowCount() - 1, 0, false, false);
        }

        public FcBaseTableModel.RowData createNewRow() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(false);
            arrayList.add("");
            arrayList.add("CHAR");
            arrayList.add(0);
            arrayList.add(0);
            arrayList.add(false);
            arrayList.add("");
            arrayList.add(false);
            if (Globals.currentSqlConnection.isIdentitySupported()) {
                arrayList.add(0);
                arrayList.add(0);
            } else {
                arrayList.add("-");
                arrayList.add("-");
            }
            arrayList.add(null);
            arrayList.add(null);
            return new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
        }

        public void setValueAt(Object object, int n, int n2) {
            super.setValueAt(object, n, n2);
            if (n2 == COLUMNS_COLS.PK.ordinal()) {
                if (((Boolean)object).booleanValue()) {
                    this.setValueAt(true, n, COLUMNS_COLS.NOT_NULL.ordinal());
                    if (!CreateSqlTable.this.PKColumns.contains(n)) {
                        CreateSqlTable.this.PKColumns.add(n);
                    }
                } else {
                    this.setValueAt(false, n, COLUMNS_COLS.NOT_NULL.ordinal());
                    if (CreateSqlTable.this.PKColumns.contains(n)) {
                        CreateSqlTable.this.PKColumns.remove(n);
                    }
                }
            } else if (n2 == COLUMNS_COLS.TYPE.ordinal()) {
                this.setValueAt(null, n, COLUMNS_COLS.SCALE.ordinal());
                String string = (String)object;
                if (string.equals("BIT")) {
                    this.setValueAt(null, n, COLUMNS_COLS.SIZE.ordinal());
                } else if (!(string.equals("CHAR") || string.equals("VARCHAR") || string.equals("NCHAR") || string.equals("NVARCHAR") || string.equals("BINARY") || string.equals("VARBINARY"))) {
                    if (string.equals("TINYINT")) {
                        this.setValueAt(1, n, COLUMNS_COLS.SIZE.ordinal());
                    } else if (string.equals("SMALLINT")) {
                        this.setValueAt(2, n, COLUMNS_COLS.SIZE.ordinal());
                    } else if (string.equals("INTEGER") || string.equals("REAL") || string.equals("DATE") || string.equals("TIME")) {
                        this.setValueAt(4, n, COLUMNS_COLS.SIZE.ordinal());
                    } else if (string.equals("BIGINT") || string.equals("DOUBLE") || string.equals("TIMESTAMP")) {
                        this.setValueAt(8, n, COLUMNS_COLS.SIZE.ordinal());
                    } else if (!string.equals("NUMERIC") && !string.equals("DECIMAL")) {
                        if (string.equals("MONEY")) {
                            this.setValueAt(2, n, COLUMNS_COLS.SCALE.ordinal());
                        } else if (string.equals("FLOAT")) {
                            this.setValueAt(8, n, COLUMNS_COLS.SIZE.ordinal());
                        }
                    }
                }
                if (!(string.equals("TINYINT") || string.equals("SMALLINT") || string.equals("INTEGER") || string.equals("BIGINT"))) {
                    this.setValueAt(null, n, COLUMNS_COLS.SEED.ordinal());
                    this.setValueAt(null, n, COLUMNS_COLS.INCREMENT.ordinal());
                    this.setValueAt(false, n, COLUMNS_COLS.IDENTITY.ordinal());
                }
            } else if (n2 == COLUMNS_COLS.IDENTITY.ordinal() && !((Boolean)object).booleanValue()) {
                this.setValueAt(null, n, COLUMNS_COLS.SEED.ordinal());
                this.setValueAt(null, n, COLUMNS_COLS.INCREMENT.ordinal());
            }
            CreateSqlTable.this.buildStatement();
            this.fireTableDataChanged();
        }

        public boolean isCellEditable(int n, int n2) {
            String string;
            String string2;
            if (this.isReadOnly()) {
                return false;
            }
            if (this.readOnlyColumns != null && ((Boolean)this.readOnlyColumns.get(n2)).booleanValue()) {
                return false;
            }
            if (!Globals.currentSqlConnection.isIdentitySupported()) {
                if (n2 == COLUMNS_COLS.IDENTITY.ordinal() || n2 == COLUMNS_COLS.SEED.ordinal() || n2 == COLUMNS_COLS.INCREMENT.ordinal()) {
                    return false;
                }
            } else {
                if (n2 == COLUMNS_COLS.IDENTITY.ordinal()) {
                    String string3 = (String)this.getValueAt(n, COLUMNS_COLS.TYPE.ordinal());
                    return string3.equals("TINYINT") || string3.equals("SMALLINT") || string3.equals("INTEGER") || string3.equals("BIGINT");
                }
                if (!(n2 != COLUMNS_COLS.SEED.ordinal() && n2 != COLUMNS_COLS.INCREMENT.ordinal() || ((Boolean)this.getValueAt(n, COLUMNS_COLS.IDENTITY.ordinal())).booleanValue())) {
                    return false;
                }
            }
            return !(n2 == COLUMNS_COLS.NOT_NULL.ordinal() ? (Boolean)this.getValueAt(n, COLUMNS_COLS.PK.ordinal()) == true : (n2 == COLUMNS_COLS.SIZE.ordinal() ? (string2 = (String)this.getValueAt(n, COLUMNS_COLS.TYPE.ordinal())).equals("BIT") || string2.equals("TINYINT") || string2.equals("SMALLINT") || string2.equals("INTEGER") || string2.equals("REAL") || string2.equals("DATE") || string2.equals("TIME") || string2.equals("BIGINT") || string2.equals("REAL") || string2.equals("DOUBLE") || string2.equals("TIMESTAMP") || string2.equals("LVARCHAR") || string2.equals("LVARBINARY") : n2 == COLUMNS_COLS.SCALE.ordinal() && !(string = (String)this.getValueAt(n, COLUMNS_COLS.TYPE.ordinal())).equals("NUMERIC") && !string.equals("DECIMAL")));
        }
    }

    public class ColumnsTable
    extends FcBaseDynamicTable {
        ColumnsTableModel model;

        public ColumnsTable() {
            this.model = new ColumnsTableModel(this);
            this.setModel((TableModel)((Object)this.model));
            this.model.setupColumns();
            this.popupMenu = new JPopupMenu();
        }

        public void setupActions() {
            JMenuItem jMenuItem = new JMenuItem("Add");
            jMenuItem.addActionListener(new SqlActions(this, 1));
            this.popupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Insert");
            jMenuItem.addActionListener(new SqlActions(this, 2));
            this.popupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Delete");
            jMenuItem.addActionListener(new SqlActions(this, 3));
            this.popupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Move Up");
            jMenuItem.addActionListener(new SqlActions(this, 4));
            this.popupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Move Down");
            jMenuItem.addActionListener(new SqlActions(this, 5));
            this.popupMenu.add(jMenuItem);
        }

        public ColumnsTableModel getModel() {
            return this.model;
        }
    }

    public static enum COLUMNS_COLS {
        PK,
        NAME,
        TYPE,
        SIZE,
        SCALE,
        NOT_NULL,
        DEFAULT,
        IDENTITY,
        SEED,
        INCREMENT,
        REFERENCES,
        CHECK;


        public static COLUMNS_COLS fromInt(int n) {
            return COLUMNS_COLS.values()[n];
        }
    }
}

