/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import ctreeaceexplorer.Globals;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class CreateSynonym
extends JDialog {
    String currentUser = "";
    private JButton createButton;
    private JButton exitButton;
    private JCheckBox isPublicCB;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JTextField synNameTB;
    private JComboBox<String> tableNameCB;

    public CreateSynonym(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.createButton = new JButton();
        this.exitButton = new JButton();
        this.jLabel1 = new JLabel();
        this.isPublicCB = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.synNameTB = new JTextField();
        this.jLabel3 = new JLabel();
        this.tableNameCB = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Create Synonym");
        this.jPanel1.setName("jPanel1");
        this.createButton.setMnemonic('O');
        this.createButton.setText("Create");
        this.createButton.setName("createButton");
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateSynonym.this.createButtonActionPerformed(actionEvent);
            }
        });
        this.exitButton.setMnemonic('A');
        this.exitButton.setText("Exit");
        this.exitButton.setName("exitButton");
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateSynonym.this.exitButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(107, 107, 107).addComponent(this.createButton, -2, 75, -2).addGap(82, 82, 82).addComponent(this.exitButton, -2, 71, -2).addContainerGap(108, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exitButton).addComponent(this.createButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel1.setText("CREATE");
        this.jLabel1.setName("jLabel1");
        this.isPublicCB.setText("PUBLIC");
        this.isPublicCB.setName("isPublicCB");
        this.jLabel2.setText("SYNONYM");
        this.jLabel2.setName("jLabel2");
        this.synNameTB.setName("synNameTB");
        this.jLabel3.setText("Synonym Name :");
        this.jLabel3.setName("jLabel3");
        this.tableNameCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.tableNameCB.setName("tableNameCB");
        this.jLabel4.setText("Table / View / Synonym :");
        this.jLabel4.setName("jLabel4");
        this.jLabel5.setText("FOR");
        this.jLabel5.setName("jLabel5");
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(27, 27, 27).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.isPublicCB).addGap(18, 18, 18).addComponent(this.jLabel2)).addComponent(this.jLabel5)).addGap(18, 18, 18).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel3).addComponent(this.synNameTB, -1, 144, Short.MAX_VALUE).addComponent(this.tableNameCB, 0, 204, Short.MAX_VALUE))).addContainerGap()).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(31, 31, 31).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.isPublicCB).addComponent(this.jLabel2).addComponent(this.synNameTB, -2, -1, -2)).addGap(22, 22, 22).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tableNameCB, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 29, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void createButtonActionPerformed(ActionEvent actionEvent) {
        if (this.synNameTB.getText().isEmpty()) {
            Globals.showMessage("Missing Synonym Name", "Error");
            return;
        }
        try {
            String string = "CREATE ";
            if (this.isPublicCB.isSelected()) {
                string = string + "PUBLIC ";
            }
            string = string + "SYNONYM ";
            string = string + this.currentUser + "." + this.synNameTB.getText();
            String string2 = this.tableNameCB.getSelectedItem().toString();
            String[] stringArray = string2.split(" ");
            string = string + " FOR " + stringArray[0];
            Globals.currentSqlConnection.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "Create Synonym Error");
            return;
        }
        Globals.showOKMessage("Synonym Successfully Created", "Create v");
    }

    private void exitButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public void showDialog() {
        this.currentUser = Globals.currentSqlConnection.getSelectedUser();
        this.readTables();
        this.getRootPane().setDefaultButton(this.createButton);
        this.setVisible(true);
    }

    private void readTables() {
        String string = "select tbl from admin.systables where owner = '" + this.currentUser + "' order by tbltype, tbl";
        string = string + " union select sname from admin.syssynonyms where sowner = '" + this.currentUser + "'";
        string = "select tbl, tbltype from systables where owner = '" + this.currentUser + "' order by tbltype ";
        string = string + "union select sname, 'SYN' from admin.syssynonyms where sowner = '" + this.currentUser + "' order by 2 desc,1";
        this.tableNameCB.removeAllItems();
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string);
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    this.tableNameCB.addItem(this.currentUser + "." + resultSet.getString(1) + "  (" + resultSet.getString(2).trim() + ")");
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "Read Columns");
            }
        }
    }
}

