/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import FairCom.JCheckedListBox.JCheckedListBox;
import ctree.jdbc.CtreeSQLException;
import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.sql.CreateSqlTable;
import ctreeaceexplorer.sql.SQL_MODE;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;

public class CreateTrigger
extends JDialog {
    String triggerOwner = "";
    String triggerName = "";
    SQL_MODE mode;
    boolean loading = false;
    private JComboBox actionCB;
    private JCheckedListBox columnsLB;
    private JButton createButton;
    private JButton exitButton;
    private JCheckBox forEachCB;
    private JTextField importTB;
    private JComboBox insertCB;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JCheckBox newRowCB;
    private JCheckBox oldRowCB;
    private JTextArea procTextTA;
    private JCheckBox referencingCB;
    private JButton saveButton;
    private JTextArea statementTA;
    private JComboBox<String> tableNameCB;
    private JTextField triggerNameTB;

    public CreateTrigger(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.saveButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.statementTA = new JTextArea();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.procTextTA = new JTextArea();
        this.jPanel4 = new JPanel();
        this.importTB = new JTextField();
        this.jPanel5 = new JPanel();
        this.columnsLB = new JCheckedListBox();
        this.jPanel6 = new JPanel();
        this.actionCB = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.insertCB = new JComboBox();
        this.forEachCB = new JCheckBox();
        this.referencingCB = new JCheckBox();
        this.tableNameCB = new JComboBox();
        this.jLabel3 = new JLabel();
        this.oldRowCB = new JCheckBox();
        this.newRowCB = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.triggerNameTB = new JTextField();
        this.jPanel1 = new JPanel();
        this.createButton = new JButton();
        this.exitButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Create / View Trigger");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Resulting Statement", 0, 0, null, Color.blue));
        this.jPanel3.setName("jPanel3");
        this.saveButton.setText("Save Statement");
        this.saveButton.setName("saveButton");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateTrigger.this.saveButtonActionPerformed(actionEvent);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.statementTA.setColumns(1);
        this.statementTA.setFont(new Font("Tahoma", 0, 11));
        this.statementTA.setLineWrap(true);
        this.statementTA.setRows(10);
        this.statementTA.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.statementTA.setName("statementTA");
        this.jScrollPane1.setViewportView(this.statementTA);
        GroupLayout groupLayout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 557, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(234, 234, 234).addComponent(this.saveButton).addContainerGap(214, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 65, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveButton)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Text", 0, 0, null, Color.blue));
        this.jPanel2.setName("jPanel2");
        this.jScrollPane2.setName("jScrollPane2");
        this.procTextTA.setColumns(1);
        this.procTextTA.setFont(new Font("Tahoma", 0, 11));
        this.procTextTA.setLineWrap(true);
        this.procTextTA.setRows(1);
        this.procTextTA.setName("procTextTA");
        this.procTextTA.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CreateTrigger.this.procTextTAFocusLost(focusEvent);
            }
        });
        this.jScrollPane2.setViewportView(this.procTextTA);
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 557, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 107, Short.MAX_VALUE));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Import", 0, 0, null, Color.blue));
        this.jPanel4.setName("jPanel4");
        this.importTB.setName("importTB");
        this.importTB.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CreateTrigger.this.importTBFocusLost(focusEvent);
            }
        });
        GroupLayout groupLayout3 = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.importTB, -1, 557, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.importTB, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, "Columns", 0, 0, null, Color.blue));
        this.jPanel5.setName("jPanel5");
        this.columnsLB.setEnabled(false);
        this.columnsLB.setName("columnsLB");
        this.columnsLB.addMyEventListener(new JCheckedListBox.MyEventListener(){

            public void itemSelected(JCheckedListBox.SelectionEvent selectionEvent) {
                CreateTrigger.this.columnsLBItemSelected(selectionEvent);
            }

            public void itemChecked(JCheckedListBox.CheckedEvent checkedEvent) {
                CreateTrigger.this.columnsLBItemChecked(checkedEvent);
            }
        });
        GroupLayout groupLayout4 = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.columnsLB, -1, 557, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.columnsLB, -1, 76, Short.MAX_VALUE));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(null, "When / How", 0, 0, null, Color.blue));
        this.jPanel6.setName("jPanel6");
        this.actionCB.setModel(new DefaultComboBoxModel<String>(new String[]{"BEFORE", "AFTER"}));
        this.actionCB.setName("actionCB");
        this.actionCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateTrigger.this.actionCBActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setText("Action Time :");
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText("Event :");
        this.jLabel2.setName("jLabel2");
        this.insertCB.setModel(new DefaultComboBoxModel<String>(new String[]{"INSERT", "DELETE", "UPDATE"}));
        this.insertCB.setName("insertCB");
        this.insertCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateTrigger.this.insertCBActionPerformed(actionEvent);
            }
        });
        this.forEachCB.setText("FOR EACH ROW");
        this.forEachCB.setName("forEachCB");
        this.forEachCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateTrigger.this.forEachCBActionPerformed(actionEvent);
            }
        });
        this.referencingCB.setText("REFERENCING");
        this.referencingCB.setName("referencingCB");
        this.referencingCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateTrigger.this.referencingCBActionPerformed(actionEvent);
            }
        });
        this.tableNameCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.tableNameCB.setName("tableNameCB");
        this.tableNameCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateTrigger.this.tableNameCBActionPerformed(actionEvent);
            }
        });
        this.jLabel3.setText("Table Name :");
        this.jLabel3.setName("jLabel3");
        this.oldRowCB.setText("OLDROW");
        this.oldRowCB.setName("oldRowCB");
        this.oldRowCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateTrigger.this.oldRowCBActionPerformed(actionEvent);
            }
        });
        this.newRowCB.setText("NEWROW");
        this.newRowCB.setName("newRowCB");
        this.newRowCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateTrigger.this.newRowCBActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout5 = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addComponent(this.forEachCB).addGap(44, 44, 44).addComponent(this.referencingCB).addGap(60, 60, 60).addComponent(this.oldRowCB).addGap(58, 58, 58).addComponent(this.newRowCB)).addGroup(groupLayout5.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.actionCB, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 32, Short.MAX_VALUE).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.insertCB, -2, 73, -2).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tableNameCB, -2, 160, -2))).addContainerGap()));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.actionCB, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.tableNameCB, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.insertCB, -2, -1, -2)).addGap(18, 18, 18).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.forEachCB).addComponent(this.referencingCB).addComponent(this.oldRowCB).addComponent(this.newRowCB)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel4.setText("Trigger Name :");
        this.jLabel4.setName("jLabel4");
        this.triggerNameTB.setName("triggerNameTB");
        this.triggerNameTB.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CreateTrigger.this.triggerNameTBFocusLost(focusEvent);
            }
        });
        this.jPanel1.setName("jPanel1");
        this.createButton.setMnemonic('O');
        this.createButton.setText("Create");
        this.createButton.setName("createButton");
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateTrigger.this.createButtonActionPerformed(actionEvent);
            }
        });
        this.exitButton.setMnemonic('A');
        this.exitButton.setText("Exit");
        this.exitButton.setName("exitButton");
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateTrigger.this.exitButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout6 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addGap(179, 179, 179).addComponent(this.createButton, -2, 75, -2).addGap(82, 82, 82).addComponent(this.exitButton, -2, 71, -2).addContainerGap(142, Short.MAX_VALUE)));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createButton).addComponent(this.exitButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout7 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout7);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addGroup(groupLayout7.createSequentialGroup().addGap(183, 183, 183).addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.triggerNameTB, -2, 130, -2).addContainerGap(167, Short.MAX_VALUE)).addComponent(this.jPanel4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout7.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE));
        groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.triggerNameTB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addGap(8, 8, 8).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void createButtonActionPerformed(ActionEvent actionEvent) {
        if (this.triggerNameTB.getText().endsWith(".")) {
            Globals.showMessage("Missing Trigger Name", "Error");
            return;
        }
        try {
            Globals.currentSqlConnection.executeUpdate(this.statementTA.getText());
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == -20146) {
                JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
                String string = "A trigger with the same name already exist.\n\nDo you want to replace the existing trigger ?";
                Object[] objectArray = new Object[]{"Yes", "No"};
                int n = JOptionPane.showOptionDialog(jFrame, string, "Create Trigger", 0, 1, null, objectArray, objectArray[0]);
                if (n == 0) {
                    String string2 = "DROP TRIGGER " + this.triggerOwner + "." + this.triggerNameTB.getText();
                    try {
                        Globals.currentSqlConnection.executeUpdate(string2);
                        this.createButtonActionPerformed(actionEvent);
                        return;
                    }
                    catch (SQLException sQLException2) {
                        Globals.showException(sQLException2, "Create Trigger Error");
                        return;
                    }
                }
                return;
            }
            Globals.showException(sQLException, "Create Trigger Error");
            CtreeSQLException cfr_ignored_0 = (CtreeSQLException)sQLException;
            Globals.appFrame.showErrorPos(sQLException.getErrorCode(), CtreeSQLException.getErrorPosition(), this.statementTA.getText(), this.statementTA);
            return;
        }
        Globals.showOKMessage("Trigger Successfully Created", "Create Trigger");
    }

    private void exitButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveButtonActionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        JFileChooser jFileChooser = new JFileChooser();
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("script files (*.sql)", "sql");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setCurrentDirectory(new File(Globals.execDir));
        int n = jFileChooser.showSaveDialog(jFrame);
        if (n == 0) {
            OutputStreamWriter outputStreamWriter = null;
            try {
                File file = jFileChooser.getSelectedFile();
                String string = file.getAbsolutePath();
                if (!string.isEmpty() && !string.contains(".s")) {
                    string = string + ".sql";
                }
                outputStreamWriter = new FileWriter(string);
                outputStreamWriter.write(this.statementTA.getText());
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Save Statement");
            }
            finally {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(CreateSqlTable.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }
        }
    }

    private void procTextTAFocusLost(FocusEvent focusEvent) {
        this.buildStatement();
    }

    private void importTBFocusLost(FocusEvent focusEvent) {
        this.buildStatement();
    }

    private void buildStatement() {
        Object object;
        boolean bl = true;
        String string = "CREATE TRIGGER ";
        boolean bl2 = false;
        string = string + " " + this.triggerOwner + "." + this.triggerNameTB.getText();
        string = string + " " + this.actionCB.getSelectedItem();
        string = string + " " + this.insertCB.getSelectedItem();
        ArrayList arrayList = this.columnsLB.getCheckedItems();
        if (this.columnsLB.isEnabled() && !arrayList.isEmpty()) {
            string = string + " OF (";
            for (String[] stringArray : arrayList) {
                if (bl) {
                    bl = false;
                } else {
                    string = string + ", ";
                }
                string = string + "\"" + (String)stringArray + "\"";
            }
            string = string + " )";
        }
        string = string + " ON " + this.triggerOwner + "." + this.tableNameCB.getSelectedItem() + " ";
        if (this.referencingCB.isSelected()) {
            string = string + "REFERENCING ";
            object = this.insertCB.getSelectedItem().toString();
            if (((String)object).equals("INSERT")) {
                string = string + "NEWROW ";
            } else if (((String)object).equals("DELETE")) {
                string = string + "OLDROW ";
            } else if (((String)object).equals("UPDATE")) {
                if (this.newRowCB.isSelected()) {
                    string = string + "NEWROW ";
                    bl2 = true;
                }
                if (this.oldRowCB.isSelected()) {
                    if (bl2) {
                        string = string + ",";
                    }
                    string = string + "OLDROW ";
                }
            }
        }
        if (this.forEachCB.isSelected()) {
            string = string + "FOR EACH ROW";
        }
        if (!this.importTB.getText().isEmpty()) {
            String[] stringArray;
            string = string + "\nIMPORT\n";
            object = this.importTB.getText();
            for (String string2 : stringArray = ((String)object).split(" |;")) {
                if (string2.toLowerCase().equals("import") || string2.isEmpty() || (string = string + "import " + string2).endsWith(";")) continue;
                string = string + "; ";
            }
        }
        if (!this.procTextTA.getText().isEmpty()) {
            string = string + "\nBEGIN\n";
            string = string + this.procTextTA.getText();
            string = string + "\nEND\n";
        }
        this.statementTA.setText(string);
        this.statementTA.select(0, 0);
    }

    private void columnsLBItemSelected(JCheckedListBox.SelectionEvent selectionEvent) {
        this.buildStatement();
    }

    private void columnsLBItemChecked(JCheckedListBox.CheckedEvent checkedEvent) {
        this.buildStatement();
    }

    private void insertCBActionPerformed(ActionEvent actionEvent) {
        String string = this.insertCB.getSelectedItem().toString();
        if (string.equals("UPDATE")) {
            this.columnsLB.setEnabled(true);
            if (this.referencingCB.isSelected()) {
                this.oldRowCB.setEnabled(true);
                this.newRowCB.setEnabled(true);
            }
        } else if (string.equals("INSERT")) {
            this.columnsLB.setEnabled(false);
            if (this.referencingCB.isSelected()) {
                this.oldRowCB.setEnabled(false);
                this.newRowCB.setEnabled(false);
                this.oldRowCB.setSelected(false);
                this.newRowCB.setSelected(true);
            }
        } else if (string.equals("DELETE")) {
            this.columnsLB.setEnabled(false);
            if (this.referencingCB.isSelected()) {
                this.oldRowCB.setEnabled(false);
                this.newRowCB.setEnabled(false);
                this.oldRowCB.setSelected(true);
                this.newRowCB.setSelected(false);
            }
        }
        this.buildStatement();
    }

    private void forEachCBActionPerformed(ActionEvent actionEvent) {
        if (this.forEachCB.isSelected()) {
            this.referencingCB.setEnabled(true);
        } else {
            this.referencingCB.setEnabled(false);
            this.referencingCB.setSelected(false);
        }
        this.buildStatement();
    }

    private void referencingCBActionPerformed(ActionEvent actionEvent) {
        if (this.referencingCB.isSelected()) {
            String string = this.insertCB.getSelectedItem().toString();
            if (string.equals("UPDATE")) {
                this.columnsLB.setEnabled(true);
                if (this.referencingCB.isSelected()) {
                    this.oldRowCB.setEnabled(true);
                    this.newRowCB.setEnabled(true);
                }
            } else if (string.equals("INSERT")) {
                if (this.referencingCB.isSelected()) {
                    this.oldRowCB.setSelected(false);
                    this.newRowCB.setSelected(true);
                }
            } else if (string.equals("DELETE") && this.referencingCB.isSelected()) {
                this.oldRowCB.setSelected(true);
                this.newRowCB.setSelected(false);
            }
        } else {
            this.oldRowCB.setEnabled(false);
            this.newRowCB.setEnabled(false);
        }
        this.buildStatement();
    }

    private void oldRowCBActionPerformed(ActionEvent actionEvent) {
        this.buildStatement();
    }

    private void newRowCBActionPerformed(ActionEvent actionEvent) {
        this.buildStatement();
    }

    private void actionCBActionPerformed(ActionEvent actionEvent) {
        this.buildStatement();
    }

    private void tableNameCBActionPerformed(ActionEvent actionEvent) {
        if (!this.loading) {
            String string = this.tableNameCB.getSelectedItem().toString();
            this.readFields(string);
            this.buildStatement();
        }
    }

    private void triggerNameTBFocusLost(FocusEvent focusEvent) {
        this.buildStatement();
    }

    public void showDialog(SQL_MODE sQL_MODE, String string) {
        this.loading = true;
        this.triggerOwner = Globals.currentSqlConnection.getSelectedUser();
        this.mode = sQL_MODE;
        this.triggerName = string;
        this.readTables();
        if (sQL_MODE == SQL_MODE.TRIGGER_PROPERTIES) {
            this.triggerNameTB.setText(string);
            String string2 = "";
            String string3 = "";
            String string4 = "select tbl, tblowner, trigger_time, trigger_event, refers_to_old, refers_to_new, statement_or_row, triggerid from admin.systrigger where triggername = '" + string + "' and owner = '" + this.triggerOwner + "'";
            ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string4);
            if (resultSet != null) {
                try {
                    Object object;
                    String string5;
                    while (resultSet.next()) {
                        string3 = resultSet.getString(1);
                        this.tableNameCB.setSelectedItem(string3);
                        this.readFields(string3);
                        string5 = resultSet.getString(4);
                        this.oldRowCB.setEnabled(false);
                        this.newRowCB.setEnabled(false);
                        this.columnsLB.setEnabled(false);
                        this.referencingCB.setEnabled(false);
                        if (string5.equals("I")) {
                            this.insertCB.setSelectedItem("INSERT");
                            this.oldRowCB.setSelected(false);
                            this.newRowCB.setSelected(true);
                        } else if (string5.equals("D")) {
                            this.insertCB.setSelectedItem("DELETE");
                            this.oldRowCB.setSelected(true);
                            this.newRowCB.setSelected(false);
                        } else if (string5.equals("U")) {
                            this.insertCB.setSelectedItem("UPDATE");
                            this.oldRowCB.setEnabled(true);
                            this.newRowCB.setEnabled(true);
                            this.columnsLB.setEnabled(true);
                        }
                        string5 = resultSet.getString(5);
                        this.oldRowCB.setSelected(string5.equals("Y"));
                        string5 = resultSet.getString(6);
                        this.newRowCB.setSelected(string5.equals("Y"));
                        string5 = resultSet.getString(7);
                        this.forEachCB.setSelected(string5.equals("R"));
                        if (this.forEachCB.isSelected()) {
                            this.referencingCB.setEnabled(true);
                        }
                        if (this.oldRowCB.isSelected() || this.newRowCB.isSelected()) {
                            this.referencingCB.setSelected(true);
                        }
                        string2 = resultSet.getString(8);
                    }
                    resultSet.close();
                    string4 = "select colid from admin.systrigcols where triggername = '" + string + "' and owner = '" + this.triggerOwner + "'";
                    resultSet = Globals.currentSqlConnection.execRsQuery(string4);
                    string5 = "";
                    boolean bl = true;
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            if (bl) {
                                bl = false;
                                string5 = string5 + resultSet.getString(1).trim();
                                continue;
                            }
                            string5 = string5 + "," + resultSet.getString(1).trim();
                        }
                        resultSet.close();
                    }
                    if (!string5.isEmpty() && (resultSet = Globals.currentSqlConnection.execRsQuery(string4 = "select col from admin.syscolumns where tbl = '" + string3 + "' and owner = '" + this.triggerOwner + "' and id in(" + string5 + ")")) != null) {
                        object = this.columnsLB.getItems();
                        String string6 = "";
                        block4: while (resultSet.next()) {
                            string6 = resultSet.getString(1);
                            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                                if (!((String)((ArrayList)object).get(i)).equals(string6)) continue;
                                this.columnsLB.setItemChecked(i, true);
                                continue block4;
                            }
                        }
                        resultSet.close();
                    }
                    if (!string2.isEmpty() && (resultSet = Globals.currentSqlConnection.execRsQuery(string4 = "select proc_text from admin.sysproctext where id = " + string2 + " order by seq")) != null) {
                        object = "";
                        if (resultSet.next()) {
                            this.importTB.setText(resultSet.getString(1));
                        }
                        while (resultSet.next()) {
                            object = (String)object + resultSet.getString(1);
                        }
                        this.procTextTA.setText((String)object);
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    Globals.showException(sQLException, "Read Tables");
                }
            }
            this.buildStatement();
        }
        this.getRootPane().setDefaultButton(this.createButton);
        this.loading = false;
        this.setVisible(true);
    }

    private void readTables() {
        String string = "select tbl from admin.systables where owner = '" + this.triggerOwner + "' and tbltype = 'T' order by 1";
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string);
        this.tableNameCB.removeAllItems();
        this.tableNameCB.addItem("");
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    this.tableNameCB.addItem(resultSet.getString(1));
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "Read Tables");
            }
        }
    }

    private void readFields(String string) {
        String string2 = "select col from admin.syscolumns where tbl = '" + string + "' and owner = '" + this.triggerOwner + "' ";
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string2);
        this.columnsLB.removeAllItems();
        this.columnsLB.setVisibleRowCount(3);
        this.columnsLB.setLayoutOrientation(1);
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    this.columnsLB.add(resultSet.getString(1), Boolean.valueOf(false));
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "Read Tables");
            }
        }
    }
}

