/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import ctreeaceexplorer.Globals;
import ctreeaceexplorer.sql.SQL_MODE;
import ctreeaceexplorer.sql.TmpUser;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class CreateUserDialog
extends JDialog {
    SQL_MODE mode;
    private JButton cancelButton;
    private JCheckBox dbaCB;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField name;
    private JButton okButton;
    private JTextField pwd;
    private JTextField pwd2;
    private JCheckBox resourceCB;

    public CreateUserDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel2 = new JPanel();
        this.dbaCB = new JCheckBox();
        this.resourceCB = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.name = new JTextField();
        this.pwd = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.pwd2 = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Create User");
        this.setResizable(false);
        this.jPanel1.setName("jPanel1");
        this.okButton.setText("OK");
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateUserDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateUserDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(60, 60, 60).addComponent(this.okButton, -2, 71, -2).addGap(26, 26, 26).addComponent(this.cancelButton).addContainerGap(51, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(19, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Privileges"));
        this.jPanel2.setName("jPanel2");
        this.dbaCB.setText("DBA");
        this.dbaCB.setName("dbaCB");
        this.resourceCB.setText("Resource");
        this.resourceCB.setName("resourceCB");
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGap(34, 34, 34).addComponent(this.dbaCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 54, Short.MAX_VALUE).addComponent(this.resourceCB).addGap(37, 37, 37)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resourceCB).addComponent(this.dbaCB)).addContainerGap(16, Short.MAX_VALUE)));
        this.jLabel1.setText("User Name :");
        this.jLabel1.setName("jLabel1");
        this.name.setName("name");
        this.pwd.setName("pwd");
        this.jLabel2.setText("Password :");
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setText("Confirm Password :");
        this.jLabel3.setName("jLabel3");
        this.pwd2.setName("pwd2");
        GroupLayout groupLayout3 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.name).addComponent(this.pwd).addComponent(this.pwd2, -1, 143, Short.MAX_VALUE)).addContainerGap()).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap(26, Short.MAX_VALUE).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.name, -2, -1, -2)).addGap(18, 18, 18).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.pwd, -2, -1, -2)).addGap(18, 18, 18).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.pwd2, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        String string = "";
        boolean bl = false;
        if (this.mode == SQL_MODE.USER_CREATE) {
            if (this.name.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this, "Name field is empty", "Error", 0);
                return;
            }
            if (this.pwd.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this, "A Password is mandatory", "Error", 0);
                return;
            }
            if (!this.pwd.getText().equals(this.pwd2.getText())) {
                JOptionPane.showMessageDialog(this, "Passwords do not match", "Error", 0);
                return;
            }
            string = "call admin.fc_create_user('" + this.name.getText() + "','" + this.pwd.getText() + "')";
            try {
                Globals.currentSqlConnection.executeUpdate(string);
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "Create User");
                return;
            }
        }
        string = "revoke dba, resource from \"" + this.name.getText() + "\"";
        try {
            Globals.currentSqlConnection.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "grant ";
        if (this.dbaCB.isSelected()) {
            string = string + "dba";
            bl = true;
        }
        if (this.resourceCB.isSelected()) {
            if (bl) {
                string = string + ", ";
            }
            string = string + "resource";
            bl = true;
        }
        string = string + " to \"" + this.name.getText() + "\" ";
        if (bl) {
            try {
                Globals.currentSqlConnection.executeUpdate(string);
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "Create User");
                return;
            }
        }
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public void showDialog(SQL_MODE sQL_MODE, String string) {
        this.mode = sQL_MODE;
        if (sQL_MODE == SQL_MODE.USER_PRIVILEGES) {
            this.setTitle("Set User Privileges");
            this.name.setText(string);
            this.name.setEditable(false);
            this.pwd.setEditable(false);
            this.pwd2.setEditable(false);
            if (string.toLowerCase().equals("admin")) {
                this.dbaCB.setEnabled(false);
                this.resourceCB.setEnabled(false);
            }
            ArrayList<TmpUser> arrayList = Globals.currentSqlConnection.readUsersArray();
            for (TmpUser tmpUser : arrayList) {
                if (!tmpUser.Name.equals(string)) continue;
                if (tmpUser.isDBA != null) {
                    this.dbaCB.setSelected(true);
                }
                if (tmpUser.hasResource == null) continue;
                this.resourceCB.setSelected(true);
            }
        }
        this.getRootPane().setDefaultButton(this.okButton);
        this.setVisible(true);
    }
}

