/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.Helper.Editors.FcComboBoxCellEditor;
import FairCom.Helper.Renderers.FcStringCellRenderer;
import FairCom.JCheckedListBox.JCheckedListBox;
import FairCom.JCheckedListBox.ListItem;
import ctree.jdbc.CtreeSQLException;
import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.sql.CreateSqlTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class CreateView
extends JDialog {
    String tableOwner = "";
    String currentTable = "";
    String currentTableUser = "";
    DataTable selectedFields = new DataTable();
    WhereTable wTable = new WhereTable();
    boolean selectingFields;
    boolean checkingFields;
    private JCheckBox allUsersCB;
    private JButton createButton;
    private JButton exitButton;
    private JCheckedListBox fieldsLB;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JButton saveButton;
    private JTextArea statementTA;
    private JCheckBox sysTablesCB;
    private JCheckedListBox tablesLB;
    private JTextField viewNameTB;
    private JScrollPane whereScrollPane;
    private JCheckBox withCheckCB;

    public CreateView(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.setIconImage(Globals.getIcon("Table.png").getImage());
        this.whereScrollPane.setViewportView((Component)((Object)this.wTable));
        this.wTable.showRowHeader(this.whereScrollPane);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.createButton = new JButton();
        this.exitButton = new JButton();
        this.jPanel3 = new JPanel();
        this.saveButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.statementTA = new JTextArea();
        this.jPanel2 = new JPanel();
        this.whereScrollPane = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.sysTablesCB = new JCheckBox();
        this.allUsersCB = new JCheckBox();
        this.tablesLB = new JCheckedListBox();
        this.jPanel7 = new JPanel();
        this.fieldsLB = new JCheckedListBox();
        this.jLabel1 = new JLabel();
        this.viewNameTB = new JTextField();
        this.withCheckCB = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Create View");
        this.jPanel1.setName("jPanel1");
        this.createButton.setMnemonic('O');
        this.createButton.setText("Create");
        this.createButton.setName("createButton");
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateView.this.createButtonActionPerformed(actionEvent);
            }
        });
        this.exitButton.setMnemonic('A');
        this.exitButton.setText("Exit");
        this.exitButton.setName("exitButton");
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateView.this.exitButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(236, 236, 236).addComponent(this.createButton, -2, 75, -2).addGap(77, 77, 77).addComponent(this.exitButton, -2, 71, -2).addContainerGap(239, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exitButton).addComponent(this.createButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Resulting Statement", 0, 0, new Font("Tahoma", 0, 11), Color.blue));
        this.jPanel3.setName("jPanel3");
        this.saveButton.setText("Save Statement");
        this.saveButton.setName("saveButton");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateView.this.saveButtonActionPerformed(actionEvent);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.statementTA.setColumns(1);
        this.statementTA.setFont(new Font("Tahoma", 0, 11));
        this.statementTA.setLineWrap(true);
        this.statementTA.setRows(10);
        this.statementTA.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.statementTA.setName("statementTA");
        this.jScrollPane1.setViewportView(this.statementTA);
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 676, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addGap(285, 285, 285).addComponent(this.saveButton).addContainerGap(282, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.jScrollPane1, -1, 65, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveButton)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Where", 0, 0, new Font("Tahoma", 0, 11), Color.blue));
        this.jPanel2.setName("jPanel2");
        this.whereScrollPane.setName("whereScrollPane");
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setName("jTable1");
        this.whereScrollPane.setViewportView(this.jTable1);
        GroupLayout groupLayout3 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.whereScrollPane, GroupLayout.Alignment.TRAILING, -1, 676, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.whereScrollPane, -2, 100, -2));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Select From", 0, 0, new Font("Tahoma", 0, 11), Color.blue));
        this.jPanel4.setName("jPanel4");
        this.jPanel5.setName("jPanel5");
        this.jPanel6.setName("jPanel6");
        this.sysTablesCB.setText("Show System Tables");
        this.sysTablesCB.setName("sysTablesCB");
        this.sysTablesCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateView.this.sysTablesCBActionPerformed(actionEvent);
            }
        });
        this.allUsersCB.setText("Show All User's Tables");
        this.allUsersCB.setName("allUsersCB");
        this.allUsersCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateView.this.allUsersCBActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout4 = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGap(16, 16, 16).addComponent(this.sysTablesCB, -2, 147, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.allUsersCB, -2, 152, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sysTablesCB).addComponent(this.allUsersCB))));
        this.tablesLB.setName("tablesLB");
        this.tablesLB.addMyEventListener(new JCheckedListBox.MyEventListener(){

            public void itemChecked(JCheckedListBox.CheckedEvent checkedEvent) {
                CreateView.this.tablesLBItemChecked(checkedEvent);
            }

            public void itemSelected(JCheckedListBox.SelectionEvent selectionEvent) {
                CreateView.this.tablesLBItemSelected(selectionEvent);
            }
        });
        GroupLayout groupLayout5 = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addContainerGap()).addComponent((Component)this.tablesLB, -1, 333, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addComponent((Component)this.tablesLB, -2, 128, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -2, -1, -2).addContainerGap()));
        this.jPanel7.setName("jPanel7");
        this.fieldsLB.setName("fieldsLB");
        this.fieldsLB.addMyEventListener(new JCheckedListBox.MyEventListener(){

            public void itemChecked(JCheckedListBox.CheckedEvent checkedEvent) {
                CreateView.this.fieldsLBItemChecked(checkedEvent);
            }

            public void itemSelected(JCheckedListBox.SelectionEvent selectionEvent) {
            }
        });
        GroupLayout groupLayout6 = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.fieldsLB, -1, 337, Short.MAX_VALUE));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.fieldsLB, -1, 175, Short.MAX_VALUE));
        GroupLayout groupLayout7 = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(groupLayout7);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel7, -1, -1, Short.MAX_VALUE)));
        groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout7.createSequentialGroup().addGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel7, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.jLabel1.setText("View Name :");
        this.jLabel1.setName("jLabel1");
        this.viewNameTB.setName("viewNameTB");
        this.viewNameTB.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CreateView.this.viewNameTBFocusLost(focusEvent);
            }
        });
        this.withCheckCB.setText("WITH CHECK OPTION");
        this.withCheckCB.setName("withCheckCB");
        this.withCheckCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateView.this.withCheckCBActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout8 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout8);
        groupLayout8.setHorizontalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(groupLayout8.createSequentialGroup().addGap(82, 82, 82).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.viewNameTB, -2, 180, -2).addGap(69, 69, 69).addComponent(this.withCheckCB, -2, 166, -2).addContainerGap(132, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout8.createSequentialGroup().addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout8.setVerticalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout8.createSequentialGroup().addContainerGap(15, Short.MAX_VALUE).addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.withCheckCB).addComponent(this.viewNameTB, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel4, -2, 201, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void createButtonActionPerformed(ActionEvent actionEvent) {
        if (this.viewNameTB.getText().endsWith(".")) {
            Globals.showMessage("Missing View Name", "Error");
            return;
        }
        try {
            Globals.currentSqlConnection.executeUpdate(this.statementTA.getText());
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "Create View Error");
            CtreeSQLException cfr_ignored_0 = (CtreeSQLException)sQLException;
            Globals.appFrame.showErrorPos(sQLException.getErrorCode(), CtreeSQLException.getErrorPosition(), this.statementTA.getText(), this.statementTA);
            return;
        }
        Globals.showOKMessage("View Successfully Created", "Create View");
    }

    private void exitButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveButtonActionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        JFileChooser jFileChooser = new JFileChooser();
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("script files (*.sql)", "sql");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setCurrentDirectory(new File(Globals.execDir));
        int n = jFileChooser.showSaveDialog(jFrame);
        if (n == 0) {
            OutputStreamWriter outputStreamWriter = null;
            try {
                File file = jFileChooser.getSelectedFile();
                String string = file.getAbsolutePath();
                if (!string.isEmpty() && !string.contains(".s")) {
                    string = string + ".sql";
                }
                outputStreamWriter = new FileWriter(string);
                outputStreamWriter.write(this.statementTA.getText());
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Save Statement");
            }
            finally {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(CreateSqlTable.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }
        }
    }

    private void sysTablesCBActionPerformed(ActionEvent actionEvent) {
        this.readTables();
    }

    private void allUsersCBActionPerformed(ActionEvent actionEvent) {
        this.readTables();
    }

    private void tablesLBItemChecked(JCheckedListBox.CheckedEvent checkedEvent) {
        if (this.wTable.getCellEditor() != null) {
            this.wTable.getCellEditor().stopCellEditing();
        }
        if (checkedEvent.IsChecked().booleanValue()) {
            if (!this.selectingFields) {
                this.fieldsLB.setItemChecked(0, true);
                this.fieldsLB.checkedEvent(true, 0);
            }
        } else {
            int n = this.fieldsLB.getItemsCount();
            for (int i = 0; i < n; ++i) {
                this.fieldsLB.setItemChecked(i, false);
                this.fieldsLB.checkedEvent(false, i);
            }
        }
        this.setupTableCombo();
        this.buildStatement();
    }

    private void tablesLBItemSelected(JCheckedListBox.SelectionEvent selectionEvent) {
        ArrayList<String> arrayList;
        String string = selectionEvent.GetSelectedItemText();
        String[] stringArray = string.split(" ");
        if (stringArray.length > 1 && string.indexOf(40) != -1) {
            String[] stringArray2 = string.split("\\(");
            String string2 = stringArray2[1].replace(")", "");
            this.currentTableUser = string2 = string2.trim();
            arrayList = this.readFields(stringArray[0], string2);
        } else {
            this.currentTableUser = "";
            arrayList = this.readFields(stringArray[0], "");
        }
        this.currentTable = stringArray[0];
        if (arrayList != null) {
            arrayList.add(0, "* (All)");
            this.fieldsLB.setItems(arrayList);
        }
        this.setCheckedFields(this.currentTable, this.currentTableUser);
    }

    private void setCheckedFields(String string, String string2) {
        this.checkingFields = true;
        Object var3_3 = null;
        block0: for (TableRow tableRow : this.selectedFields.rows) {
            if (!tableRow.owner.equals(this.currentTableUser) || !tableRow.table.equals(this.currentTable)) continue;
            String string3 = tableRow.field;
            for (int i = 0; i < this.fieldsLB.getItemsCount(); ++i) {
                ListItem listItem = this.fieldsLB.get(i);
                if (!listItem.name.equals(string3)) continue;
                this.fieldsLB.setItemChecked(i, true);
                continue block0;
            }
        }
        this.checkingFields = false;
    }

    private void fieldsLBItemChecked(JCheckedListBox.CheckedEvent checkedEvent) {
        String string = checkedEvent.GetSelectedItemText();
        TableRow tableRow = null;
        boolean bl = false;
        for (TableRow tableRow2 : this.selectedFields.rows) {
            if (!tableRow2.owner.equals(this.currentTableUser) || !tableRow2.table.equals(this.currentTable) || !tableRow2.field.equals(string)) continue;
            if (checkedEvent.IsChecked().booleanValue()) {
                tableRow2.checked = true;
            } else {
                tableRow = tableRow2;
            }
            bl = true;
            break;
        }
        if (!bl && checkedEvent.IsChecked().booleanValue()) {
            TableRow tableRow3 = new TableRow(this.currentTableUser, this.currentTable, string);
            this.selectedFields.rows.add(tableRow3);
        } else if (tableRow != null) {
            this.selectedFields.rows.remove(tableRow);
        }
        bl = false;
        for (TableRow tableRow2 : this.selectedFields.rows) {
            if (!tableRow2.owner.equals(this.currentTableUser) || !tableRow2.table.equals(this.currentTable) || !tableRow2.checked) continue;
            bl = true;
        }
        int n = this.tablesLB.getSelectedItem();
        this.tablesLB.setItemChecked(n, bl);
        if (this.fieldsLB.getSelectedItems().size() > 1) {
            TableRow tableRow2;
            this.fieldsLB.setItemChecked(0, false);
            tableRow2 = null;
            for (TableRow tableRow4 : this.selectedFields.rows) {
                if (!tableRow4.owner.equals(this.currentTableUser) || !tableRow4.table.equals(this.currentTable) || !tableRow4.checked || !tableRow4.field.equals("* (All)")) continue;
                tableRow2 = tableRow4;
                break;
            }
            if (tableRow2 != null) {
                this.selectedFields.rows.remove(tableRow2);
            }
        }
        this.buildStatement();
    }

    private void withCheckCBActionPerformed(ActionEvent actionEvent) {
        this.buildStatement();
    }

    private void viewNameTBFocusLost(FocusEvent focusEvent) {
        this.buildStatement();
    }

    public void showDialog() {
        this.wTable.getModel().addNewRow();
        this.tableOwner = Globals.currentSqlConnection.getSelectedUser();
        this.viewNameTB.setText(this.tableOwner + ".");
        this.readTables();
        this.getRootPane().setDefaultButton(this.createButton);
        this.setVisible(true);
    }

    private void readTables() {
        ResultSet resultSet;
        String string = "select tbl, owner, tbltype from admin.systables where tbltype in ('T','V')";
        if (!this.allUsersCB.isSelected()) {
            string = string + " and owner = '" + this.tableOwner + "'";
        }
        if (this.sysTablesCB.isSelected()) {
            string = string + " union all select tbl, owner, tbltype from admin.systables where tbltype = 'S'";
        }
        if ((resultSet = Globals.currentSqlConnection.execRsQuery(string = string + " order by 3,2,1")) != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    string2 = this.padRight(string2, 150);
                    String string3 = resultSet.getString(3);
                    if (string3.equals("S")) {
                        string2 = string2 + "\t[ System Table]";
                    } else if (string3.equals("T")) {
                        string2 = string2 + "\t[ User Table]";
                    } else if (string3.equals("V")) {
                        string2 = string2 + "\t[   View   ]";
                    }
                    string3 = resultSet.getString(2);
                    string2 = this.padRight(string2, 230);
                    string2 = string2 + "\t( " + string3 + " )";
                    arrayList.add(string2);
                }
                resultSet.close();
                this.tablesLB.setItems(arrayList);
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "Read Columns");
            }
        }
    }

    private ArrayList<String> readFields(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = "select col from admin.syscolumns where tbl = '" + string + "' and owner = '" + string2 + "' order by id";
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string3);
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    String string4 = resultSet.getString(1);
                    arrayList.add(string4);
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "Read Fields");
            }
        }
        return arrayList;
    }

    private void buildStatement() {
        if (!this.selectedFields.rows.isEmpty()) {
            int n;
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (TableRow tableRow : this.selectedFields.rows) {
                String string2 = tableRow.owner;
                String string3 = "\"" + tableRow.table + "\"";
                String string4 = tableRow.field;
                string4 = string4.equals("* (All)") ? "*" : "\"" + string4 + "\"";
                string = string2 + "." + string3 + "." + string4;
                arrayList.add(string);
                string = string2 + "." + string3;
                if (arrayList2.contains(string)) continue;
                arrayList2.add(string);
            }
            string = "CREATE VIEW " + this.viewNameTB.getText() + " AS (SELECT ";
            for (n = 0; n < arrayList.size(); ++n) {
                string = string + (String)arrayList.get(n);
                if (n >= arrayList.size() - 1) continue;
                string = string + ", ";
            }
            string = string + " FROM ";
            for (n = 0; n < arrayList2.size(); ++n) {
                string = string + (String)arrayList2.get(n);
                if (n >= arrayList2.size() - 1) continue;
                string = string + ", ";
            }
            WhereTableModel whereTableModel = this.wTable.getModel();
            int n2 = whereTableModel.getRowCount();
            boolean bl = true;
            for (int i = 0; i < n2; ++i) {
                FcBaseTableModel.RowData rowData = whereTableModel.getRow(i);
                Object object = rowData.getValue(1);
                String string5 = "";
                if (object != null) {
                    string5 = object.toString();
                }
                if (string5.isEmpty()) continue;
                if (bl) {
                    bl = false;
                    string = string + " WHERE ";
                } else {
                    object = rowData.getValue(0);
                    if (object != null) {
                        string = string + " " + object.toString() + " ";
                    }
                }
                string = string + string5 + " ";
                String string6 = "";
                object = rowData.getValue(2);
                if (object != null) {
                    string6 = object.toString();
                }
                if (!string6.isEmpty()) {
                    string = string + string6 + " ";
                }
                String string7 = "";
                object = rowData.getValue(3);
                if (object == null || (string7 = object.toString()).isEmpty()) continue;
                string = string + string7;
            }
            string = string + ")";
            if (this.withCheckCB.isSelected()) {
                string = string + " WITH CHECK OPTION";
            }
            this.statementTA.setText(string);
        } else {
            this.statementTA.setText("");
        }
    }

    public String padRight(String string, int n) {
        Graphics graphics = this.tablesLB.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.tablesLB.getFont());
        int n2 = fontMetrics.stringWidth(string);
        while (n2 < n) {
            string = string + " ";
            n2 = fontMetrics.stringWidth(string);
        }
        return string;
    }

    private void setupTableCombo() {
        Object object;
        FcComboBoxCellEditor fcComboBoxCellEditor;
        String string2;
        ArrayList<String> arrayList = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList arrayList3 = this.tablesLB.getSelectedItems();
        arrayList2.add("");
        for (String string2 : arrayList3) {
            fcComboBoxCellEditor = string2.split(" ");
            object = "";
            if (((String[])fcComboBoxCellEditor).length > 1 && string2.indexOf(40) != -1) {
                String[] stringArray = string2.split("\\(");
                object = stringArray[1].replace(")", "");
                object = object.trim();
                arrayList = this.readFields((String)fcComboBoxCellEditor[0], (String)object);
            }
            if (arrayList == null) continue;
            for (String string3 : arrayList) {
                arrayList2.add((String)object + ".\"" + (String)fcComboBoxCellEditor[0] + "\".\"" + string3 + "\"");
            }
        }
        TableColumn tableColumn = this.wTable.getColumnModel().getColumn(1);
        string2 = null;
        fcComboBoxCellEditor = (FcComboBoxCellEditor)tableColumn.getCellEditor();
        if (!arrayList2.isEmpty()) {
            object = new String[arrayList2.size()];
            object = arrayList2.toArray((T[])object);
            if (string2 != null) {
                string2.setItems(object);
            }
            fcComboBoxCellEditor.setItems(tableColumn, object);
        } else {
            if (string2 != null) {
                string2.removeAllItems();
            }
            fcComboBoxCellEditor.removeAllItems();
        }
    }

    public class WhereTableModel
    extends FcBaseTableModel {
        WhereTable table;

        public WhereTableModel(WhereTable whereTable) {
            super((FcBaseDynamicTable)whereTable, false);
            this.table = whereTable;
            this.showNullAsEmpty = true;
        }

        public void setValueAt(Object object, int n, int n2) {
            super.setValueAt(object, n, n2);
            if (this.autoAddRows && object != null && n == this.getRowCount() - 1 && object instanceof String && !object.toString().isEmpty()) {
                this.addNewRow();
            }
            CreateView.this.buildStatement();
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"And / Or", "Columns", "Operator", "Value"};
            Integer[] integerArray = new Integer[]{1, 1, 1, 1};
            String[] stringArray2 = new String[]{"", "AND", "OR", "NOT"};
            String[] stringArray3 = new String[]{"", "=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "CONTAINS", "NOT CONTAINS", "EXITS", "IN", "NOT IN", "IS NULL", "IS NOT NULL", "LIKE", "NOT LIKE"};
            this.clearTable();
            this.numberOfColumns = stringArray.length;
            this.addColumns(stringArray, integerArray);
            this.autoSizeColumns.set(3, true);
            this.autoAddRows = true;
            super.fireTableStructureChanged();
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setCellEditor((TableCellEditor)new FcComboBoxCellEditor(stringArray2));
            tableColumn.setPreferredWidth(100);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setCellRenderer((TableCellRenderer)new FcStringCellRenderer(true));
            tableColumn.setCellEditor((TableCellEditor)new FcComboBoxCellEditor());
            tableColumn.setPreferredWidth(150);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setCellEditor((TableCellEditor)new FcComboBoxCellEditor(stringArray3));
            tableColumn.setPreferredWidth(100);
        }

        public void addNewRow() {
            this.addRow(this.createNewRow());
            this.fireTableDataChanged();
        }

        public ArrayList<Object> createNewRow() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            return arrayList;
        }
    }

    public class WhereTable
    extends FcBaseDynamicTable {
        WhereTableModel model;

        public WhereTable() {
            this.model = new WhereTableModel(this);
            this.setModel((TableModel)((Object)this.model));
            this.model.setupColumns();
            this.setRowSorter(null);
        }

        public WhereTableModel getModel() {
            return this.model;
        }
    }

    public class DataTable {
        public ArrayList<TableRow> rows = new ArrayList();

        public void Add(TableRow tableRow) {
            this.rows.add(tableRow);
        }
    }

    public class TableRow {
        public String owner;
        public String table;
        public String field;
        public boolean checked;

        public TableRow(String string, String string2, String string3) {
            this.owner = string;
            this.table = string2;
            this.field = string3;
            this.checked = true;
        }
    }
}

