/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import FairCom.Helper.Classes.CtreeServer;
import ctree.jdbc.CtreeSQLException;
import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.EXIT_CODE;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.Warnings;
import ctreeaceexplorer.sql.ForeignServer;
import ctreeaceexplorer.sql.SqlConnection;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class CtreeACEDestServer {
    String quote = "\"";
    String tableOwner;
    String database;
    boolean stopOnSyntaxErrors;
    boolean convertToLower;
    SqlConnection conn;
    final String[] RESERVER_WORDS = new String[]{"A", "ACTUAL_COST", "ADD", "ALL", "ALLOCATE", "ALTER", "AN", "AND", "ANY", "ARRAY", "AS", "ASC", "ASCENDING", "AUTO", "AUTO_UNIQUE_VALUE", "AVG", "BASE_COLUMN_NAME", "BASE_TABLE_NAME", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BIND", "BINDING", "BIT", "BY", "CASE_SENSITIVE", "CHAR", "CHARACTER", "CHARACTER_SET_NAME", "CHECK", "CLASS_ORIGIN", "COALESCE", "COLLATION_NAME", "COLUMN_NAME", "COMMIT", "COMMITTED", "COMPLEX", "CONDITION_NUMBER", "CONNECTION_ID", "CONSTRAINT", "CONTINUE", "CONVERT", "COUNT", "CREATE", "CURRENT", "CURSOR", "DATA", "DATABASE", "DATE", "DEC", "DECIMAL", "DECLARATION", "DECLARE", "DEFAULT", "DEFINITION", "DELETE", "DESC", "DESCENDING", "DESCRIBE", "DESCRIPTOR", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOUBLE", "DROP", "ELSE", "END", "ESCAPE", "ESTIMATED_COST", "EXCEPTION", "EXCLUSIVE", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXPLICIT", "EXTERN", "FETCH", "FILE", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "GET", "GO", "GOTO", "GRANT", "GROUP", "HASH", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INDEX", "INDICATOR", "INNER", "INPUT", "INSERT", "INT", "INTEGER", "INTERFACE", "INTERSECT", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LAST", "LEFT", "LENGTH", "LEVEL", "LIKE", "LINK", "LIST", "LOCK", "LONG", "MAIN", "MAX", "MESSAGE_LENGTH", "MESSAGE_TEXT", "MIN", "MINUS", "MODE", "MODIFY", "MONEY", "MORE", "NAME", "NCHAR", "NOCOMPRESS", "NOT", "NOWAIT", "NULL", "NULLABLE", "NUMBER", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "PARAMETER_TYPE", "PCTFREE", "PRECISION", "PREPARE", "PRIMARY", "PRIVILEGES", "PUBLIC", "READ", "REAL", "RECORD", "RECURSIVE", "REFERENCES", "RENAME", "REPEATABLE", "RESOURCE", "RETURN", "RETURNED_LENGTH", "RETURNED_SQLSTATE", "REVOKE", "RIGHT", "ROLLBACK", "ROWID", "ROW_COUNT", "SAVEPOINT", "SCALE", "SEARCHABLE", "SECTION", "SELECT", "SERIALIZABLE", "SERVICE", "SET", "SHARE", "SHORT", "SIZE", "SKIP", "SMALLINT", "SOME", "SPACE", "SQL", "SQLERROR", "SQLWARNING", "START", "STATIC", "STOP", "STORAGE_ATTRIBUTES", "SUBCLASS_ORIGIN", "SUM", "SYNONYM", "SYSDATE", "SYSTIME", "SYSTIMESTAMP", "TABLE", "TABLE_NAME", "TIME", "TIMEOUT", "TIMESTAMP", "TINYINT", "TO", "TPE", "TRANSACTION", "TRUNCATE", "TYPE", "UID", "UNCOMMITTED", "UNION", "UNIQUE", "UNNAMED", "UNSIGNED", "UPDATABLE", "UPDATE", "USER", "USING", "UUID", "VALUE", "VALUES", "VARBINARY", "VARCHAR", "VARIABLES", "VERBOSE_TYPE", "VERSION", "VIEW", "WHENEVER", "WHERE", "WITH", "WORK"};

    CtreeACEDestServer(SqlConnection sqlConnection, String string, String string2, boolean bl, boolean bl2) {
        this.database = string;
        this.tableOwner = string2.equals("Source Owner") ? "" : string2;
        this.stopOnSyntaxErrors = bl;
        this.convertToLower = bl2;
        CtreeServer ctreeServer = new CtreeServer((CtreeServer)sqlConnection);
        this.conn = new SqlConnection(ctreeServer, string, false, true);
        this.conn.setAutoCommit(false);
    }

    public boolean isUnicodeServer() {
        return this.conn.isUnicodeServer();
    }

    void disconnect() {
        if (this.conn != null && this.conn.isConnected()) {
            this.conn.commit();
            this.conn.disconnect();
        }
    }

    public boolean addCtreeACETable(ForeignServer.TableSchema tableSchema, BufferedWriter bufferedWriter) {
        if (tableSchema.Columns.isEmpty()) {
            return true;
        }
        String string = this.buildCreateTableStatement(tableSchema);
        Globals.appFrame.objNameLabel.setText("Creating Table \"" + tableSchema.TableName + "\"");
        if (bufferedWriter != null) {
            try {
                bufferedWriter.write(string);
                bufferedWriter.write(";");
                bufferedWriter.newLine();
                bufferedWriter.newLine();
            }
            catch (IOException iOException) {
                Logger.getLogger(CtreeACEDestServer.class.getName()).log(Level.SEVERE, null, iOException);
            }
            return true;
        }
        try {
            this.conn.executeUpdate(string);
            return true;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != -20041) {
                tableSchema.CreationFailed = true;
            }
            return this.showException(sQLException);
        }
    }

    public boolean createView(ForeignServer.ViewSchema viewSchema, StringBuilder stringBuilder, BufferedWriter bufferedWriter) {
        boolean bl = false;
        String string = this.buildCreateViewStatement(viewSchema);
        Globals.appFrame.objNameLabel.setText("Creating View \"" + viewSchema.ViewName + "\"");
        while (true) {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.write(string);
                    bufferedWriter.write(";");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                }
                catch (IOException iOException) {
                    Logger.getLogger(CtreeACEDestServer.class.getName()).log(Level.SEVERE, null, iOException);
                }
                return true;
            }
            try {
                this.conn.executeUpdate(string);
                return true;
            }
            catch (SQLException sQLException) {
                if (this.stopOnSyntaxErrors) {
                    JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
                    Warnings warnings = new Warnings((Frame)jFrame, true);
                    warnings.setWarningText(string);
                    warnings.setErrorMessage(sQLException.getErrorCode() + ": " + sQLException.getMessage());
                    CtreeSQLException cfr_ignored_0 = (CtreeSQLException)sQLException;
                    warnings.setErrorPosition(CtreeSQLException.getErrorPosition());
                    warnings.setLocationRelativeTo(jFrame);
                    EXIT_CODE eXIT_CODE = warnings.showDialog(false, "View");
                    if (eXIT_CODE == EXIT_CODE.OK) {
                        string = warnings.getWarningText();
                        continue;
                    }
                    if (eXIT_CODE == EXIT_CODE.RETRY) {
                        return true;
                    }
                    return this.showException(sQLException);
                }
                stringBuilder.append("Create View statement for View \"").append(viewSchema.ViewName).append("\" failed with the following error : \n").append(sQLException.getErrorCode()).append(": ").append(sQLException.getMessage()).append("\nThe statement in error was:\n").append(string).append("\n\n");
                bl = true;
                if (!bl) continue;
                return true;
            }
            break;
        }
    }

    public boolean createSynonym(ForeignServer.SynonymSchema synonymSchema, StringBuilder stringBuilder, BufferedWriter bufferedWriter) {
        boolean bl = false;
        String string = this.buildCreateSynonymStatement(synonymSchema);
        Globals.appFrame.objNameLabel.setText("Creating View \"" + synonymSchema.SynonymName + "\"");
        while (true) {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.write(string);
                    bufferedWriter.write(";");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                }
                catch (IOException iOException) {
                    Logger.getLogger(CtreeACEDestServer.class.getName()).log(Level.SEVERE, null, iOException);
                }
                return true;
            }
            try {
                this.conn.executeUpdate(string);
                return true;
            }
            catch (SQLException sQLException) {
                if (this.stopOnSyntaxErrors) {
                    JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
                    Warnings warnings = new Warnings((Frame)jFrame, true);
                    warnings.setWarningText(string);
                    warnings.setErrorMessage(sQLException.getErrorCode() + ": " + sQLException.getMessage());
                    CtreeSQLException cfr_ignored_0 = (CtreeSQLException)sQLException;
                    warnings.setErrorPosition(CtreeSQLException.getErrorPosition());
                    warnings.setLocationRelativeTo(jFrame);
                    EXIT_CODE eXIT_CODE = warnings.showDialog(false, "Synonym");
                    if (eXIT_CODE == EXIT_CODE.OK) {
                        string = warnings.getWarningText();
                        continue;
                    }
                    if (eXIT_CODE == EXIT_CODE.RETRY) {
                        return true;
                    }
                    return this.showException(sQLException);
                }
                stringBuilder.append("Create Synonym statement for Synonym \"").append(synonymSchema.SynonymName).append("\" failed with the following error : \n").append(sQLException.getErrorCode()).append(": ").append(sQLException.getMessage()).append("\nThe statement in error was:\n").append(string).append("\n\n");
                bl = true;
                if (!bl) continue;
                return true;
            }
            break;
        }
    }

    public boolean createPK(ForeignServer.TableSchema tableSchema, StringBuilder stringBuilder, BufferedWriter bufferedWriter) {
        try {
            Globals.appFrame.objNameLabel.setText("Creating Primary Keys for Table : " + tableSchema.TableName);
            boolean bl = false;
            if (tableSchema.PrimaryKey != null && tableSchema.PrimaryKey.size() > 0) {
                do {
                    String string = this.buildCreatePKStatement(tableSchema);
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.write(string);
                            bufferedWriter.write(";");
                            bufferedWriter.newLine();
                            bufferedWriter.newLine();
                            bl = true;
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(CtreeACEDestServer.class.getName()).log(Level.SEVERE, null, iOException);
                        }
                        continue;
                    }
                    try {
                        this.conn.executeUpdate(string);
                        bl = true;
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getErrorCode() == -17018) {
                            if (tableSchema.PrimaryKeyConstraintName.equals(tableSchema.TableName + tableSchema.PrimaryKeyConstraintName)) continue;
                            stringBuilder.append("The PrimaryKey for Table \"").append(tableSchema.TableName).append("\" has been renamed from \"").append(tableSchema.PrimaryKeyConstraintName).append("\" to \"").append(tableSchema.TableName).append(tableSchema.PrimaryKeyConstraintName).append("\"\n");
                            tableSchema.PrimaryKeyConstraintName = tableSchema.TableName + tableSchema.PrimaryKeyConstraintName;
                            continue;
                        }
                        throw sQLException;
                    }
                } while (!bl);
            }
            return true;
        }
        catch (SQLException sQLException) {
            return this.showException(sQLException);
        }
    }

    public boolean createUK(ForeignServer.TableSchema tableSchema, StringBuilder stringBuilder, BufferedWriter bufferedWriter) {
        try {
            Globals.appFrame.objNameLabel.setText("Creating Unique Keys for Table : " + tableSchema.TableName);
            boolean bl = false;
            for (ForeignServer.UniqueConstraint uniqueConstraint : tableSchema.UniqueKeys) {
                do {
                    String string = this.buildCreateUKStatement(tableSchema, uniqueConstraint);
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.write(string);
                            bufferedWriter.write(";");
                            bufferedWriter.newLine();
                            bufferedWriter.newLine();
                            bl = true;
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(CtreeACEDestServer.class.getName()).log(Level.SEVERE, null, iOException);
                        }
                        continue;
                    }
                    try {
                        this.conn.executeUpdate(string);
                        bl = true;
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getErrorCode() == -17018) {
                            if (uniqueConstraint.UniqueConstraintName.equals(tableSchema.TableName + uniqueConstraint.UniqueConstraintName)) continue;
                            stringBuilder.append("The UniqueKey for Table \"").append(tableSchema.TableName).append("\" has been renamed from \"").append(uniqueConstraint.UniqueConstraintName).append("\" to \"").append(tableSchema.TableName).append(uniqueConstraint.UniqueConstraintName).append("\"\n");
                            uniqueConstraint.UniqueConstraintName = tableSchema.TableName + uniqueConstraint.UniqueConstraintName;
                            continue;
                        }
                        throw sQLException;
                    }
                } while (!bl);
            }
            return true;
        }
        catch (SQLException sQLException) {
            return this.showException(sQLException);
        }
    }

    public boolean createFK(ForeignServer.TableSchema tableSchema, StringBuilder stringBuilder, BufferedWriter bufferedWriter) {
        try {
            Globals.appFrame.objNameLabel.setText("Creating Foreign Keys for Table : " + tableSchema.TableName);
            boolean bl = false;
            for (ForeignServer.ForeignKey foreignKey : tableSchema.ForeignKeys) {
                do {
                    String string = this.buildCreateFKStatement(tableSchema, foreignKey);
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.write(string);
                            bufferedWriter.write(";");
                            bufferedWriter.newLine();
                            bufferedWriter.newLine();
                            bl = true;
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(CtreeACEDestServer.class.getName()).log(Level.SEVERE, null, iOException);
                        }
                        continue;
                    }
                    try {
                        this.conn.executeUpdate(string);
                        bl = true;
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getErrorCode() == -17018) {
                            if (foreignKey.ForeignConstraintName.equals(tableSchema.TableName + foreignKey.ForeignConstraintName)) continue;
                            stringBuilder.append("The Foreign Key for Table \"").append(tableSchema.TableName).append("\" has been renamed from \"").append(foreignKey.ForeignConstraintName).append("\" to \"").append(tableSchema.TableName).append(foreignKey.ForeignConstraintName).append("\"\n");
                            foreignKey.ForeignConstraintName = tableSchema.TableName + foreignKey.ForeignConstraintName;
                            continue;
                        }
                        throw sQLException;
                    }
                } while (!bl);
            }
            return true;
        }
        catch (SQLException sQLException) {
            return this.showException(sQLException);
        }
    }

    public boolean createCheck(ForeignServer.TableSchema tableSchema, StringBuilder stringBuilder, BufferedWriter bufferedWriter) {
        try {
            Globals.appFrame.objNameLabel.setText("Creating Check Constraints for Table : " + tableSchema.TableName);
            boolean bl = false;
            for (ForeignServer.CheckConstraint checkConstraint : tableSchema.CheckConstraints) {
                do {
                    String string = this.buildCreateCheckStatement(tableSchema, checkConstraint);
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.write(string);
                            bufferedWriter.write(";");
                            bufferedWriter.newLine();
                            bufferedWriter.newLine();
                            bl = true;
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(CtreeACEDestServer.class.getName()).log(Level.SEVERE, null, iOException);
                        }
                        continue;
                    }
                    try {
                        this.conn.executeUpdate(string);
                        bl = true;
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getErrorCode() == -17018) {
                            if (checkConstraint.ConstraintName.equals(tableSchema.TableName + checkConstraint.ConstraintName)) continue;
                            stringBuilder.append("The UniqueKey for Table \"").append(tableSchema.TableName).append("\" has been renamed from \"").append(checkConstraint.ConstraintName).append("\" to \"").append(tableSchema.TableName).append(checkConstraint.ConstraintName).append("\"\n");
                            checkConstraint.ConstraintName = tableSchema.TableName + checkConstraint.ConstraintName;
                            continue;
                        }
                        throw sQLException;
                    }
                } while (!bl);
            }
            return true;
        }
        catch (SQLException sQLException) {
            return this.showException(sQLException);
        }
    }

    public boolean createIndexes(ForeignServer.TableSchema tableSchema, StringBuilder stringBuilder, BufferedWriter bufferedWriter) {
        try {
            Globals.appFrame.objNameLabel.setText("Creating Indexes for Table : " + tableSchema.TableName);
            boolean bl = false;
            int n = 1;
            for (ForeignServer.IndexSchema indexSchema : tableSchema.Indexes) {
                Globals.appFrame.importProgressBar.setValue(n++);
                this.createIndex(tableSchema, indexSchema, stringBuilder, bufferedWriter);
            }
            return true;
        }
        catch (SQLException sQLException) {
            return this.showException(sQLException);
        }
    }

    private void createIndex(ForeignServer.TableSchema tableSchema, ForeignServer.IndexSchema indexSchema, StringBuilder stringBuilder, BufferedWriter bufferedWriter) throws SQLException {
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl = false;
        String string = indexSchema.IndexName;
        String string2 = "";
        string2 = !this.tableOwner.isEmpty() ? this.tableOwner : tableSchema.TableOwner;
        do {
            stringBuilder2.setLength(0);
            stringBuilder2.append("CREATE ");
            if (indexSchema.IsUnique) {
                stringBuilder2.append("UNIQUE ");
            }
            stringBuilder2.append("INDEX ").append(this.quote);
            stringBuilder2.append(string2).append(this.quote).append(".").append(this.quote);
            stringBuilder2.append(this.convertCase(string)).append(this.quote);
            stringBuilder2.append(" ON ").append(this.quote);
            stringBuilder2.append(string2).append(this.quote).append(".").append(this.quote);
            stringBuilder2.append(this.convertCase(tableSchema.TableName)).append(this.quote);
            stringBuilder2.append("(");
            for (int i = 0; i < indexSchema.Columns.size(); ++i) {
                stringBuilder2.append(this.quote).append(this.convertCase(indexSchema.Columns.get((int)i).ColumnName)).append(this.quote);
                if (!indexSchema.Columns.get((int)i).IsAscending) {
                    stringBuilder2.append(" DESC");
                }
                if (i >= indexSchema.Columns.size() - 1) continue;
                stringBuilder2.append(", ");
            }
            stringBuilder2.append(")");
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.write(stringBuilder2.toString());
                    bufferedWriter.write(";");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bl = true;
                }
                catch (IOException iOException) {
                    Logger.getLogger(CtreeACEDestServer.class.getName()).log(Level.SEVERE, null, iOException);
                }
                continue;
            }
            try {
                this.conn.executeUpdate(stringBuilder2.toString());
                bl = true;
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == -20028 || sQLException.getErrorCode() == -17018) {
                    if (this.checkIndex(string2, tableSchema.TableName, string)) {
                        throw sQLException;
                    }
                    if (!string.equals(tableSchema.TableName + string)) {
                        stringBuilder.append("The Index \"").append(string).append("\" for Table \"").append(tableSchema.TableName).append("\" has been renamed to \"").append(tableSchema.TableName).append(string).append("\"\n");
                        string = tableSchema.TableName + string;
                        continue;
                    }
                    throw sQLException;
                }
                throw sQLException;
            }
        } while (!bl);
    }

    private boolean checkIndex(String string, String string2, String string3) {
        String string4 = "select count(*) from admin.sysindexes where tbl = '" + string2 + "' and tblowner = '" + string + "' and idxname = '" + string3 + "'";
        int n = 0;
        try {
            ResultSet resultSet = this.conn.executeQuery(string4);
            resultSet.next();
            n = resultSet.getInt(1);
        }
        catch (SQLException sQLException) {
            Logger.getLogger(CtreeACEDestServer.class.getName()).log(Level.SEVERE, null, sQLException);
        }
        return n == 1;
    }

    private String buildCreateTableStatement(ForeignServer.TableSchema tableSchema) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE TABLE ").append(this.quote);
        if (!this.tableOwner.isEmpty()) {
            stringBuilder.append(this.tableOwner).append(this.quote).append(".").append(this.quote);
        } else {
            stringBuilder.append(tableSchema.TableOwner).append(this.quote).append(".").append(this.quote);
        }
        stringBuilder.append(this.convertCase(tableSchema.TableName)).append(this.quote).append(" (");
        for (int i = 0; i < tableSchema.Columns.size(); ++i) {
            ForeignServer.ColumnSchema columnSchema = tableSchema.Columns.get(i);
            String string = this.buildColumnStatement(columnSchema);
            stringBuilder.append(string);
            if (i >= tableSchema.Columns.size() - 1) continue;
            stringBuilder.append(", \n");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private String buildCreateUKStatement(ForeignServer.TableSchema tableSchema, ForeignServer.UniqueConstraint uniqueConstraint) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ALTER TABLE ").append(this.quote);
        if (!this.tableOwner.isEmpty()) {
            stringBuilder.append(this.tableOwner).append(this.quote).append(".").append(this.quote);
        } else {
            stringBuilder.append(tableSchema.TableOwner).append(this.quote).append(".").append(this.quote);
        }
        stringBuilder.append(this.convertCase(tableSchema.TableName)).append(this.quote);
        stringBuilder.append(" ADD");
        if (!uniqueConstraint.UniqueConstraintName.isEmpty()) {
            stringBuilder.append(" CONSTRAINT ").append(this.quote).append(this.convertCase(uniqueConstraint.UniqueConstraintName)).append(this.quote);
        }
        stringBuilder.append(" UNIQUE (");
        for (int i = 0; i < uniqueConstraint.UniqueConstraintColumns.size(); ++i) {
            stringBuilder.append(this.quote).append(this.convertCase(uniqueConstraint.UniqueConstraintColumns.get(i))).append(this.quote);
            if (i >= uniqueConstraint.UniqueConstraintColumns.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private String buildCreatePKStatement(ForeignServer.TableSchema tableSchema) {
        StringBuilder stringBuilder = new StringBuilder();
        if (tableSchema.PrimaryKey != null && tableSchema.PrimaryKey.size() > 0) {
            stringBuilder.append("ALTER TABLE ").append(this.quote);
            if (!this.tableOwner.isEmpty()) {
                stringBuilder.append(this.tableOwner).append(this.quote).append(".").append(this.quote);
            } else {
                stringBuilder.append(tableSchema.TableOwner).append(this.quote).append(".").append(this.quote);
            }
            stringBuilder.append(this.convertCase(tableSchema.TableName)).append(this.quote);
            stringBuilder.append(" ADD");
            if (!tableSchema.PrimaryKeyConstraintName.isEmpty()) {
                stringBuilder.append(" CONSTRAINT ").append(this.quote).append(this.convertCase(tableSchema.PrimaryKeyConstraintName)).append(this.quote);
            }
            stringBuilder.append(" PRIMARY KEY (");
            for (int i = 0; i < tableSchema.PrimaryKey.size(); ++i) {
                stringBuilder.append(this.quote).append(this.convertCase(tableSchema.PrimaryKey.get(i))).append(this.quote);
                if (i >= tableSchema.PrimaryKey.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    private String buildCreateFKStatement(ForeignServer.TableSchema tableSchema, ForeignServer.ForeignKey foreignKey) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ALTER TABLE ").append(this.quote);
        if (!this.tableOwner.isEmpty()) {
            stringBuilder.append(this.tableOwner).append(this.quote).append(".").append(this.quote);
        } else {
            stringBuilder.append(tableSchema.TableOwner).append(this.quote).append(".").append(this.quote);
        }
        stringBuilder.append(this.convertCase(foreignKey.Table)).append(this.quote);
        stringBuilder.append(" ADD");
        if (!foreignKey.ForeignConstraintName.isEmpty()) {
            stringBuilder.append(" CONSTRAINT ").append(this.quote).append(this.convertCase(foreignKey.ForeignConstraintName)).append(this.quote);
        }
        stringBuilder.append(" FOREIGN KEY (");
        for (n = 0; n < foreignKey.Columns.size(); ++n) {
            stringBuilder.append(this.quote).append(this.convertCase(foreignKey.Columns.get(n))).append(this.quote);
            if (n >= foreignKey.Columns.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(" ) ");
        stringBuilder.append(" REFERENCES ");
        if (!foreignKey.RefTable.isEmpty()) {
            if (!this.tableOwner.isEmpty()) {
                stringBuilder.append(this.quote).append(this.tableOwner).append(this.quote).append(".");
            } else {
                stringBuilder.append(this.quote).append(tableSchema.TableOwner).append(this.quote).append(".");
            }
            stringBuilder.append(this.quote).append(this.convertCase(foreignKey.RefTable)).append(this.quote).append(" ");
        }
        if (foreignKey.RefColumns.size() > 0) {
            stringBuilder.append(" (");
            for (n = 0; n < foreignKey.RefColumns.size(); ++n) {
                stringBuilder.append(this.quote).append(this.convertCase(foreignKey.RefColumns.get(n))).append(this.quote);
                if (n >= foreignKey.RefColumns.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(" ) ");
        }
        return stringBuilder.toString();
    }

    private String buildCreateCheckStatement(ForeignServer.TableSchema tableSchema, ForeignServer.CheckConstraint checkConstraint) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ALTER TABLE ").append(this.quote);
        if (!this.tableOwner.isEmpty()) {
            stringBuilder.append(this.tableOwner).append(this.quote).append(".").append(this.quote);
        } else {
            stringBuilder.append(tableSchema.TableOwner).append(this.quote).append(".").append(this.quote);
        }
        stringBuilder.append(this.convertCase(this.convertCase(tableSchema.TableName))).append(this.quote);
        stringBuilder.append(" ADD");
        if (!checkConstraint.ConstraintName.isEmpty()) {
            stringBuilder.append(" CONSTRAINT ").append(this.quote).append(this.convertCase(checkConstraint.ConstraintName)).append(this.quote);
        }
        stringBuilder.append(" CHECK (");
        stringBuilder.append(this.convertCase(checkConstraint.CheckClause));
        stringBuilder.append(" )");
        return stringBuilder.toString();
    }

    private String buildColumnStatement(ForeignServer.ColumnSchema columnSchema) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.quote).append(this.convertCase(columnSchema.ColumnName)).append(this.quote).append(" ");
        stringBuilder.append(columnSchema.ColumnType);
        if (columnSchema.ColumnType.equals("TINYINT") || columnSchema.ColumnType.equals("SMALLINT") || columnSchema.ColumnType.equals("INTEGER") || columnSchema.ColumnType.equals("BIGINT")) {
            if (columnSchema.IsIdentity) {
                stringBuilder.append(" IDENTITY ");
            }
        } else if (columnSchema.ColumnType.equals("NUMERIC") || columnSchema.ColumnType.equals("NUMBER") || columnSchema.ColumnType.equals("DECIMAL")) {
            if (columnSchema.Precision > 0) {
                stringBuilder.append("(").append(columnSchema.Precision).append(",").append(columnSchema.Scale).append(")");
            }
        } else if (columnSchema.ColumnType.equals("MONEY") || columnSchema.ColumnType.equals("FLOAT")) {
            if (columnSchema.Precision > 0) {
                stringBuilder.append("(").append(columnSchema.Precision).append(")");
            }
        } else if ((columnSchema.ColumnType.equals("CHAR") || columnSchema.ColumnType.equals("CHARACTER") || columnSchema.ColumnType.equals("NCHAR") || columnSchema.ColumnType.equals("VARCHAR") || columnSchema.ColumnType.equals("NVARCHAR") || columnSchema.ColumnType.equals("BINARY") || columnSchema.ColumnType.equals("VARBINARY")) && columnSchema.Length > 0) {
            stringBuilder.append("(").append(columnSchema.Length).append(")");
        }
        if (columnSchema.IsNullable) {
            stringBuilder.append(" NULL");
        } else {
            stringBuilder.append(" NOT NULL");
        }
        if (!(columnSchema.DefaultValue == null || columnSchema.DefaultValue.isEmpty() || columnSchema.ColumnType.equals("LVARCHAR") || columnSchema.ColumnType.equals("LVARBINARY"))) {
            if (columnSchema.DefaultValue.startsWith("0000")) {
                if (columnSchema.ColumnType.equals("TIMESTAMP")) {
                    columnSchema.DefaultValue = "1900-01-01";
                } else if (columnSchema.ColumnType.equals("DATE")) {
                    columnSchema.DefaultValue = "1700-03-01";
                }
            }
            if (columnSchema.DefaultValue.equals("USER") || columnSchema.DefaultValue.toUpperCase().equals("NULL") || columnSchema.DefaultValue.equals("UID") || columnSchema.DefaultValue.equals("SYSDATE") || columnSchema.DefaultValue.equals("SYSTIME") || columnSchema.DefaultValue.equals("SYSTIMESTAMP")) {
                stringBuilder.append(" DEFAULT ").append(columnSchema.DefaultValue).append(" ");
            } else {
                stringBuilder.append(" DEFAULT '").append(columnSchema.DefaultValue).append("'");
            }
        }
        return stringBuilder.toString();
    }

    public String buildInsertText(ForeignServer.TableSchema tableSchema) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO ").append(this.quote);
        if (this.tableOwner.length() > 0) {
            stringBuilder.append(this.tableOwner).append(this.quote).append(".").append(this.quote);
        } else {
            stringBuilder.append(tableSchema.TableOwner).append(this.quote).append(".").append(this.quote);
        }
        stringBuilder.append(this.convertCase(tableSchema.TableName)).append(this.quote).append(" ");
        stringBuilder.append(" VALUES (");
        return stringBuilder.toString();
    }

    public PreparedStatement buildInsertCommand(ForeignServer.TableSchema tableSchema) {
        PreparedStatement preparedStatement = null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO ").append(this.quote);
        if (this.tableOwner.length() > 0) {
            stringBuilder.append(this.tableOwner).append(this.quote).append(".").append(this.quote);
        } else {
            stringBuilder.append(tableSchema.TableOwner).append(this.quote).append(".").append(this.quote);
        }
        stringBuilder.append(this.convertCase(tableSchema.TableName)).append(this.quote).append(" ");
        stringBuilder.append(" VALUES (");
        for (int i = 0; i < tableSchema.Columns.size(); ++i) {
            if (tableSchema.Columns.get((int)i).IsIdentity) continue;
            stringBuilder.append("?");
            if (i >= tableSchema.Columns.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        try {
            preparedStatement = this.conn.prepareStatement(stringBuilder.toString());
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "buildInsertCommand");
        }
        return preparedStatement;
    }

    private String buildCreateViewStatement(ForeignServer.ViewSchema viewSchema) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE VIEW ").append(this.quote);
        if (!this.tableOwner.isEmpty()) {
            stringBuilder.append(this.tableOwner).append(this.quote).append(".").append(this.quote);
        } else {
            stringBuilder.append(viewSchema.ViewOwner).append(this.quote).append(".").append(this.quote);
        }
        stringBuilder.append(this.convertCase(viewSchema.ViewName)).append(this.quote);
        stringBuilder.append(" AS ( ");
        String string = this.parseViewText(viewSchema.ViewDefinition);
        stringBuilder.append(string);
        stringBuilder.append(" )");
        if (viewSchema.WithCheck) {
            stringBuilder.append(" WITH CHECK OPTION");
        }
        return stringBuilder.toString();
    }

    private String buildCreateSynonymStatement(ForeignServer.SynonymSchema synonymSchema) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE ");
        if (synonymSchema.Public) {
            stringBuilder.append("PUBLIC ");
        }
        stringBuilder.append("SYNONYM ").append(this.quote);
        if (!this.tableOwner.isEmpty()) {
            stringBuilder.append(this.tableOwner).append(this.quote).append(".").append(this.quote);
        } else {
            stringBuilder.append(synonymSchema.SynonymOwner).append(this.quote).append(".").append(this.quote);
        }
        stringBuilder.append(this.convertCase(synonymSchema.SynonymName)).append(this.quote);
        stringBuilder.append(" FOR ");
        stringBuilder.append(this.quote).append(this.convertCase(synonymSchema.ReferredObject)).append(this.quote);
        return stringBuilder.toString();
    }

    private String parseViewText(String string) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = this.tokenize(string.trim());
        for (String string2 : arrayList) {
            if (string2.isEmpty()) continue;
            if (string2.equals("\"")) {
                bl = !bl;
                stringBuilder.append("\"");
                continue;
            }
            if (bl) {
                stringBuilder.append(string2);
                continue;
            }
            if (string2.equals("'")) {
                bl2 = !bl2;
                stringBuilder.append("'");
                continue;
            }
            if (bl2) {
                stringBuilder.append(string2);
                continue;
            }
            if (string2.equals("\r") || string2.equals("\n")) {
                if (string2.endsWith(" ")) continue;
                stringBuilder.append(" ");
                continue;
            }
            String string3 = string2.toUpperCase();
            boolean bl3 = false;
            for (String string4 : this.RESERVER_WORDS) {
                if (!string4.equals(string3)) continue;
                stringBuilder.append(string3).append(" ");
                bl3 = true;
                break;
            }
            if (bl3) continue;
            if (string2.length() > 1) {
                try {
                    Double.parseDouble(string2);
                    stringBuilder.append(this.convertCase(string2));
                }
                catch (Exception exception) {
                    stringBuilder.append("\"").append(this.convertCase(string2)).append("\"");
                }
                continue;
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private ArrayList<String> tokenize(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "()[] `<>\"'+-/^*.,=\r\n\t", true);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    private String convertCase(String string) {
        if (this.convertToLower) {
            return string.toLowerCase();
        }
        return string;
    }

    private boolean showException(SQLException sQLException) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        int n = JOptionPane.showConfirmDialog(jFrame, "Error : " + sQLException.getErrorCode() + "\n\nDescription : " + sQLException.getMessage() + "\n\nDo you want to proceed ?", "c-treeACE Warning", 0, 0);
        return n == 0;
    }
}

