/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import FairCom.Helper.Classes.CtreeServer;
import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.TREE_OBJECT;
import ctreeaceexplorer.sql.ForeignServer;
import ctreeaceexplorer.sql.OracleServer;
import ctreeaceexplorer.sql.SqlConnection;
import java.awt.Toolkit;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class CtreeACESourceServer
implements ForeignServer {
    private SqlConnection conn;
    private boolean cancelled;

    @Override
    public boolean connect(String string, String string2, Boolean bl) {
        if (this.conn == null || !this.conn.isConnected()) {
            CtreeServer ctreeServer = new CtreeServer(string, 6597, string2, "ADMIN", "ADMIN");
            this.conn = new SqlConnection(ctreeServer, true, true);
        }
        return this.conn.isConnected();
    }

    @Override
    public void disconnect() {
        this.conn.disconnect();
    }

    @Override
    public String getServerId() {
        return this.conn.getServerId();
    }

    @Override
    public boolean changeDb(String string) {
        return this.conn.changeDb(string);
    }

    @Override
    public ArrayList<String> readObjects(TREE_OBJECT tREE_OBJECT) {
        return this.conn.readObjects(tREE_OBJECT);
    }

    @Override
    public ForeignServer.TableSchema createTableSchema(String string, boolean bl) {
        ForeignServer.TableSchema tableSchema = new ForeignServer.TableSchema();
        String[] stringArray = Pattern.compile("\\[|\\]|\\.").split(string, 0);
        ArrayList<String> arrayList = this.removeEmptyStrings(stringArray);
        if (arrayList.size() == 2) {
            tableSchema.TableOwner = arrayList.get(0);
            tableSchema.TableName = arrayList.get(1);
            tableSchema.IsValid = true;
            tableSchema.Columns = new ArrayList();
            String string2 = "";
            string2 = this.conn.isIdentitySupported() ? "SELECT col,dflt_value,nullflag,coltype,width, scale, colid, seed, incr FROM admin.syscolumns cols LEFT JOIN admin.sysidentity ids on cols.owner = ids.owner and cols.tbl = ids.tbl and cols.id = ids.colid WHERE cols.owner ='" + tableSchema.TableOwner + "' AND cols.tbl = '" + tableSchema.TableName + "' ORDER BY id" : "SELECT col,dflt_value,nullflag,coltype,width, scale FROM admin.syscolumns WHERE owner ='" + tableSchema.TableOwner + "' AND tbl = '" + tableSchema.TableName + "' ORDER BY id";
            Globals.appFrame.objNameLabel.setText("Creating Schema for Table " + string);
            ResultSet resultSet = this.conn.execRsQuery(string2);
            try {
                String string3;
                Object object;
                Object object2;
                Object object3;
                while (resultSet.next()) {
                    object3 = new ForeignServer.ColumnSchema();
                    ((ForeignServer.ColumnSchema)object3).ColumnName = resultSet.getString("col");
                    object2 = resultSet.getString("dflt_value");
                    ((ForeignServer.ColumnSchema)object3).DefaultValue = this.fixDefaultValueString((String)object2);
                    ((ForeignServer.ColumnSchema)object3).IsNullable = resultSet.getString("nullflag").equals("Y");
                    object = resultSet.getString("coltype");
                    try {
                        this.validateDataType((String)object);
                    }
                    catch (Exception exception) {
                        Globals.showException(exception, "createTableSchema");
                        return tableSchema;
                    }
                    ((ForeignServer.ColumnSchema)object3).Precision = ((ForeignServer.ColumnSchema)object3).Length = resultSet.getInt("width");
                    ((ForeignServer.ColumnSchema)object3).Scale = resultSet.getInt("scale");
                    if (this.conn.isIdentitySupported()) {
                        string3 = resultSet.getString("colid");
                        if (string3 != null) {
                            ((ForeignServer.ColumnSchema)object3).IsIdentity = true;
                            ((ForeignServer.ColumnSchema)object3).IsNullable = true;
                        }
                        ((ForeignServer.ColumnSchema)object3).IdentitySeed = resultSet.getInt("seed");
                        ((ForeignServer.ColumnSchema)object3).IdentityIncrement = resultSet.getInt("incr");
                    }
                    ((ForeignServer.ColumnSchema)object3).ColumnType = ((String)object).equals("nchar") ? (bl ? "NCHAR" : "CHAR") : (((String)object).equals("nvarchar") ? (bl ? "NVARCHAR" : "VARCHAR") : (((String)object).equals("int") ? "INTEGER" : (((String)object).equals("double") ? "DOUBLE PRECISION" : ((String)object).toUpperCase())));
                    tableSchema.Columns.add((ForeignServer.ColumnSchema)object3);
                }
                resultSet.close();
                string2 = "select b.colname, a.cnstrname from admin.sys_tbl_constrs a join admin.sys_keycol_usage b on a.cnstrname = b.cnstrname and a.owner = b.owner and a.tblname = b.tblname where a.cnstrtype = 'P' and a.owner = '" + tableSchema.TableOwner + "' and a.tblname = '" + tableSchema.TableName + "'";
                tableSchema.PrimaryKey = new ArrayList();
                resultSet = this.conn.execRsQuery(string2);
                while (resultSet.next()) {
                    object3 = resultSet.getString("colname");
                    object2 = resultSet.getString("cnstrname");
                    tableSchema.PrimaryKey.add((String)object3);
                    if (!((String)object2).startsWith("sys_constraint")) {
                        tableSchema.PrimaryKeyConstraintName = object2;
                        continue;
                    }
                    tableSchema.PrimaryKeyConstraintName = "";
                }
                resultSet.close();
                string2 = "select b.colname, a.cnstrname from admin.sys_tbl_constrs a join admin.sys_keycol_usage b on a.cnstrname = b.cnstrname \tand a.owner = b.owner and a.tblname = b.tblname \twhere a.cnstrtype = 'U' and a.owner = '" + tableSchema.TableOwner + "' and a.tblname = '" + tableSchema.TableName + "'";
                tableSchema.UniqueKeys = new ArrayList();
                resultSet = this.conn.execRsQuery(string2);
                object3 = null;
                while (resultSet.next()) {
                    object2 = resultSet.getString("cnstrname");
                    if (object3 == null || !((ForeignServer.UniqueConstraint)object3).UniqueConstraintName.equals(object2)) {
                        object3 = new ForeignServer.UniqueConstraint();
                        ((ForeignServer.UniqueConstraint)object3).UniqueConstraintColumns = new ArrayList();
                        tableSchema.UniqueKeys.add((ForeignServer.UniqueConstraint)object3);
                        ((ForeignServer.UniqueConstraint)object3).UniqueConstraintName = !((String)object2).startsWith("sys_constraint") ? object2 : "";
                    }
                    object = resultSet.getString("colname");
                    ((ForeignServer.UniqueConstraint)object3).UniqueConstraintColumns.add((String)object);
                }
                resultSet.close();
                string2 = "select distinct tbcn.cnstrname, ku.tblname, ku.colname, ku.colposition, ku2.tblname as reftblname, ku2.colname as refcolname\tfrom admin.sys_tbl_constrs tbcn join admin.sys_keycol_usage ku on tbcn.cnstrname = ku.cnstrname\tand tbcn.owner = ku.owner and tbcn.tblname = ku.tblname\tjoin admin.sys_ref_constrs refc\ton tbcn.cnstrname = refc.cnstrname and tbcn.owner = refc.owner and tbcn.tblname = refc.tblname\tjoin admin.sys_keycol_usage ku2 on ku2.cnstrname = refc.refcnstrname and ku2.tblname = refc.reftblname and ku2.colposition = ku.colposition\twhere tbcn.cnstrtype = 'F' and \ttbcn.owner = '" + tableSchema.TableOwner + "' and tbcn.tblname = '" + tableSchema.TableName + "' " + "order by tbcn.cnstrname, ku.colposition";
                object2 = null;
                resultSet = this.conn.execRsQuery(string2);
                tableSchema.ForeignKeys = new ArrayList();
                while (resultSet.next()) {
                    object = resultSet.getString("cnstrname");
                    if (object2 == null || !((ForeignServer.ForeignKey)object2).ForeignConstraintName.equals(object)) {
                        object2 = new ForeignServer.ForeignKey();
                        ((ForeignServer.ForeignKey)object2).Columns = new ArrayList();
                        ((ForeignServer.ForeignKey)object2).RefColumns = new ArrayList();
                        tableSchema.ForeignKeys.add((ForeignServer.ForeignKey)object2);
                        ((ForeignServer.ForeignKey)object2).ForeignConstraintName = !((String)object).startsWith("sys_constraint") ? object : "";
                    }
                    string3 = resultSet.getString("refcolname");
                    ((ForeignServer.ForeignKey)object2).RefColumns.add(string3);
                    string3 = resultSet.getString("colname");
                    ((ForeignServer.ForeignKey)object2).Columns.add(string3);
                    ((ForeignServer.ForeignKey)object2).RefTable = string3 = resultSet.getString("reftblname");
                    ((ForeignServer.ForeignKey)object2).Table = string3 = resultSet.getString("tblname");
                }
                resultSet.close();
                string2 = "select tblc.cnstrname, chkc.chkclause, chku.colname from admin.sys_tbl_constrs tblc \tjoin admin.sys_chk_constrs chkc\ton chkc.cnstrname = tblc.cnstrname  join admin.sys_chkcol_usage chku on chku.cnstrname = tblc.cnstrname\twhere tblc.owner = '" + tableSchema.TableOwner + "' and tblc.tblname = '" + tableSchema.TableName + "' and cnstrtype = 'C'";
                resultSet = this.conn.execRsQuery(string2);
                tableSchema.CheckConstraints = new ArrayList();
                while (resultSet.next()) {
                    object = new ForeignServer.CheckConstraint();
                    string3 = resultSet.getString("cnstrname");
                    ((ForeignServer.CheckConstraint)object).ConstraintName = !string3.startsWith("sys_constraint") ? string3 : "";
                    ((ForeignServer.CheckConstraint)object).ColumnName = string3 = resultSet.getString("colname");
                    string3 = resultSet.getString("chkclause");
                    if ((string3 = string3.trim()).startsWith("(")) {
                        string3 = string3.substring(1);
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    string3 = string3.replace('[', '\"');
                    ((ForeignServer.CheckConstraint)object).CheckClause = string3 = string3.replace(']', '\"');
                    tableSchema.CheckConstraints.add((ForeignServer.CheckConstraint)object);
                }
                resultSet.close();
                string2 = "select idx.idxseq, idx.idxowner, idx.idxname, idx.colname,\tidx.idxtype, idx.idxorder\tfrom admin.sysindexes idx where idx.tblowner = '" + tableSchema.TableOwner + "' and idx.tbl = '" + tableSchema.TableName + "' " + "and idx.idxname " + "not in ( select systb.idxname from admin.sys_tbl_constrs systb where systb.idxname = idx.idxname ) " + "order by idx.idxname, idx.idxseq";
                object = null;
                tableSchema.Indexes = new ArrayList();
                resultSet = this.conn.execRsQuery(string2);
                while (resultSet.next()) {
                    string3 = resultSet.getString("idxname");
                    String string4 = resultSet.getString("idxowner");
                    String string5 = resultSet.getString("idxtype");
                    String string6 = resultSet.getString("idxorder");
                    if (object == null || !((ForeignServer.IndexSchema)object).IndexName.equals(string3)) {
                        object = new ForeignServer.IndexSchema();
                        ((ForeignServer.IndexSchema)object).IndexName = string3;
                        ((ForeignServer.IndexSchema)object).IndexOwner = string4;
                        ((ForeignServer.IndexSchema)object).Columns = new ArrayList();
                        tableSchema.Indexes.add((ForeignServer.IndexSchema)object);
                    }
                    if (string5.equals("U")) {
                        ((ForeignServer.IndexSchema)object).IsUnique = true;
                    }
                    String string7 = resultSet.getString("colname");
                    ForeignServer.IndexColumn indexColumn = new ForeignServer.IndexColumn();
                    indexColumn.ColumnName = string7;
                    if (string6.equals("A")) {
                        indexColumn.IsAscending = true;
                    }
                    ((ForeignServer.IndexSchema)object).Columns.add(indexColumn);
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(CtreeACESourceServer.class.getName()).log(Level.SEVERE, null, sQLException);
            }
        }
        return tableSchema;
    }

    @Override
    public ForeignServer.ViewSchema createViewSchema(String string) {
        ForeignServer.ViewSchema viewSchema = new ForeignServer.ViewSchema();
        String[] stringArray = Pattern.compile("\\[|\\]|\\.").split(string, 0);
        ArrayList<String> arrayList = this.removeEmptyStrings(stringArray);
        if (arrayList.size() == 2) {
            viewSchema.ViewOwner = arrayList.get(0);
            viewSchema.ViewName = arrayList.get(1);
            String string2 = "select viewtext, tbltype from admin.sysviews a join admin.systables b on a.viewname = b.tbl and a.owner = b.owner where a.owner = '" + viewSchema.ViewOwner + "' and a.viewname = '" + viewSchema.ViewName + "'";
            viewSchema.ViewColumns = new ArrayList();
            Globals.appFrame.objNameLabel.setText("Creating Schema for View " + string);
            ResultSet resultSet = this.conn.execRsQuery(string2);
            try {
                while (resultSet.next()) {
                    String string3 = resultSet.getString("viewtext");
                    if ((string3 = string3.trim()).startsWith("(")) {
                        string3 = string3.substring(1);
                    }
                    if (string3.endsWith(")")) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    viewSchema.ViewDefinition = string3;
                    string3 = resultSet.getString("tbltype");
                    if (string3.equals("C")) {
                        viewSchema.WithCheck = true;
                    }
                    viewSchema.IsUpdatable = false;
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(CtreeACESourceServer.class.getName()).log(Level.SEVERE, null, sQLException);
            }
        }
        return viewSchema;
    }

    @Override
    public ForeignServer.SynonymSchema createSynonymSchema(String string) {
        ForeignServer.SynonymSchema synonymSchema = new ForeignServer.SynonymSchema();
        String[] stringArray = Pattern.compile("\\[|\\]|\\.").split(string, 0);
        ArrayList<String> arrayList = this.removeEmptyStrings(stringArray);
        if (arrayList.size() == 2) {
            synonymSchema.SynonymOwner = arrayList.get(0);
            synonymSchema.SynonymName = arrayList.get(1);
            String string2 = "select sname, stbl, ispublic FROM admin.syssynonyms where sowner = '" + synonymSchema.SynonymOwner + "'  and sname = '" + synonymSchema.SynonymName + "'  ";
            Globals.appFrame.objNameLabel.setText("Creating Schema for Synonym " + string);
            ResultSet resultSet = this.conn.execRsQuery(string2);
            try {
                while (resultSet.next()) {
                    String string3;
                    synonymSchema.SynonymName = string3 = resultSet.getString("sname");
                    synonymSchema.ReferredObject = string3 = resultSet.getString("stbl");
                    int n = resultSet.getInt("ispublic");
                    if (n != 1) continue;
                    synonymSchema.Public = true;
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(CtreeACESourceServer.class.getName()).log(Level.SEVERE, null, sQLException);
            }
        }
        return synonymSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean copyRows(String string, ForeignServer.TableSchema tableSchema, boolean bl, BufferedWriter bufferedWriter) {
        int n;
        boolean bl2;
        block21: {
            bl2 = true;
            n = 0;
            int n3 = 0;
            String string2 = "select count(*) from \"" + tableSchema.TableOwner + "\".\"" + tableSchema.TableName + "\"";
            ResultSet resultSet = null;
            StringBuilder stringBuilder = null;
            try {
                resultSet = this.conn.executeQuery(string2);
                resultSet.next();
                n = resultSet.getInt(1) + 1;
                n3 = n / 100 + 1;
                Globals.appFrame.importProgressBar.setMaximum(n);
                Globals.appFrame.importProgressBar.setValue(0);
            }
            catch (SQLException sQLException) {
                boolean n2 = this.showException(sQLException, "Source");
                if (!n2) {
                    boolean bl3 = bl2;
                    return bl3;
                }
            }
            finally {
                this.conn.closeResultSet(resultSet);
            }
            String string3 = this.buildServerTableQuery(tableSchema);
            try {
                resultSet = this.conn.executeQuery(string3);
                boolean sQLException = false;
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                while (resultSet.next()) {
                    void var12_15;
                    stringBuilder = new StringBuilder(string);
                    if (this.cancelled) {
                        resultSet.close();
                        return bl2;
                    }
                    try {
                        for (int iOException = 1; iOException <= n2; ++iOException) {
                            if (iOException > 1) {
                                stringBuilder.append(",");
                            }
                            int n4 = resultSetMetaData.getColumnType(iOException);
                            String string4 = null;
                            if (n4 != 2004 && n4 != -4 && (string4 = resultSet.getString(iOException)) != null) {
                                string4 = string4.replace("'", "''");
                                string4 = "'" + string4 + "'";
                            }
                            if (resultSet.wasNull()) {
                                stringBuilder.append("NULL");
                                continue;
                            }
                            stringBuilder.append(string4);
                        }
                    }
                    catch (SQLException sQLException2) {
                        try {
                            bufferedWriter.write(sQLException2.getMessage());
                            bufferedWriter.newLine();
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(OracleServer.class.getName()).log(Level.SEVERE, null, iOException);
                        }
                    }
                    try {
                        stringBuilder.append(")");
                        bufferedWriter.write(stringBuilder.toString());
                        bufferedWriter.write(";");
                        bufferedWriter.newLine();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(OracleServer.class.getName()).log(Level.SEVERE, null, iOException);
                    }
                    if (++var12_15 % n3 != false) continue;
                    Globals.appFrame.importProgressBar.setValue((int)var12_15);
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                if (this.showException(sQLException, "Source")) break block21;
                bl2 = false;
            }
        }
        Globals.appFrame.importProgressBar.setValue(n);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyRows(PreparedStatement preparedStatement, ForeignServer.TableSchema tableSchema, boolean bl, StringBuilder stringBuilder) {
        int n;
        boolean bl2;
        block15: {
            bl2 = true;
            n = 0;
            int n2 = 0;
            String string = "select count(*) from \"" + tableSchema.TableOwner + "\".\"" + tableSchema.TableName + "\"";
            ResultSet resultSet = null;
            try {
                resultSet = this.conn.executeQuery(string);
                resultSet.next();
                n = resultSet.getInt(1) + 1;
                n2 = n / 100 + 1;
                Globals.appFrame.importProgressBar.setMaximum(n);
                Globals.appFrame.importProgressBar.setValue(0);
            }
            catch (SQLException sQLException) {
                boolean bl3 = this.showException(sQLException, "Source");
                if (!bl3) {
                    boolean bl4 = bl2;
                    return bl4;
                }
            }
            finally {
                this.conn.closeResultSet(resultSet);
            }
            String string2 = this.buildServerTableQuery(tableSchema);
            try {
                ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
                resultSet = this.conn.executeQuery(string2);
                int n3 = 0;
                while (resultSet.next()) {
                    if (this.cancelled) {
                        resultSet.close();
                        return bl2;
                    }
                    try {
                        int n4 = parameterMetaData.getParameterCount();
                        for (int i = 1; i <= n4; ++i) {
                            Object object = resultSet.getObject(i);
                            if (object != null) {
                                preparedStatement.setObject(i, object);
                                continue;
                            }
                            preparedStatement.setNull(i, parameterMetaData.getParameterType(i));
                        }
                        preparedStatement.execute();
                    }
                    catch (SQLException sQLException) {
                        stringBuilder.append("Insertion of Row # ").append(n3 + 1).append(" in Table \"").append(tableSchema.TableName).append("\" returned the following error : ").append(sQLException.getErrorCode()).append(" = ").append(sQLException.getMessage()).append("\n");
                    }
                    if (++n3 % n2 != 0) continue;
                    Globals.appFrame.importProgressBar.setValue(n3);
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                if (this.showException(sQLException, "Source")) break block15;
                bl2 = false;
            }
        }
        Globals.appFrame.importProgressBar.setValue(n);
        return bl2;
    }

    private String buildServerTableQuery(ForeignServer.TableSchema tableSchema) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        for (int i = 0; i < tableSchema.Columns.size(); ++i) {
            if (tableSchema.Columns.get((int)i).IsIdentity) continue;
            stringBuilder.append("\"").append(tableSchema.Columns.get((int)i).ColumnName).append("\"");
            if (i >= tableSchema.Columns.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(" FROM \"").append(tableSchema.TableOwner).append("\".\"").append(tableSchema.TableName).append("\"");
        return stringBuilder.toString();
    }

    private void validateDataType(String string) throws Exception {
        if (string.equals("int") || string.equals("integer") || string.equals("smallint") || string.equals("bit") || string.equals("float") || string.equals("double") || string.equals("real") || string.equals("nvarchar") || string.equals("nchar") || string.equals("varchar") || string.equals("lvarchar") || string.equals("clob") || string.equals("blob") || string.equals("varbinary") || string.equals("image") || string.equals("text") || string.equals("ntext") || string.equals("bigint") || string.equals("char") || string.equals("character") || string.equals("numeric") || string.equals("binary") || string.equals("date") || string.equals("time") || string.equals("timestamp") || string.equals("money") || string.equals("tinyint") || string.equals("varbinary") || string.equals("lvarbinary") || string.equals("decimal") || string.equals("datetime")) {
            return;
        }
        throw new Exception("Validation failed for data type [" + string + "]");
    }

    private String fixDefaultValueString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '\"' && n == -1) {
                n = i;
            }
            if (string2.charAt(i) != '\"' || n == -1 || i <= n2) continue;
            n2 = i;
        }
        if (n != -1 && n2 > n) {
            String string3 = string2.substring(n + 1, n2);
            return string3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '(' || string2.charAt(i) == ')') continue;
            stringBuilder.append(string2.charAt(i));
        }
        return stringBuilder.toString();
    }

    private ArrayList<String> removeEmptyStrings(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (string.isEmpty()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public ForeignServer.SynonymSchema createSynonymSchema(Connection connection, String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ArrayList<String> readServerTables(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "select owner, tbl from admin.systables where tbltype = 'T' order by owner,tbl";
        ResultSet resultSet = this.conn.execRsQuery(string2);
        try {
            while (resultSet.next()) {
                arrayList.add("[" + resultSet.getString(1) + "].[" + resultSet.getString(2) + "]");
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(CtreeACESourceServer.class.getName()).log(Level.SEVERE, null, sQLException);
        }
        this.conn.closeResultSet(resultSet);
        return arrayList;
    }

    @Override
    public ArrayList<String> readServerViews(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "select owner, tbl from admin.systables where tbltype in ('C','V') order by owner,tbl";
        ResultSet resultSet = this.conn.execRsQuery(string2);
        try {
            while (resultSet.next()) {
                arrayList.add("[" + resultSet.getString(1) + "].[" + resultSet.getString(2) + "]");
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(CtreeACESourceServer.class.getName()).log(Level.SEVERE, null, sQLException);
        }
        this.conn.closeResultSet(resultSet);
        return arrayList;
    }

    @Override
    public ArrayList<String> readServerSynonyms(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "select sowner,sname from admin.syssynonyms order by sowner,sname";
        ResultSet resultSet = this.conn.execRsQuery(string2);
        try {
            while (resultSet.next()) {
                arrayList.add("[" + resultSet.getString(1) + "].[" + resultSet.getString(2) + "]");
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(CtreeACESourceServer.class.getName()).log(Level.SEVERE, null, sQLException);
        }
        this.conn.closeResultSet(resultSet);
        return arrayList;
    }

    @Override
    public void stopConversion(boolean bl) {
        this.cancelled = bl;
    }

    private boolean showException(SQLException sQLException, String string) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        int n = JOptionPane.showConfirmDialog(jFrame, string + " Server Error : " + sQLException.getErrorCode() + "\n\nDescription : " + sQLException.getMessage() + "\n\nDo you want to proceed ?", string + " Server Error", 0, 0);
        return n == 0;
    }

    @Override
    public boolean isConnected() {
        return this.conn.isConnected();
    }

    @Override
    public String getCurrentDb() {
        return this.conn.getDatabaseName();
    }
}

