/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import FairCom.Helper.Classes.FcBaseTableModel;
import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.MyTreeNode;
import ctreeaceexplorer.RebuildDialog;
import ctreeaceexplorer.TREE_OBJECT;
import ctreeaceexplorer.sql.DataWriter;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.TreeNode;
import org.xml.sax.SAXException;

public class DumpRows
extends JDialog {
    TREE_OBJECT objectType;
    String objectName;
    String objectOwner;
    FcBaseTableModel model;
    MODE mode = MODE.TABLE;
    FORMAT format = FORMAT.CSV;
    static String fileName;
    static String directoryName;
    ArrayList<String> objects = new ArrayList();
    JFrame mainFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
    Writer writer = null;
    boolean multi = false;
    MyTreeNode currentNode = null;
    private String sqlStatement;
    private JCheckBox appendCB;
    private JButton browseBTN;
    private JButton cancelButton;
    private JCheckBox colHeadersCB;
    private JTextField fieldsQuoteTB;
    private JTextField fieldsSeparatorTB;
    private JLabel fileLabel;
    private JTextField fileNameTB;
    private JComboBox formatCB;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel objectLabel;
    private JLabel objectTypeLabel;
    private JButton okButton;
    private JCheckBox oneFileCB;
    private JCheckBox quoteNumerics;
    private JCheckBox useObjectNameCB;

    public DumpRows(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    public void showDialog(FcBaseTableModel fcBaseTableModel, String string, String string2) {
        this.sqlStatement = string2;
        this.oneFileCB.setEnabled(false);
        this.appendCB.setEnabled(true);
        this.objectTypeLabel.setText("");
        this.objectLabel.setText("");
        this.objectType = TREE_OBJECT.TABLE;
        this.objectName = "Record Grid";
        this.mode = MODE.RECORDGRID;
        this.fileNameTB.setText(fileName);
        this.setTitle("Dump Rows from Grid");
        this.model = fcBaseTableModel;
        if (string != null) {
            this.objectName = string;
            this.objectOwner = Globals.currentSqlConnection.getSelectedUser();
        } else {
            this.mode = MODE.STATEMENTGRID;
        }
        this.getRootPane().setDefaultButton(this.okButton);
        this.setVisible(true);
    }

    public void showDialog(TREE_OBJECT tREE_OBJECT, String string, MyTreeNode myTreeNode) {
        this.oneFileCB.setEnabled(false);
        this.appendCB.setEnabled(false);
        this.objectTypeLabel.setText("");
        this.objectLabel.setText("");
        this.objectType = tREE_OBJECT;
        this.currentNode = myTreeNode;
        if (string.equals("_$Checked")) {
            this.multi = true;
        } else {
            this.objectName = string;
        }
        this.mode = MODE.TABLE;
        this.fileNameTB.setText(fileName);
        this.objectOwner = Globals.currentSqlConnection.getSelectedUser();
        this.setTitle("Dump Rows from Grid");
        if (tREE_OBJECT == TREE_OBJECT.TABLE || tREE_OBJECT == TREE_OBJECT.TABLE_RTG || tREE_OBJECT == TREE_OBJECT.TABLE_LINKED) {
            this.setTitle("Dump Rows from Table : " + this.objectOwner + "." + this.objectName);
        } else if (this.objectType == TREE_OBJECT.TABLES) {
            this.oneFileCB.setEnabled(true);
            this.appendCB.setEnabled(true);
            if (this.multi) {
                this.setTitle("Dump Rows from selected \"" + this.objectOwner + "\" tables");
            } else {
                this.setTitle("Dump Rows from all \"" + this.objectOwner + "\" tables");
            }
        }
        this.getRootPane().setDefaultButton(this.okButton);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel1 = new JLabel();
        this.formatCB = new JComboBox();
        this.colHeadersCB = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.oneFileCB = new JCheckBox();
        this.useObjectNameCB = new JCheckBox();
        this.appendCB = new JCheckBox();
        this.fileLabel = new JLabel();
        this.fileNameTB = new JTextField();
        this.browseBTN = new JButton();
        this.jLabel3 = new JLabel();
        this.objectTypeLabel = new JLabel();
        this.objectLabel = new JLabel();
        this.quoteNumerics = new JCheckBox();
        this.fieldsQuoteTB = new JTextField();
        this.jLabel2 = new JLabel();
        this.fieldsSeparatorTB = new JTextField();
        this.jLabel4 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel1.setName("jPanel1");
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DumpRows.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton.setMnemonic('E');
        this.cancelButton.setText("Exit");
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DumpRows.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(81, 81, 81).addComponent(this.okButton, -2, 75, -2).addGap(51, 51, 51).addComponent(this.cancelButton, -2, 76, -2).addContainerGap(79, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        this.jLabel1.setText("Output Format :");
        this.jLabel1.setName("jLabel1");
        this.formatCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Comma Separated Value (CSV)", "eXtensible Markup Language (XML)"}));
        this.formatCB.setName("formatCB");
        this.formatCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DumpRows.this.formatCBItemStateChanged(itemEvent);
            }
        });
        this.colHeadersCB.setText("Include Column's Names in Output File");
        this.colHeadersCB.setName("colHeadersCB");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Output File(s)"));
        this.jPanel2.setName("jPanel2");
        this.oneFileCB.setText("One File Per Object");
        this.oneFileCB.setName("oneFileCB");
        this.oneFileCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DumpRows.this.oneFileCBStateChanged(changeEvent);
            }
        });
        this.useObjectNameCB.setText("Use Object Name As File Name");
        this.useObjectNameCB.setName("useObjectNameCB");
        this.useObjectNameCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DumpRows.this.useObjectNameCBItemStateChanged(itemEvent);
            }
        });
        this.appendCB.setText("Append To Output Fille");
        this.appendCB.setName("appendCB");
        this.fileLabel.setText("Output File :");
        this.fileLabel.setName("fileLabel");
        this.fileNameTB.setName("fileNameTB");
        this.browseBTN.setText("...");
        this.browseBTN.setName("browseBTN");
        this.browseBTN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DumpRows.this.browseBTNActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout2.createSequentialGroup().addComponent(this.oneFileCB).addGap(18, 18, 18).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.appendCB).addComponent(this.useObjectNameCB))).addComponent(this.fileLabel).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.fileNameTB, -1, 275, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.browseBTN, -2, 25, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.oneFileCB).addComponent(this.useObjectNameCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.appendCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileNameTB, -2, -1, -2).addComponent(this.browseBTN)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel3.setText("Exporting :");
        this.jLabel3.setName("jLabel3");
        this.objectTypeLabel.setText("Object");
        this.objectTypeLabel.setName("objectTypeLabel");
        this.objectLabel.setText("ObjectName");
        this.objectLabel.setName("objectLabel");
        this.quoteNumerics.setText("Quote Numeric Fields");
        this.quoteNumerics.setName("quoteNumerics");
        this.fieldsQuoteTB.setText("\"");
        this.fieldsQuoteTB.setName("fieldsQuoteTB");
        this.jLabel2.setText("Fields Quote Char :");
        this.jLabel2.setName("jLabel2");
        this.fieldsSeparatorTB.setText(",");
        this.fieldsSeparatorTB.setName("fieldsSeparatorTB");
        this.jLabel4.setText("Fields Separator :");
        this.jLabel4.setName("jLabel4");
        GroupLayout groupLayout3 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.objectTypeLabel).addGap(18, 18, 18).addComponent(this.objectLabel).addContainerGap(172, Short.MAX_VALUE)).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addGap(19, 19, 19).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldsQuoteTB, -2, 15, -2)).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fieldsSeparatorTB, -2, 15, -2)).addComponent(this.quoteNumerics).addComponent(this.colHeadersCB).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jLabel1).addGap(32, 32, 32).addComponent(this.formatCB, -2, -1, -2))).addContainerGap(41, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.formatCB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.colHeadersCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.quoteNumerics).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.fieldsQuoteTB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.fieldsSeparatorTB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.objectTypeLabel).addComponent(this.objectLabel)).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        if (this.fileNameTB.getText().isEmpty()) {
            Globals.showMessage("Please input a filename or a directory", "Error");
            return;
        }
        this.format = this.formatCB.getSelectedItem().toString().startsWith("Comma") ? FORMAT.CSV : FORMAT.XML;
        this.setCursor(Cursor.getPredefinedCursor(3));
        Thread thread = new Thread(new RunSomeTask());
        switch (this.objectType) {
            case TABLE: {
                this.objects.clear();
                this.objects.add(this.objectName);
                thread.start();
                break;
            }
            case TABLES: {
                this.setObjectsArray();
                thread.start();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setObjectsArray() {
        this.objects.clear();
        String string = "select tbl from admin.systables where owner = '" + this.objectOwner + "' and tbltype = 'T' order by id";
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string);
        if (resultSet == null) return;
        try {
            block2: while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    return;
                }
                if (this.multi) {
                    String string2 = resultSet.getString(1);
                    if (this.currentNode.getChildCount() < 0) continue;
                    Enumeration<TreeNode> enumeration = this.currentNode.children();
                    while (true) {
                        if (!enumeration.hasMoreElements()) continue block2;
                        MyTreeNode myTreeNode = (MyTreeNode)enumeration.nextElement();
                        if (!myTreeNode.name.equals(string2) || !myTreeNode.isChecked()) continue;
                        this.objects.add(resultSet.getString(1));
                    }
                }
                this.objects.add(resultSet.getString(1));
            }
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "Dump Rows");
        }
    }

    private void dumpObjects() {
        boolean bl = true;
        Integer n = 0;
        for (String string : this.objects) {
            String string2;
            this.objectTypeLabel.setText("Table : ");
            this.objectLabel.setText(string);
            this.objectName = string;
            this.objectLabel.repaint();
            this.objectLabel.invalidate();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(RebuildDialog.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            String string3 = "";
            if (this.mode == MODE.TABLE) {
                string3 = "# Rows dumped from table \"" + this.objectOwner + "\".\"" + this.objectName + "\"";
            } else if (this.mode == MODE.STATEMENTGRID) {
                string3 = "# Rows dumped from statement grid";
            } else if (this.mode == MODE.RECORDGRID) {
                string3 = "# Rows dumped from record grid for table \"" + this.objectOwner + "\".\"" + this.objectName + "\"";
            }
            String string4 = string2 = this.fileNameTB.getText();
            if (this.useObjectNameCB.isSelected()) {
                string2 = this.format == FORMAT.CSV ? string + ".csv" : string + ".xml";
                try {
                    if (this.writer != null) {
                        this.writer.close();
                        this.writer = null;
                    }
                    this.writer = new Writer(string4 + File.separator + string2, this.format, this.appendCB.isSelected());
                }
                catch (IOException iOException) {
                    Globals.showException(iOException, "Dump Rows");
                }
            } else if (this.oneFileCB.isSelected()) {
                try {
                    int n2 = string4.indexOf(".c");
                    if (n2 > 0) {
                        string4 = string4.substring(0, n2);
                    }
                    String string5 = string4 + "_" + n.toString();
                    if (this.format == FORMAT.CSV) {
                        if (!string5.contains(".c")) {
                            string5 = string5 + ".csv";
                        }
                    } else if (!string5.contains(".x")) {
                        string5 = string5 + ".xml";
                    }
                    if (this.writer != null) {
                        this.writer.close();
                    }
                    this.writer = new Writer(string5, this.format, this.appendCB.isSelected());
                    Integer n3 = n;
                    Integer n4 = n = Integer.valueOf(n + 1);
                }
                catch (IOException iOException) {
                    Globals.showException(iOException, "Dump Rows");
                }
            } else {
                if (this.format == FORMAT.CSV) {
                    if (!string4.contains(".c")) {
                        string4 = string4 + ".csv";
                    }
                } else if (!string4.contains(".x")) {
                    string4 = string4 + ".xml";
                }
                boolean bl2 = this.appendCB.isSelected();
                if (!bl) {
                    bl2 = true;
                }
                try {
                    this.writer = new Writer(string4, this.format, bl2);
                    bl = false;
                }
                catch (IOException iOException) {
                    Globals.showException(iOException, "Dump Rows");
                }
            }
            if (this.writer == null || !this.writer.isValid) continue;
            try {
                if (this.format == FORMAT.XML) {
                    this.writer.startDocument();
                    this.writer.writeComment(string3);
                    this.writer.writeStart(string);
                } else {
                    this.writer.writeComment(string3);
                }
                this.dumpObjectRows();
                this.writer.writeLine("\r\n");
                if (this.format == FORMAT.XML) {
                    this.writer.writeEnd(string);
                    this.writer.endDocument();
                }
                this.writer.close();
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Dump Rows");
            }
        }
    }

    private void dumpObjectRows() {
        if (this.mode == MODE.TABLE) {
            this.dumpObjectRowsFromTable(null);
        } else {
            this.dumpObjectRowsFromTable(this.sqlStatement);
        }
    }

    private void dumpObjectRowsFromTable(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        if (string == null) {
            string2 = "select * from " + Globals.doubleQuote(this.objectOwner) + "." + Globals.doubleQuote(this.objectName);
        } else {
            if (string.endsWith(";")) {
                string = string.substring(0, string.length() - 1);
            }
            string2 = string;
        }
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string2);
        if (resultSet != null) {
            try {
                int n;
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                String string3 = this.fieldsSeparatorTB.getText();
                if (this.colHeadersCB.isSelected()) {
                    for (n = 1; n <= n2; ++n) {
                        if (this.format == FORMAT.CSV) {
                            if (n > 1) {
                                this.writer.write(string3 + "  ");
                            } else {
                                this.writer.write("# ");
                            }
                            this.writer.write("\"" + resultSetMetaData.getColumnName(n) + "\"");
                            continue;
                        }
                        if (this.format != FORMAT.XML) continue;
                        arrayList.add(resultSetMetaData.getColumnName(n));
                    }
                    if (this.format == FORMAT.CSV) {
                        this.writer.writeLine("");
                        this.writer.writeLine("");
                    }
                }
                n = 1;
                String string4 = "";
                while (resultSet.next()) {
                    string4 = "";
                    if (this.format == FORMAT.XML) {
                        this.writer.writeStart("ROW_" + n);
                    }
                    String string5 = this.fieldsQuoteTB.getText();
                    boolean bl = this.quoteNumerics.isSelected();
                    for (int i = 1; i <= n2; ++i) {
                        String string6 = resultSet.getString(i);
                        int n3 = resultSetMetaData.getColumnType(i);
                        if (this.format == FORMAT.CSV) {
                            if (i > 1) {
                                string4 = string4 + string3;
                            }
                            if (string6 == null || string6.equals("(null)")) continue;
                            if (string5.length() > 0 && string6 != null && string6.contains(string5)) {
                                string6 = string6.replace(string5, "\\" + string5);
                            }
                            switch (n3) {
                                case -16: 
                                case -15: 
                                case -9: 
                                case -1: 
                                case 1: 
                                case 12: {
                                    string6 = string5 + string6 + string5;
                                    break;
                                }
                                default: {
                                    if (!bl) break;
                                    string6 = string5 + string6 + string5;
                                }
                            }
                            string4 = string4 + string6;
                            continue;
                        }
                        if (string6 == null || string6.equals("(null)")) {
                            this.writer.writeValue((String)arrayList.get(i - 1), "");
                            continue;
                        }
                        this.writer.writeValue((String)arrayList.get(i - 1), string6);
                    }
                    if (this.format == FORMAT.CSV) {
                        this.writer.writeLine(string4);
                    } else {
                        this.writer.writeEnd("ROW_" + n);
                    }
                    ++n;
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "Dump Rows");
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Dump Rows");
            }
        }
    }

    private void dumpObjectRowsFromGrid() {
        String string = "";
        ArrayList arrayList = new ArrayList();
        try {
            if (this.colHeadersCB.isSelected()) {
                for (int i = 0; i < this.model.getColumnCount(); ++i) {
                    if (this.format == FORMAT.CSV) {
                        if (i > 0) {
                            this.writer.write(", ");
                        }
                        this.writer.write("\"" + (String)this.model.columnsName.get(i) + "\"");
                        continue;
                    }
                    arrayList.add(this.model.columnsName.get(i));
                }
                if (this.format == FORMAT.CSV) {
                    this.writer.writeLine("");
                }
            }
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                string = "";
                if (this.format == FORMAT.XML) {
                    this.writer.writeStart("ROW_" + (i + 1));
                }
                for (int j = 0; j < this.model.getColumnCount(); ++j) {
                    Object object;
                    if (this.format == FORMAT.CSV) {
                        if (j > 0) {
                            string = string + ", ";
                        }
                        if ((object = this.model.getValueAt(i, j)) == null || object.toString().equals("(null)")) continue;
                        String string2 = object.toString();
                        if (string2.contains("\"")) {
                            string2.replace("\"", "\"\"");
                        }
                        string2 = "\"" + string2 + "\"";
                        string = string + string2;
                        continue;
                    }
                    object = this.model.getValueAt(i, j);
                    if (object == null || object.toString().equals("(null)")) {
                        this.writer.writeValue((String)arrayList.get(j), "");
                        continue;
                    }
                    this.writer.writeValue((String)arrayList.get(j), object.toString());
                }
                if (this.format == FORMAT.CSV) {
                    this.writer.writeLine(string);
                    continue;
                }
                this.writer.writeEnd("ROW_" + (i + 1));
            }
        }
        catch (IOException iOException) {
            Globals.showException(iOException, "Dump Rows");
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void formatCBItemStateChanged(ItemEvent itemEvent) {
        String string = (String)this.formatCB.getSelectedItem();
        if (string.startsWith("Comma")) {
            this.format = FORMAT.CSV;
            this.colHeadersCB.setEnabled(true);
        } else {
            this.format = FORMAT.XML;
            this.colHeadersCB.setEnabled(false);
            this.colHeadersCB.setSelected(true);
        }
    }

    private void oneFileCBStateChanged(ChangeEvent changeEvent) {
        this.appendCB.setEnabled(!this.oneFileCB.isSelected());
    }

    private void browseBTNActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        if (this.useObjectNameCB.isSelected()) {
            if (directoryName == null) {
                directoryName = Globals.execDir;
            }
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setCurrentDirectory(new File(directoryName));
            int n = jFileChooser.showSaveDialog(this.mainFrame);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                directoryName = file.getAbsolutePath();
                this.fileNameTB.setText(directoryName);
            }
        } else {
            FileNameExtensionFilter fileNameExtensionFilter;
            if (this.format == FORMAT.CSV) {
                fileNameExtensionFilter = new FileNameExtensionFilter("csv files (*.csv)", "csv");
                jFileChooser.setFileFilter(fileNameExtensionFilter);
            } else if (this.format == FORMAT.XML) {
                fileNameExtensionFilter = new FileNameExtensionFilter("xml files (*.xml)", "xml");
                jFileChooser.setFileFilter(fileNameExtensionFilter);
            }
            if (fileName == null) {
                fileName = Globals.execDir;
            }
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setCurrentDirectory(new File(fileName));
            int n = jFileChooser.showSaveDialog(this.mainFrame);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                fileName = file.getAbsolutePath();
                this.fileNameTB.setText(fileName);
            }
        }
    }

    private void useObjectNameCBItemStateChanged(ItemEvent itemEvent) {
        if (this.useObjectNameCB.isSelected()) {
            this.fileLabel.setText("Output Directory :");
            this.fileNameTB.setText(directoryName);
        } else {
            this.fileLabel.setText("Output File :");
            this.fileNameTB.setText(fileName);
        }
        this.appendCB.setEnabled(false);
        this.oneFileCB.setEnabled(false);
        this.appendCB.setSelected(false);
        this.oneFileCB.setSelected(false);
        if (this.objectType == TREE_OBJECT.TABLES) {
            this.oneFileCB.setEnabled(!this.useObjectNameCB.isSelected());
            this.oneFileCB.setSelected(this.useObjectNameCB.isSelected());
            this.appendCB.setEnabled(!this.oneFileCB.isSelected());
        }
        if (this.mode != MODE.TABLE) {
            this.appendCB.setEnabled(true);
        }
    }

    class Writer {
        private FileWriter sw = null;
        private FileWriter xwf = null;
        private DataWriter xw = null;
        private FORMAT format;
        public boolean isValid = false;

        public Writer(String string, FORMAT fORMAT, boolean bl) throws IOException {
            this.format = fORMAT;
            try {
                if (fORMAT == FORMAT.CSV) {
                    this.sw = new FileWriter(string, bl);
                } else if (fORMAT == FORMAT.XML) {
                    this.xwf = new FileWriter(string, bl);
                    this.xw = new DataWriter(this.xwf);
                    this.xw.setIndentStep(4);
                }
                this.isValid = true;
            }
            catch (Exception exception) {
                Globals.showException(exception, "Dump Rows");
            }
        }

        public void close() throws IOException {
            if (this.format == FORMAT.CSV) {
                this.sw.close();
            } else if (this.format == FORMAT.XML) {
                this.xwf.close();
            }
        }

        public void endDocument() throws IOException {
            if (this.format == FORMAT.XML) {
                try {
                    this.xw.endDocument();
                }
                catch (SAXException sAXException) {
                    throw new IOException(sAXException.getMessage());
                }
            }
        }

        public void startDocument() throws IOException {
            if (this.format == FORMAT.XML) {
                try {
                    this.xw.startDocument();
                }
                catch (SAXException sAXException) {
                    throw new IOException(sAXException.getMessage());
                }
            }
        }

        public void write(String string) throws IOException {
            if (this.format == FORMAT.CSV) {
                this.sw.write(string);
            }
        }

        public void writeLine(String string) throws IOException {
            if (this.format == FORMAT.CSV) {
                this.sw.write(string + "\r\n");
            }
        }

        public void writeComment(String string) throws IOException {
            if (this.format == FORMAT.CSV) {
                this.sw.write(string + "\r\n\r\n");
            } else if (this.format == FORMAT.XML) {
                char[] cArray = string.toCharArray();
                try {
                    this.xwf.write("<!--");
                    this.xw.characters(cArray, 0, string.length());
                    this.xwf.write("-->\r\n");
                }
                catch (SAXException sAXException) {
                    throw new IOException(sAXException.getMessage());
                }
            }
        }

        public void writeValue(String string, String string2) throws IOException {
            try {
                this.xw.dataElement(string, string2);
            }
            catch (SAXException sAXException) {
                throw new IOException(sAXException.getMessage());
            }
        }

        public void writeStart(String string) throws IOException {
            try {
                this.xw.startElement(string);
            }
            catch (SAXException sAXException) {
                throw new IOException(sAXException.getMessage());
            }
        }

        public void writeEnd(String string) throws IOException {
            try {
                this.xw.endElement(string);
            }
            catch (SAXException sAXException) {
                throw new IOException(sAXException.getMessage());
            }
        }
    }

    public class RunSomeTask
    implements Runnable {
        @Override
        public void run() {
            DumpRows.this.dumpObjects();
            DumpRows.this.objectTypeLabel.setText("Dump Completed");
            DumpRows.this.objectLabel.setText("");
            DumpRows.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    static enum MODE {
        TABLE,
        RECORDGRID,
        STATEMENTGRID;

    }

    static enum FORMAT {
        CSV,
        XML;

    }
}

