/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.MyTreeNode;
import ctreeaceexplorer.TREE_OBJECT;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.TreeNode;

public class ExportSchema
extends JDialog {
    TREE_OBJECT objectType;
    String objectName;
    String objectOwner;
    static String fileName;
    static String directoryName;
    ArrayList<String> objects = new ArrayList();
    JFrame mainFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
    FileWriter writer = null;
    boolean multi = false;
    MyTreeNode currentNode = null;
    ArrayList<String> Identities = new ArrayList();
    ArrayList<String> constraintNames = new ArrayList();
    private JCheckBox appendCB;
    private JButton browseBTN;
    private JButton cancelButton;
    private JCheckBox dumpCB;
    private JCheckBox exportPermsCB;
    private JLabel fileLabel;
    private JTextField fileNameTB;
    private JSpinner insertCommitSP;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel label4;
    private JLabel label5;
    private JLabel objectLabel;
    private JLabel objectTypeLabel;
    private JButton okButton;
    private JCheckBox oneFileCB;
    private JCheckBox useObjectNameCB;

    public ExportSchema(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    public void showDialog(TREE_OBJECT tREE_OBJECT, String string, MyTreeNode myTreeNode) {
        this.oneFileCB.setEnabled(false);
        this.objectTypeLabel.setText("");
        this.objectLabel.setText("");
        this.objectType = tREE_OBJECT;
        this.currentNode = myTreeNode;
        this.objectName = string;
        if (this.objectName.equals("_$Checked")) {
            this.multi = true;
        }
        this.fileNameTB.setText(fileName);
        this.objectOwner = Globals.currentSqlConnection.getSelectedUser();
        this.setTitle("Export Schema");
        if (this.objectType == TREE_OBJECT.TABLES || this.objectType == TREE_OBJECT.VIEWS || this.objectType == TREE_OBJECT.UPROCEDURES || this.objectType == TREE_OBJECT.UDFS || this.objectType == TREE_OBJECT.TRIGGERS) {
            this.oneFileCB.setEnabled(true);
            this.appendCB.setEnabled(true);
        }
        if (this.objectType != TREE_OBJECT.TABLES && this.objectType != TREE_OBJECT.TABLE && this.objectType != TREE_OBJECT.TABLE_RTG && this.objectType != TREE_OBJECT.TABLE_LINKED) {
            this.dumpCB.setEnabled(false);
            this.insertCommitSP.setEnabled(false);
            this.label4.setEnabled(false);
            this.label5.setEnabled(false);
        }
        this.getRootPane().setDefaultButton(this.okButton);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel2 = new JPanel();
        this.oneFileCB = new JCheckBox();
        this.useObjectNameCB = new JCheckBox();
        this.appendCB = new JCheckBox();
        this.fileLabel = new JLabel();
        this.fileNameTB = new JTextField();
        this.browseBTN = new JButton();
        this.jLabel3 = new JLabel();
        this.objectTypeLabel = new JLabel();
        this.objectLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.dumpCB = new JCheckBox();
        this.label4 = new JLabel();
        this.insertCommitSP = new JSpinner();
        this.label5 = new JLabel();
        this.exportPermsCB = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Export Schema");
        this.setResizable(false);
        this.jPanel1.setName("jPanel1");
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportSchema.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton.setMnemonic('E');
        this.cancelButton.setText("Exit");
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportSchema.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(91, 91, 91).addComponent(this.okButton, -2, 75, -2).addGap(63, 63, 63).addComponent(this.cancelButton, -2, 76, -2).addContainerGap(88, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Output File(s)"));
        this.jPanel2.setName("jPanel2");
        this.oneFileCB.setText("One File Per Object");
        this.oneFileCB.setName("oneFileCB");
        this.oneFileCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ExportSchema.this.oneFileCBStateChanged(changeEvent);
            }
        });
        this.useObjectNameCB.setText("Use Object Name As File Name");
        this.useObjectNameCB.setName("useObjectNameCB");
        this.useObjectNameCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ExportSchema.this.useObjectNameCBItemStateChanged(itemEvent);
            }
        });
        this.appendCB.setText("Append To Output Fille");
        this.appendCB.setName("appendCB");
        this.fileLabel.setText("Output File :");
        this.fileLabel.setName("fileLabel");
        this.fileNameTB.setName("fileNameTB");
        this.browseBTN.setText("...");
        this.browseBTN.setName("browseBTN");
        this.browseBTN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportSchema.this.browseBTNActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileLabel).addComponent(this.oneFileCB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 49, Short.MAX_VALUE).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.appendCB).addComponent(this.useObjectNameCB))).addGroup(groupLayout2.createSequentialGroup().addComponent(this.fileNameTB, -1, 310, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseBTN, -2, 25, -2))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useObjectNameCB).addComponent(this.oneFileCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.appendCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileNameTB, -2, -1, -2).addComponent(this.browseBTN)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel3.setText("Exporting :");
        this.jLabel3.setName("jLabel3");
        this.objectTypeLabel.setText("Object");
        this.objectTypeLabel.setName("objectTypeLabel");
        this.objectLabel.setText("ObjectName");
        this.objectLabel.setName("objectLabel");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Options"));
        this.jPanel3.setName("jPanel3");
        this.dumpCB.setText("Include rows (Records) as SQL 'Insert' statements");
        this.dumpCB.setName("dumpCB");
        this.label4.setText("Insert \"Commit\" in \"Export Schema\" script every");
        this.label4.setName("label4");
        this.insertCommitSP.setName("insertCommitSP");
        this.label5.setText("records");
        this.label5.setName("label5");
        this.exportPermsCB.setText("Export Object Permissions");
        this.exportPermsCB.setName("exportPermsCB");
        GroupLayout groupLayout3 = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.exportPermsCB).addComponent(this.dumpCB).addGroup(groupLayout3.createSequentialGroup().addComponent(this.label4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.insertCommitSP, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.label5))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.dumpCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addComponent(this.exportPermsCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label4).addComponent(this.insertCommitSP, -2, -1, -2).addComponent(this.label5)).addGap(6, 6, 6)));
        GroupLayout groupLayout4 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.objectTypeLabel).addGap(18, 18, 18).addComponent(this.objectLabel)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jPanel3, -2, -1, -2).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addGap(11, 11, 11).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.objectTypeLabel).addComponent(this.objectLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        if (this.fileNameTB.getText().isEmpty()) {
            Globals.showMessage("Please input a filename or a directory", "Error");
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Thread thread = new Thread(new RunSomeTask());
        String string = "";
        this.objects.clear();
        switch (this.objectType) {
            case TABLE: 
            case TABLE_RTG: 
            case TABLE_LINKED: 
            case VIEW: 
            case UPROCEDURE: 
            case UDF: 
            case TRIGGER: {
                this.objects.add(this.objectName);
                thread.start();
                break;
            }
            case TABLES: {
                string = "select tbl from admin.systables where owner = '" + this.objectOwner + "' and tbltype = 'T' order by id";
                this.setObjectsArray(string);
                if (this.objects.isEmpty()) break;
                thread.start();
                break;
            }
            case VIEWS: {
                string = "select tbl from admin.systables where owner = '" + this.objectOwner + "' and (tbltype = 'V' or tbltype = 'C') order by id";
                this.setObjectsArray(string);
                if (this.objects.isEmpty()) break;
                thread.start();
                break;
            }
            case UPROCEDURES: {
                string = "select proc_name from admin.sysprocedures where proc_type = 'stored' and owner = '" + this.objectOwner + "'";
                this.setObjectsArray(string);
                if (this.objects.isEmpty()) break;
                thread.start();
                break;
            }
            case UDFS: {
                string = "select proc_name from admin.sysprocedures where proc_type = 'udf' and owner = '" + this.objectOwner + "'";
                this.setObjectsArray(string);
                if (this.objects.isEmpty()) break;
                thread.start();
                break;
            }
            case TRIGGERS: {
                string = "select triggername from admin.systrigger where owner = '" + this.objectOwner + "'";
                this.setObjectsArray(string);
                if (this.objects.isEmpty()) break;
                thread.start();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setObjectsArray(String string) {
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string);
        if (resultSet == null) return;
        try {
            block2: while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    return;
                }
                if (this.multi) {
                    String string2 = resultSet.getString(1);
                    if (this.currentNode.getChildCount() < 0) continue;
                    Enumeration<TreeNode> enumeration = this.currentNode.children();
                    while (true) {
                        if (!enumeration.hasMoreElements()) continue block2;
                        MyTreeNode myTreeNode = (MyTreeNode)enumeration.nextElement();
                        if (!myTreeNode.name.equals(string2) || !myTreeNode.isChecked()) continue;
                        this.objects.add(resultSet.getString(1));
                    }
                }
                this.objects.add(resultSet.getString(1));
            }
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "Export Schema");
        }
    }

    private void setWriter(String string, Integer n, boolean bl, boolean bl2) {
        String string2;
        String string3 = string2 = this.fileNameTB.getText();
        if (!bl2) {
            bl2 = this.appendCB.isSelected();
        }
        if (this.useObjectNameCB.isSelected()) {
            string2 = string + ".sql";
            try {
                if (this.writer != null) {
                    this.writer.close();
                    this.writer = null;
                }
                this.writer = new FileWriter(string3 + File.separator + string2, bl2);
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Export Schema");
            }
        } else if (this.oneFileCB.isSelected()) {
            try {
                String string4;
                int n2 = string3.indexOf(".s");
                if (n2 > 0) {
                    string3 = string3.substring(0, n2);
                }
                if (!(string4 = string3 + "_" + n.toString()).contains(".s")) {
                    string4 = string4 + ".sql";
                }
                if (this.writer != null) {
                    this.writer.close();
                }
                this.writer = new FileWriter(string4, bl2);
                Integer n3 = n;
                Integer n4 = n = Integer.valueOf(n + 1);
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Export Schema");
            }
        } else {
            if (!string3.contains(".s")) {
                string3 = string3 + ".sql";
            }
            if (!bl) {
                bl2 = true;
            }
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
                this.writer = new FileWriter(string3, bl2);
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Export Schema");
            }
        }
    }

    private void createViews() {
        Object object;
        Object object2;
        Integer n = 0;
        Boolean bl = true;
        for (String string : this.objects) {
            this.objectTypeLabel.setText("Table : ");
            this.objectLabel.setText(string);
            this.objectName = string;
            this.objectLabel.repaint();
            this.objectLabel.invalidate();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(ExportSchema.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            this.setWriter(string, n, bl, false);
            bl = false;
            object2 = n;
            n = n + 1;
            object = n;
            object2 = "\r\ncreate view \"" + this.objectOwner + "\".\"" + this.objectName + "\" (";
            try {
                this.writer.write((String)object2 + "\r\n");
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Export Schema");
            }
            this.createViewColumns();
            object2 = " as\r\n";
            object = "select viewtext from admin.sysviews where viewname ='" + this.objectName + "' and owner ='" + this.objectOwner + "'";
            ResultSet resultSet = Globals.currentSqlConnection.execRsQuery((String)object);
            if (resultSet != null) {
                try {
                    while (resultSet.next()) {
                        object2 = (String)object2 + resultSet.getString(1);
                    }
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    Globals.showException(sQLException, "Export Schema");
                }
            }
            if ((resultSet = Globals.currentSqlConnection.execRsQuery((String)(object = "select tbltype from admin.systables where owner = '" + this.objectOwner + "' and tbl ='" + this.objectName + "' and (tbltype = 'V' or tbltype = 'C')"))) != null) {
                try {
                    while (resultSet.next()) {
                        String string2 = resultSet.getString(1);
                        if (string2.equals("C")) {
                            object2 = (String)object2 + " WITH CHECK OPTION";
                        }
                        object2 = (String)object2 + ";\r\n";
                    }
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    Globals.showException(sQLException, "Export Schema");
                }
            }
            try {
                this.writer.write((String)object2);
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Export Schema");
            }
        }
        if (this.exportPermsCB.isSelected()) {
            n = 0;
            bl = true;
            for (String string : this.objects) {
                this.setWriter(string, n, bl, true);
                bl = false;
                object2 = n;
                n = n + 1;
                object = n;
                this.objectTypeLabel.setText("Permissions");
                this.objectLabel.setText(string);
                this.objectName = string;
                this.setPermissions();
            }
        }
        try {
            this.writer.write("\r\nset schema user;\r\n");
        }
        catch (IOException iOException) {
            Globals.showException(iOException, "Export Schema");
        }
    }

    private void createViewColumns() {
        String string = "";
        String string2 = "";
        String string3 = "select col from admin.syscolumns where tbl ='" + this.objectName + "' and owner ='" + this.objectOwner + "' order by id";
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string3);
        boolean bl = true;
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    if (bl) {
                        bl = false;
                    } else {
                        string = string + ",\r\n";
                    }
                    string2 = resultSet.getString(1);
                    string = string + "\t\"" + string2 + "\"";
                }
                resultSet.close();
                string = string + "\r\n)";
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "Export Schema");
            }
            try {
                this.writer.write(string);
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Export Schema");
            }
        }
    }

    private void createTables() {
        Object object;
        Object object2;
        Integer n = 0;
        Boolean bl = true;
        for (String string : this.objects) {
            this.objectTypeLabel.setText("Table : ");
            this.objectLabel.setText(string);
            this.objectName = string;
            this.objectLabel.repaint();
            this.objectLabel.invalidate();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(ExportSchema.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            this.setWriter(string, n, bl, false);
            bl = false;
            object2 = n;
            n = n + 1;
            object = n;
            object2 = "\r\ncreate table \"" + this.objectOwner + "\".\"" + this.objectName + "\" (";
            try {
                this.writer.write((String)object2 + "\r\n");
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Export Schema");
            }
            this.createColumns();
            try {
                object = Globals.currentSqlConnection.getConstraintsStatus(this.objectName);
                if (object == null) continue;
                boolean bl2 = (Boolean)object[0];
                boolean bl3 = (Boolean)object[2];
                boolean bl4 = (Boolean)object[3];
                if (bl2) {
                    this.createPK();
                }
                if (bl4) {
                    this.createUK();
                }
                if (bl3) {
                    this.createCHK();
                }
                this.writer.write("\r\n)");
                this.CreateStorageAttributes();
                this.writer.write(";\r\n");
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Export Schema");
            }
        }
        n = 0;
        bl = true;
        for (String string : this.objects) {
            this.setWriter(string, n, bl, true);
            bl = false;
            object2 = n;
            n = Integer.valueOf(n + 1);
            object = n;
            this.objectTypeLabel.setText("Index");
            this.objectLabel.setText(string);
            this.objectName = string;
            this.createIndexes();
        }
        if (this.dumpCB.isSelected()) {
            n = 0;
            bl = true;
            for (String string : this.objects) {
                this.setWriter(string, n, bl, true);
                bl = false;
                object2 = n;
                n = n + 1;
                object = n;
                this.objectTypeLabel.setText("Data");
                this.objectLabel.setText(string);
                this.objectName = string;
                this.dumpData();
            }
        }
        n = 0;
        bl = true;
        for (String string : this.objects) {
            this.setWriter(string, n, bl, true);
            bl = false;
            object2 = n;
            n = n + 1;
            object = n;
            this.objectTypeLabel.setText("Synonym");
            this.objectLabel.setText(string);
            this.objectName = string;
            this.createSynonyms();
        }
        n = 0;
        bl = true;
        for (String string : this.objects) {
            this.setWriter(string, n, bl, true);
            bl = false;
            object2 = n;
            n = n + 1;
            object = n;
            this.objectTypeLabel.setText("Constraints");
            this.objectLabel.setText(string);
            this.objectName = string;
            this.createFK();
        }
        if (this.exportPermsCB.isSelected()) {
            n = 0;
            bl = true;
            for (String string : this.objects) {
                this.setWriter(string, n, bl, true);
                bl = false;
                object2 = n;
                n = n + 1;
                object = n;
                this.objectTypeLabel.setText("Permissions");
                this.objectLabel.setText(string);
                this.objectName = string;
                this.setPermissions();
            }
        }
        try {
            this.writer.write("\r\nset schema user;\r\n");
        }
        catch (IOException iOException) {
            Globals.showException(iOException, "Export Schema");
        }
    }

    private void CreateStorageAttributes() {
        MyTreeNode myTreeNode = null;
        TREE_OBJECT tREE_OBJECT = this.currentNode.getType();
        myTreeNode = tREE_OBJECT == TREE_OBJECT.TABLES ? (MyTreeNode)this.currentNode.getParent().getParent() : (MyTreeNode)this.currentNode.getParent().getParent().getParent();
        if (myTreeNode.getDbVersion() > 1) {
            ResultSet resultSet = Globals.currentSqlConnection.execRsQuery("select tbl_attrib from admin.systables where tbl ='" + this.objectName + "' and owner ='" + this.objectOwner + "'");
            String string = "";
            if (resultSet != null) {
                try {
                    while (resultSet.next()) {
                        string = resultSet.getString(1);
                    }
                }
                catch (SQLException sQLException) {
                    Globals.showException(sQLException, "Export Schema");
                }
                try {
                    if (string != null && string.length() > 0) {
                        this.writer.write("\r\nSTORAGE_ATTRIBUTES '" + string + "'\r\n");
                    }
                }
                catch (IOException iOException) {
                    Globals.showException(iOException, "Export Schema");
                }
            }
        }
    }

    private void createColumns() {
        String string = "";
        String string2 = "";
        string = Globals.currentSqlConnection.isIdentitySupported() ? "select col, coltype, width, scale, nullflag, dflt_value, case when colid is null then 'N' else 'Y' end as 'identity', seed, incr, charset, collation  from admin.syscolumns cols left join admin.sysidentity ids on cols.owner = ids.owner and cols.tbl = ids.tbl and cols.id = ids.colid where cols.tbl = '" + this.objectName + "' and cols.owner = '" + this.objectOwner + "' order by id" : "select col, coltype, width, scale, nullflag, dflt_value,    '( n.a. )' as 'identity', '( n.a. )' as 'seed', '( n.a. )' as 'incr', charset, collation  from admin.syscolumns cols where cols.tbl = '" + this.objectName + "' and cols.owner = '" + this.objectOwner + "' order by id";
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string);
        Integer n = 0;
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    Integer n2;
                    Integer n3;
                    String string3;
                    Object object;
                    Object object2;
                    if (n > 0) {
                        string2 = string2 + ",\r\n";
                    }
                    String string4 = resultSet.getString(1);
                    string2 = string2 + "\t\"" + string4 + "\"";
                    String string5 = resultSet.getString(2);
                    if (string5.equals("double")) {
                        string5 = "double precision";
                    }
                    string2 = string2 + " " + string5;
                    if (string5.equals("character") || string5.equals("varchar") || string5.equals("nchar") || string5.equals("nvarchar") || string5.equals("binary") || string5.equals("varbinary") || string5.equals("float") || string5.equals("numeric") || string5.equals("decimal")) {
                        object2 = Integer.parseInt(resultSet.getString(3));
                        if ((Integer)object2 > 0) {
                            string2 = string2 + " (" + object2;
                            object = Integer.parseInt(resultSet.getString(4));
                            if ((Integer)object > 0) {
                                string2 = string2 + "," + object;
                            }
                            string2 = string2 + ")";
                        }
                    } else if (string5.equals("money") && (Integer)(object2 = Integer.valueOf(Integer.parseInt(resultSet.getString(3)))) > 0) {
                        string2 = string2 + " (" + object2 + ")";
                    }
                    object2 = resultSet.getString(5);
                    if (((String)object2).toLowerCase().equals("n")) {
                        string2 = string2 + " not null";
                    }
                    if ((object = resultSet.getString(6)) != null && !((String)object).isEmpty()) {
                        object = ((String)object).replace("\"", "");
                        string2 = string2 + " default ";
                        string3 = ((String)object).toUpperCase();
                        string2 = string3.equals("USER") || string3.equals("NULL") || string3.equals("UID") || string3.equals("SYSDATE") || string3.equals("SYSTIME") || string3.equals("SYSTIMESTAMP") ? string2 + (String)object : string2 + "'" + (String)object + "'";
                    }
                    if ((string3 = resultSet.getString(7)).equals("Y")) {
                        this.Identities.add(this.objectOwner + this.objectName + n.toString());
                        string2 = string2 + " identity ";
                        string2 = string2 + "(";
                        n3 = Integer.parseInt(resultSet.getString(8));
                        string2 = n3 > 0 ? string2 + n3 : string2 + "1";
                        string2 = string2 + ",";
                        n2 = Integer.parseInt(resultSet.getString(9));
                        string2 = n2 > 0 ? string2 + n2 : string2 + "1";
                        string2 = string2 + ")";
                    }
                    n3 = n;
                    n2 = n = Integer.valueOf(n + 1);
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "Export Schema");
            }
            try {
                this.writer.write(string2);
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Export Schema");
            }
        }
    }

    private void createPK() {
        String string = "";
        String string2 = "select u.colname, u.cnstrname, c.idxname from admin.sys_tbl_constrs c join admin.sys_keycol_usage u on c.owner = u.owner and c.tblname = u.tblname and c.cnstrname = u.cnstrname  where c.owner = '" + this.objectOwner + "' and c.tblname = '" + this.objectName + "' and c.cnstrtype = 'P'";
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string2);
        boolean bl = true;
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    if (bl) {
                        string = string + ", \r\n";
                        String string3 = resultSet.getString(2);
                        this.constraintNames.add(resultSet.getString(3));
                        string = string + "constraint " + string3 + " ";
                        string = string + "primary key (";
                        bl = false;
                    } else {
                        string = string + ", ";
                    }
                    string = string + "\"" + resultSet.getString(1) + "\"";
                }
                resultSet.close();
                string = string + ")";
                try {
                    this.writer.write(string);
                }
                catch (IOException iOException) {
                    Globals.showException(iOException, "setupPK");
                }
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "setupPK");
            }
        }
    }

    private void createUK() {
        String string = "";
        String string2 = "select u.colname, u.cnstrname, c.idxname from admin.sys_tbl_constrs c join admin.sys_keycol_usage u on c.owner = u.owner and c.tblname = u.tblname and c.cnstrname = u.cnstrname  where c.owner = '" + this.objectOwner + "' and c.tblname = '" + this.objectName + "' and c.cnstrtype = 'U' " + "order by u.cnstrname, u.colposition";
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string2);
        boolean bl = true;
        if (resultSet != null) {
            try {
                String string3 = "";
                string = string + ", \r\n";
                while (resultSet.next()) {
                    String string4 = resultSet.getString(2);
                    this.constraintNames.add(resultSet.getString(3));
                    if (!bl && !string3.equals(string4)) {
                        string = string + "),\r\n";
                        string = string + "constraint " + string4 + " ";
                        string = string + "unique (";
                        string = string + "\"" + resultSet.getString(1) + "\"";
                        string3 = string4;
                        continue;
                    }
                    if (bl) {
                        string = string + "constraint " + string4 + " ";
                        string = string + "unique (";
                        string = string + "\"" + resultSet.getString(1) + "\"";
                        bl = false;
                        string3 = string4;
                        continue;
                    }
                    string = string + ",\"" + resultSet.getString(1) + "\"";
                }
                string = string + ")";
                resultSet.close();
                try {
                    this.writer.write(string);
                }
                catch (IOException iOException) {
                    Globals.showException(iOException, "setupPK");
                }
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "setupUK");
            }
        }
    }

    private void createCHK() {
        String string = "";
        String string2 = "select l.chkclause, c.cnstrname from admin.sys_tbl_constrs c join admin.sys_chk_constrs l on c.owner = l.owner and c.tblname = l.tblname and c.cnstrname = l.cnstrname where c.owner = '" + this.objectOwner + "' and c.tblname = '" + this.objectName + "' and c.cnstrtype = 'C' " + "order by l.cnstrname";
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string2);
        boolean bl = true;
        if (resultSet != null) {
            try {
                String string3 = "";
                while (resultSet.next()) {
                    String string4 = resultSet.getString(2);
                    if (!bl && !string3.equals(string4)) {
                        string = string + ",\r\n";
                        if (!string4.startsWith("sys_")) {
                            string = string + "constraint " + string4 + " ";
                        }
                        string = string + "check ";
                        string = string + resultSet.getString(1);
                        string3 = string4;
                        bl = true;
                        continue;
                    }
                    if (bl) {
                        string = string + ", \r\n";
                        if (!string4.startsWith("sys_")) {
                            string = string + "constraint " + string4 + " ";
                        }
                        string = string + "check ";
                        string = string + resultSet.getString(1);
                        bl = false;
                        string3 = string4;
                        continue;
                    }
                    string = string + ",\"" + resultSet.getString(1) + "\"";
                }
                resultSet.close();
                try {
                    this.writer.write(string);
                }
                catch (IOException iOException) {
                    Globals.showException(iOException, "setupCHK");
                }
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "setupCHK");
            }
        }
    }

    private void createIndexes() {
        String string = "";
        String string2 = "";
        MyTreeNode myTreeNode = null;
        TREE_OBJECT tREE_OBJECT = this.currentNode.getType();
        myTreeNode = tREE_OBJECT == TREE_OBJECT.TABLES ? (MyTreeNode)this.currentNode.getParent().getParent() : (MyTreeNode)this.currentNode.getParent().getParent().getParent();
        string2 = myTreeNode.getDbVersion() > 1 ? "select idxname, idxowner, idxtype, idxcompress, idxattrib from admin.sysindexes where tblowner = '" + this.objectOwner + "' and tbl = '" + this.objectName + "' and idxseq = 0 order by idxname" : "select idxname, idxowner, idxtype, idxcompress from admin.sysindexes where tblowner = '" + this.objectOwner + "' and tbl = '" + this.objectName + "' and idxseq = 0 order by idxname";
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string2);
        try {
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string3;
                    String string4 = resultSet.getString(1);
                    if (this.constraintNames.contains(string4)) continue;
                    string = "\r\ncreate ";
                    String string5 = resultSet.getString(3);
                    if (string5.toUpperCase().equals("U")) {
                        string = string + "unique ";
                    }
                    string = string + "index ";
                    string = string + "\"" + this.objectOwner + "\".\"" + string4 + "\"";
                    string = string + " on \"" + this.objectOwner + "\".\"" + this.objectName + "\" ";
                    string2 = "select colname, idxorder from admin.sysindexes where tblowner = '" + this.objectOwner + "' and tbl = '" + this.objectName + "' and idxname ='" + string4 + "' order by idxseq";
                    ResultSet resultSet2 = Globals.currentSqlConnection.execRsQuery(string2);
                    string = string + "(";
                    boolean bl = true;
                    if (resultSet2 != null) {
                        while (resultSet2.next()) {
                            if (bl) {
                                bl = false;
                            } else {
                                string = string + ", ";
                            }
                            String string6 = resultSet2.getString(1);
                            String string7 = resultSet2.getString(2);
                            string = string + "\"" + string6 + "\"";
                            if (!string7.equals("D")) continue;
                            string = string + " DESC";
                        }
                        resultSet2.close();
                    }
                    string = string + ")";
                    string = myTreeNode.getDbVersion() > 1 ? ((string3 = resultSet.getString(5)) != null && string3.length() > 0 ? string + "\r\nSTORAGE_ATTRIBUTES '" + string3 + "';\r\n" : string + ";\r\n") : string + ";\r\n";
                    this.writer.write(string);
                }
                resultSet.close();
            }
        }
        catch (IOException iOException) {
            Globals.showException(iOException, "Create Indexes");
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "Create Indexes");
        }
    }

    private void dumpData() {
        int n = 0;
        String string = null;
        String string2 = "select * from \"" + this.objectOwner + "\".\"" + this.objectName + "\"";
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string2);
        if (resultSet != null) {
            try {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                this.writer.write("\r\n");
                while (resultSet.next()) {
                    string = "insert into \"" + this.objectOwner + "\".\"" + this.objectName + "\" values(";
                    boolean bl = false;
                    Integer n3 = 1;
                    while (n3 <= n2) {
                        if (!this.Identities.contains(this.objectOwner + this.objectName + n3.toString())) {
                            try {
                                if (bl) {
                                    string = string + ",";
                                }
                                int n4 = resultSetMetaData.getColumnType(n2);
                                String string3 = resultSet.getString(n3);
                                if (resultSet.wasNull()) {
                                    string3 = "NULL";
                                } else {
                                    if (n4 == -7) {
                                        if (string3.toLowerCase().equals("true")) {
                                            string3 = "1";
                                        } else if (string3.toLowerCase().equals("false")) {
                                            string3 = "0";
                                        }
                                    } else if (string3.contains("'")) {
                                        string3 = string3.replace("'", "''");
                                    }
                                    string3 = "'" + string3 + "'";
                                }
                                string = string + string3;
                                bl = true;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        Integer n5 = n3;
                        Integer n6 = n3 = Integer.valueOf(n3 + 1);
                    }
                    string = string + ");";
                    this.writer.write(string + "\r\n");
                    if ((Integer)this.insertCommitSP.getValue() <= 0 || ++n < (Integer)this.insertCommitSP.getValue()) continue;
                    this.writer.write("commit;\r\n");
                    n = 0;
                }
                resultSet.close();
                this.writer.write("commit;\r\n");
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Dump Data");
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "Dump Data");
            }
        }
    }

    private void createSynonyms() {
        String string = "";
        String string2 = "select sname, sowner, screator, ispublic, sremdb from admin.syssynonyms where stblowner = '" + this.objectOwner + "' and stbl = '" + this.objectName + "' order by sname";
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string2);
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    string = "\r\ncreate ";
                    String string3 = resultSet.getString(4);
                    if (string3.equals("1")) {
                        string = string + "public ";
                    }
                    string = string + "synonym ";
                    String string4 = resultSet.getString(1);
                    string = string + "\"" + this.objectOwner + "\".\"" + string4 + "\"";
                    string = string + " for \"" + this.objectOwner + "\".\"" + this.objectName + "\";";
                    this.writer.write(string);
                }
                resultSet.close();
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Create Synonyms");
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "Create Synonyms");
            }
        }
    }

    private void createFK() {
        String string = "alter table \"" + this.objectOwner + "\".\"" + this.objectName + "\" add ";
        String string2 = "select cnstrname, idxname from admin.sys_tbl_constrs where owner = '" + this.objectOwner + "' and tblname = '" + this.objectName + "' and cnstrtype = 'F'";
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string2);
        boolean bl = true;
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    this.constraintNames.add(resultSet.getString(2));
                    string = "\r\nalter table \"" + this.objectOwner + "\".\"" + this.objectName + "\" add ";
                    string = string + "constraint " + string3 + " ";
                    string = string + "foreign key (";
                    string2 = "select colname from admin.sys_keycol_usage where owner = '" + this.objectOwner + "' and tblname = '" + this.objectName + "' and cnstrname ='" + string3 + "' order by colposition";
                    ResultSet resultSet2 = Globals.currentSqlConnection.execRsQuery(string2);
                    bl = true;
                    if (resultSet2 != null) {
                        while (resultSet2.next()) {
                            if (bl) {
                                bl = false;
                            } else {
                                string = string + ", ";
                            }
                            string = string + "\"" + resultSet2.getString(1) + "\"";
                        }
                        resultSet2.close();
                    }
                    string = string + ")";
                    string2 = "select refowner,refcnstrname,reftblname from admin.sys_ref_constrs where owner = '" + this.objectOwner + "' and tblname = '" + this.objectName + "' and cnstrname ='" + string3 + "'";
                    resultSet2 = Globals.currentSqlConnection.execRsQuery(string2);
                    String string4 = "";
                    String string5 = "";
                    String string6 = "";
                    if (resultSet2 != null) {
                        resultSet2.next();
                        string5 = resultSet2.getString(1);
                        string6 = resultSet2.getString(2);
                        string4 = resultSet2.getString(3);
                        resultSet2.close();
                    }
                    string = string + " references \"" + string5 + "\".\"" + string4 + "\"";
                    string2 = "select colname from admin.sys_keycol_usage where owner = '" + string5 + "' and tblname = '" + string4 + "' and cnstrname ='" + string6 + "' order by colposition";
                    resultSet2 = Globals.currentSqlConnection.execRsQuery(string2);
                    bl = true;
                    if (resultSet2 != null) {
                        while (resultSet2.next()) {
                            if (bl) {
                                string = string + " (\"";
                                bl = false;
                            } else {
                                string = string + "\",\" ";
                            }
                            string = string + resultSet2.getString(1);
                        }
                        if (!bl) {
                            string = string + "\")";
                        }
                        resultSet2.close();
                    }
                    string = string + ";";
                    this.writer.write(string);
                }
                resultSet.close();
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Create FK");
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "Create FK");
            }
        }
    }

    private void createProcedures() {
        Integer n = 0;
        Boolean bl = true;
        for (String string : this.objects) {
            this.objectTypeLabel.setText("Procedure");
            this.objectLabel.setText(string);
            this.objectName = string;
            this.objectLabel.repaint();
            this.objectLabel.invalidate();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(ExportSchema.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            String string2 = "";
            String string3 = "";
            String string4 = "SP";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            String string10 = "";
            String string11 = "";
            if (this.objectType == TREE_OBJECT.UPROCEDURE || this.objectType == TREE_OBJECT.UPROCEDURES) {
                string2 = "CREATE PROCEDURE \"" + this.objectOwner + "\".\"" + this.objectName + "\" (";
                string3 = "select rssid, proc_id from admin.sysprocedures where proc_type = 'stored' and proc_name ='" + this.objectName + "' and owner ='" + this.objectOwner + "'";
            } else if (this.objectType == TREE_OBJECT.UDF || this.objectType == TREE_OBJECT.UDFS) {
                string2 = "CREATE FUNCTION \"" + this.objectOwner + "\".\"" + this.objectName + "\" (";
                string3 = "select rssid, proc_id from admin.sysprocedures where proc_type = 'udf' and proc_name ='" + this.objectName + "' and owner ='" + this.objectOwner + "'";
            } else if (this.objectType == TREE_OBJECT.TRIGGER || this.objectType == TREE_OBJECT.TRIGGERS) {
                string2 = "CREATE TRIGGER \"" + this.objectOwner + "\".\"" + this.objectName + "\"\r\n";
                string3 = "select rssid, triggerid, tbl, tblowner, trigger_time, trigger_event, refers_to_old, refers_to_new, statement_or_row from admin.systrigger where triggername = '" + this.objectName + "' and owner = '" + this.objectOwner + "'";
                string4 = "TP";
            }
            this.setWriter(string, n, bl, false);
            bl = false;
            Object object = n;
            n = n + 1;
            Object object2 = n;
            object = "";
            object2 = "";
            ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string3);
            try {
                String string12;
                this.writer.write(string2);
                if (resultSet != null) {
                    while (resultSet.next()) {
                        object = resultSet.getString(1);
                        object2 = resultSet.getString(2);
                        if (this.objectType != TREE_OBJECT.TRIGGER && this.objectType != TREE_OBJECT.TRIGGERS) continue;
                        string5 = resultSet.getString(3);
                        string6 = resultSet.getString(4);
                        string7 = resultSet.getString(5);
                        string8 = resultSet.getString(6);
                        string9 = resultSet.getString(7);
                        string10 = resultSet.getString(8);
                        string11 = resultSet.getString(9);
                    }
                    resultSet.close();
                }
                if (this.objectType == TREE_OBJECT.TRIGGER || this.objectType == TREE_OBJECT.TRIGGERS) {
                    string2 = string7.equals("B") ? "\tBEFORE " : "\tAFTER ";
                    boolean bl2 = false;
                    if (string8.equals("I")) {
                        string2 = string2 + "INSERT ";
                    } else if (string8.equals("U")) {
                        string2 = string2 + "UPDATE ";
                        bl2 = true;
                    } else {
                        string2 = string8.equals("D") ? string2 + "DELETE " : string2 + "\n-- the event of the trigger is not valid";
                    }
                    if (bl2) {
                        string12 = "";
                        String string13 = "";
                        string3 = "select count(*) from admin.systrigcols where triggername = '" + this.objectName + "' and owner = '" + this.objectOwner + "'";
                        resultSet = null;
                        resultSet = Globals.currentSqlConnection.execRsQuery(string3);
                        if (resultSet != null) {
                            if (resultSet.next()) {
                                string12 = resultSet.getString(1);
                            }
                            resultSet.close();
                        }
                        string3 = "select count(*) from admin.syscolumns where tbl = '" + string5 + "' and owner = '" + string6 + "'";
                        resultSet = null;
                        resultSet = Globals.currentSqlConnection.execRsQuery(string3);
                        if (resultSet != null) {
                            if (resultSet.next()) {
                                string13 = resultSet.getString(1);
                            }
                            resultSet.close();
                        }
                        if (!string12.equals(string13)) {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            string2 = string2 + "OF (";
                            string3 = "select colid from admin.systrigcols where triggername = '" + this.objectName + "' and owner = '" + this.objectOwner + "'";
                            resultSet = null;
                            resultSet = Globals.currentSqlConnection.execRsQuery(string3);
                            if (resultSet != null) {
                                while (resultSet.next()) {
                                    arrayList.add(resultSet.getString(1));
                                }
                                resultSet.close();
                            }
                            String string14 = "";
                            String string15 = "";
                            string3 = "select col, id from admin.syscolumns where tbl = '" + string5 + "' and owner = '" + string6 + "' order by id";
                            resultSet = null;
                            resultSet = Globals.currentSqlConnection.execRsQuery(string3);
                            boolean bl3 = true;
                            if (resultSet != null) {
                                while (resultSet.next()) {
                                    string15 = resultSet.getString(1);
                                    string14 = resultSet.getString(2);
                                    for (String string16 : arrayList) {
                                        if (!string16.equals(string14)) continue;
                                        if (bl3) {
                                            bl3 = false;
                                        } else {
                                            string2 = string2 + ", ";
                                        }
                                        string2 = string2 + "\"" + string15 + "\"";
                                    }
                                }
                                resultSet.close();
                            }
                            string2 = string2 + ")";
                        }
                    }
                    string2 = string2 + "\r\n\tON \"" + string6 + "\".\"" + string5 + "\"";
                    if (string10.equals("Y") || string9.equals("Y")) {
                        string2 = string2 + "\r\n\tREFERENCING ";
                        if (string10.equals("Y")) {
                            string2 = string2 + "NEWROW";
                        }
                        if (string10.equals("Y") && string9.equals("Y")) {
                            string2 = string2 + ", ";
                        }
                        if (string9.equals("Y")) {
                            string2 = string2 + "OLDROW";
                        }
                    }
                    string2 = string2 + "\r\n\tFOR EACH ";
                    string2 = string11.equals("R") ? string2 + "ROW" : string2 + "STATEMENT";
                    this.writer.write(string2 + "\r\n");
                } else {
                    this.createProcColumns((String)object, (String)object2);
                }
                string3 = "select proc_text from admin.sysproctext where proc_type = '" + string4 + "' and id = " + (String)object2 + " and rssId = " + (String)object + "order by seq";
                resultSet = null;
                resultSet = Globals.currentSqlConnection.execRsQuery(string3);
                if (resultSet != null) {
                    resultSet.next();
                    if (!resultSet.getString(1).isEmpty()) {
                        this.writer.write("IMPORT\r\n");
                        this.writer.write(resultSet.getString(1) + "\r\n");
                    }
                    this.writer.write("BEGIN\r\n");
                    while (resultSet.next()) {
                        string2 = resultSet.getString(1);
                    }
                    this.writer.write(string2 + "\r\n");
                    this.writer.write("END\r\n");
                    resultSet.close();
                }
                if (this.exportPermsCB.isSelected()) {
                    string3 = "select grantee, exe from admin.systabauth where tbl = '" + this.objectName + "' and tblOwner = '" + this.objectOwner + "' and grantee != '" + this.objectOwner + "' and (exe = 'y' or exe = 'g')";
                    resultSet = null;
                    resultSet = Globals.currentSqlConnection.execRsQuery(string3);
                    String string17 = "";
                    string12 = "";
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            string17 = resultSet.getString(1);
                            string12 = resultSet.getString(2);
                            string2 = "\r\nGRANT EXECUTE ON \"" + this.objectOwner + "\".\"" + this.objectName + "\" TO " + string17;
                            if (string12.equals("g")) {
                                string2 = string2 + " WITH GRANT OPTION";
                            }
                            string2 = string2 + ";";
                            this.writer.write(string2 + "\r\n");
                        }
                        resultSet.close();
                    }
                }
                this.writer.write("\r\n");
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "Export Schema");
                return;
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Export Schema");
                return;
            }
        }
    }

    private void createProcColumns(String string, String string2) {
        String string3 = null;
        String string4 = "select argtype, col, datatype, width, scale from admin.sysproccolumns where proc_id ='" + string2 + "' and rssid ='" + string + "' order by id";
        ArrayList<ColumnSchema> arrayList = new ArrayList<ColumnSchema>();
        ArrayList<ColumnSchema> arrayList2 = new ArrayList<ColumnSchema>();
        ArrayList<ColumnSchema> arrayList3 = new ArrayList<ColumnSchema>();
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string4);
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    ColumnSchema columnSchema = new ColumnSchema();
                    columnSchema.ArgType = resultSet.getString(1);
                    columnSchema.ColumnName = resultSet.getString(2);
                    columnSchema.ColumnType = resultSet.getString(3);
                    columnSchema.Length = resultSet.getInt(4);
                    columnSchema.Scale = resultSet.getInt(5);
                    if (columnSchema.ArgType.equals("result")) {
                        arrayList2.add(columnSchema);
                        continue;
                    }
                    if (columnSchema.ArgType.equals("udf_return")) {
                        arrayList3.add(columnSchema);
                        continue;
                    }
                    arrayList.add(columnSchema);
                }
                resultSet.close();
                int n = 0;
                if (arrayList.size() > 0) {
                    for (ColumnSchema columnSchema : arrayList) {
                        string3 = "\r\n";
                        string3 = string3 + this.writecolumn(columnSchema, true, true);
                        string3 = ++n < arrayList.size() ? string3 + "," : string3 + "\r\n)";
                        this.writer.write(string3);
                    }
                    this.writer.write("\r\n");
                } else {
                    this.writer.write(")\r\n");
                }
                n = 0;
                if (arrayList2.size() > 0) {
                    this.writer.write("RESULT (");
                    for (ColumnSchema columnSchema : arrayList2) {
                        string3 = "\r\n";
                        string3 = string3 + this.writecolumn(columnSchema, false, true);
                        string3 = ++n < arrayList2.size() ? string3 + "," : string3 + "\r\n)";
                        this.writer.write(string3);
                    }
                    this.writer.write("\r\n");
                }
                if (arrayList3.size() > 0) {
                    this.writer.write("RETURNS ");
                    for (ColumnSchema columnSchema : arrayList3) {
                        string3 = this.writecolumn(columnSchema, false, false);
                        this.writer.write(string3 + "\r\n");
                    }
                }
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "Export Schema");
                return;
            }
            catch (IOException iOException) {
                Globals.showException(iOException, "Export Schema");
                return;
            }
        }
    }

    private String writecolumn(ColumnSchema columnSchema, boolean bl, boolean bl2) {
        String string = "";
        if (bl) {
            string = "\t" + columnSchema.ArgType.toUpperCase();
        }
        if (bl2) {
            string = string + "\t\"" + columnSchema.ColumnName + "\"";
        }
        string = columnSchema.ColumnType.equals("double") ? string + " double precision" : string + " " + columnSchema.ColumnType;
        if (columnSchema.ColumnType.equals("character") || columnSchema.ColumnType.equals("nchar") || columnSchema.ColumnType.equals("varchar") || columnSchema.ColumnType.equals("national varchar") || columnSchema.ColumnType.equals("binary") || columnSchema.ColumnType.equals("varbinary") || columnSchema.ColumnType.equals("float") || columnSchema.ColumnType.equals("numeric") || columnSchema.ColumnType.equals("decimal")) {
            string = string + " (" + columnSchema.Length.toString();
            if (columnSchema.Scale > 0) {
                string = string + "," + columnSchema.Scale.toString();
            }
            string = string + ")";
        }
        if (columnSchema.ColumnType.equals("money")) {
            string = string + " (" + columnSchema.Length.toString() + ")";
        }
        return string;
    }

    private void setPermissions() {
        String string = "select grantee, sel, ins, del, upd, ndx, alt from admin.systabauth where tbl = '" + this.objectName + "'" + "and tblowner = '" + this.objectOwner + "' order by grantee";
        ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string);
        try {
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    String string3 = resultSet.getString(2);
                    String string4 = resultSet.getString(3);
                    String string5 = resultSet.getString(4);
                    String string6 = resultSet.getString(5);
                    String string7 = resultSet.getString(6);
                    String string8 = resultSet.getString(7);
                    if (string2.toLowerCase().equals("admin") || string2.toLowerCase().equals(this.objectOwner.toLowerCase())) continue;
                    if (string3.equals("y")) {
                        this.writer.write("\r\nGRANT SELECT ON \"" + this.objectOwner + "\".\"" + this.objectName + "\" TO " + string2 + ";");
                    } else if (string3.equals("g")) {
                        this.writer.write("\r\nGRANT SELECT ON \"" + this.objectOwner + "\".\"" + this.objectName + "\" TO " + string2 + " WITH GRANT OPTION;");
                    }
                    if (string4.equals("y")) {
                        this.writer.write("\r\nGRANT INSERT ON \"" + this.objectOwner + "\".\"" + this.objectName + "\" TO " + string2 + ";");
                    } else if (string4.equals("g")) {
                        this.writer.write("\r\nGRANT INSERT ON \"" + this.objectOwner + "\".\"" + this.objectName + "\" TO " + string2 + " WITH GRANT OPTION;");
                    }
                    if (string5.equals("y")) {
                        this.writer.write("\r\nGRANT DELETE ON \"" + this.objectOwner + "\".\"" + this.objectName + "\" TO " + string2 + ";");
                    } else if (string5.equals("g")) {
                        this.writer.write("\r\nGRANT DELETE ON \"" + this.objectOwner + "\".\"" + this.objectName + "\" TO " + string2 + " WITH GRANT OPTION;");
                    }
                    if (string6.equals("y")) {
                        this.writer.write("\nGRANT UPDATE ON \"" + this.objectOwner + "\".\"" + this.objectName + "\" TO " + string2 + ";");
                    } else if (string6.equals("g")) {
                        this.writer.write("\nGRANT UPDATE ON \"" + this.objectOwner + "\".\"" + this.objectName + "\" TO " + string2 + " WITH GRANT OPTION;");
                    }
                    if (string7.equals("y")) {
                        this.writer.write("\r\nGRANT INDEX ON \"" + this.objectOwner + "\".\"" + this.objectName + "\" TO " + string2 + ";");
                    } else if (string7.equals("g")) {
                        this.writer.write("\r\nGRANT INDEX ON \"" + this.objectOwner + "\".\"" + this.objectName + "\" TO " + string2 + " WITH GRANT OPTION;");
                    }
                    if (string8.equals("y")) {
                        this.writer.write("\nGRANT ALTER ON \"" + this.objectOwner + "\".\"" + this.objectName + "\" TO " + string2 + ";");
                        continue;
                    }
                    if (!string8.equals("g")) continue;
                    this.writer.write("\r\nGRANT ALTER ON \"" + this.objectOwner + "\".\"" + this.objectName + "\" TO " + string2 + " WITH GRANT OPTION;");
                }
                resultSet.close();
            }
        }
        catch (IOException iOException) {
            Globals.showException(iOException, "Create Permissions");
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "Create Permissions");
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void oneFileCBStateChanged(ChangeEvent changeEvent) {
        this.appendCB.setEnabled(!this.oneFileCB.isSelected());
    }

    private void browseBTNActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        if (this.useObjectNameCB.isSelected()) {
            if (directoryName == null) {
                directoryName = Globals.execDir;
            }
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setCurrentDirectory(new File(directoryName));
            int n = jFileChooser.showSaveDialog(this.mainFrame);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                directoryName = file.getAbsolutePath();
                this.fileNameTB.setText(directoryName);
            }
        } else {
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("script files (*.sql)", "sql");
            jFileChooser.setFileFilter(fileNameExtensionFilter);
            if (fileName == null) {
                fileName = Globals.execDir;
            }
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setCurrentDirectory(new File(fileName));
            int n = jFileChooser.showSaveDialog(this.mainFrame);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                fileName = file.getAbsolutePath();
                this.fileNameTB.setText(fileName);
            }
        }
    }

    private void useObjectNameCBItemStateChanged(ItemEvent itemEvent) {
        if (this.useObjectNameCB.isSelected()) {
            this.fileLabel.setText("Output Directory :");
            this.fileNameTB.setText(directoryName);
            this.appendCB.setSelected(false);
            this.appendCB.setEnabled(false);
        } else {
            this.fileLabel.setText("Output File :");
            this.fileNameTB.setText(fileName);
            this.appendCB.setEnabled(true);
        }
        this.oneFileCB.setEnabled(false);
        this.oneFileCB.setSelected(false);
        if (this.multi) {
            this.oneFileCB.setEnabled(!this.useObjectNameCB.isSelected());
            this.oneFileCB.setSelected(this.useObjectNameCB.isSelected());
        }
    }

    public class ColumnSchema {
        public String ColumnName;
        public String ColumnType;
        public boolean IsNullable;
        public boolean IsIdentity;
        public String ArgType;
        public Integer Length;
        public Integer Precision;
        public Integer Scale;
        public Integer IdentitySeed;
        public Integer IdentityIncrement;
    }

    public class RunSomeTask
    implements Runnable {
        @Override
        public void run() {
            switch (ExportSchema.this.objectType) {
                case TABLE: 
                case TABLE_RTG: 
                case TABLE_LINKED: 
                case TABLES: {
                    ExportSchema.this.createTables();
                    break;
                }
                case VIEW: 
                case VIEWS: {
                    ExportSchema.this.createViews();
                    break;
                }
                case UPROCEDURE: 
                case UDF: 
                case TRIGGER: 
                case UPROCEDURES: 
                case UDFS: 
                case TRIGGERS: {
                    ExportSchema.this.createProcedures();
                }
            }
            ExportSchema.this.objectTypeLabel.setText("Export Completed");
            ExportSchema.this.objectLabel.setText("");
            if (ExportSchema.this.writer != null) {
                try {
                    ExportSchema.this.writer.close();
                }
                catch (IOException iOException) {
                    Globals.showException(iOException, "Export Schema");
                }
                ExportSchema.this.writer = null;
            }
            ExportSchema.this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

