/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.CtreeACEExplorerView;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.ImportScriptDialog;
import ctreeaceexplorer.ImportTree;
import ctreeaceexplorer.MyTreeNode;
import ctreeaceexplorer.TAB_PAGES;
import ctreeaceexplorer.TREE_OBJECT;
import ctreeaceexplorer.Warnings;
import ctreeaceexplorer.sql.CtreeACEDestServer;
import ctreeaceexplorer.sql.CtreeACESourceServer;
import ctreeaceexplorer.sql.ForeignServer;
import ctreeaceexplorer.sql.MsSqlServer;
import ctreeaceexplorer.sql.MySQLServer;
import ctreeaceexplorer.sql.OracleServer;
import ctreeaceexplorer.sql.ScriptsPane;
import ctreeaceexplorer.sql.SqlConnection;
import ctreeaceexplorer.sql.SqlTree;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Import {
    private CtreeACEExplorerView appFrame;
    private ImportTree theTree;
    private ForeignServer sourceServer;
    private StringBuilder warnings;
    private CtreeACEDestServer destinationServer;
    private boolean stopConversion;
    private boolean createScript = false;
    private boolean openScript = false;
    private BufferedWriter writer = null;
    private String writerFilename;
    private boolean intSec = false;

    public Import(CtreeACEExplorerView ctreeACEExplorerView, ImportTree importTree) {
        this.appFrame = ctreeACEExplorerView;
        this.theTree = importTree;
    }

    public void setServers(SqlTree sqlTree) {
        this.appFrame.importDestServerCB.removeAllItems();
        MyTreeNode myTreeNode = (MyTreeNode)sqlTree.getModel().getRoot();
        if (myTreeNode.getChildCount() >= 0) {
            boolean bl = true;
            Enumeration<TreeNode> enumeration = myTreeNode.children();
            while (enumeration.hasMoreElements()) {
                MyTreeNode myTreeNode2 = (MyTreeNode)enumeration.nextElement();
                this.appFrame.importDestServerCB.addItem(myTreeNode2.name);
                if (!bl) continue;
                bl = false;
                this.setDatabases(sqlTree, myTreeNode2.name);
            }
        }
    }

    public void setDatabases(SqlTree sqlTree, String string) {
        this.appFrame.importDatabasesCB.removeAllItems();
        MyTreeNode myTreeNode = (MyTreeNode)sqlTree.getModel().getRoot();
        if (myTreeNode.getChildCount() >= 0) {
            boolean bl = true;
            Enumeration<TreeNode> enumeration = myTreeNode.children();
            while (enumeration.hasMoreElements()) {
                MyTreeNode myTreeNode2 = (MyTreeNode)enumeration.nextElement();
                if (!myTreeNode2.name.equals(string)) continue;
                this.appFrame.importDatabasesCB.addItem("Source Database");
                Enumeration<TreeNode> enumeration2 = myTreeNode2.children();
                while (enumeration2.hasMoreElements()) {
                    myTreeNode2 = (MyTreeNode)enumeration2.nextElement();
                    this.appFrame.importDatabasesCB.addItem(myTreeNode2.name);
                    if (!bl) continue;
                    bl = false;
                    this.setUsers(sqlTree, string, myTreeNode2.name);
                }
                break block0;
            }
        }
    }

    public void setUsers(SqlTree sqlTree, String string, String string2) {
        this.appFrame.importTableOwnerCB.removeAllItems();
        ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(TREE_OBJECT.USER);
        if (this.appFrame.sourceServerCB.getSelectedIndex() == ForeignServer.ServerType.CTREEACE.ordinal()) {
            this.appFrame.importTableOwnerCB.addItem("Source Owner");
        }
        for (String string3 : arrayList) {
            this.appFrame.importTableOwnerCB.addItem(string3);
        }
    }

    void setOwnerCB() {
        int n = this.appFrame.importTableOwnerCB.getItemCount();
        if (n > 0) {
            if (this.appFrame.sourceServerCB.getSelectedIndex() == ForeignServer.ServerType.MSSQL.ordinal() || this.appFrame.sourceServerCB.getSelectedIndex() == ForeignServer.ServerType.MYSQL.ordinal() || this.appFrame.sourceServerCB.getSelectedIndex() == ForeignServer.ServerType.ORACLE.ordinal()) {
                for (int i = 0; i < n; ++i) {
                    if (!this.appFrame.importTableOwnerCB.getItemAt(i).equals("Source Owner")) continue;
                    this.appFrame.importTableOwnerCB.removeItemAt(i);
                    break;
                }
                if (this.appFrame.importTableOwnerCB.getItemCount() > 0) {
                    this.appFrame.importTableOwnerCB.setSelectedIndex(0);
                }
            } else if (this.appFrame.sourceServerCB.getSelectedIndex() == ForeignServer.ServerType.CTREEACE.ordinal()) {
                boolean bl = false;
                for (int i = 0; i < n; ++i) {
                    if (!this.appFrame.importTableOwnerCB.getItemAt(i).equals("Source Owner")) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.appFrame.importTableOwnerCB.insertItemAt("Source Owner", 0);
                }
                if (this.appFrame.importTableOwnerCB.getItemCount() > 0) {
                    this.appFrame.importTableOwnerCB.setSelectedIndex(0);
                }
            }
        }
    }

    public ForeignServer getSourceServer() {
        return this.sourceServer;
    }

    public void setSourceServer(int n) {
        if (n == ForeignServer.ServerType.CTREEACE.ordinal()) {
            this.appFrame.importSynCB.setSelected(true);
            this.appFrame.importSynCB.setEnabled(true);
            this.appFrame.connectToSourceServerBT.setEnabled(false);
            this.appFrame.serverAddressTB.setText("localhost");
        } else if (n == ForeignServer.ServerType.MSSQL.ordinal()) {
            this.appFrame.importSynCB.setSelected(true);
            this.appFrame.importSynCB.setEnabled(true);
            this.appFrame.connectToSourceServerBT.setEnabled(true);
            this.appFrame.serverAddressTB.setText("localhost\\SQLEXPRESS");
        } else if (n == ForeignServer.ServerType.MYSQL.ordinal()) {
            this.appFrame.importSynCB.setSelected(false);
            this.appFrame.importSynCB.setEnabled(false);
            this.appFrame.connectToSourceServerBT.setEnabled(false);
            this.appFrame.serverAddressTB.setText("localhost");
        } else if (n == ForeignServer.ServerType.ORACLE.ordinal()) {
            this.appFrame.importSynCB.setSelected(true);
            this.appFrame.importSynCB.setEnabled(true);
            this.appFrame.connectToSourceServerBT.setEnabled(false);
            this.appFrame.serverAddressTB.setText("localhost");
        }
        this.setOwnerCB();
    }

    public void connect(int n) {
        this.intSec = false;
        this.setOwnerCB();
        if (this.sourceServer != null) {
            this.sourceServer.disconnect();
            this.sourceServer = null;
        }
        if (n == ForeignServer.ServerType.MSSQL.ordinal()) {
            this.sourceServer = new MsSqlServer();
        }
        if (this.sourceServer != null) {
            boolean bl = this.sourceServer.connect(this.appFrame.serverAddressTB.getText(), "", false);
            this.theTree.clear();
            if (bl) {
                this.appFrame.importStartBT.setEnabled(true);
                this.addServerToTree();
            }
        }
    }

    public void connectExt(int n) {
        this.intSec = true;
        this.setOwnerCB();
        if (this.sourceServer != null) {
            this.sourceServer.disconnect();
            this.sourceServer = null;
        }
        if (n == ForeignServer.ServerType.CTREEACE.ordinal()) {
            this.sourceServer = new CtreeACESourceServer();
        } else if (n == ForeignServer.ServerType.MSSQL.ordinal()) {
            this.sourceServer = new MsSqlServer();
        } else if (n == ForeignServer.ServerType.MYSQL.ordinal()) {
            this.sourceServer = new MySQLServer();
        } else if (n == ForeignServer.ServerType.ORACLE.ordinal()) {
            this.sourceServer = new OracleServer();
        }
        if (this.sourceServer != null) {
            boolean bl = this.sourceServer.connect(this.appFrame.serverAddressTB.getText(), "ctreeSQL", true);
            this.theTree.clear();
            if (bl) {
                this.appFrame.importStartBT.setEnabled(true);
                this.addServerToTree();
            }
        }
    }

    private void addServerToTree() {
        MyTreeNode myTreeNode = new MyTreeNode(this.sourceServer.getServerId(), TREE_OBJECT.SERVER, false, this.theTree);
        MyTreeNode myTreeNode2 = this.theTree.addObject(null, myTreeNode);
        ArrayList<String> arrayList = this.sourceServer.readObjects(TREE_OBJECT.DATABASE);
        for (String string : arrayList) {
            MyTreeNode myTreeNode3 = new MyTreeNode(string, TREE_OBJECT.DATABASE, true, this.theTree);
            this.theTree.addObject(myTreeNode2, myTreeNode3);
        }
        this.theTree.expandNode();
        this.theTree.expandNode(myTreeNode2);
        this.theTree.setSelectionPath(new TreePath(myTreeNode2.getPath()));
    }

    public void start() {
        Globals.currentSqlConnection.commit();
        if (this.sourceServer == null) {
            return;
        }
        this.warnings = new StringBuilder();
        this.stopConversion = false;
        this.sourceServer.stopConversion(false);
        this.setControls(false);
        this.appFrame.objNameLabel.setText("  ");
        MyTreeNode myTreeNode = (MyTreeNode)this.theTree.getModel().getRoot();
        if (myTreeNode.getChildCount() > 0) {
            Thread thread = new Thread(new RunSomeTask());
            thread.start();
        }
    }

    public void stop() {
        this.stopConversion = true;
        this.sourceServer.stopConversion(true);
    }

    private void setControls(boolean bl) {
        Component[] componentArray;
        for (Component component : componentArray = this.appFrame.databasePanel.getComponents()) {
            component.setEnabled(bl);
        }
        for (Component component : componentArray = this.appFrame.tablesPanel.getComponents()) {
            component.setEnabled(bl);
        }
        this.appFrame.importTableOwnerLabel.setEnabled(bl);
        this.appFrame.importTableOwnerCB.setEnabled(bl);
        this.appFrame.importStartBT.setEnabled(bl);
        this.appFrame.importStopBT.setEnabled(!bl);
    }

    private void close() {
        if (this.sourceServer != null) {
            this.sourceServer.disconnect();
        }
        if (this.createScript && this.writer != null) {
            try {
                this.writer.newLine();
                this.writer.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(Import.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    private boolean checkNodes(MyTreeNode myTreeNode) {
        boolean bl = false;
        Enumeration<TreeNode> enumeration = myTreeNode.children();
        block0: while (enumeration.hasMoreElements()) {
            MyTreeNode myTreeNode2 = (MyTreeNode)enumeration.nextElement();
            Enumeration<TreeNode> enumeration2 = myTreeNode2.children();
            while (enumeration2.hasMoreElements()) {
                MyTreeNode myTreeNode3 = (MyTreeNode)enumeration2.nextElement();
                if (!myTreeNode3.isChecked()) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    private void importObjects() throws IOException {
        Serializable serializable;
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        MyTreeNode myTreeNode = (MyTreeNode)this.theTree.getModel().getRoot();
        this.createScript = this.appFrame.createScriptCB.isSelected();
        MyTreeNode myTreeNode2 = (MyTreeNode)myTreeNode.getChildAt(0);
        this.writer = null;
        this.openScript = false;
        if (this.createScript) {
            object = CtreeACEExplorerApp.getApplication().getMainFrame();
            serializable = new ImportScriptDialog((Frame)object, true);
            ((Window)serializable).setLocationRelativeTo((Component)object);
            if (!((ImportScriptDialog)serializable).showDialog()) {
                return;
            }
            this.writer = ((ImportScriptDialog)serializable).getWriter();
            this.openScript = ((ImportScriptDialog)serializable).getOpenScript();
            this.writerFilename = ((ImportScriptDialog)serializable).getWriterFilename();
        }
        object = myTreeNode2.children();
        while (object.hasMoreElements()) {
            Object object2;
            Object object3;
            Iterator<Object> iterator;
            Object object42;
            serializable = (MyTreeNode)object.nextElement();
            bl = this.checkNodes((MyTreeNode)serializable);
            if (!bl) continue;
            bl3 = true;
            if (!this.sourceServer.isConnected() || !this.sourceServer.getCurrentDb().equals(((MyTreeNode)serializable).name)) {
                this.sourceServer.disconnect();
                this.sourceServer.changeDb(((MyTreeNode)serializable).name);
                this.sourceServer.connect(this.appFrame.serverAddressTB.getText(), ((MyTreeNode)serializable).name, this.intSec);
            }
            if (this.stopConversion) {
                this.close();
                return;
            }
            String string = this.appFrame.importDatabasesCB.getSelectedItem().toString();
            if (string.equals("Source Database")) {
                string = ((MyTreeNode)serializable).name;
            }
            String string2 = this.appFrame.importDestServerCB.getSelectedItem().toString();
            SqlConnection sqlConnection = null;
            for (Object object42 : Globals.sqlConnections) {
                if (!object42.getServerId().equals(string2)) continue;
                if (!object42.isConnected()) {
                    Globals.showMessage("No connection has been made to the destination server.\n\nPlease connect before continuing.", "Convert / Import");
                    return;
                }
                sqlConnection = object42;
                break;
            }
            if (sqlConnection != null) {
                if (!bl2 && this.appFrame.createDbCB.isSelected() && this.writer == null) {
                    this.createDb(sqlConnection, string);
                    sqlConnection.commit();
                    bl2 = true;
                }
                this.destinationServer = new CtreeACEDestServer(sqlConnection, string, this.appFrame.importTableOwnerCB.getSelectedItem().toString(), this.appFrame.importStopOnErrorsCB.isSelected(), this.appFrame.importConvertToLowerCB.isSelected());
            }
            if (this.stopConversion || !this.destinationServer.conn.isConnected()) {
                this.close();
                return;
            }
            if (this.writer != null) {
                this.writer.write("-- WARNING: Connect to " + string + " database before running this script");
                this.writer.newLine();
                this.writer.newLine();
            }
            object42 = new ArrayList();
            if (this.appFrame.importTablesCB.isSelected()) {
                Object object5;
                if (((DefaultMutableTreeNode)serializable).getChildCount() > 0) {
                    MyTreeNode myTreeNode3 = (MyTreeNode)((DefaultMutableTreeNode)serializable).getChildAt(0);
                    this.appFrame.importProgressBar.setMaximum(myTreeNode3.getChildCount());
                    this.appFrame.importProgressBar.setValue(0);
                    int n = 1;
                    object5 = myTreeNode3.children();
                    while (object5.hasMoreElements()) {
                        this.appFrame.importProgressBar.setValue(n++);
                        MyTreeNode myTreeNode4 = (MyTreeNode)object5.nextElement();
                        if (!myTreeNode4.isChecked()) continue;
                        ForeignServer.TableSchema tableSchema = this.sourceServer.createTableSchema(myTreeNode4.name, this.destinationServer.isUnicodeServer());
                        if (!tableSchema.IsValid) continue;
                        ((ArrayList)object42).add(tableSchema);
                    }
                }
                this.appFrame.importProgressBar.setMaximum(((ArrayList)object42).size());
                this.appFrame.importProgressBar.setValue(0);
                int n = 1;
                iterator = ((ArrayList)object42).iterator();
                while (iterator.hasNext()) {
                    boolean bl4;
                    object5 = (ForeignServer.TableSchema)iterator.next();
                    if (this.stopConversion) {
                        this.close();
                        return;
                    }
                    this.appFrame.importProgressBar.setValue(n++);
                    if (!this.appFrame.createTableCB.isSelected() || (bl4 = this.destinationServer.addCtreeACETable((ForeignServer.TableSchema)object5, this.writer))) continue;
                    this.close();
                    return;
                }
                n = 1;
                iterator = ((ArrayList)object42).iterator();
                while (iterator.hasNext()) {
                    Object object6;
                    object5 = (ForeignServer.TableSchema)iterator.next();
                    if (this.stopConversion) {
                        this.close();
                    }
                    this.appFrame.importProgressBar.setValue(n++);
                    if (!this.appFrame.copyRowsCB.isSelected() || ((ForeignServer.TableSchema)object5).CreationFailed) continue;
                    this.appFrame.objNameLabel.setText("Copying rows for Table " + ((ForeignServer.TableSchema)object5).TableName + " ...");
                    if (this.writer != null) {
                        object6 = this.destinationServer.buildInsertText((ForeignServer.TableSchema)object5);
                        this.sourceServer.copyRows((String)object6, (ForeignServer.TableSchema)object5, this.destinationServer.isUnicodeServer(), this.writer);
                        continue;
                    }
                    object6 = this.destinationServer.buildInsertCommand((ForeignServer.TableSchema)object5);
                    if (object6 != null && this.sourceServer.copyRows((PreparedStatement)object6, (ForeignServer.TableSchema)object5, this.destinationServer.isUnicodeServer(), this.warnings)) continue;
                }
                n = 1;
                iterator = ((ArrayList)object42).iterator();
                while (iterator.hasNext()) {
                    object5 = (ForeignServer.TableSchema)iterator.next();
                    if (this.stopConversion) {
                        this.close();
                        return;
                    }
                    this.appFrame.importProgressBar.setValue(n++);
                    if (!this.appFrame.createPKCB.isSelected() || ((ForeignServer.TableSchema)object5).CreationFailed) continue;
                    if (!this.destinationServer.createPK((ForeignServer.TableSchema)object5, this.warnings, this.writer)) {
                        this.close();
                        return;
                    }
                    if (!this.destinationServer.createUK((ForeignServer.TableSchema)object5, this.warnings, this.writer)) {
                        this.close();
                        return;
                    }
                    if (this.destinationServer.createCheck((ForeignServer.TableSchema)object5, this.warnings, this.writer)) continue;
                    this.close();
                    return;
                }
                n = 1;
                iterator = ((ArrayList)object42).iterator();
                while (iterator.hasNext()) {
                    object5 = (ForeignServer.TableSchema)iterator.next();
                    if (this.stopConversion) {
                        this.close();
                        return;
                    }
                    this.appFrame.importProgressBar.setValue(n++);
                    if (!this.appFrame.createIndexesCB.isSelected() || ((ForeignServer.TableSchema)object5).CreationFailed || this.destinationServer.createIndexes((ForeignServer.TableSchema)object5, this.warnings, this.writer)) continue;
                    this.close();
                    return;
                }
                n = 1;
                iterator = ((ArrayList)object42).iterator();
                while (iterator.hasNext()) {
                    object5 = (ForeignServer.TableSchema)iterator.next();
                    if (this.stopConversion) {
                        this.close();
                        return;
                    }
                    this.appFrame.importProgressBar.setValue(n++);
                    if (!this.appFrame.createPKCB.isSelected() || ((ForeignServer.TableSchema)object5).CreationFailed || this.destinationServer.createFK((ForeignServer.TableSchema)object5, this.warnings, this.writer)) continue;
                    this.close();
                    return;
                }
            }
            if (this.appFrame.importViewsCB.isSelected() && ((DefaultMutableTreeNode)serializable).getChildCount() > 0) {
                MyTreeNode myTreeNode5 = (MyTreeNode)((DefaultMutableTreeNode)serializable).getChildAt(1);
                iterator = new ArrayList();
                this.appFrame.importProgressBar.setValue(0);
                int n = 1;
                Object object7 = myTreeNode5.children();
                while (object7.hasMoreElements()) {
                    this.appFrame.importProgressBar.setValue(n++);
                    object3 = (MyTreeNode)object7.nextElement();
                    if (!((MyTreeNode)object3).isChecked()) continue;
                    object2 = this.sourceServer.createViewSchema(((MyTreeNode)object3).name);
                    ((ArrayList)((Object)iterator)).add((ForeignServer.ViewSchema)object2);
                }
                n = 1;
                object7 = ((ArrayList)((Object)iterator)).iterator();
                while (object7.hasNext()) {
                    object3 = (ForeignServer.ViewSchema)object7.next();
                    if (this.stopConversion) {
                        this.close();
                        return;
                    }
                    this.appFrame.importProgressBar.setValue(n++);
                    if (this.destinationServer.createView((ForeignServer.ViewSchema)object3, this.warnings, this.writer)) continue;
                    this.close();
                    return;
                }
            }
            if (this.appFrame.importSynCB.isSelected() && ((DefaultMutableTreeNode)serializable).getChildCount() > 0) {
                MyTreeNode myTreeNode6 = (MyTreeNode)((DefaultMutableTreeNode)serializable).getChildAt(2);
                iterator = new ArrayList();
                this.appFrame.importProgressBar.setValue(0);
                int n = 1;
                Object object8 = myTreeNode6.children();
                while (object8.hasMoreElements()) {
                    this.appFrame.importProgressBar.setValue(n++);
                    object3 = (MyTreeNode)object8.nextElement();
                    if (!((MyTreeNode)object3).isChecked()) continue;
                    object2 = this.sourceServer.createSynonymSchema(((MyTreeNode)object3).name);
                    ((ArrayList)((Object)iterator)).add(object2);
                }
                n = 1;
                object8 = ((ArrayList)((Object)iterator)).iterator();
                while (object8.hasNext()) {
                    object3 = (ForeignServer.SynonymSchema)object8.next();
                    if (this.stopConversion) {
                        this.close();
                        return;
                    }
                    this.appFrame.importProgressBar.setValue(n++);
                    if (this.destinationServer.createSynonym((ForeignServer.SynonymSchema)object3, this.warnings, this.writer)) continue;
                    this.close();
                    return;
                }
            }
            this.destinationServer.disconnect();
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(ScriptsPane.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
        }
        if (bl3) {
            this.appFrame.objNameLabel.setText("Conversion finished");
        } else {
            this.appFrame.objNameLabel.setText("No checked items found - Nothing to Convert");
        }
        this.close();
    }

    private boolean createDb(SqlConnection sqlConnection, String string) {
        this.appFrame.objNameLabel.setText("Creating Database : " + string);
        try {
            sqlConnection.createDatabase(string);
            return true;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == -17019) {
                Globals.showWarningMessage("Database \"" + string + "\" already exist", "Convert / Import");
            } else {
                Globals.showException(sQLException, "Create Database");
            }
            return false;
        }
    }

    private class RunSomeTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Globals.ShowWaitCursor();
            try {
                Import.this.importObjects();
            }
            catch (Exception exception) {
                Globals.showException(exception, "Convert / Import");
            }
            finally {
                if (Import.this.destinationServer != null) {
                    Import.this.destinationServer.disconnect();
                    Import.this.destinationServer = null;
                }
                ((Import)Import.this).appFrame.importProgressBar.setValue(0);
                ((Import)Import.this).appFrame.objNameLabel.setText("Conversion finished");
                Globals.ShowNormalCursor();
                Import.this.setControls(true);
                Import.this.stopConversion = true;
                if (!Import.this.warnings.toString().isEmpty()) {
                    JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
                    Warnings warnings = new Warnings((Frame)jFrame, true);
                    warnings.setWarningText(Import.this.warnings.toString());
                    warnings.setLocationRelativeTo(jFrame);
                    warnings.showDialog(true, "");
                }
                if (Import.this.openScript) {
                    Import.this.appFrame.setSelectedPane(TAB_PAGES.SQL_SCRIPTS_VIEW);
                    if (Import.this.writerFilename != null) {
                        Import.this.appFrame.loadScript(Import.this.writerFilename, false);
                    }
                }
            }
        }
    }
}

