/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.TREE_OBJECT;
import ctreeaceexplorer.sql.ForeignServer;
import ctreeaceexplorer.sql.MsSqlServerConnect;
import ctreeaceexplorer.sql.NoJdbcDialog;
import ctreeaceexplorer.sql.OracleServer;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class MsSqlServer
implements ForeignServer {
    boolean extendedLogin;
    private String userName;
    private String userPassword;
    private String serverAddress;
    private Connection conn;
    private boolean cancelled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(String string, String string2, Boolean bl) {
        Object object;
        boolean bl2 = false;
        this.serverAddress = string;
        this.extendedLogin = bl;
        try {
            Object object2;
            if (this.conn != null && !this.conn.isClosed()) {
                boolean bl3 = true;
                return bl3;
            }
            if (bl.booleanValue()) {
                object2 = CtreeACEExplorerApp.getApplication().getMainFrame();
                object = new MsSqlServerConnect((Frame)object2, true);
                ((Window)object).setLocationRelativeTo((Component)object2);
                boolean bl4 = ((MsSqlServerConnect)object).showDialog(true);
                if (!bl4) {
                    boolean bl5 = false;
                    return bl5;
                }
                this.userName = ((MsSqlServerConnect)object).getUserName();
                this.userPassword = ((MsSqlServerConnect)object).getUserPassword();
            }
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            object2 = this.getConnectionString("master");
            Globals.ShowWaitCursor();
            this.conn = DriverManager.getConnection((String)object2);
            bl2 = true;
            return bl2;
        }
        catch (SQLException sQLException) {
            object = sQLException.getMessage();
            Globals.showMessage(this.splitException((String)object), "Connect");
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = CtreeACEExplorerApp.getApplication().getMainFrame();
            NoJdbcDialog noJdbcDialog = new NoJdbcDialog((Frame)object, "Microsoft SQL Server");
            noJdbcDialog.setLocationRelativeTo((Component)object);
            noJdbcDialog.setVisible(true);
        }
        catch (Exception exception) {
            object = exception.getMessage();
            Globals.showMessage(this.splitException((String)object), "Connect");
        }
        finally {
            Globals.ShowNormalCursor();
            return bl2;
        }
    }

    private String splitException(String string) {
        String[] stringArray = string.split("\\. ");
        string = "";
        for (String string2 : stringArray) {
            if (!string2.endsWith(".")) {
                string2 = string2 + ".";
            }
            string = string + string2 + "\r\n";
        }
        return string;
    }

    private String getConnectionString(String string) {
        String string2 = "jdbc:sqlserver://" + this.serverAddress.trim() + ";databaseName=" + string.trim();
        string2 = this.extendedLogin ? string2 + ";user=" + this.userName + ";password=" + this.userPassword : string2 + ";integratedSecurity=true;";
        return string2;
    }

    @Override
    public void disconnect() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(MsSqlServer.class.getName()).log(Level.SEVERE, null, sQLException);
            }
        }
    }

    @Override
    public String getServerId() {
        return this.serverAddress;
    }

    @Override
    public boolean changeDb(String string) {
        String string2 = this.getConnectionString(string);
        try {
            this.conn = DriverManager.getConnection(string2);
            return true;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(MsSqlServer.class.getName()).log(Level.SEVERE, null, sQLException);
            return false;
        }
    }

    @Override
    public ArrayList<String> readObjects(TREE_OBJECT tREE_OBJECT) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (tREE_OBJECT == TREE_OBJECT.DATABASE) {
            String string = "SELECT DISTINCT [NAME] from SYSDATABASES";
            try {
                Statement statement = this.conn.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "readObjects");
            }
        }
        return arrayList;
    }

    @Override
    public ForeignServer.TableSchema createTableSchema(String string, boolean bl) {
        Object object;
        String string2;
        Object object2;
        Object object3;
        Object object4;
        Statement statement;
        boolean bl2 = false;
        ForeignServer.TableSchema tableSchema = new ForeignServer.TableSchema();
        tableSchema.TableName = string;
        tableSchema.IsValid = true;
        tableSchema.Columns = new ArrayList();
        String string3 = "SELECT COLUMN_NAME,COLUMN_DEFAULT,IS_NULLABLE,DATA_TYPE,CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION, NUMERIC_SCALE,  COLUMNPROPERTY( OBJECT_ID('" + string + "'), COLUMN_NAME , 'ISIDENTITY') as 'IDENTITY', " + " IDENT_SEED('" + string + "') as IDENTITY_SEED, " + " IDENT_INCR('" + string + "') as IDENTITY_INCR " + "FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '" + string + "' ORDER BY " + "ORDINAL_POSITION ASC";
        Globals.appFrame.objNameLabel.setText("Creating Schema for Table " + string);
        try {
            statement = this.conn.createStatement();
            object4 = statement.executeQuery(string3);
            while (object4.next()) {
                object3 = object4.getString("COLUMN_NAME");
                object2 = object4.getString("COLUMN_DEFAULT");
                string2 = object4.getString("IS_NULLABLE");
                boolean bl3 = string2.equals("YES");
                object = object4.getString("DATA_TYPE");
                int n = object4.getInt("IDENTITY");
                boolean bl4 = n == 1;
                n = object4.getInt("IDENTITY_SEED");
                int n2 = 1;
                if (n != 0) {
                    n2 = n;
                }
                n = object4.getInt("IDENTITY_INCR");
                int n3 = 1;
                if (n != 0) {
                    n3 = n;
                }
                int n4 = object4.getInt("CHARACTER_MAXIMUM_LENGTH");
                int n5 = object4.getInt("NUMERIC_PRECISION");
                int n6 = object4.getInt("NUMERIC_SCALE");
                try {
                    bl2 = false;
                    this.validateDataType((String)object);
                }
                catch (Exception exception) {
                    Globals.showWarningMessage("Unsupported type [" + (String)object + "]\n\nColumn \"" + (String)object3 + "\" will be skipped", "createTableSchema");
                    bl2 = true;
                }
                String string4 = "";
                if (bl2) continue;
                if (((String)object).equals("nchar")) {
                    string4 = bl ? "NCHAR" : "CHAR";
                } else if (((String)object).equals("nvarchar") || ((String)object).equals("varchar")) {
                    string4 = n4 == -1 ? "LVARCHAR" : (bl ? "NVARCHAR" : "VARCHAR");
                } else if (((String)object).equals("varbinary")) {
                    string4 = n4 == -1 ? "LVARBINARY" : "VARBINARY";
                } else if (((String)object).equals("text") || ((String)object).equals("ntext") || ((String)object).equals("xml")) {
                    string4 = "LVARCHAR";
                } else if (((String)object).equals("int")) {
                    string4 = "INTEGER";
                } else if (((String)object).equals("timestamp")) {
                    string4 = "BIGINT";
                } else if (((String)object).equals("smallmoney")) {
                    string4 = "MONEY";
                } else if (((String)object).equals("date")) {
                    string4 = "DATE";
                } else if (((String)object).equals("time")) {
                    string4 = "TIME";
                } else if (((String)object).equals("datetime") || ((String)object).equals("datetime2") || ((String)object).equals("smalldatetime")) {
                    string4 = "TIMESTAMP";
                } else if (((String)object).equals("image") || ((String)object).equals("sql_variant")) {
                    string4 = "LVARBINARY";
                } else if (((String)object).equals("uniqueidentifier")) {
                    string4 = "VARCHAR";
                    n4 = 255;
                } else if (((String)object).equals("numeric")) {
                    string4 = "NUMERIC";
                    if (n5 > 32) {
                        n5 = 32;
                    }
                } else {
                    string4 = ((String)object).toUpperCase();
                }
                object2 = this.fixDefaultValueString((String)object2);
                ForeignServer.ColumnSchema columnSchema = new ForeignServer.ColumnSchema();
                columnSchema.ColumnName = object3;
                columnSchema.ColumnType = string4;
                columnSchema.IsNullable = bl3;
                columnSchema.IsIdentity = bl4;
                columnSchema.IdentitySeed = n2;
                columnSchema.IdentityIncrement = n3;
                columnSchema.DefaultValue = this.adjustDefaultValue((String)object2);
                columnSchema.Length = n4;
                columnSchema.Precision = n5;
                columnSchema.Scale = n6;
                tableSchema.Columns.add(columnSchema);
            }
            object4.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        string3 = "SELECT KC.COLUMN_NAME, KC.CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS PK INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE KC ON KC.CONSTRAINT_SCHEMA = PK.CONSTRAINT_SCHEMA AND KC.CONSTRAINT_NAME = PK.CONSTRAINT_NAME WHERE PK.CONSTRAINT_TYPE = 'PRIMARY KEY' AND KC.TABLE_NAME = '" + string + "' ORDER BY ORDINAL_POSITION ASC";
        try {
            tableSchema.PrimaryKey = new ArrayList();
            statement = this.conn.createStatement();
            object4 = statement.executeQuery(string3);
            while (object4.next()) {
                object3 = object4.getString("COLUMN_NAME");
                object2 = object4.getString("CONSTRAINT_NAME");
                tableSchema.PrimaryKey.add((String)object3);
                tableSchema.PrimaryKeyConstraintName = object2;
            }
            object4.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        string3 = "SELECT KC.COLUMN_NAME, KC.CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS PK INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE KC ON KC.CONSTRAINT_SCHEMA = PK.CONSTRAINT_SCHEMA AND KC.CONSTRAINT_NAME = PK.CONSTRAINT_NAME WHERE PK.CONSTRAINT_TYPE = 'UNIQUE' AND KC.TABLE_NAME = '" + string + "' ORDER BY KC.CONSTRAINT_NAME, ORDINAL_POSITION ASC";
        object4 = null;
        try {
            tableSchema.UniqueKeys = new ArrayList();
            statement = this.conn.createStatement();
            object3 = statement.executeQuery(string3);
            while (object3.next()) {
                object2 = object3.getString("CONSTRAINT_NAME");
                if (object4 == null || !((ForeignServer.UniqueConstraint)object4).UniqueConstraintName.equals(object2)) {
                    object4 = new ForeignServer.UniqueConstraint();
                    ((ForeignServer.UniqueConstraint)object4).UniqueConstraintColumns = new ArrayList();
                    tableSchema.UniqueKeys.add((ForeignServer.UniqueConstraint)object4);
                    ((ForeignServer.UniqueConstraint)object4).UniqueConstraintName = object2;
                }
                string2 = object3.getString("COLUMN_NAME");
                ((ForeignServer.UniqueConstraint)object4).UniqueConstraintColumns.add(string2);
            }
            object3.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        string3 = "SELECT FK.TABLE_NAME AS TO_TABLE, CU.COLUMN_NAME AS FROM_COLUMN, PK.TABLE_NAME AS TABLE_NAME, PT.COLUMN_NAME AS TO_COLUMN, C.CONSTRAINT_NAME FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS C INNER JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS FK ON C.CONSTRAINT_NAME = FK.CONSTRAINT_NAME INNER JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS PK ON C.UNIQUE_CONSTRAINT_NAME = PK.CONSTRAINT_NAME INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE CU ON C.CONSTRAINT_NAME = CU.CONSTRAINT_NAME INNER JOIN ( SELECT i1.TABLE_NAME, i2.COLUMN_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS i1 INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE i2 ON i1.CONSTRAINT_NAME = i2.CONSTRAINT_NAME WHERE i1.CONSTRAINT_TYPE = 'PRIMARY KEY' ) PT ON PT.TABLE_NAME = PK.TABLE_NAME WHERE FK.TABLE_NAME='" + string + "'";
        try {
            object3 = null;
            tableSchema.ForeignKeys = new ArrayList();
            statement = this.conn.createStatement();
            object2 = statement.executeQuery(string3);
            while (object2.next()) {
                string2 = object2.getString("CONSTRAINT_NAME");
                if (object3 == null || !((ForeignServer.ForeignKey)object3).ForeignConstraintName.equals(string2)) {
                    object3 = new ForeignServer.ForeignKey();
                    ((ForeignServer.ForeignKey)object3).Columns = new ArrayList();
                    ((ForeignServer.ForeignKey)object3).RefColumns = new ArrayList();
                    tableSchema.ForeignKeys.add((ForeignServer.ForeignKey)object3);
                    ((ForeignServer.ForeignKey)object3).ForeignConstraintName = string2;
                }
                String string5 = object2.getString("FROM_COLUMN");
                ((ForeignServer.ForeignKey)object3).RefColumns.add(string5);
                string5 = object2.getString("TO_COLUMN");
                ((ForeignServer.ForeignKey)object3).Columns.add(string5);
                ((ForeignServer.ForeignKey)object3).RefTable = string5 = object2.getString("TABLE_NAME");
                ((ForeignServer.ForeignKey)object3).Table = string5 = object2.getString("TO_TABLE");
            }
            object2.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        string3 = "SELECT CK.CONSTRAINT_NAME, CC.COLUMN_NAME, CK.CHECK_CLAUSE FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS CK JOIN INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE  CC ON CK  .CONSTRAINT_NAME = CC.CONSTRAINT_NAME WHERE CC.TABLE_NAME = '" + string + "'";
        try {
            tableSchema.CheckConstraints = new ArrayList();
            statement = this.conn.createStatement();
            object3 = statement.executeQuery(string3);
            while (object3.next()) {
                object2 = new ForeignServer.CheckConstraint();
                ((ForeignServer.CheckConstraint)object2).ConstraintName = string2 = object3.getString("CONSTRAINT_NAME");
                ((ForeignServer.CheckConstraint)object2).ColumnName = string2 = object3.getString("COLUMN_NAME");
                string2 = object3.getString("CHECK_CLAUSE");
                if (string2.startsWith("(")) {
                    string2 = string2.substring(1);
                    string2 = string2.substring(0, string2.length() - 1);
                }
                string2 = string2.replace('[', '\"');
                ((ForeignServer.CheckConstraint)object2).CheckClause = string2 = string2.replace(']', '\"');
                tableSchema.CheckConstraints.add((ForeignServer.CheckConstraint)object2);
            }
            object3.close();
            string3 = "EXEC SP_HELPINDEX '" + string + "'";
            tableSchema.Indexes = new ArrayList();
            statement = this.conn.createStatement();
            try {
                object3 = statement.executeQuery(string3);
                while (object3.next()) {
                    object2 = object3.getString("INDEX_NAME");
                    string2 = object3.getString("INDEX_DESCRIPTION");
                    String string6 = object3.getString("INDEX_KEYS");
                    if (string2.contains("primary key") || string2.contains("unique key")) continue;
                    object = this.buildIndexSchema((String)object2, string2, string6);
                    tableSchema.Indexes.add((ForeignServer.IndexSchema)object);
                }
                object3.close();
            }
            catch (SQLException sQLException) {}
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        return tableSchema;
    }

    private ForeignServer.IndexSchema buildIndexSchema(String string, String string2, String string3) {
        String[] stringArray;
        ForeignServer.IndexSchema indexSchema = new ForeignServer.IndexSchema();
        indexSchema.IndexName = string;
        String[] stringArray2 = string2.split(",");
        for (String string4 : stringArray2) {
            if (!string4.trim().equals("unique")) continue;
            indexSchema.IsUnique = true;
            break;
        }
        indexSchema.Columns = new ArrayList();
        Pattern pattern = Pattern.compile("([a-zA-Z_0-9]+)(\\(\\-\\))?");
        for (String string5 : stringArray = string3.split(",")) {
            Matcher matcher = pattern.matcher(string5);
            if (!matcher.find()) {
                Globals.showMessage("Illegal key name [" + string5 + "] in index [" + string + "]", "buildIndexSchema");
            }
            String string6 = matcher.group(1);
            String string7 = matcher.group(2);
            ForeignServer.IndexColumn indexColumn = new ForeignServer.IndexColumn();
            indexColumn.ColumnName = string6;
            indexColumn.IsAscending = string7 == null;
            indexSchema.Columns.add(indexColumn);
        }
        return indexSchema;
    }

    private String fixDefaultValueString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '\'' && n == -1) {
                n = i;
            }
            if (string2.charAt(i) != '\'' || n == -1 || i <= n2) continue;
            n2 = i;
        }
        if (n != -1 && n2 > n) {
            String string3 = string2.substring(n + 1, n2);
            return string3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '(' || string2.charAt(i) == ')') continue;
            stringBuilder.append(string2.charAt(i));
        }
        return stringBuilder.toString();
    }

    private String adjustDefaultValue(String string) {
        return string;
    }

    private void validateDataType(String string) throws Exception {
        if (string.equals("int") || string.equals("integer") || string.equals("smallint") || string.equals("bit") || string.equals("float") || string.equals("double") || string.equals("real") || string.equals("nvarchar") || string.equals("nchar") || string.equals("varchar") || string.equals("lvarchar") || string.equals("varbinary") || string.equals("image") || string.equals("text") || string.equals("ntext") || string.equals("bigint") || string.equals("char") || string.equals("character") || string.equals("numeric") || string.equals("binary") || string.equals("date") || string.equals("time") || string.equals("timestamp") || string.equals("money") || string.equals("tinyint") || string.equals("smalldatetime") || string.equals("xml") || string.equals("sql_variant") || string.equals("datetime2") || string.equals("smallmoney") || string.equals("uniqueidentifier") || string.equals("varbinary") || string.equals("lvarbinary") || string.equals("decimal") || string.equals("datetime")) {
            return;
        }
        throw new Exception("Validation failed for data type [" + string + "]");
    }

    @Override
    public ForeignServer.ViewSchema createViewSchema(String string) {
        String string2 = "SELECT c.TABLE_NAME, c.COLUMN_NAME , c.ORDINAL_POSITION [Ordinal]\t, VIEW_DEFINITION, CHECK_OPTION, IS_UPDATABLE  FROM INFORMATION_SCHEMA.COLUMNS c INNER JOIN INFORMATION_SCHEMA.VIEWS v ON c.TABLE_CATALOG = v.TABLE_CATALOG AND c.TABLE_SCHEMA = v.TABLE_SCHEMA AND c.TABLE_NAME = v.TABLE_NAME WHERE\tv.TABLE_NAME = '" + string + "' AND NOT (v.TABLE_SCHEMA = 'dbo'" + " AND v.TABLE_NAME in('syssegments', 'sysconstraints')" + " AND SUBSTRING(CAST(SERVERPROPERTY('productversion') as varchar(20)),1,1) = 8) " + " ORDER BY v.TABLE_NAME ASC";
        ForeignServer.ViewSchema viewSchema = new ForeignServer.ViewSchema();
        Globals.appFrame.objNameLabel.setText("Creating Schema for View " + string);
        try {
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string3;
                viewSchema.ViewColumns = new ArrayList();
                viewSchema.ViewName = string3 = resultSet.getString("TABLE_NAME");
                string3 = resultSet.getString("COLUMN_NAME");
                viewSchema.ViewColumns.add(string3);
                string3 = resultSet.getString("VIEW_DEFINITION");
                int n = string3.indexOf("AS");
                if (n > 0) {
                    string3 = string3.substring(n + 2);
                }
                if (string3.endsWith(")")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                viewSchema.ViewDefinition = string3;
                string3 = resultSet.getString("CHECK_OPTION");
                if (string3.equals("CASCADE")) {
                    viewSchema.WithCheck = true;
                }
                viewSchema.IsUpdatable = false;
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        return viewSchema;
    }

    @Override
    public ForeignServer.SynonymSchema createSynonymSchema(String string) {
        String string2 = "SELECT NAME, BASE_OBJECT_NAME FROM SYS.SYNONYMS WHERE NAME = '" + string + "'";
        ForeignServer.SynonymSchema synonymSchema = new ForeignServer.SynonymSchema();
        Globals.appFrame.objNameLabel.setText("Creating Synonym " + string);
        try {
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string3;
                synonymSchema.SynonymName = string3 = resultSet.getString("NAME");
                string3 = resultSet.getString("BASE_OBJECT_NAME");
                int n = string3.lastIndexOf(91);
                int n2 = string3.lastIndexOf(93);
                synonymSchema.ReferredObject = string3.substring(n + 1, n2);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        return synonymSchema;
    }

    @Override
    public ArrayList<String> readServerTables(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.getConnectionString(string);
        try {
            this.conn = DriverManager.getConnection(string2);
            String string3 = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE = 'BASE TABLE' ORDER BY TABLE_NAME";
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            this.conn.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readServerTables");
        }
        return arrayList;
    }

    @Override
    public ArrayList<String> readServerViews(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.getConnectionString(string);
        try {
            this.conn = DriverManager.getConnection(string2);
            String string3 = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.VIEWS ORDER BY TABLE_NAME";
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            this.conn.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readServerViews");
        }
        return arrayList;
    }

    @Override
    public ArrayList<String> readServerSynonyms(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.getConnectionString(string);
        try {
            this.conn = DriverManager.getConnection(string2);
            String string3 = "SELECT NAME FROM SYS.SYNONYMS ORDER BY NAME";
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            this.conn.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readServerSynonyms");
        }
        return arrayList;
    }

    @Override
    public void stopConversion(boolean bl) {
        this.cancelled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean copyRows(String string, ForeignServer.TableSchema tableSchema, boolean bl, BufferedWriter bufferedWriter) {
        int n;
        boolean bl2;
        block30: {
            bl2 = true;
            n = 0;
            int n3 = 0;
            String string2 = "select count(*) from [" + tableSchema.TableName + "]";
            ResultSet resultSet = null;
            Statement statement = null;
            StringBuilder stringBuilder = null;
            try {
                statement = this.conn.createStatement();
                resultSet = statement.executeQuery(string2);
                resultSet.next();
                n = resultSet.getInt(1) + 1;
                n3 = n / 100 + 1;
                Globals.appFrame.importProgressBar.setMaximum(n);
                Globals.appFrame.importProgressBar.setValue(0);
            }
            catch (SQLException sQLException) {
                boolean n2 = this.showException(sQLException, "Source");
                if (!n2) {
                    boolean bl3 = bl2;
                    return bl3;
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(OracleServer.class.getName()).log(Level.SEVERE, null, sQLException);
                    }
                }
            }
            String string3 = this.buildServerTableQuery(tableSchema);
            try {
                statement = this.conn.createStatement();
                resultSet = statement.executeQuery(string3);
                boolean sQLException = false;
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                while (resultSet.next()) {
                    void var13_18;
                    stringBuilder = new StringBuilder(string);
                    if (this.cancelled) {
                        resultSet.close();
                        statement.close();
                        return bl2;
                    }
                    try {
                        for (int iOException = 1; iOException <= n2; ++iOException) {
                            if (iOException > 1) {
                                stringBuilder.append(",");
                            }
                            int n4 = resultSetMetaData.getColumnType(iOException);
                            String string4 = null;
                            if (n4 != 2004 && n4 != -4 && (string4 = resultSet.getString(iOException)) != null) {
                                string4 = string4.replace("'", "''");
                                string4 = "'" + string4 + "'";
                            }
                            if (resultSet.wasNull()) {
                                stringBuilder.append("NULL");
                                continue;
                            }
                            stringBuilder.append(string4);
                        }
                    }
                    catch (SQLException sQLException2) {
                        try {
                            bufferedWriter.write(sQLException2.getMessage());
                            bufferedWriter.newLine();
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(OracleServer.class.getName()).log(Level.SEVERE, null, iOException);
                        }
                    }
                    try {
                        stringBuilder.append(")");
                        bufferedWriter.write(stringBuilder.toString());
                        bufferedWriter.write(";");
                        bufferedWriter.newLine();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(OracleServer.class.getName()).log(Level.SEVERE, null, iOException);
                    }
                    if (++var13_18 % n3 != false) continue;
                    Globals.appFrame.importProgressBar.setValue((int)var13_18);
                }
                resultSet.close();
                statement.close();
            }
            catch (SQLException sQLException) {
                if (this.showException(sQLException, "Source")) break block30;
                bl2 = false;
            }
        }
        Globals.appFrame.importProgressBar.setValue(n);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyRows(PreparedStatement preparedStatement, ForeignServer.TableSchema tableSchema, boolean bl, StringBuilder stringBuilder) {
        int n;
        boolean bl2;
        block24: {
            Object object;
            bl2 = true;
            n = 0;
            int n2 = 0;
            String string = "select count(*) from [" + tableSchema.TableName + "]";
            ResultSet resultSet = null;
            try {
                object = this.conn.createStatement();
                resultSet = object.executeQuery(string);
                resultSet.next();
                n = resultSet.getInt(1) + 1;
                n2 = n / 100 + 1;
                Globals.appFrame.importProgressBar.setMaximum(n);
                Globals.appFrame.importProgressBar.setValue(0);
            }
            catch (SQLException sQLException) {
                boolean bl3 = this.showException(sQLException, "Source");
                if (!bl3) {
                    boolean bl4 = bl2;
                    return bl4;
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(MsSqlServer.class.getName()).log(Level.SEVERE, null, sQLException);
                    }
                }
            }
            object = this.buildServerTableQuery(tableSchema);
            try {
                ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
                Statement statement = this.conn.createStatement();
                resultSet = statement.executeQuery((String)object);
                int n3 = 0;
                while (resultSet.next()) {
                    if (this.cancelled) {
                        resultSet.close();
                        return bl2;
                    }
                    try {
                        int n4 = parameterMetaData.getParameterCount();
                        for (int i = 1; i <= n4; ++i) {
                            Object object2 = resultSet.getObject(i);
                            if (object2 != null) {
                                preparedStatement.setObject(i, object2);
                                continue;
                            }
                            preparedStatement.setNull(i, parameterMetaData.getParameterType(i));
                        }
                        preparedStatement.execute();
                    }
                    catch (SQLException sQLException) {
                        stringBuilder.append("Insertion of Row # ").append(n3 + 1).append(" in Table \"").append(tableSchema.TableName).append("\" returned the following error : ").append(sQLException.getErrorCode()).append(" = ").append(sQLException.getMessage()).append("\n");
                    }
                    if (++n3 % n2 != 0) continue;
                    Globals.appFrame.importProgressBar.setValue(n3);
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                if (this.showException(sQLException, "Source")) break block24;
                bl2 = false;
            }
        }
        Globals.appFrame.importProgressBar.setValue(n);
        return bl2;
    }

    private String buildServerTableQuery(ForeignServer.TableSchema tableSchema) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        for (int i = 0; i < tableSchema.Columns.size(); ++i) {
            if (tableSchema.Columns.get((int)i).IsIdentity) continue;
            stringBuilder.append("[").append(tableSchema.Columns.get((int)i).ColumnName).append("]");
            if (i >= tableSchema.Columns.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(" FROM [").append(tableSchema.TableName).append("]");
        return stringBuilder.toString();
    }

    private boolean showException(SQLException sQLException, String string) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        int n = JOptionPane.showConfirmDialog(jFrame, string + " Server Error : " + sQLException.getErrorCode() + "\n\nDescription : " + sQLException.getMessage() + "\n\nDo you want to proceed ?", string + " Server Error", 0, 0);
        return n == 0;
    }

    @Override
    public boolean isConnected() {
        try {
            return !this.conn.isClosed();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(MsSqlServer.class.getName()).log(Level.SEVERE, null, sQLException);
            return false;
        }
    }

    @Override
    public String getCurrentDb() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

