/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.TREE_OBJECT;
import ctreeaceexplorer.sql.ForeignServer;
import ctreeaceexplorer.sql.MsSqlServer;
import ctreeaceexplorer.sql.MsSqlServerConnect;
import ctreeaceexplorer.sql.NoJdbcDialog;
import ctreeaceexplorer.sql.OracleServer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class MySQLServer
implements ForeignServer {
    boolean extendedLogin;
    private String userName;
    private String userPassword;
    private String serverAddress;
    private String database;
    private Connection conn;
    private boolean cancelled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(String string, String string2, Boolean bl) {
        Object object;
        boolean bl2 = false;
        this.serverAddress = string;
        this.database = string2;
        this.extendedLogin = bl;
        try {
            Object object2;
            if (this.conn != null && !this.conn.isClosed()) {
                boolean bl3 = true;
                return bl3;
            }
            if (bl.booleanValue()) {
                object2 = CtreeACEExplorerApp.getApplication().getMainFrame();
                object = new MsSqlServerConnect((Frame)object2, true);
                ((Window)object).setLocationRelativeTo((Component)object2);
                ((Dialog)object).setTitle("MySQL Server Connection");
                boolean bl4 = ((MsSqlServerConnect)object).showDialog(true);
                if (!bl4) {
                    boolean bl5 = false;
                    return bl5;
                }
                this.userName = ((MsSqlServerConnect)object).getUserName();
                this.userPassword = ((MsSqlServerConnect)object).getUserPassword();
            }
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            object2 = this.getConnectionString("information_schema");
            Globals.ShowWaitCursor();
            this.conn = DriverManager.getConnection((String)object2);
            bl2 = true;
            return bl2;
        }
        catch (SQLException sQLException) {
            object = sQLException.getMessage();
            Globals.showMessage(this.splitException((String)object), "Connect");
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = CtreeACEExplorerApp.getApplication().getMainFrame();
            NoJdbcDialog noJdbcDialog = new NoJdbcDialog((Frame)object, "MySQL Server");
            noJdbcDialog.setLocationRelativeTo((Component)object);
            noJdbcDialog.setVisible(true);
        }
        finally {
            Globals.ShowNormalCursor();
            return bl2;
        }
    }

    private String splitException(String string) {
        String[] stringArray = string.split("\\. ");
        string = "";
        for (String string2 : stringArray) {
            if (!string2.endsWith(".")) {
                string2 = string2 + ".";
            }
            string = string + string2 + "\r\n";
        }
        return string;
    }

    private String getConnectionString(String string) {
        this.database = string;
        String string2 = "jdbc:mysql://" + this.serverAddress.trim() + "/" + string.trim() + "?";
        string2 = this.extendedLogin ? string2 + "user=" + this.userName + "&password=" + this.userPassword : string2 + ";integratedSecurity=true;";
        return string2;
    }

    @Override
    public void disconnect() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(MsSqlServer.class.getName()).log(Level.SEVERE, null, sQLException);
            }
        }
    }

    @Override
    public String getServerId() {
        return this.serverAddress;
    }

    @Override
    public boolean changeDb(String string) {
        this.database = string;
        String string2 = this.getConnectionString(string);
        try {
            this.conn = DriverManager.getConnection(string2);
            return true;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(MsSqlServer.class.getName()).log(Level.SEVERE, null, sQLException);
            return false;
        }
    }

    @Override
    public ArrayList<String> readObjects(TREE_OBJECT tREE_OBJECT) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (tREE_OBJECT == TREE_OBJECT.DATABASE) {
            String string = "SHOW DATABASES";
            try {
                Statement statement = this.conn.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "readObjects");
            }
        }
        return arrayList;
    }

    @Override
    public ForeignServer.TableSchema createTableSchema(String string, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Statement statement;
        int n = 0;
        int n2 = 0;
        ForeignServer.TableSchema tableSchema = new ForeignServer.TableSchema();
        tableSchema.TableName = string;
        tableSchema.Columns = new ArrayList();
        String string2 = "SHOW VARIABLES LIKE 'auto_inc%'";
        try {
            boolean bl2 = true;
            statement = this.conn.createStatement();
            object3 = statement.executeQuery(string2);
            while (object3.next()) {
                int n3 = object3.getInt(2);
                if (bl2) {
                    n = n3;
                    bl2 = false;
                    continue;
                }
                n2 = n3;
            }
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        string2 = "SELECT COLUMN_NAME, COLUMN_DEFAULT, IS_NULLABLE, IF(LEFT(COLUMN_TYPE,10) = 'tinyint(1)', 'bit',DATA_TYPE) AS `DATA_TYPE`, IF (CHARACTER_MAXIMUM_LENGTH > 2147483647, 2147483647, CHARACTER_MAXIMUM_LENGTH) AS `CHARACTER_MAXIMUM_LENGTH`, NUMERIC_PRECISION, NUMERIC_SCALE, CASE WHEN EXTRA LIKE '%auto%' THEN 1 ELSE 0 END AS `IDENTITY` FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA=schema() AND TABLE_NAME = '" + string + "' ORDER BY ORDINAL_POSITION";
        Globals.appFrame.objNameLabel.setText("Creating Schema for Table " + string);
        try {
            statement = this.conn.createStatement();
            object2 = statement.executeQuery(string2);
            while (object2.next()) {
                object3 = object2.getString("COLUMN_NAME");
                String string3 = object2.getString("COLUMN_DEFAULT");
                if (string3 == null) {
                    string3 = "";
                }
                object = object2.getString("IS_NULLABLE");
                boolean bl3 = ((String)object).equals("YES");
                String string4 = object2.getString("DATA_TYPE");
                int n4 = object2.getInt("IDENTITY");
                boolean bl4 = n4 == 1;
                int n5 = n2;
                int n6 = n;
                int n7 = object2.getInt("CHARACTER_MAXIMUM_LENGTH");
                int n8 = object2.getInt("NUMERIC_PRECISION");
                int n9 = object2.getInt("NUMERIC_SCALE");
                try {
                    this.validateDataType(string4);
                }
                catch (Exception exception) {
                    Globals.showException(exception, "createTableSchema");
                    return tableSchema;
                }
                String string5 = "";
                if (string4.equals("int") || string4.equals("integer") || string4.equals("mediumint")) {
                    string5 = "INTEGER";
                } else if (string4.equals("double")) {
                    string5 = "DOUBLE PRECISION";
                } else if (string4.equals("binary") || string4.equals("varbinary")) {
                    string5 = "BINARY";
                } else if (string4.equals("char") || string4.equals("tinytext") || string4.equals("enum") || string4.equals("set")) {
                    string5 = "CHAR";
                } else if (string4.equals("text") || string4.equals("mediumtext") || string4.equals("clob") || string4.equals("lvarchar") || string4.equals("longtext")) {
                    string5 = "LVARCHAR";
                    bl3 = true;
                } else if (string4.equals("tinyblob")) {
                    string5 = "BINARY";
                } else if (string4.equals("blob") || string4.equals("mediumblob") || string4.equals("longblob")) {
                    string5 = "LVARBINARY";
                    bl3 = true;
                } else {
                    string5 = string4.equals("date") || string4.equals("year") ? "DATE" : (string4.equals("datetime") ? "TIMESTAMP" : string4.toUpperCase());
                }
                string3 = this.fixDefaultValueString(string3);
                ForeignServer.ColumnSchema columnSchema = new ForeignServer.ColumnSchema();
                columnSchema.ColumnName = object3;
                columnSchema.ColumnType = string5;
                columnSchema.IsNullable = bl3;
                columnSchema.IsIdentity = bl4;
                columnSchema.IdentitySeed = n5;
                columnSchema.IdentityIncrement = n6;
                columnSchema.DefaultValue = this.adjustDefaultValue(string3);
                columnSchema.Length = n7;
                columnSchema.Precision = n8;
                columnSchema.Scale = n9;
                tableSchema.Columns.add(columnSchema);
            }
            object2.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        string2 = "SELECT KC.COLUMN_NAME, KC.CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS PK INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE KC  ON KC.CONSTRAINT_SCHEMA = PK.CONSTRAINT_SCHEMA AND KC.CONSTRAINT_NAME = PK.CONSTRAINT_NAME\tAND KC.TABLE_NAME = PK.TABLE_NAME WHERE PK.CONSTRAINT_TYPE = 'PRIMARY KEY' AND PK.TABLE_SCHEMA=schema() AND KC.TABLE_NAME = '" + string + "' ORDER BY ORDINAL_POSITION ASC";
        try {
            tableSchema.PrimaryKey = new ArrayList();
            statement = this.conn.createStatement();
            object2 = statement.executeQuery(string2);
            while (object2.next()) {
                object3 = object2.getString("COLUMN_NAME");
                String string6 = object2.getString("CONSTRAINT_NAME");
                tableSchema.PrimaryKey.add((String)object3);
                tableSchema.PrimaryKeyConstraintName = string6;
            }
            object2.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        string2 = "SELECT KC.COLUMN_NAME, KC.CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS PK INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE KC  ON KC.CONSTRAINT_SCHEMA = PK.CONSTRAINT_SCHEMA AND KC.CONSTRAINT_NAME = PK.CONSTRAINT_NAME AND KC.TABLE_NAME = PK.TABLE_NAME WHERE PK.CONSTRAINT_TYPE = 'UNIQUE' AND PK.TABLE_SCHEMA=schema() AND KC.TABLE_NAME = '" + string + "' ORDER BY ORDINAL_POSITION ASC";
        object2 = null;
        try {
            tableSchema.UniqueKeys = new ArrayList();
            statement = this.conn.createStatement();
            object3 = statement.executeQuery(string2);
            while (object3.next()) {
                String string7 = object3.getString("CONSTRAINT_NAME");
                if (object2 == null || !((ForeignServer.UniqueConstraint)object2).UniqueConstraintName.equals(string7)) {
                    object2 = new ForeignServer.UniqueConstraint();
                    ((ForeignServer.UniqueConstraint)object2).UniqueConstraintColumns = new ArrayList();
                    tableSchema.UniqueKeys.add((ForeignServer.UniqueConstraint)object2);
                    ((ForeignServer.UniqueConstraint)object2).UniqueConstraintName = string7;
                }
                object = object3.getString("COLUMN_NAME");
                ((ForeignServer.UniqueConstraint)object2).UniqueConstraintColumns.add((String)object);
            }
            object3.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        string2 = "SELECT KCU.CONSTRAINT_NAME, KCU.TABLE_NAME,KCU.COLUMN_NAME AS FROM_COLUMN, KCU.REFERENCED_TABLE_NAME AS TO_TABLE, KCU.REFERENCED_COLUMN_NAME AS TO_COLUMN FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS TC INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE KCU WHERE TC.CONSTRAINT_TYPE = 'FOREIGN KEY' AND KCU.TABLE_NAME = '" + string + "' AND TC.TABLE_SCHEMA = KCU.TABLE_SCHEMA AND TC.TABLE_NAME = KCU.TABLE_NAME " + " AND TC.CONSTRAINT_NAME = KCU.CONSTRAINT_NAME " + " AND TC.TABLE_SCHEMA = schema()";
        try {
            object3 = null;
            tableSchema.ForeignKeys = new ArrayList();
            statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                object = resultSet.getString("CONSTRAINT_NAME");
                if (object3 == null || !((ForeignServer.ForeignKey)object3).ForeignConstraintName.equals(object)) {
                    object3 = new ForeignServer.ForeignKey();
                    ((ForeignServer.ForeignKey)object3).Columns = new ArrayList();
                    ((ForeignServer.ForeignKey)object3).RefColumns = new ArrayList();
                    tableSchema.ForeignKeys.add((ForeignServer.ForeignKey)object3);
                    ((ForeignServer.ForeignKey)object3).ForeignConstraintName = object;
                }
                String string8 = resultSet.getString("FROM_COLUMN");
                ((ForeignServer.ForeignKey)object3).Columns.add(string8);
                string8 = resultSet.getString("TO_COLUMN");
                ((ForeignServer.ForeignKey)object3).RefColumns.add(string8);
                ((ForeignServer.ForeignKey)object3).Table = string8 = resultSet.getString("TABLE_NAME");
                ((ForeignServer.ForeignKey)object3).RefTable = string8 = resultSet.getString("TO_TABLE");
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        tableSchema.CheckConstraints = new ArrayList();
        try {
            string2 = "SHOW INDEX FROM " + this.database + ".`" + string + "`";
            tableSchema.Indexes = new ArrayList();
            object3 = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            object = null;
            boolean bl5 = false;
            boolean bl6 = true;
            statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string9 = resultSet.getString("Key_Name");
                if (!string9.equals(object3) && !bl6) {
                    if (!this.indexExist((String)object3, tableSchema)) {
                        object = this.buildIndexSchema((String)object3, bl5, arrayList);
                        tableSchema.Indexes.add((ForeignServer.IndexSchema)object);
                    }
                    arrayList = new ArrayList();
                    bl5 = false;
                }
                bl6 = false;
                object3 = string9;
                String string10 = resultSet.getString("Column_name");
                arrayList.add(string10);
                long l = resultSet.getLong("Non_unique");
                if (l != 0L) continue;
                bl5 = true;
            }
            resultSet.close();
            if (((String)object3).length() > 0 && !this.indexExist((String)object3, tableSchema)) {
                object = this.buildIndexSchema((String)object3, bl5, arrayList);
                tableSchema.Indexes.add((ForeignServer.IndexSchema)object);
            }
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        return tableSchema;
    }

    boolean indexExist(String string, ForeignServer.TableSchema tableSchema) {
        if (string.equals(tableSchema.PrimaryKeyConstraintName)) {
            return true;
        }
        for (ForeignServer.UniqueConstraint object : tableSchema.UniqueKeys) {
            if (!string.equals(object.UniqueConstraintName)) continue;
            return true;
        }
        for (ForeignServer.ForeignKey foreignKey : tableSchema.ForeignKeys) {
            if (!string.equals(foreignKey.ForeignConstraintName)) continue;
            return true;
        }
        return false;
    }

    private ForeignServer.IndexSchema buildIndexSchema(String string, boolean bl, ArrayList<String> arrayList) {
        ForeignServer.IndexSchema indexSchema = new ForeignServer.IndexSchema();
        indexSchema.IndexName = string;
        indexSchema.Columns = new ArrayList();
        indexSchema.IsUnique = bl;
        Pattern pattern = Pattern.compile("([a-zA-Z_0-9]+)(\\(\\-\\))?");
        for (String string2 : arrayList) {
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.find()) {
                Globals.showMessage("Illegal key name [" + string2 + "] in index [" + string + "]", "buildIndexSchema");
            }
            String string3 = matcher.group(1);
            String string4 = matcher.group(2);
            ForeignServer.IndexColumn indexColumn = new ForeignServer.IndexColumn();
            indexColumn.ColumnName = string3;
            indexColumn.IsAscending = string4 == null;
            indexSchema.Columns.add(indexColumn);
        }
        return indexSchema;
    }

    private String fixDefaultValueString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '\'' && n == -1) {
                n = i;
            }
            if (string2.charAt(i) != '\'' || n == -1 || i <= n2) continue;
            n2 = i;
        }
        if (n != -1 && n2 > n) {
            String string3 = string2.substring(n + 1, n2);
            return string3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '(' || string2.charAt(i) == ')') continue;
            stringBuilder.append(string2.charAt(i));
        }
        String string4 = stringBuilder.toString();
        if (string4.equals("CURRENT_TIMESTAMP")) {
            string4 = "SYSTIMESTAMP";
        }
        if (string4.equals("CURRENT_DATE")) {
            string4 = "SYSDATE";
        }
        if (string4.equals("CURRENT_TIME")) {
            string4 = "SYSTIME";
        }
        return string4;
    }

    private String adjustDefaultValue(String string) {
        return string.replace("'", "");
    }

    private void validateDataType(String string) throws Exception {
        if (string.equals("bit") || string.equals("tinyint") || string.equals("int") || string.equals("integer") || string.equals("smallint") || string.equals("mediumint") || string.equals("bigint") || string.equals("numeric") || string.equals("decimal") || string.equals("set") || string.equals("float") || string.equals("real") || string.equals("double") || string.equals("date") || string.equals("time") || string.equals("datetime") || string.equals("timestamp") || string.equals("year") || string.equals("char") || string.equals("varchar") || string.equals("enum") || string.equals("text") || string.equals("tinytext") || string.equals("mediumtext") || string.equals("longtext") || string.equals("blob") || string.equals("tinyblob") || string.equals("mediumblob") || string.equals("longblob")) {
            return;
        }
        throw new Exception("Validation failed for data type [" + string + "]");
    }

    @Override
    public ForeignServer.ViewSchema createViewSchema(String string) {
        String string2 = "SELECT C.TABLE_NAME, C.COLUMN_NAME, VIEW_DEFINITION FROM INFORMATION_SCHEMA.COLUMNS C JOIN INFORMATION_SCHEMA.VIEWS V ON C.TABLE_NAME = V.TABLE_NAME WHERE C.TABLE_SCHEMA=schema() AND V.TABLE_SCHEMA=schema() AND C.TABLE_NAME = '" + string + "'";
        ForeignServer.ViewSchema viewSchema = new ForeignServer.ViewSchema();
        Globals.appFrame.objNameLabel.setText("Creating Schema for View " + string);
        try {
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string3;
                viewSchema.ViewColumns = new ArrayList();
                viewSchema.ViewName = string3 = resultSet.getString("TABLE_NAME");
                string3 = resultSet.getString("COLUMN_NAME");
                viewSchema.ViewColumns.add(string3);
                string3 = resultSet.getString("VIEW_DEFINITION");
                viewSchema.ViewDefinition = this.parseViewText(string3);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        return viewSchema;
    }

    private String parseViewText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.database;
        Boolean bl = false;
        ArrayList<String> arrayList = this.tokenize(string.trim());
        for (String string3 : arrayList) {
            if (string3.isEmpty()) continue;
            if (string3.equals("`")) {
                stringBuilder.append("\"");
                continue;
            }
            if (string3.equals(string2)) {
                bl = true;
                continue;
            }
            if (string3.equals(".") && bl.booleanValue()) {
                bl = false;
                continue;
            }
            if (string3.equals("\r") || string3.equals("\n")) {
                if (string3.endsWith(" ")) continue;
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append(string3);
        }
        Object object = stringBuilder.toString();
        object = ((String)object).replace("``", "");
        object = ((String)object).replace("\"\"", "");
        return object;
    }

    private ArrayList<String> tokenize(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "()[] `<>\"'+-/^*.,=\r\n\t", true);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    @Override
    public ForeignServer.SynonymSchema createSynonymSchema(String string) {
        String string2 = "SELECT NAME, BASE_OBJECT_NAME FROM SYS.SYNONYMS WHERE NAME = '" + string + "'";
        ForeignServer.SynonymSchema synonymSchema = new ForeignServer.SynonymSchema();
        Globals.appFrame.objNameLabel.setText("Creating Synonym " + string);
        try {
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string3;
                synonymSchema.SynonymName = string3 = resultSet.getString("NAME");
                string3 = resultSet.getString("BASE_OBJECT_NAME");
                int n = string3.lastIndexOf(91);
                int n2 = string3.lastIndexOf(93);
                synonymSchema.ReferredObject = string3.substring(n + 1, n2);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        return synonymSchema;
    }

    @Override
    public ArrayList<String> readServerTables(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.getConnectionString(string);
        try {
            this.conn = DriverManager.getConnection(string2);
            String string3 = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE = 'BASE TABLE' AND TABLE_SCHEMA=schema() ORDER BY TABLE_NAME";
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            this.conn.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readServerTables");
        }
        return arrayList;
    }

    @Override
    public ArrayList<String> readServerViews(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.getConnectionString(string);
        try {
            this.conn = DriverManager.getConnection(string2);
            String string3 = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE = 'VIEW' AND TABLE_SCHEMA=schema()";
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            this.conn.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readServerViews");
        }
        return arrayList;
    }

    @Override
    public ArrayList<String> readServerSynonyms(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        return arrayList;
    }

    @Override
    public void stopConversion(boolean bl) {
        this.cancelled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean copyRows(String string, ForeignServer.TableSchema tableSchema, boolean bl, BufferedWriter bufferedWriter) {
        int n;
        boolean bl2;
        block30: {
            bl2 = true;
            n = 0;
            int n3 = 0;
            String string2 = "select count(*) from `" + tableSchema.TableName + "`";
            ResultSet resultSet = null;
            Statement statement = null;
            StringBuilder stringBuilder = null;
            try {
                statement = this.conn.createStatement();
                resultSet = statement.executeQuery(string2);
                resultSet.next();
                n = resultSet.getInt(1) + 1;
                n3 = n / 100 + 1;
                Globals.appFrame.importProgressBar.setMaximum(n);
                Globals.appFrame.importProgressBar.setValue(0);
            }
            catch (SQLException sQLException) {
                boolean n2 = this.showException(sQLException, "Source");
                if (!n2) {
                    boolean bl3 = bl2;
                    return bl3;
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(OracleServer.class.getName()).log(Level.SEVERE, null, sQLException);
                    }
                }
            }
            String string3 = this.buildServerTableQuery(tableSchema);
            try {
                statement = this.conn.createStatement();
                resultSet = statement.executeQuery(string3);
                boolean sQLException = false;
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                while (resultSet.next()) {
                    void var13_18;
                    stringBuilder = new StringBuilder(string);
                    if (this.cancelled) {
                        resultSet.close();
                        statement.close();
                        return bl2;
                    }
                    try {
                        for (int iOException = 1; iOException <= n2; ++iOException) {
                            if (iOException > 1) {
                                stringBuilder.append(",");
                            }
                            int n4 = resultSetMetaData.getColumnType(iOException);
                            String string4 = null;
                            if (n4 != 2004 && n4 != -4 && (string4 = resultSet.getString(iOException)) != null) {
                                string4 = string4.replace("'", "''");
                                string4 = "'" + string4 + "'";
                            }
                            if (resultSet.wasNull()) {
                                stringBuilder.append("NULL");
                                continue;
                            }
                            stringBuilder.append(string4);
                        }
                    }
                    catch (SQLException sQLException2) {
                        try {
                            bufferedWriter.write(sQLException2.getMessage());
                            bufferedWriter.newLine();
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(OracleServer.class.getName()).log(Level.SEVERE, null, iOException);
                        }
                    }
                    try {
                        stringBuilder.append(")");
                        bufferedWriter.write(stringBuilder.toString());
                        bufferedWriter.write(";");
                        bufferedWriter.newLine();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(OracleServer.class.getName()).log(Level.SEVERE, null, iOException);
                    }
                    if (++var13_18 % n3 != false) continue;
                    Globals.appFrame.importProgressBar.setValue((int)var13_18);
                }
                resultSet.close();
                statement.close();
            }
            catch (SQLException sQLException) {
                if (this.showException(sQLException, "Source")) break block30;
                bl2 = false;
            }
        }
        Globals.appFrame.importProgressBar.setValue(n);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyRows(PreparedStatement preparedStatement, ForeignServer.TableSchema tableSchema, boolean bl, StringBuilder stringBuilder) {
        int n;
        boolean bl2;
        block24: {
            Object object;
            bl2 = true;
            n = 0;
            int n2 = 0;
            String string = "select count(*) from `" + tableSchema.TableName + "`";
            ResultSet resultSet = null;
            try {
                object = this.conn.createStatement();
                resultSet = object.executeQuery(string);
                resultSet.next();
                n = resultSet.getInt(1) + 1;
                n2 = n / 100 + 1;
                Globals.appFrame.importProgressBar.setMaximum(n);
                Globals.appFrame.importProgressBar.setValue(0);
            }
            catch (SQLException sQLException) {
                boolean bl3 = this.showException(sQLException, "Source");
                if (!bl3) {
                    boolean bl4 = bl2;
                    return bl4;
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(MsSqlServer.class.getName()).log(Level.SEVERE, null, sQLException);
                    }
                }
            }
            object = this.buildServerTableQuery(tableSchema);
            try {
                ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
                Statement statement = this.conn.createStatement();
                resultSet = statement.executeQuery((String)object);
                int n3 = 0;
                while (resultSet.next()) {
                    if (this.cancelled) {
                        resultSet.close();
                        return bl2;
                    }
                    try {
                        int n4 = parameterMetaData.getParameterCount();
                        for (int i = 1; i <= n4; ++i) {
                            Object object2 = resultSet.getObject(i);
                            if (object2 != null) {
                                preparedStatement.setObject(i, object2);
                                continue;
                            }
                            preparedStatement.setNull(i, parameterMetaData.getParameterType(i));
                        }
                        preparedStatement.execute();
                    }
                    catch (SQLException sQLException) {
                        stringBuilder.append("Insertion of Row # ").append(n3 + 1).append(" in Table \"").append(tableSchema.TableName).append("\" returned the following error : ").append(sQLException.getErrorCode()).append(" = ").append(sQLException.getMessage()).append("\n");
                    }
                    if (++n3 % n2 != 0) continue;
                    Globals.appFrame.importProgressBar.setValue(n3);
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                if (this.showException(sQLException, "Source")) break block24;
                bl2 = false;
            }
        }
        Globals.appFrame.importProgressBar.setValue(n);
        return bl2;
    }

    private String buildServerTableQuery(ForeignServer.TableSchema tableSchema) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        for (int i = 0; i < tableSchema.Columns.size(); ++i) {
            if (tableSchema.Columns.get((int)i).IsIdentity) continue;
            stringBuilder.append("`").append(tableSchema.Columns.get((int)i).ColumnName).append("`");
            if (i >= tableSchema.Columns.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(" FROM `").append(tableSchema.TableName).append("`");
        return stringBuilder.toString();
    }

    private boolean showException(SQLException sQLException, String string) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        int n = JOptionPane.showConfirmDialog(jFrame, string + " Server Error : " + sQLException.getErrorCode() + "\n\nDescription : " + sQLException.getMessage() + "\n\nDo you want to proceed ?", string + " Server Error", 0, 0);
        return n == 0;
    }

    @Override
    public boolean isConnected() {
        try {
            return !this.conn.isClosed();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(MsSqlServer.class.getName()).log(Level.SEVERE, null, sQLException);
            return false;
        }
    }

    @Override
    public String getCurrentDb() {
        return this.database;
    }
}

