/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.TREE_OBJECT;
import ctreeaceexplorer.sql.ForeignServer;
import ctreeaceexplorer.sql.MsSqlServer;
import ctreeaceexplorer.sql.MsSqlServerConnect;
import ctreeaceexplorer.sql.NoJdbcDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class OracleServer
implements ForeignServer {
    boolean extendedLogin;
    private String userName;
    private String userPassword;
    private String serverAddress;
    private String port;
    private String sid;
    private Connection conn;
    private boolean cancelled;
    private String currentDb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(String string, String string2, Boolean bl) {
        Object object;
        boolean bl2 = false;
        this.serverAddress = string;
        this.extendedLogin = bl;
        try {
            if (this.conn == null || this.conn.isClosed()) {
                Object object2;
                if (bl.booleanValue()) {
                    object2 = CtreeACEExplorerApp.getApplication().getMainFrame();
                    object = new MsSqlServerConnect((Frame)object2, true);
                    ((Window)object).setLocationRelativeTo((Component)object2);
                    ((Dialog)object).setTitle("Oracle Connection");
                    boolean bl3 = ((MsSqlServerConnect)object).showDialog(false);
                    if (!bl3) {
                        boolean bl4 = false;
                        return bl4;
                    }
                    this.userName = ((MsSqlServerConnect)object).getUserName();
                    this.userPassword = ((MsSqlServerConnect)object).getUserPassword();
                    this.port = ((MsSqlServerConnect)object).getPort();
                    this.sid = ((MsSqlServerConnect)object).getSid();
                }
                Class.forName("oracle.jdbc.driver.OracleDriver");
                object2 = this.getConnectionString();
                Globals.ShowWaitCursor();
                this.conn = DriverManager.getConnection((String)object2);
                bl2 = true;
                return bl2;
            }
        }
        catch (SQLException sQLException) {
            object = sQLException.getMessage();
            Globals.showMessage(this.splitException((String)object), "Connect");
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = CtreeACEExplorerApp.getApplication().getMainFrame();
            NoJdbcDialog noJdbcDialog = new NoJdbcDialog((Frame)object, "Oracle Server");
            noJdbcDialog.setLocationRelativeTo((Component)object);
            noJdbcDialog.setVisible(true);
        }
        finally {
            Globals.ShowNormalCursor();
            return bl2;
        }
    }

    private String splitException(String string) {
        String[] stringArray = string.split("\\. ");
        string = "";
        for (String string2 : stringArray) {
            if (!string2.endsWith(".")) {
                string2 = string2 + ".";
            }
            string = string + string2 + "\r\n";
        }
        return string;
    }

    private String getConnectionString() {
        String string = "jdbc:oracle:thin:" + this.userName + "/" + this.userPassword + "@" + this.serverAddress + ":" + this.port + ":" + this.sid;
        return string;
    }

    @Override
    public void disconnect() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(OracleServer.class.getName()).log(Level.SEVERE, null, sQLException);
            }
        }
    }

    @Override
    public String getServerId() {
        return this.serverAddress;
    }

    @Override
    public boolean changeDb(String string) {
        this.currentDb = string;
        return true;
    }

    @Override
    public ArrayList<String> readObjects(TREE_OBJECT tREE_OBJECT) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (tREE_OBJECT == TREE_OBJECT.DATABASE) {
            String string = "SELECT username FROM all_users ORDER BY username";
            try {
                Statement statement = this.conn.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "readObjects");
            }
        }
        return arrayList;
    }

    @Override
    public ForeignServer.TableSchema createTableSchema(String string, boolean bl) {
        boolean bl2;
        String string2;
        String string3;
        Object object;
        Object object2;
        Object object3;
        ForeignServer.TableSchema tableSchema = new ForeignServer.TableSchema();
        tableSchema.TableName = string;
        tableSchema.Columns = new ArrayList();
        String string4 = "SELECT COLUMN_NAME, DATA_DEFAULT, NULLABLE, DATA_TYPE, DATA_LENGTH, DATA_PRECISION, DATA_SCALE FROM ALL_TAB_COLUMNS WHERE TABLE_NAME ='" + string + "' AND OWNER ='" + this.currentDb + "' ORDER BY COLUMN_ID";
        Globals.appFrame.objNameLabel.setText("Creating Schema for Table " + string);
        Statement statement = null;
        try {
            statement = this.conn.createStatement();
            object3 = statement.executeQuery(string4);
            while (object3.next()) {
                if (this.cancelled) {
                    object3.close();
                    return tableSchema;
                }
                object2 = object3.getString("COLUMN_NAME");
                object = object3.getString("DATA_DEFAULT");
                string3 = object3.getString("NULLABLE");
                boolean bl3 = string3.equals("Y");
                string2 = object3.getString("DATA_TYPE");
                bl2 = false;
                int n = 1;
                int n2 = 1;
                int n3 = object3.getInt("DATA_LENGTH");
                int n4 = object3.getInt("DATA_PRECISION");
                int n5 = object3.getInt("DATA_SCALE");
                String string5 = "";
                string5 = string2.equals("VARCHAR2") || string2.equals("NVARCHAR2") ? (bl ? "NVARCHAR" : "VARCHAR") : (string2.equals("BLOB") || string2.equals("LONG RAW") ? "LVARBINARY" : (string2.equals("RAW") ? "VARBINARY" : (string2.equals("CLOB") || string2.equals("NCLOB") || string2.equals("LONG") ? "LVARCHAR" : (string2.equals("PLS_INTEGER") || string2.equals("BINARY_INTEGER") ? "INTEGER" : (string2.startsWith("INTERVAL") ? "TIME" : (string2.equals("XMLTYPE") ? "LVARCHAR" : (string2.equals("TIMESTAMP(6)") ? "TIMESTAMP" : string2.toUpperCase())))))));
                object = this.fixDefaultValueString((String)object);
                ForeignServer.ColumnSchema columnSchema = new ForeignServer.ColumnSchema();
                columnSchema.ColumnName = object2;
                columnSchema.ColumnType = string5;
                columnSchema.IsNullable = bl3;
                columnSchema.IsIdentity = bl2;
                columnSchema.IdentitySeed = n;
                columnSchema.IdentityIncrement = n2;
                columnSchema.DefaultValue = this.adjustDefaultValue((String)object);
                columnSchema.Length = n3;
                columnSchema.Precision = n4;
                columnSchema.Scale = n5;
                tableSchema.Columns.add(columnSchema);
            }
            object3.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
            try {
                statement.close();
            }
            catch (SQLException sQLException2) {
                Logger.getLogger(OracleServer.class.getName()).log(Level.SEVERE, null, sQLException2);
            }
        }
        string4 = "SELECT COLS.COLUMN_NAME, COLS.CONSTRAINT_NAME FROM ALL_CONSTRAINTS CONS, ALL_CONS_COLUMNS COLS WHERE COLS.TABLE_NAME = '" + string + "' AND CONS.CONSTRAINT_TYPE ='P' AND COLS.CONSTRAINT_NAME = CONS.CONSTRAINT_NAME" + " AND CONS.OWNER = COLS.OWNER AND CONS.OWNER ='" + this.currentDb + "'" + " ORDER BY COLS.POSITION";
        try {
            tableSchema.PrimaryKey = new ArrayList();
            statement = this.conn.createStatement();
            object3 = statement.executeQuery(string4);
            while (object3.next()) {
                object2 = object3.getString("COLUMN_NAME");
                object = object3.getString("CONSTRAINT_NAME");
                tableSchema.PrimaryKey.add((String)object2);
                tableSchema.PrimaryKeyConstraintName = object;
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        string4 = "SELECT COLS.COLUMN_NAME, COLS.CONSTRAINT_NAME FROM ALL_CONSTRAINTS CONS, ALL_CONS_COLUMNS COLS WHERE COLS.TABLE_NAME = '" + string + "' AND CONS.CONSTRAINT_TYPE ='U' AND COLS.CONSTRAINT_NAME = CONS.CONSTRAINT_NAME" + " AND CONS.OWNER = COLS.OWNER AND CONS.OWNER ='" + this.currentDb + "'" + " ORDER BY COLS.POSITION";
        object3 = null;
        tableSchema.UniqueKeys = new ArrayList();
        try {
            statement = this.conn.createStatement();
            object2 = statement.executeQuery(string4);
            while (object2.next()) {
                object = object2.getString("CONSTRAINT_NAME");
                if (object3 == null || !((ForeignServer.UniqueConstraint)object3).UniqueConstraintName.equals(object)) {
                    object3 = new ForeignServer.UniqueConstraint();
                    ((ForeignServer.UniqueConstraint)object3).UniqueConstraintColumns = new ArrayList();
                    tableSchema.UniqueKeys.add((ForeignServer.UniqueConstraint)object3);
                    ((ForeignServer.UniqueConstraint)object3).UniqueConstraintName = object;
                }
                string3 = object2.getString("COLUMN_NAME");
                ((ForeignServer.UniqueConstraint)object3).UniqueConstraintColumns.add(string3);
            }
            object2.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        tableSchema.ForeignKeys = new ArrayList();
        string4 = "SELECT CONS.CONSTRAINT_NAME, CONS.TABLE_NAME TO_TABLE, COLS.COLUMN_NAME TO_COLUMN, COLS_P.TABLE_NAME TABLE_NAME, COLS_P.COLUMN_NAME FROM_COLUMN  FROM ALL_CONSTRAINTS CONS  LEFT OUTER JOIN ALL_CONS_COLUMNS COLS_P ON  COLS_P.CONSTRAINT_NAME = CONS.R_CONSTRAINT_NAME, ALL_CONS_COLUMNS COLS WHERE CONS.OWNER = '" + this.currentDb + "'" + " AND COLS.TABLE_NAME = '" + string + "'" + " AND COLS.CONSTRAINT_NAME = CONS.CONSTRAINT_NAME " + " AND CONS.R_CONSTRAINT_NAME IS NOT NULL" + "  ORDER BY COLS.POSITION";
        try {
            object2 = null;
            statement = this.conn.createStatement();
            object = statement.executeQuery(string4);
            while (object.next()) {
                string3 = object.getString("CONSTRAINT_NAME");
                if (object2 == null || !((ForeignServer.ForeignKey)object2).ForeignConstraintName.equals(string3)) {
                    object2 = new ForeignServer.ForeignKey();
                    ((ForeignServer.ForeignKey)object2).Columns = new ArrayList();
                    ((ForeignServer.ForeignKey)object2).RefColumns = new ArrayList();
                    tableSchema.ForeignKeys.add((ForeignServer.ForeignKey)object2);
                    ((ForeignServer.ForeignKey)object2).ForeignConstraintName = string3;
                }
                String string6 = object.getString("FROM_COLUMN");
                ((ForeignServer.ForeignKey)object2).RefColumns.add(string6);
                string6 = object.getString("TO_COLUMN");
                ((ForeignServer.ForeignKey)object2).Columns.add(string6);
                ((ForeignServer.ForeignKey)object2).RefTable = string6 = object.getString("TABLE_NAME");
                ((ForeignServer.ForeignKey)object2).Table = string6 = object.getString("TO_TABLE");
            }
            object.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        string4 = "SELECT COLS.COLUMN_NAME, COLS.CONSTRAINT_NAME, SEARCH_CONDITION FROM ALL_CONSTRAINTS CONS, ALL_CONS_COLUMNS COLS WHERE COLS.TABLE_NAME = '" + string + "' AND CONS.CONSTRAINT_TYPE ='C' AND COLS.CONSTRAINT_NAME = CONS.CONSTRAINT_NAME" + " AND CONS.OWNER = COLS.OWNER AND CONS.OWNER ='" + this.currentDb + "'";
        tableSchema.CheckConstraints = new ArrayList();
        try {
            statement = this.conn.createStatement();
            object2 = statement.executeQuery(string4);
            while (object2.next()) {
                object = new ForeignServer.CheckConstraint();
                ((ForeignServer.CheckConstraint)object).ConstraintName = string3 = object2.getString("CONSTRAINT_NAME");
                ((ForeignServer.CheckConstraint)object).ColumnName = string3 = object2.getString("COLUMN_NAME");
                string3 = object2.getString("SEARCH_CONDITION");
                if (string3.startsWith("(")) {
                    string3 = string3.substring(1);
                    string3 = string3.substring(0, string3.length() - 1);
                }
                string3 = string3.replace('[', '\"');
                ((ForeignServer.CheckConstraint)object).CheckClause = string3 = string3.replace(']', '\"');
                tableSchema.CheckConstraints.add((ForeignServer.CheckConstraint)object);
            }
            object2.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        string4 = "EXEC SP_HELPINDEX '" + string + "'";
        tableSchema.Indexes = new ArrayList();
        string4 = "SELECT INDEX_NAME, COLUMN_NAME, COLUMN_POSITION, DESCEND FROM ALL_IND_COLUMNS WHERE TABLE_OWNER = '" + this.currentDb + "'" + " AND TABLE_NAME = '" + string + "'" + " ORDER BY INDEX_NAME, COLUMN_POSITION";
        try {
            statement = this.conn.createStatement();
            object2 = statement.executeQuery(string4);
            object = null;
            while (object2.next()) {
                string3 = object2.getString("INDEX_NAME");
                String string7 = object2.getString("COLUMN_NAME");
                string2 = object2.getString("DESCEND");
                bl2 = false;
                if (object == null || !((ForeignServer.IndexSchema)object).IndexName.equals(string3)) {
                    object = new ForeignServer.IndexSchema();
                    ((ForeignServer.IndexSchema)object).IndexName = string3;
                    ((ForeignServer.IndexSchema)object).Columns = new ArrayList();
                    if (string3.equals(tableSchema.PrimaryKeyConstraintName)) {
                        bl2 = true;
                    }
                    for (ForeignServer.UniqueConstraint uniqueConstraint : tableSchema.UniqueKeys) {
                        if (!uniqueConstraint.UniqueConstraintName.equals(string3)) continue;
                        bl2 = true;
                    }
                    if (!bl2) {
                        tableSchema.Indexes.add((ForeignServer.IndexSchema)object);
                    }
                }
                ForeignServer.IndexColumn indexColumn = new ForeignServer.IndexColumn();
                indexColumn.ColumnName = string7;
                indexColumn.IsAscending = string2.equals("ASC");
                ((ForeignServer.IndexSchema)object).Columns.add(indexColumn);
            }
            object2.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        return tableSchema;
    }

    private ForeignServer.IndexSchema buildIndexSchema(String string, String string2, String string3) {
        String[] stringArray;
        ForeignServer.IndexSchema indexSchema = new ForeignServer.IndexSchema();
        indexSchema.IndexName = string;
        String[] stringArray2 = string2.split(",");
        for (String string4 : stringArray2) {
            if (!string4.trim().equals("unique")) continue;
            indexSchema.IsUnique = true;
            break;
        }
        indexSchema.Columns = new ArrayList();
        Pattern pattern = Pattern.compile("([a-zA-Z_0-9]+)(\\(\\-\\))?");
        for (String string5 : stringArray = string3.split(",")) {
            Matcher matcher = pattern.matcher(string5);
            if (!matcher.find()) {
                Globals.showMessage("Illegal key name [" + string5 + "] in index [" + string + "]", "buildIndexSchema");
            }
            String string6 = matcher.group(1);
            String string7 = matcher.group(2);
            ForeignServer.IndexColumn indexColumn = new ForeignServer.IndexColumn();
            indexColumn.ColumnName = string6;
            indexColumn.IsAscending = string7 == null;
            indexSchema.Columns.add(indexColumn);
        }
        return indexSchema;
    }

    private String fixDefaultValueString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '\'' && n == -1) {
                n = i;
            }
            if (string2.charAt(i) != '\'' || n == -1 || i <= n2) continue;
            n2 = i;
        }
        if (n != -1 && n2 > n) {
            String string3 = string2.substring(n + 1, n2);
            return string3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '(' || string2.charAt(i) == ')') continue;
            stringBuilder.append(string2.charAt(i));
        }
        return stringBuilder.toString();
    }

    private String adjustDefaultValue(String string) {
        return string;
    }

    @Override
    public ForeignServer.ViewSchema createViewSchema(String string) {
        String string2 = "SELECT VIEW_NAME, TEXT, READ_ONLY FROM ALL_VIEWS where OWNER = '" + this.currentDb + "' AND VIEW_NAME = '" + string + "'";
        ForeignServer.ViewSchema viewSchema = new ForeignServer.ViewSchema();
        Globals.appFrame.objNameLabel.setText("Creating Schema for View " + string);
        try {
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string3;
                viewSchema.ViewColumns = new ArrayList();
                viewSchema.ViewName = string3 = resultSet.getString("VIEW_NAME");
                string3 = resultSet.getString("TEXT");
                int n = string3.indexOf(" AS ");
                if (n > 0) {
                    string3 = string3.substring(n + 2);
                }
                if (string3.endsWith(")")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                viewSchema.ViewDefinition = string3;
                string3 = resultSet.getString("READ_ONLY");
                viewSchema.IsUpdatable = !string3.equals("N");
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        return viewSchema;
    }

    @Override
    public ForeignServer.SynonymSchema createSynonymSchema(String string) {
        String string2 = "SELECT TABLE_NAME FROM ALL_SYNONYMS WHERE OWNER = '" + this.currentDb + "' AND SYNONYM_NAME = '" + string + "'";
        ForeignServer.SynonymSchema synonymSchema = new ForeignServer.SynonymSchema();
        Globals.appFrame.objNameLabel.setText("Creating Synonym " + string);
        try {
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string3;
                synonymSchema.SynonymName = string;
                synonymSchema.ReferredObject = string3 = resultSet.getString("TABLE_NAME");
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        return synonymSchema;
    }

    @Override
    public ArrayList<String> readServerTables(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.getConnectionString();
        try {
            this.conn = DriverManager.getConnection(string2);
            String string3 = "SELECT TABLE_NAME FROM ALL_TABLES WHERE OWNER = '" + string + "' ORDER BY TABLE_NAME";
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            this.conn.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readServerTables");
        }
        return arrayList;
    }

    @Override
    public ArrayList<String> readServerViews(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.getConnectionString();
        try {
            this.conn = DriverManager.getConnection(string2);
            String string3 = "SELECT VIEW_NAME FROM ALL_VIEWS WHERE OWNER = '" + string + "' ORDER BY VIEW_NAME";
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            this.conn.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readServerViews");
        }
        return arrayList;
    }

    @Override
    public ArrayList<String> readServerSynonyms(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.getConnectionString();
        try {
            this.conn = DriverManager.getConnection(string2);
            String string3 = "SELECT SYNONYM_NAME FROM ALL_SYNONYMS WHERE OWNER = '" + string + "' ORDER BY SYNONYM_NAME";
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            this.conn.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readServerSynonyms");
        }
        return arrayList;
    }

    @Override
    public void stopConversion(boolean bl) {
        this.cancelled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean copyRows(String string, ForeignServer.TableSchema tableSchema, boolean bl, BufferedWriter bufferedWriter) {
        int n;
        boolean bl2;
        block30: {
            bl2 = true;
            n = 0;
            int n3 = 0;
            String string2 = "select count(*) from \"" + this.currentDb + "\".\"" + tableSchema.TableName + "\"";
            ResultSet resultSet = null;
            Statement statement = null;
            StringBuilder stringBuilder = null;
            try {
                statement = this.conn.createStatement();
                resultSet = statement.executeQuery(string2);
                resultSet.next();
                n = resultSet.getInt(1) + 1;
                n3 = n / 100 + 1;
                Globals.appFrame.importProgressBar.setMaximum(n);
                Globals.appFrame.importProgressBar.setValue(0);
            }
            catch (SQLException sQLException) {
                boolean n2 = this.showException(sQLException, "Source");
                if (!n2) {
                    boolean bl3 = bl2;
                    return bl3;
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(OracleServer.class.getName()).log(Level.SEVERE, null, sQLException);
                    }
                }
            }
            String string3 = this.buildServerTableQuery(tableSchema);
            try {
                statement = this.conn.createStatement();
                resultSet = statement.executeQuery(string3);
                boolean sQLException = false;
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                while (resultSet.next()) {
                    void var13_18;
                    stringBuilder = new StringBuilder(string);
                    if (this.cancelled) {
                        resultSet.close();
                        statement.close();
                        return bl2;
                    }
                    try {
                        for (int iOException = 1; iOException <= n2; ++iOException) {
                            if (iOException > 1) {
                                stringBuilder.append(",");
                            }
                            int n4 = resultSetMetaData.getColumnType(iOException);
                            String string4 = null;
                            if (n4 != 2004 && n4 != -4 && (string4 = resultSet.getString(iOException)) != null) {
                                string4 = string4.replace("'", "''");
                                string4 = "'" + string4 + "'";
                            }
                            if (resultSet.wasNull()) {
                                stringBuilder.append("NULL");
                                continue;
                            }
                            stringBuilder.append(string4);
                        }
                    }
                    catch (SQLException sQLException2) {
                        try {
                            bufferedWriter.write(sQLException2.getMessage());
                            bufferedWriter.newLine();
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(OracleServer.class.getName()).log(Level.SEVERE, null, iOException);
                        }
                    }
                    try {
                        stringBuilder.append(")");
                        bufferedWriter.write(stringBuilder.toString());
                        bufferedWriter.write(";");
                        bufferedWriter.newLine();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(OracleServer.class.getName()).log(Level.SEVERE, null, iOException);
                    }
                    if (++var13_18 % n3 != false) continue;
                    Globals.appFrame.importProgressBar.setValue((int)var13_18);
                }
                resultSet.close();
                statement.close();
            }
            catch (SQLException sQLException) {
                if (this.showException(sQLException, "Source")) break block30;
                bl2 = false;
            }
        }
        Globals.appFrame.importProgressBar.setValue(n);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyRows(PreparedStatement preparedStatement, ForeignServer.TableSchema tableSchema, boolean bl, StringBuilder stringBuilder) {
        int n;
        boolean bl2;
        block26: {
            bl2 = true;
            n = 0;
            int n2 = 0;
            String string = "select count(*) from \"" + this.currentDb + "\".\"" + tableSchema.TableName + "\"";
            ResultSet resultSet = null;
            Statement statement = null;
            try {
                statement = this.conn.createStatement();
                resultSet = statement.executeQuery(string);
                resultSet.next();
                n = resultSet.getInt(1) + 1;
                n2 = n / 100 + 1;
                Globals.appFrame.importProgressBar.setMaximum(n);
                Globals.appFrame.importProgressBar.setValue(0);
            }
            catch (SQLException sQLException) {
                boolean bl3 = this.showException(sQLException, "Source");
                if (!bl3) {
                    boolean bl4 = bl2;
                    return bl4;
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(OracleServer.class.getName()).log(Level.SEVERE, null, sQLException);
                    }
                }
            }
            String string2 = this.buildServerTableQuery(tableSchema);
            try {
                ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
                statement = this.conn.createStatement();
                resultSet = statement.executeQuery(string2);
                int n3 = 0;
                while (resultSet.next()) {
                    if (this.cancelled) {
                        resultSet.close();
                        statement.close();
                        return bl2;
                    }
                    try {
                        int n4 = parameterMetaData.getParameterCount();
                        for (int i = 1; i <= n4; ++i) {
                            int n5 = parameterMetaData.getParameterType(i);
                            Object object = null;
                            object = n5 == 91 ? resultSet.getDate(i) : (n5 == 93 ? resultSet.getTimestamp(i) : resultSet.getObject(i));
                            if (object != null) {
                                if (object instanceof Clob) {
                                    object = resultSet.getAsciiStream(i);
                                }
                                if (object instanceof Blob) {
                                    object = resultSet.getBinaryStream(i);
                                }
                                preparedStatement.setObject(i, object);
                                continue;
                            }
                            preparedStatement.setNull(i, parameterMetaData.getParameterType(i));
                        }
                        preparedStatement.execute();
                    }
                    catch (SQLException sQLException) {
                        stringBuilder.append("Insertion of Row # ").append(n3 + 1).append(" in Table \"").append(tableSchema.TableName).append("\" returned the following error : ").append(sQLException.getErrorCode()).append(" = ").append(sQLException.getMessage()).append("\n");
                    }
                    if (++n3 % n2 != 0) continue;
                    Globals.appFrame.importProgressBar.setValue(n3);
                }
                resultSet.close();
                statement.close();
            }
            catch (SQLException sQLException) {
                if (this.showException(sQLException, "Source")) break block26;
                bl2 = false;
            }
        }
        Globals.appFrame.importProgressBar.setValue(n);
        return bl2;
    }

    private String buildServerTableQuery(ForeignServer.TableSchema tableSchema) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        for (int i = 0; i < tableSchema.Columns.size(); ++i) {
            if (tableSchema.Columns.get((int)i).IsIdentity) continue;
            stringBuilder.append("").append(tableSchema.Columns.get((int)i).ColumnName).append("");
            if (i >= tableSchema.Columns.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(" FROM \"").append(this.currentDb).append("\".\"").append(tableSchema.TableName).append("\"");
        return stringBuilder.toString();
    }

    public boolean showException(Exception exception, String string) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        int n = JOptionPane.showConfirmDialog(jFrame, "\n\nError Description : " + exception.getMessage() + "\n\nDo you want to proceed ?", string, 0, 0);
        return n == 0;
    }

    private boolean showException(SQLException sQLException, String string) {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        Toolkit.getDefaultToolkit().beep();
        int n = JOptionPane.showConfirmDialog(jFrame, string + " Server Error : " + sQLException.getErrorCode() + "\n\nDescription : " + sQLException.getMessage() + "\n\nDo you want to proceed ?", string + " Server Error", 0, 0);
        return n == 0;
    }

    @Override
    public boolean isConnected() {
        try {
            return !this.conn.isClosed();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(MsSqlServer.class.getName()).log(Level.SEVERE, null, sQLException);
            return false;
        }
    }

    @Override
    public String getCurrentDb() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

