/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.Helper.Editors.FcBooleanCellEditor;
import FairCom.Helper.Renderers.FcBooleanCellRenderer;
import ctreeaceexplorer.Globals;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class Parameters
extends JDialog {
    ParametersTable paramTable = new ParametersTable();
    ArrayList<String> params = new ArrayList();
    int parameterCount;
    boolean exitOK = false;
    boolean inMode = false;
    private JButton cancelButton;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JButton okButton;
    private JTable pTable;

    public Parameters(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.setIconImage(Globals.getIcon("Table.png").getImage());
        this.jScrollPane1.setViewportView((Component)((Object)this.paramTable));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.pTable = new JTable();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Parameters Editor");
        this.jScrollPane1.setName("jScrollPane1");
        this.pTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Index / Name", "Value", "Set Null"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, Boolean.class};
                this.canEdit = new boolean[]{false, true, true};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.pTable.setName("pTable");
        this.jScrollPane1.setViewportView(this.pTable);
        this.jPanel1.setName("jPanel1");
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Parameters.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Parameters.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(81, 81, 81).addComponent(this.okButton, -2, 72, -2).addGap(45, 45, 45).addComponent(this.cancelButton, -2, 75, -2).addContainerGap(78, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 351, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.jScrollPane1, -1, 208, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        if (this.inMode) {
            ParametersTableModel parametersTableModel = this.paramTable.getModel();
            if (this.paramTable.getCellEditor() != null) {
                this.paramTable.getCellEditor().stopCellEditing();
            }
            for (int i = 0; i < parametersTableModel.getRowCount(); ++i) {
                String string = (String)parametersTableModel.getValueAt(i, 1);
                Boolean bl = (Boolean)parametersTableModel.getValueAt(i, 2);
                if (bl.booleanValue()) {
                    this.params.set(i, null);
                    continue;
                }
                this.params.set(i, string);
            }
        }
        this.exitOK = true;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.exitOK = false;
        this.setVisible(false);
    }

    public boolean showDialog(ArrayList<String> arrayList, boolean bl) {
        this.inMode = bl;
        ParametersTableModel parametersTableModel = this.paramTable.getModel();
        boolean bl2 = false;
        int n = 0;
        if (!bl) {
            this.setTitle("Output Parameters");
            parametersTableModel.setColumnHeaderText(2, "Is Null");
            this.cancelButton.setEnabled(false);
        }
        this.params = arrayList;
        for (String string : arrayList) {
            bl2 = true;
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add(n++);
            if (bl) {
                arrayList2.add("");
                arrayList2.add(false);
            } else {
                arrayList2.add(string);
                if (string == null) {
                    arrayList2.add(true);
                } else {
                    arrayList2.add(false);
                }
            }
            parametersTableModel.addRow(arrayList2);
        }
        parametersTableModel.fireTableDataChanged();
        this.getRootPane().setDefaultButton(this.okButton);
        if (bl2) {
            this.setVisible(true);
        }
        return this.exitOK;
    }

    public class ParametersTableModel
    extends FcBaseTableModel {
        ParametersTable table;

        public ParametersTableModel(ParametersTable parametersTable) {
            super((FcBaseDynamicTable)parametersTable, false);
            this.table = parametersTable;
            this.showNullAsEmpty = true;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"Index", "Value", "Set Null"};
            Integer[] integerArray = new Integer[]{4, 1, 1};
            this.clearTable();
            this.addColumns(stringArray, integerArray);
            this.autoSizeColumns.set(1, true);
            this.readOnlyColumns.set(0, true);
            super.fireTableStructureChanged();
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(20);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(70);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(50);
            tableColumn.setCellRenderer((TableCellRenderer)new FcBooleanCellRenderer(false));
            tableColumn.setCellEditor((TableCellEditor)new FcBooleanCellEditor(false));
        }

        public boolean isCellEditable(int n, int n2) {
            if (!Parameters.this.inMode) {
                return false;
            }
            if (((Boolean)this.readOnlyColumns.get(n2)).booleanValue()) {
                return false;
            }
            return !this.isReadOnly();
        }

        public void setColumnHeaderText(int n, String string) {
            this.columnsName.set(n, string);
            super.fireTableStructureChanged();
        }
    }

    public class ParametersTable
    extends FcBaseDynamicTable {
        ParametersTableModel model;

        public ParametersTable() {
            this.model = new ParametersTableModel(this);
            this.setModel((TableModel)((Object)this.model));
            this.model.setReadOnly(false);
            this.model.setupColumns();
        }

        public ParametersTableModel getModel() {
            return this.model;
        }
    }
}

