/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

abstract class QEPAVLTree {
    protected int height = 0;
    protected QEPAVLTree lchild = null;
    protected QEPAVLTree rchild = null;

    protected QEPAVLTree() {
    }

    protected QEPAVLTree insert(QEPAVLTree qEPAVLTree) {
        int n = this.compare(qEPAVLTree);
        if (n > 0) {
            this.lchild = this.lchild != null ? this.lchild.insert(qEPAVLTree) : qEPAVLTree;
        } else if (n < 0) {
            this.rchild = this.rchild != null ? this.rchild.insert(qEPAVLTree) : qEPAVLTree;
        } else {
            this.insertDuplicate(qEPAVLTree);
        }
        QEPAVLTree qEPAVLTree2 = this;
        if (Math.abs(QEPAVLTree.heightOf(this.lchild) - QEPAVLTree.heightOf(this.rchild)) > 1) {
            qEPAVLTree2 = n > 0 ? (this.lchild.compare(qEPAVLTree) > 0 ? this.singleLeftRotation(qEPAVLTree2) : this.doubleLeftRotation(qEPAVLTree2)) : (this.rchild.compare(qEPAVLTree) < 0 ? this.singleRightRotation(qEPAVLTree2) : this.doubleRightRotation(qEPAVLTree2));
        } else {
            this.height = Math.max(QEPAVLTree.heightOf(this.lchild), QEPAVLTree.heightOf(this.rchild)) + 1;
        }
        return qEPAVLTree2;
    }

    protected static int heightOf(QEPAVLTree qEPAVLTree) {
        return qEPAVLTree == null ? -1 : qEPAVLTree.height;
    }

    protected QEPAVLTree singleLeftRotation(QEPAVLTree qEPAVLTree) {
        QEPAVLTree qEPAVLTree2 = qEPAVLTree.lchild;
        QEPAVLTree qEPAVLTree3 = qEPAVLTree2.lchild;
        QEPAVLTree qEPAVLTree4 = qEPAVLTree2.rchild;
        qEPAVLTree2.rchild = qEPAVLTree;
        qEPAVLTree.lchild = qEPAVLTree4;
        qEPAVLTree.height = Math.max(QEPAVLTree.heightOf(qEPAVLTree.lchild), QEPAVLTree.heightOf(qEPAVLTree.rchild)) + 1;
        qEPAVLTree2.height = Math.max(QEPAVLTree.heightOf(qEPAVLTree), QEPAVLTree.heightOf(qEPAVLTree3)) + 1;
        return qEPAVLTree2;
    }

    protected QEPAVLTree doubleLeftRotation(QEPAVLTree qEPAVLTree) {
        QEPAVLTree qEPAVLTree2 = qEPAVLTree.lchild;
        QEPAVLTree qEPAVLTree3 = qEPAVLTree2.rchild;
        QEPAVLTree qEPAVLTree4 = qEPAVLTree3.lchild;
        QEPAVLTree qEPAVLTree5 = qEPAVLTree3.rchild;
        qEPAVLTree3.lchild = qEPAVLTree2;
        qEPAVLTree3.rchild = qEPAVLTree;
        qEPAVLTree2.rchild = qEPAVLTree4;
        qEPAVLTree.lchild = qEPAVLTree5;
        qEPAVLTree.height = Math.max(QEPAVLTree.heightOf(qEPAVLTree.lchild), QEPAVLTree.heightOf(qEPAVLTree.rchild)) + 1;
        qEPAVLTree2.height = Math.max(QEPAVLTree.heightOf(qEPAVLTree2.lchild), QEPAVLTree.heightOf(qEPAVLTree2.rchild)) + 1;
        qEPAVLTree3.height = Math.max(QEPAVLTree.heightOf(qEPAVLTree), QEPAVLTree.heightOf(qEPAVLTree2)) + 1;
        return qEPAVLTree3;
    }

    protected QEPAVLTree singleRightRotation(QEPAVLTree qEPAVLTree) {
        QEPAVLTree qEPAVLTree2 = qEPAVLTree.rchild;
        QEPAVLTree qEPAVLTree3 = qEPAVLTree2.rchild;
        QEPAVLTree qEPAVLTree4 = qEPAVLTree2.lchild;
        qEPAVLTree2.lchild = qEPAVLTree;
        qEPAVLTree.rchild = qEPAVLTree4;
        qEPAVLTree.height = Math.max(QEPAVLTree.heightOf(qEPAVLTree.lchild), QEPAVLTree.heightOf(qEPAVLTree.rchild)) + 1;
        qEPAVLTree2.height = Math.max(QEPAVLTree.heightOf(qEPAVLTree), QEPAVLTree.heightOf(qEPAVLTree3)) + 1;
        return qEPAVLTree2;
    }

    protected QEPAVLTree doubleRightRotation(QEPAVLTree qEPAVLTree) {
        QEPAVLTree qEPAVLTree2 = qEPAVLTree.rchild;
        QEPAVLTree qEPAVLTree3 = qEPAVLTree2.lchild;
        QEPAVLTree qEPAVLTree4 = qEPAVLTree3.lchild;
        QEPAVLTree qEPAVLTree5 = qEPAVLTree3.rchild;
        qEPAVLTree3.rchild = qEPAVLTree2;
        qEPAVLTree3.lchild = qEPAVLTree;
        qEPAVLTree2.lchild = qEPAVLTree5;
        qEPAVLTree.rchild = qEPAVLTree4;
        qEPAVLTree.height = Math.max(QEPAVLTree.heightOf(qEPAVLTree.lchild), QEPAVLTree.heightOf(qEPAVLTree.rchild)) + 1;
        qEPAVLTree2.height = Math.max(QEPAVLTree.heightOf(qEPAVLTree2.lchild), QEPAVLTree.heightOf(qEPAVLTree2.rchild)) + 1;
        qEPAVLTree3.height = Math.max(QEPAVLTree.heightOf(qEPAVLTree), QEPAVLTree.heightOf(qEPAVLTree2)) + 1;
        return qEPAVLTree3;
    }

    protected void printTree() {
        if (this.lchild != null) {
            this.lchild.printTree();
        }
        this.visitNode();
        if (this.rchild != null) {
            this.rchild.printTree();
        }
    }

    protected abstract int compare(QEPAVLTree var1);

    protected abstract void insertDuplicate(QEPAVLTree var1);

    protected abstract void visitNode();
}

