/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public final class QEPHelpers {
    public static final Toolkit toolkit = Toolkit.getDefaultToolkit();

    public static void drawDashedRect(Graphics graphics, int n, int n2, int n3, int n4) {
        for (int i = n; i < n + n3; i += 2) {
            graphics.fillRect(i, n2, 1, 1);
            graphics.fillRect(i, n2 + n4 - 1, 1, 1);
        }
        for (int i = n2; i < n2 + n4; i += 2) {
            graphics.fillRect(n, i, 1, 1);
            graphics.fillRect(n + n3 - 1, i, 1, 1);
        }
    }

    public static Point getStartXY(int n, int n2) {
        Dimension dimension = toolkit.getScreenSize();
        int n3 = dimension.width - n >> 1;
        int n4 = dimension.height - n2 >> 1;
        return new Point(n3, n4);
    }

    public static void showMessage(String string, Component component, String string2, int n) {
        JOptionPane jOptionPane = new JOptionPane();
        FontMetrics fontMetrics = jOptionPane.getFontMetrics(jOptionPane.getFont());
        JDialog jDialog = jOptionPane.createDialog(component, string2);
        if (string == null) {
            string = "";
        }
        String[] stringArray = QEPHelpers.split(string, 35 * fontMetrics.charWidth('W'), fontMetrics);
        String string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string3 = string3 + stringArray[i] + "\n";
        }
        jOptionPane.setMessage(string3);
        jOptionPane.setMessageType(n);
        jDialog.setResizable(false);
        jDialog.pack();
        jDialog.setVisible(true);
    }

    public static String[] concat(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = null;
        if (stringArray == null && stringArray2 == null) {
            return null;
        }
        if (stringArray == null) {
            stringArray3 = stringArray2;
        } else if (stringArray2 == null) {
            stringArray3 = stringArray;
        } else {
            stringArray3 = new String[stringArray.length + stringArray2.length];
            for (int i = 0; i < stringArray3.length; ++i) {
                stringArray3[i] = i < stringArray.length ? stringArray[i] : stringArray2[i - stringArray.length];
            }
        }
        return stringArray3;
    }

    public static String[] split(String string, int n, FontMetrics fontMetrics) {
        String string2;
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while ((string2 = QEPHelpers.getLine(string, n2, n, fontMetrics)) != null) {
            arrayList.add(string2);
            n2 += string2.length();
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    protected static String getLine(String string, int n, int n2, FontMetrics fontMetrics) {
        String string2 = "";
        String string3 = "";
        int n3 = 0;
        int n4 = 0;
        while ((string3 = QEPHelpers.getWord(string, n)) != null && n3 + (n4 = fontMetrics.stringWidth(string3)) <= n2) {
            string2 = string2 + string3;
            n3 += n4;
            n += string3.length();
        }
        if (string3 != null && string2.equals("")) {
            string2 = string3;
        }
        return string2.equals("") ? null : string2;
    }

    protected static String getWord(String string, int n) {
        String string2 = "";
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n++);
            string2 = string2 + c;
            if (" \t\n.,()".indexOf(c) == -1) continue;
        }
        return string2.equals("") ? null : string2;
    }

    public static void addKeyListener(Component component, KeyListener keyListener) {
        QEPHelpers.addKeyListener(component, keyListener, false);
    }

    public static void addKeyListener(Component component, KeyListener keyListener, boolean bl) {
        if (component == null) {
            return;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            Component component2 = null;
            for (int i = container.getComponentCount() - 1; i >= 0; --i) {
                component2 = container.getComponent(i);
                if (bl) {
                    QEPHelpers.addKeyListener(component2, keyListener, true);
                    continue;
                }
                component2.addKeyListener(keyListener);
            }
        }
        component.addKeyListener(keyListener);
    }
}

