/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import ctreeaceexplorer.CtreeACEExplorerView;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.sql.QEPDIDXSupportList;
import ctreeaceexplorer.sql.QEPHelpers;
import ctreeaceexplorer.sql.QEPNodeTypes;
import ctreeaceexplorer.sql.QEPOpSupportList;
import ctreeaceexplorer.sql.QEPPFSupportList;
import ctreeaceexplorer.sql.QEPProjectSupportList;
import ctreeaceexplorer.sql.QEPSfnSupportList;
import ctreeaceexplorer.sql.QEPSortBySupportList;
import ctreeaceexplorer.sql.QEPSupportList;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

class QEPTree {
    protected int nodeType;
    protected int nodeID;
    protected int parentID;
    protected float cost;
    protected float card;
    protected int width;
    protected int lWidth;
    protected int rWidth;
    protected QEPSupportList lSuppList;
    protected QEPSupportList rSuppList;
    protected ArrayList<Integer> lSuppNodeIDs;
    protected ArrayList<Integer> rSuppNodeIDs;
    protected QEPTree lchild;
    protected QEPTree rchild;

    protected QEPTree(int n, int n2, int n3, float f, float f2) {
        this.nodeType = n;
        this.nodeID = n2;
        this.parentID = n3;
        this.cost = f;
        this.card = f2;
        this.width = 0;
        this.lWidth = 1;
        this.rWidth = 1;
        this.lSuppList = null;
        this.rSuppList = null;
        this.lSuppNodeIDs = new ArrayList();
        this.rSuppNodeIDs = new ArrayList();
        this.lchild = null;
        this.rchild = null;
    }

    protected QEPTree(CtreeACEExplorerView ctreeACEExplorerView, String string, String string2, String string3) {
        QEPTree qEPTree = null;
        this.width = 0;
        this.lWidth = 1;
        this.rWidth = 1;
        this.lSuppList = null;
        this.rSuppList = null;
        this.lSuppNodeIDs = new ArrayList();
        this.rSuppNodeIDs = new ArrayList();
        this.lchild = null;
        this.rchild = null;
        try {
            ResultSet resultSet = Globals.currentSqlConnection.execRsQuery("select node_type, node_id, parent_id, is_supportive, cost, cardinality, node_info, child_number from " + string + "." + string2 + " where query_id = " + string3);
            QEPTree qEPTree2 = null;
            block13: while (resultSet.next()) {
                String string4;
                this.nodeType = QEPNodeTypes.getNodeType(resultSet.getString(1));
                this.nodeID = resultSet.getInt(2);
                this.parentID = resultSet.getInt(3);
                String string5 = resultSet.getString(4);
                boolean bl = string5 != null && string5.equals("Y");
                this.cost = resultSet.getFloat(5);
                this.card = resultSet.getFloat(6);
                if (this.nodeType == 0) {
                    string4 = resultSet.getString(7);
                    if (string4 == null || !string4.equalsIgnoreCase("*")) continue;
                    this.nodeType = 16;
                }
                if (!bl) {
                    qEPTree2 = new QEPTree(this.nodeType, this.nodeID, this.parentID, this.cost, this.card);
                    if (qEPTree != null) {
                        qEPTree.insert(qEPTree2);
                    } else {
                        qEPTree = qEPTree2;
                    }
                    switch (this.nodeType) {
                        case 4: 
                        case 5: 
                        case 6: {
                            qEPTree.addSuppInfo(new QEPSupportList(this.nodeType, this.nodeID, resultSet.getString(7)), this.nodeID, resultSet.getInt(8));
                            continue block13;
                        }
                    }
                    continue;
                }
                if (qEPTree == null) continue;
                string4 = resultSet.getString(7);
                if (string4 == null) {
                    string4 = "";
                }
                int n = resultSet.getInt(8);
                switch (this.nodeType) {
                    case 18: 
                    case 25: {
                        qEPTree.addSuppInfo(new QEPProjectSupportList(this.nodeType, this.nodeID, string4), this.parentID, n);
                        continue block13;
                    }
                    case 38: {
                        qEPTree.addSuppInfo(new QEPSortBySupportList(this.nodeType, this.nodeID, string4), this.parentID, n);
                        continue block13;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 34: {
                        qEPTree.addSuppInfo(new QEPOpSupportList(this.nodeType, this.nodeID, string4), this.parentID, n);
                        continue block13;
                    }
                    case 15: 
                    case 19: {
                        qEPTree.addSuppInfo(new QEPSfnSupportList(this.nodeType, this.nodeID, string4), this.parentID, n);
                        continue block13;
                    }
                    case 22: 
                    case 24: 
                    case 26: {
                        qEPTree.addSuppInfo(new QEPDIDXSupportList(this.nodeType, this.nodeID, string4), this.parentID, n);
                        continue block13;
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        qEPTree.addSuppInfo(new QEPPFSupportList(this.nodeType, this.nodeID, string4), this.parentID, n);
                        continue block13;
                    }
                }
                qEPTree.addSuppInfo(new QEPSupportList(this.nodeType, this.nodeID, string4), this.parentID, n);
            }
            resultSet.close();
            if (qEPTree != null) {
                qEPTree.replacePexprs();
                qEPTree.formatSuppInfo((Graphics2D)ctreeACEExplorerView.planPanel.getGraphics());
                ctreeACEExplorerView.planPanel.setRoot(qEPTree);
            }
        }
        catch (SQLException sQLException) {
            qEPTree = null;
        }
    }

    protected void insert(QEPTree qEPTree) {
        boolean bl = this.hasRChild();
        if (this.nodeID == qEPTree.parentID) {
            if (bl && this.lchild != null) {
                this.rchild = qEPTree;
            } else {
                this.lchild = qEPTree;
            }
        } else if (bl && this.rchild != null) {
            this.rchild.insert(qEPTree);
        } else if (this.lchild != null) {
            this.lchild.insert(qEPTree);
        } else {
            this.lchild = qEPTree;
        }
        int n = this.width = bl ? Math.max(QEPTree.widthOf(this.lchild), QEPTree.widthOf(this.rchild)) + 1 : QEPTree.widthOf(this.lchild);
        if (bl) {
            this.lWidth = QEPTree.lWidthOf(this.lchild) + QEPTree.rWidthOf(this.lchild);
            this.rWidth = QEPTree.lWidthOf(this.rchild) + QEPTree.rWidthOf(this.rchild);
        } else {
            this.lWidth = QEPTree.lWidthOf(this.lchild);
            this.rWidth = QEPTree.rWidthOf(this.lchild);
        }
    }

    protected static int widthOf(QEPTree qEPTree) {
        return qEPTree == null ? -1 : qEPTree.width;
    }

    protected static int lWidthOf(QEPTree qEPTree) {
        return qEPTree == null ? -1 : qEPTree.lWidth;
    }

    protected static int rWidthOf(QEPTree qEPTree) {
        return qEPTree == null ? -1 : qEPTree.rWidth;
    }

    protected boolean addSuppInfo(QEPSupportList qEPSupportList, int n, int n2) {
        Integer n3 = new Integer(n);
        if (this.nodeID == n) {
            if (qEPSupportList.isLSuppInfo()) {
                if (this.lSuppList != null) {
                    this.lSuppList.add(qEPSupportList);
                } else {
                    this.lSuppList = qEPSupportList;
                }
                this.lSuppNodeIDs.add(new Integer(qEPSupportList.getNodeID()));
            } else {
                if (this.rSuppList != null) {
                    this.rSuppList.add(qEPSupportList);
                } else {
                    this.rSuppList = qEPSupportList;
                }
                this.rSuppNodeIDs.add(new Integer(qEPSupportList.getNodeID()));
            }
        } else if (this.lSuppNodeIDs.contains(n3)) {
            if (!this.lSuppList.addChild(qEPSupportList, n, n2)) {
                this.lSuppList.add(qEPSupportList);
            }
            this.lSuppNodeIDs.add(new Integer(qEPSupportList.getNodeID()));
        } else if (this.rSuppNodeIDs.contains(n3)) {
            if (!this.rSuppList.addChild(qEPSupportList, n, n2)) {
                this.rSuppList.add(qEPSupportList);
            }
            this.rSuppNodeIDs.add(new Integer(qEPSupportList.getNodeID()));
        } else {
            boolean bl = false;
            if (this.lchild != null) {
                bl = this.lchild.addSuppInfo(qEPSupportList, n, n2);
            }
            return !bl && this.rchild != null ? this.rchild.addSuppInfo(qEPSupportList, n, n2) : bl;
        }
        return true;
    }

    protected QEPTree lchild() {
        return this.lchild;
    }

    protected QEPTree rchild() {
        return this.rchild;
    }

    protected int getType() {
        return this.nodeType;
    }

    protected String getTypeStr() {
        switch (this.nodeType) {
            case 1: {
                return "PROJECT";
            }
            case 2: {
                return "RESTRICT";
            }
            case 3: {
                return "JOIN";
            }
            case 4: {
                return "TABLE SCAN";
            }
            case 5: {
                return "REMOTE TABLE SCAN";
            }
            case 6: {
                return "INDEX SCAN";
            }
            case 7: {
                return "SORT";
            }
            case 8: {
                return "DYNAMIC INDEX";
            }
            case 9: {
                return "UNION";
            }
            case 10: {
                return "INTERSECT";
            }
            case 11: {
                return "MINUS";
            }
        }
        return String.valueOf(this.nodeType);
    }

    protected boolean hasRChild() {
        switch (this.nodeType) {
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    protected int getNodeID() {
        return this.nodeID;
    }

    protected float getCost() {
        return this.cost;
    }

    protected float getCard() {
        return this.card;
    }

    protected int drawSuppInfo(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (this.lSuppList != null) {
            n3 = this.lSuppList.drawSuppInfo(graphics, n, n2, true);
        }
        if (this.rSuppList != null) {
            n4 = this.rSuppList.drawSuppInfo(graphics, n, n2, false);
        }
        return n3 > n4 ? n3 : n4;
    }

    protected String[] getToolTipText() {
        switch (this.nodeType) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return this.rSuppList != null ? this.rSuppList.getSuppInfo(this.rSuppList) : null;
            }
            case 3: {
                return this.lSuppList != null ? (this.rSuppList != null ? QEPHelpers.concat(this.lSuppList.getSuppInfo(this.lSuppList), this.rSuppList.getSuppInfo(this.rSuppList)) : this.lSuppList.getSuppInfo(this.lSuppList)) : (this.rSuppList != null ? this.rSuppList.getSuppInfo(this.rSuppList) : null);
            }
            case 7: {
                return this.lSuppList != null ? this.lSuppList.getSuppInfo(this.lSuppList) : null;
            }
            case 9: 
            case 10: 
            case 11: {
                return null;
            }
        }
        return null;
    }

    protected String[] replacePexprs() {
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        if (this.lchild != null) {
            stringArray = this.lchild.replacePexprs();
        }
        if (this.rchild != null) {
            stringArray = QEPHelpers.concat(stringArray, this.rchild.replacePexprs());
        }
        if (this.lSuppList != null) {
            stringArray2 = this.lSuppList.replacePexprs(this.lSuppList, stringArray);
        }
        if (this.rSuppList != null) {
            stringArray3 = this.rSuppList.replacePexprs(this.rSuppList, stringArray);
        }
        switch (this.nodeType) {
            case 1: 
            case 5: {
                return stringArray3 == null ? stringArray : stringArray3;
            }
            case 8: {
                return stringArray2 == null ? stringArray : stringArray2;
            }
        }
        return stringArray;
    }

    protected void formatSuppInfo(Graphics2D graphics2D) {
        graphics2D.scale(1.0, 1.0);
        if (this.lSuppList != null) {
            this.lSuppList.formatSuppInfo(this.lSuppList, graphics2D);
        }
        if (this.rSuppList != null) {
            this.rSuppList.formatSuppInfo(this.rSuppList, graphics2D);
        }
        if (this.lchild != null) {
            this.lchild.formatSuppInfo(graphics2D);
        }
        if (this.rchild != null) {
            this.rchild.formatSuppInfo(graphics2D);
        }
    }
}

