/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import ctreeaceexplorer.sql.QEPAVLTree;
import ctreeaceexplorer.sql.QEPMatrix;
import ctreeaceexplorer.sql.QEPNodeTypes;
import ctreeaceexplorer.sql.QEPTree;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class QEPTreeLbl
extends JPanel {
    QEPTree root;
    boolean firstTime = true;
    protected static final int horzArcLen = 300;
    protected static final int vertArcLen = 50;
    protected static final int nodeWidth = 50;
    protected static final int nodeHeight = 50;
    protected static final Color[] defaultNodeColors = new Color[]{new Color(255, 255, 255), new Color(204, 255, 255), new Color(204, 204, 255), new Color(254, 204, 255), new Color(255, 204, 204), new Color(254, 255, 204), new Color(204, 255, 204), new Color(255, 204, 153), new Color(126, 126, 247), new Color(153, 204, 255), new Color(153, 204, 255), new Color(153, 204, 255)};
    protected JScrollPane sp;
    protected int halfPaneWidth;
    protected QEPMatrix matrix;
    protected boolean updateMatrix;
    protected Color[] nodeColors;
    protected String[] nodeColorKeys;
    protected double zoom = 1.0;
    Point old;

    public QEPTreeLbl() {
        this.setColors();
        this.setBackground(Color.white);
        this.setLocation(0, 0);
        this.setLayout(null);
        this.setFont(new Font("tahoma", 0, 14));
    }

    public void setZoom(double d) {
        this.zoom = d / 100.0;
        this.repaint();
    }

    public void modifyZoom(double d) {
        this.zoom -= d / 10.0;
        this.repaint();
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setRoot(QEPTree qEPTree) {
        this.root = qEPTree;
    }

    protected void setColors() {
        this.nodeColors = new Color[defaultNodeColors.length];
        this.nodeColorKeys = new String[defaultNodeColors.length];
        for (int i = 0; i < this.nodeColors.length; ++i) {
            this.nodeColorKeys[i] = "QEP_" + QEPNodeTypes.getNodeType(i).toUpperCase().replace(' ', '_');
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            this.nodeColors[i] = n3 >= 0 && n3 <= 255 && n2 >= 0 && n2 <= 255 && n >= 0 && n <= 255 ? new Color(n3, n2, n) : defaultNodeColors[i];
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return dimension;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.root == null) {
            return;
        }
        Container container = this.getParent().getParent();
        this.sp = (JScrollPane)container;
        int n = this.getX();
        int n2 = this.sp.getViewportBorderBounds().width >> 1;
        n2 = n2 - n2 % 50 + 25;
        int n3 = n > this.halfPaneWidth ? n : this.halfPaneWidth;
        this.updateMatrix = this.matrix == null;
        ((Graphics2D)graphics).scale(this.zoom, this.zoom);
        graphics.setColor(Color.black);
        Point point = this.drawTree(null, this.root, n3, 50);
        int n4 = n3 = point.x;
        n3 = (int)((double)n3 * 1.5);
        point = this.drawTree(graphics, this.root, n3, 50);
        if (this.firstTime) {
            this.firstTime = false;
            this.repaint();
        }
        ((Graphics2D)graphics).scale(1.0 / this.zoom, 1.0 / this.zoom);
        Dimension dimension = new Dimension(450 + (point.x != n3 ? point.x + 100 : point.x), point.y);
        int n5 = (int)((double)dimension.width * this.zoom);
        int n6 = (int)((double)dimension.height * this.zoom);
        Dimension dimension2 = new Dimension();
        Dimension dimension3 = this.getSize();
        Rectangle rectangle = this.sp.getViewportBorderBounds();
        dimension2.width = n5 > rectangle.width ? n5 : rectangle.width;
        int n7 = dimension2.height = n6 > rectangle.height ? n6 : rectangle.height;
        if (dimension2.width != dimension3.width || dimension2.height != dimension3.height) {
            this.setSize(dimension2);
            this.setPreferredSize(dimension2);
            this.sp.getViewport().setViewPosition(new Point(n4, 0));
            return;
        }
        if (this.halfPaneWidth != n2 || this.updateMatrix) {
            int n8 = (int)(this.zoom * (double)n);
            this.halfPaneWidth = n2;
            Point point2 = new Point(n8 > this.halfPaneWidth && dimension2.width > rectangle.width ? n8 - this.halfPaneWidth : 0, 0);
            this.sp.getViewport().setViewPosition(point2);
            this.updateMatrix = false;
        }
    }

    protected Point drawTree(Graphics graphics, QEPTree qEPTree, int n, int n2) {
        Object object;
        Point point = new Point(n, n2);
        Point point2 = new Point(n, n2);
        if (qEPTree != null) {
            if (this.updateMatrix) {
                object = new QEPMatrix(n - 25, n2, qEPTree);
                this.matrix = this.matrix == null ? object : (QEPMatrix)this.matrix.insert((QEPAVLTree)object);
            }
            object = this.drawNode(graphics, qEPTree, n, n2);
            point = this.drawTree(graphics, qEPTree.lchild(), ((Point)object).x, ((Point)object).y);
            if (qEPTree.hasRChild()) {
                int n3;
                int n4 = 300 * n3 + ((n3 = QEPTree.lWidthOf(qEPTree.rchild())) > 1 ? 50 * n3 >> 1 : 0) + 25;
                n2 = ((Point)object).y;
                point2 = this.drawTree(graphics, qEPTree.rchild(), n += 25 + n4, n2);
            }
        }
        object = new Point(Math.abs(point.x) > Math.abs(point2.x) ? Math.abs(point.x) : Math.abs(point2.x), Math.abs(point.y) > Math.abs(point2.y) ? Math.abs(point.y) : Math.abs(point2.y));
        return object;
    }

    protected Point drawNode(Graphics graphics, QEPTree qEPTree, int n, int n2) {
        int n3 = qEPTree.drawSuppInfo(graphics, n, n2);
        switch (qEPTree.getType()) {
            case 1: {
                return this.drawProject(graphics, n, n2, n3);
            }
            case 2: {
                return this.drawRestrict(graphics, n, n2, n3);
            }
            case 3: {
                return this.drawJoin(graphics, qEPTree, n, n2, n3);
            }
            case 4: 
            case 5: 
            case 6: {
                return this.drawScan(graphics, qEPTree.getType(), n, n2, n3);
            }
            case 7: {
                return this.drawSort(graphics, n, n2, n3);
            }
            case 8: {
                return this.drawDidx(graphics, n, n2, n3);
            }
            case 9: 
            case 10: 
            case 11: {
                return this.drawSetop(graphics, qEPTree, n, n2, n3);
            }
        }
        return new Point(n, n2);
    }

    protected Point drawProject(Graphics graphics, int n, int n2, int n3) {
        int n4 = 50;
        int n5 = 40;
        int n6 = n4 >> 1;
        int n7 = n5 >> 1;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = n;
        nArray2[0] = n2;
        nArray[1] = n - n6;
        nArray2[1] = nArray2[0] + n5;
        nArray[2] = n + n6;
        nArray2[2] = nArray2[0] + n5;
        if (graphics != null) {
            graphics.setColor(this.nodeColors[1]);
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(Color.black);
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.drawLine(n, nArray2[1], n, nArray2[1] + 10 + 50 * (n3 + 1));
        }
        return new Point(n, nArray2[1] + 10 + 50 * (n3 + 1));
    }

    protected Point drawRestrict(Graphics graphics, int n, int n2, int n3) {
        int n4 = 40;
        int n5 = 50;
        int n6 = n4 >> 1;
        int n7 = n5 >> 1;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (graphics != null) {
            graphics.drawLine(n, n2, n, n2 + (n7 >> 1));
        }
        nArray[0] = n + n6;
        nArray2[0] = n2 + n7;
        nArray[1] = nArray[0] - n4;
        nArray2[1] = n2;
        nArray[2] = nArray[0] - n4;
        nArray2[2] = n2 + n5;
        if (graphics != null) {
            graphics.setColor(this.nodeColors[2]);
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(Color.black);
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.drawLine(n, n2 + (3 * n7 >> 1) + 1, n, nArray2[2] + 50 * (n3 + 1));
        }
        return new Point(n, nArray2[2] + 50 * (n3 + 1));
    }

    protected Point drawJoin(Graphics graphics, QEPTree qEPTree, int n, int n2, int n3) {
        int n4;
        int n5 = 50;
        int n6 = 50;
        int n7 = n5 >> 1;
        int n8 = n6 >> 1;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        if (graphics != null) {
            graphics.drawLine(n, n2, n, n2 + n8);
        }
        nArray[0] = n - n7;
        nArray2[0] = n2;
        nArray[1] = nArray[0];
        nArray2[1] = n2 + n6;
        nArray[2] = nArray[0] + n5;
        nArray2[2] = n2;
        nArray[3] = nArray[0] + n5;
        nArray2[3] = n2 + n6;
        if (graphics != null) {
            graphics.setColor(this.nodeColors[3]);
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(Color.black);
            graphics.drawPolygon(nArray, nArray2, nArray.length);
        }
        n2 += n6;
        if (graphics != null) {
            graphics.drawLine(nArray[0], n2, nArray[0], n2 + n3 * 50);
            graphics.drawLine(nArray[2], n2, nArray[2], n2 + n3 * 50);
        }
        n2 += n3 * 50;
        int n9 = 300 * n4 + ((n4 = QEPTree.lWidthOf(qEPTree.rchild())) > 1 ? 50 * n4 >> 1 : 0) + 25;
        if (graphics != null) {
            graphics.drawLine(nArray[2] + 1, n2, nArray[2] + n9, n2);
            graphics.drawLine(nArray[2] + n9, n2, nArray[2] + n9, n2 + 50);
        }
        n9 = 300 * n4 + ((n4 = QEPTree.rWidthOf(qEPTree.lchild())) > 1 ? 50 * n4 >> 1 : 0) + 25;
        if (graphics != null) {
            graphics.drawLine(nArray[0] - n9, n2, nArray[0] - 1, n2);
            graphics.drawLine(nArray[0] - n9, n2, nArray[0] - n9, n2 + 50);
        }
        return new Point(nArray[0] - n9, n2 + 50);
    }

    protected Point drawScan(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 50;
        int n6 = 50;
        n2 -= n5 >> 1;
        String string = "";
        switch (n) {
            case 4: {
                string = "T";
                break;
            }
            case 5: {
                string = "R";
                break;
            }
            case 6: {
                string = "I";
            }
        }
        if (graphics != null) {
            graphics.setColor(this.nodeColors[n]);
            graphics.fillArc(n2, n3, n5, n6, 0, 360);
            graphics.setColor(Color.black);
            graphics.drawArc(n2, n3, n5, n6, 0, 360);
            if (string != null && !string.equals("")) {
                Font font = graphics.getFont();
                graphics.setFont(n == 6 ? new Font("times new roman", 1, 30) : font.deriveFont(1, 30.0f));
                FontMetrics fontMetrics = graphics.getFontMetrics();
                graphics.drawString(string, n2 + (n5 - fontMetrics.stringWidth(string) >> 1), n3 + (n6 + fontMetrics.getHeight() >> 1) - fontMetrics.getDescent());
                graphics.setFont(font);
            }
        }
        return new Point(n2, n3 + 50 + 50 * (n4 + 1));
    }

    protected Point drawSetop(Graphics graphics, QEPTree qEPTree, int n, int n2, int n3) {
        int n4;
        int n5 = 50;
        int n6 = 40;
        int n7 = n5 >> 1;
        int n8 = n6 >> 1;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (graphics2D != null) {
            graphics2D.drawLine(n, n2, n, n2 + 5);
        }
        n -= n7;
        n2 += 50 - n6 >> 1;
        if (graphics2D != null) {
            graphics2D.setColor(this.nodeColors[qEPTree.getType()]);
            graphics2D.fillOval(n, n2, n5, n6);
            graphics2D.setColor(Color.black);
            graphics2D.drawOval(n, n2, n5, n6);
            n4 = qEPTree.getType();
            Font font = graphics2D.getFont();
            graphics2D.setFont(font.deriveFont(1, 30.0f));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            if (n4 == 9) {
                String string = "U";
                graphics2D.drawString(string, n + n7 - (fontMetrics.stringWidth(string) >> 1), n2 + n8 + (fontMetrics.getAscent() >> 1));
            } else if (n4 == 10) {
                String string = "U";
                int n9 = n + n7 + (fontMetrics.stringWidth(string) >> 1);
                int n10 = n2 + n8;
                graphics2D.rotate(Math.PI);
                graphics2D.translate(-2 * n9, -2 * n10);
                graphics2D.drawString(string, n9, n10 + (fontMetrics.getAscent() >> 1));
                graphics2D.translate(2 * n9, 2 * n10);
                graphics2D.rotate(Math.PI);
            } else {
                String string = "I";
                graphics2D.rotate(-1.5707963267948966, n + n7, n2 + n8);
                graphics2D.drawString(string, n + n7 - (fontMetrics.stringWidth(string) >> 1) + 1, n2 + n8 + (fontMetrics.getHeight() >> 1) - fontMetrics.getDescent());
                graphics2D.rotate(1.5707963267948966, n + n7, n2 + n8);
            }
            graphics2D.setFont(font);
        }
        n += n5;
        n2 += n8;
        int n11 = 300 * n4 + ((n4 = QEPTree.lWidthOf(qEPTree.rchild())) > 1 ? 50 * n4 >> 1 : 0) + 25;
        if (graphics2D != null) {
            graphics2D.drawLine(n, n2, n + n11, n2);
            graphics2D.drawLine(n + n11, n2, n + n11, n2 + 50 + 25);
        }
        n -= n5;
        n11 = 300 * n4 + ((n4 = QEPTree.rWidthOf(qEPTree.lchild())) > 1 ? 50 * n4 >> 1 : 0) + 25;
        if (graphics2D != null) {
            graphics2D.drawLine(n, n2, n - n11, n2);
            graphics2D.drawLine(n - n11, n2, n - n11, n2 + 50 + 25);
        }
        return new Point(n - n11, n2 + 50 + 25);
    }

    protected Point drawSort(Graphics graphics, int n, int n2, int n3) {
        int n4 = 50;
        int n5 = 50;
        int n6 = n4 >> 1;
        int n7 = n5 >> 1;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = n;
        nArray2[0] = n2;
        nArray[1] = nArray[0] - n6;
        nArray2[1] = nArray2[0] + n7;
        nArray[2] = nArray[0];
        nArray2[2] = nArray2[0] + n5;
        nArray[3] = nArray[0] + n6;
        nArray2[3] = nArray2[0] + n7;
        if (graphics != null) {
            graphics.setColor(this.nodeColors[7]);
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(Color.black);
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.drawLine(n, nArray2[2], n, nArray2[2] + 50 * (n3 + 1));
        }
        return new Point(n, nArray2[2] + 50 * (n3 + 1));
    }

    protected Point drawDidx(Graphics graphics, int n, int n2, int n3) {
        int n4 = 50;
        int n5 = 40;
        int n6 = n4 >> 1;
        int n7 = n5 >> 1;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = n;
        nArray2[0] = n2;
        nArray[1] = n - n6;
        nArray2[1] = nArray2[0] + n5;
        nArray[2] = n + n6;
        nArray2[2] = nArray2[0] + n5;
        if (graphics != null) {
            graphics.setColor(this.nodeColors[8]);
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(Color.black);
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            Font font = graphics.getFont();
            graphics.setFont(font.deriveFont(1, 12.0f));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = "DIDX";
            graphics.drawString(string, nArray[1] + (n4 - fontMetrics.stringWidth(string) >> 1), n2 + (3 * n7 + fontMetrics.getHeight() >> 1) - fontMetrics.getDescent());
            graphics.setFont(font);
            graphics.drawLine(n, nArray2[1], n, nArray2[1] + 10 + 50 * (n3 + 1));
        }
        return new Point(n, nArray2[1] + 10 + 50 * (n3 + 1));
    }

    protected void drawRubberBand() {
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.sp != null) {
            JViewport jViewport = this.sp.getViewport();
            int n = jViewport.getHeight();
            int n2 = jViewport.getWidth();
            int n3 = jViewport.getX();
            Dimension dimension = jViewport.getViewSize();
            int n4 = this.getHeight();
            int n5 = this.getWidth();
            Point point = jViewport.getViewPosition();
            Point point2 = new Point(point);
            int n6 = mouseEvent.getX() - this.old.x;
            int n7 = mouseEvent.getY() - this.old.y;
            if (point.x - n6 >= 0) {
                point.x -= n6;
            }
            if (point.y - n7 >= 0) {
                point.y -= n7;
            }
            if (point.y + n > n4) {
                point.y = point2.y;
            }
            if (point.x + n2 > n5) {
                point.x = point2.x;
            }
            jViewport.setViewPosition(point);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.old = mouseEvent.getPoint();
        if (this.sp != null) {
            JViewport jViewport = this.sp.getViewport();
            jViewport.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.sp != null) {
            JViewport jViewport = this.sp.getViewport();
            jViewport.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

