/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import FairCom.JCheckedListBox.JCheckedListBox;
import FairCom.JCheckedListBox.ListItem;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.sql.CreateSqlTable;
import ctreeaceexplorer.sql.SqlTableColumn;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class RecordColumns
extends JDialog {
    boolean allSelected;
    MODE mode;
    ArrayList<SqlTableColumn> currentColumns = null;
    private JButton buttonDown;
    private JButton buttonUp;
    private JButton cancelBT;
    private JCheckedListBox jCheckedListBox1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton okBT;
    private JButton selectAllBT;
    private JButton unselectAllBT;

    public RecordColumns(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.setIconImage(Globals.getIcon("Table.png").getImage());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cancelBT = new JButton();
        this.okBT = new JButton();
        this.selectAllBT = new JButton();
        this.unselectAllBT = new JButton();
        this.jPanel2 = new JPanel();
        this.jCheckedListBox1 = new JCheckedListBox();
        this.jPanel3 = new JPanel();
        this.buttonUp = new JButton();
        this.buttonDown = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Columns Selector");
        this.setIconImage(null);
        this.jPanel1.setName("jPanel1");
        this.cancelBT.setMnemonic('C');
        this.cancelBT.setText("Cancel");
        this.cancelBT.setName("cancelBT");
        this.cancelBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordColumns.this.cancelBTActionPerformed(actionEvent);
            }
        });
        this.okBT.setMnemonic('O');
        this.okBT.setText("OK");
        this.okBT.setName("okBT");
        this.okBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordColumns.this.okBTActionPerformed(actionEvent);
            }
        });
        this.selectAllBT.setMnemonic('S');
        this.selectAllBT.setText("Select All");
        this.selectAllBT.setName("selectAllBT");
        this.selectAllBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordColumns.this.selectAllBTActionPerformed(actionEvent);
            }
        });
        this.unselectAllBT.setMnemonic('U');
        this.unselectAllBT.setText("Unselect All");
        this.unselectAllBT.setName("unselectAllBT");
        this.unselectAllBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordColumns.this.unselectAllBTActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(33, 33, 33).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.okBT, -1, -1, Short.MAX_VALUE).addComponent(this.selectAllBT, -1, 86, Short.MAX_VALUE)).addGap(52, 52, 52).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cancelBT, -1, -1, Short.MAX_VALUE).addComponent(this.unselectAllBT, -1, -1, Short.MAX_VALUE)).addGap(35, 35, 35)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectAllBT).addComponent(this.unselectAllBT)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelBT).addComponent(this.okBT))));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanel2.setName("jPanel2");
        this.jCheckedListBox1.setName("jCheckedListBox1");
        this.jPanel3.setName("jPanel3");
        this.buttonUp.setIcon(new ImageIcon(this.getClass().getResource("/ctreeaceexplorer/images/Arrowup.png")));
        this.buttonUp.setName("buttonUp");
        this.buttonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordColumns.this.buttonUpActionPerformed(actionEvent);
            }
        });
        this.buttonDown.setIcon(new ImageIcon(this.getClass().getResource("/ctreeaceexplorer/images/Arrowdown.png")));
        this.buttonDown.setName("buttonDown");
        this.buttonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordColumns.this.buttonDownActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.buttonUp, -2, 27, -2).addContainerGap()).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.buttonDown, -2, 27, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap(46, Short.MAX_VALUE).addComponent(this.buttonUp).addGap(53, 53, 53).addComponent(this.buttonDown).addGap(57, 57, 57)));
        GroupLayout groupLayout3 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addComponent((Component)this.jCheckedListBox1, -1, 252, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, 43, -2)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jCheckedListBox1, -1, 206, Short.MAX_VALUE));
        GroupLayout groupLayout4 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void okBTActionPerformed(ActionEvent actionEvent) {
        ArrayList arrayList = this.jCheckedListBox1.getCheckedStatus();
        this.allSelected = true;
        for (int i = 0; i < this.currentColumns.size(); ++i) {
            SqlTableColumn sqlTableColumn = this.currentColumns.get(i);
            sqlTableColumn.Selected = (Boolean)arrayList.get(i);
            if (sqlTableColumn.Selected) continue;
            this.allSelected = false;
        }
        if (this.mode != MODE.RECORD_COLUMNS) {
            this.allSelected = true;
        }
        this.setVisible(false);
    }

    private void cancelBTActionPerformed(ActionEvent actionEvent) {
        ArrayList<SqlTableColumn> arrayList = Globals.currentSqlConnection.tableColumnsForRecords;
        this.allSelected = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            SqlTableColumn sqlTableColumn = arrayList.get(i);
            if (sqlTableColumn.Selected) continue;
            this.allSelected = false;
        }
        if (this.mode != MODE.RECORD_COLUMNS) {
            this.allSelected = false;
        }
        this.setVisible(false);
    }

    private void selectAllBTActionPerformed(ActionEvent actionEvent) {
        this.jCheckedListBox1.setAllItemsChecked(true);
    }

    private void unselectAllBTActionPerformed(ActionEvent actionEvent) {
        this.jCheckedListBox1.setAllItemsChecked(false);
    }

    private void buttonDownActionPerformed(ActionEvent actionEvent) {
        int n = this.jCheckedListBox1.getSelectedItem();
        if (n >= 0 && n < this.jCheckedListBox1.getItemsCount() - 1) {
            SqlTableColumn sqlTableColumn = this.currentColumns.get(n);
            this.currentColumns.remove(sqlTableColumn);
            this.currentColumns.add(n + 1, sqlTableColumn);
            ListItem listItem = this.jCheckedListBox1.get(n);
            this.jCheckedListBox1.removeItem(listItem);
            this.jCheckedListBox1.add(n + 1, listItem);
            this.jCheckedListBox1.setSelectedItem(n + 1);
        }
    }

    private void buttonUpActionPerformed(ActionEvent actionEvent) {
        int n = this.jCheckedListBox1.getSelectedItem();
        if (n > 0) {
            SqlTableColumn sqlTableColumn = this.currentColumns.get(n);
            this.currentColumns.remove(sqlTableColumn);
            this.currentColumns.add(n - 1, sqlTableColumn);
            ListItem listItem = this.jCheckedListBox1.get(n);
            this.jCheckedListBox1.removeItem(listItem);
            this.jCheckedListBox1.add(n - 1, listItem);
            this.jCheckedListBox1.setSelectedItem(n - 1);
        }
    }

    public boolean showDialog(MODE mODE) {
        return this.showDialog(mODE, null);
    }

    public boolean showDialog(MODE mODE, String string) {
        this.mode = mODE;
        this.getRootPane().setDefaultButton(this.okBT);
        switch (mODE) {
            case RECORD_COLUMNS: 
            case CONSTRAINS_COLUMNS: {
                this.currentColumns = Globals.currentSqlConnection.tableColumnsForRecords;
                break;
            }
            case PK_COLUMNS: {
                this.currentColumns = CreateSqlTable.pkSelectedColumns;
                break;
            }
            case UK_COLUMNS: {
                this.currentColumns = CreateSqlTable.ukSelectedColumns;
                break;
            }
            case UK_COLUMNS_CREATE: {
                this.currentColumns = CreateSqlTable.ukSelectedColumns;
                break;
            }
            case FK_COLUMNS: {
                this.currentColumns = CreateSqlTable.fkSelectedColumns;
                break;
            }
            default: {
                return false;
            }
        }
        String[] stringArray = null;
        if (string != null) {
            stringArray = string.split(",");
        }
        if (this.currentColumns == null) {
            return false;
        }
        for (SqlTableColumn sqlTableColumn : this.currentColumns) {
            if (string == null) {
                this.jCheckedListBox1.add(sqlTableColumn.Name, Boolean.valueOf(sqlTableColumn.Selected));
                continue;
            }
            boolean bl = false;
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    if (!string2.equals(sqlTableColumn.Name)) continue;
                    this.jCheckedListBox1.add(sqlTableColumn.Name, Boolean.valueOf(true));
                    sqlTableColumn.Selected = true;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.jCheckedListBox1.add(sqlTableColumn.Name, Boolean.valueOf(false));
                sqlTableColumn.Selected = false;
                continue;
            }
            this.jCheckedListBox1.add(sqlTableColumn.Name, Boolean.valueOf(false));
        }
        this.setVisible(true);
        return this.allSelected;
    }

    public static enum MODE {
        RECORD_COLUMNS,
        PK_COLUMNS,
        UK_COLUMNS,
        UK_COLUMNS_CREATE,
        FK_COLUMNS,
        CONSTRAINS_COLUMNS;

    }
}

