/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import ctree.jdbc.CtreeSQLException;
import ctreeaceexplorer.CtreeACEExplorerView;
import ctreeaceexplorer.Globals;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ScriptsPane
extends JTextPane {
    static int TPE_MAX_SQLSTMTLEN = 35000;
    ScriptStatements statements = new ScriptStatements();
    ColumnsFormatTable columnsFormatTable = new ColumnsFormatTable();
    StyledDocument doc = this.getStyledDocument();
    CtreeACEExplorerView appFrame;
    Timer timer;
    Thread runThread;
    Calendar startDate = null;
    Calendar endDate = null;
    FileWriter outFile;
    JPopupMenu contextMenu;
    PopupActions popupActions;
    JPopupMenu contextMenu2;
    PopupActions2 popupActions2;
    ArrayList<ScriptRow> selectedRows = new ArrayList();
    int activeLine;
    int defaultIsolationLevel;
    int currentIsolationLevel;
    boolean colorize = true;
    boolean parsing;
    boolean pause = false;
    boolean stop = false;
    boolean stopThread = false;
    boolean stopOnErrors = false;
    boolean running = false;
    boolean sstep = false;
    boolean scAutoCommit = false;
    boolean scEcho = false;
    boolean scTime = false;
    boolean scReport = false;
    boolean scriptError = false;
    boolean scriptRunMode = false;
    boolean runScript = false;
    boolean runningInIfClause = false;
    boolean inIfClause = false;
    boolean ifClauseIsIfExist = false;
    boolean ifClauseHasRows = false;
    boolean ifClauseDone = false;
    boolean insideBegin = false;
    boolean insideElse = false;
    boolean skipBegin = false;
    SC_STATE scState = SC_STATE.STOPPED;
    public RUN_MODE scriptMode;
    public String outFileName;
    Pattern comment_regex = Pattern.compile("^--.*");
    Pattern set_regex = Pattern.compile("^[ \t]*set.*");
    Pattern setSchema_regex = Pattern.compile("^[ \t]*set.*schema.*");
    Pattern column_regex = Pattern.compile("^[ \t]*column.*");
    Pattern command_regex = Pattern.compile("^!.*");
    Pattern echo_regex = Pattern.compile("^[ \t]*echo.*");
    Pattern spool_regex = Pattern.compile("^[ \t]*spool.*");
    Pattern createProc_regex = Pattern.compile("^[ \t]*create procedure.*");
    Pattern createTrigger_regex = Pattern.compile("^[ \t]*create trigger.*");
    Pattern createUDF_regex = Pattern.compile("^[ \t]*create function.*");
    Pattern ifexist_regex = Pattern.compile("^[ \t]*if_exist.*");
    Pattern ifexist2_regex = Pattern.compile("^[ \t]*if +exist.*");
    Pattern ifnotexist_regex = Pattern.compile("^[ \t]*if_not_exist.*");
    Pattern ifnotexist2_regex = Pattern.compile("^[ \t]*if +not +exist.*");
    Pattern begin_regex = Pattern.compile("^[ \t]*begin.*");
    Pattern else_regex = Pattern.compile("^[ \t]*else.*");
    Pattern end_regex = Pattern.compile("^[ \t]*end.*");
    Style redStyle;
    Style blueStyle;
    Style slateBlueStyle;
    Style blackStyle;
    Style salmonStyle;
    Style tomatoStyle;
    Style saddleBrownStyle;
    Style purpleStyle;
    Style greenStyle;
    Style backgStyle;
    Style defaultBackgStyle;

    public ScriptsPane() {
        this.doc.addDocumentListener(new MyDocumentListener());
        this.timer = new Timer(250, new MyTimerActionListener(this));
        this.redStyle = this.addStyle("Red", null);
        StyleConstants.setForeground(this.redStyle, Color.red);
        this.slateBlueStyle = this.addStyle("SlateBlue", null);
        StyleConstants.setForeground(this.slateBlueStyle, new Color(102, 102, 255));
        this.blueStyle = this.addStyle("Blue", null);
        StyleConstants.setForeground(this.blueStyle, Color.blue);
        this.blackStyle = this.addStyle("Black", null);
        StyleConstants.setForeground(this.blackStyle, Color.black);
        this.salmonStyle = this.addStyle("Salmon", null);
        StyleConstants.setForeground(this.salmonStyle, new Color(204, 81, 81));
        this.tomatoStyle = this.addStyle("Tomato", null);
        StyleConstants.setForeground(this.tomatoStyle, new Color(255, 51, 0));
        this.saddleBrownStyle = this.addStyle("SaddleBrown", null);
        StyleConstants.setForeground(this.saddleBrownStyle, new Color(164, 62, 11));
        this.purpleStyle = this.addStyle("Purple", null);
        StyleConstants.setForeground(this.purpleStyle, new Color(102, 0, 102));
        this.greenStyle = this.addStyle("Green", null);
        StyleConstants.setForeground(this.greenStyle, new Color(74, 170, 12));
        this.backgStyle = this.addStyle("BackGround", null);
        StyleConstants.setBackground(this.backgStyle, new Color(204, 204, 204));
        Color color = this.getBackground();
        this.defaultBackgStyle = this.addStyle("DefaultBackGround", null);
        StyleConstants.setBackground(this.defaultBackgStyle, color);
        this.addMouseListener(new PopupListener(this));
        this.popupActions = new PopupActions(this);
        this.contextMenu = new JPopupMenu("Edit");
        this.contextMenu.add(this.makeMenuItem("Copy", this.popupActions));
        this.contextMenu.add(this.makeMenuItem("Paste", this.popupActions));
        this.contextMenu.add(new JPopupMenu.Separator());
        this.contextMenu.add(this.makeMenuItem("Exec Selected", this.popupActions));
        this.contextMenu.add(this.makeMenuItem("ExecPlan Selected", this.popupActions));
        this.contextMenu.add(this.makeMenuItem("Run To Cursor", this.popupActions));
        this.contextMenu.add(this.makeMenuItem("Clear Script", this.popupActions));
        this.popupActions2 = new PopupActions2();
        this.contextMenu2 = new JPopupMenu("Edit2");
        this.contextMenu2.add(this.makeMenuItem("Clear", this.popupActions2));
        this.contextMenu2.add(this.makeMenuItem("Copy", this.popupActions2));
    }

    private JMenuItem makeMenuItem(String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container container = this.getParent();
        TextUI textUI = this.getUI();
        return container != null ? textUI.getPreferredSize((JComponent)this).width <= container.getSize().width : true;
    }

    public void loadScript(String string, boolean bl) {
        this.statements.rows.clear();
        this.appFrame = Globals.appFrame;
        this.popupActions2.setupPane(this.appFrame.resultTA);
        this.appFrame.resultTA.addMouseListener(new PopupListener(this));
        if (bl) {
            try {
                this.doc.remove(0, this.doc.getLength());
                this.appFrame.resultTA.setText("");
                this.runScript = true;
                this.scriptRunMode = true;
                this.setControls(false);
                this.appFrame.runBT.setText("Stop");
                this.appFrame.runBT.setEnabled(true);
                this.appFrame.sstepBT.setEnabled(false);
                this.appFrame.pauseBT.setEnabled(false);
                this.appFrame.scriptEchoCB.setEnabled(false);
                this.appFrame.scriptAnimateCB.setEnabled(false);
                if (!this.outFileName.isEmpty()) {
                    try {
                        this.outFile = new FileWriter(this.outFileName);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(ScriptsPane.class.getName()).log(Level.SEVERE, null, iOException);
                    }
                }
                this.scState = SC_STATE.RUNNING;
                Globals.ShowWaitCursor();
                this.appFrame.scriptProgressBar.setIndeterminate(true);
                this.runThread = new Thread(new RunSomeTask2(string));
                this.runThread.start();
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(CtreeACEExplorerView.class.getName()).log(Level.SEVERE, null, badLocationException);
            }
        } else {
            this.appFrame.sstepBT.setEnabled(true);
            this.appFrame.pauseBT.setEnabled(false);
            this.appFrame.scriptEchoCB.setEnabled(true);
            this.appFrame.scriptAnimateCB.setEnabled(true);
            int n = string.length();
            if (n > 1000000) {
                Globals.showMessage("The script is considered \"large\".\n\n\"Syntax Highlighting\" has been set to\"Off\"", "Scripts Evaluation");
                Globals.appFrame.sqlTSB.setSelected(false);
                this.colorize = false;
            } else {
                Globals.appFrame.sqlTSB.setSelected(true);
                this.colorize = true;
            }
            Globals.ShowWaitCursor();
            this.parsing = true;
            try {
                this.doc.remove(0, this.doc.getLength());
                this.doc.insertString(0, string, null);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(CtreeACEExplorerView.class.getName()).log(Level.SEVERE, null, badLocationException);
            }
            this.parseScript();
            this.setCaretPosition(0);
            Globals.ShowNormalCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runScriptInRunMode(String string) {
        String string2 = "";
        String string3 = "";
        int n = 1;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("--")) continue;
                string2 = string2.trim();
                string3 = string3 + string2;
                if (string2.endsWith(";")) {
                    if (n == 1 || n % 1000 == 0) {
                        this.appFrame.resultTA.append("Executing statement # " + n + "\n");
                        this.appFrame.resultTA.setCaretPosition(this.appFrame.resultTA.getText().length());
                    }
                    this.runSingleLine(string3);
                    string3 = "";
                    ++n;
                }
                if (!this.stopThread) continue;
                this.stopScript();
                break;
            }
            if (this.scState == SC_STATE.RUNNING) {
                this.appFrame.resultTA.append("Executed last script statement\n");
            }
            this.appFrame.resultTA.append("Script ended\n");
            this.appFrame.resultTA.setCaretPosition(this.appFrame.resultTA.getText().length());
            this.scState = SC_STATE.STOPPED;
            if (this.outFile != null) {
                this.outFile.close();
            }
            Globals.ShowNormalCursor();
        }
        catch (IOException iOException) {
            Globals.showException(iOException, "Run Script");
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.outFile = null;
        this.setControls(true);
        this.appFrame.runBT.setText("Run");
        this.scriptRunMode = false;
        this.appFrame.scriptProgressBar.setIndeterminate(false);
    }

    public void setStopOnError(boolean bl) {
        this.stopOnErrors = bl;
    }

    public void setColorize(boolean bl) {
        this.colorize = bl;
        Globals.ShowWaitCursor();
        int n = this.getCaretPosition();
        if (this.colorize) {
            this.parseScript();
        } else {
            this.doc.setCharacterAttributes(0, this.doc.getLength(), this.blueStyle, true);
        }
        this.setCaretPosition(n);
        Globals.ShowNormalCursor();
    }

    public String getScriptText() {
        String string = "";
        try {
            string = this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(CtreeACEExplorerView.class.getName()).log(Level.SEVERE, null, badLocationException);
        }
        return string;
    }

    private void runSingleLine(String string) {
        String string2 = string.trim().toLowerCase();
        boolean bl = false;
        if (string2.isEmpty()) {
            return;
        }
        if (bl) {
            if (string2.equals("end") || string2.equals("end;")) {
                bl = false;
            }
            return;
        }
        Matcher matcher = this.createProc_regex.matcher(string2);
        Matcher matcher2 = this.createTrigger_regex.matcher(string2);
        Matcher matcher3 = this.createUDF_regex.matcher(string2);
        if (matcher.find() || matcher2.find() || matcher3.find()) {
            bl = true;
            return;
        }
        if (this.comment_regex.matcher(string2).find()) {
            return;
        }
        if (this.set_regex.matcher(string2).find()) {
            return;
        }
        if (this.column_regex.matcher(string2).find()) {
            return;
        }
        if (this.spool_regex.matcher(string2).find()) {
            return;
        }
        if (this.command_regex.matcher(string2).find()) {
            return;
        }
        if (this.echo_regex.matcher(string2).find()) {
            return;
        }
        string = string.replace("\n", " ");
        string = string.replace("\t", " ");
        this.execStmt(string, true);
    }

    public void runStop() {
        this.appFrame = Globals.appFrame;
        if (this.scState == SC_STATE.STOPPED && !this.statements.rows.isEmpty()) {
            this.stop = false;
            this.pause = false;
            this.inIfClause = false;
            this.appFrame.pauseBT.setEnabled(true);
            this.appFrame.sstepBT.setEnabled(false);
            this.appFrame.pauseBT.setText("Pause");
            this.appFrame.runBT.setText("Stop");
            this.appFrame.resultTA.setText("");
            this.scState = SC_STATE.RUNNING;
            this.setControls(false);
            this.appFrame.scriptProgressBar.setMaximum(this.statements.rows.size());
            this.appFrame.scriptProgressBar.setValue(0);
            this.activeLine = 0;
            this.startDate = Calendar.getInstance();
            this.runThread = new Thread(new RunSomeTask());
            this.runThread.start();
        } else {
            this.stopScript();
        }
    }

    private void stopScript() {
        this.stopThread = true;
        this.appFrame.runBT.setText("Run");
        this.setControls(true);
        if (!this.selectedRows.isEmpty()) {
            for (ScriptRow scriptRow : this.selectedRows) {
                this.doc.setCharacterAttributes(scriptRow.start, scriptRow.length, this.defaultBackgStyle, false);
            }
            this.selectedRows.clear();
        }
        if (!this.scriptRunMode && this.scState != SC_STATE.STOPPED) {
            this.scState = SC_STATE.STOPPED;
            this.appFrame.sstepBT.setEnabled(true);
            this.appFrame.pauseBT.setEnabled(false);
            this.appFrame.scriptProgressBar.setValue(0);
            ScriptRow scriptRow = this.statements.rows.get(this.statements.rows.size() - 1);
            this.setCaretPosition(scriptRow.start);
            if (this.scTime || this.appFrame.scriptTimeCB.isSelected()) {
                this.endDate = Calendar.getInstance();
                long l = this.startDate.getTimeInMillis();
                long l2 = this.endDate.getTimeInMillis();
                long l3 = (l2 - l) / 1000L;
                long l4 = l2 - l - l3 * 1000L;
                String string = String.format("%d.%03d", l3, l4);
                this.appFrame.resultTA.append("Total Elapsed Time = " + string + "\n");
                this.appFrame.resultTA.setCaretPosition(this.appFrame.resultTA.getText().length());
            }
            if (this.outFile != null) {
                try {
                    this.outFile.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(ScriptsPane.class.getName()).log(Level.SEVERE, null, iOException);
                }
                this.outFile = null;
            }
        }
    }

    public void selectStatement() {
        int n = this.getCaretPosition();
        if (!this.statements.rows.isEmpty()) {
            if (!this.selectedRows.isEmpty()) {
                for (ScriptRow scriptRow : this.selectedRows) {
                    this.doc.setCharacterAttributes(scriptRow.start, scriptRow.length, this.defaultBackgStyle, false);
                }
            }
            int n2 = 0;
            boolean bl = false;
            block1: for (ScriptRow scriptRow : this.statements.rows) {
                if (n >= scriptRow.start && n < scriptRow.start + scriptRow.length) {
                    boolean bl2 = false;
                    while (n2 > 0 && scriptRow.type == ROW_TYPE.STATEMENT) {
                        ScriptRow scriptRow2 = this.statements.rows.get(n2 - 1);
                        if (scriptRow2.statement.trim().endsWith(";")) break;
                        scriptRow = this.statements.rows.get(--n2);
                        if (bl2 && scriptRow.statement.trim().endsWith(";")) break;
                        bl2 = true;
                    }
                    while (n2 < this.statements.rows.size() && scriptRow.type != ROW_TYPE.STATEMENT) {
                        scriptRow = this.statements.rows.get(n2);
                        if (scriptRow.type == ROW_TYPE.STATEMENT) break;
                        ++n2;
                    }
                    this.selectedRows.clear();
                    this.activeLine = n2;
                    if (n2 >= this.statements.rows.size()) break;
                    do {
                        this.doc.setCharacterAttributes(scriptRow.start, scriptRow.length, this.backgStyle, false);
                        this.selectedRows.add(scriptRow);
                        if (scriptRow.statement.trim().endsWith(";")) break block1;
                        if (++n2 >= this.statements.rows.size()) continue;
                        scriptRow = this.statements.rows.get(n2);
                    } while (n2 < this.statements.rows.size() && scriptRow.type == ROW_TYPE.STATEMENT);
                    break;
                }
                ++n2;
            }
        }
    }

    public void pause() {
        if (this.scState == SC_STATE.RUNNING) {
            this.setControls(true);
            if (this.runScript) {
                this.scState = SC_STATE.STOPPED;
                return;
            }
            this.appFrame.pauseBT.setText("Continue");
            this.appFrame.sstepBT.setEnabled(true);
            this.scState = SC_STATE.PAUSED;
            ++this.activeLine;
            if (this.activeLine < this.statements.rows.size() - 1) {
                if (!this.selectedRows.isEmpty()) {
                    for (ScriptRow scriptRow : this.selectedRows) {
                        this.doc.setCharacterAttributes(scriptRow.start, scriptRow.length, this.defaultBackgStyle, false);
                    }
                }
                Object object = this.statements.rows.get(this.activeLine);
                while (this.activeLine < this.statements.rows.size() - 1 && ((ScriptRow)object).type != ROW_TYPE.STATEMENT) {
                    ++this.activeLine;
                    object = this.statements.rows.get(this.activeLine);
                }
                this.selectedRows.clear();
                this.selectedRows.add((ScriptRow)object);
                this.setCaretPosition(((ScriptRow)object).start);
                this.doc.setCharacterAttributes(((ScriptRow)object).start, ((ScriptRow)object).length, this.backgStyle, false);
                this.pause = true;
            }
        } else if ((this.scState == SC_STATE.PAUSED || this.scState == SC_STATE.SSTEP) && this.activeLine < this.statements.rows.size() - 1) {
            this.setControls(false);
            this.appFrame.pauseBT.setText("  Pause   ");
            this.appFrame.sstepBT.setEnabled(false);
            this.scState = SC_STATE.RUNNING;
            Thread thread = new Thread(new RunSomeTask());
            thread.start();
        }
    }

    public void singleStep() {
        this.appFrame.pauseBT.setText("Continue");
        this.appFrame.pauseBT.setEnabled(true);
        this.pause = false;
        this.stop = false;
        this.scState = SC_STATE.SSTEP;
        if (this.activeLine < 0) {
            this.activeLine = 0;
        }
        if (this.activeLine <= this.statements.rows.size() - 1) {
            this.activeLine = this.runStep(this.activeLine);
            ++this.activeLine;
            if (this.activeLine <= this.statements.rows.size() - 1) {
                ScriptRow scriptRow = this.statements.rows.get(this.activeLine);
                this.setCaretPosition(scriptRow.start);
                this.selectStatement();
            }
        }
    }

    private void runScript() {
        this.scriptError = false;
        this.scTime = false;
        this.scEcho = false;
        this.scReport = false;
        if (!this.statements.rows.isEmpty()) {
            ScriptRow scriptRow = this.statements.rows.get(this.activeLine);
            this.setCaretPosition(scriptRow.start);
            this.currentIsolationLevel = this.defaultIsolationLevel = Globals.currentSqlConnection.getTransactionIsolation();
            this.pause = false;
            if (this.activeLine < 0) {
                this.activeLine = 0;
            }
            while (this.activeLine < this.statements.rows.size()) {
                this.activeLine = this.runStep(this.activeLine);
                if (this.pause) break;
                if (this.stopOnErrors && this.scriptError || this.stopThread) {
                    this.stopScript();
                    break;
                }
                if (this.stop) {
                    this.activeLine = 0;
                    break;
                }
                ++this.activeLine;
            }
            if (this.activeLine == this.statements.rows.size()) {
                this.stopScript();
                this.running = false;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private int runStep(int var1_1) {
        var2_2 = false;
        if (this.statements.rows.isEmpty()) {
            return var1_1;
        }
        do {
            block75: {
                block74: {
                    var3_3 = this.statements.rows.get(var1_1);
                    var4_4 = var3_3.statement.trim();
                    if (var1_1 < this.appFrame.scriptProgressBar.getMaximum()) {
                        this.appFrame.scriptProgressBar.setValue(var1_1);
                    }
                    if (this.appFrame.scriptAnimateCB.isSelected()) {
                        this.setCaretPosition(var3_3.start);
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException var5_6) {
                            Logger.getLogger(ScriptsPane.class.getName()).log(Level.SEVERE, null, var5_6);
                        }
                    }
                    if (!this.inIfClause || var3_3.type == ROW_TYPE.NULL) break block74;
                    if (!this.insideBegin && !this.skipBegin && var3_3.type != ROW_TYPE.BEGIN && var3_3.type != ROW_TYPE.COMMENT) {
                        this.appFrame.resultTA.append("Error - Expected \"BEGIN\" clause\n");
                        this.stopScript();
                        this.stop = true;
                        return 0;
                    }
                    if (!this.insideBegin && this.skipBegin && var3_3.type != ROW_TYPE.END) {
                        return var1_1;
                    }
                    if (var3_3.type != ROW_TYPE.BEGIN) ** GOTO lbl35
                    if (this.ifClauseHasRows && this.ifClauseIsIfExist) {
                        this.insideBegin = true;
                        this.ifClauseDone = true;
                    } else if (!this.ifClauseHasRows && !this.ifClauseIsIfExist) {
                        this.insideBegin = true;
                        this.ifClauseDone = true;
                    } else {
                        this.skipBegin = true;
                        return var1_1;
lbl35:
                        // 1 sources

                        if (var3_3.type == ROW_TYPE.END) {
                            this.inIfClause = false;
                            this.insideBegin = false;
                        }
                    }
                    break block75;
                }
                if (this.ifClauseDone) {
                    if (this.insideBegin) {
                        if (var3_3.type != ROW_TYPE.END) {
                            return var1_1;
                        }
                        this.ifClauseDone = false;
                    }
                    if (var3_3.type == ROW_TYPE.BEGIN) {
                        this.insideBegin = true;
                    }
                }
            }
            switch (1.$SwitchMap$ctreeaceexplorer$sql$ScriptsPane$ROW_TYPE[var3_3.type.ordinal()]) {
                case 1: 
                case 2: {
                    this.doEcho(var4_4);
                    break;
                }
                case 3: {
                    this.doEcho(var4_4);
                    var5_5 = var4_4.replace(";", "");
                    var6_7 = var5_5.split(" ");
                    try {
                        if (var6_7.length > 2 && var6_7[2].equals("on")) {
                            this.outFile = new FileWriter(var6_7[1]);
                            break;
                        }
                        if (var6_7.length <= 1) break;
                        if (var6_7[1].equals("off")) {
                            if (this.outFile == null) break;
                            this.outFile.close();
                            this.outFile = null;
                            break;
                        }
                        if (var6_7[1].equals("out")) break;
                        this.outFile = new FileWriter(var6_7[1]);
                    }
                    catch (Exception var7_9) {
                        Globals.showException(var7_9, "Spool command error ");
                    }
                    break;
                }
                case 4: {
                    this.doEcho(var4_4);
                    var7_8 = Pattern.compile("\\s+");
                    var5_5 = var4_4.replace(";", "");
                    var6_7 = var7_8.split(var5_5.toLowerCase());
                    if (var6_7.length <= 2) break;
                    if (var6_7[1].equals("autocommit")) {
                        if (var6_7[2].equals("on")) {
                            this.scAutoCommit = true;
                            break;
                        }
                        this.scAutoCommit = false;
                        break;
                    }
                    if (var6_7[1].equals("echo")) {
                        if (var6_7[2].equals("on")) {
                            this.scEcho = true;
                            break;
                        }
                        this.scEcho = false;
                        break;
                    }
                    if (var6_7[1].equals("time")) {
                        if (var6_7[2].equals("on")) {
                            this.scTime = true;
                            break;
                        }
                        this.scTime = false;
                        break;
                    }
                    if (var6_7[1].equals("report")) {
                        if (var6_7[2].equals("on")) {
                            this.scReport = true;
                            break;
                        }
                        this.scReport = false;
                        break;
                    }
                    if (var6_7.length >= 5 && var6_7[1].equals("transaction")) {
                        this.currentIsolationLevel = this.defaultIsolationLevel;
                        if (var6_7[2].equals("isolation") && var6_7[3].equals("level")) {
                            if (var6_7[4].equals("read")) {
                                if (var6_7.length == 6) {
                                    if (var6_7[5].equals("uncommitted")) {
                                        this.currentIsolationLevel = 1;
                                    } else if (var6_7[5].equals("committed")) {
                                        this.currentIsolationLevel = 2;
                                    } else {
                                        this.appFrame.resultTA.append(this.currentIsolationLevel + "\n\n");
                                    }
                                } else {
                                    this.appFrame.resultTA.append(this.currentIsolationLevel + "\n\n");
                                }
                            } else if (var6_7[4].equals("repeatable")) {
                                if (var6_7.length == 6) {
                                    if (var6_7[5].equals("read")) {
                                        this.currentIsolationLevel = 4;
                                    }
                                } else {
                                    this.appFrame.resultTA.append(this.currentIsolationLevel + "\n\n");
                                }
                            } else if (var6_7[4].equals("serializable")) {
                                this.currentIsolationLevel = 8;
                            } else {
                                this.appFrame.resultTA.append(this.currentIsolationLevel + "\n\n");
                            }
                            if (this.currentIsolationLevel == this.defaultIsolationLevel) break;
                            this.appFrame.resultTA.append("Transaction Isolation Level = " + this.currentIsolationLevel + "\n\n");
                            break;
                        }
                        this.appFrame.resultTA.append("Error !!!\n\n");
                        break;
                    }
                    if ((var4_4 = var4_4.trim()).endsWith(";")) {
                        var4_4 = var4_4.substring(0, var4_4.length() - 1);
                    }
                    this.execStmt(var4_4, true);
                    break;
                }
                case 5: {
                    this.doEcho(var4_4);
                    var6_7 = this.splitString(var4_4);
                    if (var6_7.length < 2) break;
                    var8_10 = var6_7[1].toLowerCase();
                    var9_11 = ColumnsFormatTable.access$300(this.columnsFormatTable, var8_10);
                    if (var9_11 == null) {
                        var9_11 = this.columnsFormatTable.newRow();
                        this.columnsFormatTable.columnFormat.add((ColumnFormat)var9_11);
                        var9_11.name = var8_10;
                    }
                    var9_11.heading = "";
                    var9_11.format = "";
                    if (var6_7.length > 3) {
                        if (var6_7[2].toLowerCase().equals("format")) {
                            var9_11.format = var6_7[3];
                        } else if (var6_7[2].toLowerCase().equals("heading")) {
                            var9_11.heading = var6_7[3];
                        }
                    }
                    if (var6_7.length <= 5) break;
                    if (var6_7[4].toLowerCase().equals("format")) {
                        var9_11.format = var6_7[5];
                        break;
                    }
                    if (!var6_7[4].toLowerCase().equals("heading")) break;
                    var9_11.heading = var6_7[5];
                    break;
                }
                case 6: {
                    var9_11 = var4_4 + "\n";
                    while (!var4_4.toLowerCase().equals("end") && !var4_4.toLowerCase().equals("end;") && var1_1 < this.statements.rows.size() - 1) {
                        var3_3 = this.statements.rows.get(++var1_1);
                        var4_4 = var3_3.statement.trim();
                        var9_11 = (String)var9_11 + var4_4 + "\n";
                    }
                    this.execStmt((String)var9_11, true);
                    var2_2 = true;
                    break;
                }
                case 7: {
                    this.inIfClause = true;
                    this.insideBegin = false;
                    this.ifClauseIsIfExist = false;
                    this.ifClauseDone = false;
                    this.skipBegin = false;
                    this.ifClauseIsIfExist = this.ifnotexist_regex.matcher(var4_4.toLowerCase()).find() == false && this.ifnotexist2_regex.matcher(var4_4.toLowerCase()).find() == false;
                    var10_12 = "";
                    if (var4_4.endsWith(")")) {
                        var11_13 = var4_4.indexOf("(");
                        var10_12 = var4_4.substring(var11_13 + 1, var4_4.length() - 1);
                    } else {
                        var3_3 = this.statements.rows.get(++var1_1);
                        var4_4 = var3_3.statement.trim();
                        do {
                            var10_12 = var10_12 + var4_4 + "\n";
                            var3_3 = this.statements.rows.get(++var1_1);
                        } while (!(var4_4 = var3_3.statement.trim()).toLowerCase().equals(")") && !var4_4.toLowerCase().equals(");") && var1_1 < this.statements.rows.size() - 1);
                    }
                    this.ifClauseHasRows = this.execStmt(var10_12, false);
                    var2_2 = true;
                    break;
                }
                case 8: {
                    var11_13 = 0;
                    var12_14 = false;
                    var13_15 = false;
                    for (var14_16 = 0; var14_16 < var4_4.length(); ++var14_16) {
                        if (var4_4.charAt(var14_16) == '-' && var4_4.charAt(var14_16 + 1) == '-' && !var12_14 && !var13_15) {
                            var11_13 = var14_16;
                        }
                        if (var4_4.charAt(var14_16) == '\'') {
                            v0 = var12_14 = var12_14 == false;
                        }
                        if (var4_4.charAt(var14_16) == '\"') {
                            v1 = var13_15 = var13_15 == false;
                        }
                        if (var11_13 == 0 || var12_14 || var13_15) continue;
                        var4_4 = var4_4.substring(0, var11_13).trim();
                        break;
                    }
                    var9_11 = var4_4 + " ";
                    while (!var4_4.endsWith(";") && var1_1 < this.statements.rows.size() - 1) {
                        var3_3 = this.statements.rows.get(++var1_1);
                        var4_4 = var3_3.statement.trim();
                        if (this.inIfClause && var4_4.toLowerCase().equals("end")) {
                            --var1_1;
                            break;
                        }
                        var11_13 = var4_4.indexOf("--");
                        if (var11_13 >= 0 && (var14_16 = var4_4.indexOf(";")) < var11_13) {
                            var4_4 = var4_4.substring(0, var11_13);
                        }
                        var9_11 = (String)var9_11 + var4_4 + " ";
                    }
                    this.ifClauseHasRows = this.execStmt((String)var9_11, true);
                    var2_2 = true;
                }
            }
            if (!this.sstep) continue;
            ++var1_1;
        } while (this.sstep && this.statements.rows.size() > var1_1 && !var2_2 && !this.stopThread);
        if (var1_1 == this.statements.rows.size()) {
            this.stopScript();
            var1_1 = 0;
        }
        return var1_1;
    }

    private boolean execStmt(String string, boolean bl) {
        boolean bl2 = false;
        if (!string.isEmpty()) {
            String[] stringArray;
            if (string.length() > TPE_MAX_SQLSTMTLEN) {
                Globals.showMessage("Statement is longer than the allowed maximum (" + TPE_MAX_SQLSTMTLEN + " characters)", "Error");
                return bl2;
            }
            this.doEcho(string);
            if (this.outFile != null && !this.scReport) {
                try {
                    this.outFile.write(string + "\r\n\r\n");
                }
                catch (IOException iOException) {
                    Logger.getLogger(ScriptsPane.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }
            if ((string = string.trim()).endsWith(";")) {
                string = string.substring(0, string.length() - 1);
            }
            if ((stringArray = string.split(" ")).length > 0) {
                if (stringArray[0].toLowerCase().equals("commit")) {
                    if (!this.scriptRunMode || this.scriptMode == RUN_MODE.SCREEN) {
                        this.appFrame.resultTA.append("\nStatement correctly executed\n\n");
                    }
                    Globals.currentSqlConnection.commit();
                    return false;
                }
                if (stringArray[0].toLowerCase().equals("rollback")) {
                    if (!this.scriptRunMode || this.scriptMode == RUN_MODE.SCREEN) {
                        this.appFrame.resultTA.append("\nStatement correctly executed\n\n");
                    }
                    Globals.currentSqlConnection.rollback();
                    return false;
                }
            }
            if (!string.isEmpty()) {
                int n;
                ResultSet resultSet;
                Calendar calendar;
                block27: {
                    string = string + "\n";
                    calendar = Calendar.getInstance();
                    this.scriptError = false;
                    resultSet = null;
                    n = 0;
                    try {
                        if (string.toLowerCase().startsWith("select") || string.toLowerCase().startsWith("call")) {
                            resultSet = Globals.currentSqlConnection.executeQuery(string);
                        } else {
                            n = Globals.currentSqlConnection.executeUpdate(string);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getErrorCode() == 26033) break block27;
                        if (!this.scriptRunMode || this.scriptMode == RUN_MODE.SCREEN) {
                            this.appFrame.resultTA.append(string + "\n");
                            this.appFrame.resultTA.setCaretPosition(this.appFrame.resultTA.getText().length());
                        }
                        this.showScriptError(sQLException, string);
                        this.scriptError = true;
                        this.appFrame.statusMessageLabel.setText("Error");
                        return false;
                    }
                }
                Calendar calendar2 = Calendar.getInstance();
                this.appFrame.statusMessageLabel.setText("Success");
                this.doEcho("\n\n");
                if (resultSet != null) {
                    bl2 = this.displayData(resultSet, bl);
                }
                this.appFrame.resultTA.setCaretPosition(this.appFrame.resultTA.getText().length());
                string = string.toLowerCase();
                if (!(this.scriptRunMode && this.scriptMode != RUN_MODE.SCREEN || string.startsWith("select"))) {
                    String string2 = "";
                    string2 = string.startsWith("insert") ? "inserted" : (string.startsWith("update") ? "updated" : (string.startsWith("delete") ? "deleted" : "returned"));
                    if (resultSet != null) {
                        // empty if block
                    }
                    if (!string.startsWith("create") && !string.startsWith("drop")) {
                        this.appFrame.resultTA.append(n + " record(s) " + string2 + "\n\n");
                    } else {
                        this.appFrame.resultTA.append("Statement correctly executed\n\n");
                    }
                }
                if (this.scAutoCommit) {
                    // empty if block
                }
                if (this.scTime || this.appFrame.scriptTimeCB.isSelected()) {
                    calendar2 = Calendar.getInstance();
                    long l = calendar.getTimeInMillis();
                    long l2 = calendar2.getTimeInMillis();
                    long l3 = (l2 - l) / 1000L;
                    long l4 = l2 - l - l3 * 1000L;
                    String string3 = String.format("%d.%03d", l3, l4);
                    this.appFrame.resultTA.append("Elapsed Time = " + string3 + "\n");
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(ScriptsPane.class.getName()).log(Level.SEVERE, null, sQLException);
                    }
                }
            }
            return bl2;
        }
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    boolean displayData(ResultSet resultSet, boolean bl) {
        String string32;
        Object object;
        StringBuilder stringBuilder = new StringBuilder(4096);
        StringBuilder stringBuilder2 = new StringBuilder(4096);
        int n = 0;
        ResultSetMetaData resultSetMetaData = null;
        try {
            resultSetMetaData = resultSet.getMetaData();
            n = resultSetMetaData.getColumnCount();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(ScriptsPane.class.getName()).log(Level.SEVERE, null, sQLException);
            return false;
        }
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        int[] nArray5 = new int[n];
        int[] nArray6 = new int[n];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int[] nArray7 = new int[n];
        ColumnsTable columnsTable = new ColumnsTable();
        long l = 0L;
        String string2 = "";
        int n2 = 0;
        try {
            Object object2 = 0;
            while ((Integer)object2 < n) {
                int n3;
                string2 = resultSetMetaData.getColumnName((Integer)object2 + 1);
                if (string2 == null) {
                    string2 = "";
                }
                stringArray2[((Integer)object2).intValue()] = string2;
                object = new Column();
                ((Column)object).colNumber = (Integer)object2;
                columnsTable.columns.add((Column)object);
                nArray[((Integer)object2).intValue()] = n3 = string2.length();
                nArray7[((Integer)object2).intValue()] = resultSetMetaData.getColumnType((Integer)object2 + 1);
                object = object2;
                object2 = (Integer)object2 + 1;
                Integer n4 = object2;
            }
            object2 = this.appFrame.scriptMaxRowsCombo.getSelectedItem();
            try {
                n2 = Integer.parseInt((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
            while (resultSet.next() && (n2 == -1 || (long)n2 > l)) {
                object = new Row();
                for (int i = 0; i < n; ++i) {
                    try {
                        string2 = resultSet.getString(i + 1);
                    }
                    catch (SQLException sQLException) {
                        Globals.showException(sQLException, "");
                    }
                    if (string2 != null) {
                        ((Row)object).values.add(string2.trim());
                        int n5 = string2.trim().length();
                        if (n5 > nArray[i]) {
                            nArray[i] = n5;
                        }
                        switch (nArray7[i]) {
                            case -6: 
                            case -5: 
                            case 2: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: {
                                int n6 = string2.indexOf(".");
                                if (n6 > -1 && nArray4[i] < string2.length() - n6 - 1) {
                                    nArray4[i] = string2.length() - n6 - 1;
                                }
                                if (n6 > -1 && nArray5[i] < n6) {
                                    nArray5[i] = n6;
                                } else if (n6 == -1 && nArray5[i] < n5) {
                                    nArray5[i] = n5;
                                }
                                nArray[i] = nArray5[i] + nArray4[i] - 1;
                                break;
                            }
                            case 91: 
                            case 92: {
                                nArray[i] = n5 + 2;
                                break;
                            }
                        }
                        continue;
                    }
                    ((Row)object).values.add("(null)");
                }
                ++l;
                columnsTable.rows.add((Row)object);
            }
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "");
        }
        if (columnsTable.rows.isEmpty()) {
            return false;
        }
        int n7 = 0;
        for (String string32 : stringArray2) {
            void object4;
            Object object2;
            boolean bl2 = false;
            String string = string32;
            if (!this.columnsFormatTable.columnFormat.isEmpty() && (object2 = this.columnsFormatTable.select(string32)) != null) {
                if (!((ColumnFormat)object2).heading.isEmpty()) {
                    String string5 = ((ColumnFormat)object2).heading;
                    string5 = string5.replace("\"", "");
                } else {
                    String string6 = string32;
                }
                if (!((ColumnFormat)object2).format.isEmpty()) {
                    object = ((ColumnFormat)object2).format;
                    object = ((String)object).replace("\"", "");
                    nArray[n7] = 0;
                    switch (nArray7[n7]) {
                        case -16: 
                        case -15: 
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: {
                            int n8;
                            nArray6[n7] = MODE.STRING.value;
                            if (!((String)object).startsWith("A")) break;
                            object = ((String)object).substring(1, ((String)object).length());
                            try {
                                nArray[n7] = n8 = Integer.parseInt((String)object);
                                bl2 = true;
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case 91: {
                            nArray6[n7] = MODE.DATE.value;
                            stringArray[n7] = object;
                            nArray[n7] = ((String)object).length();
                            bl2 = true;
                            break;
                        }
                        case 92: {
                            nArray6[n7] = MODE.TIME.value;
                            stringArray[n7] = object;
                            nArray[n7] = ((String)object).length();
                            bl2 = true;
                            break;
                        }
                        case 93: {
                            nArray6[n7] = MODE.TIMESTAMP.value;
                            stringArray[n7] = object;
                            nArray[n7] = ((String)object).length();
                            bl2 = true;
                            break;
                        }
                        case -6: 
                        case -5: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            int n3;
                            int n8;
                            if (((String)object).startsWith("A")) {
                                nArray6[n7] = MODE.STRING.value;
                                object = ((String)object).substring(1, ((String)object).length());
                                try {
                                    nArray[n7] = n8 = Integer.parseInt((String)object);
                                    bl2 = true;
                                }
                                catch (Exception exception) {}
                                break;
                            }
                            nArray6[n7] = MODE.NUMERIC.value;
                            block54: for (n3 = 0; n3 < ((String)object).length(); ++n3) {
                                switch (((String)object).charAt(n3)) {
                                    case '.': 
                                    case '9': {
                                        int n4 = n7;
                                        nArray[n4] = nArray[n4] + 1;
                                        bl2 = true;
                                        continue block54;
                                    }
                                    case '0': {
                                        int n5 = n7;
                                        nArray6[n5] = nArray6[n5] | MODE.ZERO_PADDING.value;
                                        continue block54;
                                    }
                                    case 'B': {
                                        int n6 = n7;
                                        nArray6[n6] = nArray6[n6] | MODE.BLANK_IF_ZERO.value;
                                        continue block54;
                                    }
                                    case '$': {
                                        int n9 = n7;
                                        nArray[n9] = nArray[n9] + 1;
                                        bl2 = true;
                                        int n10 = n7;
                                        nArray6[n10] = nArray6[n10] | MODE.DOLLAR_SIGN.value;
                                        continue block54;
                                    }
                                    case ',': {
                                        int n11 = n7;
                                        nArray[n11] = nArray[n11] + 1;
                                        bl2 = true;
                                        int n12 = n7;
                                        nArray6[n12] = nArray6[n12] | MODE.COMMAS.value;
                                    }
                                }
                            }
                            if (((String)object).indexOf("MI") > 0) {
                                int n13 = n7;
                                nArray6[n13] = nArray6[n13] | MODE.MI.value;
                            }
                            if (((String)object).indexOf("PR") > 0) {
                                int n14 = n7;
                                nArray6[n14] = nArray6[n14] | MODE.PR.value;
                            }
                            object = ((String)object).replace("MI", "");
                            object = ((String)object).replace("PR", "");
                            object = ((String)object).replace("mi", "");
                            stringArray[n7] = object = ((String)object).replace("pr", "");
                            n3 = ((String)object).indexOf(".");
                            if (n3 <= -1) break;
                            nArray2[n7] = ((String)object).length() - n3 - 1;
                        }
                    }
                }
            }
            nArray3[n7] = bl2 ? nArray[n7] : (object4.length() > nArray[n7] + 1 ? object4.length() : nArray[n7] + 2);
            switch (nArray7[n7]) {
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    stringBuilder.append(ScriptsPane.padRight((String)object4, nArray3[n7]));
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    stringBuilder.append(ScriptsPane.padRight((String)object4, nArray3[n7]));
                    break;
                }
                default: {
                    if (nArray6[n7] == MODE.STRING.value) {
                        stringBuilder.append(ScriptsPane.padRight((String)object4, nArray3[n7]));
                        break;
                    }
                    if (bl2) {
                        stringBuilder.append(ScriptsPane.padLeft((String)object4, nArray3[n7] + 2));
                        break;
                    }
                    stringBuilder.append(ScriptsPane.padLeft((String)object4, nArray3[n7]));
                }
            }
            stringBuilder.append("| ");
            ++n7;
        }
        stringBuilder.append("\r\n\r\n");
        String string4 = " ";
        string32 = " ";
        for (Row row : columnsTable.rows) {
            n7 = 0;
            for (String string : row.values) {
                Object object5 = string;
                String string6 = "";
                string4 = " ";
                string32 = " ";
                if (nArray6[n7] > MODE.NULL.value) {
                    stringBuilder2.setLength(0);
                    if ((nArray6[n7] & MODE.NUMERIC.value) > 0) {
                        if (string.equals("(null)")) {
                            stringBuilder.append(ScriptsPane.padLeft(string, nArray3[n7] + 2, ' '));
                        } else {
                            int n15 = string.indexOf(".");
                            if (n15 > 0) {
                                object5 = string.substring(0, n15);
                                string6 = string.substring(n15);
                            } else {
                                object5 = string;
                                string6 = "";
                            }
                            if (nArray2[n7] > 0) {
                                if (n15 > 0) {
                                    String string7 = ScriptsPane.padRight(string, 100, '0');
                                    string6 = string7.substring(n15, n15 + nArray2[n7] + 1);
                                } else {
                                    string6 = "." + ScriptsPane.padRight(new String(), nArray2[n7] - 1, '0');
                                }
                            } else {
                                string6 = "";
                            }
                            double d = 0.0;
                            try {
                                d = Double.parseDouble(string);
                                if (d < 0.0) {
                                    string4 = "-";
                                    if ((nArray6[n7] & MODE.PR.value) > 0) {
                                        string4 = "<";
                                        string32 = ">";
                                    }
                                    if ((nArray6[n7] & MODE.MI.value) > 0) {
                                        string4 = " ";
                                        string32 = "-";
                                    }
                                    object5 = ((String)object5).substring(1, ((String)object5).length());
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            int n16 = 0;
                            String string8 = "";
                            if ((nArray6[n7] & MODE.DOLLAR_SIGN.value) > 0) {
                                n16 = 1;
                                string8 = "$";
                            }
                            if ((nArray6[n7] & MODE.BLANK_IF_ZERO.value) > 0 && d == 0.0) {
                                stringBuilder2.append(ScriptsPane.padRight(new String(), nArray[n7] + 2, ' '));
                            } else if (((String)object5).length() + string6.length() + n16 > nArray[n7]) {
                                stringBuilder2.append(" ").append(ScriptsPane.padRight("", nArray[n7], '#')).append(" ");
                            } else {
                                String string9;
                                if ((nArray6[n7] & MODE.COMMAS.value) > 0) {
                                    StringBuilder stringBuilder3 = new StringBuilder(128);
                                    int n17 = stringArray[n7].indexOf(46);
                                    string9 = "";
                                    String string10 = "";
                                    if (n17 > 0) {
                                        string9 = stringArray[n7].substring(0, n17);
                                        string10 = stringArray[n7].substring(n17 + 1);
                                    } else {
                                        string9 = stringArray[n7];
                                    }
                                    if ((nArray6[n7] & MODE.ZERO_PADDING.value) > 0) {
                                        object5 = ScriptsPane.padLeft((String)object5, nArray[n7] - string10.length() - 1, '0');
                                    }
                                    int n18 = ((String)object5).length() - 1;
                                    for (int i = string9.length() - 1; n18 >= 0 && i >= 0; --n18, --i) {
                                        if (string9.charAt(i) == '9') {
                                            stringBuilder3.insert(0, ((String)object5).charAt(n18));
                                            continue;
                                        }
                                        if (string9.charAt(i) != ',') continue;
                                        stringBuilder3.insert(0, ',');
                                        ++n18;
                                    }
                                    while (n18 >= 0) {
                                        stringBuilder3.insert(0, ((String)object5).charAt(n18));
                                        --n18;
                                    }
                                    object5 = stringBuilder3.toString();
                                }
                                stringBuilder2.insert(0, string32);
                                int n19 = 0;
                                if (nArray2[n7] > 0) {
                                    stringBuilder2.insert(0, ScriptsPane.padRight(string6, nArray2[n7] + 1, '0'));
                                    n19 = 1;
                                }
                                String string11 = "";
                                if (nArray[n7] - (((String)object5).length() + nArray2[n7] + n19) > 0) {
                                    string11 = ScriptsPane.padRight("", nArray[n7] - (((String)object5).length() + nArray2[n7] + n19 + n16), ' ');
                                }
                                string9 = "";
                                if ((nArray6[n7] & MODE.ZERO_PADDING.value) > 0 && (nArray6[n7] & MODE.COMMAS.value) == 0) {
                                    string9 = ScriptsPane.padRight("", nArray[n7] - (((String)object5).length() + nArray2[n7] + n19 + n16), '0');
                                    string11 = "";
                                }
                                stringBuilder2.insert(0, string11 + string4 + string8 + string9 + (String)object5);
                            }
                            if (stringBuilder2.length() < nArray3[n7]) {
                                stringBuilder2.insert(0, ScriptsPane.padRight("", nArray3[n7] - stringBuilder2.length(), ' '));
                            }
                            stringBuilder.append((CharSequence)stringBuilder2);
                        }
                    } else if ((nArray6[n7] & MODE.DATE.value) > 0) {
                        try {
                            object5 = this.formatDate(string, stringArray[n7]);
                        }
                        catch (Exception exception) {
                            object5 = "Error";
                        }
                        stringBuilder.append(ScriptsPane.padLeft((String)object5, nArray3[n7], ' '));
                    } else if ((nArray6[n7] & MODE.TIME.value) > 0) {
                        try {
                            object5 = this.formatTime(string, stringArray[n7]);
                        }
                        catch (Exception exception) {
                            object5 = "Error";
                        }
                        stringBuilder.append(ScriptsPane.padLeft((String)object5, nArray3[n7], ' '));
                    } else if ((nArray6[n7] & MODE.TIMESTAMP.value) > 0) {
                        try {
                            object5 = this.formatTimestamp(string, stringArray[n7]);
                        }
                        catch (Exception exception) {
                            object5 = "Error";
                        }
                        stringBuilder.append(ScriptsPane.padLeft((String)object5, nArray3[n7], ' '));
                    } else {
                        stringBuilder.append(ScriptsPane.padRight(string, nArray3[n7], ' '));
                    }
                } else {
                    switch (nArray7[n7]) {
                        case -16: 
                        case -15: 
                        case -9: 
                        case -4: 
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2004: 
                        case 2005: {
                            stringBuilder.append(ScriptsPane.padRight(string, nArray3[n7], ' '));
                            break;
                        }
                        case 91: {
                            object5 = this.formatDate(string, null);
                            if (((String)object5).length() < nArray3[n7]) {
                                object5 = ScriptsPane.padLeft((String)object5, nArray3[n7], ' ');
                            }
                            stringBuilder.append((String)object5);
                            break;
                        }
                        case 92: {
                            object5 = this.formatTime(string, null);
                            if (((String)object5).length() < nArray3[n7]) {
                                object5 = ScriptsPane.padLeft((String)object5, nArray3[n7], ' ');
                            }
                            stringBuilder.append((String)object5);
                            break;
                        }
                        case 93: {
                            object5 = this.formatTimestamp(string, null);
                            if (((String)object5).length() < nArray3[n7]) {
                                object5 = ScriptsPane.padLeft((String)object5, nArray3[n7], ' ');
                            }
                            stringBuilder.append((String)object5);
                            break;
                        }
                        default: {
                            if (string.equals("(null)")) {
                                object5 = string;
                            } else {
                                String[] stringArray3 = string.split("\\.");
                                if (stringArray3.length == 1) {
                                    object5 = stringArray3[0];
                                    if (nArray4[n7] > 0) {
                                        object5 = (String)object5 + ".";
                                        object5 = (String)object5 + ScriptsPane.padRight("", nArray4[n7], '0');
                                    }
                                } else if (stringArray3.length > 1) {
                                    String string12 = ScriptsPane.padRight(stringArray3[1], nArray4[n7], '0');
                                    object5 = stringArray3[0];
                                    object5 = (String)object5 + ".";
                                    object5 = (String)object5 + string12;
                                }
                                object5 = ScriptsPane.padLeft((String)object5, nArray5[n7] + nArray4[n7] + 1, ' ');
                            }
                            if (((String)object5).length() < nArray3[n7]) {
                                object5 = ScriptsPane.padLeft((String)object5, nArray3[n7], ' ');
                            }
                            stringBuilder.append((String)object5);
                        }
                    }
                }
                stringBuilder.append("| ");
                ++n7;
            }
            stringBuilder.append("\r\n");
        }
        stringBuilder.append("\r\n").append(l).append(" record(s) selected\r\n");
        if (n2 != -1) {
            stringBuilder.append("\r\n").append("(fetch truncated, other rows may exist)");
        }
        stringBuilder.append("\r\n");
        if (this.outFile != null) {
            try {
                this.outFile.write(stringBuilder.toString());
            }
            catch (IOException iOException) {
                Logger.getLogger(ScriptsPane.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
        if ((!this.scriptRunMode || this.scriptMode == RUN_MODE.SCREEN) && bl) {
            this.appFrame.resultTA.append(stringBuilder.toString());
        }
        return true;
    }

    private String[] splitString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = new String[1];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != ' ') {
                if (c == '\"') {
                    bl = !bl;
                }
                ++n2;
                continue;
            }
            if (bl) {
                ++n2;
                continue;
            }
            arrayList.add(string.substring(n, n2));
            n = n2;
            ++n3;
            while (c == ' ' && i < string.length()) {
                ++n;
                ++n2;
                c = string.charAt(++i);
            }
            --i;
        }
        String string2 = string.substring(n, n2);
        while (string2.endsWith(";")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        arrayList.add(string2);
        return arrayList.toArray(stringArray);
    }

    private static String padRight(String string, int n) {
        return ScriptsPane.padRight(string, n, ' ');
    }

    private static String padLeft(String string, int n) {
        return ScriptsPane.padLeft(string, n, ' ');
    }

    public static String padRight(String string, int n, char c) {
        int n2 = n - string.length();
        if (n < string.length()) {
            return string.substring(0, n);
        }
        return string.concat(ScriptsPane.padding(n2, c));
    }

    public static String padLeft(String string, int n, char c) {
        int n2 = n - string.length();
        if (n < string.length()) {
            return string.substring(0, n);
        }
        return ScriptsPane.padding(n2, c).concat(string);
    }

    private static String padding(int n, char c) {
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = c;
        }
        return new String(cArray);
    }

    private String formatDate(String string, String string2) {
        if (string.equals("(null)")) {
            return string;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
            Date date = simpleDateFormat.parse(string);
            DateFormat dateFormat = null;
            if (string2 == null) {
                dateFormat = DateFormat.getDateInstance(3);
                if (dateFormat != null) {
                    String string3 = dateFormat.format(date);
                    return string3;
                }
            } else {
                simpleDateFormat = new SimpleDateFormat(string2);
                return simpleDateFormat.format(date);
            }
            return string;
        }
        catch (Exception exception) {
            return "FORMAT ERROR";
        }
    }

    private String formatTime(String string, String string2) {
        if (string.equals("(null)")) {
            return string;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
            Date date = simpleDateFormat.parse(string);
            DateFormat dateFormat = null;
            if (string2 == null) {
                dateFormat = DateFormat.getTimeInstance(2);
                if (dateFormat != null) {
                    String string3 = dateFormat.format(date);
                    return string3;
                }
            } else {
                simpleDateFormat = new SimpleDateFormat(string2);
                return simpleDateFormat.format(date);
            }
            return string;
        }
        catch (Exception exception) {
            return "FORMAT ERROR";
        }
    }

    private String formatTimestamp(String string, String string2) {
        if (string.equals("(null)")) {
            return string;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
            Date date = simpleDateFormat.parse(string);
            DateFormat dateFormat = null;
            DateFormat dateFormat2 = null;
            if (string2 == null) {
                dateFormat = DateFormat.getDateInstance(3);
                dateFormat2 = DateFormat.getTimeInstance(2);
                if (dateFormat != null && dateFormat2 != null) {
                    String string3 = dateFormat.format(date);
                    string3 = string3 + " " + dateFormat2.format(date);
                    return string3;
                }
            } else {
                simpleDateFormat = new SimpleDateFormat(string2);
                return simpleDateFormat.format(date);
            }
            return string;
        }
        catch (Exception exception) {
            return "FORMAT ERROR";
        }
    }

    public void showScriptError(SQLException sQLException, String string) {
        String string2 = "Error : " + sQLException.getErrorCode() + "    Error Description : " + sQLException.getMessage() + "\n";
        if (!this.scriptRunMode || this.scriptMode == RUN_MODE.SCREEN) {
            if (sQLException instanceof CtreeSQLException) {
                CtreeSQLException ctreeSQLException = (CtreeSQLException)sQLException;
                this.appFrame.showErrorPos(ctreeSQLException.getErrorCode(), ctreeSQLException.getErrorPosition(), string);
                this.appFrame.resultTA.append(string2 + "\n");
            } else {
                this.appFrame.showErrorPos(0, 0, string);
                this.appFrame.resultTA.append(string2 + "\n");
            }
        }
        if (this.outFile != null) {
            try {
                this.outFile.write(string2 + "\n");
            }
            catch (IOException iOException) {
                Logger.getLogger(ScriptsPane.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    private void doEcho(String string) {
        if (this.scEcho || this.appFrame.scriptEchoCB.isSelected()) {
            this.appFrame.resultTA.append(string.trim() + "\n");
            this.appFrame.resultTA.setCaretPosition(this.appFrame.resultTA.getText().length());
        }
    }

    private void parseScript() {
        int n;
        int n2;
        int n3;
        this.appFrame = Globals.appFrame;
        this.parsing = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        int n4 = 1;
        this.statements.rows.clear();
        this.columnsFormatTable.columnFormat.clear();
        Element element = this.doc.getDefaultRootElement();
        int n5 = element.getElementCount();
        for (n3 = 0; n3 < n5; ++n3) {
            Element element2 = element.getElement(n3);
            n2 = element2.getStartOffset();
            n = element2.getEndOffset();
            try {
                String string = this.getText(n2, n - n2);
                boolean bl = false;
                do {
                    bl = false;
                    ScriptRow scriptRow = n4 > this.statements.rows.size() ? this.statements.newRow() : this.statements.rows.get(n4 - 1);
                    scriptRow.statement = string;
                    scriptRow.start = n2;
                    scriptRow.length = string.length();
                    scriptRow.type = ROW_TYPE.NULL;
                    if (n4 > this.statements.rows.size()) {
                        this.statements.rows.add(scriptRow);
                    }
                    ++n4;
                } while (bl);
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        n3 = 0;
        boolean bl = false;
        n2 = 0;
        n = 0;
        for (ScriptRow scriptRow : this.statements.rows) {
            String string = scriptRow.statement.trim().toLowerCase();
            n2 = scriptRow.start;
            n = scriptRow.length;
            if (string.isEmpty()) {
                scriptRow.type = ROW_TYPE.NULL;
                continue;
            }
            if (n3 != 0) {
                scriptRow.type = ROW_TYPE.CREATE;
                if (this.colorize) {
                    this.doc.setCharacterAttributes(n2, n, this.slateBlueStyle, true);
                }
                if (!string.equals("end") && !string.equals("end;")) continue;
                n3 = 0;
                continue;
            }
            Matcher matcher = this.createProc_regex.matcher(string);
            Matcher matcher2 = this.createTrigger_regex.matcher(string);
            Matcher matcher3 = this.createUDF_regex.matcher(string);
            if (matcher.find() || matcher2.find() || matcher3.find()) {
                scriptRow.type = ROW_TYPE.CREATE;
                n3 = 1;
                if (!this.colorize) continue;
                this.doc.setCharacterAttributes(n2, n, this.slateBlueStyle, true);
                continue;
            }
            if (bl) {
                scriptRow.type = ROW_TYPE.IF_CLAUSE;
                if (this.colorize) {
                    this.doc.setCharacterAttributes(n2, n, this.blueStyle, true);
                }
                if (string.equals(")") || string.equals(");")) {
                    bl = false;
                    if (this.colorize) {
                        this.doc.setCharacterAttributes(n2, n, this.redStyle, true);
                    }
                    scriptRow.type = ROW_TYPE.STATEMENT;
                    continue;
                }
            }
            if (this.ifexist_regex.matcher(string).find() || this.ifexist2_regex.matcher(string).find()) {
                scriptRow.type = ROW_TYPE.IF_CLAUSE;
                bl = true;
                if (!this.colorize) continue;
                this.doc.setCharacterAttributes(n2, n, this.redStyle, true);
                continue;
            }
            if (this.ifnotexist_regex.matcher(string).find() || this.ifnotexist2_regex.matcher(string).find()) {
                scriptRow.type = ROW_TYPE.IF_CLAUSE;
                bl = true;
                if (!this.colorize) continue;
                this.doc.setCharacterAttributes(n2, n, this.redStyle, true);
                continue;
            }
            if (this.comment_regex.matcher(string).find()) {
                scriptRow.type = ROW_TYPE.COMMENT;
                if (!this.colorize) continue;
                this.doc.setCharacterAttributes(n2, n, this.blackStyle, true);
                continue;
            }
            if (this.setSchema_regex.matcher(string).find()) {
                scriptRow.type = ROW_TYPE.STATEMENT;
                continue;
            }
            if (this.set_regex.matcher(string).find()) {
                scriptRow.type = ROW_TYPE.SET;
                if (!this.colorize) continue;
                this.doc.setCharacterAttributes(n2, n, this.salmonStyle, true);
                continue;
            }
            if (this.column_regex.matcher(string).find()) {
                scriptRow.type = ROW_TYPE.COLUMN;
                if (!this.colorize) continue;
                this.doc.setCharacterAttributes(n2, n, this.tomatoStyle, true);
                continue;
            }
            if (this.spool_regex.matcher(string).find()) {
                scriptRow.type = ROW_TYPE.SPOOL;
                if (!this.colorize) continue;
                this.doc.setCharacterAttributes(n2, n, this.saddleBrownStyle, true);
                continue;
            }
            if (this.command_regex.matcher(string).find()) {
                scriptRow.type = ROW_TYPE.COMMAND;
                if (!this.colorize) continue;
                this.doc.setCharacterAttributes(n2, n, this.saddleBrownStyle, true);
                continue;
            }
            if (this.echo_regex.matcher(string).find()) {
                scriptRow.type = ROW_TYPE.ECHO;
                if (!this.colorize) continue;
                this.doc.setCharacterAttributes(n2, n, this.greenStyle, true);
                continue;
            }
            if (this.begin_regex.matcher(string).find()) {
                this.insideBegin = true;
                scriptRow.type = ROW_TYPE.BEGIN;
                if (!this.colorize) continue;
                this.doc.setCharacterAttributes(n2, n, this.redStyle, true);
                continue;
            }
            if (this.end_regex.matcher(string).find()) {
                this.insideBegin = false;
                scriptRow.type = ROW_TYPE.END;
                if (!this.colorize) continue;
                this.doc.setCharacterAttributes(n2, n, this.redStyle, true);
                continue;
            }
            if (this.else_regex.matcher(string).find()) {
                this.insideElse = true;
                scriptRow.type = ROW_TYPE.ELSE;
                if (!this.colorize) continue;
                this.doc.setCharacterAttributes(n2, n, this.redStyle, true);
                continue;
            }
            scriptRow.type = ROW_TYPE.STATEMENT;
            if (!this.colorize) continue;
            this.doc.setCharacterAttributes(n2, n, this.blueStyle, true);
        }
        this.parsing = false;
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void setControls(boolean bl) {
        Component[] componentArray;
        for (Component component : componentArray = this.appFrame.scriptsToolBar.getComponents()) {
            component.setEnabled(bl);
        }
        this.appFrame.setControls(bl);
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$ctreeaceexplorer$sql$ScriptsPane$ROW_TYPE;

        static {
            $SwitchMap$ctreeaceexplorer$sql$ScriptsPane$ROW_TYPE = new int[ROW_TYPE.values().length];
            try {
                1.$SwitchMap$ctreeaceexplorer$sql$ScriptsPane$ROW_TYPE[ROW_TYPE.ECHO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$ctreeaceexplorer$sql$ScriptsPane$ROW_TYPE[ROW_TYPE.COMMAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$ctreeaceexplorer$sql$ScriptsPane$ROW_TYPE[ROW_TYPE.SPOOL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$ctreeaceexplorer$sql$ScriptsPane$ROW_TYPE[ROW_TYPE.SET.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$ctreeaceexplorer$sql$ScriptsPane$ROW_TYPE[ROW_TYPE.COLUMN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$ctreeaceexplorer$sql$ScriptsPane$ROW_TYPE[ROW_TYPE.CREATE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$ctreeaceexplorer$sql$ScriptsPane$ROW_TYPE[ROW_TYPE.IF_CLAUSE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$ctreeaceexplorer$sql$ScriptsPane$ROW_TYPE[ROW_TYPE.STATEMENT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    class PopupActions2
    implements ActionListener {
        JTextArea pane;

        PopupActions2() {
        }

        public void setupPane(JTextArea jTextArea) {
            this.pane = jTextArea;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Copy") && this.pane != null) {
                String string2 = this.pane.getSelectedText();
                StringSelection stringSelection = new StringSelection(string2);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, stringSelection);
            } else if (string.equals("Clear") && this.pane != null) {
                this.pane.setText("");
            }
        }
    }

    class PopupActions
    implements ActionListener {
        ScriptsPane pane;

        public PopupActions(ScriptsPane scriptsPane2) {
            this.pane = scriptsPane2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Copy")) {
                String string2 = this.pane.getSelectedText();
                StringSelection stringSelection = new StringSelection(string2);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, stringSelection);
            } else if (string.equals("Paste")) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable transferable = clipboard.getContents(clipboard);
                if (transferable != null) {
                    try {
                        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            String string3 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                            this.pane.replaceSelection(string3);
                        }
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        System.err.println("Flavor unsupported: " + unsupportedFlavorException);
                    }
                    catch (IOException iOException) {
                        System.err.println("Data not available: " + iOException);
                    }
                }
            } else if (string.equals("Exec Selected")) {
                if (!this.pane.selectedRows.isEmpty()) {
                    String string4 = "";
                    for (ScriptRow scriptRow : this.pane.selectedRows) {
                        if (scriptRow.type != ROW_TYPE.STATEMENT) continue;
                        string4 = string4 + scriptRow.statement;
                    }
                    if (!string4.isEmpty()) {
                        ScriptsPane.this.execStmt(string4, true);
                    }
                }
            } else if (string.equals("ExecPlan Selected")) {
                if (!this.pane.selectedRows.isEmpty()) {
                    String string5 = "";
                    for (ScriptRow scriptRow : this.pane.selectedRows) {
                        if (scriptRow.type != ROW_TYPE.STATEMENT) continue;
                        string5 = string5 + scriptRow.statement + " ";
                        string5 = string5.replace("\n", "");
                    }
                    if (!(string5 = string5.replace(";", "")).isEmpty()) {
                        ScriptsPane.this.appFrame.execPlan(string5);
                    }
                }
            } else if (!string.equals("Run To Cursor") && string.equals("Clear Script")) {
                this.pane.setText("");
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        ScriptsPane pane;

        public PopupListener(ScriptsPane scriptsPane2) {
            this.pane = scriptsPane2;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component.getClass() == ScriptsPane.class) {
                this.pane.selectStatement();
            }
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                Component component = mouseEvent.getComponent();
                if (component.getClass() == ScriptsPane.class) {
                    Component[] componentArray;
                    for (Component component2 : componentArray = ScriptsPane.this.contextMenu.getComponents()) {
                        JMenuItem jMenuItem;
                        String string;
                        if (!(component2 instanceof JMenuItem) || !(string = (jMenuItem = (JMenuItem)component2).getText()).equals("Exec Selected") && !string.equals("ExecPlan Selected")) continue;
                        if (this.pane.selectedRows.isEmpty()) {
                            jMenuItem.setEnabled(false);
                            continue;
                        }
                        jMenuItem.setEnabled(true);
                    }
                    ScriptsPane.this.contextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else {
                    ScriptsPane.this.contextMenu2.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    public class ScriptRow {
        public String statement;
        public int start;
        public int length;
        public ROW_TYPE type;
    }

    public class ScriptStatements {
        ArrayList<ScriptRow> rows = new ArrayList();

        public ScriptRow newRow() {
            ScriptRow scriptRow = new ScriptRow();
            return scriptRow;
        }
    }

    public class ColumnFormat {
        public String name;
        public String format;
        public String heading;
    }

    public class ColumnsFormatTable {
        ArrayList<ColumnFormat> columnFormat = new ArrayList();

        public ColumnFormat newRow() {
            ColumnFormat columnFormat = new ColumnFormat();
            columnFormat.format = "";
            columnFormat.heading = "";
            columnFormat.name = "";
            return columnFormat;
        }

        private ColumnFormat select(String string) {
            for (ColumnFormat columnFormat : this.columnFormat) {
                if (!columnFormat.name.equals(string)) continue;
                return columnFormat;
            }
            return null;
        }
    }

    public class Row {
        ArrayList<String> values = new ArrayList();
    }

    public class Column {
        public int colNumber;
        public String colName;
    }

    public class ColumnsTable {
        ArrayList<Column> columns = new ArrayList();
        ArrayList<Row> rows = new ArrayList();

        private Column select(String string) {
            for (Column column : this.columns) {
                if (!column.colName.equals(string)) continue;
                return column;
            }
            return null;
        }
    }

    protected class MyDocumentListener
    implements DocumentListener {
        protected MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!ScriptsPane.this.parsing) {
                ScriptsPane.this.timer.start();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (!ScriptsPane.this.parsing) {
                ScriptsPane.this.timer.start();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    public class RunSomeTask
    implements Runnable {
        @Override
        public void run() {
            ScriptsPane.this.stopThread = false;
            ScriptsPane.this.runScript();
        }
    }

    public class RunSomeTask2
    implements Runnable {
        String reader;

        public RunSomeTask2(String string) {
            this.reader = string;
        }

        @Override
        public void run() {
            ScriptsPane.this.stopThread = false;
            ScriptsPane.this.runScriptInRunMode(this.reader);
        }
    }

    class MyTimerActionListener
    implements ActionListener {
        ScriptsPane pane;

        public MyTimerActionListener(ScriptsPane scriptsPane2) {
            this.pane = scriptsPane2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.pane.getCaretPosition();
            ScriptsPane.this.parseScript();
            this.pane.setCaretPosition(n);
            ScriptsPane.this.timer.stop();
        }
    }

    private static enum MODE {
        NULL(0),
        ZERO_PADDING(1),
        DOLLAR_SIGN(2),
        BLANK_IF_ZERO(4),
        NUMERIC(8),
        STRING(16),
        COMMAS(32),
        MI(64),
        PR(128),
        DATE(256),
        TIME(512),
        TIMESTAMP(1024);

        private int value;

        private MODE(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }
    }

    private static enum ROW_TYPE {
        NULL,
        BEGIN,
        END,
        ECHO,
        ELSE,
        COMMAND,
        COMMENT,
        SPOOL,
        SET,
        COLUMN,
        CREATE,
        IF_CLAUSE,
        STATEMENT;

    }

    public static enum RUN_MODE {
        NO_OUTPUT,
        SCREEN,
        FILE;

    }

    private static enum SC_STATE {
        RUNNING,
        PAUSED,
        STOPPED,
        SSTEP;

    }
}

