/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import FairCom.Helper.Classes.CtreeServer;
import FairCom.Helper.Dialogs.ConnectDialog;
import ctree.jdbc.CtreeConnection;
import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.EXIT_CODE;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.MyTreeNode;
import ctreeaceexplorer.TREE_OBJECT;
import ctreeaceexplorer.sql.SqlTableColumn;
import ctreeaceexplorer.sql.TmpUser;
import java.awt.Component;
import java.awt.Frame;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SqlConnection
extends CtreeServer {
    private Connection conn;
    private String selectedUser;
    private String selectedTableName;
    private boolean supportIdentity;
    private int queryTimeout;
    private MyTreeNode treeNode;
    public ArrayList<SqlTableColumn> tableColumnsForRecords = new ArrayList();
    public ArrayList<String> uniqueColumns = new ArrayList();
    public String whereClause = "";
    public String orderByClause = "";
    public String topClause = "";
    public String sqlStatement = "";

    public SqlConnection(CtreeServer ctreeServer, boolean bl, boolean bl2) {
        super(ctreeServer);
        if (bl2) {
            this.connect(bl);
        }
    }

    public SqlConnection(CtreeServer ctreeServer, String string, boolean bl, boolean bl2) {
        super(ctreeServer);
        this.setDatabaseName(string);
        if (bl2) {
            this.connect(bl);
        }
    }

    public void close() {
        try {
            this.conn.close();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(SqlConnection.class.getName()).log(Level.SEVERE, null, sQLException);
        }
    }

    void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(SqlConnection.class.getName()).log(Level.SEVERE, null, sQLException);
        }
    }

    public void commit() {
        try {
            if (this.conn != null) {
                this.conn.commit();
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(SqlConnection.class.getName()).log(Level.SEVERE, null, sQLException);
        }
    }

    public void rollback() {
        try {
            if (this.conn != null) {
                this.conn.rollback();
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(SqlConnection.class.getName()).log(Level.SEVERE, null, sQLException);
        }
    }

    public void setAutoCommit(boolean bl) {
        try {
            if (this.conn != null) {
                this.conn.setAutoCommit(bl);
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(SqlConnection.class.getName()).log(Level.SEVERE, null, sQLException);
        }
    }

    public int getTransactionIsolation() {
        try {
            if (this.conn != null) {
                return this.conn.getTransactionIsolation();
            }
            return -1;
        }
        catch (SQLException sQLException) {
            return -1;
        }
    }

    public void setTransactionIsolation(int n) {
        try {
            if (this.conn != null) {
                this.conn.setTransactionIsolation(n);
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(SqlConnection.class.getName()).log(Level.SEVERE, null, sQLException);
        }
    }

    private boolean connect(boolean bl) {
        try {
            Object object;
            int n;
            Object object2;
            Object object3;
            if (bl || this.getPassword().isEmpty()) {
                object3 = CtreeACEExplorerApp.getApplication().getMainFrame();
                object2 = new ConnectDialog((Frame)object3, true);
                object2.setLocationRelativeTo((Component)object3);
                Boolean bl2 = object2.showDialog((CtreeServer)this, true);
                if (!bl2.booleanValue()) {
                    return false;
                }
            }
            Class.forName("ctree.jdbc.ctreeDriver");
            object3 = "jdbc:ctree://" + this.getHostNameOrAddress() + ":" + this.getSqlServerPort() + "/" + this.getDatabaseName();
            object2 = this.getCharset();
            if (((String)object2).length() > 2) {
                object3 = (String)object3 + "?characterEncoding=" + (String)object2;
            }
            if ((n = this.getSslMode()) == 1) {
                object3 = (String)object3 + "?ssl=basic";
            } else if (n == 2) {
                object3 = (String)object3 + "?ssl=peerAuthentication";
            }
            String string = this.getLoggedUser();
            String string2 = this.getPassword();
            this.conn = DriverManager.getConnection((String)object3, string, string2);
            if (!Globals.appProps.sqlAutoCommit) {
                this.conn.setAutoCommit(false);
                this.conn.setTransactionIsolation(Globals.appProps.sqlIsolationLevel);
            }
            this.setConnected(true);
            this.readUsers();
            try {
                object = this.conn.createStatement();
                object.executeQuery("select count(*) from admin.sysidentity");
                this.supportIdentity = true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                object = System.getenv("COMPUTERNAME");
                if (object == null) {
                    object = System.getenv("HOSTNAME");
                }
                if (object == null) {
                    object = "c-treeACE Explorer";
                }
                Statement statement = this.conn.createStatement();
                statement.execute("call fc_set_nodename ('" + (String)object + "')");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return true;
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "Connection Error");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Globals.showException(classNotFoundException, "Connection Error");
            System.out.println("Class Not Found Exception: " + classNotFoundException.toString());
        }
        return false;
    }

    public void disconnect() {
        if (this.conn != null) {
            this.close();
        }
        this.setConnected(false);
    }

    public boolean changeDb(String string) {
        if (this.conn != null) {
            this.disconnect();
            this.setDatabaseName(string);
            return this.connect(false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDatabaseVersion() {
        int n = 0;
        try {
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery("call fc_db_version()");
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        finally {
            return n;
        }
    }

    public String getServerId() {
        if (this.getHostNameOrAddress().length() > 0) {
            return this.getSqlServerPort() + "@" + this.getHostNameOrAddress();
        }
        return this.getSqlServerPort() + "";
    }

    public boolean isIdentitySupported() {
        return this.supportIdentity;
    }

    public boolean isUnicodeServer() {
        CtreeConnection ctreeConnection = (CtreeConnection)this.conn;
        try {
            return ctreeConnection.isUnicodeServer();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public String getSelectedUser() {
        return this.selectedUser;
    }

    public void setSelectedUser(String string) {
        this.selectedUser = string;
    }

    public ArrayList<TmpUser> readUsersArray() {
        ArrayList<TmpUser> arrayList = new ArrayList<TmpUser>();
        try {
            if (this.conn != null) {
                Object object;
                Statement statement = this.conn.createStatement();
                ResultSet resultSet = statement.executeQuery("call fc_get_userlist()");
                while (resultSet.next()) {
                    object = new TmpUser();
                    ((TmpUser)object).Name = resultSet.getString(1);
                    ((TmpUser)object).isDBA = resultSet.getString(2);
                    ((TmpUser)object).hasResource = resultSet.getString(3);
                    arrayList.add((TmpUser)object);
                }
                resultSet.close();
                object = new StringBuilder();
                boolean bl = true;
                for (TmpUser tmpUser : arrayList) {
                    if (!bl) {
                        ((StringBuilder)object).append(",");
                    }
                    bl = false;
                    ((StringBuilder)object).append("'").append(tmpUser.Name).append("'");
                }
                resultSet = bl ? statement.executeQuery("select distinct owner from admin.systables") : statement.executeQuery("select distinct owner from admin.systables where owner not in (" + object + ") order by owner");
                if (resultSet != null) {
                    while (resultSet.next()) {
                        TmpUser tmpUser;
                        String string = resultSet.getString(1);
                        tmpUser = new TmpUser();
                        tmpUser.Name = resultSet.getString(1);
                        tmpUser.isDBA = "no";
                        tmpUser.hasResource = "no";
                        arrayList.add(tmpUser);
                    }
                }
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readUsersArray");
        }
        return arrayList;
    }

    public ArrayList<String> readUsers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<TmpUser> arrayList2 = this.readUsersArray();
        Globals.isDBA = false;
        Globals.hasResource = false;
        for (TmpUser tmpUser : arrayList2) {
            if (!tmpUser.Name.equals(this.getLoggedUser().toLowerCase())) continue;
            if (tmpUser.isDBA != null && tmpUser.isDBA.equals("Yes")) {
                Globals.isDBA = true;
            }
            if (tmpUser.hasResource == null || !tmpUser.hasResource.equals("Yes")) break;
            Globals.hasResource = true;
            break;
        }
        for (TmpUser tmpUser : arrayList2) {
            if (Globals.isDBA) {
                arrayList.add(tmpUser.Name);
                continue;
            }
            if (!tmpUser.Name.equals(this.getLoggedUser().toLowerCase())) continue;
            arrayList.add("admin");
            arrayList.add(tmpUser.Name);
        }
        return arrayList;
    }

    public ArrayList<String> readObjects(TREE_OBJECT tREE_OBJECT) {
        return this.readObjects(tREE_OBJECT, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> readObjects(TREE_OBJECT tREE_OBJECT, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        int n = 0;
        switch (tREE_OBJECT) {
            case USER: {
                return this.readUsers();
            }
            case DATABASE: {
                string2 = "call fc_get_dbList()";
                break;
            }
            case TABLES: {
                n = Integer.parseInt(string);
                if (n > 1) {
                    string2 = "select tbl, tbl_origin from admin.systables where owner = '" + this.getSelectedUser() + "' and tbltype = 'T' order by tbl";
                    break;
                }
                string2 = "select tbl from admin.systables where owner = '" + this.getSelectedUser() + "' and tbltype = 'T' order by tbl";
                break;
            }
            case SYSTABLES: {
                string2 = "select tbl from admin.systables where tbltype = 'S' order by tbl";
                break;
            }
            case VIEWS: {
                string2 = "select tbl from admin.systables where owner = '" + this.getSelectedUser() + "' and (tbltype = 'V' or tbltype = 'C') order by tbl";
                break;
            }
            case BPROCEDURES: {
                string2 = "select proc_name from admin.sysprocedures where proc_type = 'built_in' and owner = '" + this.getSelectedUser() + "' order by proc_name";
                break;
            }
            case UPROCEDURES: {
                string2 = "select proc_name from admin.sysprocedures where proc_type = 'stored' and owner = '" + this.getSelectedUser() + "' order by proc_name";
                break;
            }
            case UDFS: {
                string2 = "select proc_name from admin.sysprocedures where proc_type = 'udf' and owner = '" + this.getSelectedUser() + "' order by proc_name";
                break;
            }
            case INDEXES: {
                string2 = "select i.idxname from admin.sysindexes i, admin.systables t where tblowner = '" + this.getSelectedUser() + "' and idxseq = 0 and i.tbl = t.tbl and t.owner=i.tblowner and t.tbltype <> 'S' order by i.idxname";
                break;
            }
            case SYSINDEXES: {
                string2 = "select i.idxname from admin.sysindexes i, admin.systables t where tblowner = '" + this.getSelectedUser() + "' and idxseq = 0 and i.tbl = t.tbl and t.tbltype = 'S' order by i.idxname";
                break;
            }
            case TBLINDEXES: {
                string2 = "select idxname from admin.sysindexes where tbl = '" + string + "' and tblowner = '" + this.getSelectedUser() + "' and idxseq = 0 order by idxname";
                break;
            }
            case SYNONYMS: {
                string2 = "select sname from admin.syssynonyms where sowner = '" + this.getSelectedUser() + "' order by sname";
                break;
            }
            case TRIGGERS: {
                string2 = "select triggername from admin.systrigger where owner = '" + this.getSelectedUser() + "' order by triggername";
                break;
            }
            case PLAN_TABLES: {
                string2 = "select distinct tbl from admin.syscolumns where owner = '" + this.getSelectedUser() + "' and col='query_stmt'";
                break;
            }
            case PLAN_TABLE: {
                string2 = "select stmt_id from " + this.getSelectedUser() + "." + string + " where parent_id = -1 order by 1";
                break;
            }
            case COLUMNS: {
                string2 = "select col from admin.syscolumns where owner = '" + this.getSelectedUser() + "' and tbl = '" + string + "'";
                break;
            }
            default: {
                Globals.showMessage("Bad Option", "readObjects");
            }
        }
        try {
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                if (n > 1) {
                    String string3 = resultSet.getString(1);
                    String string4 = resultSet.getString(2);
                    if (string4 != null) {
                        string3 = string3 + "||" + string4;
                    }
                    arrayList.add(string3);
                    continue;
                }
                arrayList.add(resultSet.getString(1));
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "readObjects");
        }
        finally {
            return arrayList;
        }
    }

    public int executeUpdate(String string) throws SQLException {
        Statement statement = this.conn.createStatement();
        return statement.executeUpdate(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet execRsQuery(PreparedStatement preparedStatement) {
        ResultSet resultSet = null;
        try {
            resultSet = preparedStatement.executeQuery();
            return resultSet;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != 26033) {
                Globals.showException(sQLException, "execRsQuery");
            }
        }
        finally {
            return resultSet;
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.conn.createStatement();
        resultSet = statement.executeQuery(string);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet execRsQuery(String string) {
        ResultSet resultSet = null;
        try {
            Statement statement = this.conn.createStatement();
            resultSet = statement.executeQuery(string);
            return resultSet;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != 26033) {
                Globals.showException(sQLException, "execRsQuery");
            }
        }
        finally {
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execRsColumnsQuery(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.selectedTableName = string;
        this.tableColumnsForRecords.clear();
        this.uniqueColumns.clear();
        ResultSet resultSet = null;
        Statement statement = null;
        String string3 = "";
        try {
            statement = this.conn.createStatement();
            string3 = this.supportIdentity ? "select col, coltype, colid from admin.syscolumns cols left join admin.sysidentity ids on cols.owner = ids.owner and cols.tbl = ids.tbl and cols.id = ids.colid  where cols.tbl = '" + string + "' and cols.owner = '" + string2 + "' order by id" : "select col, coltype, NULL from admin.syscolumns where tbl = '" + string + "' and owner = '" + string2 + "' order by id";
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                this.tableColumnsForRecords.add(new SqlTableColumn(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3)));
            }
            resultSet.close();
            resultSet = statement.executeQuery("select cnstrname from admin.sys_tbl_constrs where owner = '" + string2 + "' and tblname = '" + string + "' and cnstrtype in ('P','U')");
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            resultSet.close();
            for (String string4 : arrayList) {
                boolean bl = false;
                resultSet = statement.executeQuery("select colname from admin.sys_keycol_usage where owner = '" + string2 + "' and tblname = '" + string + "' and cnstrname ='" + string4 + "' order by colposition");
                if (resultSet.next()) {
                    bl = true;
                    this.uniqueColumns.add(resultSet.getString(1));
                }
                while (resultSet.next()) {
                    this.uniqueColumns.add(resultSet.getString(1));
                }
                if (!bl) continue;
                break;
            }
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "execRsRecordsQuery");
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(SqlConnection.class.getName()).log(Level.SEVERE, null, sQLException);
            }
        }
    }

    public ResultSet execRsRecordsQuery(String string) {
        return this.execRsRecordsQuery(this.selectedTableName, string, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet execRsRecordsQuery(String string, String string2, int n) {
        this.selectedTableName = string;
        ResultSet resultSet = null;
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (SqlTableColumn object2 : this.tableColumnsForRecords) {
            if (!object2.Selected) continue;
            stringBuilder.append("\"").append(object2.Name).append("\",");
        }
        Object object3 = "select ";
        String string3 = Globals.currentSqlConnection.topClause;
        if (string3.toLowerCase().startsWith("top")) {
            object3 = (String)object3 + string3 + " ";
        }
        String string4 = stringBuilder + " rowid from " + Globals.doubleQuote(string2) + "." + Globals.doubleQuote(string);
        if (!Globals.currentSqlConnection.whereClause.isEmpty()) {
            string4 = string4 + " WHERE " + Globals.currentSqlConnection.whereClause;
        }
        if (!Globals.currentSqlConnection.orderByClause.isEmpty()) {
            string4 = string4 + " ORDER BY " + Globals.currentSqlConnection.orderByClause;
        }
        if (n == 1) {
            string4 = string4 + " CTOPTION(BADREC)";
        }
        this.sqlStatement = "select" + string4;
        try {
            Statement sQLException = this.conn.createStatement();
            resultSet = sQLException.executeQuery((String)object3 + string4);
            return resultSet;
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "execRsRecordsQuery");
            resultSet = null;
            return resultSet;
        }
        finally {
            return resultSet;
        }
    }

    public ResultSet execRsObjectQuery(String string, TREE_OBJECT tREE_OBJECT, Boolean bl) {
        return this.execRsObjectQuery(string, "", tREE_OBJECT, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet execRsObjectQuery(String string, String string2, TREE_OBJECT tREE_OBJECT, Boolean bl) {
        String string3 = "";
        switch (tREE_OBJECT) {
            case TABLES: {
                if (bl.booleanValue()) {
                    string3 = "select 'Rows', id, tbl, creator, owner, tbltype, tblpctfree, segid, has_pcnstrs, has_fcnstrs, has_ccnstrs, has_ucnstrs, tbl_status, rssid from admin.systables where owner = '" + this.getSelectedUser() + "' and tbltype = 'T' order by tbl";
                    break;
                }
                string3 = "select * from admin.systables where owner = '" + this.getSelectedUser() + "' and tbltype = 'T' order by tbl";
                break;
            }
            case TABLE: 
            case TABLE_RTG: 
            case TABLE_LINKED: {
                if (this.supportIdentity) {
                    string3 = "select  id, col, coltype, case when coltype = 'lvarbinary' then '' when coltype = 'lvarchar' then '' else width end as 'width', scale, dflt_value, nullflag , case when colid is null then 'N' else 'Y' end as 'identity', seed, incr, charset, collation  from admin.syscolumns cols left join admin.sysidentity ids on cols.owner = ids.owner and cols.tbl = ids.tbl and cols.id = ids.colid where cols.tbl = '" + string + "' and cols.owner = '" + this.getSelectedUser() + "' order by id";
                    break;
                }
                string3 = "select id, col, coltype, case when coltype = 'lvarbinary' then '' when coltype = 'lvarchar' then '' else width end as 'width', scale, dflt_value, nullflag,   '( n.a. )' as 'identity', '( n.a. )' as 'seed', '( n.a. )' as 'incr', charset, collation  from admin.syscolumns cols where cols.tbl = '" + string + "' and cols.owner = '" + this.getSelectedUser() + "' order by id";
                break;
            }
            case SYSTABLES: {
                string3 = "select * from admin.systables where tbltype = 'S' order by tbl";
                break;
            }
            case SYSTABLE: {
                string3 = "select * from admin.syscolumns where tbl = '" + string + "' order by id";
                break;
            }
            case VIEWS: {
                string3 = "select * from admin.systables where owner = '" + this.getSelectedUser() + "' and (tbltype = 'V' or tbltype = 'C') order by tbl";
                break;
            }
            case VIEW: {
                string3 = "select id, col, coltype, width, scale, dflt_value, nullflag,   '( n.a. )' as 'identity', '( n.a. )' as 'seed', '( n.a. )' as 'incr', charset, collation  from admin.syscolumns cols where cols.tbl = '" + string + "' and cols.owner = '" + this.getSelectedUser() + "' order by id";
                break;
            }
            case BPROCEDURES: {
                string3 = "select * from admin.sysprocedures where proc_type = 'built_in' and owner = '" + this.getSelectedUser() + "' order by proc_name";
                break;
            }
            case UPROCEDURES: {
                string3 = "select * from admin.sysprocedures where proc_type = 'stored' and owner = '" + this.getSelectedUser() + "' order by proc_name";
                break;
            }
            case UDFS: {
                string3 = "select * from admin.sysprocedures where proc_type = 'udf' and owner = '" + this.getSelectedUser() + "' order by proc_name";
                break;
            }
            case BPROCEDURE: 
            case UPROCEDURE: 
            case UDF: {
                string3 = "call admin.sqlprocedurecols2x('',0,'" + this.getSelectedUser() + "',5,'" + string + "','" + string.length() + "','%',1)";
                break;
            }
            case INDEXES: {
                string3 = "select i.id, i.idxname, i.idxowner, i.tbl, i.tblowner, i.idxtype, i.idxorder, i.idxcompress, i.idxmethod,  i.rssid from admin.sysindexes i, admin.systables t where tblowner = '" + this.getSelectedUser() + "' and idxseq = 0 and i.tbl = t.tbl and t.owner=i.tblowner and t.tbltype <> 'S' order by i.idxname";
                break;
            }
            case SYSINDEXES: {
                string3 = "select i.id, i.idxname, i.idxowner, i.tbl, i.tblowner, i.idxtype, i.idxorder, i.idxcompress, i.idxmethod,  i.rssid from admin.sysindexes i, admin.systables t where tblowner = '" + this.getSelectedUser() + "' and idxseq = 0 and i.tbl = t.tbl and t.tbltype = 'S' order by i.idxname";
                break;
            }
            case TBLINDEXES: {
                string3 = "select * from admin.sysindexes where tbl = '" + string + "' and tblowner = '" + this.getSelectedUser() + "' and idxseq = 0 order by idxname";
                break;
            }
            case SYNONYMS: {
                string3 = "select * from admin.syssynonyms where sowner = '" + this.getSelectedUser() + "' order by sname";
                break;
            }
            case INDEX: 
            case INDEXCON: 
            case SYSINDEX: {
                string3 = "select distinct a.colname,b.coltype,a.idxseq,a.idxname,a.idxowner,a.tbl,a.tblowner,a.idxtype,a.id";
                string3 = string3 + ",a.idxsegid,a.idxorder,a.idxcompress,a.idxmethod,a.rssid ";
                string3 = string3 + "from admin.sysindexes a, admin.syscolumns b where a.idxowner = '" + this.getSelectedUser() + "' and a.idxname ='" + string + "'";
                string3 = string3 + " and a.tbl = b.tbl and a.colname = b.col order by idxseq";
                break;
            }
            case TBLINDEX: 
            case TBLINDEXCON: {
                string3 = "select distinct a.colname,b.coltype,a.idxseq,a.idxname,a.idxowner,a.tbl,a.tblowner,a.idxtype,a.id";
                string3 = string3 + ",a.idxsegid,a.idxorder,a.idxcompress,a.idxmethod,a.rssid ";
                string3 = string3 + "from admin.sysindexes a, admin.syscolumns b where a.idxowner = '" + this.getSelectedUser() + "' and a.idxname ='" + string + "'";
                string3 = string3 + " and a.tbl = '" + string2 + "' and a.tbl = b.tbl and a.colname = b.col order by idxseq";
                break;
            }
            case SYNONYM: {
                string3 = "select * from admin.syssynonyms where sowner = '" + this.getSelectedUser() + "' and sname = '" + string + "'";
                break;
            }
            case TRIGGERS: {
                string3 = "select * from admin.systrigger where owner = '" + this.getSelectedUser() + "' order by triggername";
                break;
            }
            case TRIGGER: {
                string3 = "select * from admin.systrigcols where owner = '" + this.getSelectedUser() + "' and triggername = '" + string + "'";
                break;
            }
            default: {
                Globals.showMessage("Bad Option", "execRsQuery");
            }
        }
        ResultSet resultSet = null;
        try {
            Statement statement = this.conn.createStatement();
            resultSet = statement.executeQuery(string3);
            return resultSet;
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "execRsObjectQuery");
        }
        finally {
            return resultSet;
        }
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.conn.prepareStatement(string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.conn.prepareCall(string);
    }

    public ArrayList<String> readConstraints() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "select distinct idxname from admin.sys_tbl_constrs where cnstrtype in ('P','U','F')";
        ResultSet resultSet = null;
        try {
            Statement statement = this.conn.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException2) {
                Logger.getLogger(SqlConnection.class.getName()).log(Level.SEVERE, null, sQLException2);
            }
            return null;
        }
        return arrayList;
    }

    public byte[] getLongColumn(String string, String string2) {
        String string3 = "SELECT \"" + string + "\" FROM \"" + this.selectedUser + "\".\"" + this.selectedTableName + "\" WHERE rowid = " + string2;
        ResultSet resultSet = null;
        try {
            Statement statement = this.conn.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                return resultSet.getBytes(1);
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException2) {
                Logger.getLogger(SqlConnection.class.getName()).log(Level.SEVERE, null, sQLException2);
            }
        }
        return null;
    }

    public void setLongColumn(String string, String string2, String string3) {
        String string4 = "UPDATE \"" + this.selectedUser + "\".\"" + this.selectedTableName + "\" SET \"" + string2 + "\" = ? WHERE rowid = '" + string3 + "'";
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement(string4);
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "setLongColumn");
        }
    }

    public void setLongColumn(byte[] byArray, String string, String string2) {
        String string3 = "UPDATE \"" + this.selectedUser + "\".\"" + this.selectedTableName + "\" SET \"" + string + "\" = ? WHERE rowid = '" + string2 + "'";
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement(string3);
            preparedStatement.setBytes(1, byArray);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "setLongColumn");
        }
    }

    public boolean isConstraint(String string) {
        String string2 = "select count(*) from admin.sys_tbl_constrs where idxname = '" + string + "'";
        ResultSet resultSet = null;
        try {
            Statement statement = this.conn.createStatement();
            resultSet = statement.executeQuery(string2);
            resultSet.next();
            int n = resultSet.getInt(1);
            return n > 0;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public EXIT_CODE updateRow(String string) {
        int n = 0;
        String string2 = "UPDATE \"" + this.getSelectedUser() + "\"." + Globals.doubleQuote(this.selectedTableName) + " SET " + string;
        try {
            Statement statement = this.conn.createStatement();
            n = statement.executeUpdate(string2);
        }
        catch (SQLException sQLException) {
            return Globals.showAbortRetryException(sQLException, string2, "UpdateRow");
        }
        return EXIT_CODE.OK;
    }

    public EXIT_CODE insertRow(String string, String string2) {
        String string3 = "INSERT INTO " + this.getSelectedUser() + "." + Globals.doubleQuote(this.selectedTableName) + " ( " + string + " ) ";
        string3 = string3 + " VALUES ( " + string2 + " ) ";
        try {
            Statement statement = this.conn.createStatement();
            statement.executeUpdate(string3);
        }
        catch (SQLException sQLException) {
            return Globals.showAbortRetryException(sQLException, string3, "InsertRow");
        }
        return EXIT_CODE.OK;
    }

    public EXIT_CODE deleteRow(String string) {
        String string2 = "DELETE FROM " + this.getSelectedUser() + "." + Globals.doubleQuote(this.selectedTableName);
        string2 = string2 + " WHERE rowid = '" + string + "'";
        try {
            Statement statement = this.conn.createStatement();
            statement.executeUpdate(string2);
        }
        catch (SQLException sQLException) {
            return Globals.showAbortRetryException(sQLException, string2, "InsertRow");
        }
        return EXIT_CODE.OK;
    }

    public static Object[] splitServerId(String string) {
        String[] stringArray = string.split("@");
        if (stringArray.length == 2) {
            String string2 = stringArray[1];
            String string3 = stringArray[0];
            try {
                int n = Integer.parseInt(string3.trim());
                return new Object[]{string2, n};
            }
            catch (Exception exception) {
                return new Object[]{string2, string3};
            }
        }
        if (stringArray.length == 1) {
            String string4 = "";
            String string5 = stringArray[0];
            try {
                int n = Integer.parseInt(string5.trim());
                return new Object[]{string4, n};
            }
            catch (Exception exception) {
                return new Object[]{string4, string5};
            }
        }
        return null;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    public MyTreeNode getTreeNode() {
        return this.treeNode;
    }

    public void setTreeNode(MyTreeNode myTreeNode) {
        this.treeNode = myTreeNode;
    }

    public void createDatabase(String string) throws SQLException {
        String string2 = "call fc_create_db('" + string + "')";
        Statement statement = this.conn.createStatement();
        statement.execute(string2);
    }

    public void addDatabase(String string) {
        String string2 = "call fc_add_db('" + string + "')";
        try {
            Statement statement = this.conn.createStatement();
            statement.execute(string2);
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "Add Database");
        }
    }

    public void clearDatabase() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        String string = "select tbl, tbltype, owner from admin.systables where tbltype in ('T','V','C')";
        ResultSet resultSet = null;
        try {
            Object object;
            Statement statement = this.conn.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                object = new TableSchema();
                ((TableSchema)object).TableName = resultSet.getString(1);
                ((TableSchema)object).Type = resultSet.getString(2);
                ((TableSchema)object).TableOwner = resultSet.getString(3);
                if (((TableSchema)object).Type.equals("T")) {
                    arrayList.add(object);
                    continue;
                }
                arrayList2.add(object);
            }
            resultSet.close();
            object = this.conn.createStatement();
            for (TableSchema tableSchema : arrayList) {
                string = "select cnstrname from admin.sys_tbl_constrs where tblname = '" + tableSchema.TableName + "' and owner = '" + tableSchema.TableOwner + "' and cnstrtype = 'F'";
                resultSet = statement.executeQuery(string);
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    String string3 = "alter table \"" + tableSchema.TableOwner + "\".\"" + tableSchema.TableName + "\" drop constraint \"" + string2 + "\"";
                    try {
                        object.execute(string3);
                    }
                    catch (SQLException sQLException) {
                        Globals.showException(sQLException, tableSchema.TableName + " - " + string2, "Clear Database");
                    }
                }
                resultSet.close();
            }
            for (TableSchema tableSchema : arrayList) {
                string = "drop table \"" + tableSchema.TableOwner + "\".\"" + tableSchema.TableName + "\"";
                try {
                    statement.execute(string);
                }
                catch (SQLException sQLException) {
                    Globals.showException(sQLException, tableSchema.TableName, "Clear Database");
                }
            }
            for (TableSchema tableSchema : arrayList2) {
                string = "drop view \"" + tableSchema.TableOwner + "\".\"" + tableSchema.TableName + "\"";
                try {
                    statement.execute(string);
                }
                catch (SQLException sQLException) {
                    Globals.showException(sQLException, tableSchema.TableName, "Clear Database");
                }
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "Clear Database");
        }
    }

    public ObjectPrivileges getPrivileges(TREE_OBJECT tREE_OBJECT, String string) {
        ObjectPrivileges objectPrivileges = new ObjectPrivileges();
        String string2 = "";
        ResultSet resultSet = null;
        switch (tREE_OBJECT) {
            case TABLE: 
            case TABLE_RTG: 
            case TABLE_LINKED: 
            case VIEW: {
                string2 = "select ins, del, upd, sel, exe, ndx, alt, tblowner from admin.systabauth where grantee = '" + this.getLoggedUser().toLowerCase() + "' and tbl = '" + string + "'";
                try {
                    Statement statement = this.conn.createStatement();
                    resultSet = statement.executeQuery(string2);
                    if (resultSet.next()) {
                        String string3 = resultSet.getString(1);
                        objectPrivileges.hasInsert = !string3.isEmpty();
                        string3 = resultSet.getString(2);
                        objectPrivileges.hasDelete = !string3.isEmpty();
                        string3 = resultSet.getString(3);
                        objectPrivileges.hasUpdate = !string3.isEmpty();
                        string3 = resultSet.getString(4);
                        objectPrivileges.hasSelect = !string3.isEmpty();
                        string3 = resultSet.getString(5);
                        if (string3 != null) {
                            objectPrivileges.hasExecute = !string3.isEmpty();
                        }
                        objectPrivileges.hasIndex = !(string3 = resultSet.getString(6)).isEmpty();
                        string3 = resultSet.getString(7);
                        objectPrivileges.hasAlter = !string3.isEmpty();
                        string3 = resultSet.getString(8);
                        if (string3.toLowerCase().equals(this.getSelectedUser().toLowerCase())) {
                            objectPrivileges.isOwner = true;
                        }
                    }
                    resultSet.close();
                    break;
                }
                catch (SQLException sQLException) {
                    Globals.showException(sQLException, "getPrivileges");
                }
            }
        }
        return objectPrivileges;
    }

    public Object[] getConstraintsStatus(String string) {
        ArrayList arrayList = new ArrayList();
        String string2 = "select has_pcnstrs, has_fcnstrs, has_ccnstrs, has_ucnstrs from admin.systables where tbl = '" + string + "' and owner = '" + this.getSelectedUser() + "'";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        ResultSet resultSet = null;
        try {
            Statement statement = this.conn.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet != null && resultSet.next()) {
                bl = resultSet.getString(1).equals("Y");
                bl2 = resultSet.getString(2).equals("Y");
                bl3 = resultSet.getString(3).equals("Y");
                bl4 = resultSet.getString(4).equals("Y");
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException2) {
                Logger.getLogger(SqlConnection.class.getName()).log(Level.SEVERE, null, sQLException2);
            }
            return null;
        }
        return new Object[]{bl, bl2, bl3, bl4};
    }

    public class TableSchema {
        public String TableOwner = "";
        public String TableName = "";
        public String Type;
    }

    public class ObjectPrivileges {
        public boolean hasInsert;
        public boolean hasDelete;
        public boolean hasUpdate;
        public boolean hasSelect;
        public boolean hasExecute;
        public boolean hasIndex;
        public boolean hasAlter;
        public boolean isOwner;
    }
}

