/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.ImageViewer;
import ctreeaceexplorer.LVBViewer;
import ctreeaceexplorer.sql.SqlTableColumn;
import ctreeaceexplorer.sql.SqlTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class SqlDynamicTable
extends FcBaseDynamicTable {
    private SqlTableModel sqlTableModel;
    private boolean inError;
    private Color readOnlyColor = new Color(255, 244, 221);

    public SqlDynamicTable(boolean bl) {
        this.sqlTableModel = new SqlTableModel(this, bl);
        this.setModel(this.sqlTableModel);
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
    }

    public SqlTableModel getModel() {
        return this.sqlTableModel;
    }

    public void setModel(SqlTableModel sqlTableModel) {
        this.sqlTableModel = sqlTableModel;
        super.setModel((TableModel)((Object)sqlTableModel));
    }

    public ImageIcon getCellIconAt(int n, int n2) {
        if (this.sqlTableModel.tableType == 1 && this.sqlTableModel.getTagAt(n, n2) != null) {
            return Globals.getIcon("Alert.png");
        }
        return null;
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        int n3;
        Object object;
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        Object object2 = this.sqlTableModel.getTagAt(n, n2);
        if (object2 != null && component instanceof JComponent) {
            object = (JComponent)component;
            ((JComponent)object).setToolTipText("<html>Column has been truncated to " + Globals.appProps.maxCharsInColumns + " bytes." + "<br>Click \"View in Window\" to view the whole column</html>");
        }
        if (!this.sqlTableModel.isReadOnly() && Globals.currentSqlConnection.tableColumnsForRecords.size() > n2) {
            boolean bl;
            object = Globals.currentSqlConnection.tableColumnsForRecords.get(n2);
            if (((SqlTableColumn)object).IsIdentity && !(bl = this.isCellSelected(n, n2))) {
                component.setBackground(this.readOnlyColor);
                component.setForeground(Color.black);
            }
        }
        if ((n3 = this.sqlTableModel.getColumnType(n2)) == -4 || n3 == -1 || n3 == -16 || n3 == 2004 || n3 == 2005) {
            component.setBackground(this.readOnlyColor);
            component.setForeground(Color.black);
        }
        if ((Integer)this.sqlTableModel.columnsMode.get(this.sqlTableModel.getDataColumnNumber(n2)) == this.sqlTableModel.HEX) {
            component.setBackground(this.readOnlyColor);
            component.setForeground(Color.black);
        }
        if ((Integer)this.sqlTableModel.columnsMode.get(this.sqlTableModel.getDataColumnNumber(n2)) == this.sqlTableModel.IMG) {
            component.setBackground(this.readOnlyColor);
            component.setForeground(Color.black);
        }
        if (!this.sqlTableModel.isReadOnly() && this.sqlTableModel.isColumnReadOnly(n2)) {
            component.setBackground(this.readOnlyColor);
            component.setForeground(Color.black);
        }
        if (this.sqlTableModel.getTagAt(n, n2) != null) {
            component.setBackground(this.readOnlyColor);
            component.setForeground(Color.black);
        }
        return component;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        int n = listSelectionModel.getMinSelectionIndex();
        if (!this.inError && this.previousRow >= 0 && !this.sqlTableModel.rowChanged(this.previousRow)) {
            this.inError = true;
            this.editCellAt(this.previousRow, 0);
            this.setRowSelectionInterval(this.previousRow, this.previousRow);
        } else {
            this.inError = false;
            int n2 = -1;
            if (n >= 0) {
                n2 = this.convertRowIndexToModel(n);
            }
            this.previousRow = n2;
        }
        Globals.appFrame.sqlTableSelectedRecord.setText(Integer.toString(n + 1));
        super.valueChanged(listSelectionEvent);
    }

    class ViewAsAction
    implements ActionListener {
        int column;
        int mode;

        public ViewAsAction(int n, int n2) {
            this.column = n;
            this.mode = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            SqlTableModel sqlTableModel = SqlDynamicTable.this.getModel();
            int n = SqlDynamicTable.this.getCurrentRow();
            int n2 = sqlTableModel.getDataColumnNumber(this.column);
            String string = sqlTableModel.getColumnName(this.column);
            FcBaseTableModel.RowData rowData = sqlTableModel.getRow(n);
            Object object2 = null;
            if (!sqlTableModel.isReadOnly()) {
                object = rowData.getData(sqlTableModel.getColumnCount());
                object2 = object.getData();
            }
            if (this.mode < 100) {
                sqlTableModel.columnsMode.set(n2, this.mode);
                sqlTableModel.mustResizeRows = true;
                sqlTableModel.fireTableDataChanged();
            } else {
                this.mode -= 100;
                if (this.mode == sqlTableModel.LOAD) {
                    sqlTableModel.rowChanged(n);
                    object = CtreeACEExplorerApp.getApplication().getMainFrame();
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileSelectionMode(0);
                    int n3 = jFileChooser.showOpenDialog((Component)object);
                    if (n3 == 0) {
                        FileInputStream fileInputStream = null;
                        try {
                            int n4;
                            File file = jFileChooser.getSelectedFile();
                            long l = file.length();
                            if (l > Integer.MAX_VALUE) {
                                throw new IOException("File too big" + file.getName());
                            }
                            byte[] byArray = new byte[(int)l];
                            fileInputStream = new FileInputStream(file);
                            int n5 = 0;
                            for (n4 = 0; n4 < byArray.length && (n5 = fileInputStream.read(byArray, n4, byArray.length - n4)) >= 0; n4 += n5) {
                            }
                            if (n4 < byArray.length) {
                                throw new IOException("Could not completely read file " + file.getName());
                            }
                            SqlDynamicTable.this.setValueAt(byArray, n, this.column);
                            Globals.currentSqlConnection.setLongColumn(byArray, string, object2.toString());
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            Globals.showMessage(fileNotFoundException.getMessage(), "Load from File");
                        }
                        catch (IOException iOException) {
                            Globals.showMessage(iOException.getMessage(), "Load from File");
                        }
                        finally {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException) {
                                Globals.showMessage(iOException.getMessage(), "Load from File");
                            }
                        }
                    }
                } else if (this.mode == sqlTableModel.SAVE) {
                    object = CtreeACEExplorerApp.getApplication().getMainFrame();
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileSelectionMode(0);
                    int n6 = jFileChooser.showSaveDialog((Component)object);
                    if (n6 == 0) {
                        Globals.ShowWaitCursor();
                        Object object3 = sqlTableModel.getSpecialValueAt(n, sqlTableModel.getDataColumnNumber(this.column));
                        if (object3 instanceof byte[]) {
                            byte[] byArray = (byte[])object3;
                            FileOutputStream fileOutputStream = null;
                            try {
                                File file = jFileChooser.getSelectedFile();
                                fileOutputStream = new FileOutputStream(file);
                                if (byArray == null) {
                                    file.delete();
                                    file.createNewFile();
                                } else {
                                    fileOutputStream.write(byArray);
                                }
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                Globals.showMessage(fileNotFoundException.getMessage(), "Save To File");
                            }
                            catch (IOException iOException) {
                                Globals.showMessage(iOException.getMessage(), "Save To File");
                            }
                            finally {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (IOException iOException) {
                                    Globals.showMessage(iOException.getMessage(), "Save To File");
                                }
                            }
                            Globals.ShowNormalCursor();
                        } else if (object3 instanceof String) {
                            try {
                                File file = jFileChooser.getSelectedFile();
                                FileWriter fileWriter = new FileWriter(file);
                                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                                bufferedWriter.write((String)object3);
                                bufferedWriter.close();
                            }
                            catch (IOException iOException) {
                                Logger.getLogger(SqlDynamicTable.class.getName()).log(Level.SEVERE, null, iOException);
                            }
                            Globals.ShowNormalCursor();
                        }
                    }
                } else if (this.mode == sqlTableModel.NULL) {
                    SqlDynamicTable.this.setValueAt(null, n, this.column);
                    sqlTableModel.setColumnDirty(this.column);
                } else {
                    byte[] byArray;
                    object = sqlTableModel.getSpecialValueAt(n, sqlTableModel.getDataColumnNumber(this.column));
                    if (object instanceof byte[] && (byArray = (byte[])object) != null) {
                        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
                        if (this.mode == 2) {
                            ImageViewer imageViewer = new ImageViewer((Frame)jFrame, true);
                            imageViewer.setLocationRelativeTo(jFrame);
                            imageViewer.showDialog(string, byArray);
                            imageViewer.dispose();
                        } else {
                            LVBViewer lVBViewer = new LVBViewer((Frame)jFrame, true);
                            lVBViewer.setLocationRelativeTo(jFrame);
                            lVBViewer.showDialog(string, this.mode, byArray);
                        }
                        byArray = null;
                    }
                }
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu = null;
            Component component = mouseEvent.getComponent();
            if (component.getClass() == SqlDynamicTable.class) {
                SqlDynamicTable sqlDynamicTable = (SqlDynamicTable)((Object)component);
                SqlTableModel sqlTableModel = sqlDynamicTable.getModel();
                int n = sqlDynamicTable.columnAtPoint(mouseEvent.getPoint());
                int n2 = sqlDynamicTable.rowAtPoint(mouseEvent.getPoint());
                SqlDynamicTable.this.changeSelection(n2, n, false, false);
                if (n2 == -1) {
                    sqlTableModel.fireTableDataChanged();
                }
                if (mouseEvent.isPopupTrigger()) {
                    TableCellEditor tableCellEditor = sqlDynamicTable.getCellEditor();
                    if (tableCellEditor != null) {
                        tableCellEditor.stopCellEditing();
                    }
                    SqlDynamicTable.this.changeSelection(n2, n, false, false);
                    jPopupMenu = new JPopupMenu();
                    int n3 = (Integer)sqlTableModel.columnsMode.get(n);
                    if (n3 == -1) {
                        n3 = sqlTableModel.TEXT;
                    }
                    switch (sqlTableModel.getColumnType(n)) {
                        case -16: 
                        case -15: 
                        case -4: 
                        case -3: 
                        case -2: 
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2004: 
                        case 2005: {
                            JMenuItem jMenuItem = new JCheckBoxMenuItem("View as Text");
                            jMenuItem.addActionListener(new ViewAsAction(n, sqlTableModel.TEXT));
                            if (n3 == sqlTableModel.TEXT) {
                                jMenuItem.setSelected(true);
                            }
                            jPopupMenu.add(jMenuItem);
                            jMenuItem = new JCheckBoxMenuItem("View as Byte Array");
                            jMenuItem.addActionListener(new ViewAsAction(n, sqlTableModel.BYTE));
                            if (n3 == sqlTableModel.BYTE) {
                                jMenuItem.setSelected(true);
                            }
                            jPopupMenu.add(jMenuItem);
                            jMenuItem = new JCheckBoxMenuItem("View as Hex/ASCII");
                            jMenuItem.addActionListener(new ViewAsAction(n, sqlTableModel.HEX));
                            if (n3 == sqlTableModel.HEX) {
                                jMenuItem.setSelected(true);
                            }
                            jPopupMenu.add(jMenuItem);
                            jMenuItem = new JCheckBoxMenuItem("View as Image");
                            jMenuItem.addActionListener(new ViewAsAction(n, sqlTableModel.IMG));
                            if (n3 == sqlTableModel.IMG) {
                                jMenuItem.setSelected(true);
                            }
                            jPopupMenu.add(jMenuItem);
                            JPopupMenu.Separator separator = new JPopupMenu.Separator();
                            jPopupMenu.add(separator);
                            jMenuItem = new JMenuItem("View in Window");
                            jMenuItem.addActionListener(new ViewAsAction(n, 100 + n3));
                            jPopupMenu.add(jMenuItem);
                            separator = new JPopupMenu.Separator();
                            jPopupMenu.add(separator);
                            jMenuItem = new JMenuItem("Load from File");
                            jMenuItem.addActionListener(new ViewAsAction(n, 100 + sqlTableModel.LOAD));
                            jPopupMenu.add(jMenuItem);
                            jMenuItem = new JMenuItem("Save to File");
                            jMenuItem.addActionListener(new ViewAsAction(n, 100 + sqlTableModel.SAVE));
                            jPopupMenu.add(jMenuItem);
                            jMenuItem = new JMenuItem("Set NULL");
                            jMenuItem.addActionListener(new ViewAsAction(n, 100 + sqlTableModel.NULL));
                            jPopupMenu.add(jMenuItem);
                            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        }
                    }
                }
            }
        }
    }
}

