/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import FairCom.Helper.Classes.BitConverter;
import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import ctree.jdbc.CtreeResultSet;
import ctree.jdbc.CtreeResultSetMetaData;
import ctreeaceexplorer.EXIT_CODE;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.sql.SqlDynamicTable;
import ctreeaceexplorer.sql.SqlTableColumn;
import java.awt.Component;
import java.awt.FontMetrics;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SqlTableModel
extends FcBaseTableModel {
    private SqlDynamicTable sqlTable;
    public boolean mustResizeRows;
    int tableType;
    DateFormat dateFormatter = DateFormat.getDateInstance(3);
    DateFormat timeFormatter = DateFormat.getTimeInstance(2);
    DateFormat dateTimeFormatter = DateFormat.getDateTimeInstance(3, 2);
    FontMetrics metrics;

    public SqlTableModel(SqlDynamicTable sqlDynamicTable, boolean bl) {
        super((FcBaseDynamicTable)sqlDynamicTable, bl);
        this.sqlTable = sqlDynamicTable;
    }

    public SqlTableModel(FcBaseDynamicTable fcBaseDynamicTable) {
        super(fcBaseDynamicTable, true);
    }

    public void addRowNum(ResultSet resultSet, int n) {
        try {
            if (resultSet != null) {
                while (resultSet.next()) {
                    long l = resultSet.getLong(1);
                    this.setValueAt(l, n, 0);
                }
            }
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "Sql Exception");
        }
        this.fireTableDataChanged();
    }

    public void addRecord() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block7: for (int i = 0; i < Globals.currentSqlConnection.tableColumnsForRecords.size(); ++i) {
            SqlTableColumn sqlTableColumn = Globals.currentSqlConnection.tableColumnsForRecords.get(i);
            if (sqlTableColumn.IsIdentity) {
                arrayList.add(null);
                continue;
            }
            this.dirtyColumns.set(i, true);
            switch ((Integer)this.columnsType.get(i)) {
                case -16: 
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 2004: 
                case 2005: {
                    arrayList.add(null);
                    continue block7;
                }
                case -7: {
                    arrayList.add(null);
                    continue block7;
                }
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    arrayList.add(0);
                    continue block7;
                }
                case -15: 
                case -9: 
                case 1: 
                case 12: {
                    arrayList.add("");
                    continue block7;
                }
                case 91: 
                case 92: 
                case 93: {
                    arrayList.add(new Date());
                }
            }
        }
        arrayList.add(-1);
        FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
        this.addRow(rowData);
        this.selectLastRecord();
        this.hasDirtyColumns = true;
        this.fireTableDataChanged();
    }

    public void deleteRecord() {
        FcBaseTableModel.RowData rowData;
        String string;
        EXIT_CODE eXIT_CODE;
        int n;
        if (this.sqlTable.getCellEditor() != null) {
            this.sqlTable.getCellEditor().cancelCellEditing();
        }
        if ((n = this.sqlTable.getCurrentRow()) >= 0 && (eXIT_CODE = Globals.currentSqlConnection.deleteRow(string = (rowData = this.getRow(n)).getValue(this.numberOfColumns).toString())) == EXIT_CODE.OK) {
            this.deleteRow(n);
        }
    }

    public void selectRecord(int n) {
        int n2 = this.sqlTable.getRowCount();
        if (n > 0 && n <= n2) {
            if (this.sqlTable.getCellEditor() != null) {
                this.sqlTable.getCellEditor().cancelCellEditing();
            }
            int n3 = this.sqlTable.getSelectedColumn();
            this.sqlTable.changeSelection(n - 1, n3, false, false);
        }
    }

    public void selectFirstRecord() {
        int n = this.sqlTable.getSelectedRow();
        if (n > 0) {
            if (this.sqlTable.getCellEditor() != null) {
                this.sqlTable.getCellEditor().cancelCellEditing();
            }
            int n2 = this.sqlTable.getSelectedColumn();
            this.sqlTable.changeSelection(0, n2, false, false);
        }
    }

    public void selectPreviousRecord() {
        int n = this.sqlTable.getSelectedRow();
        if (n > 0) {
            if (this.sqlTable.getCellEditor() != null) {
                this.sqlTable.getCellEditor().cancelCellEditing();
            }
            int n2 = this.sqlTable.getSelectedColumn();
            this.sqlTable.changeSelection(--n, n2, false, false);
        }
    }

    public void selectNextRecord() {
        int n = this.sqlTable.getRowCount();
        int n2 = this.sqlTable.getSelectedRow();
        if (n2 < n - 1) {
            if (this.sqlTable.getCellEditor() != null) {
                this.sqlTable.getCellEditor().cancelCellEditing();
            }
            int n3 = this.sqlTable.getSelectedColumn();
            this.sqlTable.changeSelection(++n2, n3, false, false);
        }
    }

    public void selectLastRecord() {
        int n = this.sqlTable.getRowCount();
        if (this.sqlTable.getCellEditor() != null) {
            this.sqlTable.getCellEditor().cancelCellEditing();
        }
        int n2 = this.sqlTable.getSelectedColumn();
        this.sqlTable.changeSelection(n - 1, n2, false, false);
    }

    public void populateFromResultSet(ResultSet resultSet, boolean bl) {
        this.metrics = this.table.getFontMetrics(this.table.getFont());
        CtreeResultSet ctreeResultSet = (CtreeResultSet)resultSet;
        this.clearTable();
        this.hasDirtyColumns = false;
        this.suspendAutoSize = false;
        try {
            Object object;
            int n;
            CtreeResultSetMetaData ctreeResultSetMetaData = (CtreeResultSetMetaData)ctreeResultSet.getMetaData();
            this.numberOfColumns = ctreeResultSetMetaData.getColumnCount();
            ArrayList arrayList = null;
            if (this.columnsMode != null && !this.columnsMode.isEmpty() && this.columnsMode.size() == this.numberOfColumns) {
                arrayList = new ArrayList(this.columnsMode);
            }
            this.allocateArrays(this.numberOfColumns);
            if (arrayList != null) {
                this.columnsMode = new ArrayList(arrayList);
            }
            if (bl) {
                --this.numberOfColumns;
            }
            for (n = 1; n <= this.numberOfColumns; ++n) {
                this.columnsName.set(n - 1, ctreeResultSetMetaData.getColumnName(n));
                this.columnsType.set(n - 1, ctreeResultSetMetaData.getColumnType(n));
                int n2 = ctreeResultSetMetaData.getScale(n);
                if (n2 == 0) {
                    n2 = -1;
                }
                this.columnsScale.set(n - 1, n2);
            }
            super.fireTableStructureChanged();
            for (n = 0; n < this.numberOfColumns; ++n) {
                TableColumn tableColumn = this.sqlTable.getColumnModel().getColumn(n);
                object = (String)this.columnsName.get(n);
                int n3 = 10;
                if (object == null) {
                    object = "";
                }
                n3 = this.metrics.stringWidth((String)object) + 15;
                tableColumn.setPreferredWidth(n3);
            }
            n = 30;
            int n4 = 0;
            while (ctreeResultSet.next() && !Globals.stopFetching.booleanValue()) {
                object = new ArrayList();
                Object object2 = null;
                for (int i = 1; i <= this.numberOfColumns; ++i) {
                    switch ((Integer)this.columnsType.get(i - 1)) {
                        case -3: 
                        case -2: {
                            if (this.tableType == 1) {
                                object2 = ctreeResultSet.getBytes(i);
                                break;
                            }
                            object2 = ctreeResultSet.getString(i);
                            break;
                        }
                        case -16: 
                        case -1: 
                        case 2005: {
                            object2 = ctreeResultSet.getBytes(i);
                            break;
                        }
                        case -4: 
                        case 2004: {
                            object2 = ctreeResultSet.getBytes(i);
                            break;
                        }
                        case -15: 
                        case -9: 
                        case 1: 
                        case 12: {
                            if (this.tableType == 1) {
                                object2 = ctreeResultSet.getBytes(i);
                                break;
                            }
                            object2 = ctreeResultSet.getString(i);
                            break;
                        }
                        default: {
                            object2 = ctreeResultSet.getObject(i);
                        }
                    }
                    if (n > 0) {
                        int n5 = 10;
                        int n6 = 0;
                        int n7 = 0;
                        int n8 = 0;
                        TableColumn tableColumn = this.sqlTable.getColumnModel().getColumn(i - 1);
                        String string = (String)tableColumn.getHeaderValue();
                        if (string == null) {
                            string = "";
                        }
                        n5 = this.metrics.stringWidth(string) + 15;
                        if (object2 != null) {
                            n6 = this.metrics.stringWidth(object2.toString()) + 10;
                        }
                        n8 = Math.max(n5, n6);
                        n7 = tableColumn.getPreferredWidth();
                        tableColumn.setPreferredWidth(Math.max(n7, n8));
                    }
                    ((ArrayList)object).add(object2);
                }
                if (bl) {
                    object2 = ctreeResultSet.getObject(this.numberOfColumns + 1);
                    ((ArrayList)object).add(object2);
                }
                FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, (ArrayList)object);
                this.addRow(rowData);
                --n;
                ++n4;
            }
            ctreeResultSet.close();
        }
        catch (SQLException sQLException) {
            Globals.showException(sQLException, "Sql Exception");
        }
        int n = this.getRowCount();
        if (this.getRowCount() < 1000) {
            this.resizeRows();
        }
        if (bl) {
            Globals.appFrame.sqlTableRecordCount.setText("  of " + Integer.toString(this.getRowCount()));
        }
        if (n > 0 && this.numberOfColumns > 0) {
            this.sqlTable.setRowSelectionInterval(0, 0);
            this.sqlTable.setColumnSelectionInterval(0, 0);
        }
    }

    public Class getColumnClass(int n) {
        Class clazz = String.class;
        int n2 = (Integer)this.columnsType.get(n);
        switch (n2) {
            case -7: 
            case 16: {
                clazz = Boolean.class;
                break;
            }
            case -16: 
            case -15: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                clazz = String.class;
                break;
            }
            case -5: {
                clazz = Long.class;
                break;
            }
            case -6: {
                clazz = Integer.class;
                break;
            }
            case 5: {
                clazz = Integer.class;
                break;
            }
            case 4: {
                clazz = Integer.class;
                break;
            }
            case 2: 
            case 3: {
                clazz = BigInteger.class;
                break;
            }
            case 7: {
                clazz = Float.class;
                break;
            }
            case 6: 
            case 8: {
                clazz = Double.class;
                break;
            }
            case 91: {
                clazz = Date.class;
                break;
            }
            case 92: {
                clazz = Time.class;
                break;
            }
            case 93: {
                clazz = Timestamp.class;
                break;
            }
            default: {
                Globals.showMessage("Invalid type : " + this.columnsType.get(n), "getColumnClass");
            }
        }
        return clazz;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 < this.columnsMode.size()) {
            int n3 = Globals.appProps.maxCharsInColumns;
            Object object = super.getValueAt(n, n2);
            Class clazz = this.getColumnClass(n2);
            int n4 = (Integer)this.columnsMode.get(this.getDataColumnNumber(n2));
            if (clazz == String.class && object instanceof byte[] && object != null) {
                Object object2;
                if (((byte[])object).length > n3) {
                    object2 = new byte[n3];
                    this.setTagAt(n, n2, 1);
                    System.arraycopy((byte[])object, 0, object2, 0, n3);
                    object = object2;
                } else {
                    this.setTagAt(n, n2, null);
                }
                object2 = "";
                if (n4 == -1 || n4 == this.TEXT) {
                    object2 = new String((byte[])object);
                } else if (n4 == this.BYTE) {
                    object2 = BitConverter.toHexString((byte[])((byte[])object), (boolean)true);
                } else if (n4 == this.HEX) {
                    object2 = BitConverter.toHexAscii((byte[])((byte[])object));
                } else {
                    if (n4 == this.IMG) {
                        return object;
                    }
                    return object;
                }
                return object2;
            }
            return object;
        }
        return super.getValueAt(n, n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        if (this.tableType == 1) {
            Class clazz = this.getColumnClass(n2);
            int n3 = (Integer)this.columnsMode.get(this.getDataColumnNumber(n2));
            if (clazz == String.class && object instanceof String && object != null) {
                if (n3 == -1 || n3 == this.TEXT) {
                    super.setValueAt((Object)object.toString(), n, n2);
                } else if (n3 == this.BYTE) {
                    byte[] byArray = BitConverter.getBytesFromBytes((String)((String)object));
                    super.setValueAt((Object)byArray, n, n2);
                }
            } else {
                super.setValueAt(object, n, n2);
            }
        } else {
            super.setValueAt(object, n, n2);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        int n = this.getRowCount();
        this.updateRowHeights();
        if (this.mustResizeRows) {
            this.mustResizeRows = false;
            this.resizeRows(n);
        }
    }

    private void resizeRows(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.metrics = this.sqlTable.getFontMetrics(this.sqlTable.getFont());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            n3 = 0;
            TableColumnModel tableColumnModel = this.sqlTable.getColumnModel();
            if (tableColumnModel.getColumnCount() <= 0) continue;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n5 = this.getDataColumnNumber(i);
            int n6 = this.metrics.stringWidth((String)this.columnsName.get(n5) + 15);
            for (int j = 0; j < n; ++j) {
                String string;
                if (this.getRowCount() <= j) continue;
                FcBaseTableModel.RowData rowData = this.getRow(j);
                FcBaseTableModel.CellData cellData = rowData.getData(n5);
                int n7 = (Integer)this.columnsType.get(n5);
                Object object = cellData.getData();
                if (object == null) {
                    n2 = this.metrics.stringWidth("(null)") + 10;
                } else if (n7 == 91) {
                    string = this.dateFormatter.format(object);
                    n2 = this.metrics.stringWidth(string) + 10;
                } else if (n7 == 92) {
                    string = this.timeFormatter.format(object);
                    n2 = this.metrics.stringWidth(string) + 10;
                } else if (n7 == 93) {
                    string = this.dateTimeFormatter.format(object);
                    n2 = this.metrics.stringWidth(string) + 10;
                } else {
                    n2 = this.metrics.stringWidth(object.toString()) + 10;
                }
                n3 = n4 = Math.max(n3, n2);
            }
            tableColumn.setPreferredWidth(Math.max(n6, n4));
        }
    }

    private void updateRowHeights() {
        try {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                int n = this.table.getRowHeight();
                for (int j = 0; j < this.table.getColumnCount(); ++j) {
                    Component component = this.table.prepareRenderer(this.table.getCellRenderer(i, j), i, j);
                    n = Math.max(n, component.getPreferredSize().height);
                }
                this.table.setRowHeight(i, n);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.isReadOnly()) {
            return false;
        }
        if (!Globals.currentSqlConnection.tableColumnsForRecords.isEmpty()) {
            SqlTableColumn sqlTableColumn = Globals.currentSqlConnection.tableColumnsForRecords.get(n2);
            if (sqlTableColumn.IsIdentity) {
                return false;
            }
            if ((Integer)this.columnsType.get(n2) == -4 || (Integer)this.columnsType.get(n2) == -1 || (Integer)this.columnsType.get(n2) == -16 || (Integer)this.columnsType.get(n2) == 2004 || (Integer)this.columnsType.get(n2) == 2005) {
                return false;
            }
        }
        if (this.isColumnReadOnly(n2)) {
            return false;
        }
        if (Globals.isamShowDebugColumns && n2 < 3) {
            return false;
        }
        if ((Integer)this.columnsMode.get(this.getDataColumnNumber(n2)) == this.HEX) {
            return false;
        }
        if ((Integer)this.columnsMode.get(this.getDataColumnNumber(n2)) == this.IMG) {
            return false;
        }
        return this.getTagAt(n, n2) == null;
    }

    public boolean rowChanged(int n) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (!this.hasDirtyColumns) {
            return true;
        }
        FcBaseTableModel.RowData rowData = this.getRow(n);
        if (rowData == null) {
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        StringBuilder stringBuilder2 = new StringBuilder(256);
        StringBuilder stringBuilder3 = new StringBuilder(256);
        boolean bl = true;
        Object object5 = 0;
        while ((Integer)object5 < this.numberOfColumns) {
            if (((Boolean)this.dirtyColumns.get((Integer)object5)).booleanValue()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                    stringBuilder2.append(",");
                    stringBuilder3.append(",");
                }
                stringBuilder.append(Globals.doubleQuote((String)this.columnsName.get((Integer)object5))).append(" = ");
                stringBuilder2.append(Globals.doubleQuote((String)this.columnsName.get((Integer)object5)));
                if (rowData.getValue(((Integer)object5).intValue()) == null) {
                    stringBuilder.append("NULL");
                    stringBuilder3.append("NULL");
                } else {
                    switch ((Integer)this.columnsType.get((Integer)object5)) {
                        case -3: 
                        case -2: {
                            object4 = "";
                            if ((Integer)this.columnsMode.get(this.getDataColumnNumber((Integer)object5)) == this.BYTE) {
                                object3 = rowData.getValue(((Integer)object5).intValue());
                                if (object3 instanceof byte[]) {
                                    object4 = BitConverter.toHexString((byte[])((byte[])object3), (boolean)false);
                                }
                            } else {
                                object4 = rowData.getValue(((Integer)object5).intValue()).toString();
                                object3 = BitConverter.getBytes((String)object4);
                                object4 = BitConverter.toHexString((byte[])object3, (boolean)false);
                            }
                            stringBuilder.append(Globals.singleQuote((String)object4));
                            stringBuilder3.append(Globals.singleQuote((String)object4));
                            break;
                        }
                        case -16: 
                        case -4: 
                        case -1: 
                        case 2004: 
                        case 2005: {
                            stringBuilder.append("NULL");
                            break;
                        }
                        case -7: {
                            object3 = rowData.getValue(((Integer)object5).intValue());
                            if (((Boolean)object3).booleanValue()) {
                                stringBuilder.append("'1'");
                                stringBuilder3.append("'1'");
                                break;
                            }
                            stringBuilder.append("'0'");
                            stringBuilder3.append("'0'");
                            break;
                        }
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            stringBuilder.append(Globals.singleQuote(rowData.getValue(((Integer)object5).intValue()).toString()));
                            stringBuilder3.append(Globals.singleQuote(rowData.getValue(((Integer)object5).intValue()).toString()));
                            break;
                        }
                        case -15: 
                        case -9: 
                        case 1: 
                        case 12: {
                            object2 = "";
                            if ((Integer)this.columnsMode.get(this.getDataColumnNumber((Integer)object5)) == this.BYTE) {
                                object = rowData.getValue(((Integer)object5).intValue());
                                if (object instanceof byte[]) {
                                    object2 = BitConverter.toString((byte[])((byte[])object));
                                }
                            } else {
                                object2 = rowData.getValue(((Integer)object5).intValue()).toString();
                            }
                            object2 = ((String)object2).replaceAll("'", "''");
                            stringBuilder.append(Globals.singleQuote((String)object2));
                            stringBuilder3.append(Globals.singleQuote((String)object2));
                            break;
                        }
                        case 91: {
                            object = rowData.getValue(((Integer)object5).intValue());
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
                            stringBuilder.append(Globals.singleQuote(simpleDateFormat.format(object)));
                            stringBuilder3.append(Globals.singleQuote(simpleDateFormat.format(object)));
                            break;
                        }
                        case 92: {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                            stringBuilder.append(Globals.singleQuote(simpleDateFormat.format(rowData.getValue(((Integer)object5).intValue()))));
                            stringBuilder3.append(Globals.singleQuote(simpleDateFormat.format(rowData.getValue(((Integer)object5).intValue()))));
                            break;
                        }
                        case 93: {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                            stringBuilder.append(Globals.singleQuote(simpleDateFormat.format(rowData.getValue(((Integer)object5).intValue()))));
                            stringBuilder3.append(Globals.singleQuote(simpleDateFormat.format(rowData.getValue(((Integer)object5).intValue()))));
                        }
                    }
                }
            }
            object4 = object5;
            object3 = object5 = Integer.valueOf((Integer)object5 + 1);
        }
        object5 = rowData.getValue(this.numberOfColumns);
        object4 = EXIT_CODE.OK;
        if (object5.toString().equals("-1")) {
            object4 = Globals.currentSqlConnection.insertRow(stringBuilder2.toString(), stringBuilder3.toString());
        } else {
            stringBuilder.append(" WHERE rowid = ").append(Globals.singleQuote(object5.toString()));
            object4 = Globals.currentSqlConnection.updateRow(stringBuilder.toString());
        }
        if (object4 == EXIT_CODE.ABORT || object4 == EXIT_CODE.OK) {
            if (object5.toString().equals("-1") && object4 == EXIT_CODE.OK && (object3 = Globals.currentSqlConnection.execRsQuery("select last_rowid()")) != null) {
                try {
                    object3.next();
                    object2 = object3.getObject(1);
                    rowData.setValue(this.numberOfColumns, object2);
                    object3.close();
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(SqlTableModel.class.getName()).log(Level.SEVERE, null, sQLException);
                }
            }
            this.hasDirtyColumns = false;
            object3 = 0;
            while ((Integer)object3 < this.numberOfColumns) {
                this.dirtyColumns.set((Integer)object3, false);
                object2 = object3;
                object = object3 = Integer.valueOf((Integer)object3 + 1);
            }
            return true;
        }
        if (object4 == EXIT_CODE.RELOAD) {
            Globals.ShowWaitCursor();
            object3 = null;
            object3 = Globals.currentSqlConnection.execRsRecordsQuery(Globals.currentSqlConnection.getSelectedUser());
            if (object3 != null) {
                this.populateFromResultSet((ResultSet)object3, true);
                try {
                    object3.close();
                }
                catch (SQLException sQLException) {
                    Globals.showException(sQLException, "fillItemViewTable");
                }
            }
            Globals.ShowNormalCursor();
            return true;
        }
        return false;
    }

    private void resizeRows() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        FontMetrics fontMetrics = Globals.appFrame.getFrame().getFontMetrics(Globals.appFrame.getFrame().getFont());
        for (int i = 0; i < this.numberOfColumns; ++i) {
            n2 = 0;
            TableColumn tableColumn = this.sqlTable.getColumnModel().getColumn(i);
            String string = (String)this.columnsName.get(i);
            if (string == null) {
                string = "";
            }
            int n4 = fontMetrics.stringWidth(string) + 15;
            for (int j = 0; j < this.getRowCount(); ++j) {
                FcBaseTableModel.CellData cellData = this.getRow(j).getData(i);
                Object object = cellData.getData();
                n = object == null ? fontMetrics.stringWidth("(null)") + 10 : fontMetrics.stringWidth(object.toString()) + 10;
                n2 = n3 = Math.max(n2, n);
            }
            tableColumn.setPreferredWidth(Math.max(n4, n3));
        }
    }
}

