/*
 * Decompiled with CFR 0.152.
 */
package ctreeaceexplorer.sql;

import FairCom.Helper.Classes.CtreeServer;
import ctreeaceexplorer.CtreeACEExplorerApp;
import ctreeaceexplorer.CtreeACEExplorerView;
import ctreeaceexplorer.DbTableDialog;
import ctreeaceexplorer.DynamicTree;
import ctreeaceexplorer.Globals;
import ctreeaceexplorer.MyTreeNode;
import ctreeaceexplorer.TAB_PAGES;
import ctreeaceexplorer.TREE_OBJECT;
import ctreeaceexplorer.sql.AlterTable;
import ctreeaceexplorer.sql.Constraints;
import ctreeaceexplorer.sql.CreateIndex;
import ctreeaceexplorer.sql.CreateProc;
import ctreeaceexplorer.sql.CreateSqlTable;
import ctreeaceexplorer.sql.CreateSynonym;
import ctreeaceexplorer.sql.CreateTrigger;
import ctreeaceexplorer.sql.CreateUserDialog;
import ctreeaceexplorer.sql.CreateView;
import ctreeaceexplorer.sql.DumpRows;
import ctreeaceexplorer.sql.ExportSchema;
import ctreeaceexplorer.sql.PermissionsDialog;
import ctreeaceexplorer.sql.QEPTree;
import ctreeaceexplorer.sql.Rename;
import ctreeaceexplorer.sql.SQL_MODE;
import ctreeaceexplorer.sql.SpPermissionsDialog;
import ctreeaceexplorer.sql.SqlConnection;
import ctreeaceexplorer.sql.SqlExePlanTable;
import ctreeaceexplorer.sql.SqlTableModel;
import ctreeaceexplorer.sql.ViewProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SqlTree
extends DynamicTree {
    private CtreeACEExplorerView appFrame;
    private MyTreeNode currentNode;
    private MyTreeNode oldNode;
    private ArrayList<String> servers = new ArrayList();
    private JPopupMenu popup = null;
    private MouseListener popupListener = new PopupListener();
    public MyTreeNode defaultNode = null;

    public SqlTree(CtreeACEExplorerView ctreeACEExplorerView) {
        super(ctreeACEExplorerView);
        this.appFrame = ctreeACEExplorerView;
        this.addMouseListener(this.popupListener);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.valueChanged();
    }

    @Override
    public void clear() {
        super.clear();
        this.servers.clear();
    }

    public void valueChanged() {
        String string = this.appFrame.sqlObjectLabel.getText();
        boolean bl = this.appFrame.showRowNumCB.isSelected();
        this.appFrame.sqlObjectLabel.setText("Current Object = ");
        this.appFrame.sqlObjectLabel.setEnabled(false);
        this.appFrame.showRowNumCB.setEnabled(false);
        Globals.stopFetching = false;
        MyTreeNode myTreeNode = (MyTreeNode)this.getLastSelectedPathComponent();
        TAB_PAGES tAB_PAGES = this.appFrame.getSelectedPane();
        this.appFrame.rightTabbedPanel.removeAll();
        if (myTreeNode == null) {
            this.appFrame.rightTabbedPanel.add("Items View", this.appFrame.sqlItemsViewPane);
            this.clearRecordsViewTable();
            this.clearItemsViewTable();
            return;
        }
        if (this.currentNode != myTreeNode) {
            Globals.sqlTreeNodeChanged = true;
        }
        this.currentNode = myTreeNode;
        if (this.oldNode != null && !this.refreshCurrentServer()) {
            this.setSelectionPath(new TreePath(this.oldNode));
            return;
        }
        this.oldNode = myTreeNode;
        String string2 = myTreeNode.getName();
        this.appFrame.rightTabbedPanel.add("Items View", this.appFrame.sqlItemsViewPane);
        this.appFrame.rightTabbedPanel.add("Table Records", this.appFrame.sqlRecordsViewPane);
        this.appFrame.rightTabbedPanel.add("SQL Statements", this.appFrame.sqlStatementsPane);
        this.appFrame.rightTabbedPanel.add("Scripts", this.appFrame.sqlScriptsPane);
        this.appFrame.rightTabbedPanel.add("Execution Plan", this.appFrame.sqlExePlanPane);
        this.appFrame.rightTabbedPanel.add("Convert / Import", this.appFrame.sqlImportPane);
        if (myTreeNode.getType() != TREE_OBJECT.TABLE && myTreeNode.getType() != TREE_OBJECT.TABLE_RTG && myTreeNode.getType() != TREE_OBJECT.TABLE_LINKED && myTreeNode.getType() != TREE_OBJECT.SYSTABLE) {
            this.appFrame.selectItemsPane();
            this.clearRecordsViewTable();
        }
        this.setupActions(myTreeNode.getType());
        switch (myTreeNode.getType()) {
            case SERVER: {
                this.clearItemsViewTable();
                if (myTreeNode.isUpdated()) break;
                this.clearNode(myTreeNode);
                ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(TREE_OBJECT.DATABASE);
                ArrayList<String> arrayList2 = Globals.currentSqlConnection.readObjects(TREE_OBJECT.USER);
                for (String string3 : arrayList) {
                    MyTreeNode myTreeNode2 = new MyTreeNode(string3, TREE_OBJECT.DATABASE, (DynamicTree)this);
                    int n = Globals.currentSqlConnection.getDatabaseVersion();
                    myTreeNode2.setDbVersion(n);
                    this.addObject(myTreeNode, myTreeNode2);
                    for (String string4 : arrayList2) {
                        MyTreeNode myTreeNode3 = new MyTreeNode(string4, TREE_OBJECT.USER, (DynamicTree)this);
                    }
                }
                this.expandNode(myTreeNode);
                this.appFrame.importer.setServers(this);
                myTreeNode.setUpdated(true);
                break;
            }
            case DATABASE: {
                this.clearItemsViewTable();
                if (myTreeNode.isUpdated()) break;
                this.clearNode(myTreeNode);
                ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(TREE_OBJECT.USER);
                for (String string5 : arrayList) {
                    MyTreeNode myTreeNode4 = new MyTreeNode(string5, TREE_OBJECT.USER, (DynamicTree)this);
                    this.addObject(myTreeNode, myTreeNode4);
                }
                this.expandNode(myTreeNode);
                myTreeNode.setUpdated(true);
                break;
            }
            case USER: {
                this.clearItemsViewTable();
                Globals.currentSqlConnection.setSelectedUser(string2);
                if (myTreeNode.isUpdated()) break;
                this.clearNode(myTreeNode);
                this.addObject(myTreeNode, new MyTreeNode("Tables", TREE_OBJECT.TABLES, true, this));
                if (string2.equals("admin")) {
                    this.addObject(myTreeNode, new MyTreeNode("System Tables", TREE_OBJECT.SYSTABLES, (DynamicTree)this));
                }
                this.addObject(myTreeNode, new MyTreeNode("Views", TREE_OBJECT.VIEWS, true, this));
                if (string2.equals("admin")) {
                    this.addObject(myTreeNode, new MyTreeNode("Built-in Procedures", TREE_OBJECT.BPROCEDURES, (DynamicTree)this));
                }
                this.addObject(myTreeNode, new MyTreeNode("Procedures", TREE_OBJECT.UPROCEDURES, true, this));
                this.addObject(myTreeNode, new MyTreeNode("User Defined Functions", TREE_OBJECT.UDFS, true, this));
                this.addObject(myTreeNode, new MyTreeNode("Indexes", TREE_OBJECT.INDEXES, (DynamicTree)this));
                if (string2.equals("admin")) {
                    this.addObject(myTreeNode, new MyTreeNode("System Indexes", TREE_OBJECT.SYSINDEXES, true, this));
                }
                this.addObject(myTreeNode, new MyTreeNode("Synonyms", TREE_OBJECT.SYNONYMS, true, this));
                this.addObject(myTreeNode, new MyTreeNode("Triggers", TREE_OBJECT.TRIGGERS, true, this));
                this.addObject(myTreeNode, new MyTreeNode("Execution Plans", TREE_OBJECT.PLAN_TABLES, (DynamicTree)this));
                this.expandNode(myTreeNode);
                myTreeNode.setUpdated(true);
                break;
            }
            case TABLES: {
                this.appFrame.showRowNumCB.setEnabled(true);
                if (!myTreeNode.isUpdated()) {
                    this.clearNode(myTreeNode);
                    MyTreeNode myTreeNode5 = (MyTreeNode)myTreeNode.getParent().getParent();
                    String string6 = Integer.toString(myTreeNode5.getDbVersion());
                    ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(myTreeNode.getType(), string6);
                    for (String string7 : arrayList) {
                        String[] stringArray = string7.split(Pattern.quote("||"));
                        TREE_OBJECT tREE_OBJECT = TREE_OBJECT.TABLE;
                        if (stringArray.length > 1) {
                            string7 = stringArray[0];
                            tREE_OBJECT = stringArray[1].equals("RTG") ? TREE_OBJECT.TABLE_RTG : TREE_OBJECT.TABLE_LINKED;
                        }
                        MyTreeNode myTreeNode6 = new MyTreeNode(string7, tREE_OBJECT, true, this);
                        this.addObject(myTreeNode, myTreeNode6);
                    }
                    this.expandNode(myTreeNode);
                    myTreeNode.setUpdated(true);
                }
                this.fillItemViewTable(string2, myTreeNode.getType(), this.appFrame.showRowNumCB.isSelected());
                break;
            }
            case SYSTABLES: {
                if (!myTreeNode.isUpdated()) {
                    this.clearNode(myTreeNode);
                    ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(myTreeNode.getType());
                    for (String string8 : arrayList) {
                        MyTreeNode myTreeNode7 = new MyTreeNode(string8, TREE_OBJECT.SYSTABLE, (DynamicTree)this);
                        this.addObject(myTreeNode, myTreeNode7);
                    }
                    this.expandNode(myTreeNode);
                    myTreeNode.setUpdated(true);
                }
                this.fillItemViewTable(string2, myTreeNode.getType());
                break;
            }
            case VIEWS: {
                if (!myTreeNode.isUpdated()) {
                    this.clearNode(myTreeNode);
                    ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(myTreeNode.getType());
                    for (String string9 : arrayList) {
                        MyTreeNode myTreeNode8 = new MyTreeNode(string9, TREE_OBJECT.VIEW, true, this);
                        this.addObject(myTreeNode, myTreeNode8);
                    }
                    this.expandNode(myTreeNode);
                    myTreeNode.setUpdated(true);
                }
                this.fillItemViewTable(string2, myTreeNode.getType());
                break;
            }
            case BPROCEDURES: {
                if (!myTreeNode.isUpdated()) {
                    this.clearNode(myTreeNode);
                    ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(myTreeNode.getType());
                    for (String string10 : arrayList) {
                        MyTreeNode myTreeNode9 = new MyTreeNode(string10, TREE_OBJECT.BPROCEDURE, (DynamicTree)this);
                        this.addObject(myTreeNode, myTreeNode9);
                    }
                    this.expandNode(myTreeNode);
                    myTreeNode.setUpdated(true);
                }
                this.fillItemViewTable(string2, myTreeNode.getType());
                break;
            }
            case UPROCEDURES: {
                if (!myTreeNode.isUpdated()) {
                    this.clearNode(myTreeNode);
                    ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(myTreeNode.getType());
                    for (String string11 : arrayList) {
                        MyTreeNode myTreeNode10 = new MyTreeNode(string11, TREE_OBJECT.UPROCEDURE, true, this);
                        this.addObject(myTreeNode, myTreeNode10);
                    }
                    this.expandNode(myTreeNode);
                    myTreeNode.setUpdated(true);
                }
                this.fillItemViewTable(string2, myTreeNode.getType());
                break;
            }
            case UDFS: {
                if (!myTreeNode.isUpdated()) {
                    this.clearNode(myTreeNode);
                    ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(myTreeNode.getType());
                    for (String string12 : arrayList) {
                        MyTreeNode myTreeNode11 = new MyTreeNode(string12, TREE_OBJECT.UDF, true, this);
                        this.addObject(myTreeNode, myTreeNode11);
                    }
                    this.expandNode(myTreeNode);
                    myTreeNode.setUpdated(true);
                }
                this.fillItemViewTable(string2, myTreeNode.getType());
                break;
            }
            case INDEXES: {
                if (!myTreeNode.isUpdated()) {
                    this.clearNode(myTreeNode);
                    ArrayList<String> arrayList = Globals.currentSqlConnection.readConstraints();
                    ArrayList<String> arrayList3 = Globals.currentSqlConnection.readObjects(myTreeNode.getType());
                    MyTreeNode myTreeNode12 = null;
                    for (String string13 : arrayList3) {
                        myTreeNode12 = arrayList.contains(string13) ? new MyTreeNode(string13, TREE_OBJECT.INDEXCON, true, this) : new MyTreeNode(string13, TREE_OBJECT.INDEX, true, this);
                        this.addObject(myTreeNode, myTreeNode12);
                    }
                    this.expandNode(myTreeNode);
                    myTreeNode.setUpdated(true);
                }
                this.fillItemViewTable(string2, myTreeNode.getType());
                break;
            }
            case SYSINDEXES: {
                if (!myTreeNode.isUpdated()) {
                    this.clearNode(myTreeNode);
                    ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(myTreeNode.getType());
                    for (String string14 : arrayList) {
                        MyTreeNode myTreeNode13 = new MyTreeNode(string14, TREE_OBJECT.SYSINDEX, (DynamicTree)this);
                        this.addObject(myTreeNode, myTreeNode13);
                    }
                    this.expandNode(myTreeNode);
                    myTreeNode.setUpdated(true);
                }
                this.fillItemViewTable(string2, myTreeNode.getType());
                break;
            }
            case TBLINDEXES: {
                String string15 = ((MyTreeNode)myTreeNode.getParent()).getName();
                if (!myTreeNode.isUpdated()) {
                    this.clearNode(myTreeNode);
                    ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(myTreeNode.getType(), string15);
                    for (String string16 : arrayList) {
                        MyTreeNode myTreeNode14 = null;
                        myTreeNode14 = Globals.currentSqlConnection.isConstraint(string16) ? new MyTreeNode(string16, TREE_OBJECT.TBLINDEXCON, true, this) : new MyTreeNode(string16, TREE_OBJECT.TBLINDEX, true, this);
                        this.addObject(myTreeNode, myTreeNode14);
                    }
                    this.expandNode(myTreeNode);
                    myTreeNode.setUpdated(true);
                }
                this.fillItemViewTable(string15, myTreeNode.getType());
                break;
            }
            case SYNONYMS: {
                if (!myTreeNode.isUpdated()) {
                    this.clearNode(myTreeNode);
                    ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(myTreeNode.getType());
                    for (String string17 : arrayList) {
                        MyTreeNode myTreeNode15 = new MyTreeNode(string17, TREE_OBJECT.SYNONYM, true, this);
                        this.addObject(myTreeNode, myTreeNode15);
                    }
                    this.expandNode(myTreeNode);
                    myTreeNode.setUpdated(true);
                }
                this.fillItemViewTable(string2, myTreeNode.getType());
                break;
            }
            case TRIGGERS: {
                if (!myTreeNode.isUpdated()) {
                    this.clearNode(myTreeNode);
                    ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(myTreeNode.getType());
                    for (String string18 : arrayList) {
                        MyTreeNode myTreeNode16 = new MyTreeNode(string18, TREE_OBJECT.TRIGGER, true, this);
                        this.addObject(myTreeNode, myTreeNode16);
                    }
                    this.expandNode(myTreeNode);
                    myTreeNode.setUpdated(true);
                }
                this.fillItemViewTable(string2, myTreeNode.getType());
                break;
            }
            case PLAN_TABLES: {
                if (myTreeNode.isUpdated()) break;
                this.clearNode(myTreeNode);
                ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(myTreeNode.getType());
                for (String string19 : arrayList) {
                    MyTreeNode myTreeNode17 = new MyTreeNode(string19, TREE_OBJECT.PLAN_TABLE, false, this);
                    this.addObject(myTreeNode, myTreeNode17);
                }
                this.expandNode(myTreeNode);
                myTreeNode.setUpdated(true);
                break;
            }
            case PLAN_TABLE: {
                if (myTreeNode.isUpdated()) break;
                this.clearNode(myTreeNode);
                ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(myTreeNode.getType(), myTreeNode.name);
                for (String string20 : arrayList) {
                    MyTreeNode myTreeNode18 = new MyTreeNode(string20, TREE_OBJECT.STATEMENT, false, this);
                    this.addObject(myTreeNode, myTreeNode18);
                }
                this.expandNode(myTreeNode);
                myTreeNode.setUpdated(true);
                break;
            }
            case TABLE: 
            case TABLE_RTG: 
            case TABLE_LINKED: {
                this.appFrame.sqlTableLabel.setText("Current Table : " + string2);
                this.appFrame.sqlObjectLabel.setText("Current Object = Table : " + string2);
                this.appFrame.sqlObjectLabel.setEnabled(true);
                if (myTreeNode.getChildCount() == 0) {
                    this.addObject(myTreeNode, new MyTreeNode("Indexes", TREE_OBJECT.TBLINDEXES, (DynamicTree)this));
                    this.addObject(myTreeNode, new MyTreeNode("Columns", TREE_OBJECT.COLUMNS, (DynamicTree)this));
                }
                if (!Globals.sqlTreeNodeChanged) break;
                this.fillItemViewTable(string2, myTreeNode.getType());
                Globals.currentSqlConnection.tableColumnsForRecords.clear();
                if (tAB_PAGES != TAB_PAGES.SQL_RECORDS_VIEW) break;
                this.appFrame.sqlTableColumnsButton.setForeground(Color.black);
                this.appFrame.sqlWhereButton.setForeground(Color.black);
                Globals.currentSqlConnection.orderByClause = "";
                Globals.currentSqlConnection.whereClause = "";
                SqlTableModel sqlTableModel = this.appFrame.sqlRecordsViewTable.getModel();
                sqlTableModel.columnsMode = null;
                this.fillRecordsViewTable(string2, Globals.currentSqlConnection.getSelectedUser());
                Globals.sqlTreeNodeChanged = false;
                break;
            }
            case SYSTABLE: {
                this.appFrame.sqlTableLabel.setText("Current Table : " + string2);
                this.appFrame.sqlObjectLabel.setText("Current Object = System Table : " + string2);
                this.appFrame.sqlObjectLabel.setEnabled(true);
                if (myTreeNode.getChildCount() == 0) {
                    this.addObject(myTreeNode, new MyTreeNode("Indexes", TREE_OBJECT.TBLINDEXES, (DynamicTree)this));
                }
                if (!Globals.sqlTreeNodeChanged) break;
                this.fillItemViewTable(string2, myTreeNode.getType());
                Globals.currentSqlConnection.tableColumnsForRecords.clear();
                if (tAB_PAGES != TAB_PAGES.SQL_RECORDS_VIEW) break;
                this.appFrame.sqlTableColumnsButton.setForeground(Color.black);
                this.appFrame.sqlWhereButton.setForeground(Color.black);
                Globals.currentSqlConnection.orderByClause = "";
                Globals.currentSqlConnection.whereClause = "";
                this.fillRecordsViewTable(string2, "admin");
                Globals.sqlTreeNodeChanged = false;
                break;
            }
            case VIEW: {
                this.appFrame.sqlObjectLabel.setText("Current Object = View : " + string2);
                this.appFrame.sqlObjectLabel.setEnabled(true);
                this.fillItemViewTable(string2, myTreeNode.getType());
                break;
            }
            case BPROCEDURE: {
                this.appFrame.sqlObjectLabel.setText("Current Object = Built-in Procedure : " + string2);
                this.appFrame.sqlObjectLabel.setEnabled(true);
                this.fillItemViewTable(string2, myTreeNode.getType());
                break;
            }
            case UPROCEDURE: {
                this.appFrame.sqlObjectLabel.setText("Current Object = Procedure : " + string2);
                this.appFrame.sqlObjectLabel.setEnabled(true);
                this.fillItemViewTable(string2, myTreeNode.getType());
                break;
            }
            case UDF: {
                this.appFrame.sqlObjectLabel.setText("Current Object = User Defined Function : " + string2);
                this.appFrame.sqlObjectLabel.setEnabled(true);
                this.fillItemViewTable(string2, myTreeNode.getType());
                break;
            }
            case TBLINDEX: 
            case TBLINDEXCON: {
                this.appFrame.sqlObjectLabel.setText("Current Object = Index : " + string2);
                this.appFrame.sqlObjectLabel.setEnabled(true);
                this.fillItemViewTable(string2, ((MyTreeNode)myTreeNode.getParent().getParent()).name, myTreeNode.getType());
                break;
            }
            case INDEX: 
            case INDEXCON: 
            case SYSINDEX: {
                this.appFrame.sqlObjectLabel.setText("Current Object = System Index : " + string2);
                this.appFrame.sqlObjectLabel.setEnabled(true);
                this.fillItemViewTable(string2, myTreeNode.getType());
                break;
            }
            case SYNONYM: {
                this.appFrame.sqlObjectLabel.setText("Current Object = Synonym : " + string2);
                this.appFrame.sqlObjectLabel.setEnabled(true);
                this.fillItemViewTable(string2, myTreeNode.getType());
                break;
            }
            case TRIGGER: {
                this.appFrame.sqlObjectLabel.setText("Current Object = Trigger : " + string2);
                this.appFrame.sqlObjectLabel.setEnabled(true);
                this.fillItemViewTable(string2, myTreeNode.getType());
                break;
            }
            case STATEMENT: {
                this.appFrame.sqlObjectLabel.setText(string);
                this.appFrame.sqlObjectLabel.setEnabled(true);
                this.appFrame.showRowNumCB.setEnabled(bl);
                tAB_PAGES = TAB_PAGES.SQL_EXEPLAN_VIEW;
                this.fillExePlanTable(myTreeNode);
                break;
            }
            case COLUMNS: {
                if (myTreeNode.isUpdated()) break;
                this.clearNode(myTreeNode);
                ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(myTreeNode.getType(), ((MyTreeNode)myTreeNode.getParent()).name);
                for (String string21 : arrayList) {
                    MyTreeNode myTreeNode19 = new MyTreeNode(string21, TREE_OBJECT.COLUMNS, false, this);
                    this.addObject(myTreeNode, myTreeNode19);
                }
                this.expandNode(myTreeNode);
                myTreeNode.setUpdated(true);
            }
        }
        this.appFrame.setSelectedPane(tAB_PAGES);
    }

    private void fillItemViewTable(String string, TREE_OBJECT tREE_OBJECT) {
        this.fillItemViewTable(string, "", tREE_OBJECT, false);
    }

    private void fillItemViewTable(String string, String string2, TREE_OBJECT tREE_OBJECT) {
        this.fillItemViewTable(string, string2, tREE_OBJECT, false);
    }

    private void fillItemViewTable(String string, TREE_OBJECT tREE_OBJECT, Boolean bl) {
        this.fillItemViewTable(string, "", tREE_OBJECT, bl);
    }

    private void fillItemViewTable(String string, String string2, TREE_OBJECT tREE_OBJECT, Boolean bl) {
        ResultSet resultSet = null;
        SqlTableModel sqlTableModel = this.appFrame.sqlItemsViewTable.getModel();
        resultSet = Globals.currentSqlConnection.execRsObjectQuery(string, string2, tREE_OBJECT, bl);
        if (resultSet != null) {
            sqlTableModel.populateFromResultSet(resultSet, false);
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "fillItemViewTable");
            }
        }
        if (bl.booleanValue()) {
            int n = sqlTableModel.getRowCount();
            for (int i = 0; i < n; ++i) {
                String string3 = sqlTableModel.getValueAt(i, 2).toString();
                String string4 = sqlTableModel.getValueAt(i, 4).toString();
                resultSet = Globals.currentSqlConnection.execRsQuery("select count(*) from " + string4 + ".\"" + string3 + "\"");
                if (resultSet == null) continue;
                sqlTableModel.addRowNum(resultSet, i);
                try {
                    resultSet.close();
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    private void fillExePlanTable(MyTreeNode myTreeNode) {
        Object object;
        String string = "";
        String string2 = Globals.currentSqlConnection.getSelectedUser();
        MyTreeNode myTreeNode2 = (MyTreeNode)myTreeNode.getParent();
        String string3 = myTreeNode2.name;
        String string4 = myTreeNode.name;
        ResultSet resultSet = null;
        String string5 = "select query_id,query_stmt from " + string2 + "." + string3 + " where stmt_id = '" + string4 + "'";
        resultSet = Globals.currentSqlConnection.execRsQuery(string5);
        if (resultSet != null) {
            try {
                if (resultSet.next()) {
                    string = resultSet.getString(1);
                    this.appFrame.exePlanStatementTA.setText("Plan for Statement : " + resultSet.getString(2));
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "fillExePlanTable");
            }
        }
        Globals.ShowWaitCursor();
        SqlExePlanTable.SqlExePlanTableModel sqlExePlanTableModel = this.appFrame.sqlExePlanTable.getModel();
        sqlExePlanTableModel.clearTable();
        string5 = "call admin.access_get_qep('" + string2 + "','" + string3 + "','" + string4 + "',2000)";
        resultSet = Globals.currentSqlConnection.execRsQuery(string5);
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    object = new ArrayList<String>();
                    ((ArrayList)object).add(resultSet.getString(1));
                    sqlExePlanTableModel.addRow((ArrayList)object);
                }
                resultSet.close();
                sqlExePlanTableModel.fireTableDataChanged();
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "fillExePlanTable");
            }
        }
        if (!string.isEmpty()) {
            object = new QEPTree(this.appFrame, string2, string3, string);
        }
        Globals.ShowNormalCursor();
    }

    public void fillRecordsViewTable(String string) {
        this.fillRecordsViewTable(string, 0);
    }

    public void fillRecordsViewTable(String string, int n) {
        this.fillRecordsViewTable(this.currentNode.getName(), string, n);
    }

    private void fillRecordsViewTable(String string, String string2) {
        this.fillRecordsViewTable(string, string2, 0);
    }

    private void fillRecordsViewTable(String string, String string2, int n) {
        Globals.ShowWaitCursor();
        ResultSet resultSet = null;
        SqlTableModel sqlTableModel = this.appFrame.sqlRecordsViewTable.getModel();
        sqlTableModel.clearTable();
        sqlTableModel.tableType = 1;
        if (Globals.currentSqlConnection.tableColumnsForRecords.isEmpty()) {
            Globals.currentSqlConnection.execRsColumnsQuery(string, string2);
        }
        if ((resultSet = Globals.currentSqlConnection.execRsRecordsQuery(string, string2, n)) != null) {
            sqlTableModel.populateFromResultSet(resultSet, true);
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                Globals.showException(sQLException, "fillItemViewTable");
            }
        }
        Globals.ShowNormalCursor();
    }

    private void clearItemsViewTable() {
        SqlTableModel sqlTableModel = this.appFrame.sqlItemsViewTable.getModel();
        sqlTableModel.clearTable();
    }

    private void clearRecordsViewTable() {
        SqlTableModel sqlTableModel = this.appFrame.sqlRecordsViewTable.getModel();
        sqlTableModel.clearTable();
    }

    private boolean refreshCurrentServer() {
        boolean bl = true;
        String string = "";
        String string2 = "";
        String string3 = "";
        block5: for (MyTreeNode myTreeNode = this.currentNode; myTreeNode != null && myTreeNode.getType() != null; myTreeNode = (MyTreeNode)myTreeNode.getParent()) {
            switch (myTreeNode.getType()) {
                case SERVER: {
                    string = myTreeNode.getName();
                    continue block5;
                }
                case DATABASE: {
                    string2 = myTreeNode.getName();
                    continue block5;
                }
                case USER: {
                    string3 = myTreeNode.getName();
                }
            }
        }
        if (string2.isEmpty()) {
            return true;
        }
        if (!string.equalsIgnoreCase(Globals.currentSqlConnection.getServerId()) || !string2.equalsIgnoreCase(Globals.currentSqlConnection.getDatabaseName())) {
            bl = this.changeConnection(string, string2);
        }
        if (!Globals.currentSqlConnection.isConnected() && bl) {
            bl = this.changeConnection(string, string2);
        }
        Globals.currentSqlConnection.setSelectedUser(string3);
        return bl;
    }

    private SqlConnection checkConnections(String string, String string2) {
        for (SqlConnection sqlConnection : Globals.sqlConnections) {
            if (!string.equals(sqlConnection.getServerId()) || !string2.equalsIgnoreCase(sqlConnection.getDatabaseName())) continue;
            return sqlConnection;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean changeConnection(String string, String string2) {
        SqlConnection sqlConnection = Globals.currentSqlConnection;
        SqlConnection sqlConnection2 = this.checkConnections(string, string2);
        if (sqlConnection2 != null) {
            if (Globals.sqlMultipleConnections) {
                Globals.currentSqlConnection = sqlConnection2;
            } else if (Globals.appProps.sqlAutoCommit) {
                Globals.currentSqlConnection.disconnect();
                Globals.currentSqlConnection = new SqlConnection(Globals.currentSqlConnection, string2, false, true);
            } else {
                if (this.showWarning() != 0) return false;
                Globals.currentSqlConnection.disconnect();
                Globals.currentSqlConnection = new SqlConnection(Globals.currentSqlConnection, string2, false, true);
            }
        } else {
            if (!Globals.sqlMultipleConnections) {
                if (Globals.appProps.sqlAutoCommit) {
                    Globals.currentSqlConnection.disconnect();
                    Globals.sqlConnections.remove((Object)Globals.currentSqlConnection);
                } else {
                    if (this.showWarning() != 0) return false;
                    Globals.currentSqlConnection.disconnect();
                    Globals.sqlConnections.remove((Object)Globals.currentSqlConnection);
                }
            }
            if (!string.equals(Globals.currentSqlConnection.getServerId())) {
                Object[] objectArray = SqlConnection.splitServerId(string);
                CtreeServer ctreeServer = new CtreeServer((String)objectArray[0], ((Integer)objectArray[1]).intValue(), string2, Globals.currentSqlConnection.getLoggedUser(), Globals.currentSqlConnection.getPassword());
                Globals.currentSqlConnection = new SqlConnection(ctreeServer, false, true);
            } else {
                Globals.currentSqlConnection = new SqlConnection(Globals.currentSqlConnection, string2, false, true);
            }
            if (!Globals.currentSqlConnection.isConnected()) {
                Globals.currentSqlConnection = sqlConnection;
                return false;
            }
            Globals.sqlConnections.add(Globals.currentSqlConnection);
        }
        this.updateStatusBar();
        return true;
    }

    private int showWarning() {
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        String string = "You are about to change database.\n\nChanging database will disconnect from the server and reconnect using the new database.\n";
        string = string + "This operation involves a \"rollback\" statement\n";
        string = string + "If you have pending operations that you want to \"commit\", you must abort current operation and issue a \"commit\" before proceeding.\n";
        string = string + "\nDo you want to proceed ?";
        Object[] objectArray = new Object[]{"Yes", "No"};
        return JOptionPane.showOptionDialog(jFrame, string, "Change Database", 0, 1, null, objectArray, objectArray[0]);
    }

    public void updateStatusBar() {
        String string;
        String string2 = Globals.isDBA ? "Yes" : "No";
        String string3 = string = Globals.hasResource ? "Yes" : "No";
        if (Globals.currentSqlConnection != null) {
            if (Globals.currentSqlConnection.isConnected()) {
                this.appFrame.connectSBLabel.setText("Connected to Database : " + Globals.currentSqlConnection.getServerId() + ":" + Globals.currentSqlConnection.getDatabaseName());
                this.appFrame.userSBLabel.setText("Connected as : " + Globals.currentSqlConnection.getLoggedUser() + " (DBA = " + string2 + " - Resource = " + string + ")");
            } else {
                this.appFrame.connectSBLabel.setText("Disconnected");
                this.appFrame.userSBLabel.setText("");
            }
        }
    }

    public synchronized void addAdditionalServer(String string) {
        for (String object2 : this.servers) {
            if (!object2.equals(string)) continue;
            return;
        }
        MyTreeNode myTreeNode = (MyTreeNode)this.getModel().getRoot();
        MyTreeNode myTreeNode2 = new MyTreeNode(string, TREE_OBJECT.SERVER, (DynamicTree)this);
        this.addObject(myTreeNode, myTreeNode2);
        this.servers.add(string);
    }

    public synchronized void addBroadCastingServer(String string) {
        for (String object2 : this.servers) {
            if (!object2.equals(string)) continue;
            return;
        }
        MyTreeNode myTreeNode = (MyTreeNode)this.getModel().getRoot();
        MyTreeNode myTreeNode2 = new MyTreeNode(string, TREE_OBJECT.SERVER, (DynamicTree)this);
        this.addObject(myTreeNode, myTreeNode2);
        this.servers.add(string);
    }

    public void createNewServer(CtreeServer ctreeServer, boolean bl, boolean bl2) {
        if (bl) {
            Globals.currentSqlConnection = new SqlConnection(ctreeServer, false, bl2);
        } else {
            SqlConnection sqlConnection = new SqlConnection(ctreeServer, true, bl2);
            if (sqlConnection.isConnected()) {
                Globals.currentSqlConnection = sqlConnection;
                this.addFirstServerToTree();
            }
            this.updateStatusBar();
        }
        Globals.sqlConnections.add(Globals.currentSqlConnection);
    }

    public MyTreeNode getCurrentNode() {
        return this.currentNode;
    }

    public void refresh() {
        this.resetIsNodeUpdated(this.currentNode);
        Globals.sqlTreeNodeChanged = true;
        this.valueChanged();
    }

    public void refreshRightTables() {
        this.valueChanged();
    }

    private void resetIsNodeUpdated(MyTreeNode myTreeNode) {
        if (myTreeNode != null) {
            myTreeNode.setUpdated(false);
            for (int i = 0; i < myTreeNode.getChildCount(); ++i) {
                MyTreeNode myTreeNode2 = (MyTreeNode)myTreeNode.getChildAt(i);
                this.resetIsNodeUpdated(myTreeNode2);
            }
        }
    }

    private void addDatabases(MyTreeNode myTreeNode) {
        ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(TREE_OBJECT.DATABASE);
        for (String string : arrayList) {
            MyTreeNode myTreeNode2 = new MyTreeNode(string, TREE_OBJECT.DATABASE, (DynamicTree)this);
            this.addObject(myTreeNode, myTreeNode2);
        }
        this.expandNode();
        this.expandNode(myTreeNode);
    }

    private void addFirstServerToTree() {
        MyTreeNode myTreeNode = new MyTreeNode(Globals.currentSqlConnection.getServerId(), TREE_OBJECT.SERVER, (DynamicTree)this);
        String string = Globals.currentSqlConnection.getDatabaseName();
        Globals.currentSqlConnection.setTreeNode(myTreeNode);
        MyTreeNode myTreeNode2 = this.addObject(null, myTreeNode);
        ArrayList<String> arrayList = Globals.currentSqlConnection.readObjects(TREE_OBJECT.DATABASE);
        for (String string2 : arrayList) {
            MyTreeNode myTreeNode3 = new MyTreeNode(string2, TREE_OBJECT.DATABASE, (DynamicTree)this);
            this.addObject(myTreeNode2, myTreeNode3);
            int n = Globals.currentSqlConnection.getDatabaseVersion();
            myTreeNode3.setDbVersion(n);
            if (!string2.equalsIgnoreCase(string)) continue;
            this.defaultNode = myTreeNode3;
        }
        this.expandNode();
        this.expandNode(myTreeNode2);
        this.setSelectionPath(new TreePath(myTreeNode2.getPath()));
        this.servers.add(Globals.currentSqlConnection.getServerId());
    }

    private void setupActions(TREE_OBJECT tREE_OBJECT) {
        this.popup = new JPopupMenu();
        this.appFrame.actionsMenu.removeAll();
        MouseListener[] mouseListenerArray = this.appFrame.actionsMenu.getMouseListeners();
        if (mouseListenerArray.length == 1) {
            this.appFrame.actionsMenu.addMouseListener(this.popupListener);
        }
        boolean bl = false;
        switch (tREE_OBJECT) {
            case SERVER: {
                if (this.currentNode.getChildCount() > 0) {
                    this.addMenuItem("Disconnect From This Server", "Disconnect.png", Character.valueOf('D'), new SqlActions(SQL_MODE.SERVER_DISCONNECT, ""), false, false);
                    this.addMenuItem("Add Existing Database", null, Character.valueOf('A'), new SqlActions(SQL_MODE.DATABASE_ADD, ""), true, true);
                    this.addMenuItem("Create New Database", null, Character.valueOf('N'), new SqlActions(SQL_MODE.DATABASE_CREATE, ""), true, true);
                    if (Globals.advancedMode) {
                        this.addMenuItem("Create User", null, Character.valueOf('U'), new SqlActions(SQL_MODE.USER_CREATE, ""), true, true);
                    }
                    bl = true;
                    break;
                }
                this.addMenuItem("Connect To This Server", "Connect.png", Character.valueOf('C'), new SqlActions(SQL_MODE.SERVER_CONNECT, ""), false, false);
                bl = true;
                break;
            }
            case DATABASE: {
                if (Globals.sqlMultipleConnections) {
                    this.addMenuItem("Disconnect From This Database", null, Character.valueOf('D'), new SqlActions(SQL_MODE.DATABASE_DISCONNECT, ""), false, false);
                }
                this.addMenuItem("Clear Database", null, Character.valueOf('C'), new SqlActions(SQL_MODE.DATABASE_CLEAR, ""), true, true);
                bl = true;
                break;
            }
            case USER: {
                this.addMenuItem("Set Privileges", null, Character.valueOf('S'), new SqlActions(SQL_MODE.USER_PRIVILEGES, ""), true, false);
                if (Globals.sqlMultiSelectMode && this.appFrame.getSelectedPane() == TAB_PAGES.SQL_EXEPLAN_VIEW) {
                    this.addMenuItem("Drop (All Checked Tables)", null, Character.valueOf('D'), new SqlActions(SQL_MODE.USER_PRIVILEGES, ""), true, false);
                }
                bl = true;
                break;
            }
            case TABLES: {
                this.addMenuItem("Create", null, Character.valueOf('C'), new SqlActions(SQL_MODE.TABLE_CREATE, ""), true, true);
                if (Globals.sqlMultiSelectMode) {
                    this.addMenuItem("Drop (All Checked Tables)", null, Character.valueOf('D'), new SqlActions(SQL_MODE.TABLE_DROP, "_$Checked"), true, false);
                    this.addMenuItem("Dump Rows (All Checked Tables)", null, Character.valueOf('u'), new SqlActions(SQL_MODE.TABLE_DUMP, "_$Checked"), true, false);
                    this.addMenuItem("Export Schema (All Checked Tables)", null, Character.valueOf('E'), new SqlActions(SQL_MODE.TABLE_EXPORT, "_$Checked"), false, false);
                    this.addMenuItem("Permisions (All Checked Tables)", null, Character.valueOf('P'), new SqlActions(SQL_MODE.TABLE_PERMISSIONS, "_$Checked"), true, false);
                } else {
                    this.addMenuItem("Dump Rows (All Tables)", null, Character.valueOf('u'), new SqlActions(SQL_MODE.TABLE_DUMP, ""), true, false);
                    this.addMenuItem("Export Schema (All Tables)", null, Character.valueOf('E'), new SqlActions(SQL_MODE.TABLE_EXPORT, ""), false, false);
                }
                bl = true;
                break;
            }
            case SYSTABLES: {
                break;
            }
            case VIEWS: {
                this.addMenuItem("Create", null, Character.valueOf('C'), new SqlActions(SQL_MODE.VIEW_CREATE, ""), true, true);
                if (Globals.sqlMultiSelectMode) {
                    this.addMenuItem("Drop (All Checked Views)", null, Character.valueOf('D'), new SqlActions(SQL_MODE.VIEW_DROP, "_$Checked"), true, false);
                    this.addMenuItem("Export Schema (All Checked Views)", null, Character.valueOf('E'), new SqlActions(SQL_MODE.VIEW_EXPORT, "_$Checked"), false, false);
                    this.addMenuItem("Permisions (All Checked Views)", null, Character.valueOf('P'), new SqlActions(SQL_MODE.VIEW_PERMISSIONS, "_$Checked"), true, false);
                } else {
                    this.addMenuItem("Export Schema (All Views)", null, Character.valueOf('E'), new SqlActions(SQL_MODE.VIEW_EXPORT, ""), false, false);
                }
                bl = true;
                break;
            }
            case BPROCEDURES: {
                break;
            }
            case UPROCEDURES: {
                this.addMenuItem("Create", null, Character.valueOf('C'), new SqlActions(SQL_MODE.PROC_CREATE, ""), true, true);
                if (Globals.sqlMultiSelectMode) {
                    this.addMenuItem("Drop (All Checked Procedures)", null, Character.valueOf('D'), new SqlActions(SQL_MODE.PROC_DROP, "_$Checked"), true, false);
                    this.addMenuItem("Export Schema (All Checked Procedures)", null, Character.valueOf('E'), new SqlActions(SQL_MODE.PROC_EXPORT, "_$Checked"), false, false);
                    this.addMenuItem("Permisions (All Checked Procedures)", null, Character.valueOf('P'), new SqlActions(SQL_MODE.PROC_PERMISSIONS, "_$Checked"), true, false);
                    break;
                }
                this.addMenuItem("Export Schema (All Procedures)", null, Character.valueOf('E'), new SqlActions(SQL_MODE.PROC_EXPORT, ""), false, false);
                break;
            }
            case UDFS: {
                this.addMenuItem("Create", null, Character.valueOf('C'), new SqlActions(SQL_MODE.UDF_CREATE, ""), true, true);
                if (Globals.sqlMultiSelectMode) {
                    this.addMenuItem("Drop (All Checked UDFs)", null, Character.valueOf('D'), new SqlActions(SQL_MODE.UDF_DROP, "_$Checked"), true, false);
                    this.addMenuItem("Export Schema (All Checked UDFs)", null, Character.valueOf('E'), new SqlActions(SQL_MODE.UDF_EXPORT, "_$Checked"), false, false);
                    this.addMenuItem("Permisions (All Checked UDFs)", null, Character.valueOf('P'), new SqlActions(SQL_MODE.UDF_PERMISSIONS, "_$Checked"), true, false);
                    break;
                }
                this.addMenuItem("Export Schema (All UDFs)", null, Character.valueOf('E'), new SqlActions(SQL_MODE.UDF_EXPORT, ""), false, false);
                break;
            }
            case INDEXES: {
                this.addMenuItem("Create", null, Character.valueOf('C'), new SqlActions(SQL_MODE.INDEX_CREATE, ""), true, true);
                if (!Globals.sqlMultiSelectMode) break;
                this.addMenuItem("Drop (All Checked Indexes)", null, Character.valueOf('D'), new SqlActions(SQL_MODE.INDEX_DROP, "_$Checked"), true, false);
                break;
            }
            case TBLINDEXES: {
                bl = false;
                MyTreeNode myTreeNode = (MyTreeNode)this.currentNode.getParent();
                TREE_OBJECT tREE_OBJECT2 = myTreeNode.getType();
                if (tREE_OBJECT2 == TREE_OBJECT.TABLE || tREE_OBJECT2 == TREE_OBJECT.TABLE_LINKED || tREE_OBJECT2 == TREE_OBJECT.TABLE_RTG) {
                    bl = true;
                    this.addMenuItem("Create", null, Character.valueOf('C'), new SqlActions(SQL_MODE.INDEX_CREATE, this.currentNode.name), true, true);
                }
                if (!Globals.sqlMultiSelectMode) break;
                this.addMenuItem("Drop (All Checked Indexes)", null, Character.valueOf('D'), new SqlActions(SQL_MODE.INDEX_DROP, "_$Checked"), true, false);
                break;
            }
            case SYSINDEXES: {
                break;
            }
            case SYNONYMS: {
                this.addMenuItem("Create", null, Character.valueOf('C'), new SqlActions(SQL_MODE.SYNONYM_CREATE, ""), true, true);
                if (Globals.sqlMultiSelectMode) {
                    this.addMenuItem("Drop (All Checked Synonyms)", null, Character.valueOf('D'), new SqlActions(SQL_MODE.SYNONYM_DROP, "_$Checked"), true, false);
                }
                bl = true;
                break;
            }
            case TRIGGERS: {
                this.addMenuItem("Create", null, Character.valueOf('C'), new SqlActions(SQL_MODE.TRIGGER_CREATE, ""), true, true);
                if (Globals.sqlMultiSelectMode) {
                    this.addMenuItem("Drop (All Checked Triggers)", null, Character.valueOf('D'), new SqlActions(SQL_MODE.TRIGGER_DROP, "_$Checked"), true, false);
                    this.addMenuItem("Export Schema (All Checked Triggers)", null, Character.valueOf('E'), new SqlActions(SQL_MODE.TRIGGER_EXPORT, "_$Checked"), false, false);
                } else {
                    this.addMenuItem("Export Schema (All Triggers)", null, Character.valueOf('E'), new SqlActions(SQL_MODE.TRIGGER_EXPORT, ""), false, false);
                }
                bl = true;
                break;
            }
            case PLAN_TABLE: {
                this.addMenuItem("Drop Table", null, Character.valueOf('D'), new SqlActions(SQL_MODE.TABLE_DROP, this.currentNode.name), true, false);
                bl = true;
                break;
            }
            case TABLE: 
            case TABLE_RTG: 
            case TABLE_LINKED: {
                SqlConnection.ObjectPrivileges objectPrivileges = Globals.currentSqlConnection.getPrivileges(tREE_OBJECT, this.currentNode.name);
                boolean bl2 = objectPrivileges.isOwner;
                if (tREE_OBJECT == TREE_OBJECT.TABLE_RTG) {
                    bl2 = false;
                }
                this.addMenuItem("Alter Table", null, Character.valueOf('A'), new SqlActions(SQL_MODE.TABLE_ALTER, this.currentNode.name), true, true, bl2);
                this.addMenuItem("Clone", null, Character.valueOf('l'), new SqlActions(SQL_MODE.TABLE_CLONE, this.currentNode.name), true, true, bl2);
                this.addMenuItem("Constraints", null, Character.valueOf('C'), new SqlActions(SQL_MODE.TABLE_CONSTRAINTS, this.currentNode.name), true, true, bl2);
                this.addMenuItem("Drop", null, Character.valueOf('D'), new SqlActions(SQL_MODE.TABLE_DROP, this.currentNode.name), true, true, objectPrivileges.isOwner);
                this.addMenuItem("Dump Rows", null, Character.valueOf('u'), new SqlActions(SQL_MODE.TABLE_DUMP, this.currentNode.name), true, true, true);
                this.addMenuItem("Export Schema", null, Character.valueOf('E'), new SqlActions(SQL_MODE.TABLE_EXPORT, this.currentNode.name), false, false);
                this.addMenuItem("Permissions", null, Character.valueOf('P'), new SqlActions(SQL_MODE.TABLE_PERMISSIONS, this.currentNode.name), true, false, objectPrivileges.isOwner);
                this.addMenuItem("Properties", null, Character.valueOf('o'), new SqlActions(SQL_MODE.TABLE_PROPERTIES, this.currentNode.name), false, false);
                this.addMenuItem("Rename", null, Character.valueOf('R'), new SqlActions(SQL_MODE.TABLE_RENAME, this.currentNode.name), true, true, bl2);
                bl = true;
                break;
            }
            case SYSTABLE: {
                break;
            }
            case VIEW: {
                SqlConnection.ObjectPrivileges objectPrivileges = Globals.currentSqlConnection.getPrivileges(tREE_OBJECT, this.currentNode.name);
                this.addMenuItem("Drop", null, Character.valueOf('D'), new SqlActions(SQL_MODE.VIEW_DROP, this.currentNode.name), true, true, objectPrivileges.isOwner);
                this.addMenuItem("Export Schema", null, Character.valueOf('E'), new SqlActions(SQL_MODE.VIEW_EXPORT, this.currentNode.name), false, false);
                this.addMenuItem("Permissions", null, Character.valueOf('P'), new SqlActions(SQL_MODE.VIEW_PERMISSIONS, this.currentNode.name), true, false, objectPrivileges.isOwner);
                this.addMenuItem("Properties", null, Character.valueOf('o'), new SqlActions(SQL_MODE.VIEW_PROPERTIES, this.currentNode.name), false, false);
                this.addMenuItem("Rename", null, Character.valueOf('R'), new SqlActions(SQL_MODE.VIEW_RENAME, this.currentNode.name), true, true, objectPrivileges.isOwner);
                this.addMenuItem("Open (Run)", null, Character.valueOf('O'), new SqlActions(SQL_MODE.VIEW_OPEN, this.currentNode.name), true, true, objectPrivileges.isOwner);
                bl = true;
                break;
            }
            case BPROCEDURE: {
                this.addMenuItem("Permissions", null, Character.valueOf('P'), new SqlActions(SQL_MODE.PROC_PERMISSIONS, this.currentNode.name), true, false);
                bl = true;
                break;
            }
            case UPROCEDURE: {
                this.addMenuItem("Drop", null, Character.valueOf('D'), new SqlActions(SQL_MODE.PROC_DROP, this.currentNode.name), true, false);
                this.addMenuItem("Export Schema", null, Character.valueOf('E'), new SqlActions(SQL_MODE.PROC_EXPORT, this.currentNode.name), false, false);
                this.addMenuItem("Permissions", null, Character.valueOf('P'), new SqlActions(SQL_MODE.PROC_PERMISSIONS, this.currentNode.name), true, false);
                this.addMenuItem("Properties", null, Character.valueOf('o'), new SqlActions(SQL_MODE.PROC_PROPERTIES, this.currentNode.name), false, false);
                bl = true;
                break;
            }
            case UDF: {
                this.addMenuItem("Drop", null, Character.valueOf('D'), new SqlActions(SQL_MODE.UDF_DROP, this.currentNode.name), true, false);
                this.addMenuItem("Export Schema", null, Character.valueOf('E'), new SqlActions(SQL_MODE.UDF_EXPORT, this.currentNode.name), false, false);
                this.addMenuItem("Permissions", null, Character.valueOf('P'), new SqlActions(SQL_MODE.UDF_PERMISSIONS, this.currentNode.name), true, false);
                this.addMenuItem("Properties", null, Character.valueOf('o'), new SqlActions(SQL_MODE.UDF_PROPERTIES, this.currentNode.name), false, false);
                bl = true;
                break;
            }
            case TBLINDEX: 
            case INDEX: {
                bl = false;
                MyTreeNode myTreeNode = (MyTreeNode)this.currentNode.getParent().getParent();
                if (myTreeNode.getType() == TREE_OBJECT.TABLE_RTG) break;
                this.addMenuItem("Drop", null, Character.valueOf('D'), new SqlActions(SQL_MODE.INDEX_DROP, this.currentNode.name), true, true);
                bl = true;
                break;
            }
            case SYSINDEX: {
                break;
            }
            case SYNONYM: {
                SqlConnection.ObjectPrivileges objectPrivileges = Globals.currentSqlConnection.getPrivileges(tREE_OBJECT, this.currentNode.name);
                this.addMenuItem("Drop", null, Character.valueOf('D'), new SqlActions(SQL_MODE.SYNONYM_DROP, this.currentNode.name), true, false);
                this.addMenuItem("Rename", null, Character.valueOf('R'), new SqlActions(SQL_MODE.SYNONYM_RENAME, this.currentNode.name), true, true);
                bl = true;
                break;
            }
            case TRIGGER: {
                SqlConnection.ObjectPrivileges objectPrivileges = Globals.currentSqlConnection.getPrivileges(tREE_OBJECT, this.currentNode.name);
                this.addMenuItem("Drop", null, Character.valueOf('D'), new SqlActions(SQL_MODE.TRIGGER_DROP, this.currentNode.name), true, false);
                this.addMenuItem("Export Schema", null, Character.valueOf('E'), new SqlActions(SQL_MODE.TRIGGER_EXPORT, this.currentNode.name), false, false);
                this.addMenuItem("Properties", null, Character.valueOf('o'), new SqlActions(SQL_MODE.TRIGGER_PROPERTIES, this.currentNode.name), false, false);
                bl = true;
                break;
            }
            case STATEMENT: {
                this.addMenuItem("Drop", null, Character.valueOf('D'), new SqlActions(SQL_MODE.STATEMENT_DROP, this.currentNode.name), true, false);
            }
        }
        if (bl) {
            this.appFrame.actionsMenu.add(new JPopupMenu.Separator());
            this.popup.add(new JPopupMenu.Separator());
        }
        this.addMenuItem("Refresh", "Refresh.png", Character.valueOf('R'), new RefreshAction(), false, false);
    }

    private void addMenuItem(String string, String string2, Character c, ActionListener actionListener, boolean bl, boolean bl2) {
        this.addMenuItem(string, string2, c, actionListener, bl, bl2, null);
    }

    private void addMenuItem(String string, String string2, Character c, ActionListener actionListener, boolean bl, boolean bl2, Boolean bl3) {
        JMenuItem jMenuItem = new JMenuItem(string);
        JMenuItem jMenuItem2 = new JMenuItem(string);
        if (string2 != null) {
            jMenuItem.setIcon(Globals.getIcon(string2));
            jMenuItem2.setIcon(Globals.getIcon(string2));
        }
        if (c != null) {
            jMenuItem.setMnemonic(c.charValue());
            jMenuItem2.setMnemonic(c.charValue());
        }
        jMenuItem.addActionListener(actionListener);
        jMenuItem2.addActionListener(actionListener);
        if (bl && bl2 && bl3 != null) {
            if (!(Globals.isDBA || Globals.hasResource || bl3.booleanValue())) {
                jMenuItem.setEnabled(false);
                jMenuItem2.setEnabled(false);
            }
        } else if (bl && bl2) {
            if (!Globals.isDBA && !Globals.hasResource) {
                jMenuItem.setEnabled(false);
                jMenuItem2.setEnabled(false);
            }
        } else {
            if (bl && !Globals.isDBA) {
                jMenuItem.setEnabled(false);
                jMenuItem2.setEnabled(false);
            }
            if (bl2 && !Globals.hasResource) {
                jMenuItem.setEnabled(false);
                jMenuItem2.setEnabled(false);
            }
        }
        if (bl3 != null && !bl3.booleanValue()) {
            jMenuItem.setEnabled(false);
            jMenuItem2.setEnabled(false);
        }
        this.popup.add(jMenuItem);
        this.appFrame.actionsMenu.add(jMenuItem2);
    }

    void dropObject(TREE_OBJECT tREE_OBJECT, String string, MyTreeNode myTreeNode) {
        Object object;
        int n;
        Object[] objectArray;
        String string2 = null;
        Boolean bl = false;
        JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
        String string3 = Globals.currentSqlConnection.getSelectedUser();
        switch (tREE_OBJECT) {
            case USER: {
                break;
            }
            case TABLES: {
                bl = true;
                string2 = "drop table ";
                break;
            }
            case TABLE: 
            case TABLE_RTG: 
            case TABLE_LINKED: {
                string2 = "drop table ";
                break;
            }
            case PLAN_TABLE: {
                bl = true;
                break;
            }
            case VIEWS: {
                bl = true;
                string2 = "drop view ";
                break;
            }
            case VIEW: {
                string2 = "drop view ";
                break;
            }
            case UPROCEDURES: {
                bl = true;
                string2 = "drop procedure ";
                break;
            }
            case UPROCEDURE: {
                string2 = "drop procedure ";
                break;
            }
            case UDFS: {
                bl = true;
                string2 = "drop function ";
                break;
            }
            case UDF: {
                string2 = "drop function ";
                break;
            }
            case INDEXES: {
                bl = true;
                string2 = "drop index ";
                break;
            }
            case INDEX: {
                string2 = "drop index ";
                break;
            }
            case TBLINDEX: {
                bl = true;
                string2 = "drop index ";
                break;
            }
            case SYNONYMS: {
                bl = true;
                string2 = "drop synonym ";
                break;
            }
            case SYNONYM: {
                objectArray = "select ispublic from admin.syssynonyms where sowner = '" + string3 + "' and sname = '" + myTreeNode.name + "'";
                n = 0;
                object = Globals.currentSqlConnection.execRsQuery((String)objectArray);
                if (object != null) {
                    try {
                        while (object.next()) {
                            int n2 = object.getInt(1);
                            if (n2 != 1) continue;
                            n = 1;
                        }
                        object.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (n != 0) {
                    string2 = "drop public synonym ";
                    break;
                }
                string2 = "drop synonym ";
                break;
            }
            case TRIGGERS: {
                bl = true;
                string2 = "drop trigger ";
                break;
            }
            case TRIGGER: {
                string2 = "drop trigger ";
                break;
            }
            case STATEMENT: {
                string2 = "delete from " + string3 + ".\"" + ((MyTreeNode)myTreeNode.getParent()).name + "\" where stmt_id ='" + myTreeNode.name + "'";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (!bl.booleanValue() && string2 != null) {
            Toolkit.getDefaultToolkit().beep();
            objectArray = new Object[]{"Proceed", "Abort"};
            String string4 = "You are going to drop the following object :\n\n" + string3 + "." + myTreeNode.name + "\n\nAre you sure ?";
            int n3 = JOptionPane.showOptionDialog(jFrame, string4, "Drop Object", 0, 2, null, objectArray, objectArray[0]);
            if (n3 == 0) {
                if (tREE_OBJECT != TREE_OBJECT.STATEMENT) {
                    string2 = string2 + "\"" + string3 + "\".\"" + myTreeNode.name + "\"";
                }
                try {
                    Globals.currentSqlConnection.executeUpdate(string2);
                }
                catch (SQLException sQLException) {
                    Globals.showException(sQLException, "Drop Object");
                }
            }
        } else {
            objectArray = false;
            n = 0;
            if (myTreeNode != null) {
                object = "You are going to drop the following objects :\n\n";
                if (myTreeNode.getChildCount() >= 0) {
                    int n4;
                    Object[] objectArray2 = myTreeNode.children();
                    while (objectArray2.hasMoreElements()) {
                        MyTreeNode myTreeNode2 = (MyTreeNode)objectArray2.nextElement();
                        if (!myTreeNode2.isChecked()) continue;
                        objectArray = true;
                        if (++n < 30) {
                            object = (String)object + string3 + "." + myTreeNode2.name + "\n";
                            continue;
                        }
                        if (n != 30) continue;
                        object = (String)object + "...\n";
                    }
                    object = (String)object + "\n\nAre you sure ?";
                    Toolkit.getDefaultToolkit().beep();
                    objectArray2 = new Object[]{"Proceed", "Abort"};
                    if (objectArray.booleanValue() && (n4 = JOptionPane.showOptionDialog(jFrame, object, "Drop Object", 0, 2, null, objectArray2, objectArray2[0])) == 0) {
                        int n5 = 5;
                        do {
                            Enumeration<TreeNode> enumeration = myTreeNode.children();
                            while (enumeration.hasMoreElements()) {
                                String string5;
                                MyTreeNode myTreeNode3 = (MyTreeNode)enumeration.nextElement();
                                if (!myTreeNode3.isChecked()) continue;
                                if (tREE_OBJECT == TREE_OBJECT.SYNONYMS) {
                                    string5 = "select ispublic from admin.syssynonyms where sowner = '" + string3 + "' and sname = '" + myTreeNode3.name + "'";
                                    boolean bl2 = false;
                                    ResultSet resultSet = Globals.currentSqlConnection.execRsQuery(string5);
                                    if (resultSet != null) {
                                        try {
                                            while (resultSet.next()) {
                                                int n6 = resultSet.getInt(1);
                                                if (n6 != 1) continue;
                                                bl2 = true;
                                            }
                                            resultSet.close();
                                        }
                                        catch (SQLException sQLException) {
                                            // empty catch block
                                        }
                                    }
                                    string2 = bl2 ? "drop public synonym " : "drop synonym ";
                                }
                                string5 = "";
                                string5 = tREE_OBJECT == TREE_OBJECT.PLAN_TABLE ? string2 + " query_id = \"" + myTreeNode3.name + "\"" : string2 + string3 + ".\"" + myTreeNode3.name + "\"";
                                try {
                                    Globals.currentSqlConnection.executeUpdate(string5);
                                }
                                catch (SQLException sQLException) {
                                    Globals.showException(sQLException, "Drop Object");
                                }
                                myTreeNode3.setChecked(false);
                            }
                        } while (n5-- > 0);
                    }
                }
            }
        }
    }

    private void openView(String string) {
        String string2 = "select * from " + string;
        if (string2 != null) {
            this.appFrame.statementTB.setText(string2);
            this.appFrame.rightTabbedPanel.setSelectedIndex(2);
            this.appFrame.multiTSB.setSelected(true);
            this.appFrame.sizeSqlStatementPane();
            this.appFrame.execStatement();
        }
    }

    class SqlActions
    implements ActionListener {
        SQL_MODE mode;
        String name;

        public SqlActions(SQL_MODE sQL_MODE, String string) {
            this.mode = sQL_MODE;
            this.name = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = true;
            JFrame jFrame = CtreeACEExplorerApp.getApplication().getMainFrame();
            switch (this.mode) {
                case SERVER_CONNECT: {
                    SqlConnection sqlConnection = Globals.currentSqlConnection;
                    String string = SqlTree.this.currentNode.getName();
                    Object[] objectArray = SqlConnection.splitServerId(string);
                    CtreeServer ctreeServer = new CtreeServer((String)objectArray[0], ((Integer)objectArray[1]).intValue(), "ctreeSQL", Globals.currentSqlConnection.getLoggedUser(), Globals.currentSqlConnection.getPassword());
                    Globals.currentSqlConnection = new SqlConnection(ctreeServer, true, true);
                    Globals.sqlConnections.add(Globals.currentSqlConnection);
                    if (!Globals.currentSqlConnection.isConnected()) {
                        Globals.currentSqlConnection = sqlConnection;
                    } else {
                        SqlTree.this.addDatabases(SqlTree.this.currentNode);
                    }
                    SqlTree.this.updateStatusBar();
                    break;
                }
                case SERVER_DISCONNECT: {
                    ArrayList<SqlConnection> arrayList = new ArrayList<SqlConnection>();
                    for (SqlConnection sqlConnection : Globals.sqlConnections) {
                        String string = sqlConnection.getServerId();
                        if (!string.equals(((SqlTree)SqlTree.this).currentNode.name)) continue;
                        sqlConnection.disconnect();
                        arrayList.add(sqlConnection);
                    }
                    for (SqlConnection sqlConnection : arrayList) {
                        Globals.sqlConnections.remove((Object)sqlConnection);
                    }
                    ((SqlTree)SqlTree.this).currentNode.tree.clearNode(SqlTree.this.currentNode);
                    ((SqlTree)SqlTree.this).currentNode.tree.removeCurrentNode();
                    SqlTree.this.updateStatusBar();
                    break;
                }
                case DATABASE_ADD: {
                    DbTableDialog dbTableDialog = new DbTableDialog((Frame)jFrame, true);
                    dbTableDialog.setLocationRelativeTo(jFrame);
                    dbTableDialog.showDialog(this.mode, this.name);
                    SqlTree.this.refresh();
                    break;
                }
                case DATABASE_CREATE: {
                    DbTableDialog dbTableDialog = new DbTableDialog((Frame)jFrame, true);
                    dbTableDialog.setLocationRelativeTo(jFrame);
                    dbTableDialog.showDialog(this.mode, this.name);
                    SqlTree.this.refresh();
                    break;
                }
                case DATABASE_CLEAR: {
                    int n = JOptionPane.showOptionDialog(jFrame, "This action will delete all user tables, views and triggers \n from current database.\n\nDo you want to continue ?", "Clear Database", 0, 2, null, null, null);
                    if (n != 0) break;
                    Globals.ShowWaitCursor();
                    Globals.currentSqlConnection.clearDatabase();
                    Globals.ShowNormalCursor();
                    ((SqlTree)SqlTree.this).currentNode.tree.clearNode(SqlTree.this.currentNode);
                    SqlTree.this.currentNode.setUpdated(false);
                    SqlTree.this.refresh();
                    break;
                }
                case DATABASE_DISCONNECT: {
                    Globals.currentSqlConnection.disconnect();
                    Globals.sqlConnections.remove((Object)Globals.currentSqlConnection);
                    ((SqlTree)SqlTree.this).currentNode.tree.clearNode(SqlTree.this.currentNode);
                    SqlTree.this.currentNode.setUpdated(false);
                    break;
                }
                case USER_CREATE: {
                    CreateUserDialog createUserDialog = new CreateUserDialog((Frame)jFrame, true);
                    createUserDialog.setLocationRelativeTo(jFrame);
                    createUserDialog.showDialog(this.mode, ((SqlTree)SqlTree.this).currentNode.name);
                    break;
                }
                case USER_PRIVILEGES: {
                    CreateUserDialog createUserDialog = new CreateUserDialog((Frame)jFrame, true);
                    createUserDialog.setLocationRelativeTo(jFrame);
                    createUserDialog.showDialog(this.mode, ((SqlTree)SqlTree.this).currentNode.name);
                    break;
                }
                case TABLE_CLONE: {
                    CreateSqlTable createSqlTable = new CreateSqlTable((Frame)jFrame, true);
                    createSqlTable.setLocationRelativeTo(jFrame);
                    createSqlTable.showDialog(this.mode, ((SqlTree)SqlTree.this).currentNode.name);
                    MyTreeNode myTreeNode = (MyTreeNode)SqlTree.this.currentNode.getParent();
                    if (myTreeNode == null) break;
                    SqlTree.this.setSelectionPath(new TreePath(myTreeNode.getPath()));
                    SqlTree.this.refresh();
                    break;
                }
                case TABLE_CREATE: 
                case TABLE_PROPERTIES: {
                    CreateSqlTable createSqlTable = new CreateSqlTable((Frame)jFrame, true);
                    createSqlTable.setLocationRelativeTo(jFrame);
                    createSqlTable.showDialog(this.mode, ((SqlTree)SqlTree.this).currentNode.name);
                    SqlTree.this.refresh();
                    break;
                }
                case TABLE_DROP: {
                    if (this.name.isEmpty()) {
                        SqlTree.this.dropObject(TREE_OBJECT.TABLES, "", SqlTree.this.currentNode);
                    } else if (this.name.equals("_$Checked")) {
                        SqlTree.this.dropObject(TREE_OBJECT.TABLES, "", SqlTree.this.currentNode);
                    } else {
                        SqlTree.this.dropObject(TREE_OBJECT.TABLE, ((SqlTree)SqlTree.this).currentNode.name, SqlTree.this.currentNode);
                        MyTreeNode myTreeNode = (MyTreeNode)SqlTree.this.currentNode.getParent();
                        if (myTreeNode != null) {
                            SqlTree.this.setSelectionPath(new TreePath(myTreeNode.getPath()));
                        }
                    }
                    SqlTree.this.refresh();
                    break;
                }
                case TABLE_PERMISSIONS: 
                case VIEW_PERMISSIONS: {
                    PermissionsDialog permissionsDialog = new PermissionsDialog((Frame)jFrame, true);
                    permissionsDialog.setLocationRelativeTo(jFrame);
                    if (this.name.isEmpty()) {
                        permissionsDialog.showDialog(TREE_OBJECT.TABLES, "", SqlTree.this.currentNode);
                        break;
                    }
                    if (this.name.equals("_$Checked")) {
                        permissionsDialog.showDialog(TREE_OBJECT.TABLES, this.name, SqlTree.this.currentNode);
                        break;
                    }
                    permissionsDialog.showDialog(TREE_OBJECT.TABLE, this.name, SqlTree.this.currentNode);
                    break;
                }
                case TABLE_DUMP: {
                    DumpRows dumpRows = new DumpRows((Frame)jFrame, true);
                    dumpRows.setLocationRelativeTo(jFrame);
                    if (this.name.isEmpty()) {
                        dumpRows.showDialog(TREE_OBJECT.TABLES, "", SqlTree.this.currentNode);
                        break;
                    }
                    if (this.name.equals("_$Checked")) {
                        dumpRows.showDialog(TREE_OBJECT.TABLES, this.name, SqlTree.this.currentNode);
                        break;
                    }
                    dumpRows.showDialog(TREE_OBJECT.TABLE, this.name, SqlTree.this.currentNode);
                    break;
                }
                case TABLE_EXPORT: {
                    ExportSchema exportSchema = new ExportSchema((Frame)jFrame, true);
                    exportSchema.setLocationRelativeTo(jFrame);
                    if (this.name.isEmpty()) {
                        exportSchema.showDialog(TREE_OBJECT.TABLES, "", SqlTree.this.currentNode);
                        break;
                    }
                    if (this.name.equals("_$Checked")) {
                        exportSchema.showDialog(TREE_OBJECT.TABLES, this.name, SqlTree.this.currentNode);
                        break;
                    }
                    exportSchema.showDialog(TREE_OBJECT.TABLE, this.name, SqlTree.this.currentNode);
                    break;
                }
                case TABLE_CONSTRAINTS: {
                    Constraints constraints = new Constraints((Frame)jFrame, true);
                    constraints.setLocationRelativeTo(jFrame);
                    constraints.showDialog(((SqlTree)SqlTree.this).currentNode.name);
                    SqlTree.this.refresh();
                    break;
                }
                case TABLE_ALTER: {
                    AlterTable alterTable = new AlterTable((Frame)jFrame, true);
                    alterTable.setLocationRelativeTo(jFrame);
                    alterTable.showDialog(((SqlTree)SqlTree.this).currentNode.name);
                    SqlTree.this.refresh();
                    break;
                }
                case TABLE_RENAME: 
                case VIEW_RENAME: 
                case SYNONYM_RENAME: {
                    Rename rename = new Rename((Frame)jFrame, true);
                    rename.setLocationRelativeTo(jFrame);
                    rename.showDialog(((SqlTree)SqlTree.this).currentNode.name);
                    MyTreeNode myTreeNode = (MyTreeNode)SqlTree.this.currentNode.getParent();
                    if (myTreeNode == null) break;
                    if (myTreeNode != null) {
                        SqlTree.this.setSelectionPath(new TreePath(myTreeNode.getPath()));
                    }
                    SqlTree.this.refresh();
                    break;
                }
                case INDEX_CREATE: {
                    MyTreeNode myTreeNode = (MyTreeNode)SqlTree.this.currentNode.getParent();
                    if (myTreeNode != null && myTreeNode.getType() == TREE_OBJECT.TABLE) {
                        CreateIndex createIndex = new CreateIndex((Frame)jFrame, true);
                        createIndex.setLocationRelativeTo(jFrame);
                        createIndex.showDialog(myTreeNode.name);
                        SqlTree.this.refresh();
                        break;
                    }
                    CreateIndex createIndex = new CreateIndex((Frame)jFrame, true);
                    createIndex.setLocationRelativeTo(jFrame);
                    createIndex.showDialog("");
                    SqlTree.this.refresh();
                    break;
                }
                case INDEX_DROP: {
                    if (this.name.isEmpty()) {
                        SqlTree.this.dropObject(TREE_OBJECT.INDEX, "", SqlTree.this.currentNode);
                    } else if (this.name.equals("_$Checked")) {
                        SqlTree.this.dropObject(TREE_OBJECT.INDEXES, "", SqlTree.this.currentNode);
                        bl = false;
                    } else {
                        SqlTree.this.dropObject(TREE_OBJECT.INDEX, ((SqlTree)SqlTree.this).currentNode.name, SqlTree.this.currentNode);
                        MyTreeNode myTreeNode = (MyTreeNode)SqlTree.this.currentNode.getParent();
                        if (myTreeNode != null && bl) {
                            SqlTree.this.setSelectionPath(new TreePath(myTreeNode.getPath()));
                        }
                    }
                    SqlTree.this.refresh();
                    break;
                }
                case VIEW_CREATE: {
                    CreateView createView = new CreateView((Frame)jFrame, true);
                    createView.setLocationRelativeTo(jFrame);
                    createView.showDialog();
                    SqlTree.this.refresh();
                    break;
                }
                case VIEW_EXPORT: {
                    ExportSchema exportSchema = new ExportSchema((Frame)jFrame, true);
                    exportSchema.setLocationRelativeTo(jFrame);
                    if (this.name.isEmpty()) {
                        exportSchema.showDialog(TREE_OBJECT.VIEWS, "", SqlTree.this.currentNode);
                        break;
                    }
                    if (this.name.equals("_$Checked")) {
                        exportSchema.showDialog(TREE_OBJECT.VIEWS, this.name, SqlTree.this.currentNode);
                        break;
                    }
                    exportSchema.showDialog(TREE_OBJECT.VIEW, this.name, SqlTree.this.currentNode);
                    break;
                }
                case VIEW_DROP: {
                    if (this.name.isEmpty()) {
                        SqlTree.this.dropObject(TREE_OBJECT.VIEWS, "", SqlTree.this.currentNode);
                    } else if (this.name.equals("_$Checked")) {
                        SqlTree.this.dropObject(TREE_OBJECT.VIEWS, "", SqlTree.this.currentNode);
                    } else {
                        SqlTree.this.dropObject(TREE_OBJECT.VIEW, ((SqlTree)SqlTree.this).currentNode.name, SqlTree.this.currentNode);
                        MyTreeNode myTreeNode = (MyTreeNode)SqlTree.this.currentNode.getParent();
                        if (myTreeNode != null) {
                            SqlTree.this.setSelectionPath(new TreePath(myTreeNode.getPath()));
                        }
                    }
                    SqlTree.this.refresh();
                    break;
                }
                case VIEW_PROPERTIES: {
                    ViewProperties viewProperties = new ViewProperties((Frame)jFrame, true);
                    viewProperties.setLocationRelativeTo(jFrame);
                    viewProperties.showDialog(((SqlTree)SqlTree.this).currentNode.name);
                    break;
                }
                case VIEW_OPEN: {
                    SqlTree.this.openView(((SqlTree)SqlTree.this).currentNode.name);
                    break;
                }
                case PROC_CREATE: 
                case PROC_PROPERTIES: {
                    CreateProc createProc = new CreateProc((Frame)jFrame, true);
                    createProc.setLocationRelativeTo(jFrame);
                    createProc.showDialog(this.mode, ((SqlTree)SqlTree.this).currentNode.name);
                    SqlTree.this.refresh();
                    break;
                }
                case PROC_DROP: {
                    if (this.name.isEmpty()) {
                        SqlTree.this.dropObject(TREE_OBJECT.UPROCEDURES, "", SqlTree.this.currentNode);
                    } else if (this.name.equals("_$Checked")) {
                        SqlTree.this.dropObject(TREE_OBJECT.UPROCEDURES, "", SqlTree.this.currentNode);
                    } else {
                        SqlTree.this.dropObject(TREE_OBJECT.UPROCEDURE, ((SqlTree)SqlTree.this).currentNode.name, SqlTree.this.currentNode);
                        MyTreeNode myTreeNode = (MyTreeNode)SqlTree.this.currentNode.getParent();
                        if (myTreeNode != null) {
                            SqlTree.this.setSelectionPath(new TreePath(myTreeNode.getPath()));
                        }
                    }
                    SqlTree.this.refresh();
                    break;
                }
                case PROC_EXPORT: {
                    ExportSchema exportSchema = new ExportSchema((Frame)jFrame, true);
                    exportSchema.setLocationRelativeTo(jFrame);
                    if (this.name.isEmpty()) {
                        exportSchema.showDialog(TREE_OBJECT.UPROCEDURES, "", SqlTree.this.currentNode);
                        break;
                    }
                    if (this.name.equals("_$Checked")) {
                        exportSchema.showDialog(TREE_OBJECT.UPROCEDURES, this.name, SqlTree.this.currentNode);
                        break;
                    }
                    exportSchema.showDialog(TREE_OBJECT.UPROCEDURE, this.name, SqlTree.this.currentNode);
                    break;
                }
                case PROC_PERMISSIONS: 
                case UDF_PERMISSIONS: {
                    SpPermissionsDialog spPermissionsDialog = new SpPermissionsDialog((Frame)jFrame, true);
                    spPermissionsDialog.setLocationRelativeTo(jFrame);
                    if (this.name.isEmpty()) {
                        spPermissionsDialog.showDialog(TREE_OBJECT.UPROCEDURES, "", SqlTree.this.currentNode);
                        break;
                    }
                    if (this.name.equals("_$Checked")) {
                        spPermissionsDialog.showDialog(TREE_OBJECT.UPROCEDURES, this.name, SqlTree.this.currentNode);
                        break;
                    }
                    spPermissionsDialog.showDialog(TREE_OBJECT.UPROCEDURE, this.name, SqlTree.this.currentNode);
                    break;
                }
                case UDF_CREATE: 
                case UDF_PROPERTIES: {
                    CreateProc createProc = new CreateProc((Frame)jFrame, true);
                    createProc.setLocationRelativeTo(jFrame);
                    createProc.showDialog(this.mode, ((SqlTree)SqlTree.this).currentNode.name);
                    SqlTree.this.refresh();
                    break;
                }
                case UDF_DROP: {
                    if (this.name.isEmpty()) {
                        SqlTree.this.dropObject(TREE_OBJECT.UDFS, "", SqlTree.this.currentNode);
                    } else if (this.name.equals("_$Checked")) {
                        SqlTree.this.dropObject(TREE_OBJECT.UDFS, "", SqlTree.this.currentNode);
                    } else {
                        SqlTree.this.dropObject(TREE_OBJECT.UDF, ((SqlTree)SqlTree.this).currentNode.name, SqlTree.this.currentNode);
                        MyTreeNode myTreeNode = (MyTreeNode)SqlTree.this.currentNode.getParent();
                        if (myTreeNode != null) {
                            SqlTree.this.setSelectionPath(new TreePath(myTreeNode.getPath()));
                        }
                    }
                    SqlTree.this.refresh();
                    break;
                }
                case UDF_EXPORT: {
                    ExportSchema exportSchema = new ExportSchema((Frame)jFrame, true);
                    exportSchema.setLocationRelativeTo(jFrame);
                    if (this.name.isEmpty()) {
                        exportSchema.showDialog(TREE_OBJECT.UDFS, "", SqlTree.this.currentNode);
                        break;
                    }
                    if (this.name.equals("_$Checked")) {
                        exportSchema.showDialog(TREE_OBJECT.UDFS, this.name, SqlTree.this.currentNode);
                        break;
                    }
                    exportSchema.showDialog(TREE_OBJECT.UDF, this.name, SqlTree.this.currentNode);
                    break;
                }
                case SYNONYM_CREATE: {
                    CreateSynonym createSynonym = new CreateSynonym((Frame)jFrame, true);
                    createSynonym.setLocationRelativeTo(jFrame);
                    createSynonym.showDialog();
                    SqlTree.this.refresh();
                    break;
                }
                case SYNONYM_DROP: {
                    if (this.name.isEmpty()) {
                        SqlTree.this.dropObject(TREE_OBJECT.SYNONYMS, "", SqlTree.this.currentNode);
                    } else if (this.name.equals("_$Checked")) {
                        SqlTree.this.dropObject(TREE_OBJECT.SYNONYMS, "", SqlTree.this.currentNode);
                    } else {
                        SqlTree.this.dropObject(TREE_OBJECT.SYNONYM, ((SqlTree)SqlTree.this).currentNode.name, SqlTree.this.currentNode);
                        MyTreeNode myTreeNode = (MyTreeNode)SqlTree.this.currentNode.getParent();
                        if (myTreeNode != null) {
                            SqlTree.this.setSelectionPath(new TreePath(myTreeNode.getPath()));
                        }
                    }
                    SqlTree.this.refresh();
                    break;
                }
                case TRIGGER_CREATE: 
                case TRIGGER_PROPERTIES: {
                    CreateTrigger createTrigger = new CreateTrigger((Frame)jFrame, true);
                    createTrigger.setLocationRelativeTo(jFrame);
                    createTrigger.showDialog(this.mode, ((SqlTree)SqlTree.this).currentNode.name);
                    SqlTree.this.refresh();
                    break;
                }
                case TRIGGER_DROP: {
                    if (this.name.isEmpty()) {
                        SqlTree.this.dropObject(TREE_OBJECT.TRIGGERS, "", SqlTree.this.currentNode);
                    } else if (this.name.equals("_$Checked")) {
                        SqlTree.this.dropObject(TREE_OBJECT.TRIGGERS, "", SqlTree.this.currentNode);
                    } else {
                        SqlTree.this.dropObject(TREE_OBJECT.TRIGGER, ((SqlTree)SqlTree.this).currentNode.name, SqlTree.this.currentNode);
                        MyTreeNode myTreeNode = (MyTreeNode)SqlTree.this.currentNode.getParent();
                        if (myTreeNode != null) {
                            SqlTree.this.setSelectionPath(new TreePath(myTreeNode.getPath()));
                        }
                    }
                    SqlTree.this.refresh();
                    break;
                }
                case TRIGGER_EXPORT: {
                    ExportSchema exportSchema = new ExportSchema((Frame)jFrame, true);
                    exportSchema.setLocationRelativeTo(jFrame);
                    if (this.name.isEmpty()) {
                        exportSchema.showDialog(TREE_OBJECT.TRIGGERS, "", SqlTree.this.currentNode);
                        break;
                    }
                    if (this.name.equals("_$Checked")) {
                        exportSchema.showDialog(TREE_OBJECT.TRIGGERS, this.name, SqlTree.this.currentNode);
                        break;
                    }
                    exportSchema.showDialog(TREE_OBJECT.TRIGGER, this.name, SqlTree.this.currentNode);
                    break;
                }
                case STATEMENT_DROP: {
                    SqlTree.this.dropObject(TREE_OBJECT.STATEMENT, this.name, SqlTree.this.currentNode);
                    MyTreeNode myTreeNode = (MyTreeNode)SqlTree.this.currentNode.getParent();
                    if (myTreeNode == null) break;
                    SqlTree.this.setSelectionPath(new TreePath(myTreeNode.getPath()));
                    SqlTree.this.refresh();
                }
            }
        }
    }

    class RefreshAction
    implements ActionListener {
        RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SqlTree.this.refresh();
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            SqlTree sqlTree;
            TreePath treePath;
            Component component = mouseEvent.getComponent();
            if (component.getClass() == SqlTree.class && (treePath = (sqlTree = (SqlTree)component).getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
                int n = mouseEvent.getButton();
                if (n == 3) {
                    sqlTree.setSelectionPath(treePath);
                    sqlTree.scrollPathToVisible(treePath);
                    SqlTree.this.setupActions(sqlTree.getCurrentNode().getType());
                }
                if (mouseEvent.isPopupTrigger()) {
                    SqlTree.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }
}

