/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigParser
extends DefaultHandler {
    private String tempVal;
    ArrayList<Keyword> keywords;
    TreeElement currentElement;
    TreeElement rootElement;
    String fileName;
    HashSet<String> invalid_tag = null;
    HashSet<String> invalid_attr = null;
    HashSet<String> invalid_parent = null;

    public ConfigParser(String string, ArrayList<Keyword> arrayList) {
        this.fileName = string;
        this.keywords = arrayList;
        this.rootElement = this.currentElement = new TreeElement("Config file = " + string);
        this.currentElement.setType(KWTYPE.ROOT);
    }

    public TreeElement parseDocument(RTGConfigView rTGConfigView) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(this.fileName, (DefaultHandler)this);
            if (this.invalid_tag != null || this.invalid_attr != null || this.invalid_parent != null) {
                StringBuffer stringBuffer = new StringBuffer("Some elements has been removed from the file\n");
                if (this.invalid_tag != null) {
                    for (String string : this.invalid_tag) {
                        stringBuffer.append(string);
                    }
                }
                if (this.invalid_attr != null) {
                    for (String string : this.invalid_attr) {
                        stringBuffer.append(string);
                    }
                }
                if (this.invalid_parent != null) {
                    for (String string : this.invalid_parent) {
                        stringBuffer.append(string);
                    }
                }
                System.out.println(stringBuffer);
                int n = JOptionPane.showConfirmDialog(rTGConfigView, stringBuffer, "Config File Error", 2, 0);
                if (n == 2) {
                    this.currentElement = null;
                    this.rootElement = null;
                }
            }
            return this.rootElement;
        }
        catch (SAXException sAXException) {
            JOptionPane.showMessageDialog(rTGConfigView, sAXException.getMessage(), "Config File Error", 0);
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            JOptionPane.showMessageDialog(rTGConfigView, parserConfigurationException.getMessage(), "Config File Error", 0);
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(rTGConfigView, iOException.getMessage(), "Config File Error", 0);
            iOException.printStackTrace();
        }
        return null;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        Object object2;
        Object object3;
        assert (this.currentElement != null);
        TreeElement treeElement = null;
        Keyword keyword = null;
        for (Keyword keyword2 : this.keywords) {
            if (keyword2.Matches(string3) && (object3 = keyword2.getParentTypesAsList()) != null) {
                keyword = keyword2;
                object2 = ((ArrayList)object3).iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    assert (this.currentElement.getType() != null) : "null getType() " + string3 + " " + this.currentElement.getName();
                    assert (object != null);
                    if (this.currentElement.getType() != object && object != KWTYPE._ALL) continue;
                    treeElement = new TreeElement(keyword2);
                    treeElement.setParent(this.currentElement);
                    break;
                }
            }
            if (treeElement == null) continue;
            break;
        }
        if (treeElement == null) {
            if (keyword != null) {
                if (this.invalid_parent == null) {
                    this.invalid_parent = new HashSet();
                }
                this.invalid_parent.add("not permitted use of <" + string3 + "> in the scope of <" + this.currentElement.getName() + ">\n");
                treeElement = new TreeElement("fake for " + string3);
                treeElement.setParent(this.currentElement);
                treeElement.setType(keyword.getType());
                treeElement.setIsOption(keyword.isIsOption());
                treeElement.setIsAlsoOption(keyword.isHasValue());
                treeElement.setControlType(keyword.getControlType());
                this.currentElement = treeElement;
                return;
            }
            if (this.invalid_tag == null) {
                this.invalid_tag = new HashSet();
            }
            this.invalid_tag.add("<" + string3 + "> unknown\n");
            treeElement = new TreeElement("fake for " + string3);
            treeElement.setParent(this.currentElement);
            this.currentElement = treeElement;
            return;
        }
        if (this.currentElement == null) {
            this.rootElement = this.currentElement = treeElement;
        } else {
            this.currentElement.getChilds().add(treeElement);
        }
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            object3 = attributes.getLocalName(i);
            object2 = attributes.getValue(i);
            object = keyword.FindAttribute((String)object3);
            if (object != null) {
                if (((Attribute)object).getType() == OBJTYPE.BOOL) {
                    object2 = this.getNormalizedBoolean((String)object2);
                }
                Attribute attribute = new Attribute((Attribute)object, (String)object2);
                treeElement.getAttributes().add(attribute);
                continue;
            }
            if (this.invalid_attr == null) {
                this.invalid_attr = new HashSet();
            }
            this.invalid_attr.add("unknown attribute " + (String)object3 + " for <" + keyword.getName() + ">\n");
        }
        this.currentElement = treeElement;
    }

    private String getNormalizedBoolean(String string) {
        if (string.equals("yes") || string.equals("y") || string.equals("true") || string.equals("t") || string.equals("on") || string.equals("1")) {
            return "yes";
        }
        if (this.tempVal.equals("no") || string.equals("n") || string.equals("false") || string.equals("f") || string.equals("off") || string.equals("0")) {
            return "no";
        }
        return string;
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.tempVal = new String(cArray, n, n2).trim();
        if ((this.currentElement.isIsAlsoOption() || this.currentElement.isOption()) && this.currentElement.getControlType() == OBJTYPE.BOOL) {
            this.currentElement.setValue(this.getNormalizedBoolean(this.tempVal));
        } else if (!this.tempVal.isEmpty()) {
            this.currentElement.setValue(this.tempVal);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        assert (this.currentElement != null);
        assert (this.currentElement.getParent() != null) : "elem " + string3 + " " + this.currentElement.getName();
        if (this.currentElement.isOption() && this.currentElement.getControlType() == OBJTYPE.BOOL && this.currentElement.getValue() == null) {
            this.currentElement.setValue("yes");
        }
        if (this.currentElement.isIsAlsoOption() && this.currentElement.getControlType() == OBJTYPE.BOOL && this.currentElement.getValue() == null && this.currentElement.isLeaf()) {
            this.currentElement.setValue("yes");
        }
        if (this.currentElement.isIsAlsoOption() && !this.currentElement.isLeaf()) {
            this.currentElement.setValue(null);
            this.currentElement.setIsAlsoOption(false);
        }
        this.currentElement = this.currentElement.getParent();
    }
}

