/*
 * Decompiled with CFR 0.152.
 */
import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.Helper.Editors.FcComboBoxCellEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ElementsTable
extends FcBaseDynamicTable {
    private ElementsTableModel tableModel;
    private TreeElement element;
    private TreeElement baseNode;
    private boolean filling;

    public ElementsTable(boolean bl) {
        this.tableModel = new ElementsTableModel(this, bl);
        this.setModel((TableModel)((Object)this.tableModel));
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
    }

    public void setBaseNode(TreeElement treeElement) {
        this.baseNode = treeElement;
    }

    public void selectRow() {
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.getValueAt(i, 0);
            if (!string.equals(this.baseNode.getName())) continue;
            this.changeSelection(i, 0, false, false);
        }
    }

    public void setupColumns() {
        this.tableModel.setupColumns(null, null);
        this.fillTable(null, null);
    }

    public void fillTable(TreeElement treeElement, Keyword keyword) {
        this.element = treeElement;
        this.filling = true;
        this.tableModel.fillTable(treeElement, keyword);
        this.filling = false;
    }

    public void stopEdits() {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        ElementsTableModel elementsTableModel = this.getModel();
        FcBaseTableModel.RowData rowData = elementsTableModel.getRow(n);
        if (!this.isCellSelected(n, n2)) {
            Object object;
            if (n2 == 1) {
                component.setBackground(Color.white);
            }
            if (rowData.tag != null && (object = rowData.tag) instanceof ROWTYPE && n2 == 0) {
                if ((ROWTYPE)((Object)object) == ROWTYPE.ATTRIBUTE) {
                    component.setBackground(new Color(235, 255, 235));
                } else if ((ROWTYPE)((Object)object) == ROWTYPE.SPECIAL) {
                    component.setBackground(new Color(222, 255, 255));
                }
            }
        }
        return component;
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        if (n2 == 1) {
            Attribute attribute;
            OBJTYPE oBJTYPE;
            Object object = this.tableModel.getValueAt(n, 2);
            if (object instanceof OBJTYPE) {
                OBJTYPE oBJTYPE2 = (OBJTYPE)((Object)this.tableModel.getValueAt(n, 2));
                if (oBJTYPE2 == OBJTYPE.BOOL) {
                    return new FcComboBoxCellEditor(new String[]{"yes", "no"});
                }
            } else if (object instanceof Attribute && ((oBJTYPE = (attribute = (Attribute)object).getType()) == OBJTYPE.INT || oBJTYPE == OBJTYPE.STRING)) {
                String string2;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string2 : attribute.getValidValues()) {
                    arrayList.add(string2);
                }
                String[] stringArray = arrayList.toArray(new String[0]);
                string2 = new FcComboBoxCellEditor(stringArray);
                string2.setEditable(false);
                return string2;
            }
        }
        return super.getCellEditor(n, n2);
    }

    public ElementsTableModel getTableModel() {
        return this.tableModel;
    }

    public ElementsTableModel getModel() {
        return this.tableModel;
    }

    public JTableHeader getTableHeader() {
        return super.getTableHeader();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        int n = listSelectionModel.getMinSelectionIndex();
        if (this.previousRow == -1 && n == 0) {
            this.previousRow = 0;
        }
        int n2 = -1;
        if (n >= 0) {
            n2 = this.convertRowIndexToModel(n);
        }
        this.showHelp(n2);
        this.previousRow = n2;
        super.valueChanged(listSelectionEvent);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.tableModel != null) {
            super.tableChanged(tableModelEvent);
            if (this.filling || tableModelEvent.getType() != 0) {
                return;
            }
            if (this.getRowCount() > 0) {
                RTGConfigView rTGConfigView = RTGConfigView.theView;
                rTGConfigView.mustSave = true;
                rTGConfigView.saveBT.setEnabled(true);
                if (tableModelEvent.getType() == 0) {
                    this.saveRow(tableModelEvent.getFirstRow());
                }
            }
        }
    }

    private void showHelp(int n) {
        if (n >= 0) {
            String string = (String)this.getValueAt(n, 0);
            RTGConfigView rTGConfigView = RTGConfigView.theView;
            rTGConfigView.setTableHelp(string);
        }
    }

    private void saveRow(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            String string = (String)this.getValueAt(n, 0);
            String string2 = (String)this.getValueAt(n, 1);
            Object object = this.tableModel.getValueAt(n, 2);
            OBJTYPE oBJTYPE = OBJTYPE.STRING;
            if (object instanceof OBJTYPE) {
                oBJTYPE = (OBJTYPE)((Object)this.tableModel.getValueAt(n, 2));
            }
            FcBaseTableModel.RowData rowData = this.getTableModel().getRow(n);
            if (this.element != null) {
                Object object2;
                if (rowData.tag != null && (object2 = rowData.tag) instanceof ROWTYPE) {
                    if ((ROWTYPE)((Object)object2) == ROWTYPE.ATTRIBUTE) {
                        ArrayList<Attribute> arrayList = this.element.getAttributes();
                        boolean bl = false;
                        Object var10_12 = null;
                        for (Attribute attribute : arrayList) {
                            if (!attribute.getName().equals(string)) continue;
                            attribute.setValue(string2);
                            bl = true;
                            break;
                        }
                        if (!bl && string2 != null && !string2.isEmpty()) {
                            Attribute attribute;
                            Keyword keyword = this.element.getKey();
                            attribute = keyword.FindAttribute(string);
                            Attribute attribute2 = new Attribute(attribute, string2);
                            arrayList.add(attribute2);
                        } else if (var10_12 != null) {
                            arrayList.remove(var10_12);
                            this.setValueAt("", n, 1);
                        }
                    } else if ((ROWTYPE)((Object)object2) == ROWTYPE.OPTION) {
                        ArrayList<TreeElement> arrayList = this.element.getChilds();
                        boolean bl = false;
                        int n2 = 0;
                        for (TreeElement treeElement : arrayList) {
                            if (!treeElement.isOption()) continue;
                            ++n2;
                            if (!treeElement.getName().equals(string)) continue;
                            treeElement.setValue(string2);
                            bl = true;
                            break;
                        }
                        if (!bl && string2 != null && !string2.isEmpty()) {
                            TreeElement treeElement = new TreeElement(string);
                            treeElement.setValue(string2);
                            treeElement.setIsOption(true);
                            treeElement.setParent(this.element);
                            arrayList.add(n2, treeElement);
                        }
                    } else {
                        this.element.setValue(string2);
                    }
                }
                object2 = RTGConfigView.theView;
                ((RTGConfigView)object2).refreshTree();
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            Object var2_2 = null;
            Component component = mouseEvent.getComponent();
            if (component.getClass() == ElementsTable.class) {
                ElementsTable elementsTable = (ElementsTable)((Object)component);
                ElementsTableModel elementsTableModel = elementsTable.getModel();
                int n = elementsTable.columnAtPoint(mouseEvent.getPoint());
                int n2 = elementsTable.rowAtPoint(mouseEvent.getPoint());
                if (n2 == -1) {
                    elementsTableModel.fireTableDataChanged();
                }
                if (mouseEvent.isPopupTrigger()) {
                    TableCellEditor tableCellEditor = elementsTable.getCellEditor();
                    if (tableCellEditor != null) {
                        tableCellEditor.stopCellEditing();
                    }
                    ElementsTable.this.changeSelection(n2, n, false, false);
                }
            }
        }
    }

    public class ElementsTableModel
    extends FcBaseTableModel {
        ElementsTableModel(ElementsTable elementsTable2, boolean bl) {
            super((FcBaseDynamicTable)elementsTable2, bl);
            this.table = elementsTable2;
        }

        public boolean rowChanged(int n) {
            if (!this.hasDirtyColumns || ElementsTable.this.tableModel.getRowCount() == 0) {
                return true;
            }
            this.hasDirtyColumns = false;
            Integer n2 = 0;
            while (n2 < this.numberOfColumns) {
                this.dirtyColumns.set(n2, false);
                Integer n3 = n2;
                Integer n4 = n2 = Integer.valueOf(n2 + 1);
            }
            return true;
        }

        private void setupColumns(TreeElement treeElement, Keyword keyword) {
            String[] stringArray = new String[]{"Name", "Value", "Type"};
            this.clearTable();
            this.addColumns(stringArray);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(200);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(200);
            this.autoSizeColumns.set(0, true);
            this.autoSizeColumns.set(1, true);
            this.readOnlyColumns.set(0, true);
            this.readOnlyColumns.set(2, true);
            this.hiddenColumns.set(2, true);
            super.fireTableStructureChanged();
            this.columnsMinWidth.set(0, 200);
        }

        private void fillTable(TreeElement treeElement, Keyword keyword) {
            this.clearTable();
            if (treeElement == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
                this.addRow(rowData);
            } else {
                FcBaseTableModel.RowData rowData;
                ArrayList<Object> arrayList;
                Object object;
                Object object22;
                Object object3;
                ArrayList<Object> arrayList2;
                if (treeElement.isIsAlsoOption() || treeElement.isOption()) {
                    arrayList2 = new ArrayList<String>();
                    arrayList2.add(treeElement.getName());
                    arrayList2.add(treeElement.getValue());
                    arrayList2.add((Object)treeElement.getControlType());
                    object3 = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList2);
                    ((FcBaseTableModel.RowData)object3).tag = ROWTYPE.SPECIAL;
                    this.addRow((FcBaseTableModel.RowData)object3);
                }
                arrayList2 = treeElement.getAttributes();
                for (Object object22 : arrayList2) {
                    object = ((Attribute)object22).getName();
                    arrayList = new ArrayList<Object>();
                    arrayList.add(((Attribute)object22).getName());
                    arrayList.add(((Attribute)object22).getValue());
                    if (((Attribute)object22).getValidValues() != null) {
                        arrayList.add(object22);
                    } else {
                        arrayList.add((Object)((Attribute)object22).getType());
                    }
                    rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
                    rowData.tag = ROWTYPE.ATTRIBUTE;
                    this.addRow(rowData);
                }
                object3 = treeElement.getChilds();
                object22 = ((ArrayList)object3).iterator();
                while (object22.hasNext()) {
                    object = (TreeElement)object22.next();
                    if (((TreeElement)object).isAttribute() || !((TreeElement)object).isOption()) continue;
                    arrayList = new ArrayList();
                    arrayList.add(((TreeElement)object).getName());
                    arrayList.add(((TreeElement)object).getValue());
                    arrayList.add((Object)((TreeElement)object).getControlType());
                    rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
                    rowData.tag = ROWTYPE.OPTION;
                    this.addRow(rowData);
                }
            }
            super.fireTableDataChanged();
            this.rowChanged(0);
        }
    }

    public static enum ROWTYPE {
        ATTRIBUTE,
        OPTION,
        SPECIAL;


        public static ROWTYPE fromInt(int n) {
            return ROWTYPE.values()[n];
        }
    }
}

