/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="keyword")
@XmlType(propOrder={"name", "aliases", "description", "type", "parentTypes", "controlType", "hasValue", "attributes", "validValues"})
public class Keyword
implements Comparator<Keyword>,
Comparable<Keyword> {
    private String name = "";
    private String description = "";
    private KWTYPE type;
    private KWTYPE[] parentTypes;
    private OBJTYPE controlType = OBJTYPE.STRING;
    private ArrayList<Attribute> attributes;
    private boolean hasValue;
    @XmlElementWrapper(name="aliases")
    @XmlElement(name="alias")
    private HashSet<String> aliases;
    @XmlElementWrapper(name="validvalues")
    @XmlElement(name="value")
    private ArrayList<String> validValues;

    public Keyword() {
        this.aliases = null;
        this.validValues = null;
    }

    public Keyword(String string, KWTYPE kWTYPE, OBJTYPE oBJTYPE, boolean bl) {
        this.name = string;
        this.description = "";
        this.type = kWTYPE;
        this.controlType = oBJTYPE;
        this.hasValue = bl;
        this.aliases = null;
        this.validValues = null;
    }

    public String getName() {
        return this.name;
    }

    public boolean Matches(String string) {
        return string.equals(this.name) || this.aliases != null && this.aliases.contains(string);
    }

    public void AddAttribute(Attribute attribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(attribute);
    }

    @XmlElement
    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    @XmlElement
    public void setDescription(String string) {
        this.description = string;
    }

    public KWTYPE getType() {
        return this.type;
    }

    @XmlElement
    public void setType(KWTYPE kWTYPE) {
        this.type = kWTYPE;
    }

    public KWTYPE[] getParentTypes() {
        return this.parentTypes;
    }

    public ArrayList<KWTYPE> getParentTypesAsList() {
        if (this.parentTypes != null) {
            return new ArrayList<KWTYPE>(Arrays.asList(this.parentTypes));
        }
        return null;
    }

    @XmlElement(name="parentType")
    @XmlElementWrapper(name="parentTypes")
    public void setParentTypes(KWTYPE[] kWTYPEArray) {
        this.parentTypes = kWTYPEArray;
    }

    public OBJTYPE getControlType() {
        return this.controlType;
    }

    @XmlElement
    public void setControlType(OBJTYPE oBJTYPE) {
        this.controlType = oBJTYPE;
    }

    public ArrayList<Attribute> getAttributes() {
        return this.attributes;
    }

    public Attribute FindAttribute(String string) {
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                if (!attribute.Matches(string)) continue;
                return attribute;
            }
        }
        return null;
    }

    @XmlElement(name="attribute")
    @XmlElementWrapper(name="attributes")
    public void setAttributes(ArrayList<Attribute> arrayList) {
        this.attributes = arrayList;
    }

    public boolean isIsOption() {
        return this.type == KWTYPE.OPTION;
    }

    public boolean isHasValue() {
        return this.hasValue;
    }

    public void setHasValue(boolean bl) {
        this.hasValue = bl;
    }

    public void setAlias(HashSet<String> hashSet) {
        this.aliases = hashSet;
    }

    public void addAlias(String string) {
        if (this.aliases == null) {
            this.aliases = new HashSet();
        }
        this.aliases.add(string);
    }

    @XmlTransient
    public ArrayList<String> getValidValues() {
        return this.validValues;
    }

    public void addValidValue(String string) {
        if (this.validValues == null) {
            this.validValues = new ArrayList();
        }
        this.validValues.add(string);
    }

    public void addValidValues(String[] stringArray) {
        if (this.validValues == null) {
            this.validValues = new ArrayList();
        }
        this.validValues.addAll(Arrays.asList(stringArray));
    }

    @Override
    public int compare(Keyword keyword, Keyword keyword2) {
        return keyword.name.compareTo(keyword2.name);
    }

    @Override
    public int compareTo(Keyword keyword) {
        return this.name.compareTo(keyword.name);
    }

    void SortAttributes() {
        if (this.attributes != null) {
            Collections.sort(this.attributes);
        }
    }
}

