/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class Keywords {
    @XmlElement(name="keyword")
    private ArrayList<Keyword> keywords;
    private ArrayList<ArgumentDescs> argumentDescs;

    public void save(String string) {
        this.fill();
        this.SortAndFillComplemetary();
        try {
            File file = new File(string);
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{Keywords.class});
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)this, file);
        }
        catch (JAXBException jAXBException) {
            Logger.getLogger(RTGConfigView.class.getName()).log(Level.SEVERE, null, jAXBException);
        }
    }

    public static Keywords load(String string) {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{Keywords.class});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            Keywords keywords = (Keywords)unmarshaller.unmarshal((Reader)new FileReader(string));
            keywords.SortAndFillComplemetary();
            return keywords;
        }
        catch (JAXBException jAXBException) {
            Logger.getLogger(RTGConfigView.class.getName()).log(Level.SEVERE, null, jAXBException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(Keywords.class.getName()).log(Level.SEVERE, null, fileNotFoundException);
        }
        return new Keywords();
    }

    private void fill() {
        ArrayList<Keyword> arrayList = new ArrayList<Keyword>();
        Keyword keyword = new Keyword("config", KWTYPE.CONFIG, OBJTYPE.STRING, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.ROOT});
        keyword.setDescription("<config> is the root element of the XML configuration file. It does not have any attributes and it's used only as a container of all other configuration elements.");
        arrayList.add(keyword);
        keyword = new Keyword("instance", KWTYPE.INSTANCE, OBJTYPE.STRING, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG});
        keyword.setDescription("The instance element specifies instance-wide configurations for the client/server driver. Each instance represents a connection to the c-treeACE server.");
        keyword.AddAttribute(new Attribute("name", "Instance generic identifier."));
        keyword.AddAttribute(new Attribute("server", "Specifies the server name and the host name of the c-treeACE to connect to. The format can be one of the following syntaxes:\nservername\nservername@hostname\nservername@IPaddress\nIf the host name or the IP address is omitted, host name defaults to localhost."));
        keyword.AddAttribute(new Attribute("user", "Specifies the c-treeACE user name."));
        keyword.AddAttribute(new Attribute("password", "Specifies the c-treeACE user password."));
        keyword.AddAttribute(new Attribute("connect", OBJTYPE.BOOL, "Indicates whether to connect to c-treeACE at runtime initialization or wait for the first OPEN operation.\nIt accepts the following values:\n\"yes\" : Indicates to connect at runtime initialization.\n\"no\" : Indicates to connect during the first OPEN operation. This is the default value."));
        keyword.AddAttribute(new Attribute("versioncheck", OBJTYPE.BOOL, "Indicates whether to check that c-treeACE RTG version matches the c-treeACE version. This option is turned off by default.\nIt accepts the following values:\n\"yes\" : Turn on version matching check. Versions must match otherwise an error is returned at runtime initialization.\n\"no\" : Turn off version matching check. This is the default value."));
        arrayList.add(keyword);
        keyword = new Keyword("localinstance", KWTYPE.INSTANCE, OBJTYPE.STRING, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG});
        keyword.setDescription("The localinstance element specifies instance-wide configurations for the standalone driver.");
        keyword.AddAttribute(new Attribute("name", "Instance generic identifier."));
        keyword.AddAttribute(new Attribute("bufs", "Specifies the number of index file cache buffers. Minimum of 3 required."));
        keyword.AddAttribute(new Attribute("fils", "Specifies the initial block of file structures to allocate. Whenever the number of files required exceeds this initial amount, another block of file structures using this number is automatically allocated. Each index, whether it is a member of an index file or in a file by itself counts toward this parameter."));
        keyword.AddAttribute(new Attribute("sect", "Specifies the number of node sectors. Minimum of 1 required. This parameter multiplied by 128 equals the index node size."));
        keyword.AddAttribute(new Attribute("dbufs", "Specifies the number of data file cache buffers. Minimum of 3 required."));
        keyword.AddAttribute(new Attribute("logpath", "Specifies the file path for the transaction processing and temporary files."));
        arrayList.add(keyword);
        keyword = new Keyword("redirinstance", KWTYPE.INSTANCE, OBJTYPE.STRING, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG});
        keyword.setDescription("The redirinstance element allows you to specify instance-wide configuration options for files that should be handled by an external file system instead of the c-treeACE for COBOL file system. It accepts two attributes: lib and func, which specify the library and function to be used as an external file system.\n\nThis element is used if you have an older COBOL compiler that supports EXTFH for only a single external file system, and you need to use multiple file systems. For example, if you are already using an EXTFH for certain files, you can use the redirinstance element to redirect those file to that file system.");
        keyword.AddAttribute(new Attribute("name", "Instance generic identifier."));
        keyword.AddAttribute(new Attribute("lib", "Specify the file name of the library (e.g., DLL) to be called. Use the complete path with no extension."));
        keyword.AddAttribute(new Attribute("func", "Specify the name of the function to be called."));
        arrayList.add(keyword);
        keyword = new Keyword("file", KWTYPE.FILE, OBJTYPE.STRING, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE});
        keyword.setDescription("The file element specifies file-wide configurations. It is used to delimit options to a specific file identified by the name attribute or to all the files contained in a directory identified by the dir attribute.\n\nThe name and dir setting may contain the * wildcard to match multiple files with a single <file> section. The file matching rules that apply when the wildcard * is used are described in \"Wildcard file matching rules.\"");
        keyword.AddAttribute(new Attribute("name", "Specifies the string to match the file name portion of the file path passed by the COBOL application."));
        keyword.AddAttribute(new Attribute("dir", "Specifies the string to match the directory portion of the file path passed by the COBOL application. If attribute name is also specified, the options applies to the files that match both the directory and the name."));
        keyword.AddAttribute(new Attribute("priority", OBJTYPE.INT, "Specify the priority of this entry. Accepted values range from -32767 to +32767. It defaults to 0"));
        keyword.AddAttribute(new Attribute("casesensitive", OBJTYPE.BOOL, "Specifies if the file name and/or file dir attributes should be matched against the file path considering case sensitivity."));
        Attribute attribute = new Attribute("type", OBJTYPE.STRING, "Speficies the file type to match. Accepted values are \"I\"ndexed, \"S\"equential, \"L\"ine sequential, \"R\"elative, \"*\" any type.");
        attribute.addValidValues(new String[]{"I", "R", "L", "S", "*"});
        keyword.AddAttribute(attribute);
        arrayList.add(keyword);
        keyword = new Keyword("keycompress", KWTYPE.KEYCOMPRESS, OBJTYPE.BOOL, true);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The keycompress option indicates whether to create files with key compression enabled. This feature is turned off by default. It may impact performance but reduces disk space usage.");
        arrayList.add(keyword);
        keyword = new Keyword("log", KWTYPE.LOG, OBJTYPE.BOOL, true);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The log option indicates whether to log events such as errors that occur in c-tree RTG. This feature might be helpful for diagnostics purposes.");
        keyword.AddAttribute(new Attribute("file", "Specifies the log file name. If omitted the log messages are redirected to the standard error stream (stderr)."));
        arrayList.add(keyword);
        keyword = new Keyword("debug", KWTYPE.DEBUG, OBJTYPE.BOOL, true);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.LOG});
        keyword.setDescription("The debug log option instructs the c-treeACE for COBOL to insert debug information in the log file.");
        arrayList.add(keyword);
        keyword = new Keyword("error", KWTYPE.ERROR, OBJTYPE.BOOL, true);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.LOG});
        keyword.setDescription("The error log option instructs the c-treeACE for COBOL to log file error events.");
        arrayList.add(keyword);
        keyword = new Keyword("map", KWTYPE.MAP, OBJTYPE.STRING, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The map option replaces the file name or directory passed by the COBOL application with the specified values.");
        arrayList.add(keyword);
        keyword = new Keyword("atend", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.ERROR});
        keyword.setDescription("This value turns on COBOL end of file error logging. This option is enabled by default.");
        arrayList.add(keyword);
        keyword = new Keyword("automkdir", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The automkdir option indicates whether to automatically create missing directories when creating new files. If this option is set to yes, any missing directory of the file path is automatically created. If this option is set to no, an error is returned if the file path does not exist. This option is disabled by default.");
        arrayList.add(keyword);
        keyword = new Keyword("batchaddition", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The batchaddition option enables batch record writes to improve performance of consecutive record additions.\nThe batchaddition option is available only for files opened with OUTPUT or EXTEND mode. The number of records to cache is defined by the records attribute. The batchaddition option is disabled by default");
        keyword.AddAttribute(new Attribute("records", OBJTYPE.INT, "Indicates the number of records to cache. This value is set to 100 by default."));
        arrayList.add(keyword);
        keyword = new Keyword("batchaddition", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.DEBUG});
        keyword.setDescription("This value turns on batch addition debug information logging. This option is disabled by default.");
        arrayList.add(keyword);
        keyword = new Keyword("bulkaddition", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The bulkaddition option enables deferred key writes to improve performance of consecutive record additions.");
        arrayList.add(keyword);
        keyword = new Keyword("config", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.DEBUG});
        keyword.setDescription("This value turns on configuration file debug logging. This option is disabled by default. This element also accepts an attribute named \"full\" that enables full configuration file debug logs. See the examples below to see how to use this attribute.");
        keyword.AddAttribute(new Attribute("full", OBJTYPE.BOOL, "dump, for debuggin purposes, the config file with all option. This result in a config file exposing all setting that cannot be used."));
        arrayList.add(keyword);
        keyword = new Keyword("switcher", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.DEBUG});
        keyword.setDescription("This value turns on redirinstance debug logging. This option is disabled by default.");
        arrayList.add(keyword);
        keyword = new Keyword("transaction", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.DEBUG});
        keyword.setDescription("This option logs all calls to TRANBEG, TRANEND, TRANABTX, and PUTHDR with parameter ctIICTbegin, ctIICTcommit, and ctIICTabort. ");
        arrayList.add(keyword);
        keyword = new Keyword("generic", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.DEBUG});
        keyword.setDescription("This option disables generic debug log messages which are enabled by default when <log><debug> is not specifically set to no. ");
        arrayList.add(keyword);
        keyword = new Keyword("ctfixed", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The ctfixed option indicates whether to create fixed record length files with c-tree file mode ctFIXED. If this option is set to yes, files with fixed record length are created with c-tree file mode ctFIXED. If this option is set to no, all files are created with c-tree file mode ctVLENGTH. This option is disabled by default.");
        arrayList.add(keyword);
        keyword = new Keyword("datacompress", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The datacompress option indicates whether to create files with data compression enabled. When data compression is enabled, data records are compressed using the compression algorithm specified by the type attribute. Data compression reduces disk space utilization but it may also impact performance. This feature is turned off by default.");
        attribute = new Attribute("type", "Selects the type of compression.\nValues:\n\"rle\" : Use a simple RLE compression algorithm.\n\"zlib\" : Use the zlib compression algorithm.\nThe default value is \"rle\".");
        attribute.addValidValues(new String[]{"rle", "zlib"});
        keyword.AddAttribute(attribute);
        attribute = new Attribute("strategy", OBJTYPE.INT, "Selects the compression strategy.\nDepending on the compression type the possible values for strategy are:\nValid values for type \"rle\":\n\"0\" : Use the default simple RLE compression strategy. \nValid values for type \"zlib\":\n\"0\" : Use the default zlib compression strategy. \n\"1\" : Use the zlib filtered compression strategy.\n\"2\" : Use zlib Huffman only compression strategy.\n\"3\" : Use zlib RLE compression strategy. This is the default value.\n\"4\" : Use zlib fixed compression strategy.\nThe default value is \"0\".");
        attribute.addValidValues(new String[]{"0", "1", "2", "3", "4"});
        keyword.AddAttribute(attribute);
        attribute = new Attribute("level", OBJTYPE.INT, "Selects the compression level.\nValid values are 0 and the range between 1 and 9:\n\"0\" : Use the compression algorithm default level.\n\"1\" : Provides best speed but uses more disk space\n\"9\" : Provides best compression at the expense of performance.\nThe default value is \"0\".");
        attribute.addValidValues(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"});
        keyword.AddAttribute(attribute);
        arrayList.add(keyword);
        keyword = new Keyword("datafilesuffix", KWTYPE.OPTION, OBJTYPE.STRING, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The datafilesuffix option defines the string to append to data file names. It can be used to define the default data file extension.\n\nIf not specified the default data file extension is .dat.");
        arrayList.add(keyword);
        keyword = new Keyword("detectlock", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The detectlock option defaults to \"no\" which means that no error is returned when trying to retrieve a record locked by another user if the LOCK MODE is MANUAL and the READ operation does not have an explicit WITH LOCK option.");
        arrayList.add(keyword);
        keyword = new Keyword("dir", KWTYPE.OPTION, OBJTYPE.STRING, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.MAP});
        keyword.setDescription("The dir option specifies the string that replaces the directory portion of the file path passed by the COBOL application. It supports %n and %d substitution specifiers. For more information about substitution specifiers, please refer to \"Substitution specifiers.\"");
        arrayList.add(keyword);
        keyword = new Keyword("duplicate", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.ERROR});
        keyword.setDescription("This value turns on option to enable/suppress the log of duplicate key errors.");
        arrayList.add(keyword);
        keyword = new Keyword("encrypt", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.addAlias("encryption");
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The encrypt option indicates whether to create files with data encryption support enabled. When encryption is enabled, files are encrypted using encryption algorithm specified by the \"type\" attribute.");
        attribute = new Attribute("type", "Type of encryption.\nIf type is \"blowfish\" a key length must be specified.\nKey range must be from 8 up to 56 i.e. blowfish32");
        attribute.addValidValues(new String[]{"aes16", "aes24", "aes32", "camo", "des8", "des16", "des24", "twofish16", "twofish24", "twofish32"});
        for (int i = 8; i < 57; ++i) {
            attribute.addValidValue("blowfish" + i);
        }
        keyword.AddAttribute(attribute);
        arrayList.add(keyword);
        keyword = new Keyword("file", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.DEBUG});
        keyword.setDescription("This value turns on option to log file open/create events.");
        arrayList.add(keyword);
        keyword = new Keyword("leading", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.KEYCOMPRESS});
        keyword.setDescription("The keycompress leading option indicates to compress the leading characters of key values. It is indicated when there is significant leading character duplication among the key values.");
        arrayList.add(keyword);
        keyword = new Keyword("hugefile", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("This configuration keyword allows the huge file mode to be turned off so that non-huge files are created. The default is to use c-tree RTG support for huge files, which accommodate up to 16 exabytes of data when segmented files are used. Non-huge files accommodate up to 2 or 4 gigabytes of data depending on the operating system.");
        arrayList.add(keyword);
        keyword = new Keyword("ignorelock", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The ignorelock option specifies whether READ operations should ignore locks. This option is turned off by default.");
        arrayList.add(keyword);
        keyword = new Keyword("indexfilesuffix", KWTYPE.OPTION, OBJTYPE.STRING, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The indexfilesuffix option defines the string to append to index file names. It can be used to define the default index file extension. \n\nIf not specified the default data file extension is .idx. ");
        arrayList.add(keyword);
        keyword = new Keyword("keycheck", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The keycheck option specifies whether to check that all the keys belonging to an indexed file are defined in the COBOL program. If this option is set to yes, the keys must match the key definitions otherwise an error is returned. If this option is set to no, files that contain more keys than described in the COBOL program are allowed. Files that contain fewer keys than the key definitions are never allowed regardless of the keycheck setting. This feature is enabled by default.");
        arrayList.add(keyword);
        keyword = new Keyword("locktype", KWTYPE.OPTION, OBJTYPE.INT, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The locktype option allows changing the default record locking behavior of the COBOL system in use.");
        keyword.addValidValue("0");
        keyword.addValidValue("1");
        arrayList.add(keyword);
        keyword = new Keyword("maxlencheck", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The maxlencheck option specifies whether to check that the record being read from disk fits entirely into the record buffer for which length is equal to the maxlen file definition. If this option is set to yes, an error is returned if the record read from disk is larger than maxlen bytes. If this option is set to no, the record is truncated at maxlen bytes before it is returned to COBOL. This option is enabled by default.");
        arrayList.add(keyword);
        keyword = new Keyword("memoryfile", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The memoryfile option indicates whether to create files in memory rather than on disk. This feature is indicated for temporary files. This feature is turned off by default.");
        arrayList.add(keyword);
        keyword = new Keyword("name", KWTYPE.OPTION, OBJTYPE.STRING, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.MAP});
        keyword.setDescription("The name option specifies the string that replaces the file name portion of the file path passed by the COBOL application. It supports %n and %d substitution specifiers. For more information about substitution specifiers, please refer to \"Substitution specifiers.\"");
        arrayList.add(keyword);
        keyword = new Keyword("notfound", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.ERROR});
        keyword.setDescription("This value turns on COBOL record not found error logging. This option is enabled by default.");
        arrayList.add(keyword);
        keyword = new Keyword("optimisticadd", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("When optimisticadd is enabled (default), c-tree uses an optimistic strategy which provides optimal performance when adding non-existing records.\nWhen optimisticadd is disabled, c-tree uses a pessimistic strategy that attempts to add unique keys before adding the data record.");
        arrayList.add(keyword);
        keyword = new Keyword("padding", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.KEYCOMPRESS});
        keyword.setDescription("The keycompress padding option indicates to compress the padding characters of key values. It is indicated when key lengths vary in size and are padded with spaces.");
        arrayList.add(keyword);
        keyword = new Keyword("prefetch", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The prefetch option enables batch record retrieval to improve performance of consecutive sequential reads.");
        keyword.AddAttribute(new Attribute("records", OBJTYPE.INT, "Indicates the number of records to prefetch. This value is set to 100 by default."));
        keyword.AddAttribute(new Attribute("allowwriters", OBJTYPE.BOOL, "When a set of records is prefetched, the prefetched records are locked with a shared lock to prevent other users from updating them. When this attribute is enabled, the shared lock is not used so that other users can update the prefetched records.\n\nThis attribute is disabled by default (prefetch allowwriters=\"no\")."));
        arrayList.add(keyword);
        keyword = new Keyword("prefetch", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.DEBUG});
        keyword.setDescription("This value turns on prefetch debug information logging. This option is disabled by default.");
        arrayList.add(keyword);
        keyword = new Keyword("profile", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.LOG});
        keyword.setDescription("The profile option indicates to log performance profiling information in the specified log file.");
        arrayList.add(keyword);
        keyword = new Keyword("retrylock", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The retrylock option indicates whether a READ operation that fails because a record is locked should wait until the lock is released rather than returning an immediate lock error. When this option is enabled, records are locked with the c-tree lock mode of ctENABLE_BLK instead of ctENABLE.");
        arrayList.add(keyword);
        keyword = new Keyword("locktimeout", KWTYPE.OPTION, OBJTYPE.INT, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("Sets the blocking lock timeout. For example: <locktimeout>15</locktimeout> sets the timeout for blocking locks to 15 seconds.\n\n    If <retrylock> is enabled and <locktimeout> is set to a value greater than 0, an operation attempting to acquire a lock on a locked record returns after <locktimeout> seconds with a locked error.\n    If <retrylock> is enabled and <locktimeout> is set to 0 (default), an operation attempting to acquire a lock on a locked record waits until the record becomes available.");
        arrayList.add(keyword);
        keyword = new Keyword("rpc", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The rpc option indicates whether to use standard c-tree client/server calls or c-tree RTG RPC calls. Using RPC calls results in better performance due to an optimized communication protocol that reduces network traffic. This feature is turned on by default.");
        keyword.AddAttribute(new Attribute("crc", OBJTYPE.BOOL, "Indicates whether to enable CRC checks on the RPC data buffers that are sent/received over the network. It is recommended only for diagnostic purposes to detect faulty networks.\nValues:\n\"yes\" : Turns on CRC checks.\n\"no\" : Turns off CRC checks."));
        arrayList.add(keyword);
        keyword = new Keyword("skiplock", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The skiplock option advances the current record pointer when a locked record is encountered. This feature is off by default.");
        arrayList.add(keyword);
        keyword = new Keyword("smartcopy", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The smartcopy option enables the use of batched read/write techniques to improve performance of file copy operations. If this option is set to yes, the file copy reads and writes records in blocks in order to reduce the number of read and write operations. If this option is set to no, the records are copied one by one. This option is enabled by default.");
        keyword.AddAttribute(new Attribute("rpc", OBJTYPE.BOOL, "Uses an RPC function to copy records from one file to another directly within the server process."));
        keyword.AddAttribute(new Attribute("raw", OBJTYPE.BOOL, "Uses physical batches instead of standard functions. This enhancement is available only if the <smartcopy rpc> attribute is set to yes; it is not enabled by default."));
        arrayList.add(keyword);
        keyword = new Keyword("sqlize", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The sqlize option indicates whether to attempt linking the table to c-treeACE SQL. If this option is set to yes, the necessary operations to make the file accessible from c-treeACE SQL are performed when the file is open with OUTPUT or EXTEND mode. This option is disabled by default. ");
        keyword.AddAttribute(new Attribute("xfd", "Path to XFD data definition file.\nIf a directory is specified, a file with same name but \".xfd\" or \".xdd\" extension is searched.\nValue may contain %n and %d substitution specifiers.Values:\n\"yes\" : Turns on CRC checks.\n\"no\" : Turns off CRC checks."));
        keyword.AddAttribute(new Attribute("database", "Database name to add the file to.\nThe default value is \"ctreeSQL\"."));
        keyword.AddAttribute(new Attribute("password", "c-treeACE ADMIN password.\nThe default value is \"ADMIN\"."));
        keyword.AddAttribute(new Attribute("symbolic", "Optional table name to use when adding file to a database."));
        keyword.AddAttribute(new Attribute("prefix", "Optional prefix for table or symbolic name."));
        keyword.AddAttribute(new Attribute("owner", "Optional user name to assign table ownership."));
        keyword.AddAttribute(new Attribute("public", OBJTYPE.BOOL, "Optionally grant public access permissions. Values:\n\"yes\" : Grant public permissions.\n\"no\" : Do not grant public permissions."));
        attribute = new Attribute("convention", "Numeric format digit ID.\nValues:\n\"A\" : Set numeric format to ACUCOBOL type.\n\"D\" : Set numeric format to Data General type.\n\"I\" : Set numeric format to IBM type.\n\"M\" : Set numeric format to Micro Focus type.\nThe default value is \"M\" for EXTFH drivers or \"A\" for ACUCOBOL-GT drivers.");
        attribute.addAlias("conv");
        attribute.addAlias("numformat");
        attribute.addValidValues(new String[]{"A", "D", "I", "M"});
        keyword.AddAttribute(new Attribute("rules", ""));
        keyword.AddAttribute(attribute);
        arrayList.add(keyword);
        keyword = new Keyword("transaction", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The transaction option indicates whether to create files with transaction support enabled. This feature is turned on by default.");
        keyword.AddAttribute(new Attribute("logging", OBJTYPE.BOOL, "Enable/disable transaction logging.\nValues:\n\"yes\" : Turns on transaction logging. It is indicated when data safety is more important than performance. Files are created with c-tree file mode ctTRNLOG and are automatically recovered after a crash.\n\"no\" : Turns off transaction logging. It is indicated when performance is more important than data safety. Files are created with c-tree file mode ctPREIMG. This is the default value."));
        keyword.AddAttribute(new Attribute("fileoperations", OBJTYPE.BOOL, "Determines whether file operations (such as file create, delete, and rename) performed within an active transaction are affected by the transaction ending operation (commit or abort):\n\n\"yes\" : File operations are transaction dependent.\n\n\"no\" : File operations performed within an active transaction are not affected by the transaction ending operation (commit or abort)."));
        arrayList.add(keyword);
        keyword = new Keyword("writethru", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The writethru option specifies whether to enable write synchronization.");
        arrayList.add(keyword);
        keyword = new Keyword("allowcorrupt", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The allowcorrupt option specifies whether to allow openinc corrupted files.");
        arrayList.add(keyword);
        keyword = new Keyword("temporary", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("Suppresses the disk flush of certain operations to increase performance. NOTE: Use this option only on files that are not required to persist in the event of a system crash or power failure");
        arrayList.add(keyword);
        keyword = new Keyword("ccc", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The ccc option is legacy. Do not use it.");
        keyword.AddAttribute(new Attribute("system", OBJTYPE.BOOL, ""));
        arrayList.add(keyword);
        keyword = new Keyword("filecopy", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("Enable physical file copy for copy operations.");
        keyword.AddAttribute(new Attribute("overwrite", OBJTYPE.BOOL, "enable automatic overwrite of destination when already present. If not activated the copy fails if the destination file already exists."));
        arrayList.add(keyword);
        keyword = new Keyword("info", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.LOG});
        keyword.setDescription("The error log option instructs the RTG to log informational events.");
        arrayList.add(keyword);
        keyword = new Keyword("warning", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.LOG});
        keyword.setDescription("The error log option instructs the RTG to log warning events.");
        arrayList.add(keyword);
        keyword = new Keyword("extfh", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.DEBUG});
        keyword.setDescription("The error log option instructs the RTG to log extfh events.");
        arrayList.add(keyword);
        keyword = new Keyword("runitlockdetect", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("The runitlockdetect option specifies whether to check if a record has been locked by a separate OPEN statement issued from within the same run unit. When this option is turned on, a lock error is returned while reading a record that was locked within the same instance. When this option is turned off, reading a record that was locked within the same instance does not produce a locking error.");
        keyword.AddAttribute(new Attribute("anyunlock", OBJTYPE.BOOL, "determines if shared locks can be relased by any OPEN intance (yes) or just the one the obtained the lock (no)."));
        arrayList.add(keyword);
        keyword = new Keyword("trxholdslocks", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.addAlias("trx_holds_locks");
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG});
        keyword.setDescription("This configuration keyword simulates ACUCOBOL's TRX_HOLDS_LOCKS=1 option, which does not free locks at transaction commit unless the locked records are updated during the transaction.");
        arrayList.add(keyword);
        keyword = new Keyword("readonly", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("This configuration keyword forces readonly open on the file. This allows opening file on read-only media");
        arrayList.add(keyword);
        keyword = new Keyword("normalize", KWTYPE.NORMALIZE, OBJTYPE.STRING, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG});
        keyword.setDescription("The <normalize> configuration option helps normalizing file paths passed to c-treeRTG. This option is global-only and can be set only as a child of <config>. It is not valid if specified as child of <*instance> or <file>. When this option is in use the file path gets normalized before any file configuration matching.");
        arrayList.add(keyword);
        keyword = new Keyword("sep", KWTYPE.OPTION, OBJTYPE.STRING, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.NORMALIZE});
        keyword.setDescription("Specifies the path separator, such as forward slash (/) or backslash (\\)");
        arrayList.add(keyword);
        keyword = new Keyword("drive", KWTYPE.OPTION, OBJTYPE.STRING, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.NORMALIZE});
        keyword.setDescription("Specifies a drive letter to be used if the path does not include a drive letter");
        keyword.AddAttribute(new Attribute("force", OBJTYPE.BOOL, "Force to change the drive to the one specified"));
        arrayList.add(keyword);
        keyword = new Keyword("fastdup", KWTYPE.OPTION, OBJTYPE.BOOL, false);
        keyword.setParentTypes(new KWTYPE[]{KWTYPE.CONFIG, KWTYPE.INSTANCE, KWTYPE.FILE});
        keyword.setDescription("When enabled indexes allowing duplicates occupy less disk space and may perform slightly faster but do not guarantee the ordering of matching duplicates in case of updates.This option is disabled by default.");
        arrayList.add(keyword);
        this.setKeyWordList(arrayList);
    }

    private void SortAndFillComplemetary() {
        this.argumentDescs = new ArrayList();
        for (Keyword keyword : this.keywords) {
            keyword.SortAttributes();
            ArrayList<Attribute> arrayList = keyword.getAttributes();
            if (arrayList == null) continue;
            ArrayList<ArgumentDesc> arrayList2 = new ArrayList<ArgumentDesc>();
            for (Attribute attribute : arrayList) {
                arrayList2.add(new ArgumentDesc(attribute.getName(), attribute.getDescription()));
            }
            this.argumentDescs.add(new ArgumentDescs(keyword.getName(), arrayList2));
        }
        Collections.sort(this.keywords);
    }

    public void setKeyWordList(ArrayList<Keyword> arrayList) {
        this.keywords = arrayList;
    }

    public ArrayList<Keyword> getKeywordList() {
        return this.keywords;
    }

    public ArrayList<ArgumentDescs> getArgumentDescsList() {
        return this.argumentDescs;
    }
}

