/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class LeftTreeModel
implements TreeModel {
    TreeElement element;
    private boolean showAttributes = false;

    public LeftTreeModel(TreeElement treeElement) {
        this.element = treeElement;
    }

    @Override
    public Object getRoot() {
        return this.element;
    }

    @Override
    public Object getChild(Object object, int n) {
        TreeElement treeElement = (TreeElement)object;
        ArrayList<Attribute> arrayList = treeElement.getAttributes();
        if (this.showAttributes) {
            if (n < arrayList.size()) {
                Attribute attribute = arrayList.get(n);
                TreeElement treeElement2 = new TreeElement(attribute.getName());
                treeElement2.setIsAttribute(true);
                treeElement2.setValue(attribute.getValue());
                treeElement2.setParent(treeElement);
                treeElement2.setType(KWTYPE.ATTRIBUTE);
                return treeElement2;
            }
            TreeElement treeElement3 = treeElement.getChilds().get(n - arrayList.size());
            return treeElement3;
        }
        TreeElement treeElement4 = treeElement.getChilds().get(n);
        return treeElement4;
    }

    @Override
    public int getChildCount(Object object) {
        TreeElement treeElement = (TreeElement)object;
        int n = treeElement.getChilds().size();
        if (this.showAttributes) {
            n += treeElement.getAttributes().size();
        }
        return n;
    }

    @Override
    public boolean isLeaf(Object object) {
        TreeElement treeElement = (TreeElement)object;
        ArrayList<Attribute> arrayList = treeElement.getAttributes();
        if (!treeElement.isLeaf()) {
            return false;
        }
        return arrayList == null || arrayList.isEmpty();
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        TreeElement treeElement = (TreeElement)object;
        int n = treeElement.getChilds().indexOf(object2);
        if (this.showAttributes) {
            n += treeElement.getAttributes().size();
        }
        return n;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }

    public boolean isShowAttributes() {
        return this.showAttributes;
    }

    public void setShowAttributes(boolean bl) {
        this.showAttributes = bl;
    }
}

