/*
 * Decompiled with CFR 0.152.
 */
import FairCom.Helper.Dialogs.AboutBox;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;

public class RTGConfigView
extends JFrame
implements DropTargetListener,
WindowListener {
    public String[] args;
    public static AppProperties appProps = new AppProperties();
    public static RTGConfigView theView;
    private final String kwFilename = "keywords.xml";
    private String configFilename = null;
    private final ArrayList<Keyword> keywords;
    public ArrayList<ArgumentDescs> argumentDescs;
    private final LeftTree configTree;
    ArrayList<TreeElement> elements;
    TreeElement rootElement = null;
    ElementsTable elementTable = new ElementsTable(false);
    private JDialog aboutBox;
    private final JPopupMenu popup = null;
    private File currentDirectory = null;
    private static boolean writekw;
    private JMenuItem aboutMenuItem;
    public JMenu actionsMenu;
    private JButton collapseBT;
    private JLabel descLabel;
    private JLabel descLabel1;
    private JTextArea descTextArea;
    private JTextArea descTextArea1;
    private JButton expandBT;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JPopupMenu.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JSpinner jSpinner1;
    private JSplitPane jSplitPane1;
    private JTable jTable1;
    private JToolBar jToolBar1;
    private JTree jTree2;
    private JPanel leftPane;
    private JScrollPane leftScrollPane;
    private JButton loadBT;
    private JMenuItem loadMenuItem;
    private JButton newBT;
    private JMenuItem newMenuItem;
    private JButton newWzrdBT;
    private JMenuItem newWzrdMenuItem;
    private JTabbedPane rigthPane;
    private JMenuItem saveAsMenuItem;
    public JButton saveBT;
    private JMenuItem saveMenuItem;
    private JToggleButton showAttrBT;
    private JScrollPane tableScrollPane;
    public boolean mustSave = false;

    public RTGConfigView() {
        Thread.currentThread().setUncaughtExceptionHandler(new MyUncaughtExceptionHandler());
        theView = this;
        this.initComponents();
        this.addWindowListener(this);
        appProps.loadProperties();
        if (RTGConfigView.appProps.bounds != null && RTGConfigView.appProps.bounds.getWidth() > 400.0) {
            this.setBounds(RTGConfigView.appProps.bounds);
        } else {
            this.setBounds(new Rectangle(200, 200, 800, 600));
        }
        int n = this.jSplitPane1.getDividerLocation();
        this.jSplitPane1.setRightComponent(this.jPanel1);
        this.jSplitPane1.setDividerLocation(n);
        this.configTree = new LeftTree(this);
        this.leftScrollPane.setViewportView(this.configTree);
        this.tableScrollPane.setViewportView((Component)((Object)this.elementTable));
        this.saveBT.setEnabled(false);
        this.elementTable.setupColumns();
        this.elementTable.resizeColumns();
        DropTarget dropTarget = new DropTarget(this, this);
        Keywords keywords = new Keywords();
        if (writekw) {
            keywords.save("keywords.xml");
        }
        keywords = Keywords.load("keywords.xml");
        this.keywords = keywords.getKeywordList();
        this.argumentDescs = keywords.getArgumentDescsList();
        if (keywords.getKeywordList() == null) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this, "File \"keywords.xml\" was not found.\n\nThe tool cannot continue.", "Fatal Error", 0);
            System.exit(0);
        }
    }

    private void GenLeftTree() {
        LeftTreeModel leftTreeModel = new LeftTreeModel(this.rootElement);
        leftTreeModel.setShowAttributes(this.showAttrBT.isSelected());
        this.configTree.setModel(leftTreeModel);
        this.expandBTActionPerformed(null);
    }

    public void loadFile(String string) {
        this.setTitle("RTG Configuration - File : " + string);
        ConfigParser configParser = new ConfigParser(string, this.getKeywords());
        this.rootElement = configParser.parseDocument(this);
        this.GenLeftTree();
        this.backupFile(string);
        this.mustSave = true;
        this.saveBT.setEnabled(true);
    }

    private void backupFile(String string) {
        try {
            File file = new File(string);
            File file2 = new File(string + ".bak");
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            try {
                int n;
                while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(RTGConfigView.class.getName()).log(Level.SEVERE, null, iOException);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(RTGConfigView.class.getName()).log(Level.SEVERE, null, fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger(RTGConfigView.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    public void refreshTree() {
        this.configTree.updateUI();
        this.configTree.repaint();
    }

    public void nodeSelected(TreeElement treeElement) {
        Keyword keyword;
        this.descTextArea.setText("");
        this.elementTable.stopEdits();
        this.elementTable.clearTable();
        KWTYPE kWTYPE = treeElement.getType();
        TreeElement treeElement2 = treeElement;
        if ((kWTYPE == null || kWTYPE == KWTYPE.ATTRIBUTE) && (treeElement = treeElement.getParent()) != null) {
            kWTYPE = treeElement.getType();
        }
        if (treeElement != null && (keyword = treeElement.getKey()) != null) {
            this.descTextArea.setText(keyword.getDescription());
            this.descTextArea.setCaretPosition(1);
            this.elementTable.fillTable(treeElement, keyword);
            this.elementTable.setBaseNode(treeElement2);
            this.setTableHelp(treeElement.getName());
            this.descTextArea1.setText("");
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RTGConfigView.this.elementTable.selectRow();
                }
            });
        }
    }

    public void setTableHelp(String string) {
        this.descTextArea1.setText("");
        TreeElement treeElement = (TreeElement)this.configTree.getLastSelectedPathComponent();
        if (treeElement == null) {
            return;
        }
        if (treeElement.isOption() || treeElement.isAttribute()) {
            treeElement = treeElement.getParent();
        }
        boolean bl = false;
        block0: for (Keyword object : this.getKeywords()) {
            if (!string.toLowerCase().equals(object.getName())) continue;
            ArrayList<KWTYPE> arrayList = object.getParentTypesAsList();
            Iterator<KWTYPE> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                KWTYPE kWTYPE = iterator.next();
                if (treeElement.getType() != kWTYPE) continue;
                bl = true;
                this.descTextArea1.setText(object.getDescription());
                this.descTextArea1.setCaretPosition(1);
                continue block0;
            }
        }
        if (!bl) {
            block2: for (ArgumentDescs argumentDescs : this.argumentDescs) {
                if (!argumentDescs.getKeywordName().equals(treeElement.getName())) continue;
                for (ArgumentDesc argumentDesc : argumentDescs.getArgumentDesc()) {
                    if (!argumentDesc.getName().equals(string)) continue;
                    this.descTextArea1.setText(argumentDesc.getDescription());
                    this.descTextArea1.setCaretPosition(1);
                    continue block2;
                }
            }
        }
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.newWzrdBT = new JButton();
        this.newBT = new JButton();
        this.loadBT = new JButton();
        this.saveBT = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.expandBT = new JButton();
        this.collapseBT = new JButton();
        this.showAttrBT = new JToggleButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jSplitPane1 = new JSplitPane();
        this.rigthPane = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.tableScrollPane = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel3 = new JPanel();
        this.descLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.descTextArea1 = new JTextArea();
        this.jPanel2 = new JPanel();
        this.jSpinner1 = new JSpinner();
        this.leftPane = new JPanel();
        this.leftScrollPane = new JScrollPane();
        this.jTree2 = new JTree();
        this.jPanel4 = new JPanel();
        this.descLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.descTextArea = new JTextArea();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.newWzrdMenuItem = new JMenuItem();
        this.newMenuItem = new JMenuItem();
        this.loadMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.actionsMenu = new JMenu();
        this.jMenu2 = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("RTG Configuration");
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.newWzrdBT.setIcon(new ImageIcon(this.getClass().getResource("/images/NewWzrd.png")));
        this.newWzrdBT.setToolTipText("New file (Basic)");
        this.newWzrdBT.setFocusable(false);
        this.newWzrdBT.setHorizontalTextPosition(0);
        this.newWzrdBT.setVerticalTextPosition(3);
        this.newWzrdBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RTGConfigView.this.createNew(actionEvent);
            }
        });
        this.jToolBar1.add(this.newWzrdBT);
        this.newBT.setIcon(new ImageIcon(this.getClass().getResource("/images/New.png")));
        this.newBT.setToolTipText("New file (Advanced)");
        this.newBT.setFocusable(false);
        this.newBT.setHorizontalTextPosition(0);
        this.newBT.setVerticalTextPosition(3);
        this.newBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RTGConfigView.this.newBTActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.newBT);
        this.loadBT.setIcon(new ImageIcon(this.getClass().getResource("/images/Open.png")));
        this.loadBT.setToolTipText("Open a file");
        this.loadBT.setFocusable(false);
        this.loadBT.setHorizontalTextPosition(0);
        this.loadBT.setVerticalTextPosition(3);
        this.loadBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RTGConfigView.this.loadBTActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.loadBT);
        this.saveBT.setIcon(new ImageIcon(this.getClass().getResource("/images/Save.png")));
        this.saveBT.setToolTipText("Save current file");
        this.saveBT.setFocusable(false);
        this.saveBT.setHorizontalTextPosition(0);
        this.saveBT.setVerticalTextPosition(3);
        this.saveBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RTGConfigView.this.saveBTActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.saveBT);
        this.jToolBar1.add(this.jSeparator2);
        this.expandBT.setIcon(new ImageIcon(this.getClass().getResource("/images/ExpandTree.png")));
        this.expandBT.setToolTipText("Expand tree");
        this.expandBT.setFocusable(false);
        this.expandBT.setHorizontalTextPosition(0);
        this.expandBT.setVerticalTextPosition(3);
        this.expandBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RTGConfigView.this.expandBTActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.expandBT);
        this.collapseBT.setIcon(new ImageIcon(this.getClass().getResource("/images/CollapseTree.png")));
        this.collapseBT.setToolTipText("Collapse tree");
        this.collapseBT.setFocusable(false);
        this.collapseBT.setHorizontalTextPosition(0);
        this.collapseBT.setVerticalTextPosition(3);
        this.collapseBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RTGConfigView.this.collapseBTActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.collapseBT);
        this.showAttrBT.setSelected(true);
        this.showAttrBT.setText("Show Attributes");
        this.showAttrBT.setFocusable(false);
        this.showAttrBT.setHorizontalTextPosition(0);
        this.showAttrBT.setVerticalTextPosition(3);
        this.showAttrBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RTGConfigView.this.showAttrBTActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.showAttrBT);
        this.jToolBar1.add(this.jSeparator3);
        this.jSplitPane1.setDividerLocation(350);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.tableScrollPane.setViewportView(this.jTable1);
        this.descLabel1.setText("Description :");
        this.descTextArea1.setColumns(20);
        this.descTextArea1.setFont(new Font("Tahoma", 0, 12));
        this.descTextArea1.setLineWrap(true);
        this.descTextArea1.setRows(5);
        this.descTextArea1.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.descTextArea1);
        GroupLayout groupLayout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.descLabel1).addGap(18, 18, 18).addComponent(this.jScrollPane2, -1, 322, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 69, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.descLabel1).addGap(39, 39, 39)))));
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.tableScrollPane, -2, 0, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.tableScrollPane, -1, 361, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2)));
        this.rigthPane.addTab("Config", this.jPanel1);
        GroupLayout groupLayout3 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGap(78, 78, 78).addComponent(this.jSpinner1, -2, 122, -2).addContainerGap(220, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap(228, Short.MAX_VALUE).addComponent(this.jSpinner1, -2, -1, -2).addGap(210, 210, 210)));
        this.rigthPane.addTab("Log", this.jPanel2);
        this.jSplitPane1.setRightComponent(this.rigthPane);
        this.jTree2.setRowHeight(18);
        this.jTree2.setShowsRootHandles(true);
        this.leftScrollPane.setViewportView(this.jTree2);
        GroupLayout groupLayout4 = new GroupLayout(this.leftPane);
        this.leftPane.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.leftScrollPane, -1, 349, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.leftScrollPane, -1, 486, Short.MAX_VALUE));
        this.jSplitPane1.setLeftComponent(this.leftPane);
        this.descLabel.setText("Description :");
        this.descTextArea.setColumns(20);
        this.descTextArea.setFont(new Font("Tahoma", 0, 12));
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setRows(5);
        this.descTextArea.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.descTextArea);
        GroupLayout groupLayout5 = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.descLabel).addContainerGap(-1, Short.MAX_VALUE)).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addGap(86, 86, 86).addComponent(this.jScrollPane1, -1, 685, Short.MAX_VALUE).addContainerGap())));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addGap(34, 34, 34).addComponent(this.descLabel).addContainerGap(45, Short.MAX_VALUE)).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout5.createSequentialGroup().addContainerGap(12, Short.MAX_VALUE).addComponent(this.jScrollPane1, -2, 69, -2).addContainerGap(12, Short.MAX_VALUE))));
        this.jMenu1.setText("File");
        this.newWzrdMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/images/NewWzrd.png")));
        this.newWzrdMenuItem.setMnemonic('N');
        this.newWzrdMenuItem.setText("New (Basic) ...");
        this.newWzrdMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RTGConfigView.this.createNew(actionEvent);
            }
        });
        this.jMenu1.add(this.newWzrdMenuItem);
        this.newMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/images/New.png")));
        this.newMenuItem.setMnemonic('N');
        this.newMenuItem.setText("New (Advanced) ...");
        this.newMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RTGConfigView.this.newMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.newMenuItem);
        this.loadMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/images/Open.png")));
        this.loadMenuItem.setText("Open...");
        this.loadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RTGConfigView.this.loadMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.loadMenuItem);
        this.jMenu1.add(this.jSeparator1);
        this.saveMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/images/Save.png")));
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RTGConfigView.this.saveMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.saveMenuItem);
        this.saveAsMenuItem.setText("Save As...");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RTGConfigView.this.saveAsMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.saveAsMenuItem);
        this.jMenuItem1.setText("Exit");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RTGConfigView.this.jMenuItem1ActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.actionsMenu.setText("Actions");
        this.jMenuBar1.add(this.actionsMenu);
        this.jMenu2.setText("Help");
        this.aboutMenuItem.setText("About...");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RTGConfigView.this.aboutMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu2.add(this.aboutMenuItem);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout groupLayout6 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, -1, Short.MAX_VALUE).addComponent(this.jSplitPane1).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2)));
        this.pack();
    }

    private void save() {
        if (this.rootElement != null) {
            if (this.configFilename == null) {
                this.configFilename = this.chooseFile(true);
                if (this.configFilename != null) {
                    this.configTree.toXML(this.configFilename, this.rootElement);
                    this.setTitle("RTG Configuration - File : " + this.configFilename);
                }
            } else {
                this.configTree.toXML(this.configFilename, this.rootElement);
                this.setTitle("RTG Configuration - File : " + this.configFilename);
            }
        }
        this.saveBT.setEnabled(false);
        this.mustSave = false;
    }

    private void saveBTActionPerformed(ActionEvent actionEvent) {
        this.save();
    }

    private void loadBTActionPerformed(ActionEvent actionEvent) {
        String string;
        if (this.mustSave) {
            this.checkSave();
        }
        if ((string = this.chooseFile(false)) != null && !string.isEmpty()) {
            this.configFilename = string;
            this.loadFile(this.configFilename);
        }
    }

    private void loadMenuItemActionPerformed(ActionEvent actionEvent) {
        String string;
        if (this.mustSave) {
            this.checkSave();
        }
        if ((string = this.chooseFile(false)) != null && !string.isEmpty()) {
            this.configFilename = string;
            this.loadFile(this.configFilename);
        }
    }

    private void saveMenuItemActionPerformed(ActionEvent actionEvent) {
        this.save();
    }

    private void saveAsMenuItemActionPerformed(ActionEvent actionEvent) {
        String string = this.configFilename;
        this.configFilename = null;
        this.save();
        if (this.configFilename == null) {
            this.configFilename = string;
        }
    }

    private void expandBTActionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.configTree.getRowCount(); ++i) {
            this.configTree.expandRow(i);
        }
    }

    private void collapseBTActionPerformed(ActionEvent actionEvent) {
        for (int i = this.configTree.getRowCount() - 1; i >= 0; --i) {
            this.configTree.collapseRow(i);
        }
    }

    private void showAttrBTActionPerformed(ActionEvent actionEvent) {
        LeftTreeModel leftTreeModel = this.configTree.getModel();
        leftTreeModel.setShowAttributes(this.showAttrBT.isSelected());
        this.configTree.updateUI();
    }

    private void aboutMenuItemActionPerformed(ActionEvent actionEvent) {
        if (this.aboutBox == null) {
            ImageIcon imageIcon = Globals.getIcon("RTGConfig_48.png");
            this.aboutBox = new AboutBox((Frame)this, true, (Icon)imageIcon, "RTG Configuration", "RTG");
        }
        this.aboutBox.setLocationRelativeTo(this);
        this.aboutBox.setVisible(true);
    }

    private void createNew(ActionEvent actionEvent) {
        if (this.mustSave) {
            this.checkSave();
        }
        Wizard wizard = new Wizard((Frame)this, true);
        wizard.setLocationRelativeTo(this);
        boolean bl = wizard.showDialog();
    }

    private void jMenuItem1ActionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    private void newBTActionPerformed(ActionEvent actionEvent) {
        this.createNew();
    }

    private void newMenuItemActionPerformed(ActionEvent actionEvent) {
        this.createNew();
    }

    private void createNew() {
        TreeElement treeElement;
        if (this.mustSave) {
            this.checkSave();
        }
        this.configFilename = null;
        this.rootElement = treeElement = new TreeElement("New config file");
        TreeElement treeElement2 = new TreeElement(this.getKeyword("config"));
        treeElement2.setParent(treeElement);
        treeElement.getChilds().add(treeElement2);
        treeElement = treeElement2;
        this.GenLeftTree();
        this.setTitle("RTG Configuration");
        this.mustSave = true;
        this.elementTable.clearTable();
        this.saveBT.setEnabled(true);
    }

    private void checkSave() {
        int n = JOptionPane.showConfirmDialog(this, "The current file may have changed.\nDo you want to save it ?", "Config File Save", 0, 2);
        if (n == 0) {
            this.save();
        }
    }

    private Keyword getKeyword(String string) {
        for (Keyword keyword : this.keywords) {
            if (!string.equalsIgnoreCase(keyword.getName())) continue;
            return keyword;
        }
        return null;
    }

    private String chooseFile(boolean bl) {
        Object object;
        if (this.currentDirectory == null) {
            object = System.getProperty("user.dir");
            this.currentDirectory = new File((String)object);
        }
        object = new JFileChooser();
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("config files (*.conf)", "conf");
        ((JFileChooser)object).setFileFilter(fileNameExtensionFilter);
        ((JFileChooser)object).setFileSelectionMode(0);
        ((JFileChooser)object).setCurrentDirectory(this.currentDirectory);
        int n = bl ? ((JFileChooser)object).showSaveDialog(this) : ((JFileChooser)object).showOpenDialog(this);
        if (n == 0) {
            File file = ((JFileChooser)object).getSelectedFile();
            this.currentDirectory = ((JFileChooser)object).getCurrentDirectory();
            String string = file.getAbsolutePath();
            return string;
        }
        return null;
    }

    public static void main(final String[] stringArray) {
        Globals.args = stringArray;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(RTGConfigView.class.getName()).log(Level.SEVERE, null, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            Logger.getLogger(RTGConfigView.class.getName()).log(Level.SEVERE, null, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(RTGConfigView.class.getName()).log(Level.SEVERE, null, illegalAccessException);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            Logger.getLogger(RTGConfigView.class.getName()).log(Level.SEVERE, null, unsupportedLookAndFeelException);
        }
        for (String string : stringArray) {
            if (string.compareTo("-kw") != 0) continue;
            writekw = true;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RTGConfigView rTGConfigView = new RTGConfigView();
                rTGConfigView.args = stringArray;
                ArrayList<Image> arrayList = new ArrayList<Image>();
                ImageIcon imageIcon = Globals.getIcon("RTGConfig_16.png");
                Image image = imageIcon.getImage();
                arrayList.add(image);
                imageIcon = Globals.getIcon("RTGConfig_24.png");
                image = imageIcon.getImage();
                arrayList.add(image);
                imageIcon = Globals.getIcon("RTGConfig_32.png");
                image = imageIcon.getImage();
                arrayList.add(image);
                imageIcon = Globals.getIcon("RTGConfig_48.png");
                image = imageIcon.getImage();
                arrayList.add(image);
                rTGConfigView.setIconImages(arrayList);
                for (String string : Globals.args) {
                    if (!string.equals("-locale")) continue;
                    Locale.setDefault(Locale.ENGLISH);
                }
                Globals.appProps.loadProperties();
                if (Globals.appProps.bounds != null && RTGConfigView.isLocationInScreenBounds(new Point(Globals.appProps.bounds.x, Globals.appProps.bounds.y))) {
                    rTGConfigView.setBounds(Globals.appProps.bounds);
                } else {
                    rTGConfigView.setBounds(new Rectangle(200, 200, 800, 600));
                }
                rTGConfigView.setVisible(true);
                rTGConfigView.setVisible(true);
            }
        });
    }

    public static boolean isLocationInScreenBounds(Point point) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        Rectangle rectangle = new Rectangle();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
            rectangle.setRect(graphicsDevice.getDefaultConfiguration().getBounds());
            rectangle.setRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (!rectangle.contains(point.x, point.y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                System.out.println("Possible flavor: " + dataFlavorArray[i].getMimeType());
                if (!dataFlavorArray[i].isFlavorJavaFileListType()) continue;
                dropTargetDropEvent.acceptDrop(3);
                List list = (List)transferable.getTransferData(dataFlavorArray[i]);
                dropTargetDropEvent.dropComplete(true);
                this.loadFile(list.get(0).toString());
                return;
            }
            dropTargetDropEvent.rejectDrop();
        }
        catch (Exception exception) {
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        Rectangle rectangle;
        RTGConfigView.appProps.bounds = rectangle = this.getBounds();
        appProps.saveProperties();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public ArrayList<Keyword> getKeywords() {
        return this.keywords;
    }

    static {
        writekw = false;
        Globals.execDir = System.getProperty("user.dir");
        Globals.os = System.getProperty("os.name").toLowerCase();
        Globals.is64Bit = System.getProperty("sun.arch.data.model").contains("64");
        boolean bl = Globals.os.startsWith("mac os x");
        if (bl) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "RTGMigrate");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
    }

    class MyUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        MyUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (!(throwable instanceof IllegalStateException)) {
                StackTraceElement stackTraceElement;
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                if (stackTraceElementArray.length > 0 && (stackTraceElement = stackTraceElementArray[0]).getClassName().contains("BasicTreeUI")) {
                    return;
                }
                Globals.ShowNormalCursor();
                Globals.showException(throwable, null, false);
            }
        }
    }
}

