/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.TreeCellRenderer;

public class TreeNodeRenderer
extends JPanel
implements TreeCellRenderer {
    ImageIcon closedFolderIcon = TreeNodeRenderer.getIcon("ClsdFold.png");
    ImageIcon openFolderIcon = TreeNodeRenderer.getIcon("OpenFold.png");
    ImageIcon attrIcon = TreeNodeRenderer.getIcon("redBall.png");
    ImageIcon valueIcon = TreeNodeRenderer.getIcon("blueball.png");
    protected JLabel valueLabel;
    protected JLabel descLabel;
    protected JLabel iconLabel;

    public TreeNodeRenderer() {
        this.setLayout(null);
        this.iconLabel = new JLabel();
        this.add(this.iconLabel);
        this.valueLabel = new JLabel();
        this.add(this.valueLabel);
        this.descLabel = new JLabel();
        this.add(this.descLabel);
        this.descLabel.setForeground(Color.blue);
        this.descLabel.setOpaque(true);
        this.valueLabel.setOpaque(true);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Object object2;
        Object object3;
        ArrayList<Attribute> arrayList;
        TreeElement treeElement = (TreeElement)object;
        String string = treeElement.getName();
        String string2 = treeElement.getValue();
        if (bl) {
            this.valueLabel.setForeground(Color.white);
            this.valueLabel.setBackground(UIManager.getColor("Tree.selectionBackground"));
            this.descLabel.setBackground(UIManager.getColor("Tree.selectionBackground"));
            this.descLabel.setForeground(Color.white);
        } else {
            this.valueLabel.setForeground(Color.black);
            this.valueLabel.setBackground(Color.white);
            this.descLabel.setForeground(Color.blue);
            this.descLabel.setBackground(Color.white);
        }
        if (bl2) {
            this.iconLabel.setIcon(this.openFolderIcon);
        } else {
            this.iconLabel.setIcon(this.closedFolderIcon);
        }
        if (string2 != null && !string2.isEmpty()) {
            this.valueLabel.setText(" " + string);
            this.iconLabel.setIcon(this.valueIcon);
            this.descLabel.setText("= " + string2 + "");
        } else {
            this.valueLabel.setText(" " + string);
            this.descLabel.setText("");
        }
        if (treeElement.isAttribute()) {
            this.valueLabel.setText(" " + string);
            if (string2 != null) {
                this.descLabel.setText("= " + string2 + "");
            } else {
                this.descLabel.setText("");
            }
            this.iconLabel.setIcon(this.attrIcon);
        } else if (treeElement.isOption()) {
            this.iconLabel.setIcon(this.valueIcon);
        }
        if (treeElement.getChilds().size() > 0) {
            if (bl2) {
                this.iconLabel.setIcon(this.openFolderIcon);
            } else {
                this.iconLabel.setIcon(this.closedFolderIcon);
            }
        }
        if (treeElement.getKey() != null && treeElement.getKey().getType() == KWTYPE.INSTANCE) {
            arrayList = treeElement.getAttributes();
            if (!arrayList.isEmpty()) {
                object3 = arrayList.get(0);
                object2 = ((Attribute)object3).getValue();
                if (object2 == null) {
                    object2 = "";
                }
                this.descLabel.setText(" ( " + (String)object2 + " )");
            }
            if (!bl) {
                this.descLabel.setForeground(Color.gray);
            }
        }
        if (treeElement.getKey() != null && treeElement.getKey().getType() == KWTYPE.FILE) {
            arrayList = treeElement.getAttributes();
            if (!arrayList.isEmpty()) {
                String string3;
                object3 = "";
                if (arrayList.size() == 2 && (string3 = ((Attribute)(object2 = arrayList.get(1))).getValue()) != null) {
                    object3 = ((Attribute)object2).getName() + "= " + string3 + " - ";
                }
                if ((string3 = ((Attribute)(object2 = arrayList.get(0))).getValue()) != null) {
                    object3 = (String)object3 + ((Attribute)object2).getName() + "= " + string3;
                }
                this.descLabel.setText(" ( " + (String)object3 + " )");
            }
            if (!bl) {
                this.descLabel.setForeground(Color.gray);
            }
        }
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.valueLabel.getPreferredSize();
        Dimension dimension2 = this.descLabel.getPreferredSize();
        Dimension dimension3 = this.iconLabel.getPreferredSize();
        return new Dimension(dimension3.width + dimension.width + dimension2.width + 30, dimension.height < dimension2.height ? dimension2.height : dimension.height);
    }

    @Override
    public void doLayout() {
        Dimension dimension = this.valueLabel.getPreferredSize();
        Dimension dimension2 = this.descLabel.getPreferredSize();
        Dimension dimension3 = this.iconLabel.getPreferredSize();
        int n = 0;
        int n2 = 0;
        this.iconLabel.setBounds(0, n, dimension3.width + 5, dimension3.height);
        this.valueLabel.setBounds(dimension3.width + 2, n, dimension.width + 5, dimension3.height);
        this.descLabel.setBounds(dimension3.width + dimension.width + 4, n2, dimension2.width + 5, dimension3.height);
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public static ImageIcon getIcon(String string) {
        URL uRL = RTGConfigView.class.getResource("images/" + string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }
}

