/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import java.io.IOException;
import java.io.InputStream;

class CtreeCharToHexModulatorStream
extends InputStream {
    protected static final String hexDigits = "0123456789ABCDEF";
    protected InputStream charInputStream;

    public CtreeCharToHexModulatorStream(InputStream inputStream) {
        this.charInputStream = inputStream;
    }

    @Override
    public int available() throws IOException {
        int n = this.charInputStream.available();
        return n > 0 ? n / 2 : n;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.charInputStream.close();
        this.charInputStream = null;
    }

    @Override
    public int read() throws IOException {
        int n = this.charInputStream.read();
        int n2 = this.charInputStream.read();
        if (n < 0 || n2 < 0) {
            return -1;
        }
        if (n >= 97 && n <= 102) {
            n -= 32;
        }
        if (n2 >= 97 && n2 <= 102) {
            n2 -= 32;
        }
        if ((n = hexDigits.indexOf(n)) == -1) {
            throw new IOException("invalid hex number");
        }
        if ((n2 = hexDigits.indexOf(n2)) == -1) {
            throw new IOException("invalid hex number");
        }
        return (n << 4) + n2;
    }

    @Override
    public long skip(long l) throws IOException {
        return this.charInputStream.skip(l * 2L) / 2L;
    }
}

