/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeError;
import ctree.jdbc.SQLNetwork;
import ctree.jdbc.SQLNetworkException;
import ctree.jdbc.SQLPacket;
import ctree.jdbc.SQLPacketHeader;
import ctree.jdbc.SQLTransport;
import ctree.jdbc.ctreeOEM;
import ctree.jdbc.ctreeOEMX;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class CtreeSQLNetworkImpl
implements SQLNetwork,
CtreeError,
ctreeOEM,
ctreeOEMX {
    private SQLTransport TransportHandle = null;
    private int ErrorCode = 0;
    private SQLPacketHeader PacketHeader;
    private int ProcedureNumber;
    private String InterfaceName;
    private int InterfaceID;
    private int InterfaceVersion;
    private int RequestID = 0;
    private int dsnHdl = 0;
    private boolean cacheInput = true;

    public CtreeSQLNetworkImpl(SQLTransport sQLTransport) {
        this.TransportHandle = sQLTransport;
        this.PacketHeader = new SQLPacketHeader();
    }

    public CtreeSQLNetworkImpl(int n) {
        this.dsnHdl = n;
    }

    @Override
    public void close() {
        try {
            this.TransportHandle.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    @Override
    public void rsvp(SQLPacket sQLPacket, SQLPacket sQLPacket2) throws SQLNetworkException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.PacketHeader.setMessageLength(sQLPacket.getMessageLength() + 68);
        try {
            this.PacketHeader.marshal(byteArrayOutputStream);
            byteArrayOutputStream.write(sQLPacket.getPacketData());
        }
        catch (IOException iOException) {
            throw new SQLNetworkException(-30099, iOException);
        }
        try {
            this.TransportHandle.send(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new SQLNetworkException(-30031, iOException);
        }
        try {
            byte[] byArray = this.TransportHandle.receive(68);
            object = new ByteArrayInputStream(byArray);
            this.TransportHandle.unmarshal((InputStream)object);
            this.PacketHeader.unmarshal((InputStream)object);
            if (-30101 == this.PacketHeader.getStatus()) {
                return;
            }
            if (0 != this.PacketHeader.getStatus()) {
                throw new SQLNetworkException(this.PacketHeader.getStatus());
            }
        }
        catch (IOException iOException) {
            throw new SQLNetworkException(-30032, iOException);
        }
        try {
            int n = this.PacketHeader.getMessageLength() - 68;
            if (n == 0) {
                return;
            }
            if (this.cacheInput) {
                object = this.TransportHandle.receive(n);
                sQLPacket2.setPacketData((byte[])object);
            } else {
                sQLPacket2.setPacketData(this.TransportHandle.getInputStream());
            }
        }
        catch (IOException iOException) {
            throw new SQLNetworkException(-30032, iOException);
        }
    }

    @Override
    public void cancel() throws SQLNetworkException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.PacketHeader.setMessageLength(68);
        this.PacketHeader.setStatus(-30101);
        this.PacketHeader.setProcedureNumber(0);
        this.PacketHeader.setRequestIdentifier(0);
        this.PacketHeader.setInterfaceName(" ");
        this.PacketHeader.setInterfaceVersion(0);
        try {
            this.PacketHeader.marshal(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new SQLNetworkException(-30099, iOException);
        }
        try {
            this.TransportHandle.send(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new SQLNetworkException(-30031, iOException);
        }
    }

    public SQLTransport getTransportHandle() {
        return this.TransportHandle;
    }

    public void setTransportHandle(SQLTransport sQLTransport) {
        this.TransportHandle = sQLTransport;
    }

    private int getInterfaceVersion() {
        return this.InterfaceVersion;
    }

    private int getClientProcedureNumber() {
        return this.ProcedureNumber;
    }

    @Override
    public void setProcedureNumber(int n) {
        this.PacketHeader.setProcedureNumber(n);
    }

    @Override
    public void setInterfaceName(String string) {
        this.PacketHeader.setInterfaceName(string);
    }

    @Override
    public void setInterfaceID(int n) {
        this.PacketHeader.setInterfaceID(n);
    }

    private int getRequestIdentifier() {
        return this.RequestID++;
    }

    private int getNetworkVersion() {
        return 1744831864;
    }

    private int getPacketHeaderSize() {
        return 68;
    }

    private int getControlPacketSize() {
        return 4;
    }

    public int getErrorCode() {
        return this.ErrorCode;
    }

    @Override
    public int getDsnHdl() {
        return this.dsnHdl;
    }

    public String getInterfaceName(int n) throws SQLNetworkException {
        switch (n) {
            case 0: {
                return new String("NetInit");
            }
            case 1: {
                return new String("Netfns");
            }
            case 2: {
                return new String("CntlIface");
            }
        }
        throw new SQLNetworkException(-30004);
    }

    @Override
    public void setInputCaching(boolean bl) {
        if (!this.TransportHandle.isSHM()) {
            this.cacheInput = bl;
        }
    }

    @Override
    public void SslHandshake(int n) throws SQLNetworkException {
        try {
            this.TransportHandle.SslHandshake(n);
        }
        catch (IOException iOException) {
            throw new SQLNetworkException(26003);
        }
    }
}

