/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeCltSvr;
import ctree.jdbc.CtreeDA;
import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeSQLException;
import ctree.jdbc.SQLPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;

public final class CtreeSnDesc
implements CtreeError {
    int status = 0;
    CtreeCltSvr CltSvr;
    CtreeDA DA;

    public CtreeSnDesc() {
        this.CltSvr = new CtreeCltSvr(1);
        this.DA = null;
    }

    public CtreeSnDesc(int n, CtreeDA ctreeDA) {
        this.CltSvr = new CtreeCltSvr(n);
        this.DA = ctreeDA;
    }

    public void close() {
        if (this.DA != null && this.CltSvr.getType() == 1) {
            this.DA.close();
            this.DA = null;
        }
        this.CltSvr = null;
    }

    public void finalize() {
        this.close();
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void setCltSvr(CtreeCltSvr ctreeCltSvr) {
        this.CltSvr = ctreeCltSvr;
    }

    public void setDA(CtreeDA ctreeDA) {
        this.DA = ctreeDA;
    }

    public int getStatus() {
        return this.status;
    }

    public CtreeCltSvr getCltSvr() {
        return this.CltSvr;
    }

    public CtreeDA getDA() {
        return this.DA;
    }

    public void marshal(SQLPacket sQLPacket) throws IOException, SQLException {
        DataOutputStream dataOutputStream = sQLPacket.getOutputStream();
        dataOutputStream.writeInt(this.status);
        if (this.CltSvr.getType() == 0) {
            this.CltSvr.setType(1);
            this.CltSvr.marshal(sQLPacket);
            short s = this.DA.getNColumns();
            dataOutputStream.writeInt(s);
            dataOutputStream.writeInt(this.DA.getVarnmSize());
        } else if (this.CltSvr.getType() == 1) {
            throw new CtreeSQLException("Marshalling as server side. Unexpected", 26008);
        }
    }

    public void unmarshal(SQLPacket sQLPacket) throws IOException, SQLException {
        DataInputStream dataInputStream = sQLPacket.getInputStream();
        this.status = dataInputStream.readInt();
        this.CltSvr.unmarshal(dataInputStream);
        int n = this.CltSvr.getType();
        if (n == 0) {
            String string;
            int n2;
            if (this.status != 0) {
                return;
            }
            int n3 = dataInputStream.readInt();
            this.DA.setNVars((short)dataInputStream.readInt());
            if (this.DA.getNVars() >= 0) {
                n3 = this.DA.getNVars();
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.DA.setHostType(n2, (short)dataInputStream.readInt());
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.DA.setPrecision(n2, (short)dataInputStream.readInt());
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.DA.setScale(n2, (short)dataInputStream.readInt());
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.DA.setFlag(n2, (short)dataInputStream.readInt());
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.DA.setLength(n2, dataInputStream.readInt());
            }
            if (dataInputStream.readInt() != 0) {
                for (n2 = 0; n2 < n3; ++n2) {
                    string = sQLPacket.unmarshalString();
                    if (string.length() > 0) {
                        this.DA.setVarName(n2, string);
                        continue;
                    }
                    this.DA.setVarName(n2, null);
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.DA.setClength(n2, dataInputStream.readInt());
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.DA.setRlength(n2, dataInputStream.readInt());
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.DA.setOdbcFlag(n2, (short)dataInputStream.readInt());
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.DA.setSqlTypes(n2, this.DA.getHostType(n2));
                this.DA.setType(n2, this.DA.getSqlType(n2));
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.DA.setDateIntCode(n2, (short)dataInputStream.readInt());
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.DA.setDateIntPrec(n2, (short)dataInputStream.readInt());
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.DA.setSearchable(n2, (short)dataInputStream.readInt());
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.DA.setUpdatable(n2, (short)dataInputStream.readInt());
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.DA.setParamType(n2, (short)dataInputStream.readInt());
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.DA.setVerboseType(n2, (short)dataInputStream.readInt());
            }
            for (n2 = 0; n2 < n3; ++n2) {
                string = sQLPacket.unmarshalString();
                if (string.length() > 0) {
                    this.DA.setCollateName(n2, string);
                    continue;
                }
                this.DA.setCollateName(n2, null);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                string = sQLPacket.unmarshalString();
                if (string.length() > 0) {
                    this.DA.setCharsetName(n2, string);
                    continue;
                }
                this.DA.setCharsetName(n2, null);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                string = sQLPacket.unmarshalString();
                if (string.length() > 0) {
                    this.DA.setBaseTableName(n2, string);
                    continue;
                }
                this.DA.setBaseTableName(n2, null);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                string = sQLPacket.unmarshalString();
                if (string.length() > 0) {
                    this.DA.setBaseColumnName(n2, string);
                    continue;
                }
                this.DA.setBaseColumnName(n2, null);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                string = sQLPacket.unmarshalString();
                if (string.length() > 0) {
                    this.DA.setTableName(n2, string);
                    continue;
                }
                this.DA.setTableName(n2, null);
            }
        } else if (this.CltSvr.getType() == 1) {
            throw new CtreeSQLException("Marshalling as server side. Unexpected", 26008);
        }
    }
}

