/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeConnection;
import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeJDBCObject;
import ctree.jdbc.CtreeSQLException;
import ctree.jdbc.CtreeURL;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class Driver
extends CtreeJDBCObject
implements java.sql.Driver,
CtreeError {
    protected static final PrintStream o = System.out;
    protected static boolean debugFlag = true;

    public Driver() throws SQLException {
        if (Driver.traceOn()) {
            Driver.trace("@Driver(). Created a new Instance. ");
        }
        DriverManager.registerDriver(this);
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        CtreeConnection ctreeConnection;
        if (Driver.traceOn()) {
            Driver.trace("@Driver.connect (URL=" + string + ", info= " + properties + ")");
        }
        if (!this.acceptsURL(string)) {
            return null;
        }
        String string2 = properties.getProperty("user");
        String string3 = properties.getProperty("password");
        String string4 = properties.getProperty("sock_timeout");
        if (string2 == null) {
            string2 = " ";
        }
        if (string3 == null) {
            string3 = " ";
        }
        if (string4 != null) {
            Integer n = new Integer(string4);
            ctreeConnection = new CtreeConnection(string, string2, string3, null, n);
        } else {
            ctreeConnection = new CtreeConnection(string, string2, string3, null);
        }
        return ctreeConnection;
    }

    @Override
    public boolean acceptsURL(String string) {
        try {
            new CtreeURL(string, true);
        }
        catch (CtreeSQLException ctreeSQLException) {
            return false;
        }
        return true;
    }

    public String getdbOptions(String string) {
        String string2 = null;
        return string2;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        if (!this.acceptsURL(string)) {
            throw new CtreeSQLException(26004);
        }
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[2];
        driverPropertyInfoArray[0] = new DriverPropertyInfo("user", null);
        driverPropertyInfoArray[0].description = "user";
        driverPropertyInfoArray[0].required = true;
        driverPropertyInfoArray[0].choices = new String[1];
        driverPropertyInfoArray[0].choices[0] = "No choices are available";
        driverPropertyInfoArray[1] = new DriverPropertyInfo("password", null);
        driverPropertyInfoArray[1].description = "password";
        driverPropertyInfoArray[1].required = true;
        driverPropertyInfoArray[1].choices = new String[1];
        driverPropertyInfoArray[1].choices[0] = "No choices are available";
        return driverPropertyInfoArray;
    }

    @Override
    public int getMajorVersion() {
        return 1300;
    }

    @Override
    public int getMinorVersion() {
        return 1113;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        CtreeSQLException ctreeSQLException = new CtreeSQLException(26030);
        throw new SQLFeatureNotSupportedException(CtreeSQLException.getErrorMessage(26030), CtreeSQLException.getSQLState(26030), 26030);
    }

    static {
        try {
            Driver driver = new Driver();
        }
        catch (Exception exception) {
            o.println("Driver " + exception);
        }
    }
}

