/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Persistence.EntityAgent;

import FairCom.Persistence.Annotations.Column;
import FairCom.Persistence.Annotations.Entity;
import FairCom.Persistence.Annotations.ManyToMany;
import FairCom.Persistence.Annotations.ManyToOne;
import FairCom.Persistence.Annotations.OneToMany;
import FairCom.Persistence.Annotations.OneToOne;
import FairCom.Persistence.Annotations.Transient;
import FairCom.Persistence.EntityTable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.InvocationTargetException;
import java.security.ProtectionDomain;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.annotation.Annotation;

public class EntityTransformer
implements ClassFileTransformer {
    private ClassPool pool;

    @Override
    public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
        this.pool = ClassPool.getDefault();
        try {
            CtClass ctClass = this.pool.makeClass((InputStream)new ByteArrayInputStream(byArray), true);
            if (ctClass.hasAnnotation(Entity.class)) {
                boolean bl = false;
                if (ctClass.isFrozen()) {
                    bl = true;
                    ctClass.defrost();
                }
                byte[] byArray2 = this.instrumentEntityClass(ctClass);
                if (bl) {
                    ctClass.freeze();
                }
                return byArray2;
            }
            return byArray;
        }
        catch (IOException iOException) {
            Logger.getLogger(EntityTransformer.class.getName()).log(Level.SEVERE, null, iOException);
            throw new RuntimeException("Couldn't load class: " + string + " for checking the entity transformation.");
        }
        catch (RuntimeException runtimeException) {
            return byArray;
        }
    }

    private byte[] instrumentEntityClass(CtClass ctClass) throws IOException {
        CtField[] ctFieldArray = ctClass.getDeclaredFields();
        for (int i = 0; i < ctFieldArray.length; ++i) {
            if (ctFieldArray[i].hasAnnotation(Transient.class)) continue;
            this.instrumentEntityProp(ctFieldArray[i], ctClass);
        }
        try {
            return ctClass.toBytecode();
        }
        catch (CannotCompileException cannotCompileException) {
            Logger.getLogger(EntityTransformer.class.getName()).log(Level.SEVERE, null, cannotCompileException);
            throw new RuntimeException("Couldn't instrument class: " + ctClass.getName() + " for lazily fetch.");
        }
    }

    private void instrumentEntityProp(CtField ctField, CtClass ctClass) {
        if (this.isPropLazy(ctField)) {
            CtMethod ctMethod;
            if (!this.isEntityTableObjAdded(ctClass)) {
                try {
                    ctMethod = new CtField(this.pool.get(EntityTable.class.getName()), "_entTableObj", ctClass);
                    ctMethod.setModifiers(1);
                    FieldInfo fieldInfo = ctMethod.getFieldInfo();
                    AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations");
                    if (annotationsAttribute == null) {
                        annotationsAttribute = new AnnotationsAttribute(fieldInfo.getConstPool(), "RuntimeVisibleAnnotations");
                    }
                    ClassFile classFile = ctClass.getClassFile();
                    Annotation annotation = new Annotation(Transient.class.getName(), classFile.getConstPool());
                    annotationsAttribute.addAnnotation(annotation);
                    fieldInfo.addAttribute((AttributeInfo)annotationsAttribute);
                    ctClass.addField((CtField)ctMethod);
                }
                catch (NotFoundException notFoundException) {
                    Logger.getLogger(EntityTransformer.class.getName()).log(Level.SEVERE, null, notFoundException);
                    throw new RuntimeException("Couldn't load EntityTable class: " + ctClass.getName() + " from the class pool.");
                }
                catch (CannotCompileException cannotCompileException) {
                    Logger.getLogger(EntityTransformer.class.getName()).log(Level.SEVERE, null, cannotCompileException);
                    throw new RuntimeException("Couldn't add field _entTableObj in the class " + ctClass.getName() + " for lazy fetch instrumentation.");
                }
            }
            ctMethod = this.findGetter(ctField, ctClass);
            try {
                ctMethod.insertBefore("_entTableObj.Fetch(\"" + ctField.getName() + "\", this);");
            }
            catch (CannotCompileException cannotCompileException) {
                Logger.getLogger(EntityTransformer.class.getName()).log(Level.SEVERE, null, cannotCompileException);
                throw new RuntimeException("Couldn't add fetch call in the getter method: " + ctMethod.getName() + " in EntityTable class: " + ctClass.getName() + " for lazy fetch instrumentation.");
            }
        }
    }

    private boolean isPropLazy(CtField ctField) {
        try {
            if (ctField.hasAnnotation(OneToOne.class)) {
                return this.checkLazyFetchMode(ctField.getAnnotation(OneToOne.class));
            }
            if (ctField.hasAnnotation(OneToMany.class)) {
                return this.checkLazyFetchMode(ctField.getAnnotation(OneToMany.class));
            }
            if (ctField.hasAnnotation(ManyToOne.class)) {
                return this.checkLazyFetchMode(ctField.getAnnotation(ManyToOne.class));
            }
            if (ctField.hasAnnotation(ManyToMany.class)) {
                return this.checkLazyFetchMode(ctField.getAnnotation(ManyToMany.class));
            }
            if (ctField.hasAnnotation(Column.class)) {
                return this.checkLazyFetchMode(ctField.getAnnotation(Column.class));
            }
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(EntityTransformer.class.getName()).log(Level.SEVERE, null, classNotFoundException);
            throw new RuntimeException("Couldn't check if property: " + ctField.getName() + " is lazily fetched.");
        }
    }

    private CtMethod findGetter(CtField ctField, CtClass ctClass) {
        CtMethod ctMethod;
        String string = "get" + ctField.getName().substring(0, 1).toUpperCase() + ctField.getName().substring(1);
        CtClass[] ctClassArray = null;
        try {
            ctMethod = ctClass.getDeclaredMethod(string, ctClassArray);
        }
        catch (NotFoundException notFoundException) {
            Logger.getLogger(EntityTransformer.class.getName()).log(Level.SEVERE, null, notFoundException);
            throw new RuntimeException("Couldn't find getter for property: " + ctField.getName() + ".");
        }
        return ctMethod;
    }

    private boolean isEntityTableObjAdded(CtClass ctClass) {
        try {
            if (ctClass.getDeclaredField("_entTableObj") != null) {
                return true;
            }
        }
        catch (SecurityException securityException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, securityException);
            throw new RuntimeException("Couldn't check if the class: " + ctClass.getName() + " has already been instrumented.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    private boolean checkLazyFetchMode(Object object) {
        Object object2 = null;
        Object object3 = null;
        try {
            try {
                object2 = object.getClass().getDeclaredMethod("fetchMode", new Class[0]).invoke(object, new Object[0]);
                ClassLoader classLoader = object2.getClass().getClassLoader();
                Class<?> clazz = null;
                try {
                    clazz = classLoader.loadClass("FairCom.Persistence.Types.FetchMode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(EntityTransformer.class.getName()).log(Level.SEVERE, null, classNotFoundException);
                }
                try {
                    object3 = clazz.getDeclaredField("LAZY").get(null);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Logger.getLogger(EntityTransformer.class.getName()).log(Level.SEVERE, null, noSuchFieldException);
                }
                catch (SecurityException securityException) {
                    Logger.getLogger(EntityTransformer.class.getName()).log(Level.SEVERE, null, securityException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(EntityTransformer.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.getLogger(EntityTransformer.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.getLogger(EntityTransformer.class.getName()).log(Level.SEVERE, null, invocationTargetException);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger.getLogger(EntityTransformer.class.getName()).log(Level.SEVERE, null, noSuchMethodException);
        }
        catch (SecurityException securityException) {
            Logger.getLogger(EntityTransformer.class.getName()).log(Level.SEVERE, null, securityException);
        }
        return object2.equals(object3);
    }
}

