/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Persistence;

import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTField;
import FairCom.CtreeDb.CTResultSetCriteria;
import FairCom.Persistence.Annotations.Column;
import FairCom.Persistence.Annotations.Identity;
import FairCom.Persistence.EntityTable;
import FairCom.Persistence.Types.FetchMode;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

class EntityColumn {
    private CTField ctField;
    private String colName = "";
    private String propName;
    private Method getter;
    private Method setter;
    private CTResultSetCriteria resultSetCriteria = null;
    private FetchMode fetchMode;
    private Boolean identityField;

    EntityColumn(Class clazz, Field field, EntityTable entityTable) {
        this.initCol(clazz, field, entityTable, "");
    }

    EntityColumn(Class clazz, Field field, EntityTable entityTable, String string) {
        this.initCol(clazz, field, entityTable, string);
    }

    public String getColName() {
        return this.colName;
    }

    public CTField getCTField() {
        return this.ctField;
    }

    public Object getValue(Object object) {
        Object[] objectArray = null;
        try {
            if (object == null) {
                return null;
            }
            return this.getter.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(EntityColumn.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            throw new RuntimeException("Couldn't get value. Field: " + this.getColName(), illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(EntityColumn.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
            throw new RuntimeException("Couldn't get value. Field: " + this.getColName(), illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(EntityColumn.class.getName()).log(Level.SEVERE, null, invocationTargetException);
            throw new RuntimeException("Couldn't get value. Field: " + this.getColName(), invocationTargetException);
        }
    }

    public void setValue(Object object, Object object2) {
        try {
            this.setter.invoke(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(EntityColumn.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            throw new RuntimeException("Couldn't set value. Field: " + this.getColName(), illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(EntityColumn.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
            throw new RuntimeException("Couldn't set value. Field: " + this.getColName(), illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(EntityColumn.class.getName()).log(Level.SEVERE, null, invocationTargetException);
            throw new RuntimeException("Couldn't set value. Field: " + this.getColName(), invocationTargetException);
        }
    }

    public void setResultSetCriteria(CTResultSetCriteria cTResultSetCriteria) {
        this.resultSetCriteria = cTResultSetCriteria;
    }

    public CTResultSetCriteria getResultSetCriteria() {
        return this.resultSetCriteria;
    }

    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    public Method getGetter() {
        return this.getter;
    }

    private void findGetterSetter(Class clazz, Field field) {
        String string = "get" + this.propName.substring(0, 1).toUpperCase() + this.propName.substring(1);
        String string2 = "set" + this.propName.substring(0, 1).toUpperCase() + this.propName.substring(1);
        Class[] classArray = new Class[1];
        Class<?>[] classArray2 = null;
        classArray[0] = field.getType();
        try {
            this.setter = clazz.getMethod(string2, classArray);
            this.getter = clazz.getMethod(string, classArray2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger.getLogger(EntityColumn.class.getName()).log(Level.SEVERE, null, noSuchMethodException);
            throw new RuntimeException("Couldn't find getter/setter methods for property " + this.propName, noSuchMethodException);
        }
        catch (SecurityException securityException) {
            Logger.getLogger(EntityColumn.class.getName()).log(Level.SEVERE, null, securityException);
            throw new RuntimeException("Couldn't find getter/setter methods for property " + this.propName, securityException);
        }
    }

    private void findDBColumn(EntityTable entityTable) {
        try {
            this.ctField = entityTable.getCTTable().GetField(this.colName);
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityColumn.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't find the column " + this.colName + " for matching property " + this.propName, cTException);
        }
    }

    private void initCol(Class clazz, Field field, EntityTable entityTable, String string) {
        this.propName = field.getName();
        if (!string.isEmpty()) {
            this.colName = string;
        }
        if (!field.isAnnotationPresent(Column.class)) {
            if (this.colName.isEmpty()) {
                this.colName = this.propName;
            }
            this.fetchMode = FetchMode.EAGER;
        } else {
            Column column = field.getAnnotation(Column.class);
            if (this.colName.isEmpty()) {
                this.colName = column.name().isEmpty() ? this.propName : column.name();
            }
            this.fetchMode = column.fetchMode();
        }
        this.identityField = field.isAnnotationPresent(Identity.class) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.findGetterSetter(clazz, field);
        this.findDBColumn(entityTable);
    }

    boolean isIdentity() {
        return this.identityField;
    }
}

