/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Persistence;

import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTRecord;
import FairCom.CtreeDb.CTResultSet;
import FairCom.CtreeDb.CTResultSetCriteria;
import FairCom.CtreeDb.Types.CTDBRET;
import FairCom.Persistence.Annotations.Column;
import FairCom.Persistence.Annotations.ManyToMany;
import FairCom.Persistence.Annotations.ManyToOne;
import FairCom.Persistence.Annotations.OneToMany;
import FairCom.Persistence.Annotations.OneToOne;
import FairCom.Persistence.Annotations.Transient;
import FairCom.Persistence.EntityColumn;
import FairCom.Persistence.EntityException;
import FairCom.Persistence.EntityPK;
import FairCom.Persistence.EntityTable;
import FairCom.Persistence.Types.CascadeType;
import FairCom.Persistence.Types.FetchMode;
import FairCom.Persistence.Types.RelationType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class EntityFK {
    private RelationType relationMode;
    private String mappedBy;
    private CascadeType[] cascadeType;
    private EntityTable entityTable;
    private EntityTable foreignTable;
    private HashMap hashEntityField = new HashMap();
    private Class foreignPKClass;
    private Class foreignEntClass;
    private Constructor entPKDefConstructor = null;
    private Method getter;
    private Method setter;
    private CTResultSet resultSet = null;
    private Class fieldType;
    private String fieldName;
    private FetchMode fetchMode;

    EntityFK(Class clazz, Field field, EntityTable entityTable, boolean bl) throws EntityException {
        this.initFK(clazz, field, entityTable, bl);
    }

    EntityFK(Class clazz, Field field, EntityTable entityTable) throws EntityException {
        this.initFK(clazz, field, entityTable, false);
    }

    private void checkRelAnnotations(Field field, boolean bl) {
        if (field.isAnnotationPresent(OneToOne.class)) {
            this.relationMode = RelationType.ONETOONE;
            OneToOne oneToOne = field.getAnnotation(OneToOne.class);
            this.mappedBy = oneToOne.mappedBy();
            this.cascadeType = oneToOne.cascade();
            this.fetchMode = oneToOne.fetchMode();
        } else if (field.isAnnotationPresent(OneToMany.class)) {
            this.relationMode = RelationType.ONETOMANY;
            OneToMany oneToMany = field.getAnnotation(OneToMany.class);
            this.mappedBy = oneToMany.mappedBy();
            this.cascadeType = oneToMany.cascade();
            this.fetchMode = oneToMany.fetchMode();
        } else if (field.isAnnotationPresent(ManyToOne.class)) {
            this.relationMode = RelationType.MANYTOONE;
            ManyToOne manyToOne = field.getAnnotation(ManyToOne.class);
            this.mappedBy = manyToOne.mappedBy();
            this.cascadeType = manyToOne.cascade();
            this.fetchMode = manyToOne.fetchMode();
        } else if (field.isAnnotationPresent(ManyToMany.class)) {
            this.relationMode = RelationType.MANYTOMANY;
            ManyToMany manyToMany = field.getAnnotation(ManyToMany.class);
            this.mappedBy = manyToMany.mappedBy();
            this.cascadeType = manyToMany.cascade();
            this.fetchMode = manyToMany.fetchMode();
        } else {
            throw new RuntimeException("Couldn't find relationship annotation in property " + field.getName());
        }
        if (bl && this.fetchMode == FetchMode.LAZY) {
            throw new RuntimeException("Lazy fetching is not supported on a Primary Key - " + field.getName());
        }
    }

    private void findGetterSetter(Class clazz, Field field) {
        String string = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        String string2 = "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        Class[] classArray = new Class[1];
        Class<?>[] classArray2 = null;
        classArray[0] = field.getType();
        try {
            this.setter = clazz.getMethod(string2, classArray);
            this.getter = clazz.getMethod(string, classArray2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger.getLogger(EntityColumn.class.getName()).log(Level.SEVERE, null, noSuchMethodException);
            throw new RuntimeException("Couldn't find getter/setter methods for property " + field.getName(), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            Logger.getLogger(EntityColumn.class.getName()).log(Level.SEVERE, null, securityException);
            throw new RuntimeException("Couldn't find getter/setter methods for property " + field.getName(), securityException);
        }
    }

    public void getValue(Object object, CTRecord cTRecord, boolean bl, int n) {
        Object[] objectArray = null;
        try {
            if (!this.isRelOwner()) {
                Object object2;
                Collection collection;
                Object object3;
                if (this.setter.getParameterTypes()[0] == Set.class) {
                    if (bl) {
                        object3 = new HashSet();
                        this.setter.invoke(object, object3);
                    } else {
                        Object[] objectArray2 = null;
                        object3 = (Set)this.getter.invoke(object, objectArray2);
                        if (object3 == null) {
                            object3 = new HashSet();
                            this.setter.invoke(object, object3);
                        }
                    }
                    collection = object3;
                } else {
                    if (bl) {
                        object3 = new ArrayList();
                        this.setter.invoke(object, object3);
                    } else {
                        Object[] objectArray3 = null;
                        object3 = (List)this.getter.invoke(object, objectArray3);
                        if (object3 == null) {
                            object3 = new ArrayList();
                            this.setter.invoke(object, object3);
                        }
                    }
                    collection = object3;
                }
                object3 = this.setFilterForeignRecords(object);
                if (this.relationMode == RelationType.ONETOONE) {
                    object2 = this.foreignTable.getResultList(1, (CTRecord)object3, n);
                } else if (this.relationMode == RelationType.ONETOMANY) {
                    object2 = this.foreignTable.getResultList(0, (CTRecord)object3, n);
                } else {
                    throw new RuntimeException("Invalid relation mode " + (Object)((Object)this.relationMode));
                }
                if (this.setter.getParameterTypes()[0] == Set.class) {
                    ((Set)collection).addAll((Collection)object2);
                } else {
                    ((List)collection).addAll((Collection)object2);
                }
            } else {
                Object object4;
                if (this.foreignTable.isPKComposite()) {
                    Object t = this.getEntDefConstrutor().newInstance(objectArray);
                    Collection collection = this.hashEntityField.values();
                    for (EntityColumn entityColumn : collection) {
                        Object object5 = this.entityTable.getFieldValue(entityColumn, cTRecord);
                        entityColumn.setValue(t, object5);
                    }
                    object4 = this.foreignTable.getByPK(t, n);
                } else {
                    EntityColumn entityColumn = (EntityColumn)this.hashEntityField.values().toArray()[0];
                    Object object6 = this.entityTable.getFieldValue(entityColumn, cTRecord);
                    object4 = this.foreignTable.getByPK(object6, n);
                }
                this.setter.invoke(object, object4);
            }
        }
        catch (InstantiationException instantiationException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, instantiationException);
            throw new RuntimeException("Couldn't create instance for entity class: " + this.foreignPKClass.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            throw new RuntimeException("Couldn't create instance for entity class: " + this.foreignPKClass.getName(), illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
            throw new RuntimeException("Couldn't create instance for entity class: " + this.foreignPKClass.getName(), illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, invocationTargetException);
            throw new RuntimeException("Couldn't create instance for entity class: " + this.foreignPKClass.getName(), invocationTargetException);
        }
    }

    public void getValue(Object object, CTRecord cTRecord, int n) {
        this.getValue(object, cTRecord, false, n);
    }

    public void setValue(Object object, CTRecord cTRecord, int n) {
        block11: {
            Object object2;
            block10: {
                block12: {
                    Object[] objectArray = null;
                    try {
                        object2 = this.getter.invoke(object, objectArray);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Logger.getLogger(EntityPK.class.getName()).log(Level.SEVERE, null, illegalAccessException);
                        throw new RuntimeException("Couldn't retrieve the primary key object from the entity instance", illegalAccessException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Logger.getLogger(EntityPK.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
                        throw new RuntimeException("Couldn't retrieve the primary key object from the entity instance", illegalArgumentException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Logger.getLogger(EntityPK.class.getName()).log(Level.SEVERE, null, invocationTargetException);
                        throw new RuntimeException("Couldn't retrieve the primary key object from the entity instance", invocationTargetException);
                    }
                    if (this.isRelOwner()) break block10;
                    if (object2 == null || !this.isPersistCascade()) break block11;
                    if (this.relationMode != RelationType.ONETOONE) break block12;
                    this.foreignTable.persist(object2, n);
                    break block11;
                }
                if (this.relationMode != RelationType.ONETOMANY) break block11;
                if (object2.getClass() == HashSet.class) {
                    Set set = (Set)object2;
                    for (Object e : set) {
                        this.foreignTable.persist(e, n);
                    }
                } else {
                    List list = (List)object2;
                    for (int i = 0; i < list.size(); ++i) {
                        this.foreignTable.persist(list.get(i), n);
                    }
                }
                break block11;
            }
            Collection collection = this.hashEntityField.values();
            Iterator iterator = collection.iterator();
            Object object3 = null;
            while (iterator.hasNext()) {
                EntityColumn entityColumn = (EntityColumn)iterator.next();
                if (object3 == null) {
                    object3 = this.foreignTable.isPKComposite() ? this.foreignTable.getPKValue(object2) : object2;
                }
                this.entityTable.setFieldValue(object3, entityColumn, cTRecord);
            }
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public HashMap getHashEntityField() {
        return this.hashEntityField;
    }

    public Class getFieldType() {
        return this.fieldType;
    }

    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    public Method getGetter() {
        return this.getter;
    }

    public void remove(Object object) {
        if (this.isRemoveCascade()) {
            Object object2;
            Object[] objectArray = null;
            try {
                object2 = this.getter.invoke(object, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(EntityPK.class.getName()).log(Level.SEVERE, null, illegalAccessException);
                throw new RuntimeException("Couldn't retrieve the foreign entity object for removing", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.getLogger(EntityPK.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
                throw new RuntimeException("Couldn't retrieve the foreign entity object for removing", illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.getLogger(EntityPK.class.getName()).log(Level.SEVERE, null, invocationTargetException);
                throw new RuntimeException("Couldn't retrieve the foreign entity object for removing", invocationTargetException);
            }
            if (!this.isRelOwner() && object2 != null) {
                if (this.relationMode == RelationType.ONETOONE) {
                    this.foreignTable.remove(object2);
                } else if (this.relationMode == RelationType.ONETOMANY) {
                    List list = (List)object2;
                    for (int i = 0; i < list.size(); ++i) {
                        this.foreignTable.remove(list.get(i));
                    }
                }
            }
        }
    }

    private boolean isPersistCascade() {
        for (int i = 0; i < this.cascadeType.length; ++i) {
            if (this.cascadeType[i] != CascadeType.ALL && this.cascadeType[i] != CascadeType.PERSIST) continue;
            return true;
        }
        return false;
    }

    private void mapField(Field field, String string) {
        EntityColumn entityColumn = new EntityColumn(this.foreignEntClass, field, this.entityTable, string);
        this.hashEntityField.put(field.getName(), entityColumn);
    }

    private boolean isRelOwner() {
        return this.mappedBy.isEmpty();
    }

    private Constructor getEntDefConstrutor() {
        if (this.entPKDefConstructor != null) {
            return this.entPKDefConstructor;
        }
        Class<?>[] classArray = null;
        try {
            this.entPKDefConstructor = this.foreignEntClass.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, noSuchMethodException);
            throw new RuntimeException("Couldn't retrieve default constructor for class: " + this.foreignEntClass.getName(), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, securityException);
            throw new RuntimeException("Couldn't retrieve default constructor for class: " + this.foreignEntClass.getName(), securityException);
        }
        return this.entPKDefConstructor;
    }

    private CTRecord setFilterForeignRecords(Object object) {
        try {
            CTRecord cTRecord = this.foreignTable.getCTRecord();
            Collection collection = this.hashEntityField.values();
            for (EntityColumn entityColumn : collection) {
                CTResultSetCriteria cTResultSetCriteria = entityColumn.getResultSetCriteria();
                Object object2 = this.foreignTable.isPKComposite() ? this.foreignTable.getPKValue(object) : object;
                Object object3 = entityColumn.getValue(object2);
                if (object3 == null) {
                    cTResultSetCriteria.setLowValue("");
                    continue;
                }
                cTResultSetCriteria.setLowValue(object3.toString());
            }
            this.resultSet.SetOnOff(cTRecord, true, true, 0);
            return cTRecord;
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityFK.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't turn ON the result set filter in the foreign table " + this.foreignTable.getTableName(), cTException);
        }
        catch (Exception exception) {
            Logger.getLogger(EntityFK.class.getName()).log(Level.SEVERE, null, exception);
            throw new RuntimeException("Couldn't turn ON the result set filter in the foreign table " + this.foreignTable.getTableName(), exception);
        }
    }

    private boolean isRemoveCascade() {
        for (int i = 0; i < this.cascadeType.length; ++i) {
            if (this.cascadeType[i] != CascadeType.ALL && this.cascadeType[i] != CascadeType.REMOVE) continue;
            return true;
        }
        return false;
    }

    private void initFK(Class clazz, Field field, EntityTable entityTable, boolean bl) throws EntityException {
        Class clazz2 = clazz;
        if ((bl || entityTable.isFieldPK(field)) && entityTable.isPKComposite()) {
            clazz2 = entityTable.getPKClass();
        }
        this.entityTable = entityTable;
        this.fieldName = field.getName();
        this.fieldType = null;
        this.fieldType = field.getType().equals(List.class) || field.getType().equals(Set.class) ? (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0] : field.getType();
        this.foreignTable = entityTable.getTableManager().getEntityTable(this.fieldType);
        this.checkRelAnnotations(field, bl);
        Field[] fieldArray = this.foreignTable.getPKFieldList();
        this.foreignPKClass = this.foreignTable.getPKClass();
        this.foreignEntClass = fieldArray.length > 1 ? this.foreignPKClass : this.foreignTable.getEntClass();
        if (this.isRelOwner()) {
            Object object;
            String[] stringArray = null;
            if (field.isAnnotationPresent(Column.class)) {
                object = field.getAnnotation(Column.class);
                stringArray = fieldArray.length == 1 ? new String[]{object.name()} : object.names();
            }
            if (stringArray != null && stringArray.length > 0 && stringArray.length != fieldArray.length) {
                throw new RuntimeException("Property \"names\" in Column annotation in field " + field.getName() + " must match the foreign key with table " + this.foreignTable.getTableName());
            }
            for (int i = 0; i < fieldArray.length; ++i) {
                object = stringArray != null && stringArray.length > 0 ? stringArray[i] : "";
                if (fieldArray[i].isAnnotationPresent(Transient.class)) continue;
                this.mapField(fieldArray[i], (String)object);
            }
        } else {
            try {
                try {
                    this.resultSet = this.foreignTable.getCTTable().GetResultSetByName(this.foreignTable.getTableName() + "_" + this.entityTable.getTableName());
                }
                catch (CTException cTException) {
                    if (cTException.GetErrorCode() == (long)CTDBRET.NULHANDLE.getErrno()) {
                        this.resultSet = this.foreignTable.getCTTable().CreateResultSet(this.foreignTable.getTableName() + "_" + this.entityTable.getTableName());
                    }
                    throw new CTException((int)cTException.GetErrorCode(), cTException.GetErrorMsg());
                }
                this.hashEntityField = this.foreignTable.getFKEntColList(this.mappedBy);
                if (this.foreignTable.getFKFieldType(this.mappedBy) != clazz) {
                    throw new RuntimeException("Invalid map. Trying to map foreign field of type " + this.foreignTable.getFKFieldType(this.mappedBy).getName() + " to the entity of type " + clazz.getName());
                }
                Collection collection = this.hashEntityField.values();
                for (EntityColumn entityColumn : collection) {
                    CTResultSetCriteria cTResultSetCriteria = new CTResultSetCriteria(entityColumn.getCTField(), null, null, 193);
                    this.resultSet.AddCriteria(cTResultSetCriteria);
                    entityColumn.setResultSetCriteria(cTResultSetCriteria);
                }
            }
            catch (CTException cTException) {
                Logger.getLogger(EntityFK.class.getName()).log(Level.SEVERE, null, cTException);
                throw new RuntimeException("Couldn't set the result set criteria for field " + field.getName(), cTException);
            }
        }
        this.findGetterSetter(clazz2, field);
    }
}

