/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Persistence;

import FairCom.CtreeDb.CTDatabase;
import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTSession;
import FairCom.Persistence.EntityManager;
import FairCom.Persistence.EntityNamedQuery;
import FairCom.Persistence.EntityQuery;
import FairCom.Persistence.EntityTableManager;
import FairCom.Persistence.PersistenceConfig;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

class EntityManagerImpl
implements EntityManager {
    private CTSession ctSession;
    private CTDatabase ctDB;
    private EntityTableManager tableManager;
    private Collection entityClasses;
    private final int MAX_DEF_CACHE_SIZE = 100;

    public EntityManagerImpl(PersistenceConfig persistenceConfig) {
        try {
            this.connect(persistenceConfig);
            this.tableManager = new EntityTableManager(this.ctDB, persistenceConfig.getClassLoader(), persistenceConfig.getDefMaxCacheSize());
            this.entityClasses = persistenceConfig.getClasses();
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityManagerImpl.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't connect to the ctree using JTDB", cTException);
        }
    }

    public EntityManagerImpl(PersistenceConfig persistenceConfig, CTDatabase cTDatabase) {
        this.ctDB = cTDatabase;
        this.tableManager = new EntityTableManager(this.ctDB, persistenceConfig.getClassLoader(), persistenceConfig.getDefMaxCacheSize());
        this.entityClasses = persistenceConfig.getClasses();
    }

    public EntityManagerImpl(CTDatabase cTDatabase, Collection collection, ClassLoader classLoader) {
        this.tableManager = new EntityTableManager(this.ctDB, classLoader, 100);
        this.entityClasses = collection;
    }

    @Override
    public void close() {
        try {
            this.disconnect();
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityManagerImpl.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't disconnect from the ctree using JTDB", cTException);
        }
    }

    @Override
    public void beginTransaction() {
        try {
            this.ctDB.Begin();
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityManagerImpl.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't begin transaction using JTDB", cTException);
        }
    }

    @Override
    public void commitTransaction() {
        try {
            this.ctDB.Commit();
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityManagerImpl.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't commit transaction using JTDB", cTException);
        }
    }

    @Override
    public void abortTransaction() {
        try {
            this.ctDB.Abort();
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityManagerImpl.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't abort transaction using JTDB", cTException);
        }
    }

    @Override
    public void remove(Object object) {
        this.tableManager.remove(object);
    }

    @Override
    public void persist(Object object, int n) {
        this.tableManager.persist(object, n);
    }

    @Override
    public void persist(Object object) {
        this.persist(object, 0);
    }

    @Override
    public Object getResultList(String string, String string2, int n) {
        try {
            return this.tableManager.getResultList(this.getFullEntClassName(string), string2, n);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(EntityManagerImpl.class.getName()).log(Level.SEVERE, null, classNotFoundException);
            throw new RuntimeException("Invalid EntityName: " + string, classNotFoundException);
        }
    }

    @Override
    public Object getResultList(String string, String string2) {
        return this.getResultList(string, string2, 0);
    }

    @Override
    public Object getResultList(String string, int n) {
        return this.getResultList(string, "", n);
    }

    @Override
    public Object getResultList(String string) {
        return this.getResultList(string, "", 0);
    }

    @Override
    public EntityNamedQuery getNamedQuery(String string) {
        int n = string.indexOf(".");
        if (n < 0) {
            throw new RuntimeException("Invalid NamedQuery name: " + string + ". It should be in the following format <entity class name>.<named query>");
        }
        String string2 = string.substring(0, n);
        try {
            return this.tableManager.getNamedQuery(this.getFullEntClassName(string2), string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(EntityManagerImpl.class.getName()).log(Level.SEVERE, null, classNotFoundException);
            throw new RuntimeException("Couldn't retrieve NamedQuery: " + string, classNotFoundException);
        }
    }

    @Override
    public EntityQuery getQuery(String string, String string2, String string3) {
        try {
            return this.tableManager.getQuery(this.getFullEntClassName(string), string2, string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(EntityManagerImpl.class.getName()).log(Level.SEVERE, null, classNotFoundException);
            throw new RuntimeException("Couldn't create Query", classNotFoundException);
        }
    }

    @Override
    public EntityQuery getQuery(String string, String string2) {
        return this.getQuery(string, string2, "");
    }

    @Override
    public Object getByPK(String string, Object object, int n) {
        try {
            return this.tableManager.getByPK(this.getFullEntClassName(string), object, n);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(EntityManagerImpl.class.getName()).log(Level.SEVERE, null, classNotFoundException);
            throw new RuntimeException("Couldn't retrieve an entity by the primary key", classNotFoundException);
        }
    }

    @Override
    public Object getByPK(String string, Object object) {
        return this.getByPK(string, object, 0);
    }

    @Override
    public void lock(String string, Object object, int n) {
        try {
            this.tableManager.lock(this.getFullEntClassName(string), object, n);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(EntityManagerImpl.class.getName()).log(Level.SEVERE, null, classNotFoundException);
            throw new RuntimeException("Invalid EntityName: " + string, classNotFoundException);
        }
    }

    @Override
    public void lock(Object object, int n) {
        this.tableManager.lock(object, n);
    }

    @Override
    public void unlock(String string, Object object) {
        try {
            this.tableManager.unlock(this.getFullEntClassName(string), object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(EntityManagerImpl.class.getName()).log(Level.SEVERE, null, classNotFoundException);
            throw new RuntimeException("Invalid EntityName: " + string, classNotFoundException);
        }
    }

    @Override
    public void unlock(Object object) {
        this.tableManager.unlock(object);
    }

    @Override
    public void unlockAll(String string) {
        try {
            this.tableManager.unlockAll(this.getFullEntClassName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(EntityManagerImpl.class.getName()).log(Level.SEVERE, null, classNotFoundException);
            throw new RuntimeException("Invalid EntityName: " + string, classNotFoundException);
        }
    }

    @Override
    public void unlockAll() {
        this.tableManager.unlockAll();
    }

    private void connect(PersistenceConfig persistenceConfig) throws CTException {
        this.ctSession = new CTSession(persistenceConfig.getSessionType());
        this.ctDB = new CTDatabase(this.ctSession);
        String string = persistenceConfig.getServerName() + "@" + persistenceConfig.getServerAddress();
        this.ctSession.Logon(string, persistenceConfig.getUser(), persistenceConfig.getPassword());
        this.ctDB.Connect(persistenceConfig.getDatabase());
    }

    private void disconnect() throws CTException {
        this.ctDB.Disconnect();
        this.ctSession.Logoff();
    }

    private String getFullEntClassName(String string) {
        for (String string2 : this.entityClasses) {
            if (!string2.endsWith(string)) continue;
            return string2;
        }
        return string;
    }
}

