/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Persistence;

import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTIndex;
import FairCom.CtreeDb.CTRecord;
import FairCom.Persistence.Annotations.Column;
import FairCom.Persistence.Annotations.ManyToMany;
import FairCom.Persistence.Annotations.ManyToOne;
import FairCom.Persistence.Annotations.OneToMany;
import FairCom.Persistence.Annotations.OneToOne;
import FairCom.Persistence.Annotations.PK;
import FairCom.Persistence.Annotations.Transient;
import FairCom.Persistence.EntityColumn;
import FairCom.Persistence.EntityError;
import FairCom.Persistence.EntityException;
import FairCom.Persistence.EntityFK;
import FairCom.Persistence.EntityTable;
import FairCom.Persistence.Types.FetchMode;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class EntityPK {
    private Method getter;
    private Method setter;
    private CTIndex ctPKIdx;
    private HashMap hashEntityField = new HashMap();
    private HashMap hashRelationField = new HashMap();
    private EntityTable entityTable;
    private Class entPKClass;
    private Constructor entPKDefConstructor = null;
    private boolean isComposite = false;
    private Field[] fieldList;
    private boolean checkPKIndex = true;

    EntityPK(Class clazz, Field field, EntityTable entityTable) {
        FetchMode fetchMode = null;
        this.entityTable = entityTable;
        if (field.getType().isAnnotationPresent(PK.class)) {
            this.isComposite = true;
            try {
                try {
                    this.entPKClass = Class.forName(field.getType().getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ClassLoader classLoader = entityTable.getSecClassLoader();
                    if (classLoader != null) {
                        this.entPKClass = classLoader.loadClass(field.getType().getName());
                    }
                    throw classNotFoundException;
                }
                this.fieldList = this.entPKClass.getDeclaredFields();
                for (int i = 0; i < this.fieldList.length; ++i) {
                    if (this.fieldList[i].isAnnotationPresent(Transient.class)) continue;
                    this.mapField(this.entPKClass, this.fieldList[i], false);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(EntityPK.class.getName()).log(Level.SEVERE, null, classNotFoundException);
                throw new RuntimeException("Couldn't find the primary key class " + field.getType().getName(), classNotFoundException);
            }
            this.findGetterSetter(clazz, field);
            if (field.isAnnotationPresent(Column.class)) {
                Column column = field.getAnnotation(Column.class);
                fetchMode = column.fetchMode();
            }
        } else {
            this.fieldList = new Field[1];
            this.fieldList[0] = field;
            this.entPKClass = field.getType();
            EntityColumn entityColumn = new EntityColumn(clazz, field, entityTable);
            this.hashEntityField.put(field.getName(), entityColumn);
            fetchMode = entityColumn.getFetchMode();
        }
        if (fetchMode == FetchMode.LAZY) {
            throw new RuntimeException("Lazy fetching is not supported on a Primary Key - " + field.getName());
        }
        if (this.checkPKIndex) {
            this.ctPKIdx = entityTable.getIndexByColumns(this.hashEntityField.values());
            if (this.ctPKIdx == null) {
                throw new RuntimeException("Couldn't find primary key index in table " + this.entityTable.getTableName() + " in JTDB");
            }
        }
    }

    public void setValue(Object object, CTRecord cTRecord, int n) {
        if (this.isComposite) {
            Object object2;
            Object[] objectArray = null;
            try {
                object2 = this.getter.invoke(object, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(EntityPK.class.getName()).log(Level.SEVERE, null, illegalAccessException);
                throw new RuntimeException("Couldn't retrieve the primary key object from the entity instance", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.getLogger(EntityPK.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
                throw new RuntimeException("Couldn't retrieve the primary key object from the entity instance", illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.getLogger(EntityPK.class.getName()).log(Level.SEVERE, null, invocationTargetException);
                throw new RuntimeException("Couldn't retrieve the primary key object from the entity instance", invocationTargetException);
            }
            this.setPKValue(object2, cTRecord, n);
        } else {
            this.entityTable.setFieldValue(object, (EntityColumn)this.hashEntityField.values().toArray()[0], cTRecord);
        }
    }

    public void setPKValue(Object object, CTRecord cTRecord, int n) {
        if (this.isComposite) {
            Collection collection = this.hashEntityField.values();
            for (EntityColumn entityColumn : collection) {
                this.entityTable.setFieldValue(object, entityColumn, cTRecord);
            }
            Collection collection2 = this.hashRelationField.values();
            for (EntityFK entityFK : collection2) {
                entityFK.setValue(object, cTRecord, n);
            }
        } else {
            this.entityTable.setFieldValueObj(object, (EntityColumn)this.hashEntityField.values().toArray()[0], cTRecord);
        }
    }

    public Object getValue(CTRecord cTRecord, int n) {
        Object object;
        if (this.isComposite) {
            Object[] objectArray = null;
            try {
                object = this.getEntDefConstrutor().newInstance(objectArray);
                Collection collection = this.hashEntityField.values();
                for (EntityColumn entityColumn : collection) {
                    Object object2 = this.entityTable.getFieldValue(entityColumn, cTRecord);
                    entityColumn.setValue(object, object2);
                }
                Collection collection2 = this.hashRelationField.values();
                for (EntityFK entityFK : collection2) {
                    entityFK.getValue(object, cTRecord, n);
                }
            }
            catch (InstantiationException instantiationException) {
                Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, instantiationException);
                throw new RuntimeException("Couldn't create instance for entity class: " + this.entPKClass.getName(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, illegalAccessException);
                throw new RuntimeException("Couldn't create instance for entity class: " + this.entPKClass.getName(), illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
                throw new RuntimeException("Couldn't create instance for entity class: " + this.entPKClass.getName(), illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, invocationTargetException);
                throw new RuntimeException("Couldn't create instance for entity class: " + this.entPKClass.getName(), invocationTargetException);
            }
        } else {
            EntityColumn entityColumn = (EntityColumn)this.hashEntityField.values().toArray()[0];
            object = this.entityTable.getFieldValue(entityColumn, cTRecord);
        }
        return object;
    }

    public Object getValue(Object object) {
        Object object2;
        Object[] objectArray = null;
        try {
            object2 = this.getter.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(EntityPK.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            throw new RuntimeException("Couldn't retrieve the primary key object from the entity instance", illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(EntityPK.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
            throw new RuntimeException("Couldn't retrieve the primary key object from the entity instance", illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(EntityPK.class.getName()).log(Level.SEVERE, null, invocationTargetException);
            throw new RuntimeException("Couldn't retrieve the primary key object from the entity instance", invocationTargetException);
        }
        return object2;
    }

    public void storeValue(Object object, Object object2) {
        if (this.isComposite) {
            try {
                this.setter.invoke(object, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(EntityPK.class.getName()).log(Level.SEVERE, null, illegalAccessException);
                throw new RuntimeException("Couldn't storedValue for entity class: " + this.entPKClass.getName(), illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.getLogger(EntityPK.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
                throw new RuntimeException("Couldn't storedValue for entity class: " + this.entPKClass.getName(), illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.getLogger(EntityPK.class.getName()).log(Level.SEVERE, null, invocationTargetException);
                throw new RuntimeException("Couldn't storedValue for entity class: " + this.entPKClass.getName(), invocationTargetException);
            }
        } else {
            EntityColumn entityColumn = (EntityColumn)this.hashEntityField.values().toArray()[0];
            entityColumn.setValue(object, object2);
        }
    }

    public CTIndex getCtPKIdx() {
        return this.ctPKIdx;
    }

    public boolean isComposite() {
        return this.isComposite;
    }

    public Field[] getPKFieldList() {
        return this.fieldList;
    }

    public Class getPKClass() {
        return this.entPKClass;
    }

    public void checkFK(Field field) {
        if (field.getType().isAnnotationPresent(PK.class)) {
            for (int i = 0; i < this.fieldList.length; ++i) {
                if (this.fieldList[i].isAnnotationPresent(Transient.class)) continue;
                this.mapField(this.entPKClass, this.fieldList[i], true);
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.hashEntityField.values());
            Collection collection = this.hashRelationField.values();
            for (EntityFK entityFK : collection) {
                arrayList.addAll(entityFK.getHashEntityField().values());
            }
            this.ctPKIdx = this.entityTable.getIndexByColumns(arrayList);
        } else {
            this.mapField(this.entPKClass, field, true);
        }
    }

    public boolean hasField(Field field) {
        return this.hashEntityField.containsKey(field.getName());
    }

    public void setFK(Field field) {
        EntityFK entityFK;
        try {
            entityFK = new EntityFK(this.entityTable.getEntClass(), field, this.entityTable, true);
        }
        catch (EntityException entityException) {
            if (entityException.GetErrorCode().equals(EntityError.FKMIS)) {
                this.entityTable.addPendingField(field);
                return;
            }
            throw new RuntimeException("Couldn't set Foreign Key field for " + field.getName(), entityException);
        }
        if (this.hashRelationField.get(field.getName()) == null) {
            this.hashRelationField.put(field.getName(), entityFK);
        }
    }

    public Collection getFKList() {
        return this.hashRelationField.values();
    }

    public int getIndex() {
        try {
            return this.ctPKIdx.GetNumber();
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityPK.class.getName()).log(Level.SEVERE, null, cTException);
            return 0;
        }
    }

    private void mapField(Class clazz, Field field, boolean bl) {
        if (field.isAnnotationPresent(OneToOne.class) || field.isAnnotationPresent(OneToMany.class) || field.isAnnotationPresent(ManyToOne.class) || field.isAnnotationPresent(ManyToMany.class)) {
            if (bl) {
                this.setFK(field);
            } else {
                this.checkPKIndex = false;
            }
        } else if (!bl) {
            EntityColumn entityColumn = new EntityColumn(clazz, field, this.entityTable);
            this.hashEntityField.put(field.getName(), entityColumn);
            if (entityColumn.getFetchMode() == FetchMode.LAZY) {
                throw new RuntimeException("Lazy fetching is not supported on a Primary Key - " + field.getName());
            }
        }
    }

    private Constructor getEntDefConstrutor() {
        if (this.entPKDefConstructor != null) {
            return this.entPKDefConstructor;
        }
        Class<?>[] classArray = null;
        try {
            this.entPKDefConstructor = this.entPKClass.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, noSuchMethodException);
            throw new RuntimeException("Couldn't retrieve default constructor for class: " + this.entPKClass.getName(), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, securityException);
            throw new RuntimeException("Couldn't retrieve default constructor for class: " + this.entPKClass.getName(), securityException);
        }
        return this.entPKDefConstructor;
    }

    private void findGetterSetter(Class clazz, Field field) {
        String string = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        String string2 = "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        Class[] classArray = new Class[1];
        Class<?>[] classArray2 = null;
        classArray[0] = field.getType();
        try {
            this.setter = clazz.getMethod(string2, classArray);
            this.getter = clazz.getMethod(string, classArray2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger.getLogger(EntityColumn.class.getName()).log(Level.SEVERE, null, noSuchMethodException);
            throw new RuntimeException("Couldn't find getter/setter methods for property " + field.getName(), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            Logger.getLogger(EntityColumn.class.getName()).log(Level.SEVERE, null, securityException);
            throw new RuntimeException("Couldn't find getter/setter methods for property " + field.getName(), securityException);
        }
    }

    void getIdentValues(Object object, CTRecord cTRecord) {
        Collection collection = this.hashEntityField.values();
        for (EntityColumn entityColumn : collection) {
            if (!entityColumn.isIdentity()) continue;
            entityColumn.setValue(object, this.getValue(cTRecord, 6));
        }
    }
}

