/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Persistence;

import FairCom.CtreeDb.CTRecord;
import FairCom.CtreeDb.CTTable;
import FairCom.Persistence.EntityRecordFactory;
import java.io.Serializable;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

class EntityRecordPool
implements Serializable {
    private static final int POOL_SIZE = 12;
    private GenericObjectPool recordPool;

    public EntityRecordPool(CTTable cTTable) {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxActive = 12;
        config.maxIdle = 12;
        this.recordPool = new GenericObjectPool((PoolableObjectFactory)new EntityRecordFactory(cTTable), config);
    }

    public CTRecord getRecord() throws Exception {
        CTRecord cTRecord = (CTRecord)this.recordPool.borrowObject();
        return cTRecord;
    }

    public void releaseRecord(CTRecord cTRecord) throws Exception {
        this.recordPool.returnObject((Object)cTRecord);
    }
}

