/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Persistence;

import FairCom.CtreeDb.CTDatabase;
import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTField;
import FairCom.CtreeDb.CTIndex;
import FairCom.CtreeDb.CTRecord;
import FairCom.CtreeDb.CTResultSet;
import FairCom.CtreeDb.CTTable;
import FairCom.Persistence.Annotations.ID;
import FairCom.Persistence.Annotations.Index;
import FairCom.Persistence.Annotations.Indexes;
import FairCom.Persistence.Annotations.ManyToMany;
import FairCom.Persistence.Annotations.ManyToOne;
import FairCom.Persistence.Annotations.NamedQueries;
import FairCom.Persistence.Annotations.NamedQuery;
import FairCom.Persistence.Annotations.OneToMany;
import FairCom.Persistence.Annotations.OneToOne;
import FairCom.Persistence.Annotations.Table;
import FairCom.Persistence.Annotations.Transient;
import FairCom.Persistence.EntityColumn;
import FairCom.Persistence.EntityError;
import FairCom.Persistence.EntityException;
import FairCom.Persistence.EntityFK;
import FairCom.Persistence.EntityIndex;
import FairCom.Persistence.EntityNamedQuery;
import FairCom.Persistence.EntityPK;
import FairCom.Persistence.EntityQuery;
import FairCom.Persistence.EntityRecordPool;
import FairCom.Persistence.EntityTableManager;
import FairCom.Persistence.Types.FetchMode;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.annotation.Annotation;

public class EntityTable
implements Serializable {
    private CTTable ctTable;
    private EntityRecordPool ctRecPool;
    private Class entClass;
    private Constructor entDefConstructor = null;
    private String tableName;
    private String entityName;
    private EntityTableManager entityTableMgr;
    private EntityPK primaryKey = null;
    private HashMap hashEntityField = new HashMap();
    private HashMap hashEntityIndex = new HashMap();
    private HashMap hashNamedQuery = new HashMap();
    private HashMap hashRelationField = new HashMap();
    private LinkedHashMap hashEntityObj;
    private List pendingField = new ArrayList();
    private boolean lazilyFetch = false;
    private boolean alreadyInstrumented = false;
    private boolean persisting = false;
    private int maxCacheSize;
    private boolean newRec = false;
    private boolean instrumented = false;

    EntityTable(CTDatabase cTDatabase, Class clazz, EntityTableManager entityTableManager) {
        this.maxCacheSize = entityTableManager.getDefMaxCache();
        this.entClass = clazz;
        this.entityTableMgr = entityTableManager;
        this.entityName = this.getEntityShortName(this.entClass.getName());
        if (!this.entClass.isAnnotationPresent(Table.class)) {
            this.tableName = this.entityName;
        } else {
            Table table = this.entClass.getAnnotation(Table.class);
            this.tableName = table.schema().isEmpty() ? "" : table.schema() + "_";
            this.tableName = this.tableName + table.name();
            if (table.cacheSize() >= 0) {
                this.maxCacheSize = table.cacheSize();
            }
        }
        if (this.maxCacheSize > 0) {
            this.hashEntityObj = new LinkedHashMap(this.maxCacheSize, 0.75f, true){

                protected boolean removeEldestEntry(Map.Entry entry) {
                    return this.size() > EntityTable.this.maxCacheSize;
                }
            };
        }
        try {
            this.ctTable = new CTTable(cTDatabase);
            this.ctTable.Open(this.tableName, 0);
            this.ctRecPool = new EntityRecordPool(this.ctTable);
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't open table " + this.tableName + " in JTDB");
        }
        this.alreadyInstrumented = this.checkInstrumented();
        this.mapFields(false);
        this.loadIndexes(clazz);
        this.loadNamedQueries(clazz);
    }

    public void remove(Object object) {
        try {
            CTRecord cTRecord = this.ctRecPool.getRecord();
            if (this.goTo(object, cTRecord)) {
                Collection collection = this.hashRelationField.values();
                for (EntityFK entityFK : collection) {
                    entityFK.remove(object);
                }
                cTRecord.Delete();
            }
            this.ctRecPool.releaseRecord(cTRecord);
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't delete record in database");
        }
        catch (Exception exception) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, exception);
            throw new RuntimeException("Couldn't delete record in database");
        }
    }

    public void persist(Object object, int n) {
        this.persisting = true;
        try {
            CTRecord cTRecord = this.ctRecPool.getRecord();
            this.initInstrumentObj(object);
            cTRecord.Lock(3);
            if (!this.goTo(object, cTRecord)) {
                cTRecord.Clear();
                this.newRec = true;
            }
            this.storeEntityObj(object, cTRecord, n);
            cTRecord.Write();
            if (n == 0) {
                cTRecord.UnlockRecord();
            }
            cTRecord.Lock(6);
            if (this.newRec) {
                this.getIdentValues(object, cTRecord);
            }
            this.ctRecPool.releaseRecord(cTRecord);
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't persist record in database");
        }
        catch (Exception exception) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, exception);
            throw new RuntimeException("Couldn't persist record in database");
        }
        this.persisting = false;
    }

    public Object getResultList(String string, int n, String string2, CTRecord cTRecord, int n2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            CTRecord cTRecord2 = cTRecord != null ? cTRecord : this.ctRecPool.getRecord();
            boolean bl = false;
            if (n2 != 0) {
                cTRecord2.Lock(n2);
                bl = true;
            }
            if (!string.isEmpty()) {
                this.setIndex(this.getIndexByName(string), cTRecord2);
            }
            if (!string2.isEmpty()) {
                this.setFilter(string2, cTRecord2);
            }
            if (n == 1) {
                if (cTRecord2.First()) {
                    return this.createEntityObj(cTRecord2, n2);
                }
                return null;
            }
            boolean bl2 = cTRecord2.First();
            while (bl2) {
                arrayList.add(this.createEntityObj(cTRecord2, n2));
                bl2 = cTRecord2.Next();
            }
            if (bl) {
                cTRecord2.Lock(6);
            }
            if (!string.isEmpty()) {
                cTRecord2.SetDefaultIndex(this.primaryKey.getCtPKIdx().GetNumber());
            }
            this.ctRecPool.releaseRecord(cTRecord2);
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't retrieve result set from table in JTDB");
        }
        catch (Exception exception) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, exception);
            throw new RuntimeException("Couldn't retrieve result set from table in JTDB");
        }
        return arrayList;
    }

    public Object getResultList(String string, int n) {
        return this.getResultList(string, 0, "", null, n);
    }

    public Object getResultList(int n, CTRecord cTRecord, int n2) {
        return this.getResultList("", n, "", cTRecord, n2);
    }

    public Object getResultList(int n) {
        return this.getResultList("", 0, "", null, n);
    }

    public void clearResultList() {
        this.hashEntityObj.clear();
    }

    public CTTable getCTTable() {
        return this.ctTable;
    }

    public EntityIndex getIndexByName(String string) {
        if (!this.hashEntityIndex.containsKey(string = this.checkEntityName(string))) {
            throw new RuntimeException("Couldn't find index named: " + string);
        }
        return (EntityIndex)this.hashEntityIndex.get(string);
    }

    public EntityNamedQuery getNamedQuery(String string) {
        if (!this.hashNamedQuery.containsKey(string = this.checkEntityName(string))) {
            throw new RuntimeException("Couldn't find namedQuery named: " + string);
        }
        return (EntityNamedQuery)this.hashNamedQuery.get(string);
    }

    EntityQuery getQuery(String string, String string2) {
        return new EntityQuery(this, string, string2, this.entityTableMgr);
    }

    public Object getByPK(Object object, int n) {
        try {
            CTRecord cTRecord = this.ctRecPool.getRecord();
            boolean bl = false;
            if (n != 0) {
                cTRecord.Lock(n);
                bl = true;
            }
            Object object2 = this.goToPK(object, cTRecord) ? this.createEntityObj(cTRecord, n, object) : null;
            if (bl) {
                cTRecord.Lock(6);
            }
            this.ctRecPool.releaseRecord(cTRecord);
            return object2;
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't find record by Primary Key.", cTException);
        }
        catch (Exception exception) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, exception);
            throw new RuntimeException("Couldn't find record by Primary Key.");
        }
    }

    public CTIndex getIndexByColumns(Collection collection) {
        try {
            block2: for (int i = 0; i < this.ctTable.GetIndexCount(); ++i) {
                CTIndex cTIndex = this.ctTable.GetIndex(i);
                if (cTIndex.GetDuplicateFlag()) continue;
                int n = cTIndex.GetSegmentCount();
                if (collection.size() != n) continue;
                for (int j = 0; j < n; ++j) {
                    boolean bl = false;
                    for (int k = 0; k < collection.size(); ++k) {
                        EntityColumn entityColumn = (EntityColumn)collection.toArray()[k];
                        if (!cTIndex.GetSegment(j).GetFieldName().equals(entityColumn.getColName())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue block2;
                    if (j != n - 1) continue;
                    return cTIndex;
                }
            }
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't find primary key index in table " + this.tableName + " in JTDB", cTException);
        }
        return null;
    }

    public Object getFieldValue(EntityColumn entityColumn, CTRecord cTRecord) {
        try {
            CTField cTField = entityColumn.getCTField();
            if (cTRecord.IsNew() || cTRecord.IsNullField(cTField.GetNumber())) {
                return null;
            }
            switch (cTField.GetType()) {
                case 128: 
                case 170: {
                    return cTRecord.GetFieldAsBytes(cTField.GetNumber());
                }
                case 231: {
                    return cTRecord.GetFieldAsLong(cTField.GetNumber());
                }
                case 8: {
                    return cTRecord.GetFieldAsBoolean(cTField.GetNumber());
                }
                case 16: 
                case 24: 
                case 144: 
                case 146: 
                case 152: 
                case 154: 
                case 160: 
                case 162: 
                case 168: 
                case 177: 
                case 185: 
                case 193: 
                case 201: {
                    return cTRecord.GetFieldAsString(cTField.GetNumber());
                }
                case 67: 
                case 91: 
                case 103: 
                case 119: 
                case 143: {
                    if (entityColumn.getGetter().getReturnType() == Double.class) {
                        return cTRecord.GetFieldAsDouble(cTField.GetNumber());
                    }
                    return cTRecord.GetFieldAsFloat(cTField.GetNumber());
                }
                case 105: {
                    return cTRecord.GetFieldAsBigDecimal(cTField.GetNumber());
                }
                case 75: 
                case 83: 
                case 124: {
                    return cTRecord.GetFieldAsCalendar(cTField.GetNumber());
                }
                case 33: 
                case 41: 
                case 51: 
                case 59: 
                case 239: {
                    return cTRecord.GetFieldAsInt(cTField.GetNumber());
                }
            }
            throw new UnsupportedOperationException("Ctree type not supported in the JTPL. Type: " + cTField.GetType() + " - field: " + cTField.GetName());
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't get field value. Field: " + entityColumn.getColName(), cTException);
        }
    }

    public void setFieldValue(Object object, EntityColumn entityColumn, CTRecord cTRecord) {
        this.setFieldValueObj(entityColumn.getValue(object), entityColumn, cTRecord);
    }

    public void setFieldValueObj(Object object, EntityColumn entityColumn, CTRecord cTRecord) {
        try {
            CTField cTField = entityColumn.getCTField();
            if (object == null) {
                cTRecord.ClearField(cTField.GetNumber());
                return;
            }
            switch (cTField.GetType()) {
                case 128: 
                case 170: {
                    cTRecord.SetFieldAsBytes(cTField.GetNumber(), (byte[])object);
                    break;
                }
                case 231: {
                    cTRecord.SetFieldAsLong(cTField.GetNumber(), (Long)object);
                    break;
                }
                case 8: {
                    cTRecord.SetFieldAsBoolean(cTField.GetNumber(), (Boolean)object);
                    break;
                }
                case 16: 
                case 24: 
                case 144: 
                case 146: 
                case 152: 
                case 154: 
                case 160: 
                case 162: 
                case 168: 
                case 177: 
                case 185: 
                case 193: 
                case 201: {
                    cTRecord.SetFieldAsString(cTField.GetNumber(), object.toString());
                    break;
                }
                case 67: 
                case 91: 
                case 103: 
                case 119: 
                case 143: {
                    if (object.getClass() == Double.class) {
                        cTRecord.SetFieldAsDouble(cTField.GetNumber(), (Double)object);
                        break;
                    }
                    cTRecord.SetFieldAsFloat(cTField.GetNumber(), (Float)object);
                    break;
                }
                case 105: {
                    cTRecord.SetFieldAsBigDecimal(cTField.GetNumber(), (BigDecimal)object);
                    break;
                }
                case 75: 
                case 83: 
                case 124: {
                    cTRecord.SetFieldAsCalendar(cTField.GetNumber(), (Calendar)object);
                    break;
                }
                case 33: 
                case 41: 
                case 51: 
                case 59: 
                case 239: {
                    cTRecord.SetFieldAsInt(cTField.GetNumber(), (Integer)object);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Ctree type not supported in the JTPL. Type: " + cTField.GetType() + " - field: " + cTField.GetName());
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
            throw new RuntimeException("Couldn't set field value. Field: " + entityColumn.getColName(), illegalArgumentException);
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't set field value. Field: " + entityColumn.getColName(), cTException);
        }
    }

    public EntityTableManager getTableManager() {
        return this.entityTableMgr;
    }

    public void checkFK() {
        this.mapFields(true);
    }

    public String getTableName() {
        return this.tableName;
    }

    public Field[] getPKFieldList() {
        return this.primaryKey.getPKFieldList();
    }

    public Class getPKClass() {
        return this.primaryKey.getPKClass();
    }

    public HashMap getFKEntColList(String string) throws EntityException {
        EntityFK entityFK = this.getFKByName(string);
        return entityFK.getHashEntityField();
    }

    public Class getFKFieldType(String string) throws EntityException {
        EntityFK entityFK = this.getFKByName(string);
        return entityFK.getFieldType();
    }

    public Class getEntClass() {
        return this.entClass;
    }

    public void processPendingFK() {
        ArrayList arrayList = new ArrayList(this.pendingField);
        for (Field field : arrayList) {
            this.setFK(field);
            this.pendingField.remove(field);
        }
    }

    public CTRecord getCTRecord() throws Exception {
        return this.ctRecPool.getRecord();
    }

    private void setIndex(EntityIndex entityIndex, CTRecord cTRecord) {
        try {
            cTRecord.SetDefaultIndex(entityIndex.getIndex().GetName());
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't set index. Index name: " + entityIndex.getIndex().GetName(), cTException);
        }
    }

    private void setFilter(String string, CTRecord cTRecord) {
        try {
            cTRecord.SetFilter(string);
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't set record filter. Expression: " + string, cTException);
        }
    }

    private void setFK(Field field) {
        EntityFK entityFK;
        try {
            entityFK = new EntityFK(this.entClass, field, this);
            if (entityFK.getFetchMode() == FetchMode.LAZY) {
                this.setLazyGetter(this.entClass, field, entityFK.getGetter());
            }
        }
        catch (EntityException entityException) {
            if (entityException.GetErrorCode().equals(EntityError.FKMIS)) {
                this.addPendingField(field);
                this.entityTableMgr.setPeding();
                return;
            }
            throw new RuntimeException("Couldn't set Foreign Key field for " + field.getName(), entityException);
        }
        if (this.hashRelationField.get(field.getName()) == null) {
            this.hashRelationField.put(field.getName(), entityFK);
        }
    }

    public boolean isPKComposite() {
        return this.primaryKey.isComposite();
    }

    public boolean isFieldPK(Field field) {
        return this.primaryKey.hasField(field);
    }

    public void addPendingField(Field field) {
        this.pendingField.add(field);
    }

    public void Fetch(String string, Object object) {
        if (this.persisting) {
            return;
        }
        try {
            CTRecord cTRecord = this.ctRecPool.getRecord();
            if (this.goTo(object, cTRecord)) {
                EntityColumn entityColumn = (EntityColumn)this.hashEntityField.get(string);
                if (entityColumn != null) {
                    Object object2 = this.getFieldValue(entityColumn, cTRecord);
                    entityColumn.setValue(object, object2);
                } else {
                    EntityFK entityFK = (EntityFK)this.hashRelationField.get(string);
                    if (entityFK != null) {
                        entityFK.getValue(object, cTRecord, true, 0);
                    } else {
                        throw new RuntimeException("Couldn't find field: " + string + " in entity class " + this.entClass.getName() + " to be fetched");
                    }
                }
            }
            this.ctRecPool.releaseRecord(cTRecord);
        }
        catch (Exception exception) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, exception);
            throw new RuntimeException("Couldn't reposition record for fetching");
        }
    }

    public void lockByPk(Object object, int n) {
        this.getByPK(object, n);
    }

    public void lock(Object object, int n) {
        try {
            CTRecord cTRecord = this.ctRecPool.getRecord();
            if (this.goTo(object, cTRecord) && n != 0) {
                cTRecord.Lock(n);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    public void unlockByPk(Object object) {
        try {
            CTRecord cTRecord = this.ctRecPool.getRecord();
            if (this.goToPK(object, cTRecord)) {
                cTRecord.UnlockRecord();
            }
            this.ctRecPool.releaseRecord(cTRecord);
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't find record by Primary Key.", cTException);
        }
        catch (Exception exception) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, exception);
            throw new RuntimeException("Couldn't delete record in database");
        }
    }

    public void unlock(Object object) {
        try {
            CTRecord cTRecord = this.ctRecPool.getRecord();
            if (this.goTo(object, cTRecord)) {
                cTRecord.UnlockRecord();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, exception);
            throw new RuntimeException("Couldn't unlock record by entity");
        }
    }

    void unlockAll() {
        try {
            this.ctTable.UnlockTable();
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't unlock all records from the table: " + this.tableName);
        }
    }

    private void mapFields(boolean bl) {
        Field[] fieldArray = this.entClass.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (fieldArray[i].isAnnotationPresent(Transient.class)) continue;
            this.mapField(fieldArray[i], bl);
        }
    }

    private void mapField(Field field, boolean bl) {
        if (field.isAnnotationPresent(ID.class)) {
            if (!bl) {
                this.setPK(field);
            } else {
                this.primaryKey.checkFK(field);
            }
        } else if (field.isAnnotationPresent(OneToOne.class) || field.isAnnotationPresent(OneToMany.class) || field.isAnnotationPresent(ManyToOne.class) || field.isAnnotationPresent(ManyToMany.class)) {
            if (bl) {
                this.setFK(field);
            }
        } else if (!bl) {
            EntityColumn entityColumn = new EntityColumn(this.entClass, field, this);
            this.hashEntityField.put(field.getName(), entityColumn);
            if (entityColumn.getFetchMode() == FetchMode.LAZY) {
                this.setLazyGetter(this.entClass, field, entityColumn.getGetter());
            }
        }
    }

    private void setPK(Field field) {
        if (this.primaryKey != null) {
            throw new RuntimeException("Entity table can have only one ID field.");
        }
        this.primaryKey = new EntityPK(this.entClass, field, this);
    }

    private boolean goTo(Object object, CTRecord cTRecord) throws CTException {
        cTRecord.Clear();
        this.primaryKey.setValue(object, cTRecord, 0);
        boolean bl = false;
        boolean bl2 = true;
        while (bl2) {
            try {
                bl = cTRecord.Find(0);
                bl2 = false;
            }
            catch (CTException cTException) {
                if (cTException.GetErrorCode() == 42L) {
                    bl2 = true;
                    continue;
                }
                bl2 = false;
            }
        }
        return bl;
    }

    private Object createEntityObj(CTRecord cTRecord, int n, Object object) {
        Object object2;
        Object[] objectArray = null;
        try {
            if (object == null) {
                object = this.primaryKey.getValue(cTRecord, n);
            }
            if (n == 0 && this.maxCacheSize > 0 && (object2 = this.hashEntityObj.get(object)) != null) {
                return object2;
            }
            object2 = this.getEntDefConstrutor().newInstance(objectArray);
            this.initInstrumentObj(object2);
            this.primaryKey.storeValue(object2, object);
            Collection collection = this.hashEntityField.values();
            for (EntityColumn entityColumn : collection) {
                if (entityColumn.getFetchMode() == FetchMode.LAZY) continue;
                Object object3 = this.getFieldValue(entityColumn, cTRecord);
                entityColumn.setValue(object2, object3);
            }
            if (n == 0 && this.maxCacheSize > 0) {
                this.hashEntityObj.put(object, object2);
            }
            Collection collection2 = this.hashRelationField.values();
            for (EntityFK entityFK : collection2) {
                if (entityFK.getFetchMode() == FetchMode.LAZY) continue;
                entityFK.getValue(object2, cTRecord, n);
            }
        }
        catch (InstantiationException instantiationException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, instantiationException);
            throw new RuntimeException("Couldn't create instance for entity class: " + this.entClass.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            throw new RuntimeException("Couldn't create instance for entity class: " + this.entClass.getName(), illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
            throw new RuntimeException("Couldn't create instance for entity class: " + this.entClass.getName(), illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, invocationTargetException);
            throw new RuntimeException("Couldn't create instance for entity class: " + this.entClass.getName(), invocationTargetException);
        }
        return object2;
    }

    private Object createEntityObj(CTRecord cTRecord, int n) {
        return this.createEntityObj(cTRecord, n, null);
    }

    private void storeEntityObj(Object object, CTRecord cTRecord, int n) {
        if (this.newRec) {
            this.primaryKey.setValue(object, cTRecord, n);
        }
        Collection collection = this.hashEntityField.values();
        for (EntityColumn entityColumn : collection) {
            this.setFieldValue(object, entityColumn, cTRecord);
        }
        Collection collection2 = this.hashRelationField.values();
        for (EntityFK entityFK : collection2) {
            if (entityFK.getFetchMode() == FetchMode.LAZY) continue;
            entityFK.setValue(object, cTRecord, n);
        }
    }

    private Constructor getEntDefConstrutor() {
        if (this.entDefConstructor != null) {
            return this.entDefConstructor;
        }
        Class<?>[] classArray = null;
        try {
            this.entDefConstructor = this.entClass.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, noSuchMethodException);
            throw new RuntimeException("Couldn't retrieve default constructor for class: " + this.entClass.getName(), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, securityException);
            throw new RuntimeException("Couldn't retrieve default constructor for class: " + this.entClass.getName(), securityException);
        }
        return this.entDefConstructor;
    }

    private void loadIndexes(Class clazz) {
        if (clazz.isAnnotationPresent(Indexes.class)) {
            Indexes indexes = clazz.getAnnotation(Indexes.class);
            Index[] indexArray = indexes.value();
            for (int i = 0; i < indexArray.length; ++i) {
                this.mapIndex(indexArray[i]);
            }
        }
    }

    private void mapIndex(Index index) {
        EntityIndex entityIndex = new EntityIndex(this, index.indexName());
        this.hashEntityIndex.put(this.checkEntityName(index.name()), entityIndex);
    }

    private void loadNamedQueries(Class clazz) {
        if (clazz.isAnnotationPresent(NamedQueries.class)) {
            NamedQueries namedQueries = clazz.getAnnotation(NamedQueries.class);
            NamedQuery[] namedQueryArray = namedQueries.value();
            for (int i = 0; i < namedQueryArray.length; ++i) {
                this.mapNameQuery(namedQueryArray[i]);
            }
        }
    }

    private void mapNameQuery(NamedQuery namedQuery) {
        EntityNamedQuery entityNamedQuery = new EntityNamedQuery(this, namedQuery, this.entityTableMgr);
        this.hashNamedQuery.put(this.checkEntityName(namedQuery.name()), entityNamedQuery);
    }

    private String checkEntityName(String string) {
        if (!string.startsWith(this.entityName + ".")) {
            throw new RuntimeException("Invalid object name: " + string + ". It should start with the Entity class name: " + this.entityName);
        }
        return string.substring(this.entityName.length() + 1);
    }

    private String getEntityShortName(String string) {
        return string.substring(string.lastIndexOf(".") + 1);
    }

    private boolean goToPK(Object object, CTRecord cTRecord) throws CTException {
        boolean bl;
        cTRecord.Clear();
        this.primaryKey.setPKValue(object, cTRecord, 0);
        try {
            bl = cTRecord.Find(0);
        }
        catch (CTException cTException) {
            if (cTException.GetErrorCode() == 739L) {
                CTResultSet cTResultSet = cTRecord.GetActiveResultSet();
                if (cTResultSet != null) {
                    cTResultSet.SetOnOff(cTRecord, false, true, 0);
                    bl = cTRecord.Find(0);
                    cTResultSet.SetOnOff(cTRecord, true, true, 0);
                }
                throw cTException;
            }
            throw cTException;
        }
        return bl;
    }

    private EntityFK getFKByName(String string) throws EntityException {
        Collection collection = this.hashRelationField.values();
        for (EntityFK entityFK : collection) {
            if (!entityFK.getFieldName().equals(string)) continue;
            return entityFK;
        }
        collection = this.primaryKey.getFKList();
        for (EntityFK entityFK : collection) {
            if (!entityFK.getFieldName().equals(string)) continue;
            return entityFK;
        }
        throw new EntityException(EntityError.FKMIS, "Field name " + string + "still not loaded for entity " + this.entityName);
    }

    private void setLazyGetter(Class clazz, Field field, Method method) {
        FieldInfo fieldInfo;
        ClassLoader classLoader;
        CtClass ctClass;
        ClassPool classPool;
        block21: {
            this.lazilyFetch = true;
            if (this.alreadyInstrumented) {
                return;
            }
            classPool = ClassPool.getDefault();
            ctClass = null;
            try {
                ctClass = classPool.get(clazz.getName());
            }
            catch (NotFoundException notFoundException) {
                try {
                    classLoader = this.entityTableMgr.getSecClassLoader();
                    if (classLoader == null) break block21;
                    try {
                        fieldInfo = classLoader.loadClass(clazz.getName());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, classNotFoundException);
                        throw new RuntimeException("Couldn't load entity class: " + clazz.getName() + " from the class pool for lazy fetch instrumentation.");
                    }
                    classPool.insertClassPath((ClassPath)new ClassClassPath(fieldInfo));
                    ctClass = classPool.get(clazz.getName());
                }
                catch (NotFoundException notFoundException2) {
                    Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, notFoundException2);
                    throw new RuntimeException("Couldn't append classpath for entity class: " + clazz.getName() + " from the class pool for lazy fetch instrumentation.");
                }
            }
        }
        try {
            CtField ctField = ctClass.getDeclaredField("_entTableObj");
        }
        catch (NotFoundException notFoundException) {
            try {
                CtField ctField = new CtField(classPool.get(this.getClass().getName()), "_entTableObj", ctClass);
                ctField.setModifiers(1);
                fieldInfo = ctField.getFieldInfo();
                AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations");
                if (annotationsAttribute == null) {
                    annotationsAttribute = new AnnotationsAttribute(fieldInfo.getConstPool(), "RuntimeVisibleAnnotations");
                }
                ClassFile classFile = ctClass.getClassFile();
                Annotation annotation = new Annotation(Transient.class.getName(), classFile.getConstPool());
                annotationsAttribute.addAnnotation(annotation);
                fieldInfo.addAttribute((AttributeInfo)annotationsAttribute);
                ctClass.addField(ctField);
            }
            catch (NotFoundException notFoundException3) {
                Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, notFoundException3);
                throw new RuntimeException("Couldn't load EntityTable class: " + clazz.getName() + " from the class pool.");
            }
            catch (CannotCompileException cannotCompileException) {
                Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, cannotCompileException);
                throw new RuntimeException("Couldn't add field _entTableObj in the class " + clazz.getName() + " for lazy fetch instrumentation.");
            }
        }
        try {
            classLoader = ctClass.getDeclaredMethod(method.getName());
        }
        catch (NotFoundException notFoundException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, notFoundException);
            throw new RuntimeException("Couldn't find getter method: " + method.getName() + " in EntityTable class: " + clazz.getName() + " for lazy fetch instrumentation.");
        }
        try {
            classLoader.insertBefore("_entTableObj.Fetch(\"" + field.getName() + "\", this);");
        }
        catch (CannotCompileException cannotCompileException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, cannotCompileException);
            throw new RuntimeException("Couldn't add fetch call in the getter method: " + method.getName() + " in EntityTable class: " + clazz.getName() + " for lazy fetch instrumentation.");
        }
        try {
            ctClass.writeFile();
            this.entClass = ctClass.toClass();
        }
        catch (NotFoundException notFoundException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, notFoundException);
            throw new RuntimeException("Couldn't save instrumentation in class: " + clazz.getName() + " for lazy fetch. In order to use the " + "lazy fetch feature, you must start your application with the " + "following agent: -javaagent:FairComCtreeDB_PL.jar. Otherwise " + "you must provide a customized class loader that allows class " + "realoding.");
        }
        catch (IOException iOException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, iOException);
            throw new RuntimeException("Couldn't save instrumentation in class: " + clazz.getName() + " for lazy fetch. In order to use the " + "lazy fetch feature, you must start your application with the " + "following agent: -javaagent:FairComCtreeDB_PL.jar. Otherwise " + "you must provide a customized class loader that allows class " + "realoding.");
        }
        catch (CannotCompileException cannotCompileException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, cannotCompileException);
            throw new RuntimeException("Couldn't save instrumentation in class: " + clazz.getName() + " for lazy fetch. In order to use the " + "lazy fetch feature, you must start your application with the " + "following agent: -javaagent:FairComCtreeDB_PL.jar. Otherwise " + "you must provide a customized class loader that allows class " + "realoding.");
        }
    }

    private boolean checkInstrumented() {
        try {
            if (this.entClass.getDeclaredField("_entTableObj") != null) {
                this.lazilyFetch = true;
                return true;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, securityException);
            throw new RuntimeException("Couldn't check if the class: " + this.entClass.getName() + " has already been instrumented.");
        }
        return false;
    }

    private void initInstrumentObj(Object object) {
        if (!this.instrumented) {
            this.instrumented = true;
            if (this.lazilyFetch) {
                try {
                    Field field = this.entClass.getDeclaredField("_entTableObj");
                    if (field.get(object) == null) {
                        field.set(object, this);
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, noSuchFieldException);
                    throw new RuntimeException("Couldn't find internal field: _entTableObj in class " + this.entClass.getName(), noSuchFieldException);
                }
                catch (SecurityException securityException) {
                    Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, securityException);
                    throw new RuntimeException("Not enough permission for modifying internal field: _entTableObj in class " + this.entClass.getName(), securityException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
                    throw new RuntimeException("Couldn't initialize the entity object for the instrumented entity object. Property: _entTableObj in class " + this.entClass.getName(), illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger(EntityTable.class.getName()).log(Level.SEVERE, null, illegalAccessException);
                    throw new RuntimeException("Couldn't initialize the entity object for the instrumented entity object. Property: _entTableObj in class " + this.entClass.getName(), illegalAccessException);
                }
            }
        }
    }

    ClassLoader getSecClassLoader() {
        return this.entityTableMgr.getSecClassLoader();
    }

    Object getPKValue(Object object) {
        return this.primaryKey.getValue(object);
    }

    private void getIdentValues(Object object, CTRecord cTRecord) throws CTException {
        if (!this.hashEntityField.isEmpty()) {
            cTRecord.Read();
            this.primaryKey.getIdentValues(object, cTRecord);
            Collection collection = this.hashEntityField.values();
            for (EntityColumn entityColumn : collection) {
                if (!entityColumn.isIdentity()) continue;
                entityColumn.setValue(object, this.getFieldValue(entityColumn, cTRecord));
            }
        }
    }
}

