/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Persistence;

import FairCom.CtreeDb.CTDatabase;
import FairCom.CtreeDb.CTException;
import FairCom.Persistence.Annotations.Entity;
import FairCom.Persistence.EntityNamedQuery;
import FairCom.Persistence.EntityQuery;
import FairCom.Persistence.EntityTable;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class EntityTableManager {
    private CTDatabase ctDB;
    private HashMap hashEntityTable = new HashMap();
    private boolean dirty = false;
    private boolean peding = false;
    private ClassLoader secClassLoader;
    private int maxDefCacheSize;

    EntityTableManager(CTDatabase cTDatabase, ClassLoader classLoader, int n) {
        this.ctDB = cTDatabase;
        this.secClassLoader = classLoader;
        this.maxDefCacheSize = n;
    }

    public void remove(Object object) {
        this.checkEntity(object.getClass());
        EntityTable entityTable = this.getEntity(object.getClass());
        entityTable.remove(object);
    }

    void persist(Object object, int n) {
        this.checkEntity(object.getClass());
        EntityTable entityTable = this.getEntity(object.getClass());
        entityTable.persist(object, n);
    }

    public Object getResultList(String string, String string2, int n) throws ClassNotFoundException {
        EntityTable entityTable = this.getEntity(string);
        this.cleanEntity();
        return entityTable.getResultList(string2, n);
    }

    public EntityNamedQuery getNamedQuery(String string, String string2) throws ClassNotFoundException {
        EntityTable entityTable = this.getEntity(string);
        return entityTable.getNamedQuery(string2);
    }

    public EntityQuery getQuery(String string, String string2, String string3) throws ClassNotFoundException {
        EntityTable entityTable = this.getEntity(string);
        return entityTable.getQuery(string2, string3);
    }

    public Object getByPK(String string, Object object, int n) throws ClassNotFoundException {
        EntityTable entityTable = this.getEntity(string);
        return entityTable.getByPK(object, n);
    }

    public EntityTable getEntity(Class clazz) {
        EntityTable entityTable = this.getEntityTable(clazz);
        if (this.dirty) {
            this.processPendingFK();
            this.dirty = false;
        }
        return entityTable;
    }

    public EntityTable getEntityTable(Class clazz) {
        if (this.hashEntityTable.containsKey(clazz)) {
            return (EntityTable)this.hashEntityTable.get(clazz);
        }
        EntityTable entityTable = new EntityTable(this.ctDB, clazz, this);
        this.hashEntityTable.put(clazz, entityTable);
        entityTable.checkFK();
        this.dirty = true;
        return entityTable;
    }

    public void cleanEntity() {
        Collection collection = this.hashEntityTable.values();
        for (EntityTable entityTable : collection) {
            entityTable.clearResultList();
        }
    }

    public void setPeding() {
        this.peding = true;
    }

    private void checkEntity(Class clazz) {
        if (!clazz.isAnnotationPresent(Entity.class)) {
            throw new RuntimeException("Class " + clazz.getName() + " is not a Entity class");
        }
    }

    private void processPendingFK() {
        int n;
        for (n = 10; this.peding && n > 0; --n) {
            this.peding = false;
            Collection collection = this.hashEntityTable.values();
            for (EntityTable entityTable : collection) {
                entityTable.processPendingFK();
            }
        }
        if (n == 0) {
            throw new RuntimeException("Couldn't process all the pending Foreign Key");
        }
    }

    public void lock(String string, Object object, int n) throws ClassNotFoundException {
        EntityTable entityTable = this.getEntity(string);
        entityTable.lockByPk(object, n);
    }

    public void lock(Object object, int n) {
        this.checkEntity(object.getClass());
        EntityTable entityTable = this.getEntity(object.getClass());
        entityTable.lock(object, n);
    }

    public void unlock(String string, Object object) throws ClassNotFoundException {
        EntityTable entityTable = this.getEntity(string);
        entityTable.unlockByPk(object);
    }

    public void unlock(Object object) {
        this.checkEntity(object.getClass());
        EntityTable entityTable = this.getEntity(object.getClass());
        entityTable.unlock(object);
    }

    void unlockAll(String string) throws ClassNotFoundException {
        EntityTable entityTable = this.getEntity(string);
        entityTable.unlockAll();
    }

    void unlockAll() {
        try {
            this.ctDB.Unlock();
        }
        catch (CTException cTException) {
            Logger.getLogger(EntityTableManager.class.getName()).log(Level.SEVERE, null, cTException);
            throw new RuntimeException("Couldn't unlock all the locks for the current entity manager", cTException);
        }
    }

    private EntityTable getEntity(String string) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.secClassLoader != null) {
                clazz = this.secClassLoader.loadClass(string);
            }
            throw classNotFoundException;
        }
        this.checkEntity(clazz);
        return this.getEntity(clazz);
    }

    ClassLoader getSecClassLoader() {
        return this.secClassLoader;
    }

    int getDefMaxCache() {
        return this.maxDefCacheSize;
    }
}

