/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Persistence;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class PersistenceConfig {
    private static final String SERVER_NAME = "ServerName";
    private static final String SERVER_ADDRESS = "ServerAddress";
    private static final String DATABASE = "Database";
    private static final String USER = "User";
    private static final String PASSWORD = "Password";
    private static final String TRANSACTION_TYPE = "TransactionType";
    private static final String CONN_TYPE = "SessionType";
    private static final String MAX_DEF_CACHE_SIZE = "MaxDefCacheSize";
    private String serverName;
    private String serverAddress;
    private String database;
    private String user;
    private String password;
    private int transactionType;
    private int sessionType;
    private ClassLoader classLoader;
    private int maxDefCacheSize;
    private Collection classList = new ArrayList();

    PersistenceConfig(File file, String string, Map map, ClassLoader classLoader) {
        if (file == null) {
            throw new MissingResourceException("Couldn't load persistence configuration", "PersistenceConfig", file.getName());
        }
        this.loadXML(file, string);
        this.classLoader = classLoader;
        this.override(map);
    }

    private void loadXML(File file, String string) {
        this.serverName = "FAIRCOMS";
        this.serverAddress = "localhost";
        this.database = "ctreeSQL";
        this.user = "ADMIN";
        this.password = "ADMIN";
        this.transactionType = 0;
        this.sessionType = 2;
        this.maxDefCacheSize = 100;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getLogger(PersistenceConfig.class.getName()).log(Level.SEVERE, null, parserConfigurationException);
        }
        Document document = null;
        try {
            document = documentBuilder.parse(file);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(PersistenceConfig.class.getName()).log(Level.SEVERE, null, sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger(PersistenceConfig.class.getName()).log(Level.SEVERE, null, iOException);
        }
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("persistence-unit");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            Element element = (Element)node2;
            if ((string == null && !string.isEmpty() || !element.getAttribute("name").isEmpty()) && !element.getAttribute("name").equals(string)) continue;
            NodeList nodeList2 = element.getElementsByTagName("class");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node3 = nodeList2.item(j);
                if (node3.getNodeType() != 1) continue;
                node = (Element)node3;
                object = node.getChildNodes();
                this.classList.add(object.item(0).getNodeValue());
            }
            NodeList nodeList3 = ((Element)element.getElementsByTagName("properties").item(0)).getElementsByTagName("property");
            for (int j = 0; j < nodeList3.getLength(); ++j) {
                node = nodeList3.item(j);
                if (node.getNodeType() != 1) continue;
                object = (Element)node;
                if (object.getAttribute("name").equals(SERVER_NAME)) {
                    this.serverName = object.getAttribute("value");
                    continue;
                }
                if (object.getAttribute("name").equals(SERVER_ADDRESS)) {
                    this.serverAddress = object.getAttribute("value");
                    continue;
                }
                if (object.getAttribute("name").equals(DATABASE)) {
                    this.database = object.getAttribute("value");
                    continue;
                }
                if (object.getAttribute("name").equals(USER)) {
                    this.user = object.getAttribute("value");
                    continue;
                }
                if (object.getAttribute("name").equals(PASSWORD)) {
                    this.password = object.getAttribute("value");
                    continue;
                }
                if (object.getAttribute("name").equals(TRANSACTION_TYPE)) {
                    this.transactionType = Integer.parseInt(object.getAttribute("value"));
                    continue;
                }
                if (object.getAttribute("name").equals(CONN_TYPE)) {
                    this.sessionType = Integer.parseInt(object.getAttribute("value"));
                    continue;
                }
                if (object.getAttribute("name").equals(MAX_DEF_CACHE_SIZE)) {
                    this.maxDefCacheSize = Integer.parseInt(object.getAttribute("value"));
                    continue;
                }
                throw new UnsupportedOperationException("Property [" + object.getAttribute("name") + "] not yet implemented");
            }
        }
    }

    private void override(Map map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        map = map instanceof HashMap ? (Map)((HashMap)map).clone() : (map instanceof Properties ? (Map)((Properties)map).clone() : new LinkedHashMap(map));
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            if (string.equals(SERVER_NAME)) {
                this.serverName = (String)entry.getValue();
                continue;
            }
            if (string.equals(SERVER_ADDRESS)) {
                this.serverAddress = (String)entry.getValue();
                continue;
            }
            if (string.equals(DATABASE)) {
                this.database = (String)entry.getValue();
                continue;
            }
            if (string.equals(USER)) {
                this.user = (String)entry.getValue();
                continue;
            }
            if (string.equals(PASSWORD)) {
                this.password = (String)entry.getValue();
                continue;
            }
            if (string.equals(TRANSACTION_TYPE)) {
                this.transactionType = Integer.parseInt((String)entry.getValue());
                continue;
            }
            if (string.equals(CONN_TYPE)) {
                this.sessionType = Integer.parseInt((String)entry.getValue());
                continue;
            }
            if (string.equals(MAX_DEF_CACHE_SIZE)) {
                this.maxDefCacheSize = Integer.parseInt((String)entry.getValue());
                continue;
            }
            throw new UnsupportedOperationException("Property [" + string + "] not yet implemented");
        }
    }

    public String getDatabase() {
        return this.database;
    }

    public String getPassword() {
        return this.password;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getTransactionType() {
        return this.transactionType;
    }

    public String getUser() {
        return this.user;
    }

    public void setDatabase(String string) {
        this.database = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setServerAddress(String string) {
        this.serverAddress = string;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setTransactionType(int n) {
        this.transactionType = n;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public Collection getClasses() {
        return this.classList;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setSessionType(int n) {
        this.sessionType = n;
    }

    int getSessionType() {
        return this.sessionType;
    }

    public void setDefMaxCacheSize(int n) {
        this.maxDefCacheSize = n;
    }

    int getDefMaxCacheSize() {
        return this.maxDefCacheSize;
    }
}

